/* tracker-query.c generated by valac 0.12.0, the Vala compiler
 * generated from tracker-query.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_QUERY, TrackerQueryClass))
#define TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_QUERY))
#define TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
typedef struct _TrackerQueryPrivate TrackerQueryPrivate;

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (tracker_query_unref (var), NULL)))
typedef struct _TrackerQueryGetCountAsyncData TrackerQueryGetCountAsyncData;
typedef struct _TrackerQueryPerformAsyncData TrackerQueryPerformAsyncData;
typedef struct _TrackerParamSpecQuery TrackerParamSpecQuery;

struct _TrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerQueryPrivate * priv;
};

struct _TrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerQuery *self);
};

struct _TrackerQueryPrivate {
	gchar** match_clauses;
	gint match_clauses_length1;
	gint _match_clauses_size_;
	gchar** where_clauses;
	gint where_clauses_length1;
	gint _where_clauses_size_;
	gchar* _criteria;
	guint _offset;
	guint _limit;
	gchar* _query;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT
} TrackerQueryMatch;

struct _TrackerQueryGetCountAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerQuery* self;
	TrackerQueryType query_type;
	TrackerQueryMatch match_type;
	GCancellable* cancellable;
	guint result;
	TrackerSparqlCursor* cursor;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* criteria_escaped;
	gchar* _tmp5_;
	gchar* match;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	GError * e;
	gint64 _tmp12_;
	GError * _inner_error_;
};

struct _TrackerQueryPerformAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerQuery* self;
	TrackerQueryType query_type;
	TrackerQueryMatch match_type;
	gchar** args;
	gint args_length1;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* cursor;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* criteria_escaped;
	gchar* _tmp5_;
	gchar* match;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	TrackerSparqlCursor* _tmp24_;
	TrackerSparqlCursor* _tmp25_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerParamSpecQuery {
	GParamSpec parent_instance;
};


static gpointer tracker_query_parent_class = NULL;
static TrackerSparqlConnection* tracker_query_connection;
static TrackerSparqlConnection* tracker_query_connection = NULL;

gpointer tracker_query_ref (gpointer instance);
void tracker_query_unref (gpointer instance);
GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_query (GValue* value, gpointer v_object);
void tracker_value_take_query (GValue* value, gpointer v_object);
gpointer tracker_value_get_query (const GValue* value);
GType tracker_query_get_type (void) G_GNUC_CONST;
#define TRACKER_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_QUERY, TrackerQueryPrivate))
enum  {
	TRACKER_QUERY_DUMMY_PROPERTY
};
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
static gboolean tracker_query_check_query_and_match_type (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type);
static void tracker_query_get_count_async_data_free (gpointer _data);
void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_query_get_count_async_co (TrackerQueryGetCountAsyncData* data);
const gchar* tracker_query_get_criteria (TrackerQuery* self);
static void tracker_query_set_query (TrackerQuery* self, const gchar* value);
const gchar* tracker_query_get_query (TrackerQuery* self);
static void tracker_query_get_count_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_query_perform_async_data_free (gpointer _data);
static gchar** _vala_array_dup2 (gchar** self, int length);
void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_query_perform_async_co (TrackerQueryPerformAsyncData* data);
guint tracker_query_get_limit (TrackerQuery* self);
guint tracker_query_get_offset (TrackerQuery* self);
static void tracker_query_perform_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_query_set_criteria (TrackerQuery* self, const gchar* value);
void tracker_query_set_offset (TrackerQuery* self, guint value);
void tracker_query_set_limit (TrackerQuery* self, guint value);
static void tracker_query_finalize (TrackerQuery* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType tracker_query_type_get_type (void) {
	static volatile gsize tracker_query_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_QUERY_TYPE_ALL, "TRACKER_QUERY_TYPE_ALL", "all"}, {TRACKER_QUERY_TYPE_CONTACTS, "TRACKER_QUERY_TYPE_CONTACTS", "contacts"}, {TRACKER_QUERY_TYPE_APPLICATIONS, "TRACKER_QUERY_TYPE_APPLICATIONS", "applications"}, {TRACKER_QUERY_TYPE_MUSIC, "TRACKER_QUERY_TYPE_MUSIC", "music"}, {TRACKER_QUERY_TYPE_IMAGES, "TRACKER_QUERY_TYPE_IMAGES", "images"}, {TRACKER_QUERY_TYPE_VIDEOS, "TRACKER_QUERY_TYPE_VIDEOS", "videos"}, {TRACKER_QUERY_TYPE_DOCUMENTS, "TRACKER_QUERY_TYPE_DOCUMENTS", "documents"}, {TRACKER_QUERY_TYPE_MAIL, "TRACKER_QUERY_TYPE_MAIL", "mail"}, {TRACKER_QUERY_TYPE_CALENDAR, "TRACKER_QUERY_TYPE_CALENDAR", "calendar"}, {TRACKER_QUERY_TYPE_FOLDERS, "TRACKER_QUERY_TYPE_FOLDERS", "folders"}, {0, NULL, NULL}};
		GType tracker_query_type_type_id;
		tracker_query_type_type_id = g_enum_register_static ("TrackerQueryType", values);
		g_once_init_leave (&tracker_query_type_type_id__volatile, tracker_query_type_type_id);
	}
	return tracker_query_type_type_id__volatile;
}


GType tracker_query_match_get_type (void) {
	static volatile gsize tracker_query_match_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_match_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_QUERY_MATCH_NONE, "TRACKER_QUERY_MATCH_NONE", "none"}, {TRACKER_QUERY_MATCH_FTS, "TRACKER_QUERY_MATCH_FTS", "fts"}, {TRACKER_QUERY_MATCH_FTS_INDIRECT, "TRACKER_QUERY_MATCH_FTS_INDIRECT", "fts-indirect"}, {TRACKER_QUERY_MATCH_TITLES, "TRACKER_QUERY_MATCH_TITLES", "titles"}, {TRACKER_QUERY_MATCH_TITLES_INDIRECT, "TRACKER_QUERY_MATCH_TITLES_INDIRECT", "titles-indirect"}, {0, NULL, NULL}};
		GType tracker_query_match_type_id;
		tracker_query_match_type_id = g_enum_register_static ("TrackerQueryMatch", values);
		g_once_init_leave (&tracker_query_match_type_id__volatile, tracker_query_match_type_id);
	}
	return tracker_query_match_type_id__volatile;
}


TrackerQuery* tracker_query_construct (GType object_type) {
	TrackerQuery* self = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerQuery*) g_type_create_instance (object_type);
	_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	_g_object_unref0 (tracker_query_connection);
	tracker_query_connection = _tmp1_;
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("tracker-query.vala:163: Could not get Sparql connection: %s", e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


TrackerQuery* tracker_query_new (void) {
	return tracker_query_construct (TRACKER_TYPE_QUERY);
}


static gboolean tracker_query_check_query_and_match_type (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (query_type != TRACKER_QUERY_TYPE_IMAGES) {
		_tmp0_ = match_type == TRACKER_QUERY_MATCH_NONE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_critical ("tracker-query.vala:169: You can not use a non-IMAGES query (%d) with N" \
"ONE matching", (gint) query_type);
		result = FALSE;
		return result;
	}
	if (query_type == TRACKER_QUERY_TYPE_MUSIC) {
		gboolean _tmp2_ = FALSE;
		if (match_type == TRACKER_QUERY_MATCH_FTS_INDIRECT) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = match_type == TRACKER_QUERY_MATCH_TITLES_INDIRECT;
		}
		_tmp1_ = !_tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		g_critical ("tracker-query.vala:175: You can not use a MUSIC query with match TITLE" \
"S or FTS, INDIRECT required");
		result = FALSE;
		return result;
	}
	if (query_type != TRACKER_QUERY_TYPE_MUSIC) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		if (match_type == TRACKER_QUERY_MATCH_NONE) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = match_type == TRACKER_QUERY_MATCH_FTS;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = match_type == TRACKER_QUERY_MATCH_TITLES;
		}
		_tmp3_ = !_tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		g_critical ("tracker-query.vala:182: You can not use a non-MUSIC query (%d) with IN" \
"DIRECT matching (%d)", (gint) query_type, (gint) match_type);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void tracker_query_get_count_async_data_free (gpointer _data) {
	TrackerQueryGetCountAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_tracker_query_unref0 (data->self);
	g_slice_free (TrackerQueryGetCountAsyncData, data);
}


static gpointer _tracker_query_ref0 (gpointer self) {
	return self ? tracker_query_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerQueryGetCountAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerQueryGetCountAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_query_get_count_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_query_get_count_async_data_free);
	_data_->self = _tracker_query_ref0 (self);
	_data_->query_type = query_type;
	_data_->match_type = match_type;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_query_get_count_async_co (_data_);
}


guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error) {
	guint result;
	TrackerQueryGetCountAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0U;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void tracker_query_get_count_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerQueryGetCountAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_query_get_count_async_co (data);
}


static gboolean tracker_query_get_count_async_co (TrackerQueryGetCountAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_query_connection != NULL, FALSE);
	data->cursor = NULL;
	data->_tmp0_ = tracker_query_check_query_and_match_type (data->self, data->query_type, data->match_type);
	if (!data->_tmp0_) {
		data->result = (guint) 0;
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->match_type != TRACKER_QUERY_MATCH_NONE) {
		if (data->self->priv->_criteria == NULL) {
			data->_tmp2_ = TRUE;
		} else {
			data->_tmp3_ = strlen (data->self->priv->_criteria);
			data->_tmp2_ = data->_tmp3_ < 1;
		}
		data->_tmp1_ = data->_tmp2_;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		g_warning ("tracker-query.vala:198: Criteria was NULL or an empty string, no query" \
" performed");
		data->result = (guint) 0;
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = tracker_sparql_escape_string (data->self->priv->_criteria);
	data->criteria_escaped = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_strdup_printf (data->self->priv->match_clauses[data->match_type], data->criteria_escaped);
	data->match = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_strdup_printf (data->self->priv->where_clauses[data->query_type], data->match);
	data->_tmp7_ = data->_tmp6_;
	data->_tmp8_ = g_strconcat ("SELECT count(?urn) ", data->_tmp7_, NULL);
	data->_tmp9_ = data->_tmp8_;
	tracker_query_set_query (data->self, data->_tmp9_);
	_g_free0 (data->_tmp9_);
	_g_free0 (data->_tmp7_);
	data->_state_ = 1;
	tracker_sparql_connection_query_async (tracker_query_connection, data->self->priv->_query, NULL, tracker_query_get_count_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp10_ = NULL;
	data->_tmp10_ = tracker_sparql_connection_query_finish (tracker_query_connection, data->_res_, &data->_inner_error_);
	data->_tmp11_ = data->_tmp10_;
	if (data->_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	_g_object_unref0 (data->cursor);
	data->cursor = data->_tmp11_;
	data->_state_ = 2;
	tracker_sparql_cursor_next_async (data->cursor, NULL, tracker_query_get_count_async_ready, data);
	return FALSE;
	_state_2:
	tracker_sparql_cursor_next_finish (data->cursor, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	goto __finally4;
	__catch4_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-query.vala:211: Could not run Sparql count query: %s", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally4:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->match);
			_g_free0 (data->criteria_escaped);
			_g_object_unref0 (data->cursor);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->match);
			_g_free0 (data->criteria_escaped);
			_g_object_unref0 (data->cursor);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp12_ = tracker_sparql_cursor_get_integer (data->cursor, 0);
	data->result = (guint) data->_tmp12_;
	_g_free0 (data->match);
	_g_free0 (data->criteria_escaped);
	_g_object_unref0 (data->cursor);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_free0 (data->match);
	_g_free0 (data->criteria_escaped);
	_g_object_unref0 (data->cursor);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_query_perform_async_data_free (gpointer _data) {
	TrackerQueryPerformAsyncData* data;
	data = _data;
	data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_tracker_query_unref0 (data->self);
	g_slice_free (TrackerQueryPerformAsyncData, data);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerQueryPerformAsyncData* _data_;
	gchar** _tmp0_;
	_data_ = g_slice_new0 (TrackerQueryPerformAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_query_perform_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_query_perform_async_data_free);
	_data_->self = _tracker_query_ref0 (self);
	_data_->query_type = query_type;
	_data_->match_type = match_type;
	_data_->args = (_tmp0_ = args, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, args_length1));
	_data_->args_length1 = args_length1;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_query_perform_async_co (_data_);
}


TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerQueryPerformAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_query_perform_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerQueryPerformAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_query_perform_async_co (data);
}


static gboolean tracker_query_perform_async_co (TrackerQueryPerformAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (tracker_query_connection != NULL, FALSE);
	data->cursor = NULL;
	data->_tmp0_ = tracker_query_check_query_and_match_type (data->self, data->query_type, data->match_type);
	if (!data->_tmp0_) {
		data->result = NULL;
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->match_type != TRACKER_QUERY_MATCH_NONE) {
		if (data->self->priv->_criteria == NULL) {
			data->_tmp2_ = TRUE;
		} else {
			data->_tmp3_ = strlen (data->self->priv->_criteria);
			data->_tmp2_ = data->_tmp3_ < 1;
		}
		data->_tmp1_ = data->_tmp2_;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		g_warning ("tracker-query.vala:226: Criteria was NULL or an empty string, no query" \
" performed");
		data->result = NULL;
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->self->priv->_limit < 1) {
		g_warning ("tracker-query.vala:231: Limit was < 1, no query performed");
		data->result = NULL;
		_g_object_unref0 (data->cursor);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = tracker_sparql_escape_string (data->self->priv->_criteria);
	data->criteria_escaped = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_strdup_printf (data->self->priv->match_clauses[data->match_type], data->criteria_escaped);
	data->match = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_strjoinv (" ", data->args);
	data->_tmp7_ = data->_tmp6_;
	data->_tmp8_ = g_strconcat ("SELECT ", data->_tmp7_, NULL);
	data->_tmp9_ = data->_tmp8_;
	data->_tmp10_ = g_strconcat (data->_tmp9_, " ", NULL);
	data->_tmp11_ = data->_tmp10_;
	data->_tmp12_ = NULL;
	data->_tmp12_ = g_strdup_printf (data->self->priv->where_clauses[data->query_type], data->match);
	data->_tmp13_ = data->_tmp12_;
	data->_tmp14_ = g_strconcat (data->_tmp11_, data->_tmp13_, NULL);
	data->_tmp15_ = data->_tmp14_;
	tracker_query_set_query (data->self, data->_tmp15_);
	_g_free0 (data->_tmp15_);
	_g_free0 (data->_tmp13_);
	_g_free0 (data->_tmp11_);
	_g_free0 (data->_tmp9_);
	_g_free0 (data->_tmp7_);
	data->_tmp16_ = NULL;
	data->_tmp16_ = g_strdup_printf ("%u", data->self->priv->_offset);
	data->_tmp17_ = data->_tmp16_;
	data->_tmp18_ = NULL;
	data->_tmp18_ = g_strdup_printf ("%u", data->self->priv->_limit);
	data->_tmp19_ = data->_tmp18_;
	data->_tmp20_ = NULL;
	data->_tmp20_ = g_strconcat (" OFFSET ", data->_tmp17_, " LIMIT ", data->_tmp19_, NULL);
	data->_tmp21_ = data->_tmp20_;
	data->_tmp22_ = g_strconcat (data->self->priv->_query, data->_tmp21_, NULL);
	data->_tmp23_ = data->_tmp22_;
	tracker_query_set_query (data->self, data->_tmp23_);
	_g_free0 (data->_tmp23_);
	_g_free0 (data->_tmp21_);
	_g_free0 (data->_tmp19_);
	_g_free0 (data->_tmp17_);
	g_debug ("tracker-query.vala:241: Running query: '%s'", data->self->priv->_query);
	data->_state_ = 1;
	tracker_sparql_connection_query_async (tracker_query_connection, data->self->priv->_query, NULL, tracker_query_perform_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp24_ = NULL;
	data->_tmp24_ = tracker_sparql_connection_query_finish (tracker_query_connection, data->_res_, &data->_inner_error_);
	data->_tmp25_ = data->_tmp24_;
	if (data->_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_g_object_unref0 (data->cursor);
	data->cursor = data->_tmp25_;
	goto __finally5;
	__catch5_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-query.vala:246: Could not run Sparql query: %s", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->match);
			_g_free0 (data->criteria_escaped);
			_g_object_unref0 (data->cursor);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->match);
			_g_free0 (data->criteria_escaped);
			_g_object_unref0 (data->cursor);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_debug ("tracker-query.vala:249: Done");
	data->result = data->cursor;
	_g_free0 (data->match);
	_g_free0 (data->criteria_escaped);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_free0 (data->match);
	_g_free0 (data->criteria_escaped);
	_g_object_unref0 (data->cursor);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


const gchar* tracker_query_get_criteria (TrackerQuery* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_criteria;
	return result;
}


void tracker_query_set_criteria (TrackerQuery* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_criteria);
	self->priv->_criteria = _tmp0_;
}


guint tracker_query_get_offset (TrackerQuery* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_offset;
	return result;
}


void tracker_query_set_offset (TrackerQuery* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_offset = value;
}


guint tracker_query_get_limit (TrackerQuery* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_limit;
	return result;
}


void tracker_query_set_limit (TrackerQuery* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_limit = value;
}


const gchar* tracker_query_get_query (TrackerQuery* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_query;
	return result;
}


static void tracker_query_set_query (TrackerQuery* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_query);
	self->priv->_query = _tmp0_;
}


static void tracker_value_query_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_value_query_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_query_unref (value->data[0].v_pointer);
	}
}


static void tracker_value_query_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_query_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_value_query_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_value_query_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerQuery* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_query_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_value_query_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerQuery** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_query_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecQuery* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_QUERY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_value_get_query (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY), NULL);
	return value->data[0].v_pointer;
}


void tracker_value_set_query (GValue* value, gpointer v_object) {
	TrackerQuery* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_QUERY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_query_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_query_unref (old);
	}
}


void tracker_value_take_query (GValue* value, gpointer v_object) {
	TrackerQuery* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_QUERY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_query_unref (old);
	}
}


static void tracker_query_class_init (TrackerQueryClass * klass) {
	tracker_query_parent_class = g_type_class_peek_parent (klass);
	TRACKER_QUERY_CLASS (klass)->finalize = tracker_query_finalize;
	g_type_class_add_private (klass, sizeof (TrackerQueryPrivate));
}


static void tracker_query_instance_init (TrackerQuery * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_ = NULL;
	self->priv = TRACKER_QUERY_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	_tmp1_ = g_strdup ("?urn fts:match \"%s\"");
	_tmp2_ = g_strdup ("?match fts:match \"%s\"");
	_tmp3_ = g_strdup ("FILTER (fn:contains (fn:lower-case (nfo:fileName(?urn)), \"%s\"))");
	_tmp4_ = g_strdup ("FILTER (fn:contains (fn:lower-case (nie:title (?match), \"%s\"))");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	self->priv->match_clauses = _tmp5_;
	self->priv->match_clauses_length1 = 5;
	self->priv->_match_clauses_size_ = self->priv->match_clauses_length1;
	_tmp6_ = g_strdup ("WHERE {\n" \
"		  %s .\n" \
"		  ?urn nfo:belongsToContainer ?parent ;\n" \
"		  tracker:available true .\n" \
"		}");
	_tmp7_ = g_strdup ("");
	_tmp8_ = g_strdup ("WHERE {\n		  ?urn a nfo:Software .\n		  %s\n		}");
	_tmp9_ = g_strdup ("WHERE {\n" \
"		  {\n" \
"		    ?urn nmm:musicAlbum ?match\n" \
"		  } UNION {\n" \
"		    ?urn nmm:performer ?match\n" \
"		  } UNION {\n" \
"		    ?urn a nfo:Audio .\n" \
"		    ?match a nfo:Audio\n" \
"		    FILTER (?urn = ?match)\n" \
"		  }\n" \
"		  %s .\n" \
"		  ?urn nmm:performer [ nmm:artistName ?performer ] ;\n" \
"		       nmm:musicAlbum [ nie:title ?album ] ;\n" \
"		       nie:url ?tooltip\n" \
"		}");
	_tmp10_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Image ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		}");
	_tmp11_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Video ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		}");
	_tmp12_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Document ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		  OPTIONAL {\n" \
"		    ?urn nco:creator ?creator .\n" \
"		  }\n" \
"		  OPTIONAL {\n" \
"		    ?urn nco:publisher ?publisher .\n" \
"		  }\n" \
"		}");
	_tmp13_ = g_strdup ("WHERE {\n" \
"		  ?urn a nmo:Email ;\n" \
"		         nmo:from ?sender ;\n" \
"		         nmo:to ?to .\n" \
"		  %s\n" \
"		}");
	_tmp14_ = g_strdup ("");
	_tmp15_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Folder ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		  OPTIONAL {\n" \
"		    ?urn nfo:belongsToContainer ?parent .\n" \
"		  }\n" \
"		}");
	_tmp16_ = g_new0 (gchar*, 10 + 1);
	_tmp16_[0] = _tmp6_;
	_tmp16_[1] = _tmp7_;
	_tmp16_[2] = _tmp8_;
	_tmp16_[3] = _tmp9_;
	_tmp16_[4] = _tmp10_;
	_tmp16_[5] = _tmp11_;
	_tmp16_[6] = _tmp12_;
	_tmp16_[7] = _tmp13_;
	_tmp16_[8] = _tmp14_;
	_tmp16_[9] = _tmp15_;
	self->priv->where_clauses = _tmp16_;
	self->priv->where_clauses_length1 = 10;
	self->priv->_where_clauses_size_ = self->priv->where_clauses_length1;
	self->ref_count = 1;
}


static void tracker_query_finalize (TrackerQuery* obj) {
	TrackerQuery * self;
	self = TRACKER_QUERY (obj);
	self->priv->match_clauses = (_vala_array_free (self->priv->match_clauses, self->priv->match_clauses_length1, (GDestroyNotify) g_free), NULL);
	self->priv->where_clauses = (_vala_array_free (self->priv->where_clauses, self->priv->where_clauses_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_criteria);
	_g_free0 (self->priv->_query);
}


GType tracker_query_get_type (void) {
	static volatile gsize tracker_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_query_init, tracker_value_query_free_value, tracker_value_query_copy_value, tracker_value_query_peek_pointer, "p", tracker_value_query_collect_value, "p", tracker_value_query_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerQuery), 0, (GInstanceInitFunc) tracker_query_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_query_type_id;
		tracker_query_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerQuery", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_query_type_id__volatile, tracker_query_type_id);
	}
	return tracker_query_type_id__volatile;
}


gpointer tracker_query_ref (gpointer instance) {
	TrackerQuery* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_query_unref (gpointer instance) {
	TrackerQuery* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_QUERY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



