# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: Autoload.py,v 1.2 1999/08/06 12:49:09 gobry Exp $

import os

class Loader:
    def __init__ (self, name, url, module):
        self.name   = name
        self.url    = url [0:3]
        self.module = module
        self.loaded = 0
        return

    def load (self, url = None):
        if self.loaded: return

        if url:
            # check if we are interested
            url = list (url [0:3])
            url [2] = os.path.splitext (url [2]) [1]

            for i in range (len (self.url)):
                if not self.url [i]: continue
                if self.url [i] != url [i]: return

        # ok, load the module
        try:
            exec ('import ' + self.module)
        except ImportError, err:
            print "warning: can't import %s: %s" % \
                  (self.module, str (err))

        self.loaded = 1

__loaders = []

def register (name, url, module):
    __loaders.append (Loader (name, url, module))


def check_by_url (url):
    for l in __loaders:
        l.load (url)


def check_by_name (name):
    for l in __loaders:
        if l.name == name: l.load ()


def available ():
    return map (lambda x: x.name, __loaders)
