/* -*- Mode: C; c-basic-offset: 2; -*- */
/* GdkPixbuf library - test images
 *
 * Copyright (C) 2001 Sren Sandmann (sandmann@daimi.au.dk)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TEST_IMAGES_H
#define TEST_IMAGES_H

#define GIF_HEADER 'G', 'I', 'F', '8', '9', 'a'
#define PNG_HEADER 0x89, 'P', 'N', 'G', 0x0d, 0x0a, 0x1a, 0x0a
#define TIFF1_HEADER 'M', 'M', 0x00, 0x2a
#define TIFF2_HEADER 'I', 'I', 0x2a, 0x00
#define JPEG_HEADER 0xFF, 0xd8

static unsigned char const valid_gif_test[] = {
    GIF_HEADER,
    115, 0, 51, 0, 128, 0, 0, 0, 0, 0, 255, 255, 255, 33, 249, 4, 1,
    0, 0, 1, 0, 44, 0, 0, 0, 0, 115, 0, 51, 0, 0, 2, 254, 140, 143,
    169, 203, 237, 10, 98, 138, 224, 217, 139, 179, 222, 144, 158,
    106, 128, 220, 72, 150, 166, 24, 120, 8, 106, 182, 238, 251, 173,
    210, 10, 215, 54, 201, 206, 241, 205, 247, 206, 44, 209, 177, 124,
    68, 34, 69, 116, 44, 42, 151, 204, 166, 243, 9, 141, 74, 167, 212,
    170, 245, 138, 205, 106, 79, 199, 174, 215, 187, 141, 170, 44, 73,
    235, 208, 57, 198, 232, 166, 103, 244, 250, 210, 70, 155, 223,
    228, 106, 188, 89, 14, 47, 238, 110, 190, 214, 143, 71, 135, 53,
    134, 52, 7, 88, 34, 228, 7, 82, 24, 194, 240, 245, 245, 146, 199,
    179, 88, 193, 71, 217, 184, 149, 118, 115, 8, 177, 147, 41, 232,
    210, 165, 33, 164, 151, 2, 202, 101, 202, 201, 249, 241, 40, 90,
    115, 122, 34, 163, 230, 153, 146, 5, 27, 203, 138, 249, 131, 121,
    235, 230, 179, 182, 24, 2, 41, 44, 121, 181, 186, 241, 6, 212,
    216, 118, 204, 212, 60, 89, 187, 23, 214, 171, 20, 228, 248, 105,
    172, 59, 241, 119, 76, 141, 44, 92, 154, 59, 250, 28, 206, 225,
    77, 76, 94, 62, 222, 202, 174, 94, 205, 14, 239, 46, 63, 79, 95,
    111, 127, 143, 159, 175, 191, 207, 255, 155, 124, 94, 234, 81,
    170, 97, 112, 8, 209, 178, 23, 44, 157, 52, 86, 57, 248, 85, 90,
    7, 70, 155, 38, 133, 115, 162, 161, 139, 88, 71, 22, 13, 14, 125,
    193, 94, 93, 34, 181, 239, 146, 199, 68, 0, 31, 20, 0, 0, 59 
};

static unsigned char const gif_test_1[] = { 
    GIF_HEADER,
    229, 181, 243, 91, 86, 83, 21, 101, 171, 204, 127, 123, 82, 60,
    128, 80, 104, 129, 248, 85, 221, 103, 54, 90, 46, 29, 156, 76, 44,
    218, 157, 78, 43, 154, 187, 87, 119, 191, 138, 31, 106, 249, 235,
    4, 35, 120, 54, 114, 78, 228, 202, 34, 243, 145, 47, 93, 154, 105,
    123, 3, 245, 23, 253, 41, 48, 135, 106, 43, 183, 154, 90, 56, 96,
    178, 54, 85, 129, 28, 146, 9, 105, 11, 93, 91, 137, 32, 219, 109,
    97, 150, 123, 16, 25, 245, 108, 127, 29, 75, 170, 41, 226, 102, 6,
    97, 41, 106, 83, 105, 1, 231, 26, 115, 168, 132, 172, 107, 84,
    159, 111, 102, 29, 154, 188, 91
};

static unsigned char const gif_test_2[] = { 
    GIF_HEADER,
    234, 245, 183, 106, 54, 188, 114, 91, 109, 193, 253, 116, 71,
    1, 130, 121, 222, 4, 247, 74, 53, 255, 123, 106, 119, 172, 82, 6,
    219, 216, 186, 122, 229, 119, 222, 65, 55, 222, 31, 77, 69, 39, 28,
    5, 203, 208, 104, 81, 165, 242, 240, 3, 14, 26, 8, 16, 233, 70, 83,
    34, 242, 225, 85, 10, 218, 15, 126, 66, 48, 138, 35, 72, 249, 181,
    203, 105, 240, 61, 100, 31, 111, 194, 187, 55, 68, 163, 25, 52, 19,
    161, 238, 67, 163, 85, 239, 109, 248, 41, 72, 96, 212, 121, 30, 19,
    233, 58, 198, 63, 107, 120, 116, 45, 170, 83, 240, 107, 190, 53, 10,
    79, 104, 40, 40, 58, 149, 73, 168, 86, 245, 241, 124, 42, 213, 233,
    37, 47, 220, 74, 42, 80, 211, 246, 115, 117, 10, 233, 161, 25, 83,
    247, 124, 86, 175, 207, 46, 112, 239, 96, 128, 91, 138, 213, 156,
    35, 244, 246, 74, 117, 186, 49, 233, 44, 47, 200, 141, 39, 2, 17,
    83, 5, 164, 120, 60, 79, 34, 170, 227, 49, 220, 32, 209, 71, 212, 2,
    96, 23, 27, 96, 175, 27, 204, 94, 53, 103, 67, 197, 27, 79, 95, 3,
    201, 79, 224, 255, 35, 43, 230, 26, 11, 61, 88, 45, 17, 48, 180,
    121, 66, 62, 207, 85, 209, 124, 195, 165, 133, 93, 94, 205, 50, 42,
    142, 139, 219, 75, 44, 206, 173, 23, 243, 22, 219, 0, 131, 125, 88,
    118, 1, 184, 211, 70, 207, 97, 5, 81, 86, 116, 204, 107, 12, 161,
    117, 96, 35, 89, 130, 39, 5, 68, 251, 91, 251, 1, 246, 59, 173, 46,
    31, 75, 250, 58, 70, 81, 182, 51, 223, 104, 221, 246, 172, 114, 252,
    75, 153, 86, 90, 172, 27, 56, 255, 160, 144, 36, 217, 108, 106, 30,
    46, 175, 123, 79, 26, 1, 64, 64, 165, 203, 159, 5, 113, 116, 151,
    30, 122, 4, 9, 16, 133, 203, 195, 48, 87, 143, 162, 91, 210, 49, 26,
    64, 57, 69, 6, 111, 39, 229, 115, 88, 149, 215, 159, 29, 152, 18,
    57, 25, 181, 112, 79, 36, 193, 165, 77, 53, 139, 41, 20, 26, 56,
    238, 167, 26, 195, 93, 33, 124, 91, 139, 25, 107, 142, 98, 116, 6,
    207, 254, 150, 92, 126, 228, 155, 18, 148, 166, 111, 98, 202, 0,
    141, 24, 43, 19, 187, 93, 142, 225, 181, 51, 128, 52, 108, 1, 8, 10,
    104, 80, 138, 45, 79, 10, 218, 224, 135, 57, 7, 171, 248, 116, 99,
    154, 185, 40, 8, 144, 3, 9, 34, 172, 56, 53, 9, 102, 89, 46, 121, 4,
    155, 39, 156, 176, 65, 69, 142, 49, 29, 95, 209, 147, 61, 3, 110,
    226, 91, 5, 200, 118, 35, 78, 248, 120, 177, 91, 3, 186, 251, 34,
    96, 137, 92, 103, 173, 233, 0, 0, 197, 95, 73, 88, 235, 178, 112, 1,
    229, 215, 168, 26, 136, 189, 106, 84, 70, 62, 138, 108, 115, 58, 29,
    33, 87, 188, 1, 49, 196, 34, 38, 127, 7, 225, 140, 3, 33, 189, 142,
    73, 240, 53, 225, 92, 149, 194, 66, 55, 162, 241, 250, 74, 248, 63,
    73, 45, 32, 240, 145, 65, 124, 210, 130, 4
};

static unsigned char const gif_test_3[] = {
    GIF_HEADER,
    56, 240, 52, 127, 189, 79, 189, 22, 186, 77, 96, 110, 11, 190, 122,
    122, 130, 69, 95, 111, 40, 182, 200, 84, 211, 38, 196, 48, 35, 197,
    194, 91, 198, 121, 115, 103, 247, 107, 7, 40, 9, 42, 237, 106, 206,
    29, 75, 75, 42, 67, 134, 75, 205, 94, 33, 61, 168, 201, 99, 97, 30,
    243, 117, 119, 83, 209, 199, 40, 59, 147, 98, 73, 28, 108, 252, 65,
    109, 225, 232, 62, 165, 154, 124, 17, 7, 105, 3, 123, 153, 249, 150,
    43, 151, 35, 206, 85, 210, 108, 139, 98, 64, 207, 162, 63, 159, 207,
    93, 38, 153, 16, 229, 110, 169, 204, 224, 77, 34, 82, 108, 58, 72,
    139, 164, 28, 225, 188, 21, 77, 224, 161, 41, 81, 2, 217, 4, 11,
    237, 122, 144, 71, 98, 231, 136, 64, 42, 143, 205, 95, 192, 161, 84,
    120, 133, 172, 75, 28, 240, 8, 65, 71, 183, 13, 92, 32, 142, 214,
    56, 7, 191, 38, 140, 18, 225, 80, 226, 107, 91, 53, 90, 68, 103,
    240, 239, 115, 0, 68, 88, 99, 174, 6, 34, 109, 162, 131, 82, 61, 28,
    176, 84, 37, 27, 232, 10, 44, 71, 30, 207, 78, 36, 25, 88, 32, 180,
    225, 161, 87, 222, 65, 157, 36, 246, 133, 227, 2, 244, 176, 68, 23,
    125, 17, 251, 74, 143, 150, 200, 113, 158, 125, 37, 101, 160, 99,
    103, 5, 215, 33, 109, 14, 127, 58, 59, 50, 128, 5, 145, 86, 218,
    250, 113, 25, 108, 181, 203, 121, 226, 236, 25, 23, 4, 138, 63, 121,
    45, 87, 32, 114, 103, 153, 101, 51, 245, 146, 128, 64, 228, 100,
    124, 18, 246, 111, 158, 58, 180, 185, 12, 83, 198, 181, 94, 126, 81,
    165, 248, 126, 27, 170, 252, 70, 198, 249, 182, 97
};

static unsigned char const gif_test_4[] = {
    71, 73, 70, 56, 57, 97, 115, 0, 51, 0, 128, 0, 0, 0, 0, 0, 241,
    255, 255, 33, 249, 4, 1, 0, 0, 1, 0, 44, 0, 0, 0, 0, 115, 0, 51,
    0, 0, 2, 226, 140, 143, 169, 203, 237, 10, 98, 138, 224, 217, 139,
    179, 222, 144, 158, 106, 128, 220, 72, 150, 166, 24, 120, 8, 106,
    182, 238, 251, 173, 210, 10, 215, 54, 201, 101, 241, 205, 247,
    206, 44, 209, 177, 124, 68, 34, 69, 116, 44, 42, 151, 204, 166,
    243, 9, 141, 74, 167, 212, 170, 245, 59, 205, 106, 79, 199, 174,
    215, 187, 141, 170, 44, 73, 235, 208, 57, 198, 232, 166, 103, 244,
    250, 210, 70, 155, 223, 228, 106, 188, 89, 14, 47, 238, 110, 190,
    214, 143, 71, 135, 53, 134, 52, 191, 88, 34, 228, 7, 82, 24, 194,
    240, 245, 245, 223, 199, 179, 88, 193, 71, 217, 184, 149, 118,
    115, 8, 177, 147, 41, 232, 210, 165, 33, 164, 151, 2, 202, 101,
    202, 201, 249, 241, 40, 90, 115, 122, 34, 163, 230, 153, 146, 5,
    27, 203, 138, 249, 131, 121, 235, 230, 179, 182, 24, 2, 41, 44,
    121, 181, 186, 241, 6, 212, 216, 118, 204, 142, 60, 53, 187, 23,
    214, 171, 20, 228, 248, 105, 172, 59, 241, 119, 107, 141, 44, 92,
    154, 16, 250, 28, 206, 21, 77, 76, 0, 54, 222, 202, 174, 94, 205,
    14, 239, 46, 63, 79, 95, 111, 127, 178, 159, 175, 124, 207, 255,
    155, 124, 94, 234, 81, 170, 97, 112, 8, 209, 178, 23, 44, 157, 52,
    86, 57, 248, 85, 90, 7, 70, 155, 246, 133, 115, 162, 161, 139, 88,
    71, 22, 13, 26, 125, 193, 94, 93, 34, 181, 239, 146, 199, 68, 0,
    31, 20, 0, 0, 59
};

static unsigned char const valid_png_test[] = {
    PNG_HEADER,
    0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 48, 0, 0, 0, 48, 8, 6, 0, 0,
    0, 87, 2, 249, 135, 0, 0, 0, 4, 103, 65, 77, 65, 0, 1, 134, 160, 49,
    232, 150, 95, 0, 0, 10, 122, 73, 68, 65, 84, 120, 218, 237, 153, 93,
    108, 28, 87, 21, 199, 127, 119, 118, 118, 119, 214, 241, 198, 222,
    198, 78, 118, 99, 55, 142, 147, 214, 164, 161, 125, 136, 66, 145,
    242, 208, 34, 84, 68, 65, 168, 160, 86, 84, 173, 232, 135, 162, 210,
    168, 188, 160, 242, 81, 9, 65, 121, 170, 104, 165, 130, 224, 17, 41,
    149, 16, 66, 66, 32, 138, 4, 82, 31, 136, 170, 62, 16, 17, 209, 160,
    20, 84, 98, 39, 181, 243, 185, 137, 191, 191, 226, 217, 93, 219, 59,
    119, 119, 102, 238, 229, 97, 239, 236, 142, 55, 78, 178, 17, 42,
    170, 68, 174, 117, 53, 179, 227, 153, 59, 231, 127, 206, 255, 156,
    251, 191, 119, 224, 78, 187, 211, 238, 180, 59, 237, 78, 251, 127,
    110, 226, 19, 110, 147, 254, 164, 0, 16, 183, 48, 168, 19, 59, 244,
    255, 18, 128, 232, 192, 120, 189, 201, 125, 226, 6, 134, 235, 27,
    129, 176, 63, 38, 195, 69, 7, 14, 218, 204, 120, 177, 9, 133, 244,
    205, 64, 116, 4, 224, 119, 223, 249, 166, 82, 74, 163, 181, 34, 84,
    33, 245, 64, 81, 87, 10, 133, 64, 8, 11, 97, 9, 132, 72, 160, 205,
    95, 24, 40, 174, 121, 30, 74, 192, 54, 39, 67, 34, 153, 34, 97, 219,
    36, 236, 4, 9, 203, 66, 251, 117, 252, 90, 13, 223, 247, 9, 148, 66,
    105, 77, 24, 42, 252, 32, 164, 42, 61, 220, 170, 68, 169, 144, 30,
    59, 1, 192, 207, 143, 29, 119, 0, 101, 250, 6, 16, 29, 1, 8, 66, 5,
    26, 66, 173, 9, 2, 69, 24, 42, 246, 127, 227, 136, 200, 101, 115,
    56, 221, 78, 163, 219, 14, 50, 144, 72, 41, 65, 54, 158, 251, 193,
    203, 47, 233, 79, 239, 232, 227, 249, 215, 94, 21, 142, 227, 152,
    193, 90, 227, 74, 41, 91, 63, 74, 37, 232, 237, 5, 224, 149, 35, 47,
    104, 180, 198, 202, 108, 176, 51, 52, 231, 42, 14, 192, 234, 8, 128,
    210, 248, 97, 72, 24, 134, 40, 173, 196, 208, 19, 207, 137, 124, 62,
    207, 234, 234, 42, 161, 8, 99, 55, 54, 186, 12, 36, 50, 144, 228,
    239, 217, 39, 92, 79, 54, 141, 46, 157, 56, 121, 125, 236, 3, 224,
    66, 145, 185, 183, 223, 198, 49, 128, 190, 250, 220, 97, 225, 133,
    138, 213, 212, 22, 145, 202, 109, 227, 115, 135, 14, 117, 153, 39,
    172, 88, 191, 13, 0, 97, 72, 160, 66, 124, 21, 114, 247, 215, 159,
    163, 80, 40, 144, 74, 165, 40, 94, 41, 82, 175, 212, 145, 82, 182,
    188, 31, 180, 128, 0, 212, 3, 213, 242, 250, 154, 68, 150, 74, 148,
    78, 158, 68, 206, 151, 26, 94, 7, 228, 221, 5, 136, 162, 97, 238,
    253, 242, 99, 95, 19, 3, 219, 251, 245, 107, 71, 127, 45, 86, 86,
    87, 31, 54, 0, 108, 32, 17, 183, 237, 182, 0, 124, 234, 233, 35, 98,
    104, 199, 16, 182, 109, 19, 134, 33, 110, 197, 101, 126, 121, 190,
    101, 160, 57, 70, 17, 104, 102, 170, 3, 242, 131, 15, 161, 219, 65,
    94, 24, 71, 206, 207, 35, 139, 227, 148, 198, 198, 55, 208, 41, 114,
    4, 192, 112, 16, 240, 248, 23, 190, 36, 94, 60, 124, 152, 254, 238,
    238, 135, 140, 241, 93, 192, 22, 32, 29, 217, 222, 81, 14, 248, 74,
    161, 148, 34, 147, 204, 112, 121, 242, 50, 149, 149, 10, 238, 170,
    75, 173, 86, 163, 94, 173, 111, 240, 184, 12, 36, 142, 237, 196,
    202, 136, 134, 0, 156, 7, 15, 224, 4, 13, 67, 157, 7, 26, 247, 59,
    81, 30, 216, 144, 123, 252, 73, 164, 211, 200, 165, 110, 207, 99,
    139, 235, 50, 125, 252, 56, 159, 217, 218, 173, 127, 244, 206, 59,
    191, 0, 114, 6, 128, 6, 150, 129, 107, 128, 223, 9, 0, 225, 135, 13,
    0, 76, 21, 217, 2, 100, 180, 71, 143, 237, 224, 117, 105, 178, 235,
    235, 200, 11, 227, 224, 56, 198, 131, 64, 32, 241, 34, 0, 90, 33,
    167, 138, 38, 55, 218, 18, 151, 214, 189, 25, 64, 94, 144, 120, 190,
    79, 255, 236, 44, 107, 213, 42, 203, 243, 243, 156, 41, 45, 1, 108,
    5, 10, 192, 93, 128, 111, 2, 91, 185, 21, 128, 102, 77, 246, 131,
    16, 165, 67, 122, 31, 56, 64, 111, 228, 220, 184, 29, 14, 13, 175,
    75, 137, 59, 55, 199, 196, 153, 9, 118, 239, 219, 221, 40, 25, 26,
    100, 54, 199, 135, 227, 227, 28, 120, 224, 0, 189, 6, 104, 20, 45,
    128, 156, 169, 96, 0, 181, 191, 191, 79, 232, 251, 172, 149, 203,
    140, 151, 93, 237, 53, 234, 77, 1, 216, 3, 100, 129, 85, 96, 206,
    80, 72, 119, 20, 129, 64, 133, 132, 170, 49, 146, 99, 59, 13, 226,
    57, 166, 226, 68, 30, 53, 35, 77, 156, 153, 64, 46, 125, 64, 238,
    254, 60, 71, 143, 30, 229, 31, 239, 253, 89, 252, 245, 237, 183, 56,
    117, 234, 79, 4, 207, 252, 140, 7, 15, 61, 216, 160, 145, 211, 162,
    153, 12, 36, 158, 231, 97, 207, 207, 163, 42, 101, 86, 175, 93, 99,
    113, 117, 149, 41, 21, 80, 247, 3, 128, 1, 67, 33, 128, 42, 80, 6,
    234, 55, 203, 129, 248, 172, 104, 213, 195, 16, 165, 140, 209, 177,
    146, 25, 121, 45, 94, 211, 119, 239, 219, 205, 132, 148, 20, 167,
    37, 175, 63, 246, 24, 217, 122, 85, 63, 251, 242, 247, 197, 98, 162,
    7, 207, 243, 40, 95, 43, 147, 78, 167, 91, 207, 70, 5, 160, 86, 35,
    188, 112, 1, 207, 117, 113, 93, 151, 74, 161, 128, 92, 158, 23, 235,
    158, 212, 192, 78, 195, 178, 101, 227, 125, 55, 122, 210, 234, 64,
    26, 8, 63, 80, 4, 74, 53, 147, 51, 170, 24, 241, 228, 141, 174, 23,
    114, 5, 246, 237, 219, 135, 148, 146, 157, 59, 119, 162, 180, 70,
    89, 138, 237, 119, 109, 231, 114, 241, 50, 211, 211, 211, 27, 156,
    224, 249, 30, 158, 239, 17, 142, 141, 34, 44, 139, 242, 194, 2, 21,
    203, 66, 110, 219, 198, 186, 172, 235, 245, 90, 29, 160, 207, 76,
    100, 174, 1, 225, 69, 244, 182, 59, 209, 53, 129, 214, 2, 173, 91,
    188, 149, 109, 98, 36, 86, 70, 165, 148, 228, 114, 185, 102, 68, 2,
    21, 138, 51, 255, 60, 195, 185, 226, 57, 118, 238, 216, 137, 109,
    219, 184, 174, 187, 33, 153, 83, 203, 139, 116, 203, 26, 165, 169,
    41, 74, 229, 50, 11, 133, 2, 11, 115, 115, 172, 75, 73, 173, 238,
    11, 51, 251, 150, 129, 5, 147, 3, 183, 148, 18, 34, 54, 79, 88, 74,
    107, 173, 27, 57, 32, 226, 212, 113, 108, 167, 101, 188, 221, 186,
    238, 249, 30, 189, 125, 13, 89, 96, 9, 161, 11, 133, 130, 232, 235,
    239, 99, 255, 125, 251, 17, 73, 129, 8, 5, 158, 239, 145, 201, 100,
    240, 22, 22, 72, 203, 42, 158, 148, 184, 139, 139, 92, 17, 130, 243,
    43, 43, 141, 18, 237, 251, 8, 33, 52, 80, 2, 102, 129, 197, 136,
    251, 157, 104, 161, 102, 30, 132, 161, 106, 212, 115, 51, 23, 54,
    117, 143, 169, 249, 50, 104, 208, 201, 177, 29, 92, 207, 109, 254,
    6, 72, 88, 22, 247, 222, 123, 47, 233, 45, 105, 18, 137, 68, 35, 74,
    161, 36, 147, 204, 176, 82, 89, 193, 153, 152, 32, 213, 219, 203,
    84, 177, 136, 91, 169, 48, 142, 96, 213, 243, 72, 38, 147, 216, 9,
    139, 100, 210, 6, 152, 50, 220, 151, 49, 25, 46, 58, 205, 1, 43, 84,
    154, 80, 233, 214, 4, 229, 92, 47, 200, 162, 255, 149, 150, 75, 76,
    252, 123, 130, 210, 114, 41, 138, 0, 229, 245, 50, 163, 163, 163,
    120, 158, 215, 0, 103, 55, 162, 212, 61, 181, 64, 46, 159, 103, 241,
    236, 89, 220, 149, 21, 78, 123, 146, 82, 189, 142, 109, 219, 244,
    244, 244, 208, 221, 149, 33, 155, 201, 96, 60, 239, 181, 27, 127,
    43, 0, 205, 155, 66, 173, 208, 74, 55, 60, 238, 56, 45, 209, 22, 77,
    253, 49, 1, 119, 229, 202, 21, 228, 210, 7, 236, 232, 209, 188, 249,
    230, 155, 60, 251, 210, 139, 226, 196, 177, 63, 242, 206, 175, 190,
    203, 233, 211, 167, 73, 167, 211, 13, 222, 75, 73, 79, 58, 201, 202,
    165, 75, 44, 77, 78, 50, 91, 169, 112, 81, 88, 100, 183, 102, 25,
    24, 24, 160, 80, 40, 176, 197, 201, 136, 116, 50, 133, 49, 62, 178,
    55, 190, 214, 16, 118, 103, 171, 41, 141, 22, 226, 58, 197, 25, 231,
    63, 128, 231, 121, 228, 243, 121, 70, 43, 67, 252, 235, 220, 12, 63,
    249, 237, 11, 108, 247, 214, 245, 83, 207, 127, 75, 244, 108, 9,
    240, 61, 159, 201, 203, 147, 164, 82, 41, 182, 22, 47, 162, 182,
    102, 89, 152, 152, 224, 90, 169, 196, 41, 223, 199, 74, 103, 200,
    245, 228, 24, 28, 28, 68, 8, 129, 101, 89, 90, 88, 98, 3, 27, 98,
    71, 235, 70, 17, 208, 237, 231, 2, 129, 64, 111, 208, 56, 4, 52,
    169, 16, 7, 211, 219, 219, 203, 222, 129, 189, 172, 173, 173, 225,
    164, 211, 88, 53, 159, 229, 229, 101, 214, 236, 33, 74, 229, 18, 58,
    173, 201, 204, 79, 147, 27, 28, 224, 234, 251, 239, 83, 41, 151,
    185, 184, 182, 78, 41, 145, 160, 175, 191, 143, 145, 145, 17, 242,
    249, 60, 137, 68, 2, 203, 66, 136, 205, 11, 75, 115, 73, 106, 223,
    98, 17, 173, 163, 51, 173, 117, 107, 242, 177, 193, 233, 110, 72,
    130, 76, 131, 163, 45, 5, 234, 192, 182, 109, 219, 168, 171, 58, 61,
    231, 207, 83, 173, 215, 185, 122, 245, 42, 202, 82, 236, 220, 189,
    147, 124, 96, 225, 158, 61, 203, 116, 42, 69, 121, 97, 129, 185,
    149, 21, 206, 2, 217, 238, 44, 195, 67, 195, 12, 14, 12, 18, 232, 0,
    33, 4, 90, 163, 141, 9, 137, 152, 215, 111, 153, 3, 237, 139, 112,
    221, 152, 3, 180, 104, 26, 111, 84, 163, 227, 56, 173, 243, 120,
    239, 118, 216, 125, 207, 110, 186, 186, 186, 72, 37, 109, 246, 221,
    191, 143, 131, 159, 61, 200, 200, 208, 16, 245, 139, 231, 121, 248,
    213, 87, 169, 123, 30, 75, 174, 203, 68, 16, 98, 109, 233, 38, 191,
    35, 207, 192, 192, 0, 233, 84, 26, 17, 249, 93, 139, 56, 31, 172,
    88, 18, 91, 55, 203, 129, 235, 162, 160, 133, 70, 107, 180, 99, 59,
    162, 161, 227, 36, 78, 183, 211, 40, 106, 65, 227, 55, 64, 46, 155,
    107, 70, 41, 147, 204, 96, 219, 54, 73, 219, 102, 239, 208, 94, 114,
    185, 28, 11, 39, 254, 74, 223, 240, 48, 199, 223, 120, 131, 93, 143,
    60, 194, 71, 238, 10, 51, 87, 174, 210, 223, 219, 203, 158, 61, 123,
    200, 229, 114, 88, 86, 203, 167, 9, 209, 244, 167, 104, 3, 161, 111,
    54, 19, 235, 246, 100, 214, 90, 163, 244, 198, 29, 134, 72, 140, 73,
    41, 55, 72, 12, 2, 3, 196, 148, 87, 173, 53, 153, 76, 134, 213, 217,
    25, 122, 179, 89, 230, 71, 71, 153, 62, 119, 142, 51, 99, 99, 28,
    175, 251, 100, 179, 89, 134, 118, 13, 49, 56, 48, 72, 186, 43, 77,
    109, 189, 214, 162, 130, 64, 196, 236, 81, 155, 237, 78, 116, 18, 1,
    165, 181, 22, 129, 82, 124, 239, 153, 39, 245, 200, 67, 143, 220,
    238, 94, 146, 248, 233, 143, 95, 225, 233, 67, 15, 145, 239, 239,
    103, 122, 116, 148, 37, 215, 101, 84, 107, 150, 195, 144, 172, 157,
    160, 90, 171, 50, 53, 59, 133, 53, 191, 145, 209, 141, 73, 88, 8,
    163, 131, 194, 216, 174, 4, 157, 104, 161, 38, 251, 148, 66, 175,
    251, 138, 114, 221, 231, 196, 187, 199, 116, 219, 91, 136, 106, 69,
    147, 186, 90, 16, 106, 133, 99, 39, 184, 171, 203, 97, 107, 42, 205,
    174, 225, 97, 49, 121, 234, 20, 75, 174, 203, 84, 117, 93, 127, 84,
    245, 240, 3, 159, 176, 186, 198, 37, 111, 157, 169, 241, 179, 128,
    110, 108, 28, 40, 5, 8, 114, 9, 17, 241, 32, 242, 126, 216, 182,
    189, 114, 67, 0, 17, 199, 52, 160, 132, 184, 201, 100, 39, 132, 198,
    132, 58, 22, 111, 33, 4, 58, 122, 251, 231, 71, 238, 99, 165, 88,
    100, 242, 194, 5, 38, 171, 235, 122, 194, 73, 147, 244, 125, 18, 9,
    33, 210, 169, 164, 182, 19, 150, 104, 43, 223, 2, 180, 214, 45, 250,
    71, 186, 55, 30, 9, 221, 73, 4, 52, 192, 91, 239, 30, 207, 2, 61,
    192, 14, 96, 208, 28, 183, 154, 197, 181, 13, 36, 77, 169, 179, 99,
    101, 206, 7, 170, 95, 220, 191, 127, 251, 158, 39, 70, 190, 253,
    209, 123, 239, 49, 62, 55, 119, 249, 151, 99, 99, 239, 2, 219, 128,
    94, 243, 158, 178, 17, 107, 158, 49, 46, 90, 176, 92, 3, 150, 204,
    210, 49, 48, 227, 197, 129, 168, 78, 86, 100, 218, 220, 24, 0, 235,
    102, 192, 186, 57, 118, 1, 41, 99, 124, 116, 140, 182, 61, 18, 145,
    3, 142, 60, 250, 232, 11, 51, 99, 99, 76, 206, 204, 148, 142, 21,
    139, 191, 49, 227, 69, 18, 57, 52, 18, 121, 218, 8, 181, 48, 2, 110,
    122, 197, 0, 147, 230, 122, 61, 6, 68, 117, 18, 129, 248, 156, 16,
    149, 135, 58, 176, 22, 51, 60, 234, 81, 36, 34, 32, 214, 83, 7, 15,
    222, 87, 159, 155, 27, 190, 52, 59, 187, 242, 251, 241, 241, 31, 22,
    215, 214, 106, 102, 121, 24, 154, 49, 42, 192, 164, 81, 154, 145,
    88, 243, 99, 221, 51, 239, 147, 52, 139, 118, 203, 248, 219, 137,
    64, 212, 106, 49, 47, 69, 134, 198, 163, 96, 199, 128, 88, 95, 25,
    25, 57, 92, 41, 151, 249, 219, 149, 43, 175, 143, 151, 74, 51, 198,
    248, 46, 51, 230, 170, 209, 248, 51, 192, 138, 25, 51, 162, 134, 31,
    163, 77, 221, 188, 55, 234, 183, 77, 33, 209, 6, 36, 104, 3, 167,
    98, 47, 179, 227, 125, 189, 82, 153, 31, 155, 153, 249, 195, 95, 38,
    39, 79, 2, 219, 205, 186, 214, 50, 158, 93, 4, 174, 198, 116, 190,
    106, 75, 210, 118, 16, 113, 250, 232, 150, 78, 235, 108, 203, 124,
    195, 34, 223, 244, 68, 76, 163, 216, 177, 243, 100, 108, 251, 47,
    186, 190, 21, 216, 101, 182, 71, 50, 38, 159, 38, 77, 4, 214, 140,
    49, 65, 91, 185, 140, 122, 16, 139, 78, 208, 14, 160, 147, 109, 21,
    189, 201, 185, 142, 189, 200, 50, 131, 70, 0, 106, 109, 194, 171,
    43, 150, 180, 171, 166, 0, 204, 27, 207, 87, 141, 113, 237, 51, 109,
    60, 178, 237, 231, 250, 182, 183, 215, 219, 244, 135, 138, 189, 176,
    253, 163, 132, 181, 73, 212, 116, 172, 162, 148, 76, 121, 92, 48,
    215, 84, 91, 142, 197, 155, 218, 100, 75, 93, 253, 183, 95, 104,
    116, 91, 94, 180, 127, 26, 10, 111, 240, 149, 198, 141, 81, 97, 197,
    80, 72, 221, 228, 211, 211, 205, 142, 31, 251, 55, 178, 246, 49,
    173, 88, 121, 13, 76, 50, 234, 91, 124, 244, 211, 124, 194, 154,
    104, 91, 207, 222, 234, 195, 94, 199, 237, 63, 32, 196, 158, 174,
    153, 240, 196, 246, 0, 0, 0, 0, 73, 69, 78, 68, 174, 66, 96, 130
};

static unsigned char const png_test_1[] = {
    PNG_HEADER,
    10, 15, 19, 121, 49, 29, 160, 5, 29, 225, 167, 3, 79, 181, 188, 45,
    182, 25, 62, 4, 146, 216, 71, 105, 155, 245, 162, 37, 124, 133, 186,
    23, 15, 224, 55, 87, 109, 51, 21, 8, 145, 104, 252, 62, 52, 189, 127,
    68, 130, 125, 157 , 75, 68, 253, 226, 99, 254, 160, 147, 57, 224, 44,
    252, 97, 222, 166, 226, 84, 89, 22, 122, 81, 32, 171, 154, 49, 65,
    48, 197, 10, 131, 28, 133, 12, 210, 76, 82, 38, 42, 208, 51, 114, 91,
    87, 139, 90, 168, 210, 162, 81, 237 , 188, 106, 44, 65, 29, 255, 32,
    217, 140, 129, 11, 139, 254, 145, 5, 154, 34, 218, 1, 194, 88, 124,
    109
};

static unsigned char const png_test_2[] = { 
    PNG_HEADER, 
    0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 48, 0, 0, 0, 48, 8, 6, 0, 0,
    0, 87, 2, 249, 135, 0, 0, 0, 4, 103, 65, 77, 65, 0, 1, 134, 160,
    49, 232, 150, 95, 0, 0, 10, 122, 73, 68, 65, 84, 120, 218, 237,
    153, 93, 108, 28, 87, 21, 199, 127, 119, 118, 118, 119, 214, 241,
    198, 222, 198, 78, 118, 99, 55, 142, 147, 214, 164, 161, 125, 136,
    66, 145, 242, 208, 34, 84, 68, 65, 168, 160, 86, 84, 173, 232,
    135, 162, 210, 168, 188, 160, 242, 81, 9, 65, 121, 170, 104, 165,
    130, 224, 17, 41, 149, 16, 66, 66, 32, 138, 4, 82, 31, 136, 170,
    62, 16, 17, 209, 160, 20, 84, 98, 39, 181, 243, 185, 137, 191,
    191, 226, 217, 93, 219, 59, 119, 119, 102, 238, 229, 97, 239, 236,
    142, 55, 78, 178, 17, 42, 170, 68, 174, 117, 53, 179, 227, 153,
    59, 231, 127, 206, 255, 156, 251, 191, 119, 224, 78, 187, 211,
    238, 180, 59, 237, 78, 251, 127, 110, 226, 19, 110, 147, 254, 164,
    0, 16, 183, 48, 168, 19, 59, 244, 255, 18, 128, 232, 192, 120,
    189, 201, 125, 226, 6, 134, 235, 27, 129, 176, 63, 38, 195, 69, 7,
    14, 218, 204, 120, 177, 9, 133, 244, 205, 64, 116, 4, 224, 119,
    223, 249, 166, 82, 74, 163, 181, 34, 84, 33, 245, 64, 81, 87, 10,
    133, 64, 8, 11, 97, 9, 132, 72, 160, 205, 95, 24, 40, 174, 121,
    30, 74, 192, 54, 39, 67, 34, 153, 34, 97, 219, 36, 236, 4, 9, 203,
    66, 251, 117, 252, 90, 13, 223, 247, 9, 148, 66, 105, 77, 24, 42,
    252, 32, 164, 42, 61, 220, 170, 68, 169, 144, 30, 59, 1, 192, 207,
    143, 29, 119, 0, 101, 250, 6, 16, 29, 1, 8, 66, 5, 26, 66, 173, 9,
    2, 69, 24, 42, 246, 127, 227, 136, 200, 101, 115, 56, 221, 78,
    163, 219, 14, 50, 144, 72, 41, 65, 54, 158, 251, 193, 203, 47,
    233, 79, 239, 232, 227, 249, 215, 94, 21, 142, 227, 152, 193, 90,
    227, 74, 41, 91, 63, 74, 37, 232, 237, 5, 224, 149, 35, 47, 104,
    180, 198, 202, 108, 176, 51, 52, 231, 42, 14, 192, 234, 8, 128,
    210, 248, 97, 72, 24, 134, 40, 173, 196, 208, 19, 207, 137, 124,
    62, 207, 234, 234, 42, 161, 8, 99, 55, 54, 186, 12, 36, 50, 144,
    228, 239, 217, 39, 92, 79, 54, 141, 46, 157, 56, 121, 125, 236, 3,
    224, 66, 145, 185, 183, 223, 198, 49, 128, 190, 250, 220, 97, 225,
    133, 138, 213, 212, 22, 145, 202, 109, 227, 115, 135, 14, 117,
    153, 39, 172, 88, 191, 13, 0, 97, 72, 160, 66, 124, 21, 114, 247,
    215, 159, 163, 80, 40, 144, 74, 165, 40, 94, 41, 82, 175, 212,
    145, 82, 182, 188, 31, 180, 128, 0, 212, 3, 213, 242, 250, 154,
    68, 150, 74, 148, 78, 158, 68, 206, 151, 26, 94, 7, 228, 221, 5,
    136, 162, 97, 238, 253, 242, 99, 95, 19, 3, 219, 251, 245, 107,
    71, 127, 45, 86, 86, 87, 31, 54, 0, 108, 32, 17, 183, 237, 182, 0,
    124, 234, 233, 35, 98, 104, 199, 16, 182, 109, 19, 134, 33, 110,
    197, 101, 126, 121, 190, 101, 160, 57, 70, 17, 104, 102, 170, 3,
    242, 131, 15, 161, 219, 65, 94, 24, 71, 206, 207, 35, 139, 227,
    148, 198, 198, 55, 208, 41, 114, 4, 192, 112, 16, 240, 248, 23,
    190, 36, 94, 60, 124, 152, 254, 238, 238, 135, 140, 241, 93, 192,
    22, 32, 29, 217, 222, 81, 14, 248, 74, 161, 148, 34, 147, 204,
    112, 121, 242, 50, 149, 149, 10, 238, 170, 75, 173, 86, 163, 94,
    173, 111, 240, 184, 12, 36, 142, 237, 196, 202, 136, 134, 0, 156,
    7, 15, 224, 4, 13, 67, 157, 7, 26, 247, 59, 81, 30, 216, 144, 123,
    252, 73, 164, 211, 200, 165, 110, 207, 99, 139, 235, 50, 125, 252,
    56, 159, 217, 218, 173, 127, 244, 206, 59, 191, 0, 114, 6, 128, 6,
    150, 129, 107, 47, 223, 9, 0, 225, 135, 13, 0, 76, 21, 217, 2,
    100, 180, 71, 143, 237, 224, 117, 105, 178, 235, 235, 200, 11,
    227, 224, 56, 198, 131, 64, 32, 241, 34, 0, 90, 33, 167, 138, 38,
    55, 218, 18, 151, 214, 189, 25, 64, 94, 144, 120, 190, 79, 255,
    236, 44, 107, 213, 42, 203, 243, 243, 156, 41, 45, 1, 108, 5, 10,
    192, 93, 128, 111, 2, 91, 185, 21, 128, 102, 77, 246, 131, 16,
    165, 67, 122, 31, 56, 64, 111, 228, 220, 184, 29, 14, 13, 175, 75,
    137, 59, 55, 199, 196, 153, 9, 118, 239, 219, 221, 40, 25, 26,
    100, 54, 199, 135, 227, 227, 28, 120, 224, 0, 189, 6, 104, 20, 45,
    128, 156, 169, 96, 0, 181, 191, 191, 79, 232, 251, 172, 149, 203,
    140, 151, 93, 237, 53, 234, 77, 1, 216, 3, 100, 129, 85, 96, 206,
    80, 72, 119, 20, 129, 64, 133, 132, 170, 49, 146, 99, 59, 13, 226,
    57, 166, 226, 68, 30, 53, 35, 77, 156, 153, 64, 46, 125, 64, 238,
    254, 60, 71, 143, 30, 229, 31, 239, 253, 89, 252, 245, 237, 183,
    56, 117, 234, 79, 4, 207, 252, 140, 7, 15, 61, 216, 160, 145, 211,
    162, 153, 12, 36, 158, 231, 97, 207, 207, 163, 42, 101, 86, 175,
    93, 99, 113, 117, 149, 41, 21, 80, 247, 3, 128, 1, 67, 33, 128,
    42, 80, 6, 234, 55, 203, 129, 248, 172, 104, 213, 195, 16, 165,
    140, 209, 177, 146, 25, 121, 45, 94, 211, 119, 239, 219, 205, 132,
    148, 20, 167, 37, 175, 63, 246, 24, 217, 122, 85, 63, 251, 242,
    247, 197, 98, 162, 7, 207, 243, 40, 95, 43, 147, 78, 167, 91, 207,
    70, 5, 160, 86, 35, 188, 112, 1, 207, 117, 113, 93, 151, 74, 161,
    128, 92, 158, 23, 235, 158, 212, 192, 78, 195, 178, 101, 227, 125,
    55, 122, 210, 234, 64, 26, 8, 63, 80, 4, 74, 53, 147, 51, 170, 24,
    241, 228, 141, 174, 23, 114, 5, 246, 237, 219, 135, 148, 146, 157,
    59, 119, 162, 180, 70, 89, 138, 237, 119, 109, 231, 114, 241, 50,
    211, 211, 211, 27, 156, 224, 249, 30, 158, 239, 17, 142, 141, 34,
    44, 139, 242, 194, 2, 21, 203, 66, 110, 219, 198, 186, 172, 235,
    245, 90, 29, 160, 207, 76, 100, 174, 1, 225, 69, 244, 182, 59,
    209, 53, 129, 214, 2, 173, 91, 188, 149, 109, 98, 36, 86, 70, 165,
    148, 228, 114, 185, 102, 68, 2, 21, 138, 51, 255, 60, 195, 185,
    226, 57, 118, 238, 216, 137, 109, 219, 184, 174, 187, 33, 153, 83,
    203, 139, 116, 203, 26, 165, 169, 41, 74, 229, 50, 11, 133, 2, 11,
    115, 115, 172, 75, 73, 173, 238, 11, 51, 251, 150, 129, 5, 147, 3,
    183, 148, 18, 34, 54, 79, 88, 74, 107, 173, 27, 57, 32, 226, 212,
    113, 108, 167, 101, 188, 221, 186, 238, 249, 30, 189, 125, 13, 89,
    96, 9, 161, 11, 133, 130, 232, 235, 239, 99, 255, 125, 251, 17,
    73, 129, 8, 5, 158, 239, 145, 201, 100, 240, 22, 22, 72, 203, 42,
    158, 148, 184, 139, 139, 92, 17, 130, 243, 43, 43, 141, 18, 237,
    251, 8, 33, 52, 80, 2, 102, 129, 197, 136, 251, 157, 104, 161,
    102, 30, 132, 161, 106, 212, 115, 51, 23, 54, 117, 143, 169, 249,
    50, 104, 208, 201, 177, 29, 92, 207, 109, 254, 6, 72, 88, 22, 247,
    222, 123, 47, 233, 45, 105, 18, 137, 68, 35, 74, 161, 36, 147,
    204, 176, 82, 89, 193, 153, 152, 32, 213, 219, 203, 84, 177, 136,
    91, 169, 48, 142, 96, 213, 243, 72, 38, 147, 216, 9, 139, 100,
    210, 6, 152, 50, 220, 151, 49, 25, 46, 58, 205, 1, 43, 84, 154,
    80, 233, 214, 4, 229, 92, 47, 200, 162, 255, 149, 150, 75, 76,
    252, 123, 130, 210, 114, 41, 138, 0, 229, 245, 50, 163, 163, 163,
    120, 158, 215, 0, 103, 55, 162, 212, 61, 181, 64, 46, 159, 103,
    241, 236, 89, 220, 149, 21, 78, 123, 146, 82, 189, 142, 109, 219,
    244, 244, 244, 208, 221, 149, 33, 155, 201, 96, 60, 239, 181, 27,
    127, 43, 0, 205, 155, 66, 173, 208, 74, 55, 60, 238, 56, 45, 209,
    22, 77, 253, 49, 1, 119, 229, 202, 21, 228, 210, 7, 236, 232, 209,
    188, 249, 230, 155, 60, 251, 210, 139, 226, 196, 177, 63, 242,
    206, 175, 190, 203, 233, 211, 167, 73, 167, 211, 13, 222, 75, 73,
    79, 58, 201, 202, 165, 75, 44, 77, 78, 50, 91, 169, 112, 81, 88,
    100, 183, 102, 25, 24, 24, 160, 80, 40, 176, 197, 201, 136, 116,
    50, 133, 49, 62, 178, 55, 190, 214, 16, 118, 103, 171, 41, 141,
    22, 226, 58, 197, 25, 231, 63, 128, 231, 121, 228, 243, 121, 70,
    43, 67, 252, 235, 220, 12, 63, 249, 237, 11, 108, 247, 214, 245,
    83, 207, 127, 75, 244, 108, 9, 240, 61, 159, 201, 203, 147, 164,
    82, 41, 182, 22, 47, 162, 182, 102, 89, 152, 152, 224, 90, 169,
    196, 41, 223, 199, 74, 103, 200, 245, 228, 24, 28, 28, 68, 8, 129,
    101, 89, 90, 88, 98, 3, 27, 98, 71, 235, 70, 17, 208, 237, 231, 2,
    129, 64, 111, 208, 56, 4, 52, 169, 16, 7, 211, 219, 219, 203, 222,
    129, 189, 172, 173, 173, 225, 164, 211, 88, 53, 159, 229, 229,
    101, 214, 236, 33, 74, 229, 18, 58, 173, 201, 204, 79, 147, 27,
    28, 224, 234, 251, 239, 83, 41, 151, 185, 184, 182, 78, 41, 145,
    160, 175, 191, 143, 145, 145, 17, 242, 249, 60, 137, 68, 2, 203,
    66, 136, 205, 11, 75, 115, 73, 106, 223, 98, 17, 173, 163, 51,
    173, 117, 107, 242, 177, 193, 233, 110, 72, 130, 76, 131, 163, 45,
    5, 234, 192, 182, 109, 219, 168, 171, 58, 61, 231, 207, 83, 173,
    215, 185, 122, 245, 42, 202, 82, 236, 220, 189, 147, 124, 96, 225,
    158, 61, 203, 116, 42, 69, 121, 97, 129, 185, 149, 21, 206, 2,
    217, 238, 44, 195, 67, 195, 12, 14, 12, 18, 232, 0, 33, 4, 90,
    163, 141, 9, 137, 152, 215, 111, 153, 3, 237, 139, 112, 221, 152,
    3, 180, 104, 26, 111, 84, 163, 227, 56, 173, 243, 120, 239, 118,
    216, 125, 207, 110, 186, 186, 186, 72, 37, 109, 246, 221, 191,
    143, 131, 159, 61, 200, 200, 208, 16, 245, 139, 231, 121, 248,
    213, 87, 169, 123, 30, 75, 174, 203, 68, 16, 98, 109, 233, 38,
    191, 35, 207, 192, 192, 0, 233, 84, 26, 17, 249, 93, 139, 56, 31,
    172, 88, 18, 91, 55, 203, 129, 235, 162, 160, 133, 70, 107, 180,
    99, 59, 162, 161, 227, 36, 78, 183, 211, 40, 106, 65, 227, 55, 64,
    46, 155, 107, 70, 41, 147, 204, 96, 219, 54, 73, 219, 102, 239,
    208, 94, 114, 185, 28, 11, 39, 254, 74, 223, 240, 48, 199, 223,
    120, 131, 93, 143, 60, 194, 71, 238, 10, 51, 87, 174, 210, 223,
    219, 203, 158, 61, 123, 200, 229, 114, 88, 86, 203, 167, 9, 209,
    244, 167, 104, 3, 161, 111, 54, 19, 235, 246, 100, 214, 90, 163,
    244, 198, 29, 134, 72, 140, 73, 41, 55, 72, 12, 2, 3, 196, 148,
    87, 173, 53, 153, 76, 134, 213, 217, 25, 122, 179, 89, 230, 71,
    71, 153, 62, 119, 142, 51, 99, 99, 28, 175, 251, 100, 179, 89,
    134, 118, 13, 49, 56, 48, 72, 186, 43, 77, 109, 189, 214, 162,
    130, 64, 196, 236, 81, 155, 237, 78, 116, 18, 1, 165, 181, 22,
    129, 82, 124, 239, 153, 39, 245, 200, 67, 143, 220, 238, 94, 146,
    248, 233, 143, 95, 225, 233, 67, 15, 145, 239, 239, 103, 122, 116,
    148, 37, 215, 101, 84, 107, 150, 195, 144, 172, 157, 160, 90, 171,
    50, 53, 59, 133, 53, 191, 145, 209, 141, 73, 88, 8, 163, 131, 194,
    216, 174, 4, 157, 104, 161, 38, 251, 148, 66, 175, 251, 138, 114,
    221, 231, 196, 187, 199, 116, 219, 91, 136, 106, 69, 147, 186, 90,
    16, 106, 133, 99, 39, 184, 171, 203, 97, 107, 42, 205, 174, 225,
    97, 49, 121, 234, 20, 75, 174, 203, 84, 117, 93, 127, 84, 245,
    240, 3, 159, 176, 186, 198, 37, 111, 157, 169, 241, 179, 128, 110,
    108, 28, 40, 5, 8, 114, 9, 17, 241, 32, 242, 126, 216, 182, 189,
    114, 67, 0, 17, 199, 52, 160, 132, 184, 201, 100, 39, 132, 198,
    132, 58, 22, 111, 33, 4, 58, 122, 251, 231, 71, 238, 99, 165, 88,
    100, 242, 194, 5, 38, 171, 235, 122, 194, 73, 147, 244, 125, 18,
    9, 33, 210, 169, 164, 182, 19, 150, 104, 43, 223, 2, 180, 214, 45,
    250, 71, 186, 55, 30, 9, 221, 73, 4, 52, 192, 91, 239, 30, 207, 2,
    61, 192, 14, 96, 208, 28, 183, 154, 197, 181, 13, 36, 77, 169,
    179, 99, 101, 206, 7, 170, 95, 220, 191, 127, 251, 158, 39, 70,
    190, 253, 209, 123, 239, 49, 62, 55, 119, 249, 151, 99, 99, 239,
    2, 219, 128, 94, 243, 158, 178, 17, 107, 158, 49, 46, 90, 176, 92,
    3, 150, 204, 210, 49, 48, 227, 197, 129, 168, 78, 86, 100, 218,
    220, 24, 0, 235, 102, 192, 186, 57, 118, 1, 41, 99, 124, 116, 140,
    182, 61, 18, 145, 3, 142, 60, 250, 232, 11, 51, 99, 99, 76, 206,
    204, 148, 142, 21, 139, 191, 49, 227, 69, 18, 57, 52, 18, 121,
    218, 8, 181, 48, 2, 110, 122, 197, 0, 147, 230, 122, 61, 6, 68,
    117, 18, 129, 248, 156, 16, 149, 135, 58, 176, 22, 51, 60, 234,
    81, 36, 34, 32, 214, 83, 7, 15, 222, 87, 159, 155, 27, 190, 52,
    59, 187, 242, 251, 241, 241, 31, 22, 215, 214, 106, 102, 121, 24,
    154, 49, 42, 192, 164, 81, 154, 145, 88, 243, 99, 221, 51, 239,
    147, 52, 139, 118, 203, 248, 219, 137, 64, 212, 106, 49, 47, 69,
    134, 198, 163, 96, 199, 128, 88, 95, 25, 25, 57, 92, 41, 151, 249,
    219, 149, 43, 175, 143, 151, 74, 51, 198, 248, 46, 51, 230, 170,
    209, 248, 51, 192, 138, 25, 51, 162, 134, 31, 163, 77, 221, 188,
    55, 234, 183, 77, 33, 209, 6, 36, 104, 3, 167, 98, 47, 179, 227,
    125, 189, 82, 153, 31, 155, 153, 249, 195, 95, 38, 39, 79, 2, 219,
    205, 186, 214, 50, 158, 93, 4, 174, 198, 116, 190, 106, 75, 210,
    118, 16, 113, 250, 232, 150, 78, 235, 108, 203, 124, 195, 34, 223,
    244, 68, 76, 163, 216, 177, 243, 100, 108, 251, 47, 186, 190, 21,
    216, 101, 182, 71, 50, 38, 159, 38, 77, 4, 214, 140, 49, 65, 91,
    185, 140, 122, 16, 139, 78, 208, 14, 160, 147, 109, 21, 189, 201,
    185, 142, 189, 200, 50, 131, 70, 0, 106, 109, 194, 171, 43, 150,
    180, 171, 166, 0, 204, 27, 207, 87, 141, 113, 237, 51, 109, 60,
    178, 237, 231, 250, 182, 183, 215, 219, 244, 135, 138, 189, 176,
    253, 163, 132, 181, 73, 212, 116, 172, 162, 148, 76, 121, 92, 48,
    215, 84, 91, 142, 197, 155, 218, 100, 75, 93, 253, 183, 95, 104,
    116, 91, 94, 180, 127, 26, 10, 111, 240, 149, 198, 141, 81, 97,
    197, 80, 72, 221, 228, 211, 211, 205, 142, 31, 251, 55, 178, 246,
    49, 173, 88, 121, 13, 76, 50, 234, 91, 124, 244, 211, 124, 194,
    154, 104, 91, 207, 222, 234, 195, 94, 199, 237, 63, 32, 196, 158,
    174, 153, 240, 196, 246, 0, 0, 0, 0, 73, 69, 78, 68, 174, 66, 96,
    130 };



static unsigned char const valid_tiff1_test[] = {
    TIFF1_HEADER,
    0, 0, 6, 222, 128, 0, 32, 80, 56, 36, 22, 13, 7,
    132, 66, 97, 80, 184, 100, 54, 29, 15, 136, 68, 98, 81, 56, 164,
    86, 45, 23, 140, 70, 99, 81, 184, 228, 118, 61, 21, 23, 72, 79,
    231, 227, 233, 116, 184, 89, 143, 202, 101, 82, 162, 188, 181,
    194, 224, 112, 61, 222, 207, 86, 179, 61, 148, 138, 65, 159, 2,
    179, 185, 92, 246, 125, 15, 157, 133, 90, 12, 246, 123, 241, 246,
    251, 123, 61, 30, 109, 38, 107, 33, 40, 139, 66, 22, 138, 165, 41,
    253, 86, 54, 98, 172, 48, 23, 203, 213, 98, 165, 76, 74, 35, 17,
    32, 198, 171, 35, 201, 224, 239, 122, 218, 108, 238, 230, 67, 9,
    124, 160, 75, 164, 12, 69, 210, 184, 136, 56, 28, 171, 94, 98, 36,
    1, 232, 245, 212, 233, 116, 188, 29, 206, 198, 189, 49, 84, 161,
    76, 19, 9, 4, 104, 26, 149, 72, 163, 117, 186, 157, 86, 103, 123,
    149, 198, 224, 98, 175, 151, 9, 116, 122, 31, 21, 98, 189, 104,
    97, 233, 100, 178, 85, 220, 237, 118, 62, 38, 83, 86, 82, 141, 50,
    145, 206, 160, 4, 91, 53, 122, 189, 93, 131, 200, 185, 220, 141,
    38, 99, 25, 140, 188, 91, 39, 243, 131, 209, 216, 215, 69, 199,
    134, 41, 241, 249, 118, 235, 133, 186, 218, 108, 83, 49, 9, 4, 66,
    0, 244, 110, 52, 153, 121, 74, 39, 11, 113, 175, 209, 102, 178,
    88, 11, 133, 226, 209, 86, 148, 70, 33, 5, 98, 113, 63, 35, 221,
    8, 68, 161, 208, 141, 38, 83, 17, 146, 194, 94, 47, 86, 170, 222,
    169, 232, 136, 190, 11, 130, 184, 164, 51, 174, 102, 17, 114, 89,
    23, 101, 145, 84, 93, 150, 37, 65, 84, 80, 19, 35, 152, 218, 51,
    61, 240, 170, 14, 190, 7, 176, 49, 100, 85, 148, 36, 211, 168, 64,
    191, 225, 234, 18, 156, 142, 164, 154, 160, 69, 144, 99, 232, 210,
    49, 139, 175, 96, 69, 11, 56, 226, 228, 100, 69, 145, 68, 74, 66,
    21, 160, 99, 80, 202, 47, 196, 130, 0, 118, 28, 33, 129, 112, 86,
    21, 142, 131, 104, 206, 55, 64, 143, 91, 219, 24, 52, 43, 184, 56,
    114, 74, 7, 201, 240, 124, 24, 37, 241, 116, 28, 6, 161, 146, 7,
    33, 201, 104, 130, 130, 147, 138, 177, 216, 180, 226, 7, 10, 12,
    152, 159, 10, 162, 168, 168, 180, 158, 167, 137, 224, 120, 25,
    102, 25, 120, 65, 15, 131, 172, 204, 138, 72, 97, 88, 161, 61,
    140, 163, 24, 196, 169, 138, 82, 192, 101, 59, 204, 232, 240, 218,
    53, 141, 103, 91, 0, 104, 153, 198, 97, 112, 88, 149, 114, 64,
    196, 187, 47, 8, 117, 14, 53, 151, 148, 201, 207, 77, 166, 115,
    105, 222, 119, 81, 71, 57, 162, 250, 151, 80, 220, 76, 66, 175,
    146, 5, 10, 140, 71, 225, 193, 160, 101, 24, 102, 65, 130, 93,
    145, 164, 49, 1, 65, 72, 41, 13, 50, 93, 158, 170, 85, 122, 121,
    157, 167, 89, 215, 79, 157, 172, 17, 216, 109, 155, 6, 171, 192,
    250, 24, 144, 73, 82, 71, 186, 178, 85, 86, 140, 19, 132, 161, 30,
    88, 148, 228, 248, 214, 51, 12, 8, 52, 92, 129, 175, 161, 233,
    168, 105, 26, 71, 205, 204, 120, 157, 231, 105, 230, 179, 29, 39,
    49, 200, 238, 155, 39, 41, 196, 111, 154, 70, 113, 148, 106, 25,
    230, 89, 159, 89, 22, 69, 65, 64, 55, 197, 97, 91, 103, 105, 162,
    243, 201, 17, 58, 8, 81, 242, 12, 217, 132, 79, 96, 78, 104, 168,
    105, 145, 234, 153, 158, 135, 97, 210, 115, 155, 134, 177, 164,
    214, 86, 5, 225, 142, 205, 86, 69, 217, 90, 83, 148, 70, 17, 112,
    87, 147, 196, 177, 28, 190, 7, 120, 34, 45, 60, 135, 25, 138, 7,
    39, 32, 116, 33, 109, 155, 159, 89, 201, 229, 116, 88, 39, 65,
    181, 124, 89, 134, 81, 128, 93, 25, 70, 9, 117, 102, 60, 69, 203,
    244, 87, 51, 132, 64, 247, 9, 101, 200, 169, 81, 169, 221, 103,
    149, 210, 118, 22, 244, 128, 132, 226, 32, 195, 72, 210, 51, 234,
    178, 145, 240, 164, 158, 102, 249, 178, 106, 233, 38, 57, 122, 91,
    25, 15, 25, 158, 99, 152, 6, 107, 50, 97, 212, 186, 17, 114, 85,
    148, 68, 208, 148, 36, 52, 26, 138, 30, 147, 11, 151, 89, 227, 94,
    158, 135, 57, 198, 112, 212, 165, 73, 8, 62, 142, 242, 200, 92,
    129, 151, 5, 193, 110, 122, 221, 116, 237, 218, 113, 154, 134,
    105, 142, 101, 152, 69, 217, 156, 99, 23, 230, 81, 132, 93, 110,
    69, 241, 160, 182, 243, 229, 249, 121, 5, 17, 196, 48, 254, 187,
    130, 187, 242, 33, 152, 134, 171, 105, 123, 205, 24, 87, 217, 132,
    225, 17, 227, 80, 198, 47, 192, 130, 234, 130, 109, 186, 24, 149,
    66, 107, 26, 38, 103, 82, 103, 51, 60, 225, 117, 56, 151, 134,
    100, 228, 100, 232, 197, 225, 102, 85, 146, 164, 105, 10, 36, 97,
    61, 146, 42, 56, 71, 68, 239, 178, 66, 241, 130, 147, 20, 129,
    139, 162, 200, 168, 25, 36, 55, 121, 191, 171, 157, 23, 145, 160,
    100, 152, 102, 51, 52, 241, 150, 59, 161, 103, 207, 152, 6, 41,
    118, 44, 215, 240, 151, 16, 65, 236, 58, 56, 231, 188, 70, 147,
    33, 197, 75, 68, 21, 84, 170, 213, 218, 57, 24, 176, 231, 27, 111,
    32, 106, 147, 97, 150, 102, 69, 184, 175, 21, 78, 116, 90, 183,
    129, 54, 36, 132, 80, 130, 44, 1, 10, 3, 154, 36, 156, 14, 209,
    251, 134, 28, 6, 8, 118, 141, 241, 180, 53, 143, 2, 163, 24, 109,
    200, 95, 139, 5, 252, 122, 4, 48, 56, 125, 144, 149, 10, 187, 67,
    188, 53, 7, 80, 231, 50, 195, 124, 109, 141, 56, 46, 243, 5, 240,
    205, 24, 130, 244, 90, 10, 161, 68, 24, 10, 145, 24, 12, 201, 244,
    78, 137, 193, 56, 44, 197, 144, 175, 21, 162, 168, 84, 9, 1, 26,
    34, 140, 81, 140, 135, 132, 29, 46, 13, 65, 160, 50, 199, 41, 206,
    55, 67, 132, 104, 191, 72, 148, 47, 22, 104, 180, 131, 226, 45,
    105, 17, 16, 214, 89, 23, 24, 208, 87, 236, 236, 119, 194, 193,
    224, 106, 25, 248, 206, 65, 34, 168, 58, 36, 136, 198, 65, 198,
    64, 196, 24, 17, 164, 110, 142, 56, 136, 53, 222, 73, 226, 23, 2,
    232, 87, 138, 120, 66, 31, 8, 144, 66, 147, 76, 92, 115, 46, 177,
    224, 229, 35, 224, 238, 129, 235, 200, 111, 201, 1, 152, 43, 197,
    40, 157, 72, 161, 156, 19, 176, 57, 14, 64, 133, 140, 91, 28, 67,
    116, 108, 194, 225, 172, 53, 70, 112, 200, 25, 169, 200, 96, 11,
    97, 90, 137, 8, 144, 70, 44, 48, 76, 105, 158, 9, 28, 54, 230, 56,
    215, 140, 238, 100, 99, 140, 83, 128, 37, 196, 112, 135, 125, 136,
    226, 87, 144, 65, 24, 124, 155, 48, 213, 152, 242, 224, 100, 58,
    145, 122, 130, 132, 123, 174, 54, 106, 84, 136, 7, 64, 222, 26,
    163, 138, 204, 137, 13, 38, 36, 10, 241, 76, 39, 131, 179, 224,
    154, 164, 28, 44, 166, 161, 178, 53, 6, 116, 182, 59, 195, 73,
    231, 11, 241, 104, 43, 5, 24, 154, 18, 65, 152, 47, 133, 160, 106,
    72, 72, 144, 123, 14, 193, 200, 105, 155, 214, 50, 185, 32, 184,
    196, 84, 162, 180, 82, 9, 196, 4, 19, 39, 153, 6, 73, 194, 248,
    91, 139, 37, 152, 53, 92, 211, 165, 100, 194, 197, 213, 138, 161,
    60, 37, 68, 115, 218, 15, 193, 173, 29, 168, 66, 24, 50, 6, 48,
    196, 29, 99, 160, 115, 77, 199, 252, 45, 5, 17, 175, 160, 238, 62,
    140, 144, 119, 92, 30, 197, 240, 182, 21, 238, 113, 207, 58, 8,
    148, 47, 88, 248, 182, 168, 34, 181, 126, 138, 5, 74, 42, 160,
    200, 170, 19, 162, 100, 75, 136, 163, 228, 38, 132, 200, 152, 22,
    85, 108, 106, 85, 213, 204, 62, 98, 8, 229, 159, 131, 21, 13, 8,
    48, 246, 29, 105, 233, 10, 9, 205, 238, 95, 10, 97, 127, 80, 159,
    227, 69, 104, 135, 141, 181, 11, 74, 36, 44, 155, 104, 184, 134,
    82, 204, 109, 14, 65, 192, 55, 71, 66, 239, 148, 3, 246, 194, 20,
    161, 226, 188, 134, 244, 220, 91, 2, 124, 42, 86, 186, 210, 67, 4,
    200, 144, 17, 66, 224, 87, 10, 119, 160, 244, 133, 227, 206, 166,
    242, 236, 94, 86, 57, 184, 54, 74, 96, 224, 27, 99, 93, 203, 194,
    197, 130, 58, 99, 72, 222, 60, 13, 208, 89, 30, 144, 250, 7, 9,
    229, 143, 173, 69, 128, 84, 156, 40, 154, 40, 134, 32, 188, 22,
    182, 98, 73, 60, 227, 126, 45, 157, 56, 193, 166, 241, 180, 97,
    186, 113, 132, 55, 70, 192, 212, 146, 3, 46, 35, 12, 90, 228, 131,
    196, 192, 80, 124, 246, 200, 135, 161, 32, 210, 41, 40, 18, 15,
    19, 44, 156, 83, 87, 118, 228, 47, 97, 149, 203, 174, 85, 17, 102,
    89, 177, 138, 47, 238, 13, 148, 20, 194, 0, 60, 7, 59, 168, 68,
    138, 8, 118, 156, 239, 142, 156, 137, 25, 124, 41, 6, 11, 39, 116,
    181, 141, 231, 39, 17, 118, 219, 198, 3, 111, 24, 35, 68, 182,
    161, 171, 34, 141, 143, 93, 239, 34, 133, 4, 53, 23, 49, 10, 31,
    131, 184, 145, 132, 55, 96, 73, 78, 225, 58, 47, 167, 248, 192,
    131, 50, 244, 87, 215, 115, 126, 45, 5, 176, 172, 20, 135, 160,
    66, 162, 28, 20, 71, 33, 27, 190, 11, 171, 108, 48, 7, 164, 36,
    36, 4, 72, 130, 68, 194, 16, 78, 9, 49, 25, 7, 196, 81, 156, 16,
    242, 20, 52, 192, 108, 78, 74, 84, 163, 142, 73, 78, 57, 199, 35,
    240, 106, 227, 148, 166, 63, 201, 89, 47, 38, 100, 220, 157, 147,
    242, 134, 81, 202, 81, 140, 128, 128, 0, 14, 1, 0, 0, 3, 0, 0, 0,
    1, 0, 47, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 48, 0, 0, 1, 2, 0, 3,
    0, 0, 0, 3, 0, 0, 7, 140, 1, 3, 0, 3, 0, 0, 0, 1, 0, 5, 0, 0, 1,
    6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 0,
    8, 1, 18, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 21, 0, 3, 0, 0, 0, 1,
    0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 48, 0, 0, 1, 23, 0, 4, 0,
    0, 0, 1, 0, 0, 6, 214, 1, 26, 0, 5, 0, 0, 0, 1, 0, 0, 7, 146, 1,
    27, 0, 5, 0, 0, 0, 1, 0, 0, 7, 154, 1, 28, 0, 3, 0, 0, 0, 1, 0, 1,
    0, 0, 1, 40, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8,
    0, 8, 18, 192, 0, 0, 0, 4, 0, 0, 18, 192, 0, 0, 0, 4, 0, 0
};

static unsigned char const tiff1_test_1[] = {
    77, 77, 0, 42, 0, 0, 6, 222, 128, 0, 32, 80, 56, 170, 22, 13, 7,
    132, 66, 97, 80, 184, 100, 54, 29, 15, 136, 68, 98, 81, 56, 164,
    86, 45, 23, 140, 70, 99, 81, 184, 228, 118, 61, 21, 23, 72, 79,
    231, 227, 233, 116, 184, 89, 143, 202, 101, 82, 162, 188, 181,
    194, 224, 112, 61, 222, 207, 86, 179, 61, 148, 138, 65, 159, 2,
    179, 185, 92, 246, 125, 15, 157, 133, 90, 12, 246, 123, 241, 246,
    251, 123, 61, 30, 109, 38, 107, 33, 40, 139, 66, 22, 138, 165, 41,
    253, 86, 54, 98, 172, 48, 23, 203, 213, 98, 165, 76, 74, 35, 17,
    32, 198, 171, 35, 201, 224, 239, 122, 218, 108, 238, 230, 67, 9,
    124, 160, 75, 164, 12, 69, 210, 184, 136, 56, 28, 171, 94, 98, 36,
    1, 232, 245, 212, 233, 116, 188, 29, 206, 198, 189, 49, 84, 161,
    76, 19, 9, 4, 104, 26, 149, 72, 163, 117, 186, 157, 86, 103, 123,
    149, 198, 224, 98, 175, 151, 9, 116, 122, 31, 21, 98, 189, 104,
    97, 233, 100, 178, 85, 220, 237, 118, 62, 38, 83, 86, 82, 141, 50,
    145, 206, 160, 4, 91, 53, 122, 189, 93, 131, 200, 185, 220, 141,
    38, 99, 25, 140, 188, 91, 39, 243, 131, 209, 216, 215, 69, 199,
    134, 41, 241, 249, 118, 235, 133, 186, 218, 108, 83, 49, 9, 4, 66,
    0, 244, 110, 52, 153, 121, 74, 39, 11, 113, 175, 209, 102, 178,
    88, 11, 133, 226, 209, 86, 148, 70, 33, 5, 98, 113, 63, 35, 221,
    8, 68, 161, 208, 141, 38, 83, 17, 146, 194, 94, 47, 86, 170, 222,
    169, 232, 136, 190, 11, 130, 184, 164, 51, 174, 102, 17, 114, 89,
    23, 101, 145, 84, 93, 150, 37, 65, 84, 80, 19, 35, 152, 218, 51,
    61, 240, 170, 14, 190, 7, 176, 49, 100, 85, 148, 36, 211, 168, 64,
    191, 225, 234, 18, 156, 142, 164, 154, 160, 69, 144, 99, 232, 210,
    49, 139, 175, 96, 69, 11, 56, 226, 228, 100, 69, 145, 68, 74, 66,
    21, 160, 99, 80, 202, 47, 196, 130, 0, 118, 28, 33, 129, 112, 86,
    21, 142, 131, 104, 206, 55, 64, 143, 91, 219, 24, 52, 43, 184, 56,
    114, 74, 7, 201, 240, 124, 24, 37, 241, 116, 28, 6, 161, 146, 7,
    33, 201, 104, 130, 130, 147, 138, 177, 216, 180, 226, 7, 10, 12,
    152, 159, 10, 162, 168, 168, 180, 158, 167, 137, 224, 120, 25,
    102, 25, 120, 65, 15, 131, 172, 204, 138, 72, 97, 88, 161, 61,
    140, 163, 24, 196, 169, 138, 82, 192, 101, 59, 204, 232, 240, 218,
    53, 141, 103, 91, 0, 104, 153, 198, 97, 112, 88, 149, 114, 64,
    196, 187, 47, 8, 117, 14, 53, 151, 148, 201, 207, 77, 166, 115,
    105, 222, 119, 81, 71, 57, 162, 250, 151, 80, 220, 76, 66, 175,
    146, 5, 10, 140, 71, 225, 193, 160, 101, 24, 102, 65, 130, 93,
    145, 164, 49, 1, 65, 72, 41, 13, 50, 93, 158, 170, 85, 122, 121,
    157, 167, 89, 215, 79, 157, 172, 17, 216, 109, 155, 6, 171, 192,
    250, 24, 144, 73, 82, 71, 186, 178, 85, 86, 140, 19, 132, 161, 30,
    88, 148, 228, 248, 214, 51, 12, 8, 52, 92, 129, 175, 161, 233,
    168, 105, 26, 71, 205, 204, 120, 157, 231, 105, 230, 179, 29, 39,
    49, 200, 238, 155, 39, 41, 196, 111, 154, 70, 113, 148, 106, 25,
    230, 89, 159, 89, 22, 69, 65, 64, 55, 197, 97, 91, 103, 105, 162,
    243, 201, 17, 58, 8, 81, 242, 12, 217, 132, 79, 96, 78, 104, 168,
    105, 145, 234, 153, 158, 135, 97, 210, 115, 155, 134, 177, 164,
    214, 86, 5, 225, 142, 205, 86, 69, 217, 90, 83, 148, 70, 17, 112,
    87, 147, 196, 177, 28, 190, 7, 120, 34, 45, 60, 135, 25, 138, 7,
    39, 32, 116, 33, 109, 155, 159, 89, 201, 229, 116, 88, 39, 65,
    181, 124, 89, 134, 81, 128, 93, 25, 70, 9, 117, 102, 60, 69, 203,
    244, 87, 51, 132, 64, 247, 202, 101, 200, 169, 81, 169, 221, 103,
    149, 210, 118, 22, 244, 128, 132, 226, 32, 195, 72, 210, 51, 234,
    178, 145, 240, 164, 158, 102, 249, 178, 106, 233, 38, 57, 122, 91,
    25, 15, 25, 158, 99, 152, 6, 107, 50, 97, 212, 186, 17, 4, 85,
    148, 68, 208, 148, 36, 52, 26, 138, 30, 147, 11, 151, 89, 227, 94,
    158, 135, 57, 198, 112, 212, 165, 73, 8, 62, 142, 242, 200, 92,
    129, 151, 5, 193, 110, 122, 221, 116, 237, 218, 113, 154, 134,
    105, 142, 101, 152, 69, 217, 156, 99, 23, 230, 81, 132, 93, 110,
    69, 241, 160, 182, 243, 229, 249, 121, 5, 17, 196, 48, 254, 187,
    130, 187, 242, 33, 152, 134, 171, 105, 123, 205, 24, 87, 217, 132,
    225, 17, 227, 80, 198, 47, 192, 130, 234, 130, 109, 186, 24, 149,
    66, 107, 26, 38, 103, 82, 103, 51, 60, 149, 117, 56, 151, 134,
    100, 228, 100, 232, 197, 225, 102, 85, 146, 164, 105, 10, 36, 97,
    61, 146, 42, 56, 71, 68, 239, 178, 66, 241, 130, 147, 20, 129,
    139, 162, 200, 168, 25, 36, 55, 121, 191, 171, 157, 23, 145, 160,
    100, 152, 102, 51, 52, 241, 150, 59, 161, 103, 207, 152, 6, 41,
    118, 44, 215, 240, 151, 16, 65, 236, 58, 56, 231, 188, 70, 147,
    33, 197, 75, 68, 21, 84, 170, 213, 218, 57, 24, 176, 231, 27, 111,
    32, 106, 147, 97, 150, 102, 69, 184, 175, 21, 78, 116, 90, 183,
    129, 54, 36, 132, 80, 130, 44, 1, 10, 3, 154, 36, 156, 14, 209,
    251, 134, 28, 6, 8, 118, 141, 241, 180, 53, 143, 2, 163, 24, 109,
    200, 95, 139, 5, 252, 122, 4, 48, 56, 125, 144, 149, 10, 187, 67,
    188, 53, 7, 80, 231, 50, 195, 124, 109, 141, 56, 46, 243, 5, 240,
    205, 24, 130, 244, 90, 10, 161, 68, 24, 10, 145, 24, 12, 201, 244,
    78, 137, 193, 56, 44, 197, 144, 175, 21, 162, 168, 84, 9, 1, 26,
    34, 140, 81, 140, 135, 132, 29, 46, 13, 65, 160, 50, 199, 41, 206,
    55, 67, 132, 104, 191, 72, 148, 47, 22, 104, 180, 131, 226, 45,
    105, 17, 16, 214, 89, 23, 24, 208, 87, 236, 236, 119, 194, 193,
    224, 106, 25, 248, 206, 65, 34, 168, 58, 36, 136, 198, 65, 198,
    64, 196, 24, 17, 164, 110, 142, 56, 136, 53, 222, 73, 226, 23, 2,
    232, 87, 138, 120, 66, 31, 8, 144, 66, 147, 76, 92, 115, 46, 177,
    224, 229, 35, 224, 238, 129, 235, 200, 111, 201, 1, 152, 43, 197,
    40, 157, 72, 161, 156, 19, 176, 57, 14, 64, 133, 140, 91, 28, 67,
    116, 108, 194, 225, 172, 53, 70, 112, 200, 25, 169, 200, 96, 11,
    97, 90, 137, 8, 144, 70, 44, 48, 76, 105, 158, 9, 28, 54, 230, 56,
    215, 140, 238, 100, 99, 140, 83, 128, 37, 196, 112, 135, 125, 136,
    226, 87, 144, 65, 24, 124, 155, 48, 213, 152, 242, 224, 100, 58,
    145, 122, 130, 132, 123, 174, 54, 106, 84, 136, 7, 64, 222, 26,
    163, 138, 204, 137, 13, 38, 36, 10, 241, 76, 39, 131, 179, 224,
    154, 164, 28, 44, 166, 161, 178, 53, 6, 116, 182, 59, 195, 73,
    231, 11, 241, 104, 43, 5, 24, 154, 18, 65, 152, 47, 133, 160, 106,
    72, 72, 144, 123, 14, 193, 200, 105, 155, 214, 50, 185, 32, 184,
    196, 84, 162, 180, 82, 9, 196, 4, 19, 39, 153, 6, 73, 194, 248,
    134, 139, 37, 152, 53, 92, 211, 165, 100, 194, 197, 213, 138, 161,
    60, 37, 68, 115, 218, 15, 193, 173, 29, 168, 66, 24, 50, 6, 48,
    196, 29, 99, 160, 115, 77, 199, 252, 45, 5, 17, 175, 160, 238, 62,
    140, 144, 119, 92, 30, 197, 240, 182, 21, 238, 113, 207, 58, 8,
    148, 47, 88, 248, 182, 168, 34, 181, 126, 138, 5, 74, 42, 160,
    200, 170, 19, 162, 100, 75, 136, 163, 228, 38, 132, 200, 152, 22,
    85, 108, 106, 85, 213, 204, 62, 98, 8, 229, 159, 131, 21, 13, 8,
    48, 246, 29, 105, 233, 10, 9, 205, 238, 95, 10, 97, 127, 80, 159,
    227, 69, 104, 135, 141, 181, 11, 74, 36, 44, 155, 104, 184, 134,
    82, 204, 109, 14, 65, 192, 55, 71, 66, 239, 148, 3, 246, 194, 20,
    161, 226, 188, 134, 244, 220, 91, 2, 124, 42, 86, 186, 210, 67, 4,
    200, 144, 17, 66, 224, 87, 10, 119, 160, 244, 133, 227, 206, 166,
    242, 236, 94, 86, 57, 184, 54, 74, 96, 224, 27, 99, 93, 203, 194,
    197, 130, 58, 99, 72, 222, 60, 13, 208, 89, 30, 144, 250, 7, 9,
    229, 143, 173, 69, 128, 84, 156, 40, 154, 40, 134, 32, 188, 22,
    182, 98, 73, 60, 227, 126, 45, 157, 56, 193, 166, 241, 180, 97,
    186, 113, 132, 55, 70, 192, 212, 146, 3, 46, 35, 12, 90, 228, 131,
    196, 192, 80, 124, 246, 200, 135, 161, 32, 210, 41, 40, 18, 15,
    19, 44, 156, 83, 87, 118, 228, 47, 97, 149, 203, 174, 85, 17, 102,
    89, 177, 138, 47, 238, 13, 148, 20, 194, 0, 60, 7, 59, 168, 68,
    138, 8, 118, 156, 239, 142, 156, 137, 25, 124, 41, 6, 11, 39, 116,
    181, 141, 231, 39, 17, 118, 219, 198, 3, 111, 24, 35, 68, 182,
    161, 171, 34, 141, 143, 93, 239, 34, 133, 4, 53, 23, 49, 10, 31,
    131, 184, 145, 132, 55, 96, 73, 78, 225, 58, 47, 167, 248, 192,
    131, 50, 244, 87, 215, 115, 126, 45, 5, 176, 172, 20, 135, 160,
    66, 162, 28, 20, 71, 33, 27, 190, 11, 171, 108, 48, 7, 164, 36,
    36, 4, 72, 130, 68, 194, 16, 78, 9, 49, 25, 7, 196, 81, 156, 16,
    242, 20, 52, 192, 108, 78, 74, 84, 163, 142, 73, 78, 57, 199, 35,
    240, 106, 227, 148, 166, 63, 201, 89, 47, 38, 100, 220, 157, 147,
    242, 134, 81, 202, 81, 140, 128, 128, 0, 14, 1, 0, 103, 3, 0, 0,
    0, 1, 0, 47, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 48, 0, 0, 1, 2, 0,
    3, 0, 0, 0, 3, 0, 0, 7, 140, 1, 3, 0, 3, 0, 0, 0, 1, 0, 5, 0, 0,
    1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 220, 1, 17, 0, 4, 0, 0, 0, 1, 0,
    0, 0, 8, 1, 18, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 21, 0, 3, 0, 0,
    0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 48, 0, 0, 1, 23, 0,
    4, 0, 0, 0, 1, 0, 0, 6, 214, 1, 26, 0, 5, 0, 0, 0, 1, 0, 0, 7,
    146, 1, 27, 0, 5, 0, 0, 0, 1, 0, 0, 7, 154, 1, 28, 0, 3, 0, 0, 0,
    1, 0, 1, 0, 0, 1, 40, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0,
    8, 0, 8, 0, 8, 18, 192, 0, 0, 0, 4, 0, 0, 18, 192, 0, 0, 0, 4, 0,
    0
};

static unsigned char const tiff1_test_2[] = {
    TIFF1_HEADER,
    0, 0, 6, 222, 128, 0, 32, 80, 56, 36, 22, 13, 7, 132, 66, 97, 80,
    184, 100, 54, 29, 15, 136, 68, 98, 81, 56, 164, 86, 45, 23, 140,
    70, 99, 81, 184, 228, 118, 61, 21, 23, 72, 79, 231, 227, 233, 116,
    184, 89, 143, 202, 101, 82, 162, 188, 181, 194, 224, 112, 61, 222,
    207, 86, 179, 61, 148, 138, 65, 159, 2, 179, 185, 92, 246, 125,
    15, 157, 133, 90, 12, 246, 211, 241, 246, 251, 123, 61, 30, 109,
    38, 107, 33, 40, 139, 66, 22, 138, 165, 41, 253, 86, 54, 98, 172,
    48, 23, 241, 213, 98, 165, 76, 74, 35, 17, 32, 198, 171, 35, 201,
    224, 239, 122, 218, 108, 238, 230, 67, 9, 124, 160, 75, 164, 12,
    69, 210, 169, 136, 56, 28, 171, 94, 98, 36, 1, 232, 245, 212, 233,
    116, 188, 29, 206, 198, 189, 49, 84, 161, 76, 206, 9, 4, 104, 26,
    149, 72, 163, 117, 186, 157, 86, 103, 123, 149, 198, 224, 98, 175,
    151, 9, 116, 122, 31, 21, 98, 189, 104, 97, 233, 100, 117, 85,
    220, 237, 118, 62, 38, 83, 86, 82, 141, 50, 145, 206, 160, 4, 91,
    53, 122, 189, 93, 131, 200, 185, 220, 141, 38, 99, 25, 140, 188,
    91, 39, 243, 131, 209, 216, 215, 69, 199, 134, 41, 241, 249, 118,
    235, 133, 186, 218, 108, 83, 49, 9, 4, 66, 0, 244, 110, 52, 153,
    121, 74, 39, 11, 113, 175, 209, 102, 178, 88, 11, 133, 226, 209,
    86, 148, 70, 33, 5, 98, 113, 63, 35, 221, 8, 68, 161, 208, 141,
    38, 83, 17, 146, 194, 94, 47, 86, 170, 222, 169, 232, 136, 190,
    11, 130, 184, 164, 51, 174, 102, 17, 114, 89, 23, 101, 145, 84,
    93, 150, 37, 65, 84, 80, 19, 35, 152, 218, 51, 61, 240, 170, 14,
    190, 7, 176, 49, 100, 85, 148, 36, 211, 168, 64, 191, 225, 234,
    18, 156, 234, 164, 154, 160, 69, 144, 99, 232, 210, 49, 139, 175,
    96, 69, 11, 56, 226, 228, 100, 69, 145, 68, 74, 66, 21, 160, 99,
    80, 202, 47, 196, 130, 0, 118, 28, 33, 129, 112, 86, 21, 142, 131,
    104, 206, 55, 64, 143, 91, 219, 24, 52, 43, 184, 56, 114, 74, 7,
    201, 240, 124, 24, 37, 241, 116, 28, 6, 161, 146, 7, 33, 201, 104,
    130, 130, 147, 138, 177, 216, 180, 226, 7, 10, 12, 152, 159, 10,
    162, 168, 168, 180, 158, 167, 137, 224, 120, 25, 102, 25, 120, 65,
    15, 131, 172, 204, 138, 72, 97, 88, 161, 61, 140, 163, 24, 196,
    169, 138, 82, 192, 101, 59, 204, 232, 240, 218, 53, 141, 103, 91,
    0, 104, 153, 198, 97, 112, 88, 149, 114, 64, 196, 187, 47, 8, 117,
    14, 53, 151, 148, 201, 207, 77, 166, 115, 105, 222, 119, 81, 71,
    57, 162, 250, 151, 80, 220, 76, 66, 175, 146, 5, 10, 140, 71, 225,
    193, 160, 101, 24, 102, 65, 130, 93, 145, 164, 49, 1, 65, 72, 41,
    13, 50, 93, 158, 170, 85, 122, 121, 157, 167, 89, 215, 79, 157,
    172, 17, 216, 109, 155, 6, 171, 192, 250, 24, 144, 73, 82, 71,
    186, 178, 85, 86, 140, 19, 132, 161, 30, 88, 148, 228, 248, 214,
    51, 202, 8, 52, 92, 129, 175, 161, 233, 168, 105, 26, 71, 205,
    204, 120, 157, 231, 105, 230, 179, 29, 39, 49, 200, 238, 155, 39,
    41, 196, 111, 154, 70, 113, 148, 106, 25, 230, 89, 159, 89, 22,
    69, 65, 64, 55, 197, 97, 91, 103, 105, 162, 243, 201, 17, 58, 8,
    81, 242, 12, 217, 132, 79, 96, 78, 104, 168, 105, 145, 234, 153,
    158, 135, 97, 210, 115, 155, 134, 177, 164, 214, 20, 5, 225, 142,
    205, 86, 69, 217, 90, 83, 148, 70, 17, 112, 87, 147, 196, 177, 28,
    190, 7, 120, 34, 45, 60, 135, 25, 8, 7, 39, 32, 116, 33, 109, 155,
    159, 89, 201, 229, 116, 88, 39, 65, 181, 124, 89, 134, 81, 128,
    93, 25, 70, 9, 117, 102, 60, 69, 203, 244, 87, 51, 132, 64, 247,
    9, 101, 200, 169, 81, 169, 221, 103, 149, 210, 118, 22, 244, 128,
    132, 226, 32, 195, 72, 210, 51, 234, 178, 145, 240, 164, 158, 102,
    249, 178, 106, 233, 38, 57, 122, 91, 25, 15, 25, 158, 99, 152, 6,
    107, 50, 97, 212, 186, 17, 114, 85, 148, 68, 208, 148, 36, 52, 26,
    138, 30, 147, 11, 151, 89, 227, 94, 158, 135, 57, 198, 112, 212,
    165, 73, 8, 62, 142, 242, 200, 92, 129, 151, 5, 193, 110, 122,
    221, 116, 237, 218, 113, 154, 134, 105, 142, 101, 152, 69, 217,
    156, 99, 23, 230, 81, 132, 93, 110, 69, 241, 160, 182, 243, 229,
    249, 121, 5, 17, 196, 48, 254, 187, 130, 187, 242, 33, 228, 134,
    171, 105, 123, 205, 24, 87, 217, 132, 225, 160, 227, 80, 198, 47,
    192, 130, 234, 130, 109, 186, 24, 149, 66, 107, 26, 38, 103, 82,
    103, 51, 60, 225, 117, 56, 151, 134, 100, 228, 100, 232, 197, 225,
    102, 85, 146, 164, 105, 10, 36, 97, 61, 146, 42, 56, 71, 68, 239,
    178, 66, 241, 130, 147, 20, 129, 139, 162, 200, 168, 25, 36, 55,
    121, 191, 171, 157, 23, 145, 160, 100, 152, 102, 51, 52, 241, 150,
    59, 161, 103, 207, 152, 6, 41, 118, 44, 215, 240, 151, 16, 65,
    236, 58, 56, 231, 188, 70, 222, 33, 197, 75, 68, 21, 84, 170, 213,
    218, 57, 24, 176, 231, 27, 111, 32, 106, 147, 97, 150, 102, 69,
    184, 175, 21, 78, 116, 90, 183, 129, 54, 36, 132, 80, 130, 44, 1,
    10, 3, 154, 36, 156, 14, 209, 251, 134, 28, 6, 8, 118, 141, 241,
    180, 53, 143, 2, 163, 24, 109, 200, 95, 139, 5, 252, 122, 4, 48,
    56, 125, 144, 149, 10, 187, 67, 188, 53, 7, 80, 231, 50, 195, 124,
    109, 141, 56, 240, 243, 5, 240, 205, 24, 130, 244, 90, 10, 161,
    68, 24, 10, 145, 24, 12, 201, 244, 78, 137, 193, 56, 44, 197, 144,
    175, 21, 162, 168, 84, 9, 1, 26, 34, 140, 81, 140, 135, 132, 29,
    46, 13, 65, 160, 50, 199, 41, 206, 55, 67, 132, 104, 191, 72, 148,
    47, 22, 104, 180, 131, 226, 45, 105, 17, 16, 214, 89, 23, 24, 208,
    87, 236, 236, 119, 194, 193, 224, 106, 25, 248, 206, 65, 34, 168,
    58, 36, 136, 198, 65, 198, 64, 196, 24, 17, 164, 110, 142, 56,
    136, 53, 222, 73, 226, 23, 2, 232, 87, 138, 120, 66, 31, 8, 144,
    66, 147, 76, 92, 115, 46, 177, 224, 229, 35, 224, 238, 129, 235,
    200, 111, 201, 1, 152, 43, 197, 40, 157, 72, 161, 156, 19, 176,
    57, 14, 64, 133, 140, 91, 28, 67, 116, 108, 194, 225, 172, 53, 70,
    112, 200, 25, 169, 200, 96, 11, 97, 90, 137, 8, 144, 70, 44, 48,
    76, 105, 158, 9, 28, 54, 230, 56, 215, 140, 238, 100, 99, 140, 83,
    128, 37, 196, 112, 135, 125, 136, 226, 95, 144, 65, 24, 124, 155,
    48, 213, 152, 242, 224, 100, 58, 145, 122, 130, 132, 123, 174, 54,
    106, 84, 136, 7, 64, 222, 26, 163, 138, 204, 137, 13, 38, 36, 10,
    241, 76, 39, 131, 179, 224, 154, 164, 28, 44, 166, 161, 178, 53,
    6, 239, 182, 59, 195, 73, 231, 11, 241, 104, 43, 5, 24, 154, 18,
    220, 152, 47, 133, 160, 106, 72, 72, 144, 123, 14, 193, 200, 24,
    155, 214, 50, 185, 32, 184, 196, 84, 162, 180, 82, 9, 196, 4, 19,
    39, 153, 6, 73, 194, 248, 91, 139, 37, 152, 53, 92, 211, 165, 202,
    194, 197, 213, 138, 161, 60, 37, 68, 115, 218, 15, 193, 173, 29,
    168, 66, 24, 50, 6, 48, 196, 29, 99, 160, 115, 77, 199, 252, 45,
    5, 17, 175, 160, 238, 62, 140, 144, 119, 92, 30, 197, 240, 182,
    21, 238, 113, 207, 58, 8, 148, 47, 88, 248, 182, 168, 34, 181,
    126, 138, 5, 74, 42, 160, 200, 170, 19, 162, 100, 75, 136, 163,
    228, 38, 132, 200, 152, 22, 85, 108, 106, 85, 213, 204, 62, 98, 8,
    229, 159, 131, 21, 13, 8, 48, 246, 29, 105, 233, 10, 9, 205, 238,
    95, 10, 97, 127, 80, 159, 227, 69, 104, 135, 141, 181, 11, 74, 36,
    44, 155, 104, 184, 134, 82, 204, 109, 14, 104, 192, 55, 71, 66,
    239, 148, 3, 246, 194, 20, 161, 226, 188, 134, 244, 220, 91, 2,
    124, 42, 86, 186, 210, 67, 4, 200, 144, 17, 66, 224, 87, 10, 119,
    160, 244, 133, 227, 206, 166, 242, 236, 94, 86, 57, 184, 54, 74,
    96, 224, 27, 99, 93, 203, 194, 197, 130, 58, 99, 72, 222, 60, 13,
    208, 89, 30, 144, 250, 7, 9, 229, 143, 173, 69, 128, 84, 156, 40,
    154, 40, 134, 32, 188, 22, 182, 98, 73, 82, 227, 126, 45, 157, 56,
    193, 166, 241, 180, 97, 186, 113, 132, 55, 70, 192, 212, 146, 3,
    46, 35, 12, 90, 228, 131, 196, 192, 80, 124, 246, 200, 135, 17,
    32, 121, 41, 40, 18, 15, 19, 44, 156, 83, 87, 118, 228, 47, 97,
    149, 203, 174, 85, 17, 102, 89, 177, 138, 47, 238, 13, 148, 20,
    194, 224, 60, 7, 59, 168, 68, 138, 8, 118, 156, 239, 142, 156,
    137, 25, 124, 41, 6, 11, 39, 116, 181, 141, 231, 39, 17, 118, 219,
    198, 3, 111, 24, 35, 68, 182, 161, 171, 34, 141, 143, 93, 239, 34,
    133, 4, 53, 23, 49, 10, 31, 131, 184, 145, 132, 55, 96, 73, 78,
    225, 58, 47, 167, 248, 192, 131, 50, 244, 87, 215, 115, 126, 45,
    5, 176, 172, 20, 135, 160, 66, 162, 28, 20, 71, 33, 27, 190, 11,
    171, 108, 48, 7, 164, 36, 36, 4, 72, 130, 68, 194, 16, 78, 9, 49,
    25, 7, 196, 216, 156, 16, 242, 20, 52, 192, 108, 78, 74, 84, 163,
    142, 73, 78, 57, 199, 35, 240, 106, 227, 148, 166, 63, 201, 89,
    47, 38, 100, 220, 157, 147, 242, 134, 81, 202, 81, 140, 128, 128,
    0, 14, 1, 0, 0, 3, 0, 0, 0, 1, 0, 47, 0, 0, 1, 11, 0, 3, 0, 0, 0,
    1, 0, 48, 0, 0, 1, 2, 0, 3, 0, 0, 0, 3, 0, 0, 7, 140, 1, 3, 0, 3,
    0, 0, 0, 1, 0, 5, 0, 0, 1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17,
    0, 4, 0, 0, 0, 1, 0, 0, 0, 8, 1, 18, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0,
    1, 21, 0, 3, 0, 0, 0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0,
    48, 0, 0, 1, 23, 83, 4, 0, 0, 0, 1, 0, 0, 6, 214, 1, 26, 0, 5, 0,
    0, 0, 1, 0, 0, 7, 146, 1, 27, 0, 5, 0, 0, 0, 1, 0, 0, 7, 154, 1,
    28, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 40, 0, 3, 0, 0, 0, 1, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 144, 18, 192, 0, 0, 0, 4, 0, 0,
    18, 192, 0, 0, 0, 4, 0, 0
};

static unsigned char const valid_ico_test[] = {
    0, 0, 1, 0, 1, 0, 16, 16, 16, 0, 0, 0, 0, 0, 40, 1, 0, 0, 22, 0, 0,
    0, 40, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0,
    128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 128, 0, 0, 128, 0, 0, 0, 128, 128, 0, 128, 0, 0, 0, 128,
    0, 128, 0, 128, 128, 0, 0, 192, 192, 192, 0, 128, 128, 128, 0, 0, 0,
    255, 0, 0, 255, 0, 0, 0, 255, 255, 0, 255, 0, 0, 0, 255, 0, 255, 0,
    255, 255, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    153, 153, 153, 9, 144, 0, 0, 0, 0, 153, 0, 0, 0, 0, 0, 0, 0, 153, 0,
    0, 153, 0, 0, 0, 9, 153, 144, 0, 153, 144, 0, 0, 153, 144, 153, 0,
    9, 144, 0, 9, 153, 0, 9, 144, 9, 153, 0, 153, 144, 0, 153, 153, 153,
    153, 153, 153, 153, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0, 240, 55, 0, 0, 240,
    39, 0, 0, 252, 123, 0, 0, 252, 113, 0, 0, 248, 48, 0, 0, 241, 24, 0,
    0, 227, 136, 0, 0, 129, 0, 0, 0, 1, 255, 0, 0, 255, 255, 0, 0, 255,
    255, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0
};

static unsigned char const ico_test_1[] = {
    0, 0, 1, 0, 1, 0, 16, 16, 16, 0, 0, 0, 0, 0, 40, 1, 0, 0, 22, 0,
    0, 0, 40, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 1, 0, 4, 0, 0, 222,
    0, 0, 128, 0, 0, 0, 0, 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 128, 0, 0, 0, 128, 128, 0, 128, 0,
    0, 0, 128, 0, 128, 0, 128, 128, 0, 0, 192, 192, 192, 0, 128, 128,
    128, 0, 0, 0, 255, 0, 0, 255, 0, 0, 0, 255, 255, 0, 255, 0, 0, 0,
    255, 0 , 255, 0, 255, 255, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 153, 153, 153, 9, 144, 0, 0, 0, 0, 153, 0, 0,
    0, 0, 0, 0, 0, 153, 0, 0, 153, 0, 0, 0, 9, 153, 144, 0, 153, 144,
    0, 0, 153, 144, 153, 251, 9, 144, 0, 9, 153, 0, 9, 144, 9, 153 ,
    0, 153, 144, 0, 153, 153, 153, 153, 153, 153, 153, 144, 0, 0, 0,
    0, 0, 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0,
    255, 255, 0, 0, 240, 55, 0, 0, 240, 39, 0, 0, 252, 123, 0, 0, 252,
    113, 0, 0, 248, 48, 0, 0, 241, 24, 0, 0, 227, 136, 0, 0 , 129, 0,
    0, 0, 1, 255, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0, 255, 255, 0,
    0, 255, 255, 0, 0
};

static unsigned char const wbmp_test_1[] = {
    0, 0, 189, 179, 1, 0, 16, 180, 16, 0, 0, 230, 0, 0, 40, 1, 0, 0,
    22, 0, 0, 115, 40, 0, 0, 0, 16, 0, 0, 0, 32, 56, 0, 0, 1, 70, 4,
    92, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 128, 0, 0, 128, 0, 0, 135, 128,
    128, 0, 128, 0, 0, 0, 248, 0, 128, 0, 128, 128, 0, 154, 84, 192,
    176, 0, 128, 128, 128, 0, 0, 0, 255, 0, 0, 255, 151, 0, 0, 161,
    255, 0, 255, 0, 0, 0, 255, 0, 255, 0, 255, 255, 0, 0, 255, 250,
    255, 0, 0, 159, 0, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216, 0, 0, 148,
    0, 0, 0, 24, 0, 187, 0, 229, 0, 0, 0, 0, 0, 67, 0, 90, 0, 65, 153,
    153, 9, 144, 205, 236, 0, 0, 153, 0, 0, 0, 0, 0, 0, 251, 249, 0,
    0, 194, 0, 97, 0, 9, 153, 144, 0, 153, 144, 0, 255, 153, 144, 153,
    150, 9, 144, 0, 9, 153, 141, 9, 198, 9, 153, 0, 153, 153, 208,
    153, 153, 233, 239, 153, 153, 153, 144, 0, 0, 71, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 61, 0, 0, 0, 0, 17, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 171, 235, 0, 0, 103, 255, 0, 60, 255, 255, 0,
    0, 240, 55, 0, 41, 240, 39, 220, 0, 252, 123, 0, 0, 58, 113, 0,
    178, 248, 48, 233, 0, 241, 183, 42, 0, 130, 136, 0, 0, 129, 88, 0,
    0, 1, 255, 0, 0, 175, 93, 26, 0, 255, 255, 0, 149, 255, 255, 0,
    198, 212, 255, 0, 0,
};

static unsigned char const wbmp_test_2[] = { 
    0, 0, 1, 111, 172, 0, 16, 16, 227, 0, 162, 150, 0, 24, 40, 208, 0,
    0, 22, 0, 0, 0, 40, 9, 0, 0, 16, 0, 221, 55, 32, 0, 0, 49, 1, 0,
    4, 0, 0, 0, 171, 0, 128, 0, 0, 24, 0, 0, 88, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 128, 0, 0, 128, 0, 0, 0, 128,
    128, 0, 128, 0, 0, 0, 128, 107, 128, 0, 128, 128, 0, 0, 192, 248,
    192, 234, 128, 128, 128, 209, 0, 28, 255, 0, 0, 255, 0, 0, 0, 255,
    255, 0, 255, 0, 0, 0, 102, 0, 255, 0, 130, 255, 0, 0, 255, 255,
    255, 202, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    232, 0, 19, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 81, 0, 153, 153, 153,
    99, 144, 0, 0, 0, 0, 153, 0, 0, 0, 0, 0, 0, 0, 153, 0, 0, 153,
    255, 0, 0, 10, 153, 144, 0, 153, 144, 0, 0, 153, 144, 153, 96, 9,
    144, 0, 9, 153, 0, 9, 144, 9, 153, 0, 153, 144, 0, 153, 254, 153,
    153, 153, 153, 153, 144, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 0, 47, 17, 0, 0, 0, 0, 0, 0, 250, 93, 47, 0,
    133, 28, 0, 255, 255, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0, 240,
    55, 211, 0, 240, 39, 0, 169, 252, 123, 0, 0, 252, 118, 0, 0, 248,
    48, 26, 0, 122, 24, 0, 0, 227, 108, 0, 0, 129, 0, 0, 133, 1, 255,
    0, 0, 142, 255, 0, 0, 255, 255, 88, 40, 120, 64, 0, 178, 168, 255,
    151, 147
};

static unsigned char const valid_jpeg_test[] = {
    JPEG_HEADER, 
    255, 224, 0, 16, 74, 70, 73, 70, 0, 1, 1, 1, 0, 72, 0, 72, 0, 0,
    255, 254, 0, 23, 67, 114, 101, 97, 116, 101, 100, 32, 119, 105,
    116, 104, 32, 84, 104, 101, 32, 71, 73, 77, 80, 255, 219, 0, 67,
    0, 8, 6, 6, 7, 6, 5, 8, 7, 7, 7, 9, 9, 8, 10, 12, 20, 13, 12, 11,
    11, 12, 25, 18, 19, 15, 20, 29, 26, 31, 30, 29, 26, 28, 28, 32,
    36, 46, 39, 32, 34, 44, 35, 28, 28, 40, 55, 41, 44, 48, 49, 52,
    52, 52, 31, 39, 57, 61, 56, 50, 60, 46, 51, 52, 50, 255, 219, 0,
    67, 1, 9, 9, 9, 12, 11, 12, 24, 13, 13, 24, 50, 33, 28, 33, 50,
    50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
    50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
    50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
    50, 255, 192, 0, 17, 8, 1, 144, 1, 144, 3, 1, 34, 0, 2, 17, 1, 3,
    17, 1, 255, 196, 0, 26, 0, 0, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 2, 3, 0, 4, 5, 7, 255, 196, 0, 56, 16, 0, 2, 1, 4, 1,
    3, 3, 3, 3, 2, 5, 4, 3, 1, 1, 1, 1, 2, 17, 0, 3, 18, 33, 49, 4,
    65, 81, 19, 34, 97, 50, 113, 129, 35, 66, 145, 82, 161, 5, 20, 51,
    177, 193, 114, 209, 225, 240, 98, 162, 241, 130, 67, 178, 255,
    196, 0, 24, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 2, 3, 4, 255, 196, 0, 23, 17, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 17, 1, 49, 255, 218, 0, 12, 3, 1, 0, 2, 17, 3,
    17, 0, 63, 0, 249, 216, 84, 91, 67, 17, 32, 142, 71, 122, 24, 70,
    200, 220, 104, 10, 202, 142, 232, 164, 94, 182, 130, 60, 77, 4,
    177, 105, 156, 2, 239, 112, 142, 73, 208, 175, 59, 185, 20, 230,
    164, 145, 33, 26, 4, 119, 171, 123, 216, 177, 80, 204, 73, 0, 251,
    232, 179, 91, 181, 108, 132, 182, 161, 71, 205, 34, 33, 116, 6,
    228, 73, 60, 142, 5, 84, 20, 36, 157, 3, 223, 154, 89, 62, 168,
    104, 208, 240, 124, 211, 7, 11, 108, 140, 139, 70, 164, 84, 128,
    123, 162, 230, 40, 196, 118, 215, 52, 12, 249, 22, 84, 81, 250,
    158, 124, 81, 9, 149, 194, 161, 75, 1, 16, 72, 167, 8, 21, 27, 4,
    194, 121, 108, 233, 8, 109, 5, 184, 85, 119, 36, 137, 168, 166,
    34, 27, 71, 191, 52, 169, 238, 7, 100, 128, 118, 69, 31, 76, 185,
    32, 67, 49, 212, 255, 0, 72, 166, 128, 139, 128, 50, 59, 145, 222,
    129, 16, 143, 89, 32, 1, 36, 201, 61, 171, 27, 182, 226, 51, 89,
    248, 52, 192, 231, 112, 128, 129, 163, 187, 86, 148, 77, 149, 180,
    39, 141, 85, 68, 253, 107, 89, 6, 82, 35, 137, 162, 138, 66, 24,
    64, 88, 177, 227, 152, 167, 5, 174, 88, 34, 65, 153, 18, 56, 166,
    36, 235, 114, 66, 193, 168, 169, 147, 10, 75, 14, 6, 132, 246,
    165, 208, 184, 100, 140, 136, 214, 169, 222, 49, 96, 78, 136, 162,
    25, 18, 217, 112, 203, 155, 142, 77, 84, 21, 68, 76, 139, 28, 238,
    30, 126, 41, 25, 130, 169, 111, 207, 138, 37, 178, 37, 253, 70,
    81, 2, 34, 153, 45, 162, 195, 179, 179, 5, 223, 60, 154, 138, 2,
    208, 80, 13, 196, 92, 136, 157, 142, 40, 8, 25, 158, 195, 64, 69,
    47, 166, 122, 150, 150, 103, 91, 125, 227, 83, 84, 180, 168, 128,
    18, 249, 14, 203, 192, 170, 128, 170, 45, 161, 136, 201, 140, 150,
    165, 8, 239, 112, 170, 184, 1, 68, 236, 154, 42, 11, 168, 132,
    135, 36, 247, 162, 69, 193, 145, 86, 182, 36, 126, 234, 1, 55, 85,
    32, 155, 96, 22, 208, 12, 123, 208, 85, 45, 121, 90, 224, 1, 84,
    234, 141, 187, 14, 167, 212, 107, 138, 9, 58, 212, 131, 68, 33,
    55, 64, 96, 53, 178, 123, 126, 40, 49, 96, 118, 191, 216, 214,
    178, 48, 177, 153, 250, 221, 164, 125, 171, 31, 78, 230, 91, 4,
    15, 26, 20, 174, 229, 205, 176, 80, 139, 98, 34, 55, 34, 162, 140,
    190, 19, 49, 151, 0, 208, 10, 136, 178, 114, 102, 0, 86, 12, 174,
    192, 193, 36, 3, 79, 128, 156, 238, 111, 126, 213, 21, 80, 168, 6,
    101, 189, 53, 39, 128, 72, 221, 1, 238, 113, 167, 0, 3, 0, 241,
    84, 102, 247, 30, 203, 218, 160, 134, 245, 254, 177, 146, 200, 88,
    69, 150, 103, 152, 160, 168, 85, 7, 50, 55, 29, 232, 63, 189, 130,
    41, 247, 55, 246, 166, 102, 244, 87, 245, 93, 21, 219, 137, 63,
    249, 172, 171, 109, 1, 111, 115, 57, 249, 159, 197, 0, 10, 139,
    104, 98, 36, 17, 200, 239, 67, 8, 217, 27, 141, 1, 89, 81, 221,
    20, 139, 214, 208, 71, 137, 160, 150, 45, 51, 128, 93, 238, 17,
    201, 58, 21, 20, 138, 115, 82, 72, 144, 141, 2, 59, 213, 189, 236,
    88, 168, 102, 36, 128, 125, 244, 89, 173, 218, 182, 66, 91, 80,
    163, 230, 145, 16, 186, 3, 114, 36, 158, 71, 2, 170, 10, 18, 78,
    129, 239, 205, 44, 159, 84, 52, 104, 120, 62, 105, 131, 133, 182,
    70, 69, 163, 82, 42, 64, 61, 209, 115, 20, 98, 59, 107, 154, 6,
    124, 139, 42, 40, 253, 79, 62, 40, 132, 202, 225, 80, 165, 128,
    136, 36, 83, 132, 10, 141, 130, 97, 60, 182, 116, 132, 54, 130,
    220, 42, 187, 146, 68, 212, 83, 17, 13, 163, 223, 154, 84, 247, 3,
    178, 64, 59, 34, 143, 166, 92, 144, 33, 152, 234, 127, 164, 83,
    64, 69, 192, 25, 29, 200, 239, 64, 136, 71, 172, 144, 0, 146, 100,
    158, 213, 141, 219, 113, 25, 172, 252, 26, 96, 115, 184, 64, 64,
    209, 221, 171, 74, 38, 202, 218, 19, 198, 170, 162, 126, 181, 172,
    131, 41, 17, 196, 209, 69, 33, 12, 32, 44, 88, 241, 204, 83, 130,
    215, 44, 17, 32, 204, 137, 28, 83, 18, 117, 185, 33, 96, 212, 84,
    201, 133, 37, 135, 3, 66, 123, 82, 232, 92, 50, 70, 68, 107, 84,
    239, 24, 176, 39, 68, 81, 12, 137, 108, 184, 101, 205, 199, 38,
    170, 10, 162, 38, 69, 142, 119, 15, 63, 20, 140, 193, 84, 183,
    231, 197, 18, 217, 18, 254, 163, 40, 129, 17, 76, 150, 209, 97,
    217, 217, 130, 239, 158, 77, 69, 33, 71, 42, 64, 117, 19, 38, 99,
    138, 101, 183, 109, 84, 44, 72, 28, 201, 230, 129, 128, 126, 40,
    2, 69, 144, 197, 57, 18, 35, 81, 64, 10, 102, 235, 108, 3, 28,
    159, 181, 61, 203, 202, 33, 32, 133, 29, 200, 172, 182, 242, 45,
    238, 35, 40, 154, 50, 168, 33, 73, 17, 243, 64, 182, 221, 13, 194,
    17, 86, 48, 157, 10, 193, 253, 173, 144, 110, 96, 10, 57, 198,
    192, 3, 201, 141, 208, 9, 9, 153, 186, 209, 162, 0, 160, 91, 151,
    144, 123, 75, 144, 72, 226, 14, 168, 253, 66, 21, 206, 244, 79,
    138, 75, 142, 134, 226, 91, 181, 112, 43, 179, 0, 204, 91, 96, 87,
    69, 235, 23, 45, 155, 142, 29, 89, 45, 13, 72, 146, 91, 239, 222,
    170, 2, 98, 161, 130, 204, 68, 73, 59, 38, 164, 81, 152, 192, 69,
    81, 228, 138, 40, 196, 116, 233, 146, 186, 147, 238, 57, 14, 244,
    224, 113, 227, 201, 168, 160, 67, 42, 149, 87, 5, 143, 115, 196,
    210, 170, 34, 0, 99, 55, 153, 44, 68, 193, 160, 204, 5, 182, 220,
    236, 64, 249, 166, 198, 64, 114, 197, 76, 104, 10, 1, 30, 166, 64,
    93, 32, 76, 141, 81, 22, 145, 88, 130, 247, 27, 238, 100, 80, 146,
    24, 201, 44, 60, 129, 255, 0, 20, 200, 21, 20, 177, 80, 9, 208,
    248, 20, 8, 66, 5, 38, 15, 230, 157, 28, 32, 4, 90, 32, 129, 245,
    26, 80, 22, 38, 9, 7, 152, 60, 211, 251, 220, 2, 99, 197, 1, 14,
    49, 35, 83, 223, 226, 164, 63, 83, 217, 36, 192, 222, 181, 84,
    108, 102, 52, 99, 205, 39, 208, 133, 84, 24, 110, 72, 160, 114,
    197, 166, 56, 236, 41, 2, 157, 2, 68, 9, 212, 115, 70, 37, 120,
    34, 71, 115, 186, 16, 0, 240, 6, 232, 29, 113, 1, 224, 192, 236,
    0, 169, 194, 151, 32, 158, 99, 154, 166, 193, 6, 53, 26, 17, 205,
    42, 182, 0, 179, 48, 2, 35, 116, 26, 229, 196, 114, 2, 17, 18, 63,
    138, 98, 224, 51, 42, 184, 129, 205, 74, 210, 255, 0, 152, 107,
    247, 13, 240, 169, 110, 2, 128, 218, 39, 230, 159, 208, 123, 66,
    210, 221, 37, 178, 222, 42, 156, 125, 234, 160, 7, 70, 16, 16, 71,
    192, 226, 156, 54, 34, 21, 20, 19, 241, 20, 160, 128, 72, 243,
    189, 214, 0, 161, 44, 64, 45, 242, 56, 168, 166, 7, 21, 19, 25,
    70, 200, 60, 82, 16, 155, 121, 109, 13, 86, 48, 4, 147, 51, 219,
    176, 160, 67, 92, 146, 68, 91, 31, 137, 160, 200, 50, 80, 202,
    237, 31, 53, 186, 123, 194, 207, 81, 233, 165, 166, 188, 228, 123,
    192, 215, 127, 52, 190, 173, 157, 151, 234, 173, 174, 35, 132, 34,
    106, 191, 225, 57, 139, 119, 46, 45, 182, 103, 184, 198, 12, 114,
    60, 238, 180, 202, 185, 116, 215, 122, 171, 151, 186, 171, 75,
    109, 17, 66, 170, 48, 159, 227, 239, 72, 246, 229, 139, 250, 65,
    16, 159, 108, 61, 118, 175, 78, 46, 89, 184, 151, 28, 44, 151, 37,
    162, 99, 219, 92, 173, 119, 166, 61, 61, 164, 86, 102, 184, 32,
    22, 154, 203, 72, 20, 114, 164, 7, 81, 50, 102, 56, 166, 91, 118,
    213, 66, 196, 129, 204, 158, 104, 24, 7, 226, 128, 36, 89, 12, 83,
    145, 34, 53, 20, 0, 166, 110, 182, 192, 49, 201, 251, 83, 220,
    188, 162, 18, 8, 81, 220, 138, 203, 111, 34, 222, 226, 50, 137,
    163, 42, 130, 20, 145, 31, 52, 11, 109, 208, 220, 33, 21, 99, 9,
    208, 172, 31, 218, 217, 6, 230, 0, 163, 156, 108, 0, 60, 152, 221,
    0, 144, 153, 155, 173, 26, 32, 10, 5, 185, 121, 7, 180, 185, 4,
    142, 32, 234, 143, 212, 33, 92, 239, 68, 248, 164, 184, 232, 110,
    37, 187, 87, 2, 187, 48, 12, 197, 182, 5, 116, 94, 177, 114, 217,
    184, 225, 213, 146, 208, 212, 137, 37, 190, 253, 234, 160, 38, 42,
    24, 44, 196, 68, 147, 178, 106, 69, 25, 140, 4, 85, 30, 72, 162,
    140, 71, 78, 153, 43, 169, 62, 227, 144, 239, 78, 7, 30, 60, 154,
    138, 4, 50, 169, 85, 112, 88, 247, 60, 77, 42, 162, 32, 6, 51,
    121, 146, 196, 76, 26, 12, 192, 91, 109, 206, 196, 15, 154, 108,
    100, 7, 44, 84, 198, 128, 160, 17, 234, 100, 5, 210, 4, 200, 213,
    17, 105, 21, 136, 47, 113, 190, 230, 69, 9, 33, 140, 146, 195,
    200, 31, 241, 76, 129, 81, 75, 21, 0, 157, 15, 129, 64, 132, 32,
    82, 96, 254, 105, 209, 194, 0, 69, 162, 8, 31, 81, 165, 1, 98, 96,
    144, 121, 131, 205, 63, 189, 192, 38, 60, 80, 16, 227, 18, 53, 61,
    254, 42, 67, 245, 61, 146, 76, 13, 235, 85, 70, 198, 99, 70, 60,
    210, 125, 8, 85, 65, 134, 228, 138, 2, 200, 130, 88, 185, 208,
    226, 153, 85, 8, 247, 172, 199, 0, 113, 83, 196, 17, 254, 161,
    198, 119, 151, 122, 46, 36, 204, 157, 68, 15, 138, 10, 59, 230,
    32, 129, 29, 252, 84, 208, 12, 1, 32, 100, 124, 118, 160, 89, 2,
    228, 88, 65, 19, 39, 189, 5, 97, 115, 65, 88, 0, 121, 52, 5, 193,
    194, 11, 76, 154, 157, 214, 185, 126, 242, 244, 182, 1, 16, 33,
    200, 28, 124, 83, 222, 80, 150, 89, 203, 251, 84, 100, 65, 248,
    174, 207, 240, 171, 62, 151, 75, 234, 148, 38, 245, 239, 118, 94,
    42, 161, 172, 127, 134, 244, 221, 61, 132, 70, 180, 173, 115, 101,
    139, 123, 136, 251, 210, 93, 233, 236, 116, 223, 173, 238, 101,
    181, 45, 232, 131, 175, 252, 87, 101, 231, 183, 211, 218, 15, 113,
    206, 77, 251, 64, 154, 230, 191, 126, 219, 116, 151, 23, 31, 123,
    130, 11, 26, 138, 157, 209, 212, 117, 45, 171, 22, 209, 15, 210,
    179, 181, 21, 205, 113, 109, 219, 18, 129, 129, 224, 65, 228, 215,
    106, 245, 88, 218, 192, 38, 79, 132, 22, 53, 200, 64, 87, 23, 9,
    218, 157, 14, 121, 160, 194, 213, 193, 112, 23, 42, 202, 190, 59,
    154, 104, 114, 73, 32, 3, 61, 232, 67, 33, 201, 253, 199, 57, 2,
    149, 230, 103, 40, 19, 199, 154, 2, 27, 11, 210, 222, 208, 7, 51,
    88, 58, 52, 153, 4, 159, 154, 24, 54, 80, 12, 179, 30, 99, 138,
    127, 210, 203, 11, 104, 52, 54, 213, 80, 186, 49, 58, 3, 193, 166,
    31, 72, 0, 100, 123, 10, 69, 68, 134, 110, 199, 193, 162, 72, 6,
    3, 152, 249, 168, 172, 229, 130, 25, 217, 58, 243, 88, 184, 69,
    145, 18, 59, 10, 80, 174, 110, 45, 199, 0, 32, 144, 7, 147, 79,
    131, 145, 238, 214, 90, 2, 120, 170, 133, 250, 66, 168, 50, 213,
    145, 49, 0, 183, 35, 176, 255, 0, 181, 62, 72, 146, 168, 210, 221,
    207, 49, 72, 211, 143, 4, 253, 142, 234, 40, 51, 98, 93, 238, 48,
    133, 6, 72, 164, 233, 58, 84, 234, 201, 189, 212, 182, 40, 76,
    173, 191, 35, 201, 165, 188, 162, 235, 90, 233, 198, 195, 185,
    200, 207, 97, 205, 123, 105, 109, 45, 90, 75, 80, 25, 155, 109,
    63, 182, 171, 46, 117, 232, 186, 99, 5, 173, 128, 20, 202, 129,
    175, 239, 82, 75, 190, 135, 84, 45, 91, 182, 110, 220, 112, 88,
    51, 29, 10, 233, 107, 253, 45, 182, 57, 92, 120, 241, 21, 11, 189,
    67, 191, 83, 110, 232, 68, 193, 83, 0, 179, 218, 163, 78, 114,
    151, 81, 166, 234, 40, 249, 28, 126, 40, 96, 75, 9, 32, 1, 184,
    154, 183, 85, 117, 29, 81, 118, 175, 220, 41, 169, 97, 115, 16,
    101, 84, 158, 73, 230, 131, 50, 41, 16, 101, 167, 248, 21, 43,
    233, 254, 97, 186, 123, 36, 149, 87, 62, 224, 167, 144, 59, 85,
    13, 149, 19, 149, 194, 223, 142, 105, 128, 25, 43, 240, 80, 202,
    253, 234, 163, 176, 116, 157, 61, 180, 10, 58, 123, 112, 56, 246,
    131, 85, 76, 218, 214, 22, 178, 1, 90, 4, 14, 42, 107, 213, 36,
    77, 197, 121, 240, 13, 78, 231, 95, 113, 213, 210, 202, 226, 38,
    0, 94, 77, 70, 151, 191, 121, 58, 78, 154, 229, 182, 189, 147,
    177, 141, 15, 166, 188, 228, 197, 152, 48, 80, 163, 136, 199, 116,
    85, 66, 25, 127, 117, 206, 72, 61, 143, 154, 89, 146, 119, 207,
    122, 136, 204, 136, 37, 139, 157, 14, 41, 149, 80, 143, 122, 204,
    112, 7, 21, 60, 65, 31, 234, 28, 103, 121, 119, 162, 226, 76, 201,
    212, 64, 248, 170, 40, 239, 152, 130, 4, 119, 241, 83, 64, 48, 4,
    129, 145, 241, 218, 129, 100, 11, 145, 97, 4, 76, 158, 244, 21,
    133, 205, 5, 96, 1, 228, 208, 23, 7, 8, 45, 50, 106, 119, 90, 229,
    251, 203, 210, 216, 4, 64, 135, 32, 113, 241, 79, 121, 66, 89,
    103, 47, 237, 81, 145, 7, 226, 187, 63, 194, 172, 250, 93, 47,
    170, 80, 155, 215, 189, 217, 120, 170, 134, 177, 254, 27, 211,
    116, 246, 17, 26, 210, 181, 205, 150, 45, 238, 35, 239, 73, 119,
    167, 177, 211, 126, 183, 185, 150, 212, 183, 162, 14, 191, 241,
    93, 151, 158, 223, 79, 104, 61, 199, 57, 55, 237, 2, 107, 154,
    253, 251, 109, 210, 92, 92, 125, 238, 8, 44, 106, 42, 119, 71, 81,
    212, 182, 172, 91, 68, 63, 74, 206, 212, 87, 53, 197, 183, 108,
    74, 6, 7, 129, 7, 147, 93, 171, 213, 99, 107, 0, 153, 62, 16, 88,
    215, 33, 1, 92, 92, 39, 106, 116, 57, 230, 131, 11, 87, 5, 192,
    92, 171, 42, 248, 238, 105, 161, 201, 36, 128, 12, 247, 161, 12,
    135, 39, 247, 28, 228, 10, 87, 153, 156, 160, 79, 30, 104, 8, 108,
    47, 75, 123, 64, 28, 205, 96, 232, 210, 100, 18, 126, 104, 96,
    217, 64, 50, 204, 121, 142, 41, 255, 0, 75, 44, 45, 160, 208, 219,
    85, 66, 232, 196, 232, 15, 6, 152, 125, 32, 1, 145, 236, 41, 21,
    18, 25, 187, 31, 6, 137, 32, 24, 14, 99, 230, 162, 179, 150, 8,
    103, 100, 235, 205, 98, 225, 22, 68, 72, 236, 41, 66, 185, 184,
    183, 28, 0, 130, 64, 30, 77, 62, 14, 71, 187, 89, 104, 9, 226,
    170, 20, 25, 144, 45, 229, 137, 131, 60, 214, 194, 230, 94, 235,
    101, 123, 140, 90, 103, 241, 77, 109, 203, 45, 199, 72, 85, 157,
    159, 39, 188, 80, 102, 104, 4, 19, 32, 212, 80, 22, 208, 196, 218,
    245, 35, 140, 180, 5, 57, 245, 29, 129, 103, 182, 170, 59, 10,
    217, 19, 39, 71, 189, 72, 17, 128, 146, 192, 198, 216, 138, 168,
    207, 101, 93, 138, 187, 150, 86, 17, 2, 189, 46, 146, 95, 165,
    182, 144, 37, 68, 16, 107, 129, 133, 185, 159, 84, 176, 243, 168,
    160, 111, 0, 21, 128, 98, 199, 250, 118, 104, 58, 250, 219, 96,
    178, 32, 186, 24, 175, 99, 251, 77, 115, 92, 96, 21, 80, 31, 104,
    57, 57, 249, 164, 13, 126, 225, 149, 176, 64, 61, 216, 199, 246,
    160, 65, 91, 37, 219, 18, 199, 184, 58, 158, 42, 41, 189, 247, 62,
    144, 21, 99, 69, 169, 144, 11, 108, 70, 220, 141, 201, 226, 153,
    201, 26, 7, 143, 205, 72, 50, 230, 7, 39, 192, 52, 20, 230, 167,
    108, 151, 30, 163, 60, 185, 58, 30, 43, 94, 37, 109, 57, 28, 198,
    183, 76, 228, 116, 246, 85, 64, 247, 1, 252, 154, 6, 148, 81, 25,
    73, 157, 153, 160, 140, 74, 18, 4, 41, 208, 249, 160, 187, 219,
    13, 131, 193, 20, 218, 114, 16, 14, 63, 138, 8, 187, 61, 219, 214,
    250, 123, 46, 169, 32, 146, 222, 63, 21, 91, 160, 244, 150, 212,
    222, 112, 192, 152, 6, 57, 169, 45, 198, 55, 146, 207, 77, 109,
    110, 58, 201, 98, 220, 1, 93, 183, 26, 46, 219, 187, 213, 89, 2,
    218, 33, 16, 130, 119, 85, 28, 227, 22, 182, 10, 201, 203, 131,
    205, 12, 19, 60, 152, 229, 255, 0, 199, 197, 93, 209, 220, 122,
    231, 4, 70, 218, 164, 238, 42, 4, 128, 50, 39, 66, 162, 178, 171,
    50, 7, 99, 110, 210, 246, 3, 152, 172, 82, 222, 139, 57, 98, 55,
    163, 253, 226, 133, 178, 125, 18, 207, 237, 247, 72, 159, 6, 153,
    61, 243, 115, 120, 240, 4, 115, 243, 64, 109, 42, 45, 235, 87, 21,
    4, 91, 59, 147, 230, 189, 49, 13, 250, 172, 224, 14, 126, 170,
    242, 240, 112, 161, 3, 196, 242, 13, 42, 251, 16, 206, 137, 242,
    104, 30, 227, 23, 188, 238, 88, 5, 157, 8, 230, 130, 179, 184, 55,
    53, 28, 44, 247, 52, 139, 36, 24, 1, 137, 226, 120, 53, 70, 208,
    8, 28, 24, 31, 138, 1, 136, 182, 164, 147, 157, 195, 203, 80, 103,
    49, 49, 144, 248, 52, 12, 177, 136, 49, 222, 139, 76, 4, 83, 31,
    246, 170, 128, 136, 8, 46, 192, 201, 58, 237, 21, 160, 141, 153,
    62, 13, 80, 203, 164, 118, 3, 117, 57, 8, 34, 116, 52, 79, 21, 20,
    100, 129, 219, 124, 26, 196, 139, 105, 237, 217, 237, 174, 245,
    134, 44, 232, 24, 72, 231, 226, 138, 34, 3, 152, 217, 61, 207, 2,
    170, 49, 75, 182, 214, 50, 82, 123, 206, 191, 138, 88, 117, 246,
    50, 144, 79, 244, 238, 139, 186, 228, 196, 158, 62, 107, 41, 33,
    56, 130, 119, 196, 84, 80, 6, 100, 11, 121, 98, 96, 207, 53, 176,
    185, 151, 186, 217, 94, 227, 22, 153, 252, 83, 91, 114, 203, 113,
    210, 21, 103, 103, 201, 239, 20, 25, 154, 1, 4, 200, 52, 0, 91,
    67, 19, 107, 212, 142, 50, 208, 20, 231, 212, 118, 5, 158, 218,
    168, 236, 43, 100, 76, 157, 30, 245, 32, 70, 2, 75, 3, 27, 98, 42,
    163, 61, 149, 118, 42, 238, 89, 88, 68, 10, 244, 186, 73, 126,
    150, 218, 64, 149, 16, 65, 174, 6, 22, 230, 125, 82, 195, 206,
    162, 129, 188, 0, 86, 1, 139, 31, 233, 217, 160, 235, 235, 109,
    130, 200, 130, 232, 98, 189, 143, 237, 53, 205, 113, 128, 85, 64,
    125, 160, 228, 231, 230, 144, 53, 251, 134, 86, 193, 0, 247, 99,
    31, 218, 129, 5, 108, 151, 108, 75, 30, 224, 234, 120, 168, 166,
    247, 220, 250, 64, 85, 141, 22, 166, 64, 45, 177, 27, 114, 55, 39,
    138, 103, 36, 104, 30, 63, 53, 32, 203, 152, 28, 159, 0, 208, 83,
    154, 157, 178, 92, 122, 140, 242, 228, 232, 120, 173, 120, 149,
    180, 228, 115, 26, 221, 51, 145, 211, 217, 85, 3, 220, 7, 242,
    104, 26, 81, 68, 101, 38, 118, 102, 130, 49, 40, 72, 16, 167, 67,
    230, 130, 239, 108, 54, 15, 4, 83, 105, 200, 64, 56, 254, 40, 34,
    236, 247, 111, 91, 233, 236, 186, 164, 130, 75, 120, 252, 85, 110,
    131, 210, 91, 83, 121, 195, 2, 96, 24, 230, 164, 183, 24, 222, 75,
    61, 53, 181, 184, 235, 37, 139, 112, 5, 118, 220, 104, 187, 110,
    239, 85, 100, 11, 104, 132, 66, 9, 221, 84, 115, 140, 90, 216, 43,
    39, 46, 15, 52, 48, 76, 242, 99, 151, 255, 0, 31, 21, 119, 71,
    113, 235, 156, 17, 27, 106, 147, 184, 168, 18, 0, 200, 157, 10,
    138, 44, 233, 110, 216, 183, 176, 23, 91, 169, 171, 151, 230, 62,
    194, 170, 138, 138, 185, 25, 98, 222, 117, 65, 157, 158, 224, 182,
    161, 64, 137, 38, 59, 80, 34, 169, 244, 152, 49, 80, 64, 136, 240,
    42, 137, 34, 73, 60, 174, 162, 151, 211, 44, 67, 22, 76, 126, 23,
    159, 154, 71, 233, 255, 0, 204, 117, 73, 110, 227, 227, 107, 19,
    161, 220, 213, 70, 183, 131, 11, 142, 45, 6, 1, 177, 17, 193, 170,
    143, 83, 41, 119, 195, 188, 32, 167, 234, 122, 102, 233, 172, 218,
    181, 211, 90, 118, 13, 63, 87, 3, 230, 164, 200, 246, 238, 48,
    184, 88, 220, 2, 98, 162, 154, 125, 216, 143, 104, 228, 73, 165,
    75, 86, 241, 25, 172, 193, 208, 147, 2, 179, 2, 54, 62, 160, 100,
    79, 154, 4, 131, 108, 203, 64, 35, 154, 0, 75, 117, 12, 203, 104,
    128, 63, 123, 246, 21, 72, 68, 1, 20, 72, 2, 9, 35, 154, 192, 159,
    69, 64, 42, 7, 129, 75, 13, 49, 49, 65, 133, 187, 115, 182, 32,
    13, 196, 234, 136, 192, 203, 230, 89, 143, 127, 20, 160, 32, 118,
    44, 160, 129, 0, 86, 0, 135, 109, 1, 150, 193, 21, 80, 243, 32,
    201, 199, 228, 246, 174, 102, 234, 108, 22, 40, 151, 24, 219, 93,
    187, 42, 147, 63, 19, 20, 111, 163, 92, 91, 125, 58, 233, 9, 80,
    204, 59, 15, 21, 235, 45, 128, 170, 182, 173, 176, 75, 75, 168,
    65, 12, 212, 28, 63, 225, 135, 59, 151, 174, 4, 101, 70, 140, 73,
    214, 128, 175, 73, 109, 228, 82, 65, 80, 199, 189, 16, 114, 2,
    221, 171, 67, 241, 73, 126, 224, 233, 214, 1, 202, 231, 19, 253,
    53, 26, 112, 171, 89, 179, 101, 237, 224, 75, 130, 125, 204, 103,
    189, 64, 32, 118, 32, 157, 13, 157, 211, 149, 66, 202, 15, 36,
    229, 170, 119, 22, 246, 170, 33, 124, 10, 172, 164, 101, 199, 212,
    9, 114, 49, 3, 227, 189, 23, 14, 27, 12, 243, 142, 220, 83, 164,
    162, 155, 133, 3, 49, 16, 24, 118, 20, 179, 51, 29, 170, 40, 42,
    32, 137, 12, 35, 177, 61, 232, 229, 193, 98, 1, 39, 75, 28, 83, 0,
    20, 73, 114, 206, 78, 201, 21, 177, 130, 75, 25, 184, 121, 248,
    160, 84, 151, 110, 0, 222, 140, 214, 102, 85, 34, 117, 58, 172, 1,
    19, 4, 0, 126, 40, 162, 12, 189, 91, 144, 72, 210, 47, 143, 154,
    5, 82, 73, 50, 73, 51, 226, 178, 49, 55, 24, 41, 146, 218, 143,
    138, 192, 98, 167, 30, 79, 111, 21, 173, 140, 3, 96, 76, 177, 231,
    189, 6, 123, 128, 40, 181, 105, 51, 184, 116, 107, 11, 74, 135,
    43, 228, 59, 129, 33, 7, 210, 180, 225, 209, 22, 17, 113, 158,
    253, 205, 42, 33, 121, 217, 128, 76, 213, 66, 201, 43, 0, 133, 99,
    199, 218, 159, 4, 35, 38, 202, 7, 16, 99, 42, 38, 11, 8, 208, 160,
    192, 177, 4, 184, 197, 71, 17, 81, 64, 218, 66, 144, 192, 130,
    251, 39, 184, 172, 81, 154, 97, 164, 48, 136, 61, 171, 2, 73, 23,
    26, 54, 116, 38, 182, 100, 145, 9, 198, 228, 138, 168, 44, 233,
    110, 216, 183, 176, 23, 91, 169, 171, 151, 230, 62, 194, 170, 138,
    138, 185, 25, 98, 222, 117, 65, 157, 158, 224, 182, 161, 64, 137,
    38, 59, 84, 82, 42, 159, 73, 131, 21, 4, 8, 143, 2, 168, 146, 36,
    147, 202, 234, 41, 125, 50, 196, 49, 100, 199, 225, 121, 249, 164,
    126, 159, 252, 199, 84, 150, 238, 62, 54, 177, 58, 29, 205, 84,
    107, 120, 48, 184, 226, 208, 96, 27, 17, 28, 26, 168, 245, 50,
    151, 124, 59, 194, 10, 126, 167, 166, 110, 154, 205, 171, 93, 53,
    167, 96, 211, 245, 112, 62, 106, 76, 143, 110, 227, 11, 133, 141,
    192, 38, 42, 41, 167, 221, 136, 246, 142, 68, 154, 84, 181, 111,
    17, 154, 204, 29, 9, 48, 43, 48, 35, 99, 234, 6, 68, 249, 160, 72,
    54, 204, 180, 2, 57, 160, 4, 183, 80, 204, 182, 136, 3, 247, 191,
    97, 84, 132, 64, 17, 68, 128, 32, 146, 57, 172, 9, 244, 84, 2,
    160, 120, 20, 176, 211, 19, 20, 24, 91, 183, 59, 98, 0, 220, 78,
    168, 140, 12, 190, 101, 152, 247, 241, 74, 2, 7, 98, 202, 8, 16,
    5, 96, 8, 118, 208, 25, 108, 17, 85, 15, 50, 12, 156, 126, 79,
    106, 230, 110, 166, 193, 98, 137, 113, 141, 181, 219, 178, 169,
    51, 241, 49, 70, 250, 53, 197, 183, 211, 174, 144, 149, 12, 195,
    176, 241, 94, 178, 216, 10, 171, 106, 219, 4, 180, 186, 132, 16,
    205, 65, 195, 254, 24, 115, 185, 122, 224, 70, 84, 104, 196, 157,
    104, 10, 244, 150, 222, 69, 36, 21, 12, 123, 209, 7, 32, 45, 218,
    180, 63, 20, 151, 238, 14, 157, 96, 28, 174, 113, 63, 211, 81,
    167, 10, 181, 155, 54, 94, 222, 4, 184, 39, 220, 198, 123, 212, 2,
    7, 98, 9, 208, 217, 221, 57, 84, 44, 160, 242, 78, 90, 167, 113,
    111, 106, 162, 23, 192, 170, 202, 88, 187, 233, 26, 214, 185, 150,
    221, 96, 183, 109, 230, 229, 173, 201, 215, 60, 10, 118, 33, 109,
    174, 43, 0, 14, 59, 212, 122, 140, 109, 217, 119, 36, 183, 27,
    252, 212, 85, 88, 146, 152, 200, 152, 220, 82, 91, 15, 123, 170,
    9, 105, 141, 181, 182, 1, 46, 57, 147, 90, 58, 139, 170, 110, 158,
    145, 97, 140, 137, 112, 166, 43, 167, 161, 177, 113, 5, 247, 185,
    25, 220, 35, 75, 251, 71, 137, 170, 138, 100, 235, 120, 186, 94,
    61, 69, 208, 152, 15, 84, 241, 92, 238, 214, 222, 215, 174, 175,
    113, 238, 240, 204, 6, 135, 154, 245, 122, 123, 78, 193, 152, 192,
    197, 120, 97, 255, 0, 218, 188, 193, 117, 214, 122, 101, 54, 197,
    182, 146, 113, 214, 166, 162, 165, 233, 2, 13, 199, 114, 79, 0,
    14, 194, 155, 7, 192, 42, 219, 4, 113, 205, 6, 185, 147, 1, 108,
    101, 6, 53, 197, 0, 8, 92, 217, 199, 213, 16, 40, 8, 85, 81, 0,
    127, 6, 131, 2, 117, 220, 235, 124, 81, 141, 131, 222, 181, 196,
    5, 75, 92, 114, 4, 125, 32, 243, 65, 131, 40, 56, 233, 238, 19,
    176, 189, 190, 244, 28, 51, 44, 152, 202, 103, 91, 170, 59, 20,
    132, 182, 21, 71, 129, 222, 145, 87, 25, 0, 228, 211, 145, 142, 5,
    1, 56, 186, 12, 128, 61, 200, 61, 170, 214, 58, 175, 77, 36, 160,
    147, 198, 207, 21, 21, 71, 80, 193, 238, 41, 118, 220, 40, 226,
    155, 4, 64, 16, 115, 220, 205, 5, 159, 172, 186, 87, 12, 176, 83,
    251, 71, 154, 230, 36, 147, 61, 183, 67, 49, 235, 5, 212, 129, 36,
    247, 20, 25, 2, 219, 102, 105, 95, 151, 241, 85, 14, 138, 77, 178,
    224, 109, 142, 167, 138, 86, 144, 166, 68, 255, 0, 211, 186, 103,
    112, 45, 172, 100, 68, 107, 157, 210, 53, 204, 39, 32, 65, 237,
    29, 234, 40, 61, 209, 4, 135, 26, 253, 177, 84, 113, 233, 89, 0,
    157, 129, 36, 214, 183, 109, 238, 16, 247, 213, 18, 216, 51, 7,
    234, 160, 229, 11, 207, 8, 12, 196, 243, 85, 12, 137, 138, 102,
    127, 118, 192, 34, 148, 19, 113, 240, 83, 175, 220, 222, 42, 96,
    155, 236, 66, 142, 221, 143, 63, 21, 133, 135, 187, 212, 27, 79,
    121, 173, 90, 80, 61, 168, 99, 159, 38, 130, 144, 170, 103, 51,
    136, 238, 104, 185, 8, 171, 32, 230, 76, 69, 11, 182, 197, 142,
    173, 44, 149, 187, 115, 17, 145, 129, 49, 226, 107, 16, 89, 243,
    32, 230, 78, 190, 40, 54, 15, 26, 42, 60, 152, 172, 9, 55, 177,
    88, 32, 15, 115, 79, 21, 154, 218, 219, 62, 201, 147, 201, 39,
    147, 65, 45, 27, 146, 24, 156, 9, 146, 69, 1, 73, 118, 32, 111,
    230, 43, 9, 68, 2, 7, 243, 76, 204, 98, 23, 107, 226, 55, 83, 32,
    51, 166, 76, 21, 65, 147, 81, 76, 176, 87, 218, 105, 116, 207,
    132, 228, 6, 216, 246, 166, 33, 12, 62, 97, 73, 152, 131, 218,
    131, 42, 217, 233, 202, 2, 25, 155, 150, 61, 205, 84, 53, 168, 91,
    11, 161, 63, 247, 160, 75, 146, 0, 147, 240, 40, 140, 91, 217, 26,
    195, 102, 123, 138, 80, 153, 41, 57, 21, 183, 220, 207, 63, 106,
    138, 24, 187, 233, 26, 214, 185, 150, 221, 96, 183, 109, 230, 229,
    173, 201, 215, 60, 10, 118, 33, 109, 174, 43, 0, 14, 59, 212, 122,
    140, 109, 217, 119, 36, 183, 27, 252, 208, 85, 137, 41, 140, 137,
    141, 197, 37, 176, 247, 186, 160, 150, 152, 219, 91, 96, 18, 227,
    153, 53, 163, 168, 186, 166, 233, 233, 22, 24, 200, 151, 10, 98,
    186, 122, 27, 23, 16, 95, 123, 145, 157, 194, 52, 191, 180, 120,
    154, 168, 166, 78, 183, 139, 165, 227, 212, 93, 9, 128, 245, 79,
    21, 206, 237, 109, 237, 122, 234, 247, 30, 239, 12, 192, 104, 121,
    175, 87, 167, 180, 236, 25, 140, 12, 87, 134, 31, 253, 171, 204,
    23, 93, 103, 166, 83, 108, 91, 105, 39, 29, 106, 106, 42, 94, 144,
    32, 220, 119, 36, 240, 0, 236, 41, 176, 124, 2, 173, 176, 71, 28,
    208, 107, 153, 48, 22, 198, 80, 99, 92, 80, 0, 133, 205, 156, 125,
    81, 2, 128, 133, 85, 16, 7, 240, 104, 48, 39, 93, 206, 183, 197,
    24, 216, 61, 235, 92, 64, 84, 181, 199, 32, 71, 210, 15, 52, 24,
    50, 131, 142, 158, 225, 59, 11, 219, 239, 65, 195, 50, 201, 140,
    166, 117, 186, 163, 177, 72, 75, 97, 84, 120, 29, 233, 21, 113,
    144, 14, 77, 57, 24, 224, 80, 19, 139, 160, 200, 3, 220, 131, 218,
    173, 99, 170, 244, 210, 74, 9, 60, 108, 241, 81, 84, 117, 12, 30,
    226, 151, 109, 194, 142, 41, 176, 68, 1, 7, 61, 204, 208, 89, 250,
    203, 165, 112, 203, 5, 63, 180, 121, 174, 98, 73, 51, 219, 116,
    51, 30, 176, 93, 72, 18, 79, 113, 65, 144, 45, 182, 102, 149, 249,
    127, 21, 80, 232, 164, 219, 46, 6, 216, 234, 120, 165, 105, 10,
    100, 79, 253, 59, 166, 119, 2, 218, 198, 68, 70, 185, 221, 35, 92,
    194, 114, 4, 30, 209, 222, 162, 153, 6, 182, 240, 0, 237, 222,
    161, 212, 168, 123, 74, 20, 232, 56, 49, 231, 123, 174, 132, 39,
    133, 217, 254, 107, 42, 67, 2, 78, 70, 32, 154, 168, 244, 130,
    139, 172, 206, 190, 219, 99, 130, 220, 154, 163, 132, 65, 36, 149,
    70, 212, 247, 53, 192, 189, 85, 224, 176, 28, 170, 70, 135, 138,
    149, 235, 175, 112, 16, 206, 88, 158, 55, 197, 72, 181, 211, 212,
    245, 195, 3, 102, 215, 182, 223, 4, 159, 221, 92, 54, 208, 3, 118,
    227, 130, 75, 113, 62, 41, 237, 224, 182, 65, 8, 13, 195, 201,
    109, 238, 131, 144, 62, 182, 153, 254, 245, 80, 32, 102, 20, 0,
    20, 9, 250, 123, 209, 40, 184, 201, 94, 242, 62, 244, 195, 80, 72,
    202, 62, 41, 76, 29, 180, 226, 60, 248, 168, 165, 192, 57, 213,
    178, 88, 158, 65, 129, 89, 237, 219, 69, 95, 86, 229, 194, 73,
    250, 84, 243, 84, 5, 204, 152, 197, 8, 142, 98, 105, 81, 81, 61,
    216, 239, 183, 122, 168, 157, 230, 4, 31, 124, 19, 4, 44, 238,
    168, 242, 50, 80, 164, 15, 138, 42, 168, 80, 92, 100, 82, 91, 202,
    246, 251, 209, 121, 36, 78, 129, 241, 226, 162, 130, 40, 89, 36,
    147, 113, 187, 118, 2, 149, 136, 69, 45, 63, 222, 182, 54, 203,
    16, 110, 92, 144, 56, 154, 198, 210, 125, 94, 179, 16, 166, 119,
    186, 3, 111, 244, 109, 201, 99, 147, 12, 140, 141, 209, 180, 138,
    3, 220, 123, 121, 49, 60, 183, 138, 77, 59, 146, 164, 176, 95,
    138, 161, 75, 142, 76, 172, 2, 53, 189, 80, 27, 175, 113, 208,
    226, 96, 246, 165, 176, 21, 23, 53, 95, 212, 63, 184, 153, 164,
    91, 61, 75, 116, 201, 116, 50, 230, 228, 226, 132, 68, 9, 172,
    161, 69, 231, 178, 72, 47, 201, 0, 72, 7, 239, 85, 14, 73, 112,
    73, 57, 22, 230, 104, 17, 44, 2, 250, 115, 218, 104, 225, 237,
    128, 208, 79, 36, 10, 70, 100, 180, 140, 229, 130, 168, 229, 141,
    3, 155, 145, 105, 66, 129, 19, 30, 193, 19, 75, 101, 122, 155,
    189, 67, 132, 41, 108, 47, 180, 146, 39, 126, 41, 83, 169, 124,
    15, 165, 211, 94, 97, 204, 226, 63, 228, 215, 95, 65, 102, 229,
    187, 14, 110, 128, 172, 238, 94, 39, 143, 20, 25, 46, 245, 22, 22,
    229, 230, 81, 113, 218, 37, 151, 92, 84, 238, 132, 7, 212, 255, 0,
    50, 110, 220, 127, 123, 0, 56, 251, 87, 117, 172, 25, 175, 0, 50,
    66, 134, 124, 87, 3, 117, 0, 116, 34, 202, 219, 1, 83, 247, 119,
    168, 169, 6, 6, 49, 6, 73, 129, 84, 18, 170, 68, 12, 70, 167, 230,
    179, 17, 98, 217, 39, 152, 129, 83, 8, 134, 218, 160, 99, 49, 46,
    102, 129, 131, 18, 120, 38, 119, 49, 64, 39, 180, 150, 144, 79,
    96, 41, 139, 198, 130, 146, 35, 176, 162, 36, 16, 100, 253, 162,
    170, 19, 5, 196, 179, 0, 79, 111, 110, 232, 165, 139, 69, 140,
    130, 0, 249, 217, 165, 180, 70, 59, 36, 146, 73, 159, 205, 49, 95,
    118, 89, 147, 60, 205, 69, 56, 100, 153, 192, 71, 111, 181, 35,
    51, 49, 27, 30, 62, 213, 184, 227, 117, 142, 129, 61, 254, 79, 52,
    25, 6, 182, 240, 0, 237, 222, 161, 212, 168, 123, 74, 20, 232, 56,
    49, 231, 123, 174, 132, 39, 133, 217, 254, 107, 42, 67, 2, 78, 70,
    32, 154, 168, 244, 130, 139, 172, 206, 190, 219, 99, 130, 220,
    154, 163, 132, 65, 36, 149, 70, 212, 247, 53, 192, 189, 85, 224,
    176, 28, 170, 70, 135, 138, 149, 235, 175, 112, 16, 206, 88, 158,
    55, 197, 72, 181, 211, 212, 245, 195, 3, 102, 215, 182, 223, 4,
    159, 221, 92, 54, 208, 3, 118, 227, 130, 75, 113, 62, 41, 237,
    224, 182, 65, 8, 13, 195, 201, 109, 238, 131, 144, 62, 182, 153,
    254, 245, 80, 32, 102, 20, 0, 20, 9, 250, 123, 209, 40, 184, 201,
    94, 242, 62, 244, 195, 80, 72, 202, 62, 41, 76, 29, 180, 226, 60,
    248, 168, 165, 192, 57, 213, 178, 88, 158, 65, 129, 89, 237, 219,
    69, 95, 86, 229, 194, 73, 250, 84, 243, 84, 5, 204, 152, 197, 8,
    142, 98, 105, 81, 81, 61, 216, 239, 183, 122, 168, 157, 230, 4,
    31, 124, 19, 4, 44, 238, 168, 242, 50, 80, 164, 15, 138, 42, 168,
    80, 92, 100, 82, 91, 202, 246, 251, 209, 121, 36, 78, 129, 241,
    226, 162, 130, 40, 89, 36, 147, 113, 187, 118, 2, 149, 136, 69,
    45, 63, 222, 182, 54, 203, 16, 110, 92, 144, 56, 154, 198, 210,
    125, 94, 179, 16, 166, 119, 186, 3, 111, 244, 109, 201, 99, 147,
    12, 140, 141, 209, 180, 138, 3, 220, 123, 121, 49, 60, 183, 138,
    77, 59, 146, 164, 176, 95, 138, 161, 75, 142, 76, 172, 2, 53, 189,
    80, 27, 175, 113, 208, 226, 96, 246, 165, 176, 21, 23, 53, 95,
    212, 63, 184, 153, 164, 91, 61, 75, 116, 201, 116, 50, 230, 228,
    226, 132, 68, 9, 172, 161, 69, 231, 178, 72, 47, 201, 0, 72, 7,
    239, 85, 20, 80, 2, 133, 4, 129, 220, 247, 165, 119, 2, 45, 168,
    147, 28, 80, 33, 157, 81, 23, 67, 131, 186, 2, 202, 162, 178, 181,
    204, 102, 51, 84, 255, 0, 147, 64, 202, 142, 235, 145, 33, 87,
    255, 0, 119, 72, 35, 100, 43, 93, 99, 161, 3, 64, 124, 213, 92,
    161, 32, 23, 33, 71, 106, 91, 127, 232, 226, 135, 21, 83, 192,
    239, 65, 146, 217, 0, 169, 39, 35, 227, 181, 24, 68, 217, 18, 126,
    220, 80, 47, 128, 40, 188, 13, 243, 201, 165, 244, 157, 220, 250,
    140, 17, 72, 144, 59, 208, 31, 80, 200, 25, 65, 142, 70, 205, 96,
    90, 1, 10, 118, 121, 106, 112, 233, 108, 194, 128, 24, 158, 124,
    208, 146, 78, 234, 41, 73, 185, 118, 230, 54, 246, 99, 109, 58,
    90, 96, 8, 66, 171, 177, 38, 90, 121, 172, 128, 184, 116, 47, 141,
    181, 236, 63, 119, 230, 139, 144, 89, 16, 105, 5, 1, 99, 160, 38,
    99, 85, 23, 17, 113, 63, 168, 157, 127, 181, 60, 0, 12, 29, 129,
    16, 41, 109, 219, 139, 162, 227, 54, 192, 160, 171, 170, 229, 17,
    49, 81, 100, 37, 78, 23, 52, 103, 76, 41, 192, 150, 99, 145, 104,
    165, 117, 9, 103, 158, 4, 80, 6, 184, 58, 126, 144, 179, 169, 50,
    120, 2, 100, 241, 70, 215, 65, 123, 168, 81, 119, 170, 124, 87,
    156, 36, 192, 255, 0, 189, 53, 139, 103, 168, 255, 0, 16, 69, 51,
    233, 244, 232, 9, 158, 9, 237, 94, 170, 35, 187, 70, 149, 38, 89,
    155, 197, 90, 71, 18, 244, 86, 237, 39, 233, 93, 184, 24, 52, 8,
    58, 26, 236, 13, 42, 245, 24, 216, 110, 158, 213, 146, 215, 20,
    195, 55, 31, 115, 38, 187, 146, 253, 149, 204, 45, 192, 196, 30,
    43, 155, 167, 123, 86, 111, 93, 123, 191, 168, 247, 31, 34, 99,
    138, 131, 144, 12, 20, 122, 135, 220, 116, 106, 70, 218, 191, 85,
    210, 219, 62, 224, 26, 92, 246, 7, 255, 0, 69, 116, 245, 111, 110,
    237, 209, 115, 211, 69, 0, 143, 167, 90, 169, 130, 236, 207, 233,
    174, 42, 63, 141, 85, 71, 170, 200, 2, 225, 108, 98, 23, 191, 245,
    82, 186, 170, 46, 119, 9, 9, 58, 203, 247, 87, 37, 190, 178, 244,
    68, 38, 135, 49, 81, 123, 151, 122, 139, 204, 1, 12, 227, 247, 77,
    72, 181, 209, 119, 168, 119, 24, 8, 181, 110, 56, 94, 90, 185, 24,
    230, 232, 32, 108, 243, 226, 41, 241, 150, 36, 251, 136, 212, 207,
    53, 130, 162, 156, 136, 147, 254, 212, 10, 226, 90, 124, 83, 175,
    63, 255, 0, 52, 128, 33, 45, 43, 201, 237, 170, 86, 31, 164, 196,
    22, 16, 40, 10, 92, 195, 30, 196, 137, 230, 132, 49, 89, 37, 160,
    119, 226, 105, 149, 45, 250, 155, 65, 128, 28, 145, 179, 76, 85,
    93, 182, 97, 120, 0, 24, 160, 88, 3, 210, 45, 161, 227, 227, 189,
    43, 150, 114, 125, 54, 85, 79, 234, 106, 163, 186, 9, 228, 246, 0,
    82, 160, 86, 105, 186, 190, 97, 42, 162, 74, 194, 26, 221, 178,
    215, 79, 114, 5, 80, 37, 197, 10, 89, 224, 177, 136, 137, 53, 64,
    237, 140, 170, 98, 59, 1, 72, 8, 64, 50, 25, 92, 34, 32, 246, 160,
    101, 0, 40, 80, 72, 29, 207, 122, 87, 112, 34, 218, 137, 49, 197,
    2, 25, 213, 17, 116, 56, 59, 160, 44, 170, 43, 43, 92, 198, 99,
    53, 79, 249, 52, 12, 168, 238, 185, 18, 21, 127, 247, 116, 130,
    54, 66, 181, 214, 58, 16, 52, 7, 205, 85, 202, 18, 1, 114, 20,
    118, 165, 183, 254, 142, 40, 113, 85, 60, 14, 244, 25, 45, 144,
    10, 146, 114, 62, 59, 81, 132, 77, 145, 39, 237, 197, 2, 248, 2,
    139, 192, 223, 60, 154, 95, 73, 221, 207, 168, 193, 20, 137, 3,
    189, 1, 245, 12, 129, 148, 24, 228, 108, 214, 5, 160, 16, 167,
    103, 150, 167, 14, 150, 204, 40, 1, 137, 231, 205, 9, 36, 238,
    162, 148, 155, 151, 110, 99, 111, 102, 54, 211, 165, 166, 0, 132,
    42, 187, 18, 101, 167, 154, 200, 11, 135, 66, 248, 219, 94, 195,
    247, 126, 104, 185, 5, 145, 6, 144, 80, 22, 58, 2, 102, 53, 81,
    113, 23, 19, 250, 137, 215, 251, 83, 192, 0, 193, 216, 17, 2, 150,
    221, 184, 186, 46, 51, 108, 10, 10, 186, 174, 81, 19, 21, 22, 66,
    84, 225, 115, 70, 116, 194, 156, 9, 102, 57, 22, 138, 87, 80, 150,
    121, 224, 69, 0, 107, 131, 167, 233, 11, 58, 147, 39, 128, 38, 79,
    20, 109, 116, 23, 186, 133, 23, 122, 167, 197, 121, 194, 76, 15,
    251, 211, 88, 182, 122, 143, 241, 4, 83, 62, 159, 78, 128, 153,
    224, 158, 213, 234, 162, 59, 180, 105, 82, 101, 153, 188, 85, 164,
    113, 47, 69, 110, 210, 126, 149, 219, 129, 131, 64, 131, 161, 174,
    192, 210, 175, 81, 141, 134, 233, 237, 89, 45, 113, 76, 51, 113,
    247, 50, 107, 185, 47, 217, 92, 194, 220, 12, 65, 226, 185, 186,
    119, 181, 102, 245, 215, 187, 250, 143, 113, 242, 38, 56, 168, 57,
    164, 51, 44, 72, 4, 207, 226, 144, 178, 148, 193, 82, 1, 228, 209,
    25, 103, 204, 44, 127, 52, 193, 85, 87, 80, 92, 247, 160, 80, 64,
    66, 21, 50, 98, 96, 152, 172, 168, 75, 70, 24, 22, 7, 95, 111,
    255, 0, 105, 109, 159, 80, 179, 47, 208, 186, 252, 213, 18, 17,
    134, 35, 103, 243, 65, 176, 85, 83, 6, 88, 247, 60, 208, 69, 15,
    115, 57, 39, 31, 108, 82, 51, 146, 216, 41, 10, 63, 123, 120, 20,
    200, 128, 170, 144, 25, 109, 198, 167, 69, 168, 54, 35, 144, 55,
    88, 90, 25, 22, 46, 241, 255, 0, 86, 171, 16, 199, 247, 64, 248,
    20, 128, 169, 96, 23, 39, 35, 191, 106, 6, 16, 110, 128, 163, 157,
    106, 143, 105, 228, 197, 58, 38, 0, 181, 200, 44, 220, 47, 138,
    146, 64, 4, 126, 224, 209, 136, 21, 80, 196, 45, 187, 100, 228,
    18, 79, 52, 4, 176, 246, 158, 252, 129, 52, 201, 104, 35, 122,
    151, 125, 205, 251, 65, 224, 82, 220, 99, 233, 144, 32, 19, 220,
    212, 86, 80, 24, 8, 153, 36, 177, 172, 64, 196, 146, 71, 142, 105,
    210, 220, 32, 5, 136, 88, 252, 159, 181, 77, 154, 208, 48, 86, 71,
    101, 137, 160, 167, 71, 237, 188, 237, 142, 238, 128, 103, 228,
    14, 43, 210, 117, 9, 98, 227, 220, 48, 48, 246, 205, 121, 150,
    208, 148, 203, 210, 107, 112, 117, 39, 99, 241, 69, 220, 144, 136,
    110, 179, 9, 136, 61, 166, 130, 118, 145, 205, 129, 188, 100, 109,
    207, 39, 237, 77, 130, 5, 204, 150, 50, 60, 211, 92, 33, 45, 132,
    28, 129, 31, 154, 95, 78, 66, 43, 185, 32, 239, 17, 226, 170, 38,
    150, 146, 224, 5, 228, 47, 101, 6, 172, 228, 29, 29, 39, 96, 43,
    7, 146, 7, 2, 38, 15, 53, 176, 202, 102, 34, 162, 148, 32, 42, 84,
    19, 242, 221, 233, 128, 91, 105, 130, 130, 59, 177, 61, 233, 67,
    251, 72, 84, 227, 115, 20, 169, 55, 113, 98, 88, 91, 2, 62, 230,
    129, 203, 128, 60, 0, 56, 20, 17, 102, 197, 178, 73, 147, 38, 103,
    183, 106, 12, 184, 172, 4, 6, 71, 218, 142, 23, 48, 89, 86, 10,
    160, 1, 177, 252, 208, 12, 8, 85, 0, 128, 23, 180, 80, 123, 168,
    170, 50, 97, 7, 129, 230, 177, 182, 12, 1, 50, 121, 32, 255, 0,
    53, 84, 91, 93, 63, 130, 222, 76, 24, 160, 76, 221, 236, 134, 51,
    197, 28, 245, 36, 197, 0, 230, 238, 114, 250, 15, 168, 160, 227,
    20, 59, 10, 20, 106, 57, 53, 80, 29, 241, 208, 80, 7, 0, 3, 88, 6,
    50, 236, 2, 193, 214, 255, 0, 154, 162, 90, 22, 156, 220, 51, 113,
    200, 208, 39, 138, 80, 210, 176, 219, 105, 157, 212, 82, 21, 23,
    47, 190, 123, 0, 123, 64, 208, 171, 64, 72, 208, 0, 25, 128, 57,
    161, 108, 42, 27, 151, 32, 179, 19, 19, 64, 169, 14, 162, 84, 19,
    230, 128, 200, 102, 88, 144, 9, 159, 197, 33, 101, 41, 130, 164,
    3, 201, 162, 50, 207, 152, 88, 254, 105, 130, 170, 174, 160, 185,
    239, 64, 160, 128, 132, 42, 100, 196, 193, 49, 89, 80, 150, 140,
    48, 44, 14, 190, 223, 254, 210, 219, 62, 161, 102, 95, 161, 117,
    249, 170, 36, 35, 12, 70, 207, 230, 131, 96, 170, 166, 12, 177,
    238, 121, 160, 138, 30, 230, 114, 78, 62, 216, 164, 103, 37, 176,
    82, 20, 126, 246, 240, 41, 145, 1, 85, 32, 50, 219, 141, 78, 139,
    80, 108, 71, 32, 110, 176, 180, 50, 44, 93, 227, 254, 173, 86, 33,
    143, 238, 129, 240, 41, 1, 82, 192, 46, 78, 71, 126, 212, 12, 32,
    221, 1, 71, 58, 213, 30, 211, 201, 138, 116, 76, 1, 107, 144, 89,
    184, 95, 21, 36, 128, 8, 253, 193, 163, 16, 42, 161, 136, 91, 118,
    201, 200, 36, 158, 104, 9, 97, 237, 61, 249, 2, 105, 146, 208, 70,
    245, 46, 251, 155, 246, 131, 192, 165, 184, 199, 211, 32, 64, 39,
    185, 168, 172, 160, 48, 17, 50, 73, 99, 88, 129, 137, 36, 143, 28,
    211, 165, 184, 64, 11, 16, 177, 249, 63, 106, 155, 53, 160, 96,
    172, 142, 203, 19, 65, 78, 143, 219, 121, 219, 29, 221, 0, 207,
    200, 28, 87, 164, 234, 18, 197, 199, 184, 96, 97, 237, 154, 243,
    45, 161, 41, 151, 164, 214, 224, 234, 78, 199, 226, 139, 185, 33,
    16, 221, 102, 19, 16, 123, 77, 4, 237, 35, 155, 3, 120, 200, 219,
    158, 79, 218, 155, 4, 11, 153, 44, 100, 121, 166, 184, 66, 91, 8,
    57, 2, 63, 52, 190, 156, 132, 87, 114, 65, 222, 35, 197, 84, 17,
    35, 231, 253, 233, 29, 153, 241, 180, 159, 91, 247, 240, 60, 209,
    73, 44, 216, 201, 11, 204, 214, 178, 25, 21, 238, 21, 38, 227,
    107, 93, 133, 3, 133, 64, 22, 218, 255, 0, 165, 111, 199, 238, 53,
    54, 98, 25, 96, 108, 207, 122, 105, 114, 130, 65, 84, 7, 190, 171,
    34, 9, 87, 109, 32, 16, 7, 154, 138, 41, 101, 17, 84, 222, 18,
    123, 32, 162, 238, 93, 183, 146, 129, 224, 80, 46, 31, 32, 68,
    246, 138, 211, 13, 177, 223, 181, 2, 140, 89, 96, 105, 120, 167,
    13, 138, 0, 136, 4, 107, 66, 129, 104, 130, 72, 129, 72, 27, 221,
    218, 15, 3, 185, 160, 97, 236, 18, 72, 249, 164, 66, 67, 46, 57,
    49, 60, 144, 41, 192, 34, 11, 16, 60, 79, 122, 39, 108, 22, 90, 9,
    230, 98, 170, 51, 2, 62, 77, 42, 1, 2, 227, 153, 110, 64, 236, 41,
    138, 167, 210, 164, 170, 249, 165, 58, 73, 4, 5, 224, 26, 138,
    215, 220, 193, 118, 115, 240, 41, 149, 29, 30, 224, 80, 39, 70,
    161, 98, 197, 206, 166, 237, 203, 190, 162, 128, 134, 20, 68, 238,
    186, 46, 56, 177, 212, 189, 155, 132, 27, 164, 104, 68, 143, 189,
    84, 41, 245, 142, 201, 79, 239, 72, 75, 65, 148, 147, 255, 0, 198,
    157, 189, 137, 253, 76, 124, 81, 204, 6, 0, 183, 61, 162, 128, 42,
    22, 105, 184, 48, 11, 218, 118, 77, 102, 134, 184, 0, 91, 135,
    145, 170, 193, 153, 238, 52, 200, 209, 230, 131, 23, 200, 34, 16,
    9, 243, 197, 69, 98, 145, 113, 84, 44, 192, 150, 44, 120, 21, 153,
    192, 98, 33, 140, 120, 167, 91, 97, 6, 220, 22, 60, 145, 68, 50,
    39, 7, 221, 30, 40, 35, 155, 157, 37, 167, 51, 204, 234, 169, 101,
    90, 221, 171, 97, 129, 83, 39, 68, 208, 204, 153, 247, 52, 14,
    102, 129, 250, 150, 125, 199, 185, 63, 246, 160, 37, 253, 221,
    201, 230, 144, 19, 117, 157, 113, 246, 169, 217, 157, 83, 92, 200,
    144, 130, 4, 255, 0, 52, 222, 213, 246, 41, 137, 247, 106, 129,
    152, 160, 83, 148, 131, 246, 169, 74, 228, 66, 1, 145, 228, 211,
    23, 36, 240, 126, 13, 107, 76, 61, 98, 35, 64, 146, 72, 224, 208,
    57, 24, 1, 34, 59, 133, 21, 36, 189, 109, 174, 148, 55, 4, 131,
    177, 17, 20, 141, 119, 43, 216, 34, 181, 199, 28, 168, 255, 0,
    147, 218, 169, 97, 25, 21, 237, 222, 233, 226, 219, 60, 182, 242,
    6, 123, 85, 67, 6, 14, 50, 6, 126, 105, 89, 129, 179, 46, 3, 79,
    0, 213, 237, 244, 173, 212, 47, 173, 109, 150, 221, 144, 134, 23,
    30, 126, 254, 43, 148, 149, 245, 149, 32, 121, 152, 160, 112, 133,
    81, 113, 6, 78, 241, 158, 41, 146, 217, 182, 197, 220, 15, 85,
    191, 250, 143, 20, 48, 83, 12, 87, 158, 228, 246, 163, 37, 220,
    132, 201, 128, 209, 39, 129, 81, 88, 72, 249, 255, 0, 122, 71,
    102, 124, 109, 39, 214, 253, 252, 15, 52, 82, 75, 54, 50, 66, 243,
    53, 172, 134, 69, 123, 133, 73, 184, 218, 215, 97, 85, 14, 21, 0,
    91, 107, 254, 149, 191, 31, 184, 212, 217, 136, 101, 129, 179, 61,
    233, 165, 202, 9, 5, 80, 30, 250, 172, 136, 37, 93, 180, 128, 64,
    30, 106, 40, 165, 148, 69, 83, 120, 73, 236, 130, 139, 185, 118,
    222, 74, 7, 129, 64, 184, 124, 129, 19, 218, 43, 76, 54, 199, 126,
    212, 10, 49, 101, 129, 165, 226, 156, 54, 40, 2, 32, 17, 173, 10,
    5, 162, 9, 34, 5, 32, 111, 119, 104, 60, 14, 230, 129, 135, 176,
    73, 35, 230, 145, 9, 12, 184, 228, 196, 242, 64, 167, 0, 136, 44,
    64, 241, 61, 232, 157, 176, 89, 104, 39, 153, 138, 168, 204, 8,
    249, 52, 168, 4, 11, 142, 101, 185, 3, 176, 166, 42, 159, 74, 146,
    171, 230, 148, 233, 36, 16, 23, 128, 106, 43, 95, 115, 5, 217,
    207, 192, 166, 84, 116, 123, 129, 64, 157, 26, 133, 139, 23, 58,
    155, 183, 46, 250, 138, 2, 24, 81, 19, 186, 232, 184, 226, 199,
    82, 246, 110, 16, 110, 145, 161, 18, 62, 245, 80, 167, 214, 59,
    37, 63, 189, 33, 45, 6, 82, 79, 255, 0, 26, 118, 246, 39, 245, 49,
    241, 71, 48, 24, 2, 220, 246, 138, 0, 168, 89, 166, 224, 192, 47,
    105, 217, 53, 154, 26, 224, 1, 110, 30, 70, 171, 6, 103, 184, 211,
    35, 71, 154, 12, 95, 32, 136, 64, 39, 207, 21, 20, 229, 160, 122,
    107, 161, 241, 254, 244, 170, 50, 86, 29, 183, 249, 172, 54, 235,
    242, 59, 208, 23, 17, 16, 137, 95, 147, 64, 215, 97, 148, 44, 107,
    196, 154, 47, 204, 183, 17, 81, 119, 246, 55, 184, 2, 38, 139,
    133, 1, 90, 225, 150, 32, 70, 70, 7, 21, 80, 65, 204, 220, 199,
    196, 207, 205, 98, 193, 45, 229, 5, 140, 106, 6, 205, 52, 18, 64,
    16, 0, 230, 60, 83, 6, 193, 192, 3, 181, 69, 15, 76, 176, 15, 116,
    108, 240, 166, 177, 117, 65, 136, 219, 76, 192, 172, 115, 105,
    129, 38, 121, 161, 103, 11, 123, 44, 11, 206, 133, 84, 102, 91,
    104, 51, 185, 187, 159, 181, 121, 129, 65, 67, 125, 80, 56, 128,
    60, 81, 227, 220, 118, 199, 157, 86, 157, 212, 86, 158, 236, 64,
    252, 69, 41, 97, 114, 227, 100, 125, 137, 253, 205, 53, 198, 68,
    183, 149, 194, 49, 158, 245, 37, 234, 186, 116, 76, 109, 171, 183,
    187, 133, 83, 179, 252, 85, 69, 122, 23, 234, 30, 227, 30, 158,
    197, 162, 147, 238, 103, 48, 38, 186, 108, 220, 54, 15, 80, 253,
    64, 15, 212, 220, 96, 158, 209, 161, 219, 159, 31, 248, 173, 208,
    40, 183, 209, 219, 23, 83, 7, 50, 72, 252, 213, 47, 244, 235, 122,
    205, 220, 139, 132, 97, 182, 83, 191, 138, 138, 228, 107, 45, 105,
    192, 114, 25, 185, 56, 29, 10, 84, 86, 203, 66, 218, 129, 201,
    154, 123, 175, 211, 122, 99, 210, 123, 138, 224, 193, 44, 54, 127,
    181, 77, 1, 150, 229, 132, 72, 160, 204, 69, 184, 151, 202, 120,
    133, 221, 4, 80, 92, 18, 46, 72, 236, 69, 58, 165, 197, 124, 216,
    5, 48, 64, 162, 50, 19, 55, 75, 80, 39, 168, 1, 50, 24, 14, 118,
    180, 138, 214, 216, 16, 141, 185, 130, 123, 213, 179, 124, 212,
    103, 0, 2, 104, 35, 155, 142, 203, 137, 104, 51, 36, 106, 170, 38,
    214, 194, 143, 76, 57, 147, 218, 38, 170, 138, 168, 73, 12, 13,
    195, 201, 255, 0, 138, 3, 76, 205, 251, 143, 122, 80, 202, 3, 150,
    32, 110, 4, 246, 168, 166, 182, 78, 108, 204, 64, 3, 64, 15, 52,
    119, 160, 54, 199, 147, 72, 168, 161, 24, 177, 202, 76, 214, 32,
    6, 246, 146, 9, 237, 51, 85, 20, 0, 1, 115, 35, 61, 188, 205, 115,
    117, 23, 31, 16, 45, 136, 118, 108, 23, 231, 205, 88, 139, 160,
    24, 80, 223, 34, 133, 155, 35, 252, 253, 180, 102, 48, 136, 72, 3,
    201, 59, 160, 236, 233, 122, 116, 233, 172, 132, 183, 132, 242,
    236, 121, 53, 97, 12, 192, 64, 103, 61, 233, 240, 76, 190, 130,
    200, 54, 5, 113, 191, 91, 115, 19, 138, 5, 79, 17, 218, 167, 90,
    224, 189, 134, 189, 214, 221, 180, 215, 15, 162, 170, 33, 67, 104,
    121, 168, 122, 94, 129, 205, 50, 57, 72, 80, 221, 163, 181, 6, 50,
    224, 35, 220, 4, 239, 241, 69, 222, 227, 143, 116, 232, 200, 154,
    33, 113, 103, 95, 213, 50, 100, 232, 127, 205, 51, 201, 0, 73,
    143, 0, 208, 139, 140, 199, 18, 144, 14, 247, 186, 2, 99, 55, 96,
    96, 196, 45, 3, 22, 129, 233, 174, 135, 199, 251, 210, 168, 201,
    88, 118, 223, 230, 176, 219, 175, 200, 239, 64, 92, 68, 66, 37,
    126, 77, 3, 93, 134, 80, 177, 175, 18, 104, 191, 50, 220, 69, 69,
    223, 216, 222, 224, 8, 154, 46, 20, 5, 107, 134, 88, 129, 25, 24,
    28, 85, 65, 7, 51, 115, 31, 19, 63, 53, 139, 4, 183, 148, 22, 49,
    168, 27, 52, 208, 73, 0, 64, 3, 152, 241, 76, 27, 7, 0, 14, 213,
    20, 61, 50, 192, 61, 209, 179, 194, 154, 197, 213, 6, 35, 109, 51,
    2, 177, 205, 166, 4, 153, 230, 133, 156, 45, 236, 176, 47, 58, 21,
    81, 153, 109, 160, 206, 230, 238, 126, 213, 230, 5, 5, 13, 245,
    64, 226, 0, 241, 71, 143, 113, 219, 30, 117, 90, 119, 81, 90, 123,
    177, 3, 241, 20, 165, 133, 203, 141, 145, 246, 39, 247, 52, 215,
    25, 18, 222, 87, 8, 198, 123, 212, 151, 170, 233, 209, 49, 182,
    174, 222, 238, 21, 78, 207, 241, 85, 21, 232, 95, 168, 123, 140,
    122, 123, 22, 138, 79, 185, 156, 192, 154, 233, 179, 112, 216, 61,
    67, 245, 0, 63, 83, 113, 130, 123, 70, 135, 110, 124, 127, 226,
    183, 64, 162, 223, 71, 108, 93, 76, 28, 201, 35, 243, 84, 191,
    211, 173, 235, 55, 114, 46, 17, 134, 217, 78, 254, 42, 43, 145,
    172, 181, 167, 1, 200, 102, 228, 224, 116, 41, 81, 91, 45, 11,
    106, 7, 38, 105, 238, 191, 77, 233, 143, 73, 238, 43, 131, 4, 176,
    217, 254, 213, 52, 6, 91, 150, 17, 34, 131, 49, 22, 226, 95, 41,
    226, 23, 116, 17, 65, 112, 72, 185, 35, 177, 20, 234, 151, 21,
    243, 96, 20, 193, 2, 136, 200, 76, 221, 45, 64, 128, 174, 134, 82,
    69, 28, 150, 208, 1, 83, 54, 59, 129, 76, 239, 130, 16, 171, 161,
    192, 2, 146, 214, 89, 109, 72, 98, 57, 34, 40, 3, 179, 170, 231,
    121, 146, 202, 182, 160, 118, 21, 53, 186, 151, 175, 217, 98, 151,
    29, 18, 118, 201, 163, 216, 26, 107, 8, 58, 171, 191, 230, 111,
    75, 162, 152, 182, 156, 131, 243, 94, 189, 164, 40, 92, 152, 83,
    16, 7, 197, 90, 143, 53, 82, 211, 43, 122, 49, 254, 101, 218, 72,
    36, 224, 40, 95, 91, 150, 25, 109, 178, 131, 112, 255, 0, 21, 215,
    212, 171, 162, 139, 214, 81, 85, 203, 132, 37, 135, 99, 64, 116,
    100, 93, 255, 0, 50, 215, 157, 216, 3, 166, 237, 246, 165, 87, 43,
    89, 186, 205, 15, 113, 85, 123, 129, 222, 153, 80, 108, 44, 11,
    107, 222, 54, 77, 96, 9, 36, 147, 207, 20, 176, 113, 133, 129, 80,
    96, 73, 115, 149, 34, 175, 175, 114, 12, 139, 107, 183, 111, 248,
    162, 236, 242, 182, 211, 235, 125, 64, 255, 0, 122, 163, 39, 167,
    100, 90, 182, 124, 102, 126, 106, 162, 105, 105, 46, 117, 214,
    237, 178, 77, 180, 76, 130, 249, 53, 233, 133, 143, 76, 9, 4, 159,
    219, 94, 120, 200, 62, 98, 6, 59, 7, 154, 234, 94, 168, 102, 140,
    216, 49, 86, 156, 106, 106, 227, 169, 108, 140, 94, 94, 230, 10,
    126, 163, 197, 115, 245, 221, 69, 143, 71, 211, 180, 247, 48, 30,
    242, 223, 213, 82, 234, 58, 135, 189, 113, 242, 58, 4, 232, 87,
    25, 198, 230, 134, 228, 239, 241, 76, 194, 172, 133, 25, 5, 194,
    128, 185, 50, 9, 237, 88, 55, 235, 102, 65, 227, 183, 106, 196,
    177, 16, 18, 56, 192, 118, 169, 186, 186, 6, 98, 224, 24, 224,
    110, 130, 141, 166, 127, 142, 212, 133, 148, 33, 240, 53, 20, 215,
    16, 51, 140, 187, 208, 182, 170, 237, 145, 0, 34, 240, 60, 154, 4,
    82, 17, 84, 180, 151, 32, 232, 85, 109, 3, 111, 54, 99, 140, 236,
    3, 218, 181, 167, 197, 28, 8, 4, 55, 111, 154, 86, 96, 4, 183,
    184, 124, 208, 2, 188, 100, 199, 102, 34, 137, 199, 134, 77, 14,
    209, 74, 2, 57, 32, 8, 251, 85, 4, 98, 57, 147, 179, 61, 168, 22,
    45, 114, 214, 161, 188, 41, 172, 96, 41, 48, 38, 53, 53, 151, 16,
    130, 60, 127, 53, 139, 1, 201, 31, 147, 64, 93, 212, 2, 68, 152,
    61, 141, 107, 112, 151, 18, 228, 108, 18, 63, 20, 169, 13, 45,
    114, 90, 14, 130, 241, 68, 134, 184, 8, 82, 80, 112, 117, 85, 29,
    77, 213, 35, 163, 250, 96, 204, 108, 255, 0, 197, 115, 22, 5, 2,
    162, 194, 196, 107, 197, 13, 109, 21, 244, 135, 178, 205, 55, 166,
    22, 202, 134, 107, 146, 189, 188, 212, 86, 64, 53, 189, 4, 129,
    72, 206, 170, 11, 49, 128, 60, 214, 30, 163, 219, 4, 8, 158, 36,
    80, 34, 218, 3, 150, 76, 71, 118, 26, 160, 40, 172, 73, 118, 24,
    169, 26, 29, 205, 20, 44, 21, 148, 19, 60, 152, 162, 10, 50, 43,
    57, 108, 136, 218, 138, 62, 194, 112, 0, 199, 199, 247, 160, 64,
    87, 67, 41, 34, 142, 75, 104, 0, 169, 155, 29, 192, 166, 119, 193,
    8, 85, 208, 224, 1, 73, 107, 44, 182, 164, 49, 28, 145, 20, 1,
    217, 213, 115, 188, 201, 101, 91, 80, 59, 10, 154, 221, 75, 215,
    236, 177, 75, 142, 137, 59, 100, 209, 236, 13, 53, 132, 29, 85,
    223, 243, 55, 165, 209, 76, 91, 78, 65, 249, 175, 94, 210, 20, 46,
    76, 41, 136, 3, 226, 173, 71, 154, 169, 105, 149, 189, 24, 255, 0,
    50, 237, 36, 18, 112, 20, 47, 173, 203, 12, 182, 217, 65, 184,
    127, 138, 235, 234, 85, 209, 69, 235, 40, 170, 229, 194, 18, 195,
    177, 160, 58, 50, 46, 255, 0, 153, 107, 206, 236, 1, 211, 118,
    251, 82, 171, 149, 172, 221, 102, 135, 184, 170, 189, 192, 239,
    76, 168, 54, 22, 5, 181, 239, 27, 38, 176, 4, 146, 73, 231, 138,
    88, 56, 194, 192, 168, 48, 36, 185, 202, 145, 87, 215, 185, 6, 69,
    181, 219, 183, 252, 81, 118, 121, 91, 105, 245, 190, 160, 127,
    189, 81, 147, 211, 178, 45, 91, 62, 51, 63, 53, 81, 52, 180, 151,
    58, 235, 118, 217, 38, 218, 38, 65, 124, 154, 244, 194, 199, 166,
    4, 130, 79, 237, 175, 60, 100, 31, 49, 3, 29, 131, 205, 117, 47,
    84, 51, 70, 108, 24, 171, 78, 53, 53, 113, 212, 182, 70, 47, 47,
    115, 5, 63, 81, 226, 185, 250, 238, 162, 199, 163, 233, 218, 123,
    152, 15, 121, 111, 234, 169, 117, 29, 67, 222, 184, 249, 29, 2,
    116, 43, 140, 227, 115, 67, 114, 119, 248, 166, 97, 86, 66, 140,
    130, 225, 64, 92, 153, 4, 246, 172, 27, 245, 179, 32, 241, 219,
    181, 98, 88, 136, 9, 28, 96, 59, 84, 221, 93, 3, 49, 112, 12, 112,
    55, 65, 70, 211, 63, 199, 106, 66, 202, 16, 248, 26, 138, 107,
    136, 25, 198, 93, 232, 91, 85, 118, 200, 128, 17, 120, 30, 77, 6,
    4, 43, 2, 73, 98, 65, 142, 213, 46, 173, 153, 122, 107, 128, 73,
    36, 1, 246, 147, 19, 78, 193, 85, 237, 42, 201, 119, 49, 36, 207,
    222, 139, 244, 202, 234, 80, 221, 120, 238, 42, 163, 208, 177,
    104, 91, 178, 170, 150, 202, 168, 17, 153, 255, 0, 138, 61, 77,
    244, 178, 232, 150, 211, 80, 36, 177, 250, 171, 116, 215, 83, 211,
    182, 110, 185, 56, 136, 251, 215, 55, 89, 212, 139, 215, 117, 191,
    2, 162, 135, 81, 212, 53, 244, 0, 183, 177, 120, 83, 230, 129,
    234, 46, 57, 182, 132, 202, 172, 205, 73, 57, 51, 51, 0, 197, 5,
    1, 109, 12, 178, 16, 123, 110, 131, 31, 85, 142, 154, 218, 15, 60,
    145, 88, 33, 107, 152, 45, 226, 78, 246, 4, 83, 74, 34, 130, 0,
    136, 241, 90, 219, 179, 181, 195, 168, 0, 13, 85, 64, 69, 244,
    217, 176, 196, 152, 229, 143, 21, 189, 227, 100, 2, 126, 13, 5,
    88, 50, 118, 107, 100, 185, 144, 88, 107, 180, 255, 0, 197, 69,
    101, 56, 46, 254, 163, 170, 104, 8, 60, 239, 159, 52, 45, 166, 83,
    113, 143, 180, 206, 207, 127, 20, 77, 191, 124, 44, 136, 19, 241,
    170, 5, 184, 250, 192, 109, 154, 156, 28, 21, 85, 76, 8, 143, 154,
    10, 164, 31, 83, 37, 203, 182, 184, 160, 115, 36, 128, 87, 153,
    159, 138, 168, 36, 210, 221, 73, 180, 219, 28, 78, 168, 178, 0,
    223, 81, 98, 60, 246, 162, 103, 41, 145, 21, 21, 130, 7, 10, 217,
    220, 39, 17, 48, 105, 110, 97, 109, 64, 18, 118, 0, 215, 122, 10,
    225, 44, 226, 73, 56, 146, 56, 172, 191, 169, 118, 90, 69, 181,
    242, 59, 213, 65, 18, 140, 202, 45, 153, 34, 103, 230, 149, 173,
    187, 2, 238, 84, 40, 249, 170, 161, 246, 220, 120, 50, 218, 31, 2,
    148, 168, 44, 9, 216, 29, 143, 21, 20, 204, 234, 28, 140, 211,
    236, 57, 164, 105, 244, 217, 190, 53, 255, 0, 229, 109, 101, 34,
    218, 169, 137, 38, 40, 186, 12, 36, 144, 220, 145, 64, 20, 69,
    181, 44, 240, 49, 16, 13, 50, 133, 41, 37, 20, 146, 118, 220, 214,
    192, 148, 80, 205, 141, 176, 36, 200, 250, 141, 16, 80, 219, 246,
    161, 136, 6, 129, 125, 64, 146, 87, 100, 143, 21, 136, 145, 238,
    124, 71, 129, 88, 60, 41, 19, 60, 154, 217, 2, 79, 184, 19, 241,
    64, 101, 84, 131, 108, 1, 223, 84, 37, 157, 184, 149, 230, 102,
    137, 112, 4, 210, 171, 251, 72, 43, 163, 244, 136, 237, 85, 1, 24,
    175, 78, 160, 180, 193, 35, 95, 122, 124, 201, 19, 230, 147, 19,
    137, 246, 75, 22, 145, 252, 213, 29, 72, 104, 7, 67, 226, 162,
    149, 73, 102, 111, 0, 71, 21, 182, 230, 1, 132, 28, 154, 192, 2,
    8, 109, 15, 154, 98, 222, 216, 26, 31, 20, 10, 8, 86, 4, 146, 196,
    131, 29, 170, 93, 91, 50, 244, 215, 0, 146, 72, 3, 237, 38, 38,
    157, 130, 171, 218, 85, 146, 238, 98, 73, 159, 189, 23, 233, 149,
    212, 161, 186, 241, 220, 85, 71, 161, 98, 208, 183, 101, 85, 45,
    149, 80, 35, 51, 255, 0, 20, 122, 155, 233, 101, 209, 45, 166,
    160, 73, 99, 245, 86, 233, 174, 167, 167, 108, 221, 114, 113, 17,
    247, 174, 110, 179, 169, 23, 174, 235, 126, 5, 69, 14, 163, 168,
    107, 232, 1, 111, 98, 240, 167, 205, 3, 212, 92, 115, 109, 9, 149,
    89, 154, 146, 114, 102, 102, 1, 138, 10, 2, 218, 25, 100, 32, 246,
    221, 6, 62, 171, 29, 53, 180, 30, 121, 34, 176, 66, 215, 48, 91,
    196, 157, 236, 8, 166, 148, 69, 4, 1, 17, 226, 181, 183, 103, 107,
    135, 80, 0, 26, 170, 128, 139, 233, 179, 97, 137, 49, 203, 30, 43,
    123, 198, 200, 4, 252, 26, 10, 176, 100, 236, 214, 201, 115, 32,
    176, 215, 105, 255, 0, 138, 138, 202, 112, 93, 253, 71, 84, 208,
    16, 121, 223, 62, 104, 91, 76, 166, 227, 31, 105, 157, 158, 254,
    40, 155, 126, 248, 89, 16, 39, 227, 84, 11, 113, 245, 128, 219,
    53, 56, 56, 42, 170, 152, 17, 31, 52, 21, 72, 62, 166, 75, 151,
    109, 113, 64, 230, 73, 0, 175, 51, 63, 21, 80, 73, 165, 186, 147,
    105, 182, 56, 157, 81, 100, 1, 190, 162, 196, 121, 237, 68, 206,
    83, 34, 42, 43, 4, 14, 21, 179, 184, 78, 34, 96, 210, 220, 194,
    218, 128, 36, 236, 1, 174, 244, 21, 194, 89, 196, 146, 113, 36,
    113, 89, 127, 82, 236, 180, 139, 107, 228, 119, 170, 134, 176,
    136, 110, 27, 131, 120, 13, 30, 14, 235, 78, 76, 68, 79, 115, 65,
    3, 42, 92, 145, 238, 39, 137, 226, 41, 212, 66, 118, 4, 153, 129,
    81, 74, 164, 153, 125, 40, 229, 104, 148, 1, 66, 3, 47, 59, 36,
    209, 64, 216, 150, 104, 3, 182, 170, 108, 64, 209, 36, 183, 97,
    64, 64, 85, 66, 20, 152, 60, 145, 178, 104, 237, 84, 64, 159, 204,
    211, 0, 64, 220, 8, 208, 80, 40, 18, 62, 65, 248, 160, 147, 150,
    107, 45, 236, 134, 157, 159, 2, 171, 146, 34, 184, 99, 18, 192,
    40, 173, 97, 114, 70, 186, 251, 19, 8, 8, 172, 215, 66, 182, 253,
    204, 123, 1, 38, 129, 114, 86, 144, 8, 58, 220, 81, 72, 82, 24,
    136, 110, 230, 129, 40, 170, 50, 178, 3, 78, 130, 243, 205, 53,
    177, 233, 163, 187, 33, 77, 104, 19, 64, 1, 15, 236, 146, 113,
    243, 65, 164, 200, 192, 146, 68, 15, 205, 49, 125, 111, 158, 96,
    9, 254, 245, 131, 184, 18, 6, 234, 163, 8, 136, 0, 128, 52, 36,
    82, 236, 222, 93, 28, 78, 168, 173, 182, 100, 184, 110, 62, 42,
    95, 243, 21, 145, 61, 242, 24, 165, 180, 39, 147, 179, 64, 74, 59,
    180, 103, 109, 55, 199, 53, 51, 105, 25, 241, 107, 206, 199, 147,
    26, 170, 18, 182, 212, 194, 198, 251, 242, 105, 68, 89, 76, 140,
    102, 79, 125, 84, 83, 231, 110, 194, 66, 33, 12, 78, 129, 228,
    212, 208, 186, 219, 247, 33, 98, 76, 146, 59, 85, 2, 20, 146, 119,
    112, 243, 75, 137, 105, 3, 204, 80, 18, 225, 154, 3, 192, 147,
    168, 221, 6, 104, 159, 183, 106, 96, 1, 99, 145, 224, 104, 84,
    180, 65, 10, 236, 114, 209, 239, 65, 129, 62, 153, 38, 73, 99,
    160, 106, 175, 130, 125, 71, 67, 154, 64, 29, 175, 35, 181, 182,
    22, 208, 29, 55, 115, 78, 19, 3, 149, 230, 13, 115, 178, 142, 5,
    4, 209, 94, 242, 7, 98, 109, 219, 236, 35, 103, 116, 192, 0, 49,
    4, 133, 226, 79, 52, 197, 203, 237, 137, 251, 84, 139, 22, 97,
    202, 143, 36, 85, 67, 250, 86, 228, 157, 152, 224, 26, 110, 208,
    160, 1, 240, 40, 57, 58, 198, 56, 217, 241, 81, 186, 46, 255, 0,
    149, 111, 76, 195, 115, 145, 237, 246, 160, 176, 33, 27, 220, 65,
    114, 35, 117, 128, 37, 100, 191, 246, 221, 86, 215, 248, 119, 79,
    103, 165, 55, 7, 169, 146, 172, 181, 201, 217, 174, 123, 54, 238,
    220, 25, 155, 76, 2, 238, 89, 166, 40, 41, 128, 46, 90, 78, 184,
    255, 0, 223, 52, 186, 202, 1, 38, 180, 192, 137, 153, 62, 42, 97,
    178, 182, 178, 9, 145, 192, 230, 162, 170, 132, 227, 228, 79, 52,
    10, 43, 182, 213, 64, 89, 63, 154, 206, 93, 20, 228, 0, 35, 72,
    131, 181, 98, 152, 38, 33, 1, 39, 251, 213, 70, 176, 136, 110, 27,
    131, 120, 13, 30, 14, 235, 78, 76, 68, 79, 115, 65, 3, 42, 92,
    145, 238, 39, 137, 226, 41, 212, 66, 118, 4, 153, 129, 81, 74,
    164, 153, 125, 40, 229, 104, 148, 1, 66, 3, 47, 59, 36, 209, 64,
    216, 150, 104, 3, 182, 170, 108, 64, 209, 36, 183, 97, 64, 64, 85,
    66, 20, 152, 60, 145, 178, 104, 237, 84, 64, 159, 204, 211, 0, 64,
    220, 8, 208, 80, 40, 18, 62, 65, 248, 160, 147, 150, 107, 45, 236,
    134, 157, 159, 2, 171, 146, 34, 184, 99, 18, 192, 40, 173, 97,
    114, 70, 186, 251, 19, 8, 8, 172, 215, 66, 182, 253, 204, 123, 1,
    38, 129, 114, 86, 144, 8, 58, 220, 81, 72, 82, 24, 136, 110, 230,
    129, 40, 170, 50, 178, 3, 78, 130, 243, 205, 53, 177, 233, 163,
    187, 33, 77, 104, 19, 64, 1, 15, 236, 146, 113, 243, 65, 164, 200,
    192, 146, 68, 15, 205, 49, 125, 111, 158, 96, 9, 254, 245, 131,
    184, 18, 6, 234, 163, 8, 136, 0, 128, 52, 36, 82, 236, 222, 93,
    28, 78, 168, 173, 182, 100, 184, 110, 62, 42, 95, 243, 21, 145,
    61, 242, 24, 165, 180, 39, 147, 179, 64, 74, 59, 180, 103, 109,
    55, 199, 53, 51, 105, 25, 241, 107, 206, 199, 147, 26, 170, 18,
    182, 212, 194, 198, 251, 242, 105, 68, 89, 76, 140, 102, 79, 125,
    84, 83, 231, 110, 194, 66, 33, 12, 78, 129, 228, 212, 208, 186,
    219, 247, 33, 98, 76, 146, 59, 85, 2, 20, 146, 119, 112, 243, 75,
    137, 105, 3, 204, 80, 5, 250, 192, 80, 75, 114, 64, 163, 138, 184,
    12, 192, 241, 58, 172, 202, 21, 112, 182, 197, 102, 125, 220, 147,
    77, 138, 170, 170, 41, 224, 119, 243, 65, 59, 140, 109, 226, 161,
    242, 45, 192, 35, 116, 109, 35, 40, 119, 123, 120, 112, 20, 10,
    22, 18, 111, 92, 186, 210, 222, 159, 180, 14, 4, 213, 2, 153, 151,
    102, 119, 39, 64, 240, 42, 161, 83, 54, 4, 130, 8, 138, 91, 132,
    133, 214, 201, 208, 17, 222, 153, 189, 250, 248, 230, 153, 22, 89,
    92, 145, 173, 197, 69, 40, 182, 21, 85, 25, 224, 14, 195, 84, 17,
    74, 163, 50, 251, 68, 242, 105, 131, 140, 164, 140, 136, 52, 54,
    210, 20, 12, 190, 123, 85, 70, 12, 17, 142, 136, 129, 204, 86, 10,
    174, 197, 137, 147, 230, 102, 152, 42, 2, 1, 58, 6, 73, 157, 147,
    72, 77, 182, 49, 136, 6, 103, 71, 117, 20, 215, 53, 108, 34, 147,
    145, 239, 70, 66, 168, 143, 228, 238, 166, 48, 144, 197, 182, 56,
    4, 209, 3, 38, 195, 71, 98, 7, 252, 80, 16, 3, 74, 106, 38, 102,
    104, 20, 134, 1, 12, 146, 118, 98, 157, 140, 112, 53, 197, 33, 42,
    186, 157, 208, 49, 182, 234, 249, 92, 131, 3, 218, 7, 147, 67,
    209, 82, 125, 71, 36, 146, 116, 60, 82, 184, 253, 198, 56, 224,
    246, 167, 27, 82, 119, 173, 80, 2, 118, 99, 98, 127, 138, 195,
    226, 34, 149, 185, 3, 191, 105, 172, 182, 149, 182, 84, 232, 106,
    128, 160, 150, 37, 208, 16, 99, 84, 249, 64, 49, 26, 220, 1, 72,
    45, 5, 98, 67, 30, 120, 109, 214, 43, 113, 127, 255, 0, 57, 158,
    234, 102, 128, 156, 221, 249, 50, 124, 158, 5, 103, 135, 98, 138,
    129, 163, 82, 104, 6, 88, 13, 112, 149, 89, 226, 176, 184, 46,
    103, 137, 129, 218, 5, 84, 48, 182, 48, 6, 78, 251, 76, 209, 115,
    128, 36, 65, 141, 138, 67, 216, 136, 48, 53, 168, 172, 45, 169,
    18, 196, 159, 249, 168, 166, 120, 145, 234, 29, 26, 143, 81, 117,
    202, 69, 177, 238, 102, 193, 123, 243, 89, 110, 51, 222, 11, 102,
    211, 93, 40, 0, 146, 208, 160, 213, 211, 167, 234, 175, 95, 183,
    234, 219, 75, 54, 145, 195, 144, 27, 34, 77, 84, 89, 122, 43, 194,
    199, 166, 253, 75, 177, 104, 201, 76, 65, 172, 206, 207, 119, 252,
    189, 229, 100, 129, 146, 34, 29, 183, 201, 174, 182, 113, 140,
    159, 104, 174, 123, 239, 118, 207, 81, 110, 225, 65, 109, 149, 15,
    130, 124, 255, 0, 239, 218, 162, 185, 153, 2, 143, 79, 6, 49, 204,
    242, 104, 102, 45, 219, 48, 0, 63, 216, 86, 184, 225, 206, 109,
    113, 131, 157, 196, 84, 214, 218, 184, 86, 187, 116, 139, 92, 227,
    198, 84, 15, 137, 206, 78, 201, 137, 166, 147, 145, 60, 119, 221,
    108, 129, 216, 223, 112, 41, 23, 43, 174, 64, 37, 84, 9, 114, 69,
    6, 95, 172, 5, 4, 183, 36, 10, 56, 171, 128, 204, 15, 19, 170,
    204, 161, 87, 11, 108, 86, 103, 221, 201, 52, 216, 170, 170, 162,
    158, 7, 127, 52, 19, 184, 198, 222, 42, 31, 34, 220, 2, 55, 70,
    210, 50, 135, 119, 183, 135, 1, 64, 161, 97, 38, 245, 203, 173,
    45, 233, 251, 64, 224, 77, 80, 41, 153, 118, 103, 114, 116, 15, 2,
    170, 21, 51, 96, 72, 32, 136, 165, 184, 72, 93, 108, 157, 1, 29,
    233, 155, 223, 175, 142, 105, 145, 101, 149, 201, 26, 220, 84, 82,
    139, 97, 85, 81, 158, 0, 236, 53, 65, 20, 170, 51, 47, 180, 79,
    38, 152, 56, 202, 72, 200, 131, 67, 109, 33, 64, 203, 231, 181,
    84, 96, 193, 24, 232, 136, 28, 197, 96, 170, 236, 88, 153, 62,
    102, 105, 130, 160, 32, 19, 160, 100, 153, 217, 52, 132, 219, 99,
    24, 128, 102, 116, 119, 81, 77, 115, 86, 194, 41, 57, 30, 244,
    100, 42, 136, 254, 78, 234, 99, 9, 12, 91, 99, 128, 77, 16, 50,
    108, 52, 118, 32, 127, 197, 1, 0, 52, 166, 162, 102, 102, 129, 72,
    96, 16, 201, 39, 102, 41, 216, 199, 3, 92, 82, 18, 171, 169, 221,
    3, 27, 110, 175, 149, 200, 48, 61, 160, 121, 52, 61, 21, 39, 212,
    114, 73, 39, 67, 197, 43, 143, 220, 99, 142, 15, 106, 113, 181,
    39, 122, 213, 0, 39, 102, 54, 39, 248, 172, 62, 34, 41, 91, 144,
    59, 246, 154, 203, 105, 91, 101, 78, 134, 168, 10, 34, 45, 235,
    121, 49, 98, 70, 247, 193, 138, 202, 84, 161, 8, 84, 159, 51, 68,
    65, 38, 16, 104, 253, 232, 176, 5, 125, 182, 215, 67, 66, 40, 21,
    8, 181, 97, 82, 53, 245, 150, 29, 235, 2, 14, 193, 153, 227, 197,
    107, 140, 86, 209, 96, 8, 212, 8, 167, 22, 132, 126, 160, 36, 192,
    36, 112, 63, 52, 19, 80, 89, 152, 204, 131, 199, 219, 255, 0, 102,
    152, 200, 80, 131, 84, 204, 199, 33, 136, 228, 198, 169, 96, 34,
    144, 11, 22, 62, 104, 8, 89, 115, 109, 52, 20, 73, 141, 209, 79,
    100, 158, 73, 239, 88, 146, 6, 11, 253, 245, 63, 122, 80, 15, 36,
    9, 160, 32, 205, 40, 198, 213, 178, 64, 5, 152, 152, 63, 236, 43,
    42, 146, 199, 153, 158, 212, 81, 27, 50, 196, 105, 126, 144, 7,
    31, 52, 1, 86, 0, 46, 67, 92, 61, 187, 1, 68, 42, 35, 12, 64, 49,
    163, 88, 182, 4, 153, 18, 59, 14, 107, 34, 146, 50, 109, 8, 208,
    160, 70, 4, 204, 172, 239, 64, 83, 125, 3, 145, 150, 167, 83, 78,
    197, 183, 17, 49, 230, 178, 202, 160, 80, 249, 16, 34, 7, 97, 64,
    128, 59, 193, 97, 136, 152, 137, 166, 184, 248, 46, 245, 31, 222,
    179, 206, 162, 149, 200, 77, 130, 11, 30, 42, 161, 6, 137, 133,
    98, 205, 222, 63, 181, 90, 213, 175, 70, 209, 37, 125, 237, 205,
    100, 144, 236, 237, 26, 227, 201, 172, 223, 84, 79, 21, 20, 32,
    204, 1, 246, 154, 1, 204, 202, 246, 28, 208, 72, 42, 28, 144, 23,
    136, 154, 44, 9, 33, 20, 31, 199, 106, 168, 192, 172, 162, 182,
    39, 83, 6, 183, 168, 76, 202, 226, 62, 212, 193, 8, 130, 35, 199,
    147, 65, 109, 187, 236, 177, 69, 248, 239, 81, 90, 105, 26, 238,
    75, 42, 172, 79, 2, 5, 62, 223, 33, 109, 76, 14, 9, 239, 68, 156,
    28, 108, 40, 136, 252, 208, 83, 252, 58, 215, 167, 210, 170, 178,
    144, 234, 251, 17, 201, 174, 228, 183, 118, 226, 159, 77, 114, 63,
    255, 0, 205, 121, 235, 117, 236, 255, 0, 164, 229, 79, 158, 38,
    138, 117, 29, 67, 134, 55, 28, 177, 97, 192, 237, 65, 215, 122,
    242, 116, 192, 8, 45, 120, 159, 169, 184, 21, 194, 236, 247, 26,
    229, 199, 134, 184, 209, 4, 154, 22, 229, 238, 177, 50, 45, 167,
    247, 52, 11, 77, 201, 248, 136, 160, 37, 51, 121, 107, 132, 15, 0,
    86, 198, 209, 125, 166, 68, 14, 90, 136, 212, 73, 18, 102, 5, 4,
    13, 131, 57, 4, 75, 106, 71, 106, 0, 113, 196, 112, 164, 158, 56,
    166, 120, 22, 74, 41, 220, 76, 206, 233, 65, 8, 117, 25, 118, 162,
    34, 126, 130, 204, 121, 110, 40, 21, 17, 22, 245, 188, 152, 177,
    35, 123, 224, 197, 101, 42, 80, 132, 42, 79, 153, 162, 32, 147, 8,
    52, 126, 244, 88, 2, 190, 219, 107, 161, 161, 20, 10, 132, 90,
    176, 169, 26, 250, 203, 14, 245, 129, 7, 96, 204, 241, 226, 181,
    198, 43, 104, 176, 4, 106, 4, 83, 139, 66, 63, 80, 18, 96, 18, 56,
    31, 154, 9, 168, 44, 204, 102, 65, 227, 237, 255, 0, 179, 76, 100,
    40, 65, 170, 102, 99, 144, 196, 114, 99, 84, 176, 17, 72, 5, 139,
    31, 52, 4, 44, 185, 182, 154, 10, 36, 198, 232, 167, 178, 79, 36,
    247, 172, 73, 3, 5, 254, 250, 159, 189, 40, 7, 146, 4, 208, 16,
    102, 148, 99, 106, 217, 32, 2, 204, 76, 31, 246, 21, 149, 73, 99,
    204, 207, 106, 40, 141, 153, 98, 52, 191, 72, 3, 143, 154, 0, 171,
    0, 23, 33, 174, 30, 221, 128, 162, 21, 17, 134, 32, 24, 209, 172,
    91, 2, 76, 137, 29, 135, 53, 145, 73, 25, 54, 132, 104, 80, 35, 2,
    102, 86, 119, 160, 41, 190, 129, 200, 203, 83, 169, 167, 98, 219,
    136, 152, 243, 89, 101, 80, 40, 124, 136, 17, 3, 176, 160, 64, 29,
    224, 176, 196, 76, 68, 211, 92, 124, 23, 122, 143, 239, 89, 231,
    81, 74, 228, 38, 193, 5, 143, 21, 80, 131, 68, 194, 177, 102, 239,
    31, 218, 173, 106, 215, 163, 104, 146, 190, 246, 230, 178, 72,
    118, 118, 141, 113, 228, 214, 111, 170, 39, 138, 138, 1, 81, 109,
    12, 68, 130, 57, 29, 232, 97, 27, 35, 113, 160, 43, 42, 59, 162,
    145, 122, 218, 8, 241, 52, 18, 197, 166, 112, 11, 189, 194, 57,
    39, 66, 129, 20, 230, 164, 145, 33, 26, 4, 119, 171, 123, 216,
    177, 80, 204, 73, 0, 251, 232, 179, 91, 181, 108, 132, 182, 161,
    71, 205, 34, 33, 116, 6, 228, 73, 60, 142, 5, 84, 20, 36, 157, 3,
    223, 154, 89, 62, 168, 104, 208, 240, 124, 211, 7, 11, 108, 140,
    139, 70, 164, 84, 128, 123, 162, 230, 40, 196, 118, 215, 52, 12,
    249, 22, 84, 81, 250, 158, 124, 81, 9, 149, 194, 161, 75, 1, 16,
    72, 167, 8, 21, 27, 4, 194, 121, 108, 233, 8, 109, 5, 184, 85,
    119, 36, 137, 168, 166, 34, 27, 71, 191, 52, 169, 238, 7, 100,
    128, 118, 69, 31, 76, 185, 32, 67, 49, 212, 255, 0, 72, 166, 128,
    139, 128, 50, 59, 145, 222, 129, 16, 143, 89, 32, 1, 36, 201, 61,
    171, 27, 182, 226, 51, 89, 248, 52, 192, 231, 112, 128, 129, 163,
    187, 86, 148, 77, 149, 180, 39, 141, 85, 68, 253, 107, 89, 6, 82,
    35, 137, 162, 138, 66, 24, 64, 88, 177, 227, 152, 167, 5, 174, 88,
    34, 65, 153, 18, 56, 166, 36, 235, 114, 66, 193, 168, 169, 147,
    10, 75, 14, 6, 132, 246, 165, 208, 184, 100, 140, 136, 214, 169,
    222, 49, 96, 78, 136, 162, 25, 18, 217, 112, 203, 155, 142, 77,
    84, 21, 68, 76, 139, 28, 238, 30, 126, 41, 25, 130, 169, 111, 207,
    138, 37, 178, 37, 253, 70, 81, 2, 34, 153, 45, 162, 195, 179, 179,
    5, 223, 60, 154, 138, 2, 208, 80, 13, 196, 92, 136, 157, 142, 40,
    8, 25, 158, 195, 64, 69, 47, 166, 122, 150, 150, 103, 91, 125,
    227, 83, 84, 180, 168, 128, 18, 249, 14, 203, 192, 170, 128, 170,
    45, 161, 136, 201, 140, 150, 165, 8, 239, 112, 170, 184, 1, 68,
    236, 154, 42, 11, 168, 132, 135, 36, 247, 162, 69, 193, 145, 86,
    182, 36, 126, 234, 1, 55, 85, 32, 155, 96, 22, 208, 12, 123, 208,
    85, 45, 121, 90, 224, 1, 84, 234, 141, 187, 14, 167, 212, 107,
    138, 9, 58, 212, 131, 68, 33, 55, 64, 96, 53, 178, 123, 126, 40,
    49, 96, 118, 191, 216, 214, 178, 48, 177, 153, 250, 221, 164, 125,
    171, 31, 78, 230, 91, 4, 15, 26, 20, 174, 229, 205, 176, 80, 139,
    98, 34, 55, 34, 162, 140, 190, 19, 49, 151, 0, 208, 10, 136, 178,
    114, 102, 0, 86, 12, 174, 192, 193, 36, 3, 79, 128, 156, 238, 111,
    126, 213, 21, 80, 168, 6, 101, 189, 53, 39, 128, 72, 221, 1, 238,
    113, 167, 0, 3, 0, 241, 84, 102, 247, 30, 203, 218, 160, 134, 245,
    254, 177, 146, 200, 88, 69, 150, 103, 152, 160, 168, 85, 7, 50,
    55, 29, 232, 63, 189, 130, 41, 247, 55, 246, 166, 102, 244, 87,
    245, 93, 21, 219, 137, 63, 249, 172, 171, 109, 1, 111, 115, 57,
    249, 159, 197, 0, 10, 139, 104, 98, 36, 17, 200, 239, 67, 8, 217,
    27, 141, 1, 89, 81, 221, 20, 139, 214, 208, 71, 137, 160, 150, 45,
    51, 128, 93, 238, 17, 201, 58, 21, 20, 138, 115, 82, 72, 144, 141,
    2, 59, 213, 189, 236, 88, 168, 102, 36, 128, 125, 244, 89, 173,
    218, 182, 66, 91, 80, 163, 230, 145, 16, 186, 3, 114, 36, 158, 71,
    2, 170, 10, 18, 78, 129, 239, 205, 44, 159, 84, 52, 104, 120, 62,
    105, 131, 133, 182, 70, 69, 163, 82, 42, 64, 61, 209, 115, 20, 98,
    59, 107, 154, 6, 124, 139, 42, 40, 253, 79, 62, 40, 132, 202, 225,
    80, 165, 128, 136, 36, 83, 132, 10, 141, 130, 97, 60, 182, 116,
    132, 54, 130, 220, 42, 187, 146, 68, 212, 83, 17, 13, 163, 223,
    154, 84, 247, 3, 178, 64, 59, 34, 143, 166, 92, 144, 33, 152, 234,
    127, 164, 83, 64, 69, 192, 25, 29, 200, 239, 64, 136, 71, 172,
    144, 0, 146, 100, 158, 213, 141, 219, 113, 25, 172, 252, 26, 96,
    115, 184, 64, 64, 209, 221, 171, 74, 38, 202, 218, 19, 198, 170,
    162, 126, 181, 172, 131, 41, 17, 196, 209, 69, 33, 12, 32, 44, 88,
    241, 204, 83, 130, 215, 44, 17, 32, 204, 137, 28, 83, 18, 117,
    185, 33, 96, 212, 84, 201, 133, 37, 135, 3, 66, 123, 82, 232, 92,
    50, 70, 68, 107, 84, 239, 24, 176, 39, 68, 81, 12, 137, 108, 184,
    101, 205, 199, 38, 170, 10, 162, 38, 69, 142, 119, 15, 63, 20,
    140, 193, 84, 183, 231, 197, 18, 217, 18, 254, 163, 40, 129, 17,
    76, 150, 209, 97, 217, 217, 130, 239, 158, 77, 69, 33, 71, 42, 64,
    117, 19, 38, 99, 138, 101, 183, 109, 84, 44, 72, 28, 201, 230,
    129, 128, 126, 40, 2, 69, 144, 197, 57, 18, 35, 81, 64, 10, 102,
    235, 108, 3, 28, 159, 181, 61, 203, 202, 33, 32, 133, 29, 200,
    172, 182, 242, 45, 238, 35, 40, 154, 50, 168, 33, 73, 17, 243, 64,
    182, 221, 13, 194, 17, 86, 48, 157, 10, 193, 253, 173, 144, 110,
    96, 10, 57, 198, 192, 3, 201, 141, 208, 9, 9, 153, 186, 209, 162,
    0, 160, 91, 151, 144, 123, 75, 144, 72, 226, 14, 168, 253, 66, 21,
    206, 244, 79, 138, 75, 142, 134, 226, 91, 181, 112, 43, 179, 0,
    204, 91, 96, 87, 69, 235, 23, 45, 155, 142, 29, 89, 45, 13, 72,
    146, 91, 239, 222, 170, 2, 98, 161, 130, 204, 68, 73, 59, 38, 164,
    81, 152, 192, 69, 81, 228, 138, 40, 196, 116, 233, 146, 186, 147,
    238, 57, 14, 244, 224, 113, 227, 201, 168, 160, 67, 42, 149, 87,
    5, 143, 115, 196, 210, 170, 34, 0, 99, 55, 153, 44, 68, 193, 160,
    204, 5, 182, 220, 236, 64, 249, 166, 198, 64, 114, 197, 76, 104,
    10, 1, 30, 166, 64, 93, 32, 76, 141, 81, 22, 145, 88, 130, 247,
    27, 238, 100, 80, 146, 24, 201, 44, 60, 129, 255, 0, 20, 200, 21,
    20, 177, 80, 9, 208, 248, 20, 8, 66, 5, 38, 15, 230, 157, 28, 32,
    4, 90, 32, 129, 245, 26, 80, 22, 38, 9, 7, 152, 60, 211, 251, 220,
    2, 99, 197, 1, 14, 49, 35, 83, 223, 226, 164, 63, 83, 217, 36,
    192, 222, 181, 84, 108, 102, 52, 99, 205, 39, 208, 133, 84, 24,
    110, 72, 160, 114, 197, 166, 56, 236, 41, 2, 157, 2, 68, 9, 212,
    115, 70, 37, 120, 34, 71, 115, 186, 16, 0, 240, 6, 232, 29, 113,
    1, 224, 192, 236, 0, 169, 194, 151, 32, 158, 99, 154, 166, 193, 6,
    53, 26, 17, 205, 42, 182, 0, 179, 48, 2, 35, 116, 26, 229, 196,
    114, 2, 17, 18, 63, 138, 98, 224, 51, 42, 184, 129, 205, 74, 210,
    255, 0, 152, 107, 247, 13, 240, 169, 110, 2, 128, 218, 39, 230,
    159, 208, 123, 66, 210, 221, 37, 178, 222, 42, 156, 125, 234, 160,
    7, 70, 16, 16, 71, 192, 226, 156, 54, 34, 21, 20, 19, 241, 20,
    160, 128, 72, 243, 189, 214, 0, 161, 44, 64, 45, 242, 56, 168,
    166, 7, 21, 19, 25, 70, 200, 60, 82, 16, 155, 121, 109, 13, 86,
    48, 4, 147, 51, 219, 176, 160, 67, 92, 146, 68, 91, 31, 137, 160,
    200, 50, 80, 202, 237, 31, 53, 186, 123, 194, 207, 81, 233, 165,
    166, 188, 228, 123, 192, 215, 127, 52, 190, 173, 157, 151, 234,
    173, 174, 35, 132, 34, 106, 191, 225, 57, 139, 119, 46, 45, 182,
    103, 184, 198, 12, 114, 60, 238, 180, 202, 185, 116, 215, 122,
    171, 151, 186, 171, 75, 109, 17, 66, 170, 48, 159, 227, 239, 72,
    246, 229, 139, 250, 65, 16, 159, 108, 61, 118, 175, 78, 46, 89,
    184, 151, 28, 44, 151, 37, 162, 99, 219, 92, 173, 119, 166, 61,
    61, 164, 86, 102, 184, 32, 22, 154, 203, 72, 20, 114, 164, 7, 81,
    50, 102, 56, 166, 91, 118, 213, 66, 196, 129, 204, 158, 104, 24,
    7, 226, 128, 36, 89, 12, 83, 145, 34, 53, 20, 0, 166, 110, 182,
    192, 49, 201, 251, 83, 220, 188, 162, 18, 8, 81, 220, 138, 203,
    111, 34, 222, 226, 50, 137, 163, 42, 130, 20, 145, 31, 52, 11,
    109, 208, 220, 33, 21, 99, 9, 208, 172, 31, 218, 217, 6, 230, 0,
    163, 156, 108, 0, 60, 152, 221, 0, 144, 153, 155, 173, 26, 32, 10,
    5, 185, 121, 7, 180, 185, 4, 142, 32, 234, 143, 212, 33, 92, 239,
    68, 248, 164, 184, 232, 110, 37, 187, 87, 2, 187, 48, 12, 197,
    182, 5, 116, 94, 177, 114, 217, 184, 225, 213, 146, 208, 212, 137,
    37, 190, 253, 234, 160, 38, 42, 24, 44, 196, 68, 147, 178, 106,
    69, 25, 140, 4, 85, 30, 72, 162, 140, 71, 78, 153, 43, 169, 62,
    227, 144, 239, 78, 7, 30, 60, 154, 138, 4, 50, 169, 85, 112, 88,
    247, 60, 77, 42, 162, 32, 6, 51, 121, 146, 196, 76, 26, 12, 192,
    91, 109, 206, 196, 15, 154, 108, 100, 7, 44, 84, 198, 128, 160,
    17, 234, 100, 5, 210, 4, 200, 213, 17, 105, 21, 136, 47, 113, 190,
    230, 69, 9, 33, 140, 146, 195, 200, 31, 241, 76, 129, 81, 75, 21,
    0, 157, 15, 129, 64, 132, 32, 82, 96, 254, 105, 209, 194, 0, 69,
    162, 8, 31, 81, 165, 1, 98, 96, 144, 121, 131, 205, 63, 189, 192,
    38, 60, 80, 16, 227, 18, 53, 61, 254, 42, 67, 245, 61, 146, 76,
    13, 235, 85, 70, 198, 99, 70, 60, 210, 125, 8, 85, 65, 134, 228,
    138, 2, 200, 130, 88, 185, 208, 226, 153, 85, 8, 247, 172, 199, 0,
    113, 83, 196, 17, 254, 161, 198, 119, 151, 122, 46, 36, 204, 157,
    68, 15, 138, 10, 59, 230, 32, 129, 29, 252, 84, 208, 12, 1, 32,
    100, 124, 118, 160, 89, 2, 228, 88, 65, 19, 39, 189, 5, 97, 115,
    65, 88, 0, 121, 52, 5, 193, 194, 11, 76, 154, 157, 214, 185, 126,
    242, 244, 182, 1, 16, 33, 200, 28, 124, 83, 222, 80, 150, 89, 203,
    251, 84, 100, 65, 248, 174, 207, 240, 171, 62, 151, 75, 234, 148,
    38, 245, 239, 118, 94, 42, 161, 172, 127, 134, 244, 221, 61, 132,
    70, 180, 173, 115, 101, 139, 123, 136, 251, 210, 93, 233, 236,
    116, 223, 173, 238, 101, 181, 45, 232, 131, 175, 252, 87, 101,
    231, 183, 211, 218, 15, 113, 206, 77, 251, 64, 154, 230, 191, 126,
    219, 116, 151, 23, 31, 123, 130, 11, 26, 138, 157, 209, 212, 117,
    45, 171, 22, 209, 15, 210, 179, 181, 21, 205, 113, 109, 219, 18,
    129, 129, 224, 65, 228, 215, 106, 245, 88, 218, 192, 38, 79, 132,
    22, 53, 200, 64, 87, 23, 9, 218, 157, 14, 121, 160, 194, 213, 193,
    112, 23, 42, 202, 190, 59, 154, 104, 114, 73, 32, 3, 61, 232, 67,
    33, 201, 253, 199, 57, 2, 149, 230, 103, 40, 19, 199, 154, 2, 27,
    11, 210, 222, 208, 7, 51, 88, 58, 52, 153, 4, 159, 154, 24, 54,
    80, 12, 179, 30, 99, 138, 127, 210, 203, 11, 104, 52, 54, 213, 80,
    186, 49, 58, 3, 193, 166, 31, 72, 0, 100, 123, 10, 69, 68, 134,
    110, 199, 193, 162, 72, 6, 3, 152, 249, 168, 172, 229, 130, 25,
    217, 58, 243, 88, 184, 69, 145, 18, 59, 10, 80, 174, 110, 45, 199,
    0, 32, 144, 7, 147, 79, 131, 145, 238, 214, 90, 2, 120, 170, 133,
    250, 66, 168, 50, 213, 145, 49, 0, 183, 35, 176, 255, 0, 181, 62,
    72, 146, 168, 210, 221, 207, 49, 72, 211, 143, 4, 253, 142, 234,
    40, 51, 98, 93, 238, 48, 133, 6, 72, 164, 233, 58, 84, 234, 201,
    189, 212, 182, 40, 76, 173, 191, 35, 201, 165, 188, 162, 235, 90,
    233, 198, 195, 185, 200, 207, 97, 205, 123, 105, 109, 45, 90, 75,
    80, 25, 155, 109, 63, 182, 171, 46, 117, 232, 186, 99, 5, 173,
    128, 20, 202, 129, 175, 239, 82, 75, 190, 135, 84, 45, 91, 182,
    110, 220, 112, 88, 51, 29, 10, 233, 107, 253, 45, 182, 57, 92,
    120, 241, 21, 11, 189, 67, 191, 83, 110, 232, 68, 193, 83, 0, 179,
    218, 163, 78, 114, 151, 81, 166, 234, 40, 249, 28, 126, 40, 96,
    75, 9, 32, 1, 184, 154, 183, 85, 117, 29, 81, 118, 175, 220, 41,
    169, 97, 115, 16, 101, 84, 158, 73, 230, 131, 50, 41, 16, 101,
    167, 248, 21, 43, 233, 254, 97, 186, 123, 36, 149, 87, 62, 224,
    167, 144, 59, 85, 13, 149, 19, 149, 194, 223, 142, 105, 128, 25,
    43, 240, 80, 202, 253, 234, 163, 176, 116, 157, 61, 180, 10, 58,
    123, 112, 56, 246, 131, 85, 76, 218, 214, 22, 178, 1, 90, 4, 14,
    42, 107, 213, 36, 77, 197, 121, 240, 13, 78, 231, 95, 113, 213,
    210, 202, 226, 38, 0, 94, 77, 70, 151, 191, 121, 58, 78, 154, 229,
    182, 189, 147, 177, 141, 15, 166, 188, 228, 197, 152, 48, 80, 163,
    136, 199, 116, 85, 66, 25, 127, 117, 206, 72, 61, 143, 154, 89,
    146, 119, 207, 122, 136, 204, 136, 37, 139, 157, 14, 41, 149, 80,
    143, 122, 204, 112, 7, 21, 60, 65, 31, 234, 28, 103, 121, 119,
    162, 226, 76, 201, 212, 64, 248, 170, 40, 239, 152, 130, 4, 119,
    241, 83, 64, 48, 4, 129, 145, 241, 218, 129, 100, 11, 145, 97, 4,
    76, 158, 244, 21, 133, 205, 5, 96, 1, 228, 208, 23, 7, 8, 45, 50,
    106, 119, 90, 229, 251, 203, 210, 216, 4, 64, 135, 32, 113, 241,
    79, 121, 66, 89, 103, 47, 237, 81, 145, 7, 226, 187, 63, 194, 172,
    250, 93, 47, 170, 80, 155, 215, 189, 217, 120, 170, 134, 177, 254,
    27, 211, 116, 246, 17, 26, 210, 181, 205, 150, 45, 238, 35, 239,
    73, 119, 167, 177, 211, 126, 183, 185, 150, 212, 183, 162, 14,
    191, 241, 93, 151, 158, 223, 79, 104, 61, 199, 57, 55, 237, 2,
    107, 154, 253, 251, 109, 210, 92, 92, 125, 238, 8, 44, 106, 42,
    119, 71, 81, 212, 182, 172, 91, 68, 63, 74, 206, 212, 87, 53, 197,
    183, 108, 74, 6, 7, 129, 7, 147, 93, 171, 213, 99, 107, 0, 153,
    62, 16, 88, 215, 33, 1, 92, 92, 39, 106, 116, 57, 230, 131, 11,
    87, 5, 192, 92, 171, 42, 248, 238, 105, 161, 201, 36, 128, 12,
    247, 161, 12, 135, 39, 247, 28, 228, 10, 87, 153, 156, 160, 79,
    30, 104, 8, 108, 47, 75, 123, 64, 28, 205, 96, 232, 210, 100, 18,
    126, 104, 96, 217, 64, 50, 204, 121, 142, 41, 255, 0, 75, 44, 45,
    160, 208, 219, 85, 66, 232, 196, 232, 15, 6, 152, 125, 32, 1, 145,
    236, 41, 21, 18, 25, 187, 31, 6, 137, 32, 24, 14, 99, 230, 162,
    179, 150, 8, 103, 100, 235, 205, 98, 225, 22, 68, 72, 236, 41, 66,
    185, 184, 183, 28, 0, 130, 64, 30, 77, 62, 14, 71, 187, 89, 104,
    9, 226, 170, 20, 25, 144, 45, 229, 137, 131, 60, 214, 194, 230,
    94, 235, 101, 123, 140, 90, 103, 241, 77, 109, 203, 45, 199, 72,
    85, 157, 159, 39, 188, 80, 102, 104, 4, 19, 32, 212, 80, 22, 208,
    196, 218, 245, 35, 140, 180, 5, 57, 245, 29, 129, 103, 182, 170,
    59, 10, 217, 19, 39, 71, 189, 72, 17, 128, 146, 192, 198, 216,
    138, 168, 207, 101, 93, 138, 187, 150, 86, 17, 2, 189, 46, 146,
    95, 165, 182, 144, 37, 68, 16, 107, 129, 133, 185, 159, 84, 176,
    243, 168, 160, 111, 0, 21, 128, 98, 199, 250, 118, 104, 58, 250,
    219, 96, 178, 32, 186, 24, 175, 99, 251, 77, 115, 92, 96, 21, 80,
    31, 104, 57, 57, 249, 164, 13, 126, 225, 149, 176, 64, 61, 216,
    199, 246, 160, 65, 91, 37, 219, 18, 199, 184, 58, 158, 42, 41,
    189, 247, 62, 144, 21, 99, 69, 169, 144, 11, 108, 70, 220, 141,
    201, 226, 153, 201, 26, 7, 143, 205, 72, 50, 230, 7, 39, 192, 52,
    20, 230, 167, 108, 151, 30, 163, 60, 185, 58, 30, 43, 94, 37, 109,
    57, 28, 198, 183, 76, 228, 116, 246, 85, 64, 247, 1, 252, 154, 6,
    148, 81, 25, 73, 157, 153, 160, 140, 74, 18, 4, 41, 208, 249, 160,
    187, 219, 13, 131, 193, 20, 218, 114, 16, 14, 63, 138, 8, 187, 61,
    219, 214, 250, 123, 46, 169, 32, 146, 222, 63, 21, 91, 160, 244,
    150, 212, 222, 112, 192, 152, 6, 57, 169, 45, 198, 55, 146, 207,
    77, 109, 110, 58, 201, 98, 220, 1, 93, 183, 26, 46, 219, 187, 213,
    89, 2, 218, 33, 16, 130, 119, 85, 28, 227, 22, 182, 10, 201, 203,
    131, 205, 12, 19, 60, 152, 229, 255, 0, 199, 197, 93, 209, 220,
    122, 231, 4, 70, 218, 164, 238, 42, 4, 128, 50, 39, 66, 162, 178,
    171, 50, 7, 99, 110, 210, 246, 3, 152, 172, 82, 222, 139, 57, 98,
    55, 163, 253, 226, 133, 178, 125, 18, 207, 237, 247, 72, 159, 6,
    153, 61, 243, 115, 120, 240, 4, 115, 243, 64, 109, 42, 45, 235,
    87, 21, 4, 91, 59, 147, 230, 189, 49, 13, 250, 172, 224, 14, 126,
    170, 242, 240, 112, 161, 3, 196, 242, 13, 42, 251, 16, 206, 137,
    242, 104, 30, 227, 23, 188, 238, 88, 5, 157, 8, 230, 130, 179,
    184, 55, 53, 28, 44, 247, 52, 139, 36, 24, 1, 137, 226, 120, 53,
    70, 208, 8, 28, 24, 31, 138, 1, 136, 182, 164, 147, 157, 195, 203,
    80, 103, 49, 49, 144, 248, 52, 12, 177, 136, 49, 222, 139, 76, 4,
    83, 31, 246, 170, 128, 136, 8, 46, 192, 201, 58, 237, 21, 160,
    141, 153, 62, 13, 80, 203, 164, 118, 3, 117, 57, 8, 34, 116, 52,
    79, 21, 20, 100, 129, 219, 124, 26, 196, 139, 105, 237, 217, 237,
    174, 245, 134, 44, 232, 24, 72, 231, 226, 138, 34, 3, 152, 217,
    61, 207, 2, 170, 49, 75, 182, 214, 50, 82, 123, 206, 191, 138, 88,
    117, 246, 50, 144, 79, 244, 238, 139, 186, 228, 196, 158, 62, 107,
    41, 33, 56, 130, 119, 196, 84, 80, 6, 100, 11, 121, 98, 96, 207,
    53, 176, 185, 151, 186, 217, 94, 227, 22, 153, 252, 83, 91, 114,
    203, 113, 210, 21, 103, 103, 201, 239, 20, 25, 154, 1, 4, 200, 52,
    0, 91, 67, 19, 107, 212, 142, 50, 208, 20, 231, 212, 118, 5, 158,
    218, 168, 236, 43, 100, 76, 157, 30, 245, 32, 70, 2, 75, 3, 27,
    98, 42, 163, 61, 149, 118, 42, 238, 89, 88, 68, 10, 244, 186, 73,
    126, 150, 218, 64, 149, 16, 65, 174, 6, 22, 230, 125, 82, 195,
    206, 162, 129, 188, 0, 86, 1, 139, 31, 233, 217, 160, 235, 235,
    109, 130, 200, 130, 232, 98, 189, 143, 237, 53, 205, 113, 128, 85,
    64, 125, 160, 228, 231, 230, 144, 53, 251, 134, 86, 193, 0, 247,
    99, 31, 218, 129, 5, 108, 151, 108, 75, 30, 224, 234, 120, 168,
    166, 247, 220, 250, 64, 85, 141, 22, 166, 64, 45, 177, 27, 114,
    55, 39, 138, 103, 36, 104, 30, 63, 53, 32, 203, 152, 28, 159, 0,
    208, 83, 154, 157, 178, 92, 122, 140, 242, 228, 232, 120, 173,
    120, 149, 180, 228, 115, 26, 221, 51, 145, 211, 217, 85, 3, 220,
    7, 242, 104, 26, 81, 68, 101, 38, 118, 102, 130, 49, 40, 72, 16,
    167, 67, 230, 130, 239, 108, 54, 15, 4, 83, 105, 200, 64, 56, 254,
    40, 34, 236, 247, 111, 91, 233, 236, 186, 164, 130, 75, 120, 252,
    85, 110, 131, 210, 91, 83, 121, 195, 2, 96, 24, 230, 164, 183, 24,
    222, 75, 61, 53, 181, 184, 235, 37, 139, 112, 5, 118, 220, 104,
    187, 110, 239, 85, 100, 11, 104, 132, 66, 9, 221, 84, 115, 140,
    90, 216, 43, 39, 46, 15, 52, 48, 76, 242, 99, 151, 255, 0, 31, 21,
    119, 71, 113, 235, 156, 17, 27, 106, 147, 184, 168, 18, 0, 200,
    157, 10, 138, 44, 233, 110, 216, 183, 176, 23, 91, 169, 171, 151,
    230, 62, 194, 170, 138, 138, 185, 25, 98, 222, 117, 65, 157, 158,
    224, 182, 161, 64, 137, 38, 59, 80, 34, 169, 244, 152, 49, 80, 64,
    136, 240, 42, 137, 34, 73, 60, 174, 162, 151, 211, 44, 67, 22, 76,
    126, 23, 159, 154, 71, 233, 255, 0, 204, 117, 73, 110, 227, 227,
    107, 19, 161, 220, 213, 70, 183, 131, 11, 142, 45, 6, 1, 177, 17,
    193, 170, 143, 83, 41, 119, 195, 188, 32, 167, 234, 122, 102, 233,
    172, 218, 181, 211, 90, 118, 13, 63, 87, 3, 230, 164, 200, 246,
    238, 48, 184, 88, 220, 2, 98, 162, 154, 125, 216, 143, 104, 228,
    73, 165, 75, 86, 241, 25, 172, 193, 208, 147, 2, 179, 2, 54, 62,
    160, 100, 79, 154, 4, 131, 108, 203, 64, 35, 154, 0, 75, 117, 12,
    203, 104, 128, 63, 123, 246, 21, 72, 68, 1, 20, 72, 2, 9, 35, 154,
    192, 159, 69, 64, 42, 7, 129, 75, 13, 49, 49, 65, 133, 187, 115,
    182, 32, 13, 196, 234, 136, 192, 203, 230, 89, 143, 127, 20, 160,
    32, 118, 44, 160, 129, 0, 86, 0, 135, 109, 1, 150, 193, 21, 80,
    243, 32, 201, 199, 228, 246, 174, 102, 234, 108, 22, 40, 151, 24,
    219, 93, 187, 42, 147, 63, 19, 20, 111, 163, 92, 91, 125, 58, 233,
    9, 80, 204, 59, 15, 21, 235, 45, 128, 170, 182, 173, 176, 75, 75,
    168, 65, 12, 212, 28, 63, 225, 135, 59, 151, 174, 4, 101, 70, 140,
    73, 214, 128, 175, 73, 109, 228, 82, 65, 80, 199, 189, 16, 114, 2,
    221, 171, 67, 241, 73, 126, 224, 233, 214, 1, 202, 231, 19, 253,
    53, 26, 112, 171, 89, 179, 101, 237, 224, 75, 130, 125, 204, 103,
    189, 64, 32, 118, 32, 157, 13, 157, 211, 149, 66, 202, 15, 36,
    229, 170, 119, 22, 246, 170, 33, 124, 10, 172, 164, 101, 199, 212,
    9, 114, 49, 3, 227, 189, 23, 14, 27, 12, 243, 142, 220, 83, 164,
    162, 155, 133, 3, 49, 16, 24, 118, 20, 179, 51, 29, 170, 40, 42,
    32, 137, 12, 35, 177, 61, 232, 229, 193, 98, 1, 39, 75, 28, 83, 0,
    20, 73, 114, 206, 78, 201, 21, 177, 130, 75, 25, 184, 121, 248,
    160, 84, 151, 110, 0, 222, 140, 214, 102, 85, 34, 117, 58, 172, 1,
    19, 4, 0, 126, 40, 162, 12, 189, 91, 144, 72, 210, 47, 143, 154,
    5, 82, 73, 50, 73, 51, 226, 178, 49, 55, 24, 41, 146, 218, 143,
    138, 192, 98, 167, 30, 79, 111, 21, 173, 140, 3, 96, 76, 177, 231,
    189, 6, 123, 128, 40, 181, 105, 51, 184, 116, 107, 11, 74, 135,
    43, 228, 59, 129, 33, 7, 210, 180, 225, 209, 22, 17, 113, 158,
    253, 205, 42, 33, 121, 217, 128, 76, 213, 66, 201, 43, 0, 133, 99,
    199, 218, 159, 4, 35, 38, 202, 7, 16, 99, 42, 38, 11, 8, 208, 160,
    192, 177, 4, 184, 197, 71, 17, 81, 64, 218, 66, 144, 192, 130,
    251, 39, 184, 172, 81, 154, 97, 164, 48, 136, 61, 171, 2, 73, 23,
    26, 54, 116, 38, 182, 100, 145, 9, 198, 228, 138, 168, 44, 233,
    110, 216, 183, 176, 23, 91, 169, 171, 151, 230, 62, 194, 170, 138,
    138, 185, 25, 98, 222, 117, 65, 157, 158, 224, 182, 161, 64, 137,
    38, 59, 84, 82, 42, 159, 73, 131, 21, 4, 8, 143, 2, 168, 146, 36,
    147, 202, 234, 41, 125, 50, 196, 49, 100, 199, 225, 121, 249, 164,
    126, 159, 252, 199, 84, 150, 238, 62, 54, 177, 58, 29, 205, 84,
    107, 120, 48, 184, 226, 208, 96, 27, 17, 28, 26, 168, 245, 50,
    151, 124, 59, 194, 10, 126, 167, 166, 110, 154, 205, 171, 93, 53,
    167, 96, 211, 245, 112, 62, 106, 76, 143, 110, 227, 11, 133, 141,
    192, 38, 42, 41, 167, 221, 136, 246, 142, 68, 154, 84, 181, 111,
    17, 154, 204, 29, 9, 48, 43, 48, 35, 99, 234, 6, 68, 249, 160, 72,
    54, 204, 180, 2, 57, 160, 4, 183, 80, 204, 182, 136, 3, 247, 191,
    97, 84, 132, 64, 17, 68, 128, 32, 146, 57, 172, 9, 244, 84, 2,
    160, 120, 20, 176, 211, 19, 20, 24, 91, 183, 59, 98, 0, 220, 78,
    168, 140, 12, 190, 101, 152, 247, 241, 74, 2, 7, 98, 202, 8, 16,
    5, 96, 8, 118, 208, 25, 108, 17, 85, 15, 50, 12, 156, 126, 79,
    106, 230, 110, 166, 193, 98, 137, 113, 141, 181, 219, 178, 169,
    51, 241, 49, 70, 250, 53, 197, 183, 211, 174, 144, 149, 12, 195,
    176, 241, 94, 178, 216, 10, 171, 106, 219, 4, 180, 186, 132, 16,
    205, 65, 195, 254, 24, 115, 185, 122, 224, 70, 84, 104, 196, 157,
    104, 10, 244, 150, 222, 69, 36, 21, 12, 123, 209, 7, 32, 45, 218,
    180, 63, 20, 151, 238, 14, 157, 96, 28, 174, 113, 63, 211, 81,
    167, 10, 181, 155, 54, 94, 222, 4, 184, 39, 220, 198, 123, 212, 2,
    7, 98, 9, 208, 217, 221, 57, 84, 44, 160, 242, 78, 90, 167, 113,
    111, 106, 162, 23, 192, 170, 202, 88, 187, 233, 26, 214, 185, 150,
    221, 96, 183, 109, 230, 229, 173, 201, 215, 60, 10, 118, 33, 109,
    174, 43, 0, 14, 59, 212, 122, 140, 109, 217, 119, 36, 183, 27,
    252, 212, 85, 88, 146, 152, 200, 152, 220, 82, 91, 15, 123, 170,
    9, 105, 141, 181, 182, 1, 46, 57, 147, 90, 58, 139, 170, 110, 158,
    145, 97, 140, 137, 112, 166, 43, 167, 161, 177, 113, 5, 247, 185,
    25, 220, 35, 75, 251, 71, 137, 170, 138, 100, 235, 120, 186, 94,
    61, 69, 208, 152, 15, 84, 241, 92, 238, 214, 222, 215, 174, 175,
    113, 238, 240, 204, 6, 135, 154, 245, 122, 123, 78, 193, 152, 192,
    197, 120, 97, 255, 0, 218, 188, 193, 117, 214, 122, 101, 54, 197,
    182, 146, 113, 214, 166, 162, 165, 233, 2, 13, 199, 114, 79, 0,
    14, 194, 155, 7, 192, 42, 219, 4, 113, 205, 6, 185, 147, 1, 108,
    101, 6, 53, 197, 0, 8, 92, 217, 199, 213, 16, 40, 8, 85, 81, 0,
    127, 6, 131, 2, 117, 220, 235, 124, 81, 141, 131, 222, 181, 196,
    5, 75, 92, 114, 4, 125, 32, 243, 65, 131, 40, 56, 233, 238, 19,
    176, 189, 190, 244, 28, 51, 44, 152, 202, 103, 91, 170, 59, 20,
    132, 182, 21, 71, 129, 222, 145, 87, 25, 0, 228, 211, 145, 142, 5,
    1, 56, 186, 12, 128, 61, 200, 61, 170, 214, 58, 175, 77, 36, 160,
    147, 198, 207, 21, 21, 71, 80, 193, 238, 41, 118, 220, 40, 226,
    155, 4, 64, 16, 115, 220, 205, 5, 159, 172, 186, 87, 12, 176, 83,
    251, 71, 154, 230, 36, 147, 61, 183, 67, 49, 235, 5, 212, 129, 36,
    247, 20, 25, 2, 219, 102, 105, 95, 151, 241, 85, 14, 138, 77, 178,
    224, 109, 142, 167, 138, 86, 144, 166, 68, 255, 0, 211, 186, 103,
    112, 45, 172, 100, 68, 107, 157, 210, 53, 204, 39, 32, 65, 237,
    29, 234, 40, 61, 209, 4, 135, 26, 253, 177, 84, 113, 233, 89, 0,
    157, 129, 36, 214, 183, 109, 238, 16, 247, 213, 18, 216, 51, 7,
    234, 160, 229, 11, 207, 8, 12, 196, 243, 85, 12, 137, 138, 102,
    127, 118, 192, 34, 148, 19, 113, 240, 83, 175, 220, 222, 42, 96,
    155, 236, 66, 142, 221, 143, 63, 21, 133, 135, 187, 212, 27, 79,
    121, 173, 90, 80, 61, 168, 99, 159, 38, 130, 144, 170, 103, 51,
    136, 238, 104, 185, 8, 171, 32, 230, 76, 69, 11, 182, 197, 142,
    173, 44, 149, 187, 115, 17, 145, 129, 49, 226, 107, 16, 89, 243,
    32, 230, 78, 190, 40, 54, 15, 26, 42, 60, 152, 172, 9, 55, 177,
    88, 32, 15, 115, 79, 21, 154, 218, 219, 62, 201, 147, 201, 39,
    147, 65, 45, 27, 146, 24, 156, 9, 146, 69, 1, 73, 118, 32, 111,
    230, 43, 9, 68, 2, 7, 243, 76, 204, 98, 23, 107, 226, 55, 83, 32,
    51, 166, 76, 21, 65, 147, 81, 76, 176, 87, 218, 105, 116, 207,
    132, 228, 6, 216, 246, 166, 33, 12, 62, 97, 73, 152, 131, 218,
    131, 42, 217, 233, 202, 2, 25, 155, 150, 61, 205, 84, 53, 168, 91,
    11, 161, 63, 247, 160, 75, 146, 0, 147, 240, 40, 140, 91, 217, 26,
    195, 102, 123, 138, 80, 153, 41, 57, 21, 183, 220, 207, 63, 106,
    138, 24, 187, 233, 26, 214, 185, 150, 221, 96, 183, 109, 230, 229,
    173, 201, 215, 60, 10, 118, 33, 109, 174, 43, 0, 14, 59, 212, 122,
    140, 109, 217, 119, 36, 183, 27, 252, 208, 85, 137, 41, 140, 137,
    141, 197, 37, 176, 247, 186, 160, 150, 152, 219, 91, 96, 18, 227,
    153, 53, 163, 168, 186, 166, 233, 233, 22, 24, 200, 151, 10, 98,
    186, 122, 27, 23, 16, 95, 123, 145, 157, 194, 52, 191, 180, 120,
    154, 168, 166, 78, 183, 139, 165, 227, 212, 93, 9, 128, 245, 79,
    21, 206, 237, 109, 237, 122, 234, 247, 30, 239, 12, 192, 104, 121,
    175, 87, 167, 180, 236, 25, 140, 12, 87, 134, 31, 253, 171, 204,
    23, 93, 103, 166, 83, 108, 91, 105, 39, 29, 106, 106, 42, 94, 144,
    32, 220, 119, 36, 240, 0, 236, 41, 176, 124, 2, 173, 176, 71, 28,
    208, 107, 153, 48, 22, 198, 80, 99, 92, 80, 0, 133, 205, 156, 125,
    81, 2, 128, 133, 85, 16, 7, 240, 104, 48, 39, 93, 206, 183, 197,
    24, 216, 61, 235, 92, 64, 84, 181, 199, 32, 71, 210, 15, 52, 24,
    50, 131, 142, 158, 225, 59, 11, 219, 239, 65, 195, 50, 201, 140,
    166, 117, 186, 163, 177, 72, 75, 97, 84, 120, 29, 233, 21, 113,
    144, 14, 77, 57, 24, 224, 80, 19, 139, 160, 200, 3, 220, 131, 218,
    173, 99, 170, 244, 210, 74, 9, 60, 108, 241, 81, 84, 117, 12, 30,
    226, 151, 109, 194, 142, 41, 176, 68, 1, 7, 61, 204, 208, 89, 250,
    203, 165, 112, 203, 5, 63, 180, 121, 174, 98, 73, 51, 219, 116,
    51, 30, 176, 93, 72, 18, 79, 113, 65, 144, 45, 182, 102, 149, 249,
    127, 21, 80, 232, 164, 219, 46, 6, 216, 234, 120, 165, 105, 10,
    100, 79, 253, 59, 166, 119, 2, 218, 198, 68, 70, 185, 221, 35, 92,
    194, 114, 4, 30, 209, 222, 162, 153, 6, 182, 240, 0, 237, 222,
    161, 212, 168, 123, 74, 20, 232, 56, 49, 231, 123, 174, 132, 39,
    133, 217, 254, 107, 42, 67, 2, 78, 70, 32, 154, 168, 244, 130,
    139, 172, 206, 190, 219, 99, 130, 220, 154, 163, 132, 65, 36, 149,
    70, 212, 247, 53, 192, 189, 85, 224, 176, 28, 170, 70, 135, 138,
    149, 235, 175, 112, 16, 206, 88, 158, 55, 197, 72, 181, 211, 212,
    245, 195, 3, 102, 215, 182, 223, 4, 159, 221, 92, 54, 208, 3, 118,
    227, 130, 75, 113, 62, 41, 237, 224, 182, 65, 8, 13, 195, 201,
    109, 238, 131, 144, 62, 182, 153, 254, 245, 80, 32, 102, 20, 0,
    20, 9, 250, 123, 209, 40, 184, 201, 94, 242, 62, 244, 195, 80, 72,
    202, 62, 41, 76, 29, 180, 226, 60, 248, 168, 165, 192, 57, 213,
    178, 88, 158, 65, 129, 89, 237, 219, 69, 95, 86, 229, 194, 73,
    250, 84, 243, 84, 5, 204, 152, 197, 8, 142, 98, 105, 81, 81, 61,
    216, 239, 183, 122, 168, 157, 230, 4, 31, 124, 19, 4, 44, 238,
    168, 242, 50, 80, 164, 15, 138, 42, 168, 80, 92, 100, 82, 91, 202,
    246, 251, 209, 121, 36, 78, 129, 241, 226, 162, 130, 40, 89, 36,
    147, 113, 187, 118, 2, 149, 136, 69, 45, 63, 222, 182, 54, 203,
    16, 110, 92, 144, 56, 154, 198, 210, 125, 94, 179, 16, 166, 119,
    186, 3, 111, 244, 109, 201, 99, 147, 12, 140, 141, 209, 180, 138,
    3, 220, 123, 121, 49, 60, 183, 138, 77, 59, 146, 164, 176, 95,
    138, 161, 75, 142, 76, 172, 2, 53, 189, 80, 27, 175, 113, 208,
    226, 96, 246, 165, 176, 21, 23, 53, 95, 212, 63, 184, 153, 164,
    91, 61, 75, 116, 201, 116, 50, 230, 228, 226, 132, 68, 9, 172,
    161, 69, 231, 178, 72, 47, 201, 0, 72, 7, 239, 85, 14, 73, 112,
    73, 57, 22, 230, 104, 17, 44, 2, 250, 115, 218, 104, 225, 237,
    128, 208, 79, 36, 10, 70, 100, 180, 140, 229, 130, 168, 229, 141,
    3, 155, 145, 105, 66, 129, 19, 30, 193, 19, 75, 101, 122, 155,
    189, 67, 132, 41, 108, 47, 180, 146, 39, 126, 41, 83, 169, 124,
    15, 165, 211, 94, 97, 204, 226, 63, 228, 215, 95, 65, 102, 229,
    187, 14, 110, 128, 172, 238, 94, 39, 143, 20, 25, 46, 245, 22, 22,
    229, 230, 81, 113, 218, 37, 151, 92, 84, 238, 132, 7, 212, 255, 0,
    50, 110, 220, 127, 123, 0, 56, 251, 87, 117, 172, 25, 175, 0, 50,
    66, 134, 124, 87, 3, 117, 0, 116, 34, 202, 219, 1, 83, 247, 119,
    168, 169, 6, 6, 49, 6, 73, 129, 84, 18, 170, 68, 12, 70, 167, 230,
    179, 17, 98, 217, 39, 152, 129, 83, 8, 134, 218, 160, 99, 49, 46,
    102, 129, 131, 18, 120, 38, 119, 49, 64, 39, 180, 150, 144, 79,
    96, 41, 139, 198, 130, 146, 35, 176, 162, 36, 16, 100, 253, 162,
    170, 19, 5, 196, 179, 0, 79, 111, 110, 232, 165, 139, 69, 140,
    130, 0, 249, 217, 165, 180, 70, 59, 36, 146, 73, 159, 205, 49, 95,
    118, 89, 147, 60, 205, 69, 56, 100, 153, 192, 71, 111, 181, 35,
    51, 49, 27, 30, 62, 213, 184, 227, 117, 142, 129, 61, 254, 79, 52,
    25, 6, 182, 240, 0, 237, 222, 161, 212, 168, 123, 74, 20, 232, 56,
    49, 231, 123, 174, 132, 39, 133, 217, 254, 107, 42, 67, 2, 78, 70,
    32, 154, 168, 244, 130, 139, 172, 206, 190, 219, 99, 130, 220,
    154, 163, 132, 65, 36, 149, 70, 212, 247, 53, 192, 189, 85, 224,
    176, 28, 170, 70, 135, 138, 149, 235, 175, 112, 16, 206, 88, 158,
    55, 197, 72, 181, 211, 212, 245, 195, 3, 102, 215, 182, 223, 4,
    159, 221, 92, 54, 208, 3, 118, 227, 130, 75, 113, 62, 41, 237,
    224, 182, 65, 8, 13, 195, 201, 109, 238, 131, 144, 62, 182, 153,
    254, 245, 80, 32, 102, 20, 0, 20, 9, 250, 123, 209, 40, 184, 201,
    94, 242, 62, 244, 195, 80, 72, 202, 62, 41, 76, 29, 180, 226, 60,
    248, 168, 165, 192, 57, 213, 178, 88, 158, 65, 129, 89, 237, 219,
    69, 95, 86, 229, 194, 73, 250, 84, 243, 84, 5, 204, 152, 197, 8,
    142, 98, 105, 81, 81, 61, 216, 239, 183, 122, 168, 157, 230, 4,
    31, 124, 19, 4, 44, 238, 168, 242, 50, 80, 164, 15, 138, 42, 168,
    80, 92, 100, 82, 91, 202, 246, 251, 209, 121, 36, 78, 129, 241,
    226, 162, 130, 40, 89, 36, 147, 113, 187, 118, 2, 149, 136, 69,
    45, 63, 222, 182, 54, 203, 16, 110, 92, 144, 56, 154, 198, 210,
    125, 94, 179, 16, 166, 119, 186, 3, 111, 244, 109, 201, 99, 147,
    12, 140, 141, 209, 180, 138, 3, 220, 123, 121, 49, 60, 183, 138,
    77, 59, 146, 164, 176, 95, 138, 161, 75, 142, 76, 172, 2, 53, 189,
    80, 27, 175, 113, 208, 226, 96, 246, 165, 176, 21, 23, 53, 95,
    212, 63, 184, 153, 164, 91, 61, 75, 116, 201, 116, 50, 230, 228,
    226, 132, 68, 9, 172, 161, 69, 231, 178, 72, 47, 201, 0, 72, 7,
    239, 85, 20, 80, 2, 133, 4, 129, 220, 247, 165, 119, 2, 45, 168,
    147, 28, 80, 33, 157, 81, 23, 67, 131, 186, 2, 202, 162, 178, 181,
    204, 102, 51, 84, 255, 0, 147, 64, 202, 142, 235, 145, 33, 87,
    255, 0, 119, 72, 35, 100, 43, 93, 99, 161, 3, 64, 124, 213, 92,
    161, 32, 23, 33, 71, 106, 91, 127, 232, 226, 135, 21, 83, 192,
    239, 65, 146, 217, 0, 169, 39, 35, 227, 181, 24, 68, 217, 18, 126,
    220, 80, 47, 128, 40, 188, 13, 243, 201, 165, 244, 157, 220, 250,
    140, 17, 72, 144, 59, 208, 31, 80, 200, 25, 65, 142, 70, 205, 96,
    90, 1, 10, 118, 121, 106, 112, 233, 108, 194, 128, 24, 158, 124,
    208, 146, 78, 234, 41, 73, 185, 118, 230, 54, 246, 99, 109, 58,
    90, 96, 8, 66, 171, 177, 38, 90, 121, 172, 128, 184, 116, 47, 141,
    181, 236, 63, 119, 230, 139, 144, 89, 16, 105, 5, 1, 99, 160, 38,
    99, 85, 23, 17, 113, 63, 168, 157, 127, 181, 60, 0, 12, 29, 129,
    16, 41, 109, 219, 139, 162, 227, 54, 192, 160, 171, 170, 229, 17,
    49, 81, 100, 37, 78, 23, 52, 103, 76, 41, 192, 150, 99, 145, 104,
    165, 117, 9, 103, 158, 4, 80, 6, 184, 58, 126, 144, 179, 169, 50,
    120, 2, 100, 241, 70, 215, 65, 123, 168, 81, 119, 170, 124, 87,
    156, 36, 192, 255, 0, 189, 53, 139, 103, 168, 255, 0, 16, 69, 51,
    233, 244, 232, 9, 158, 9, 237, 94, 170, 35, 187, 70, 149, 38, 89,
    155, 197, 90, 71, 18, 244, 86, 237, 39, 233, 93, 184, 24, 52, 8,
    58, 26, 236, 13, 42, 245, 24, 216, 110, 158, 213, 146, 215, 20,
    195, 55, 31, 115, 38, 187, 146, 253, 149, 204, 45, 192, 196, 30,
    43, 155, 167, 123, 86, 111, 93, 123, 191, 168, 247, 31, 34, 99,
    138, 131, 144, 12, 20, 122, 135, 220, 116, 106, 70, 218, 191, 85,
    210, 219, 62, 224, 26, 92, 246, 7, 255, 0, 69, 116, 245, 111, 110,
    237, 209, 115, 211, 69, 0, 143, 167, 90, 169, 130, 236, 207, 233,
    174, 42, 63, 141, 85, 71, 170, 200, 2, 225, 108, 98, 23, 191, 245,
    82, 186, 170, 46, 119, 9, 9, 58, 203, 247, 87, 37, 190, 178, 244,
    68, 38, 135, 49, 81, 123, 151, 122, 139, 204, 1, 12, 227, 247, 77,
    72, 181, 209, 119, 168, 119, 24, 8, 181, 110, 56, 94, 90, 185, 24,
    230, 232, 32, 108, 243, 226, 41, 241, 150, 36, 251, 136, 212, 207,
    53, 130, 162, 156, 136, 147, 254, 212, 10, 226, 90, 124, 83, 175,
    63, 255, 0, 52, 128, 33, 45, 43, 201, 237, 170, 86, 31, 164, 196,
    22, 16, 40, 10, 92, 195, 30, 196, 137, 230, 132, 49, 89, 37, 160,
    119, 226, 105, 149, 45, 250, 155, 65, 128, 28, 145, 179, 76, 85,
    93, 182, 97, 120, 0, 24, 160, 88, 3, 210, 45, 161, 227, 227, 189,
    43, 150, 114, 125, 54, 85, 79, 234, 106, 163, 186, 9, 228, 246, 0,
    82, 160, 86, 105, 186, 190, 97, 42, 162, 74, 194, 26, 221, 178,
    215, 79, 114, 5, 80, 37, 197, 10, 89, 224, 177, 136, 137, 53, 64,
    237, 140, 170, 98, 59, 1, 72, 8, 64, 50, 25, 92, 34, 32, 246, 160,
    101, 0, 40, 80, 72, 29, 207, 122, 87, 112, 34, 218, 137, 49, 197,
    2, 25, 213, 17, 116, 56, 59, 160, 44, 170, 43, 43, 92, 198, 99,
    53, 79, 249, 52, 12, 168, 238, 185, 18, 21, 127, 247, 116, 130,
    54, 66, 181, 214, 58, 16, 52, 7, 205, 85, 202, 18, 1, 114, 20,
    118, 165, 183, 254, 142, 40, 113, 85, 60, 14, 244, 25, 45, 144,
    10, 146, 114, 62, 59, 81, 132, 77, 145, 39, 237, 197, 2, 248, 2,
    139, 192, 223, 60, 154, 95, 73, 221, 207, 168, 193, 20, 137, 3,
    189, 1, 245, 12, 129, 148, 24, 228, 108, 214, 5, 160, 16, 167,
    103, 150, 167, 14, 150, 204, 40, 1, 137, 231, 205, 9, 36, 238,
    162, 148, 155, 151, 110, 99, 111, 102, 54, 211, 165, 166, 0, 132,
    42, 187, 18, 101, 167, 154, 200, 11, 135, 66, 248, 219, 94, 195,
    247, 126, 104, 185, 5, 145, 6, 144, 80, 22, 58, 2, 102, 53, 81,
    113, 23, 19, 250, 137, 215, 251, 83, 192, 0, 193, 216, 17, 2, 150,
    221, 184, 186, 46, 51, 108, 10, 10, 186, 174, 81, 19, 21, 22, 66,
    84, 225, 115, 70, 116, 194, 156, 9, 102, 57, 22, 138, 87, 80, 150,
    121, 224, 69, 0, 107, 131, 167, 233, 11, 58, 147, 39, 128, 38, 79,
    20, 109, 116, 23, 186, 133, 23, 122, 167, 197, 121, 194, 76, 15,
    251, 211, 88, 182, 122, 143, 241, 4, 83, 62, 159, 78, 128, 153,
    224, 158, 213, 234, 162, 59, 180, 105, 82, 101, 153, 188, 85, 164,
    113, 47, 69, 110, 210, 126, 149, 219, 129, 131, 64, 131, 161, 174,
    192, 210, 175, 81, 141, 134, 233, 237, 89, 45, 113, 76, 51, 113,
    247, 50, 107, 185, 47, 217, 92, 194, 220, 12, 65, 226, 185, 186,
    119, 181, 102, 245, 215, 187, 250, 143, 113, 242, 38, 56, 168, 57,
    164, 51, 44, 72, 4, 207, 226, 144, 178, 148, 193, 82, 1, 228, 209,
    25, 103, 204, 44, 127, 52, 193, 85, 87, 80, 92, 247, 160, 80, 64,
    66, 21, 50, 98, 96, 152, 172, 168, 75, 70, 24, 22, 7, 95, 111,
    255, 0, 105, 109, 159, 80, 179, 47, 208, 186, 252, 213, 18, 17,
    134, 35, 103, 243, 65, 176, 85, 83, 6, 88, 247, 60, 208, 69, 15,
    115, 57, 39, 31, 108, 82, 51, 146, 216, 41, 10, 63, 123, 120, 20,
    200, 128, 170, 144, 25, 109, 198, 167, 69, 168, 54, 35, 144, 55,
    88, 90, 25, 22, 46, 241, 255, 0, 86, 171, 16, 199, 247, 64, 248,
    20, 128, 169, 96, 23, 39, 35, 191, 106, 6, 16, 110, 128, 163, 157,
    106, 143, 105, 228, 197, 58, 38, 0, 181, 200, 44, 220, 47, 138,
    146, 64, 4, 126, 224, 209, 136, 21, 80, 196, 45, 187, 100, 228,
    18, 79, 52, 4, 176, 246, 158, 252, 129, 52, 201, 104, 35, 122,
    151, 125, 205, 251, 65, 224, 82, 220, 99, 233, 144, 32, 19, 220,
    212, 86, 80, 24, 8, 153, 36, 177, 172, 64, 196, 146, 71, 142, 105,
    210, 220, 32, 5, 136, 88, 252, 159, 181, 77, 154, 208, 48, 86, 71,
    101, 137, 160, 167, 71, 237, 188, 237, 142, 238, 128, 103, 228,
    14, 43, 210, 117, 9, 98, 227, 220, 48, 48, 246, 205, 121, 150,
    208, 148, 203, 210, 107, 112, 117, 39, 99, 241, 69, 220, 144, 136,
    110, 179, 9, 136, 61, 166, 130, 118, 145, 205, 129, 188, 100, 109,
    207, 39, 237, 77, 130, 5, 204, 150, 50, 60, 211, 92, 33, 45, 132,
    28, 129, 31, 154, 95, 78, 66, 43, 185, 32, 239, 17, 226, 170, 38,
    150, 146, 224, 5, 228, 47, 101, 6, 172, 228, 29, 29, 39, 96, 43,
    7, 146, 7, 2, 38, 15, 53, 176, 202, 102, 34, 162, 148, 32, 42, 84,
    19, 242, 221, 233, 128, 91, 105, 130, 130, 59, 177, 61, 233, 67,
    251, 72, 84, 227, 115, 20, 169, 55, 113, 98, 88, 91, 2, 62, 230,
    129, 203, 128, 60, 0, 56, 20, 17, 102, 197, 178, 73, 147, 38, 103,
    183, 106, 12, 184, 172, 4, 6, 71, 218, 142, 23, 48, 89, 86, 10,
    160, 1, 177, 252, 208, 12, 8, 85, 0, 128, 23, 180, 80, 123, 168,
    170, 50, 97, 7, 129, 230, 177, 182, 12, 1, 50, 121, 32, 255, 0,
    53, 84, 91, 93, 63, 130, 222, 76, 24, 160, 76, 221, 236, 134, 51,
    197, 28, 245, 36, 197, 0, 230, 238, 114, 250, 15, 168, 160, 227,
    20, 59, 10, 20, 106, 57, 53, 80, 29, 241, 208, 80, 7, 0, 3, 88, 6,
    50, 236, 2, 193, 214, 255, 0, 154, 162, 90, 22, 156, 220, 51, 113,
    200, 208, 39, 138, 80, 210, 176, 219, 105, 157, 212, 82, 21, 23,
    47, 190, 123, 0, 123, 64, 208, 171, 64, 72, 208, 0, 25, 128, 57,
    161, 108, 42, 27, 151, 32, 179, 19, 19, 64, 169, 14, 162, 84, 19,
    230, 128, 200, 102, 88, 144, 9, 159, 197, 33, 101, 41, 130, 164,
    3, 201, 162, 50, 207, 152, 88, 254, 105, 130, 170, 174, 160, 185,
    239, 64, 160, 128, 132, 42, 100, 196, 193, 49, 89, 80, 150, 140,
    48, 44, 14, 190, 223, 254, 210, 219, 62, 161, 102, 95, 161, 117,
    249, 170, 36, 35, 12, 70, 207, 230, 131, 96, 170, 166, 12, 177,
    238, 121, 160, 138, 30, 230, 114, 78, 62, 216, 164, 103, 37, 176,
    82, 20, 126, 246, 240, 41, 145, 1, 85, 32, 50, 219, 141, 78, 139,
    80, 108, 71, 32, 110, 176, 180, 50, 44, 93, 227, 254, 173, 86, 33,
    143, 238, 129, 240, 41, 1, 82, 192, 46, 78, 71, 126, 212, 12, 32,
    221, 1, 71, 58, 213, 30, 211, 201, 138, 116, 76, 1, 107, 144, 89,
    184, 95, 21, 36, 128, 8, 253, 193, 163, 16, 42, 161, 136, 91, 118,
    201, 200, 36, 158, 104, 9, 97, 237, 61, 249, 2, 105, 146, 208, 70,
    245, 46, 251, 155, 246, 131, 192, 165, 184, 199, 211, 32, 64, 39,
    185, 168, 172, 160, 48, 17, 50, 73, 99, 88, 129, 137, 36, 143, 28,
    211, 165, 184, 64, 11, 16, 177, 249, 63, 106, 155, 53, 160, 96,
    172, 142, 203, 19, 65, 78, 143, 219, 121, 219, 29, 221, 0, 207,
    200, 28, 87, 164, 234, 18, 197, 199, 184, 96, 97, 237, 154, 243,
    45, 161, 41, 151, 164, 214, 224, 234, 78, 199, 226, 139, 185, 33,
    16, 221, 102, 19, 16, 123, 77, 4, 237, 35, 155, 3, 120, 200, 219,
    158, 79, 218, 155, 4, 11, 153, 44, 100, 121, 166, 184, 66, 91, 8,
    57, 2, 63, 52, 190, 156, 132, 87, 114, 65, 222, 35, 197, 84, 127,
    255, 217
};


static unsigned char const valid_tga_test[] = {
    0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239, 0, 33, 0, 24, 32, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255
};

static unsigned char const tga_test_1[] = {
    0, 0, 2, 0, 0, 0, 0, 0, 0, 153, 0, 0, 19, 0, 116, 0, 24, 32, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 204, 255, 255, 255, 255, 255, 255, 255, 255, 47, 255, 255,
    255, 255, 255, 89, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 123, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 174, 255, 156, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 15, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 255,
    255, 255, 255, 28, 255, 255, 255, 255, 255, 255, 22, 255, 255, 38,
    255, 255, 145, 109, 255, 255, 255, 255, 255, 187, 255, 255, 255,
    255, 255, 189, 255, 255, 54, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 28, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 174, 255, 255, 255, 255, 255, 255, 255, 26, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 54, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 43, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 232, 255, 255, 240, 255, 255, 255, 255, 255, 90, 255,
    255, 255, 255, 255, 255, 255, 146, 107, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 79, 255, 0, 0, 0, 0, 0, 0, 243,
    0, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0, 130, 176, 0,
    0, 0, 0, 6, 0, 0, 0, 222, 0, 0, 0, 0, 129, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 169, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 155, 255, 255, 255, 255, 255, 255, 238, 255, 255, 255,
    255, 255, 221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 161, 255, 255, 255, 255, 255, 255, 255,
    255, 117, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 122, 255, 255, 255, 201, 255, 255, 195, 255, 255, 255, 255,
    83, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 24, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 73, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 196, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 29, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 212, 255, 255, 255, 255, 21, 255, 255,
    255, 131, 255, 255, 71, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 38, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 215, 148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    156, 255, 94, 255, 255, 255, 114, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 47, 255, 255, 255, 63, 255,
    255, 255, 255, 255, 255, 105, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 39, 255, 255, 255, 255, 255, 255, 255, 180, 255,
    255, 198, 255, 255, 255, 255, 255, 0, 255, 255, 255, 46, 255, 255,
    255, 255, 255, 255, 132, 75, 37, 255, 255, 255, 2, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 158, 255, 255, 128, 255, 255,
    251, 255, 255, 255, 255, 255, 255, 255, 255, 229, 255, 102, 255,
    255, 255, 255, 255, 255, 255, 210, 255, 255, 255, 255, 255, 255,
    255, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 214, 255, 255, 209, 255, 37,
    255, 255, 255, 62, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    184, 255, 255, 255, 255, 255, 255, 255, 13, 255, 255, 255, 255,
    152, 255, 255, 255, 255, 255, 255, 255, 124, 255, 255, 255, 255,
    255, 255, 249, 255, 255, 255, 152, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 104, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 205, 255, 27, 255, 255,
    186, 255, 255, 115, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 9, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 57, 255, 255, 88, 255, 255, 255, 255, 117, 255, 255, 255,
    241, 255, 255, 255, 50, 255, 255, 255, 255, 100, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 11, 255, 255, 255, 255, 106, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 145, 255, 255, 255, 255, 255, 240, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 129, 255, 255, 255, 255, 255, 150,
    255, 255, 99, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 224, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 20, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 255, 255,
    255, 255, 195, 255, 255, 255, 255, 255, 255, 255, 224, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 163, 255,
    255, 255, 255, 255, 255, 255, 255, 19, 255, 255, 255, 255, 255,
    255, 22, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 101, 255, 117, 94, 255, 255, 255, 40, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 196, 255,
    255, 101, 255, 255, 244, 255, 255, 255, 255, 255, 4, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 157,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 29, 255, 255, 255, 255, 255, 255, 255, 255, 218,
    255, 255, 255, 255, 255, 177, 255, 255, 255, 255, 170, 255, 255,
    255, 255, 255, 255, 255, 95, 142, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 166, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 108, 255, 255, 150, 255, 255,
    255, 255, 255, 76, 255, 255, 255, 255, 255, 255, 156, 255, 255,
    255, 255, 255, 255, 255, 255, 153, 255, 255, 255, 255, 255, 255,
    221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 116, 255, 255, 255, 255,
    255, 136, 255, 255, 255, 255, 255, 255, 255, 127, 255, 255, 255,
    255, 255, 255, 255, 143, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 51, 255, 166, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 91, 121, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 21, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208, 255, 255,
    142, 255, 255, 255, 255, 193, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 89, 255, 255, 255, 255,
    163, 255, 255, 255, 57, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 7, 255, 255, 255, 255, 38, 255, 255, 255, 105, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 58, 255, 255, 255, 124, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 33, 255, 255, 255,
    255, 148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 255,
    255, 255, 255, 255, 94, 255, 255, 255, 191, 255, 255, 255, 255,
    255, 63, 255, 255, 255, 255, 132, 255, 255, 255, 194, 255, 255,
    255, 255, 76, 34, 255, 255, 255, 255, 154, 255, 255, 255, 255,
    255, 255, 202, 255, 255, 255, 255, 55, 255, 255, 255, 255, 255,
    255, 227, 255, 255, 255, 255, 255, 51, 255, 255, 255, 255, 255,
    255, 255, 255, 237, 255, 255, 255, 255, 188, 255, 255, 206, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 42, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 70,
    255, 155, 255, 255, 255, 63, 255, 255, 255, 255, 54, 255, 255,
    255, 52, 255, 255, 255, 255, 255, 255, 16, 118, 239, 255, 255,
    212, 255, 255, 69, 255, 255, 255, 255, 255, 173, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 240, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 172, 255, 255, 255, 255, 255, 255, 226,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 59, 255, 255, 71, 255, 255, 255,
    255, 255, 255, 116, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    236, 255, 255, 255, 255, 255, 255, 217, 255, 255, 0, 255, 255,
    255, 255, 255, 68, 255, 255, 255, 255, 255, 140, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 140, 198, 189, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 50, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    65, 255, 209, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 118, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 19, 255, 255, 255, 255, 255, 255, 255, 255, 171,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 156, 255, 255, 181,
    255, 255, 255, 255, 255, 255, 255, 23, 255, 255, 255, 255, 255,
    153, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    29, 255, 255, 10, 255, 255, 255, 255, 217, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 173,
    255, 255, 182, 255, 255, 255, 255, 194, 255, 255, 229, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 196, 255, 98, 255, 255, 255,
    255, 235, 255, 255, 136, 185, 255, 255, 255, 255, 255, 255, 238,
    255, 255, 38, 255, 55, 255, 255, 255, 255, 255, 255, 255, 255, 13,
    255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255, 255, 255,
    255, 255, 132, 255, 255, 255, 193, 255, 255, 255, 145, 255, 255,
    103, 255, 250, 255, 255, 255, 156, 12, 255, 255, 255, 255, 131,
    249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    20, 255, 190, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    44, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 64, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 255, 255,
    255, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 5, 255, 255, 255,
    255, 53, 255, 255, 255, 215, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 36, 255, 255, 255, 255, 255, 125,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 215, 255, 175, 255, 255, 57, 255, 255, 255, 255, 255,
    251, 255, 255, 255, 255, 255, 255, 255, 170, 255, 255, 159, 255,
    255, 127, 84, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 160, 255, 255, 255, 255, 255, 255, 255, 255,
    218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 154, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 202, 255, 255, 255, 255, 255,
    255, 255, 29, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 126, 255, 166, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 244, 255, 255, 255, 255, 255, 255, 255, 255, 202,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 57, 255, 255,
    255, 166, 47, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 29, 255, 34, 255, 255, 255, 255, 255, 255, 1,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 111, 255, 247, 255, 255, 124, 23, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 26, 255, 255, 127, 255, 255,
    255, 255, 255, 1, 255, 221, 255, 255, 255, 255, 112, 172, 255,
    255, 255, 255, 87, 255, 255, 253, 255, 255, 255, 216, 255, 136,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 22, 255, 255,
    220, 255, 255, 255, 143, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 14, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 218, 255, 255, 255, 255, 255, 255, 162, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 64, 255, 255,
    255, 255, 255, 255, 6, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 200, 255, 255, 215, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 161, 255, 255, 255, 255, 255, 255, 255,
    255, 150, 84, 255, 255, 255, 255, 255, 255, 255, 255, 66, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 255, 138, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 103, 255, 255, 255, 255, 177, 255, 255, 49, 255, 255, 255,
    255, 255, 255, 236, 255, 255, 255, 255, 255, 255, 51, 255, 244,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 24, 255, 255, 255, 255, 255, 255,
    255, 255, 49, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 247, 255, 255, 255, 24, 255,
    255, 255, 255, 255, 255, 255, 7, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 201, 255, 255, 255, 255,
    255, 255, 255, 179, 255, 255, 255, 255, 255, 255, 255, 255, 118,
    255, 6, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 207, 255, 84, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 41, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 99, 255, 255, 255, 255, 255, 255, 255, 137, 255, 255, 255,
    255, 255, 255, 255, 255, 223, 255, 255, 255, 255, 255, 255, 60,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 86, 255, 255, 255, 149, 255, 255, 255,
    255, 255, 255, 255, 255, 166, 255, 255, 180, 255, 255, 255, 255,
    72, 49, 227, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 177, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 198, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 76, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 206, 255, 126, 255, 255, 255,
    255, 255, 161, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 143, 255, 255, 255, 190, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 34, 232, 255, 255, 255, 255, 255,
    255, 255, 20, 255, 255, 255, 255, 255, 255, 255, 255, 255, 87,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 73, 255, 255,
    255, 163, 255, 255, 255, 255, 160, 255, 90, 255, 255, 255, 14,
    255, 255, 255, 255, 255, 255, 255, 255, 234, 255, 255, 53, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 126, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 193, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 137, 255, 65, 255, 255,
    255, 141, 255, 124, 255, 18, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 174, 255, 255, 255, 76, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 49, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 153, 255, 255, 255, 255, 153, 255, 223, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 61, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32, 69, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 125, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 157, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 161, 255, 255, 255, 246, 128, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 121, 255, 255, 255, 255, 255,
    255, 255, 31, 255, 255, 255, 255, 255, 100, 255, 255, 255, 255,
    134, 255, 72, 255, 255, 255, 25, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 111, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 1, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 69, 255,
    255, 255, 255, 255, 255, 255, 255, 28, 255, 126, 43, 59, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 33, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 87, 255, 255, 255,
    255, 255, 255, 194, 255, 255, 255, 255, 111, 255, 64, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 241, 255, 255, 255, 255, 255, 59, 255, 255, 255, 67, 255, 97,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 119, 255, 59, 255, 255, 152, 255, 255, 255,
    255, 138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 83,
    255, 255, 255, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63,
    255, 255, 255, 255, 255, 94, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 161, 255, 255, 255, 255, 255, 119, 255,
    255, 255, 255, 255, 255, 255, 255, 12, 196, 168, 114, 255, 255,
    255, 255, 255, 255, 233, 217, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 184, 255, 255, 214, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 168, 255, 255, 255,
    255, 174, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 83, 255, 255, 255, 255, 255, 11, 255, 255, 255, 57,
    255, 255, 255, 255, 255, 173, 255, 134, 255, 180, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 31, 255, 255, 255, 255,
    255, 66, 255, 255, 255, 255, 162, 255, 131, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 91, 209, 255, 255, 255, 255, 129, 255, 255,
    255, 255, 255, 255, 255, 182, 255, 195, 255, 255, 255, 255, 255,
    186, 255, 255, 255, 255, 38, 255, 255, 255, 255, 96, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 38, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    75, 255, 255, 244, 31, 255, 255, 126, 255, 255, 255, 193, 255,
    210, 255, 255, 255, 255, 255, 255, 195, 255, 255, 255, 255, 255,
    255, 10, 108, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 32, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 196, 255, 255, 255, 255, 255, 168, 19, 147,
    255, 255, 255, 255, 255, 255, 255, 255, 164, 255, 255, 255, 255,
    255, 54, 255, 255, 255, 47, 255, 1, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 72, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 67,
    255, 255, 255, 255, 28, 255, 255, 255, 255, 122, 255, 255, 255,
    255, 255, 255, 175, 255, 255, 255, 255, 255, 116, 255, 255, 255,
    255, 255, 255, 22, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 130, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    157, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 197, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 165, 255, 255, 193, 255, 255,
    255, 255, 255, 255, 118, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 32, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 155, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 135, 255, 255, 255, 255, 255, 255, 255, 255,
    156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 182, 255, 255, 26, 255, 255, 255,
    255, 246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 186, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    72, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 156, 227, 255, 255, 255, 255, 255, 152, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 71, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 176, 97, 205, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 95, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 143, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 255, 255, 255,
    255, 69, 255, 133, 255, 255, 85, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 158, 136, 255, 255, 255, 255, 64, 230, 255, 255, 255,
    255, 255, 44, 255, 255, 255, 255, 255, 255, 255, 255, 15, 255,
    255, 255, 255, 172, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 41, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 180, 255, 202, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    232, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 112,
    255, 255, 255, 255, 255, 212, 255, 172, 255, 255, 255, 255, 73,
    255, 255, 255, 255, 255, 34, 255, 166, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 87, 255, 255, 51, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 181, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    253, 255, 69, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    195, 255, 255, 255, 255, 255, 111, 255, 255, 255, 255, 255, 166,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 168, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 16, 255, 255, 255, 255, 255, 255, 255, 109, 108, 255,
    236, 255, 238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 110,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 126, 135, 255, 255, 255, 255, 255, 216, 86, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 33, 255, 255, 255,
    255, 255, 135, 255, 255, 255, 255, 255, 255, 138, 255, 255, 255,
    126, 255, 91, 255, 255, 255, 113, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 180, 255, 112, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 8, 255, 255, 255,
    255, 147, 255, 255, 255, 255, 255, 197, 255, 196, 255, 255, 255,
    255, 255, 195, 255, 255, 255, 255, 174, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 96, 255, 255, 255, 255,
    255, 255, 255, 236, 255, 255, 152, 255, 80, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 251, 255, 175, 255, 255, 73,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 41, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 182, 255, 255, 255, 255, 151, 255, 255, 255,
    255, 255, 255, 255, 255, 243, 255, 255, 255, 255, 174, 255, 255,
    255, 255, 255, 52, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 155, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 240, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 92, 86, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 198, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 59, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 222, 255,
    255, 109, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 228, 176, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 131, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 140, 255, 255, 255, 255, 255, 213, 70,
    255, 255, 255, 255, 169, 10, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 66, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    146, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 211,
    255, 255, 255, 255, 56, 255, 255, 255, 163, 127, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    41, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 255, 255, 255,
    255, 21, 179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 21, 255, 255, 240, 255, 255, 255, 255, 255, 255,
    255, 255, 67, 255, 255, 255, 43, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 65, 255, 216, 255, 255, 255, 255,
    255, 255, 3, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 110, 255, 255, 255, 255, 255, 255, 87, 255, 255, 255,
    86, 255, 255, 255, 255, 83, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 165, 255, 255, 255, 164, 255, 255, 255, 221, 255, 255,
    255, 255, 255, 210, 255, 89, 255, 255, 255, 255, 255, 156, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    115, 43, 255, 255, 255, 255, 255, 255, 255, 255, 111, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 181, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    119, 222, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 128, 255, 255, 255, 255, 255, 255, 255, 255, 43,
    255, 255, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 165,
    214, 255, 255, 255, 255, 255, 255, 255, 255, 197, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 93,
    151, 255, 237, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 57, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 25, 255, 255, 255, 255, 255, 255, 255, 112, 255,
    255, 134, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 108,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 212, 255, 255, 255, 255, 255, 255, 158, 255, 255,
    77, 255, 255, 255, 255, 192, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 202, 79, 255, 255, 255, 174, 54, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 218, 255, 255, 255, 255, 255, 255, 185,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 230, 255, 255, 255, 255, 255, 255, 255, 130, 175, 150,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 73, 35, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 123, 255, 255, 255, 157, 176, 247, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 105, 255, 255, 15, 255, 255, 255, 255, 255, 15,
    255, 255, 255, 255, 231, 255, 255, 255, 255, 23, 255, 255, 255,
    255, 255, 255, 35, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 237, 0, 183, 255, 217, 255, 255, 255, 255, 255, 255,
    84, 255, 251, 220, 252, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 212, 255, 255,
    255, 255, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 70, 255, 255, 255, 255,
    255, 255, 255, 155, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 134, 255, 255, 255,
    255, 255, 183, 255, 255, 255, 255, 255, 255, 255, 255, 114, 255,
    255, 255, 255, 61, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 151, 255, 255, 255, 72, 255, 255, 255, 255, 255,
    255, 255, 21, 159, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 28, 255, 255, 255, 255, 255, 255, 255, 145,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 92, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 235, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 66, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 110, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 67, 218, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 213, 255,
    255, 255, 107, 103, 255, 255, 255, 255, 153, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 160, 255,
    255, 255, 40, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 202, 255, 255, 255, 255, 209, 255, 255, 255, 255, 255, 255,
    255, 255, 36, 255, 255, 255, 255, 57, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 5, 255,
    255, 255, 255, 255, 255, 255, 81, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    97, 255, 238, 255, 255, 255, 255, 255, 255, 255, 62, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    69, 255, 255, 255, 215, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 212, 255, 255, 255, 255, 255, 255, 255, 91, 255, 59,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    146, 165, 255, 28, 255, 255, 255, 255, 255, 255, 255, 205, 255,
    255, 255, 255, 85, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 1, 255, 255, 255, 255, 255, 38, 221, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 216, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 10, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 174, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 87, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 84, 255, 255, 102, 255, 227, 255, 255,
    255, 255, 255, 255, 121, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 104, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 20, 18, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    134, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 91, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 15, 255, 255, 255, 255,
    229, 255, 255, 239, 255, 255, 255, 255, 255, 255, 255, 255, 197,
    153, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 244, 255, 255, 255, 255, 255, 220, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 181, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 8, 255, 255, 255, 255, 255, 255, 255,
    255, 211, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 153,
    228, 174, 255, 255, 255, 255, 95, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 154, 255, 255, 255, 255, 255, 255, 174, 255, 255,
    255, 255, 207, 255, 255, 255, 255, 255, 255, 255, 61, 255, 75, 27,
    255, 255, 255, 253, 255, 255, 116, 255, 27, 255, 255, 255, 177,
    255, 255, 152, 255, 255, 58, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 231, 255, 39, 255, 255, 255, 255, 255, 77, 255, 255, 17, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195,
    255, 255, 255, 103, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 60, 255, 255, 255, 40, 255, 255, 255, 255, 255, 255,
    255, 193, 255, 255, 255, 255, 255, 255, 255, 255, 248, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 45, 140, 255, 127, 22, 255, 193, 255, 255,
    255, 1, 255, 255, 14, 255, 255, 255, 255, 255, 255, 173, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 107,
    255, 83, 255, 118, 255, 255, 196, 255, 255, 225, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 240, 255, 255, 255, 255, 255,
    255, 126, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 113, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    105, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 176, 255, 255, 255, 255,
    46, 255, 255, 255, 255, 255, 255, 255, 255, 255, 110, 0, 0, 0, 0,
    0, 255, 104, 181, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 136, 255, 255, 180, 255,
    255, 255, 255, 255, 142, 255, 255, 255, 255, 255, 104, 255, 255,
    255, 255, 255, 171, 255, 118, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 8, 97, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 75, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 210, 255, 255, 255, 255, 255, 255, 160, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 60, 65, 255,
    255, 255, 255, 255, 255, 255, 222, 255, 167, 0, 24, 0, 0, 0, 58,
    0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 251, 255, 146, 255, 255,
    255, 207, 255, 255, 255, 255, 255, 255, 255, 149, 255, 255, 19, 0,
    0, 0, 255, 255, 237, 255, 255, 255, 180, 255, 255, 255, 255, 255,
    255, 233, 255, 0, 0, 0, 0, 131, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 134, 255, 255, 0, 0, 0, 255, 227, 255, 255, 255,
    23, 255, 255, 211, 255, 255, 255, 53, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 154,
    255, 255, 119, 61, 255, 255, 66, 115, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 48, 255, 255, 35, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 195, 255, 154, 255, 255,
    255, 255, 255, 255, 255, 175, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 179, 89, 255, 255,
    255, 127, 255, 255, 255, 255, 255, 255, 228, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 41, 255, 255, 255, 255, 255, 255, 255,
    52, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 175, 255, 124, 255, 13, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 94,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 112, 255, 165, 171, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 160, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 55,
    255, 62, 255, 255, 178, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 161, 255, 255, 255, 193, 255, 60, 255, 255, 255,
    255, 255, 255, 204, 255, 255, 255, 255, 255, 255, 255, 255, 81,
    255, 255, 255, 255, 255, 255, 47, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 92, 255, 255, 255, 255, 255, 255, 255,
    255, 137, 255, 255, 255, 255, 255, 255, 63, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 129, 255, 24, 255,
    255, 255, 255, 255, 255, 255, 117, 255, 255, 255, 200, 0, 49, 0,
    0, 0, 23, 158, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 96, 255, 60, 255, 255, 0,
    0, 0, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    74, 0, 0, 0, 0, 0, 255, 97, 255, 255, 160, 255, 241, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 197, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 21, 255, 255, 255, 255,
    17, 255, 255, 255, 255, 255, 255, 255, 229, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 24, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 65, 113, 255, 255, 120, 2, 255, 255, 255,
    255, 255, 255, 255, 255, 95, 255, 255, 255, 255, 255, 204, 255,
    255, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 65, 255, 255, 177, 255, 255, 35, 255, 255, 255, 255,
    255, 52, 255, 255, 255, 255, 255, 255, 121, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 70, 8, 255, 245,
    255, 169, 255, 255, 255, 255, 58, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 226, 145, 255, 255, 255, 216, 0, 0, 168, 0, 0, 14, 255,
    255, 255, 255, 197, 255, 255, 255, 255, 140, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 29, 255, 255, 255, 42, 0, 0, 0, 255, 255, 68, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 40, 255, 255, 71, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    86, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 255, 255, 255,
    255, 255, 255, 14, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 210, 0, 0, 255, 255, 255, 82, 255, 255, 255, 255, 255,
    166, 144, 255, 255, 255, 255, 92, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 47,
    255, 255, 206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 141, 56, 255, 255, 50, 255, 255, 255, 255, 205, 255, 255,
    255, 255, 255, 255, 40, 255, 233, 255, 146, 67, 255, 255, 255,
    255, 255, 255, 255, 181, 255, 255, 255, 255, 255, 255, 255, 255,
    95, 255, 255, 198, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    6, 255, 255, 255, 255, 205, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 242, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    93, 255, 255, 255, 255, 255, 255, 255, 196, 255, 255, 255, 255,
    255, 255, 135, 255, 255, 255, 255, 0, 255, 255, 255, 255, 255,
    255, 10, 255, 255, 255, 8, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 98, 255, 255, 255, 255, 255, 221, 255, 209,
    255, 255, 255, 255, 255, 255, 24, 255, 255, 113, 255, 255, 75,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 198, 255, 255, 255, 255, 255, 255, 255, 120, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 87, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 5, 255, 255, 255, 0,
    252, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 150, 255,
    255, 255, 255, 46, 255, 255, 255, 255, 255, 255, 80, 136, 200,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 250, 186, 0, 0, 0, 0, 39, 255, 255, 255,
    255, 255, 255, 255, 153, 255, 170, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 71, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 57, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 77, 255, 255, 255, 10, 255, 0, 255, 255, 255, 255, 194, 255,
    255, 255, 255, 74, 128, 255, 255, 255, 2, 255, 255, 171, 255, 255,
    255, 255, 255, 255, 37, 255, 255, 255, 255, 255, 255, 92, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 178, 0, 141, 255, 255, 255, 255, 227, 255, 41, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 115, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 251, 0, 0, 0, 0, 0, 255, 255, 137, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    22, 255, 255, 255, 218, 255, 255, 212, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 107, 255, 255, 255, 255,
    255, 255, 255, 255, 125, 0, 0, 0, 255, 255, 206, 177, 255, 255,
    255, 255, 163, 255, 255, 255, 255, 255, 255, 255, 255, 178, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 198, 255, 255, 255,
    255, 242, 92, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 4, 255, 255, 255, 255,
    255, 69, 0, 0, 0, 255, 255, 255, 255, 255, 255, 224, 255, 255, 86,
    255, 255, 255, 255, 255, 255, 255, 148, 255, 79, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 137,
    255, 86, 255, 255, 255, 255, 255, 255, 255, 193, 255, 255, 100,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 18, 255, 255, 255, 255, 255, 29, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 55, 255,
    255, 255, 117, 255, 255, 189, 255, 255, 255, 255, 255, 255, 5,
    255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 94, 255,
    255, 255, 255, 255, 119, 255, 35, 255, 255, 255, 255, 10, 255,
    255, 255, 255, 31, 255, 0, 0, 0, 159, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 134, 255, 255, 255, 255, 255, 255, 152,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 77,
    255, 255, 255, 0, 0, 22, 255, 255, 255, 255, 255, 197, 255, 148,
    255, 255, 255, 255, 255, 255, 255, 255, 145, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 255, 255, 255,
    255, 255, 255, 255, 255, 81, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 202, 49, 129, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 255, 255, 255,
    255, 255, 9, 255, 255, 255, 255, 255, 255, 255, 255, 135, 255,
    195, 255, 255, 255, 255, 255, 255, 251, 255, 255, 255, 255, 255,
    63, 240, 255, 255, 255, 228, 255, 62, 255, 17, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 43, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 11, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 7,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 94, 255, 255, 255, 78, 11,
    0, 0, 0, 255, 250, 255, 213, 255, 255, 255, 2, 255, 255, 255, 255,
    255, 255, 54, 255, 255, 255, 231, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 179,
    255, 0, 0, 0, 255, 234, 255, 0, 0, 0, 255, 255, 255, 211, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    81, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 84, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    121, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 168, 0, 0, 255, 156, 255, 255, 255, 12, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 29, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 96, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 143, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 13, 229, 0, 124,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 61,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 113, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 190, 255,
    255, 234, 255, 255, 255, 255, 60, 255, 255, 51, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    127, 255, 255, 255, 255, 166, 255, 255, 255, 255, 255, 255, 75,
    255, 255, 255, 255, 255, 255, 255, 220, 255, 65, 255, 0, 255, 255,
    255, 0, 0, 0, 0, 62, 126, 255, 71, 255, 255, 159, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 209, 255, 255, 255, 255, 255, 255,
    62, 255, 255, 255, 105, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 255, 255,
    255, 4, 79, 255, 255, 255, 255, 255, 255, 6, 255, 255, 177, 255,
    120, 25, 8, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92, 255,
    255, 255, 255, 255, 255, 252, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 176, 45, 255, 255, 255, 255, 255, 255, 255, 255, 255, 180,
    255, 0, 0, 176, 255, 255, 255, 255, 255, 255, 255, 255, 106, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 143, 255, 255, 255, 255, 255, 255, 255, 72, 255, 255,
    255, 255, 75, 255, 255, 255, 255, 255, 255, 255, 255, 226, 255,
    255, 255, 255, 255, 255, 255, 255, 159, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 255, 255,
    255, 255, 129, 255, 255, 255, 255, 255, 135, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 230, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 130, 255, 255, 152, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 64,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 185, 255, 255,
    46, 255, 72, 255, 255, 255, 255, 112, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 37, 143, 255, 255, 255, 225, 255, 255, 255, 255,
    255, 255, 255, 0, 197, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 203, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    62, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 46, 44, 0, 0, 0, 255, 49, 175, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 50,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 44, 255, 255, 255, 255,
    255, 238, 255, 252, 11, 169, 255, 255, 255, 255, 112, 255, 255,
    255, 255, 255, 255, 255, 255, 103, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 231, 255, 255, 255, 157, 255, 255, 255, 132, 255,
    255, 117, 255, 255, 255, 255, 255, 2, 255, 255, 255, 255, 249,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 53, 214, 255, 255, 255, 255, 255,
    255, 233, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 31, 0, 167,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 172, 255, 255, 255, 255, 255, 0, 0, 0, 129, 0, 0, 0, 0, 0,
    151, 255, 255, 255, 255, 255, 255, 255, 255, 47, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 182, 255, 159, 255, 255, 255, 255, 255,
    255, 255, 255, 52, 86, 255, 255, 255, 29, 255, 255, 255, 118, 255,
    0, 0, 44, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 203, 255, 255, 255, 255, 255,
    255, 117, 255, 255, 0, 0, 0, 6, 78, 0, 255, 255, 255, 255, 255,
    255, 46, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 103, 255, 255, 255, 255, 255, 255, 127, 255,
    79, 255, 181, 255, 59, 255, 255, 255, 255, 255, 255, 24, 255, 255,
    255, 255, 255, 216, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 56, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 110,
    255, 255, 255, 255, 255, 255, 64, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 69, 255, 255, 255,
    255, 255, 255, 255, 156, 255, 0, 0, 49, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 74, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 70, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 255, 255, 255, 208, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 255,
    69, 255, 255, 255, 255, 255, 255, 179, 255, 255, 233, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 255,
    255, 255, 166, 255, 255, 255, 255, 255, 255, 255, 255, 81, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 173, 250, 255, 255, 255,
    219, 255, 174, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 90, 255, 255, 255, 255, 120, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 133, 0, 0, 0, 255, 255, 255, 255, 255, 223, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 69, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    121, 255, 94, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 64, 0, 0, 255, 255, 255, 40, 255, 255, 255, 255, 255, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 29, 0, 0, 0, 0, 0, 0, 121, 0, 157, 0, 0, 0, 0, 0, 0, 234, 142,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 67, 255,
    255, 52, 255, 255, 0, 0, 0, 0, 0, 0, 139, 0, 0, 255, 255, 255, 0,
    140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 80, 255, 255,
    255, 255, 255, 147, 255, 255, 255, 255, 255, 255, 255, 103, 98,
    212, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 4, 255, 0, 0, 0, 176, 255, 255, 255, 255,
    255, 255, 228, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 84, 255, 255, 255, 170, 255, 255, 255,
    255, 255, 255, 237, 255, 117, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 11, 255, 255, 255, 255, 255, 199, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 162, 111, 255, 15, 255, 255, 255, 255, 255,
    0, 0, 0, 2, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 233, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 62, 0, 255, 255, 255, 255,
    255, 81, 162, 255, 255, 255, 255, 255, 25, 196, 52, 255, 176, 255,
    255, 207, 255, 255, 189, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 196, 255, 255, 29, 255, 255, 146, 255, 255, 255,
    255, 73, 255, 255, 191, 0, 0, 255, 255, 255, 255, 255, 255, 24,
    255, 255, 255, 255, 255, 142, 255, 8, 255, 255, 9, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 0, 0, 0, 0, 0,
    0, 0, 0, 119, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 27, 255, 255, 255, 255, 255, 255, 255, 255, 239, 255, 255,
    255, 255, 255, 255, 14, 255, 255, 91, 255, 255, 221, 255, 255,
    255, 20, 255, 255, 255, 255, 255, 255, 18, 255, 236, 0, 153, 0,
    34, 0, 0, 255, 255, 255, 255, 225, 255, 43, 255, 255, 255, 255,
    255, 255, 255, 24, 0, 0, 74, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 247, 255, 255, 255, 255, 255, 11, 0, 0, 0, 255, 255,
    17, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 98, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 252, 1, 255, 255, 255,
    255, 255, 255, 255, 255, 149, 255, 255, 255, 255, 255, 255, 255,
    213, 255, 255, 255, 255, 255, 86, 255, 255, 255, 0, 0, 73, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 212,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 24, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 166, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 255, 240, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 226, 0, 0, 0, 0, 0, 109, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 41, 165,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 213, 255, 255, 255,
    255, 58, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 179, 0, 0, 255, 255,
    255, 255, 255, 255, 112, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 5,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 169, 255, 255, 232,
    255, 255, 255, 148, 255, 0, 0, 0, 4, 0, 0, 0, 0, 0, 206, 255, 255,
    130, 255, 255, 0, 0, 250, 255, 255, 255, 105, 255, 255, 255, 255,
    255, 207, 255, 255, 255, 255, 255, 255, 255, 119, 255, 255, 255,
    255, 228, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 242,
    255, 255, 255, 255, 146, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 249, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 54, 255,
    255, 255, 255, 255, 255, 185, 255, 255, 255, 52, 255, 255, 0, 0,
    0, 52, 0, 0, 171, 255, 255, 255, 255, 84, 255, 61, 212, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 61, 255, 255, 255, 255, 255,
    255, 255, 234, 255, 41, 0, 229, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 223, 255, 255,
    255, 255, 55, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 226, 74, 255, 255, 255, 255, 0, 0,
    0, 123, 0, 0, 255, 255, 255, 255, 255, 255, 255, 32, 255, 255,
    255, 9, 255, 255, 255, 255, 242, 169, 255, 255, 47, 255, 255, 56,
    255, 203, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 49, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    22, 255, 141, 255, 255, 255, 255, 255, 255, 13, 255, 255, 255,
    255, 255, 255, 255, 64, 255, 255, 236, 232, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 217, 255, 255, 255, 255, 142, 255,
    255, 255, 255, 255, 255, 145, 255, 255, 255, 14, 255, 255, 255,
    255, 255, 255, 22, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 53, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 175, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 21, 255, 47, 255, 41, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 0, 0, 159, 0, 0, 0, 21, 255, 255, 193, 255, 255, 0, 104,
    181, 255, 172, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    151, 255, 255, 255, 255, 255, 255, 171, 255, 255, 255, 138, 255,
    255, 255, 195, 255, 255, 255, 255, 20, 255, 255, 255, 255, 255,
    255, 255, 30, 255, 255, 255, 255, 208, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 67, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 185, 255, 255, 255, 72, 129, 255, 227,
    255, 52, 255, 255, 255, 255, 255, 255, 156, 255, 59, 255, 125,
    255, 139, 176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 246, 255, 137, 255, 255, 255, 255, 238, 255, 255,
    255, 135, 255, 255, 194, 59, 0, 0, 255, 255, 255, 21, 255, 42, 27,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    34, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 206,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 174, 61, 0, 0, 0, 255, 255, 255, 255, 196, 255,
    255, 255, 255, 0, 135, 0, 255, 255, 255, 255, 255, 69, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 77, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 99, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 40, 137, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 181, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 79, 255, 255, 255, 255, 255, 255, 255, 35, 255, 255, 255,
    193, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 11, 255, 255,
    255, 255, 255, 255, 255, 20, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 231, 244, 0, 0, 36, 0, 0, 0,
    255, 157, 255, 255, 255, 255, 210, 255, 255, 255, 255, 255, 255,
    208, 255, 117, 0, 0, 0, 0, 0, 255, 255, 255, 120, 255, 255, 255,
    255, 255, 0, 28, 0, 255, 255, 255, 255, 255, 255, 255, 241, 255,
    255, 255, 255, 255, 255, 255, 255, 12, 255, 0, 50, 0, 255, 100,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 206,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 255, 255,
    255, 255, 255, 24, 0, 0, 0, 0, 139, 100, 255, 181, 255, 238, 61,
    80, 3, 255, 255, 255, 255, 255, 255, 255, 255, 178, 106, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 93, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    22, 162, 255, 255, 255, 255, 255, 255, 255, 255, 61, 255, 255,
    255, 86, 255, 255, 114, 255, 255, 255, 255, 255, 255, 255, 255,
    97, 255, 213, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 169, 255, 255, 255, 255, 255, 124, 255, 255, 255, 255,
    255, 255, 255, 213, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 5, 255, 255, 255, 255, 255, 255, 255, 255, 255, 98, 255, 255,
    255, 255, 160, 255, 255, 255, 0, 215, 0, 0, 0, 0, 255, 255, 115,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 53, 255, 255, 0, 0, 0, 255, 41, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 12, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 39, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 109, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 46, 255, 255,
    255, 255, 255, 255, 255, 146, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 58, 255, 255, 255, 255,
    255, 13, 255, 255, 255, 255, 147, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 22, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 166, 255, 255, 205, 255, 138, 255, 255, 255,
    255, 255, 255, 255, 185, 255, 255, 253, 82, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 149, 255, 255, 255, 255, 255, 255,
    255, 255, 209, 255, 231, 255, 255, 255, 11, 26, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 187, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 232, 0, 255, 255, 255, 255, 255, 255, 255,
    28, 255, 107, 255, 255, 255, 255, 255, 0, 0, 68, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 234, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 13, 255, 255, 255, 0, 0, 0, 0, 0,
    67, 255, 255, 244, 255, 255, 255, 0, 0, 0, 255, 255, 37, 30, 255,
    255, 255, 255, 255, 255, 255, 40, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 187, 255, 244,
    6, 255, 255, 255, 255, 255, 127, 213, 255, 255, 255, 19, 255, 63,
    28, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 170, 255, 255, 245,
    255, 255, 255, 108, 255, 255, 47, 255, 255, 255, 0, 191, 0, 0,
    252, 0, 75, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 66, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 240, 0, 0, 0, 0, 225, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 247, 0, 0, 0, 0, 0, 212,
    0, 0, 0, 0, 0, 0, 158, 0, 0, 0, 255, 255, 255, 255, 255, 209, 255,
    255, 255, 255, 255, 1, 255, 255, 78, 255, 255, 171, 255, 107, 255,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 27, 255, 255, 255, 255, 255,
    245, 255, 255, 246, 255, 146, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 33, 0, 0, 237, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 127, 243, 255, 255, 255, 255, 255, 0, 79,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    0, 0, 50, 255, 255, 255, 255, 255, 255, 169, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 116, 255, 255, 255, 95, 255, 27, 255,
    255, 25, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 109, 177, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 65, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 106, 255, 255, 255, 255,
    255, 255, 255, 225, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 236, 255, 83, 255, 255, 255, 255, 108, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 137, 255, 255,
    255, 163, 255, 153, 255, 40, 255, 255, 255, 255, 255, 255, 255,
    235, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100,
    255, 255, 255, 255, 255, 255, 255, 255, 197, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 31, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 237, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 11, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 182,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 231, 138, 255, 255, 209,
    255, 255, 201, 194, 255, 255, 255, 255, 255, 255, 255, 22, 255,
    238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 255, 255,
    255, 236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 151, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 212, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 120, 255, 92, 255, 255, 255, 116, 255,
    255, 255, 255, 255, 220, 255, 255, 255, 255, 255, 255, 109, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 165, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 162, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 253, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 195, 255, 255, 255, 255, 255, 255, 255,
    29, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 0, 0, 26, 0, 0, 0, 255, 255, 255, 255, 255, 156, 255,
    255, 255, 255, 255, 255, 204, 70, 255, 0, 93, 0, 0, 0, 0, 255,
    255, 255, 183, 255, 255, 0, 0, 0, 255, 22, 255, 19, 255, 255, 43,
    133, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 112, 255, 0, 0, 0, 0, 22, 0, 255, 79, 255,
    255, 132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    151, 0, 0, 0, 255, 255, 255, 255, 255, 255, 228, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 10, 0, 0, 0, 167, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 221, 255, 255, 246, 255, 29, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146,
    255, 131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 243, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 202, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 35, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 83, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 10, 0, 0, 0,
    205, 0, 255, 255, 255, 255, 255, 255, 210, 255, 139, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 146, 255, 255, 255, 255, 172, 255,
    255, 255, 255, 255, 255, 214, 255, 255, 255, 255, 255, 20, 255,
    255, 213, 255, 255, 255, 255, 255, 0, 166, 114, 255, 255, 255,
    255, 255, 255, 255, 37, 255, 255, 255, 255, 255, 255, 255, 139,
    255, 254, 255, 255, 102, 255, 255, 255, 255, 255, 101, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 210, 255, 255, 255, 255, 255, 187,
    255, 255, 60, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 69, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 169, 255, 255, 255, 255, 255, 179, 255, 26, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 145, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 78, 140, 199, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    142, 198, 255, 255, 255, 255, 151, 255, 255, 255, 255, 255, 237,
    128, 85, 255, 133, 255, 255, 136, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 160, 255, 255, 255, 255, 255, 255, 255,
    255, 186, 255, 255, 154, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 224, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139,
    0, 0, 0, 0, 0, 0, 0, 162, 198, 0, 0, 0, 0, 0, 104, 143, 0, 0, 0,
    0, 210, 251, 0, 0, 86, 255, 255, 255, 255, 24, 255, 255, 255, 101,
    57, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149,
    47, 255, 43, 255, 255, 255, 255, 255, 88, 255, 255, 255, 255, 255,
    0, 100, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 172, 255, 96, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 14, 255, 255, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 0, 119, 0, 0, 0, 0, 35, 255, 255, 255,
    255, 177, 255, 255, 235, 248, 255, 255, 255, 255, 255, 0, 164, 0,
    0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 133, 255, 255, 255, 255,
    255, 178, 255, 255, 255, 0, 0, 0, 0, 77, 0, 255, 255, 63, 255,
    255, 255, 186, 255, 112, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 47, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 145, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 68, 255, 255, 255,
    255, 255, 104, 255, 255, 255, 255, 255, 30, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 17, 0, 0, 75, 255, 255,
    75, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    0, 91, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 100, 255, 255, 255, 130, 255, 255, 255, 255, 183, 64,
    255, 255, 255, 0, 0, 0, 255, 78, 255, 255, 255, 255, 188, 255,
    255, 255, 255, 255, 255, 255, 186, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 10, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 187, 255, 180, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 143, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 133, 255, 255, 255, 64,
    255, 255, 255, 255, 255, 72, 255, 255, 255, 255, 199, 222, 255,
    255, 255, 255, 255, 255, 255, 126, 209, 255, 255, 255, 255, 255,
    255, 255, 203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 139, 255, 255, 255,
    113, 255, 255, 255, 255, 255, 91, 255, 255, 87, 119, 255, 255,
    255, 255, 243, 255, 70, 255, 255, 194, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 54, 255, 255, 255, 255, 255, 255, 97, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 193, 255, 3, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 25, 255, 255, 14, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 158, 86, 77,
    255, 255, 255, 146, 70, 0, 0, 17, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 244, 255,
    255, 15, 255, 12, 255, 255, 255, 255, 255, 255, 241, 255, 255,
    255, 255, 255, 176, 255, 44, 68, 255, 255, 255, 6, 255, 255, 255,
    93, 255, 255, 255, 255, 255, 255, 255, 255, 186, 255, 43, 254,
    255, 255, 255, 5, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 197, 255, 255, 111, 220,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 249, 255, 255, 255, 161, 255, 255, 255, 255, 255, 255,
    255, 255, 64, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 255, 101, 255, 255, 255, 255, 255, 94, 255, 255, 255,
    255, 255, 255, 255, 227, 0, 0, 0, 82, 0, 176, 169, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 221, 0, 0, 0, 178, 255, 196,
    255, 255, 255, 181, 0, 0, 0, 255, 255, 122, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 4, 147, 255, 255, 50, 0, 0, 0, 0, 0,
    0, 123, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 121,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 66, 0, 0, 0, 122, 0,
    255, 52, 255, 78, 255, 255, 255, 255, 255, 0, 0, 41, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 33, 255, 233, 255, 153, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 103, 255, 255,
    255, 255, 167, 243, 255, 255, 255, 255, 255, 0, 0, 0, 0, 136, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 26, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 255, 255, 255,
    255, 255, 255, 255, 126, 255, 255, 255, 137, 255, 255, 255, 255,
    179, 255, 255, 255, 255, 255, 228, 255, 167, 255, 255, 255, 255,
    255, 0, 0, 0, 255, 255, 255, 255, 255, 189, 255, 255, 255, 255,
    255, 255, 255, 72, 255, 255, 255, 255, 255, 255, 255, 144, 255,
    255, 255, 255, 255, 148, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 103, 0, 255, 255, 255,
    255, 255, 255, 255, 122, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 126, 255, 255, 255, 255, 255, 255, 112, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 125, 255, 255, 255, 255, 255, 255,
    255, 255, 230, 0, 0, 0, 0, 0, 30, 151, 255, 255, 255, 255, 255,
    255, 255, 240, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 200, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 0, 0, 175, 0, 0, 41, 255, 255, 255, 220, 255, 137, 255, 255,
    255, 255, 255, 91, 255, 255, 102, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 212, 255, 255, 6,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 46,
    255, 255, 255, 129, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    138, 255, 255, 255, 255, 206, 255, 255, 255, 255, 255, 255, 255,
    227, 255, 255, 255, 255, 255, 255, 255, 170, 255, 255, 255, 255,
    255, 255, 255, 255, 20, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    31, 255, 255, 0, 0, 0, 255, 79, 255, 255, 255, 224, 255, 255, 255,
    217, 255, 255, 255, 255, 255, 253, 255, 255, 255, 191, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 25, 255, 209, 255, 255, 255, 255,
    0, 0, 0, 255, 255, 7, 255, 255, 255, 0, 0, 244, 0, 0, 0, 255, 255,
    255, 255, 219, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 91, 0, 255, 255, 255, 113, 255, 255, 255, 200, 129, 0, 0, 76,
    255, 149, 255, 255, 255, 255, 154, 255, 255, 175, 217, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 255, 255,
    255, 255, 255, 255, 20, 255, 255, 255, 255, 255, 255, 148, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 201, 255,
    255, 255, 255, 255, 255, 229, 255, 255, 255, 255, 255, 82, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254,
    255, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 255,
    255, 255, 163, 255, 0, 0, 0, 255, 255, 255, 255, 195, 255, 255,
    255, 255, 193, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 255, 133, 210, 66, 255, 255, 0, 0, 0, 0, 0,
    0, 185, 102, 255, 179, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    0, 1, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 130, 0, 181, 44, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 175,
    255, 255, 255, 255, 255, 0, 0, 0, 27, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 134, 255, 0, 0, 230, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 132, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 10, 255, 255, 255, 255, 255, 255, 255, 203, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 80, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 205, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 255, 255, 255,
    255, 255, 255, 255, 172, 161, 255, 255, 0, 0, 0, 0, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 43, 0, 0, 255, 6,
    255, 255, 255, 255, 0, 20, 0, 255, 255, 255, 255, 255, 255, 53, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 191, 214,
    255, 255, 255, 47, 255, 255, 255, 209, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    93, 255, 255, 255, 70, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 255, 177, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 4, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 90, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 238, 255, 106, 230, 255, 65, 255, 255,
    255, 255, 255, 255, 255, 255, 240, 255, 255, 255, 255, 255, 255,
    109, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 126, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 219, 255, 0, 0, 0, 255, 177,
    255, 255, 255, 255, 255, 122, 255, 255, 255, 255, 0, 0, 0, 131,
    255, 255, 255, 255, 47, 255, 255, 255, 170, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 253, 0, 0, 45, 92, 0, 0, 0, 217, 0, 0, 0, 0, 0,
    0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 15, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 0, 46, 151, 255, 255, 255, 255, 255, 255, 255, 255,
    201, 255, 255, 255, 255, 255, 255, 255, 90, 214, 255, 71, 255,
    255, 215, 130, 255, 255, 255, 255, 255, 255, 255, 255, 241, 255,
    7, 255, 255, 255, 255, 255, 255, 255, 255, 187, 255, 255, 255,
    225, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 68,
    222, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 255, 255,
    255, 255, 255, 255, 54, 255, 70, 255, 255, 255, 255, 151, 255,
    255, 158, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 0, 0, 20, 0, 0, 0,
    10, 0, 0, 110, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 140, 55, 0, 78, 219, 0, 0, 0, 0, 0, 98, 0, 0, 0,
    202, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 95, 255, 180, 255, 255, 235, 255, 164, 255, 79, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 234, 0, 0, 29, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 179, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 45, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 20, 0, 0, 0,
    0, 0, 0, 93, 0, 0, 51, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    209, 255, 235, 255, 255, 255, 255, 255, 255, 255, 2, 255, 255,
    121, 255, 255, 255, 255, 189, 255, 255, 255, 255, 255, 255, 3,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 158,
    255, 255, 255, 255, 255, 255, 255, 200, 255, 255, 255, 255, 255,
    255, 255, 255, 232, 255, 255, 255, 255, 255, 255, 255, 183, 255,
    255, 255, 255, 255, 255, 255, 69, 255, 178, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 158, 0, 53, 0, 0, 0, 0, 0,
    0, 255, 255, 241, 255, 255, 255, 255, 255, 149, 184, 255, 255, 99,
    0, 17, 255, 255, 141, 255, 255, 255, 255, 152, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 109, 255,
    255, 255, 255, 180, 255, 255, 78, 255, 255, 255, 53, 255, 255,
    255, 255, 105, 1, 0, 0, 0, 255, 25, 255, 255, 152, 255, 255, 255,
    82, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 255, 255,
    255, 255, 255, 255, 255, 255, 149, 255, 23, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 53, 255, 255, 255,
    255, 148, 255, 255, 255, 255, 255, 255, 255, 255, 191, 255, 255,
    0, 85, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 96,
    255, 255, 255, 255, 78, 255, 255, 255, 255, 255, 255, 108, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 255, 255, 106,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 137, 255, 255, 255, 229, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 214, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 58, 255, 255, 255, 255, 20, 255, 255, 255,
    255, 255, 255, 255, 255, 5, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 191, 236, 255, 255,
    85, 255, 200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 45, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 247, 255, 142, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 253, 14, 255, 255, 255, 255, 72,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 144, 255, 255, 255, 5, 255, 255, 255, 255, 255, 85, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 72, 255, 211, 255,
    255, 255, 0, 255, 255, 255, 255, 255, 223, 15, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 173, 255, 255, 255, 255,
    255, 255, 136, 255, 255, 255, 40, 36, 255, 255, 255, 86, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 58, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 151, 255, 255,
    255, 255, 255, 124, 255, 255, 255, 255, 255, 255, 255, 255, 156,
    24, 255, 255, 255, 255, 255, 255, 255, 43, 124, 255, 255, 255,
    255, 255, 80, 255, 13, 255, 255, 255, 255, 236, 255, 255, 255,
    247, 255, 255, 255, 104, 255, 255, 255, 255, 255, 255, 200, 255,
    255, 255, 249, 255, 96, 255, 255, 255, 255, 255, 255, 255, 255,
    80, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 1, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 209, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 16, 165, 255, 255,
    255, 255, 255, 255, 220, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 95, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 177, 255, 255,
    255, 255, 255, 255, 31, 255, 255, 255, 255, 64, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128,
    255, 28, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 234, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 101, 255, 255, 255, 255, 255, 255, 255, 255,
    170, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 160, 255, 0, 0, 155, 0, 0, 0, 255, 255, 255, 255, 255,
    171, 92, 255, 255, 255, 247, 255, 255, 255, 255, 8, 178, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 107, 255,
    255, 255, 255, 255, 219, 255, 210, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 122, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 35, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 17, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 192, 255, 255, 255, 255, 255,
    255, 184, 255, 255, 255, 255, 255, 255, 144, 255, 255, 255, 152,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 52, 0, 0, 0, 0, 0, 0, 255, 207, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 255, 110, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 225, 255, 213, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 80, 241, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 137, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 220, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 0, 93, 0, 255, 255, 255, 255, 255, 255, 105, 255, 193, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 45, 255, 255, 8,
    255, 255, 143, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 52, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 142, 89, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 149, 116, 255, 220, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 110, 255, 255, 255, 255, 255, 255, 17, 191,
    255, 255, 255, 255, 255, 255, 255, 255, 158, 255, 255, 47, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 88, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 24, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 243, 13, 255, 255, 255,
    255, 176, 111, 255, 255, 255, 255, 255, 153, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    230, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    134, 255, 255, 255, 74, 255, 199, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 135, 255, 255, 255, 255, 255,
    255, 255, 139, 5, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 216, 255, 255, 0, 0, 22, 255, 255, 104, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 178, 255, 255, 255, 255, 250, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    26, 255, 255, 59, 255, 255, 255, 255, 255, 255, 119, 255, 255, 0,
    0, 0, 255, 191, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 221, 255, 117, 255, 255, 255, 255, 255,
    19, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 200, 144, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 129, 255, 255, 255, 19, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 111, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 76, 255, 255, 255, 255, 229, 255, 211, 255, 192,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 110, 255, 255, 84, 255, 255, 255, 211,
    57, 255, 255, 86, 255, 255, 2, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 142, 255, 255, 255, 255, 255, 255, 92,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 148, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 20, 255, 255, 255, 255,
    255, 255, 255, 255, 15, 255, 255, 255, 14, 160, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 85, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 192, 255, 117, 255, 255, 255, 255, 255, 255, 255, 40,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 137, 0, 0,
    0, 0, 0, 255, 142, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 22, 255, 255, 255, 157, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 255, 255,
    191, 255, 255, 25, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 182, 255, 255, 255, 255, 255, 120, 255, 255, 255, 255, 255,
    64, 255, 255, 255, 255, 255, 34, 255, 125, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 107, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 53,
    166, 255, 255, 255, 255, 255, 255, 135, 255, 71, 255, 49, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 58, 255, 255, 255, 255, 255, 117, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 231, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 0, 255, 255, 255, 255,
    255, 11, 255, 255, 255, 255, 255, 255, 255, 255, 162, 255, 175,
    255, 255, 255, 255, 255, 255, 88, 255, 255, 255, 151, 255, 255,
    255, 255, 72, 255, 255, 255, 91, 255, 255, 255, 184, 255, 255,
    255, 255, 255, 255, 255, 135, 255, 175, 255, 255, 255, 255, 255,
    255, 255, 255, 36, 255, 255, 255, 255, 255, 255, 255, 255, 88,
    255, 255, 165, 255, 255, 255, 255, 1, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 76, 255, 255, 28, 255, 255, 255, 181, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 122, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 232, 255, 255, 208, 255, 167, 255, 147, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 118, 255, 255,
    80, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    253, 255, 255, 255, 255, 255, 255, 66, 255, 12, 123, 255, 241,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 112, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 107, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 148, 255, 255, 255, 44, 255, 255, 106, 255, 164, 255,
    255, 255, 36, 255, 255, 255, 255, 255, 255, 255, 255, 255, 34,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 222, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 121, 255, 46, 244, 255, 255, 255, 255,
    51, 255, 255, 255, 255, 255, 135, 99, 7, 116, 255, 255, 255, 255,
    255, 255, 255, 255, 160, 255, 255, 255, 255, 255, 0, 207, 0, 0, 0,
    0, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 171, 20, 255, 255, 255, 66, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 55, 255, 133, 132, 0, 255, 255,
    155, 255, 255, 255, 0, 0, 100, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 143, 255, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 0, 104, 0, 255, 255, 255, 255, 255, 255, 168, 255, 255,
    255, 255, 255, 255, 255, 192, 255, 255, 255, 255, 255, 255, 159,
    255, 255, 255, 255, 255, 255, 26, 218, 121, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 57, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 196, 255, 157, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 94, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 50, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 6, 255, 255, 255, 255, 255, 65, 255, 255, 255,
    255, 255, 255, 255, 255, 79, 255, 255, 255, 255, 255, 255, 255,
    255, 185, 243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    9, 255, 107, 255, 255, 255, 255, 73, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 13, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 158, 255, 255, 84,
    180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 173, 255, 255, 255, 255, 137, 255, 255, 86, 13,
    255, 255, 255, 255, 255, 255, 255, 255, 122, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 166, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 104, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 255, 255, 104,
    255, 255, 35, 255, 255, 255, 255, 255, 255, 48, 255, 255, 255,
    255, 193, 255, 255, 255, 255, 255, 255, 255, 255, 175, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 211, 255, 255, 42, 255, 255, 255, 255, 255, 255,
    149, 255, 255, 255, 255, 230, 255, 255, 255, 255, 255, 255, 255,
    1, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 79, 255, 255, 255, 255, 255, 255, 255, 166, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 66, 255, 255, 255, 255, 255, 255, 255, 186, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 207, 255, 7, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 154, 255, 218, 167,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 4, 255,
    255, 255, 255, 255, 255, 121, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 0, 255, 255, 255, 255, 255, 255, 123, 255, 171, 255,
    255, 175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 171, 255, 255, 140, 56, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 66, 255, 255, 255, 255,
    255, 198, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 0, 36, 0, 0, 0, 0, 255, 255, 255, 0, 160, 152, 255, 255, 255,
    255, 255, 255, 255, 255, 40, 220, 255, 255, 73, 255, 255, 255,
    180, 255, 255, 255, 51, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 66, 255,
    206, 255, 255, 255, 255, 255, 255, 255, 222, 255, 93, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 15, 255, 255, 255, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 47, 36, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 165, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 185, 255, 255, 255, 49, 232, 255, 255, 255, 190, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 187, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 175, 255, 255,
    255, 255, 255, 152, 61, 255, 255, 45, 153, 255, 255, 255, 255, 38,
    236, 255, 255, 255, 255, 249, 255, 255, 255, 255, 255, 207, 255,
    67, 255, 255, 255, 255, 255, 175, 255, 255, 255, 255, 255, 255,
    253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    53, 158, 255, 255, 255, 255, 255, 71, 103, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 177, 255, 255, 255, 255, 125,
    34, 255, 191, 255, 255, 58, 255, 255, 219, 255, 255, 255, 255,
    255, 255, 255, 255, 88, 167, 255, 255, 8, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 37, 255, 255,
    255, 255, 37, 112, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 104, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 77, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 124, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 134, 255, 255, 255, 255, 255, 255,
    255, 240, 255, 255, 255, 255, 255, 255, 255, 170, 255, 255, 255,
    255, 89, 255, 196, 255, 255, 255, 255, 255, 43, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 79, 255, 255,
    255, 255, 255, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 187, 255, 255, 255, 255, 255, 255, 255, 255, 202,
    255, 255, 255, 255, 255, 105, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 127, 255, 255, 255, 255, 255, 255, 191, 255, 255,
    255, 255, 255, 255, 255, 196, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 211, 255, 255, 255, 177, 255, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 140, 255, 255, 255, 255, 255, 153, 255, 255, 255, 255,
    255, 0, 221, 0, 255, 244, 255, 255, 255, 255, 255, 255, 129, 255,
    255, 255, 255, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 234, 255, 255, 255, 174, 125, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 34, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 118, 255, 176, 255, 255, 255, 255, 136, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    174, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 152, 255, 15, 255, 255, 255, 46, 143, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 228, 0, 0, 0, 0, 153, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 243, 21, 255, 255, 255, 255, 255, 255, 255, 73, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 47, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 28, 32, 255, 255, 255, 255, 255, 145, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 126, 255, 255, 255,
    255, 255, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 2,
    255, 255, 255, 255, 255, 255, 255, 171, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 241, 255, 255, 239, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 251, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 96, 255, 255, 255,
    255, 255, 35, 255, 255, 255, 255, 255, 255, 255, 163, 255, 255,
    255, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 57, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    243, 255, 49, 255, 255, 255, 255, 255, 255, 44, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    5, 255, 255, 151, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 216, 255, 237,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 118, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 96, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 153, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    63, 255, 255, 23, 255, 145, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 252, 255, 255, 255, 255, 255, 255, 255, 63,
    255, 255, 255, 255, 123, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 32, 255, 255, 108, 11,
    134, 16, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 100, 255, 17, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233,
    255, 255, 217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 204, 255, 255, 255, 255, 255, 255, 149, 255, 255, 255,
    255, 211, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    12, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 123, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 114, 234, 255, 255, 255, 56, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 129, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 197,
    255, 255, 255, 255, 255, 255, 255, 75, 255, 231, 255, 40, 255,
    255, 255, 255, 255, 163, 255, 255, 255, 255, 255, 255, 90, 255,
    159, 255, 255, 255, 255, 255, 255, 255, 255, 137, 255, 255, 255,
    255, 65, 255, 255, 255, 255, 255, 255, 255, 255, 142, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 182, 44,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 194, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 146, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 6, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 90, 8, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 61, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 101, 255, 255, 255,
    255, 221, 255, 255, 255, 255, 255, 133, 255, 255, 255, 255, 255,
    59, 255, 255, 255, 255, 68, 255, 255, 201, 115, 255, 255, 255,
    145, 255, 255, 255, 255, 238, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 126, 255, 255, 255, 190, 255, 255, 255,
    255, 255, 255, 255, 185, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 84, 255, 161, 255, 255, 255, 255, 255, 3, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 9, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    192, 52, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 90, 165, 255, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 114, 229, 255, 255, 255, 152, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 98, 255, 255, 255, 255, 255,
    255, 255, 255, 183, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 89,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 30, 255, 255, 255,
    255, 255, 255, 94, 255, 255, 255, 255, 255, 255, 225, 255, 255,
    255, 157, 255, 255, 255, 255, 152, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230,
    255, 154, 255, 255, 255, 213, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 142, 255, 53, 255, 59, 255, 184, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 91,
    255, 255, 255, 24, 255, 255, 17, 255, 255, 8, 255, 255, 255, 255,
    255, 255, 255, 255, 180, 255, 255, 255, 255, 255, 255, 1, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 70, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 58, 255, 60, 255, 255, 255,
    199, 255, 255, 255, 79, 241, 255, 221, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 44, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 104, 255, 255, 255, 255, 255, 255, 255,
    240, 255, 255, 255, 255, 29, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 71, 255, 78, 255, 255, 247, 255, 255,
    255, 233, 255, 255, 255, 88, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 90, 255, 255, 255, 255, 170, 230, 255, 255, 255, 255,
    255, 139, 152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 184, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 191, 125, 255, 255, 255,
    255, 255, 255, 255, 253, 255, 113, 255, 237, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 232, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 60, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 41, 255, 255, 255, 255,
    255, 255, 110, 124, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 53, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 252, 255, 255, 212, 255, 255, 255, 255,
    255, 61, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 102, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 41, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 77, 255, 255, 255, 255, 255,
    255, 255, 69, 52, 1, 255, 255, 255, 233, 255, 12, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 181, 255,
    255, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 61, 255, 255, 188, 255, 255, 198, 255, 255, 222, 255,
    255, 255, 255, 255, 6, 255, 255, 255, 255, 195, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 154, 255, 255, 255, 255, 178, 255,
    34, 104, 148, 255, 255, 114, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 34, 255, 255, 12, 255, 185, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 245, 255, 206, 255, 255, 255, 255, 87,
    255, 255, 255, 255, 255, 13, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 180, 186, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 154, 255, 255, 255, 255, 255, 168, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 51, 255, 255, 255, 255, 255,
    66, 255, 255, 255, 255, 194, 255, 208, 255, 255, 255, 68, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 35, 89, 255, 255, 255, 74, 222, 160, 15, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 231, 121,
    255, 255, 255, 255, 121, 255, 255, 255, 255, 255, 255, 209, 255,
    255, 255, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    170, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    249, 255, 255, 255, 255, 255, 76, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 236, 255, 122, 255, 255, 255, 255, 255, 255, 255,
    206, 255, 255, 255, 255, 255, 255, 255, 255, 105, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 113, 255, 255, 216, 255,
    255, 255, 61, 255, 255, 255, 144, 255, 28, 255, 255, 255, 255,
    105, 29, 255, 255, 255, 255, 153, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 1, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 113, 255, 255, 255, 255, 255,
    255, 255, 255, 45, 255, 255, 255, 255, 0, 255, 255, 255, 255, 175,
    255, 255, 255, 255, 255, 255, 255, 255, 158, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 90, 255, 255, 255, 255, 255, 120, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 255, 255,
    255, 255, 134, 255, 255, 255, 88, 255, 255, 255, 255, 255, 242,
    206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 167, 255, 255, 255, 255, 255, 255,
    10, 255, 255, 255, 255, 50, 255, 255, 176, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    44, 255, 255, 175, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 158, 255, 255, 255, 255, 97, 255, 255, 255,
    32, 255, 255, 255, 82, 255, 33, 0, 0, 0, 0, 0, 186, 255, 255, 255,
    100, 1, 255, 255, 255, 255, 255, 255, 255, 253, 101, 255, 212,
    255, 37, 255, 255, 255, 255, 255, 255, 191, 255, 255, 18, 255,
    255, 255, 255, 197, 255, 3, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 27, 255, 251, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 185, 255,
    255, 102, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 232, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 99, 255, 255, 255, 255, 255, 255, 245, 255, 255, 255,
    89, 255, 255, 255, 255, 255, 255, 255, 255, 255, 212, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 123, 255, 255, 255, 255, 108, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 105, 136, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 17, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 85, 255, 255, 255, 255, 156, 255, 255, 255,
    255, 255, 255, 255, 75, 255, 255, 255, 255, 255, 255, 255, 158,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 195, 255, 255, 255, 251, 255, 255, 255, 255, 255, 255, 255,
    255, 27, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 190, 255, 255, 255, 255, 255, 255, 255, 255, 255, 50,
    255, 255, 255, 88, 255, 255, 255, 255, 255, 255, 255, 137, 255,
    255, 255, 255, 255, 255, 232, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 235, 255, 255, 255, 255, 144, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 139, 255, 255, 255, 255, 122,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 24, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 241, 255, 233, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 106, 90, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 29, 255,
    244, 251, 255, 255, 255, 255, 200, 255, 77, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 240, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 79, 255, 255, 255, 255, 255, 255, 255, 177, 255, 255, 255,
    255, 255, 255, 255, 13, 233, 3, 135, 255, 255, 255, 255, 255, 16,
    57, 255, 255, 255, 230, 255, 255, 255, 255, 188, 255, 255, 255,
    112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 57,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 168,
    237, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 22, 255, 255, 255, 32, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 163, 255, 255, 255, 255, 255,
    236, 255, 255, 255, 201, 167, 255, 255, 255, 255, 190, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 86, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 139, 255, 255, 41, 255, 43, 203,
    180, 255, 255, 255, 255, 255, 255, 255, 255, 162, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 152,
    255, 255, 255, 255, 255, 255, 220, 255, 255, 255, 255, 212, 255,
    255, 255, 255, 255, 255, 255, 58, 255, 255, 255, 255, 255, 255,
    15, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 124, 255, 255, 255, 255,
    255, 255, 49, 255, 255, 255, 255, 255, 191, 255, 255, 255, 39,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 107, 255, 255, 193, 255, 255, 255, 44, 255, 255, 8,
    255, 255, 0, 215, 252, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 153, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 179, 255, 255,
    255, 255, 255, 255, 255, 204, 255, 255, 47, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255,
    255, 255, 24, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 199, 154, 255, 7, 255, 73, 255, 106,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 212, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 185, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 177, 255,
    177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 178, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 255,
    227, 255, 255, 255, 255, 255, 255, 255, 227, 255, 255, 82, 172,
    255, 255, 255, 255, 255, 241, 255, 255, 128, 255, 255, 66, 54,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 49, 255, 255, 255, 255, 255, 148, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 236, 255, 255, 255, 255, 255, 255, 255,
    80, 255, 255, 53, 255, 236, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 209, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    137, 148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 147, 115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    71, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 28, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};

  
static unsigned char const valid_ppm_1[] = {    
    80, 54, 35, 102, 111, 111, 10, 35, 102, 111, 111, 10, 49, 48, 32,
    49, 48, 35, 102, 111, 111, 10, 32, 9, 35, 102, 111, 111, 32, 52,
    52, 10, 50, 53, 53, 10, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 10 
};

static unsigned char const valid_ppm_2[] = {
    80, 54, 10, 35, 102, 111, 111, 10, 49, 48, 32, 49, 48, 10, 50, 53,
    53, 10, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32,
    32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32,
    32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 10, 80, 54, 10,
    35, 102, 111, 111, 10, 49, 48, 32, 49, 48, 10, 50, 53, 53, 10, 97,
    97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97,
    97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 97, 97, 97,
    97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88,
    88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88,
    88, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97,
    97, 97, 97, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 97,
    97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97,
    97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88, 88, 88,
    88, 88, 88, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97,
    97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88,
    88, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97,
    97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88,
    88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88,
    88, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88, 88, 88,
    88, 88, 88, 97, 97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97,
    97, 97, 97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97,
    97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 97, 97, 97,
    97, 97, 97, 88, 88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 88,
    88, 88, 88, 88, 88, 97, 97, 97, 97, 97, 97, 10, 10 
};

static unsigned char const valid_ppm_3[] = {
    80, 54, 10, 56, 32, 56, 10, 54, 53, 53, 51, 53, 10, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 10, 10 
};

static unsigned char const valid_ppm_4[] = {
    80, 51, 10, 49, 48, 32, 49, 48, 10, 50, 53, 53, 10, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    10, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 10, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 10, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 10, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48,
    10, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 10, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 10, 51, 50, 32,
    32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32,
    49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32,
    49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    32, 51, 50, 10, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 10, 49, 50, 48, 32, 49,
    50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51,
    50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50,
    48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50,
    48, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51,
    50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50,
    48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50,
    48, 10, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50,
    48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50,
    32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48,
    32, 49, 50, 48, 32, 49, 50, 48, 10, 51, 50, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32,
    49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32,
    49, 50, 48, 32, 49, 50, 48, 32, 32, 51, 50, 32, 32, 51, 50, 32,
    32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 10,
    51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49,
    50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 49, 50, 48, 32, 32,
    51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32, 51, 50, 32, 32,
    51, 50, 32, 32, 51, 50, 10, 10 
};

static unsigned char const invalid_ppm_1[] = {
    80, 54, 10, 49, 48, 32, 49, 48, 10, 50, 53, 53, 35, 10, 120, 120,
    120, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 10 
};

static unsigned char const invalid_ppm_2[] = {
    80, 54, 32, 10, 49, 48, 32, 49, 48, 10, 50, 53, 53, 35, 10, 120,
    120, 120, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 10 
};

static unsigned char invalid_ppm_3[] = {
     80, 54, 10, 49, 48, 32, 49, 48, 10, 49, 48, 48, 48, 48, 48, 48,
     32, 10, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32,
     32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32,
     32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
     32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
     120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
     120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
     32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
     120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
     120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
     120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120,
     120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
     120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
     120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32,
     32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120, 120, 120,
     120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
     120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32,
     32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
     32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
     32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 10
};

static unsigned char const invalid_ppm_4[] = {
    80, 54, 32, 10, 49, 48, 32, 49, 48, 10, 49, 48, 10, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 10 
}; 

static unsigned char const invalid_ppm_5[] = {
    80, 54, 10, 48, 32, 48, 10, 50, 53, 53, 10, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 10 
};

static unsigned char const invalid_ppm_6[] = { 
    80, 54, 10, 45, 49, 32, 45, 49, 10, 50, 53, 53, 10, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120,
    32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32,
    32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32,
    120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 10 
};

static unsigned char const invalid_ppm_7[] = {
    80, 54, 32, 49, 48, 32, 49, 48, 32, 45, 49, 10, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 10 
};

static unsigned char const invalid_ppm_8[] = {
    80, 54, 10, 49, 48, 32, 49, 48, 10, 48, 10, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32,
    32, 32, 32, 32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32,
    32, 120, 120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120,
    120, 120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120,
    120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120, 120,
    120, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 120, 120,
    120, 120, 120, 120, 32, 32, 32, 32, 32, 32, 120, 120, 120, 120,
    120, 120, 32, 32, 32, 32, 32, 32, 10, 10 
};

static unsigned char const xpm_test_1[] = {
    47, 42, 32, 88, 80, 77, 32, 42, 47, 10, 115, 116, 97, 116, 105,
    99, 32, 99, 104, 97, 114, 32, 42, 91, 93, 32, 61, 32, 123, 10, 47,
    42, 32, 119, 105, 100, 116, 104, 32, 104, 101, 105, 103, 104, 116,
    32, 110, 99, 111, 108, 111, 114, 115, 32, 99, 104, 97, 114, 115,
    95, 112, 101, 114, 95, 112, 105, 120, 101, 108, 32, 42, 47, 10,
    34, 49, 48, 32, 49, 48, 32, 50, 32, 49, 34, 44, 10, 47, 42, 32,
    99, 111, 108, 111, 114, 115, 32, 42, 47, 10, 34, 32, 32, 99, 32,
    35, 55, 56, 55, 56, 55, 56, 34, 44, 10, 34, 46, 32, 99, 32, 35,
    50, 48, 50, 48, 50, 48, 34, 44, 10, 34, 120, 32, 9, 99, 32, 35,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
    34, 44, 10, 47, 42, 32, 112, 105, 120, 101, 108, 115, 32, 42, 47,
    10, 34, 46, 46, 32, 32, 46, 46, 32, 32, 46, 46, 34, 44, 10, 34,
    46, 46, 32, 32, 46, 46, 32, 32, 46, 46, 34, 44, 10, 34, 32, 32,
    46, 46, 32, 32, 46, 46, 32, 32, 34, 44, 10, 34, 32, 32, 46, 46,
    32, 32, 46, 46, 32, 32, 34, 44, 10, 34, 46, 46, 32, 32, 46, 46,
    32, 32, 46, 46, 34, 44, 10, 34, 46, 46, 32, 32, 46, 46, 32, 32,
    46, 46, 34, 44, 10, 34, 32, 32, 46, 46, 32, 32, 46, 46, 32, 32,
    34, 44, 10, 34, 32, 32, 46, 46, 32, 32, 46, 46, 32, 32, 34, 44,
    10, 34, 46, 46, 32, 32, 46, 46, 32, 32, 46, 46, 34, 44, 10, 34,
    46, 46, 32, 32, 46, 46, 32, 32, 46, 46, 34, 10, 125, 59, 10
};

static unsigned char const ico_test_2[] = {
    0, 0, 1, 0, 1, 0, 16, 16, 16, 0, 0, 0, 0, 0, 40, 1, 0, 0, 22, 0,
    0, 0, 40, 0, 0, 0, 233, 0, 0, 0, 32, 0, 140, 0, 1, 0, 4, 0, 0, 0,
    0, 0, 128, 0, 0, 0, 0, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 114, 0, 0, 128, 0, 0, 128, 0, 0, 0, 128, 128, 0, 128,
    0, 0, 0, 128, 0, 128, 0, 128, 128, 0, 0, 192, 192, 192, 0, 128,
    128, 128, 0, 103, 0, 255, 0, 0, 255, 0, 0, 0, 255, 255, 0, 255, 0,
    0, 0, 255, 0, 255, 0, 255, 6, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 153, 153, 153, 9, 144, 0, 0, 0, 0, 153,
    0, 0, 0, 0, 0, 0, 0, 153, 0, 0, 153, 0, 0, 0, 9, 153, 144, 0, 231,
    144, 0, 0, 153, 144, 153, 0, 9, 144, 0, 9, 153, 0, 9, 144, 9, 153,
    0, 153, 144, 0, 153, 172, 153, 110, 153, 153, 153, 144, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 153, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 81, 255, 0, 0,
    255, 255, 0, 0, 240, 55, 0, 0, 240, 39, 0, 0, 252, 123, 0, 199,
    252, 113, 0, 0, 248, 48, 0, 0, 73, 24, 0, 0, 227, 136, 0, 0, 129,
    0, 0, 0, 1, 255, 0, 0, 255, 255, 0, 0, 255, 255, 0, 0, 255, 255,
    255, 0, 255, 255, 0, 0
};

static unsigned char const tiff1_test_3[] = {
77, 77, 0, 42, 0, 0, 6, 222, 128, 0, 32, 80, 56, 36, 22, 13, 7, 132, 66, 97, 80, 184, 100, 54, 29, 15, 136, 68, 98, 81, 56, 164, 86, 45, 23, 140, 70, 99, 81, 184, 228, 118, 61, 21, 23, 72, 79, 231, 227, 233, 116, 184, 89, 143, 202, 101, 82, 162, 188, 181, 194, 224, 112, 61, 222, 207, 86, 179, 61, 148, 138, 65, 159, 2, 179, 185, 92, 246, 125, 15, 157, 133, 90, 12, 246, 123, 241, 246, 251, 123, 61, 30, 109, 38, 107, 33, 40, 139, 66, 22, 138, 165, 41, 253, 86, 54, 98, 172, 48, 23, 203, 213, 98, 165, 76, 74, 35, 17, 32, 198, 171, 35, 201, 224, 239, 122, 218, 108, 238, 230, 67, 9, 124, 160, 75, 164, 12, 69, 210, 184, 136, 56, 28, 82, 94, 98, 36, 1, 232, 245, 212, 233, 116, 188, 29, 206, 198, 189, 49, 84, 161, 76, 19, 9, 4, 104, 26, 149, 72, 163, 117, 186, 157, 86, 103, 123, 149, 198, 224, 98, 175, 151, 9, 116, 122, 31, 21, 98, 189, 104, 97, 233, 100, 178, 85, 220, 237, 118, 62, 38, 83, 86, 82, 141, 50, 145, 206, 160, 4, 91, 53, 122, 189, 93, 131, 200, 185, 220, 141, 210, 99, 25, 140, 188, 91, 39, 243, 131, 209, 216, 215, 69, 199, 134, 41, 241, 249, 118, 235, 133, 186, 218, 108, 83, 49, 9, 4, 66, 0, 244, 110, 52, 153, 121, 74, 39, 11, 113, 175, 209, 102, 178, 88, 11, 133, 226, 209, 86, 148, 70, 33, 5, 98, 113, 63, 35, 221, 8, 68, 161, 208, 141, 38, 83, 17, 146, 194, 94, 47, 86, 170, 222, 169, 232, 136, 190, 11, 130, 184, 164, 51, 174, 102, 17, 114, 89, 23, 101, 145, 84, 93, 150, 37, 65, 84, 80, 19, 35, 152, 218, 51, 61, 240, 170, 14, 190, 7, 176, 49, 100, 85, 148, 36, 211, 168, 64, 191, 225, 234, 18, 156, 142, 164, 154, 160, 69, 144, 99, 232, 210, 49, 139, 175, 96, 69, 11, 56, 226, 228, 100, 69, 145, 68, 74, 66, 21, 160, 99, 80, 202, 47, 196, 130, 0, 118, 28, 33, 129, 112, 86, 21, 142, 131, 104, 206, 55, 64, 143, 91, 219, 24, 52, 43, 184, 56, 114, 74, 7, 201, 240, 124, 24, 37, 241, 116, 28, 6, 161, 146, 7, 33, 201, 104, 130, 130, 147, 138, 177, 216, 180, 226, 7, 10, 12, 152, 159, 10, 162, 168, 168, 180, 158, 167, 137, 224, 120, 25, 102, 25, 120, 65, 15, 131, 172, 204, 138, 72, 97, 88, 161, 61, 140, 163, 24, 196, 169, 138, 82, 192, 101, 59, 204, 232, 240, 218, 53, 141, 103, 91, 0, 104, 153, 198, 97, 112, 88, 149, 114, 64, 196, 187, 47, 8, 117, 14, 53, 151, 148, 201, 207, 77, 166, 115, 105, 222, 119, 81, 71, 57, 162, 250, 151, 80, 220, 76, 66, 175, 146, 5, 10, 140, 71, 225, 193, 160, 101, 24, 102, 65, 130, 93, 145, 164, 49, 1, 65, 72, 41, 13, 50, 93, 158, 170, 85, 122, 121, 157, 167, 89, 215, 79, 157, 172, 17, 216, 109, 155, 6, 171, 192, 250, 24, 144, 73, 82, 71, 186, 178, 85, 86, 140, 19, 132, 161, 30, 88, 148, 228, 248, 214, 51, 12, 8, 52, 92, 129, 175, 161, 233, 168, 105, 26, 71, 205, 204, 120, 157, 231, 105, 230, 179, 29, 39, 49, 200, 238, 155, 39, 41, 196, 111, 154, 70, 113, 148, 106, 25, 230, 89, 159, 89, 22, 69, 65, 64, 55, 197, 97, 91, 103, 105, 162, 243, 201, 17, 58, 8, 81, 242, 12, 217, 132, 79, 96, 78, 104, 168, 105, 145, 234, 153, 158, 135, 97, 210, 115, 155, 134, 177, 164, 214, 86, 5, 225, 142, 205, 86, 69, 217, 90, 83, 148, 70, 17, 112, 87, 147, 196, 177, 28, 190, 7, 120, 34, 45, 60, 135, 25, 138, 7, 39, 32, 116, 33, 109, 155, 159, 89, 201, 229, 116, 88, 39, 65, 181, 124, 89, 134, 81, 128, 93, 25, 70, 9, 117, 102, 60, 69, 203, 244, 87, 51, 132, 64, 247, 9, 101, 200, 169, 81, 169, 221, 103, 149, 210, 118, 22, 244, 128, 132, 226, 32, 195, 72, 210, 51, 234, 178, 145, 240, 164, 158, 102, 249, 178, 106, 233, 38, 57, 122, 91, 25, 15, 25, 158, 99, 152, 6, 107, 50, 97, 212, 186, 17, 114, 85, 148, 68, 208, 148, 36, 52, 26, 138, 30, 147, 11, 151, 89, 227, 94, 158, 135, 57, 198, 112, 212, 165, 73, 8, 62, 142, 242, 200, 92, 129, 151, 5, 193, 110, 122, 221, 116, 237, 218, 113, 154, 134, 105, 142, 101, 152, 69, 217, 156, 99, 23, 230, 81, 132, 93, 110, 69, 241, 160, 182, 243, 229, 249, 121, 5, 17, 196, 48, 254, 187, 130, 187, 242, 33, 152, 134, 171, 105, 123, 205, 24, 87, 217, 132, 225, 17, 227, 80, 198, 47, 192, 130, 234, 130, 109, 186, 24, 149, 66, 107, 26, 38, 103, 82, 103, 51, 60, 225, 163, 56, 151, 134, 100, 228, 100, 232, 197, 225, 102, 85, 146, 164, 105, 10, 36, 97, 61, 146, 42, 56, 71, 68, 239, 178, 66, 241, 130, 147, 20, 129, 139, 162, 200, 168, 25, 36, 55, 121, 191, 171, 157, 23, 145, 160, 100, 152, 102, 51, 52, 241, 150, 59, 161, 103, 207, 152, 6, 41, 118, 44, 215, 240, 151, 16, 65, 236, 58, 56, 231, 188, 70, 147, 33, 197, 75, 68, 21, 84, 170, 213, 218, 57, 24, 176, 231, 27, 111, 32, 106, 147, 97, 150, 102, 69, 184, 175, 21, 78, 116, 90, 183, 129, 54, 36, 132, 80, 130, 44, 1, 10, 3, 154, 36, 156, 14, 209, 251, 134, 28, 6, 8, 118, 141, 241, 180, 53, 143, 2, 163, 24, 109, 200, 95, 139, 5, 252, 122, 4, 48, 56, 125, 144, 149, 10, 187, 67, 188, 53, 7, 80, 231, 50, 195, 124, 109, 141, 56, 46, 243, 5, 240, 205, 24, 130, 244, 90, 10, 161, 27, 24, 10, 145, 24, 12, 201, 244, 78, 137, 193, 56, 44, 197, 144, 175, 21, 162, 168, 84, 9, 1, 26, 34, 140, 81, 140, 135, 132, 29, 46, 13, 65, 160, 50, 199, 41, 206, 55, 67, 132, 104, 191, 72, 148, 47, 22, 104, 180, 131, 226, 45, 105, 17, 16, 214, 89, 23, 24, 208, 87, 236, 236, 119, 194, 193, 224, 106, 25, 248, 206, 65, 34, 168, 58, 36, 136, 198, 65, 198, 64, 196, 24, 17, 164, 110, 142, 56, 136, 53, 222, 73, 226, 23, 2, 232, 87, 138, 120, 66, 31, 8, 144, 66, 147, 76, 92, 115, 46, 177, 224, 229, 35, 224, 238, 129, 235, 200, 111, 201, 1, 152, 43, 197, 40, 157, 72, 161, 156, 19, 176, 57, 14, 64, 133, 140, 91, 28, 67, 116, 108, 194, 225, 172, 53, 70, 112, 200, 25, 169, 200, 96, 11, 97, 90, 137, 8, 144, 70, 44, 48, 76, 105, 158, 9, 28, 54, 230, 56, 215, 140, 238, 100, 99, 140, 83, 128, 37, 196, 112, 135, 125, 136, 226, 87, 144, 65, 24, 124, 155, 48, 213, 152, 242, 224, 100, 58, 145, 122, 130, 132, 123, 174, 54, 106, 84, 136, 7, 64, 222, 26, 163, 138, 204, 137, 13, 38, 36, 10, 241, 76, 39, 131, 179, 224, 154, 164, 28, 44, 166, 161, 178, 53, 6, 116, 182, 59, 195, 73, 231, 11, 241, 104, 43, 5, 24, 154, 18, 65, 152, 47, 133, 160, 106, 72, 72, 144, 123, 14, 193, 200, 105, 155, 214, 50, 185, 32, 184, 196, 84, 162, 180, 82, 9, 196, 4, 19, 39, 153, 6, 73, 194, 248, 91, 139, 37, 152, 53, 92, 211, 165, 100, 194, 197, 213, 138, 161, 60, 37, 68, 115, 218, 15, 193, 173, 29, 168, 66, 24, 50, 6, 48, 196, 29, 99, 160, 115, 77, 199, 252, 45, 5, 17, 175, 160, 238, 62, 140, 144, 119, 92, 30, 197, 240, 182, 21, 238, 113, 207, 58, 8, 148, 47, 88, 248, 182, 168, 34, 181, 126, 138, 5, 74, 42, 160, 200, 170, 19, 162, 100, 75, 136, 163, 228, 38, 132, 200, 152, 22, 85, 108, 106, 85, 213, 204, 62, 98, 8, 229, 159, 131, 21, 13, 8, 48, 246, 29, 105, 233, 10, 9, 205, 238, 95, 10, 97, 127, 80, 159, 227, 69, 104, 135, 141, 181, 11, 74, 36, 44, 155, 104, 184, 134, 82, 204, 109, 14, 65, 192, 55, 71, 66, 239, 148, 3, 246, 194, 20, 161, 226, 188, 134, 244, 220, 91, 2, 124, 42, 86, 186, 210, 67, 4, 200, 144, 17, 66, 224, 87, 10, 119, 160, 244, 133, 227, 206, 166, 242, 236, 94, 86, 57, 184, 54, 74, 96, 224, 27, 99, 93, 203, 194, 197, 130, 58, 99, 72, 222, 60, 13, 208, 89, 30, 144, 250, 7, 9, 229, 143, 173, 69, 218, 84, 156, 40, 154, 40, 134, 32, 188, 22, 182, 98, 73, 60, 227, 126, 45, 157, 56, 193, 166, 241, 180, 97, 186, 113, 132, 55, 70, 192, 212, 146, 3, 46, 35, 12, 90, 228, 131, 196, 192, 80, 124, 246, 200, 135, 161, 32, 210, 41, 40, 18, 15, 19, 44, 156, 83, 87, 118, 228, 47, 97, 149, 203, 174, 85, 17, 102, 89, 177, 138, 47, 238, 13, 148, 20, 194, 0, 60, 7, 59, 168, 68, 138, 8, 118, 156, 239, 206, 156, 137, 25, 124, 41, 6, 11, 39, 116, 181, 141, 231, 39, 17, 118, 219, 198, 3, 111, 24, 35, 68, 182, 161, 171, 34, 141, 143, 93, 239, 34, 133, 4, 53, 23, 49, 10, 31, 131, 184, 145, 132, 55, 96, 73, 78, 225, 58, 47, 167, 248, 192, 131, 50, 244, 87, 215, 115, 126, 45, 5, 176, 172, 20, 135, 160, 66, 162, 28, 20, 71, 33, 27, 190, 11, 171, 108, 48, 7, 164, 36, 36, 4, 72, 130, 68, 194, 16, 78, 9, 49, 25, 7, 196, 81, 156, 16, 242, 20, 52, 192, 108, 78, 74, 84, 163, 142, 73, 78, 57, 199, 35, 240, 106, 227, 148, 166, 63, 201, 89, 47, 38, 100, 220, 157, 147, 242, 134, 81, 202, 81, 140, 128, 128, 0, 14, 1, 0, 0, 3, 0, 0, 0, 1, 0, 47, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 48, 0, 0, 1, 2, 181, 3, 0, 0, 0, 3, 0, 0, 7, 140, 1, 3, 0, 3, 0, 0, 0, 1, 0, 5, 0, 0, 1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 0, 8, 1, 18, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 21, 0, 3, 0, 0, 0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 48, 0, 0, 1, 23, 0, 79, 0, 0, 0, 1, 0, 0, 6, 214, 1, 26, 0, 5, 0, 0, 0, 1, 0, 0, 7, 146, 1, 27, 0, 5, 0, 0, 0, 1, 0, 0, 7, 154, 1, 28, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 40, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 8, 18, 192, 0, 0, 0, 4, 0, 0, 18, 192, 0, 0, 0, 4, 0, 0
};


#endif




