/* Generated by GOB (v2.0.16)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 16

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gnome-pilot-conduit-config.h"

#include "gnome-pilot-conduit-config-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 34 "gnome-pilot-conduit-config.gob"

#include <config.h>

#line 30 "gnome-pilot-conduit-config.c"
/* self casting macros */
#define SELF(x) GNOME_PILOT_CONDUIT_CONFIG(x)
#define SELF_CONST(x) GNOME_PILOT_CONDUIT_CONFIG_CONST(x)
#define IS_SELF(x) GNOME_IS_PILOT_CONDUIT_CONFIG(x)
#define TYPE_SELF GNOME_TYPE_PILOT_CONDUIT_CONFIG
#define SELF_CLASS(x) GNOME_PILOT_CONDUIT_CONFIG_CLASS(x)

#define SELF_GET_CLASS(x) GNOME_PILOT_CONDUIT_CONFIG_GET_CLASS(x)

/* self typedefs */
typedef GnomePilotConduitConfig Self;
typedef GnomePilotConduitConfigClass SelfClass;

/* here are local prototypes */
#line 0 "gnome-pilot-conduit-config.gob"
static void gnome_pilot_conduit_config_init (GnomePilotConduitConfig * o) G_GNUC_UNUSED;
#line 47 "gnome-pilot-conduit-config.c"
#line 0 "gnome-pilot-conduit-config.gob"
static void gnome_pilot_conduit_config_class_init (GnomePilotConduitConfigClass * c) G_GNUC_UNUSED;
#line 50 "gnome-pilot-conduit-config.c"

/* pointer to the class of our parent */
static GtkObjectClass *parent_class = NULL;

/* Short form macros */
#define self_sync_type_int_to_str gnome_pilot_conduit_config_sync_type_int_to_str
#define self_sync_type_str_to_int gnome_pilot_conduit_config_sync_type_str_to_int
#define self_new gnome_pilot_conduit_config_new
#define self_destroy gnome_pilot_conduit_config_destroy
#define self_load_config gnome_pilot_conduit_config_load_config
#define self_save_config gnome_pilot_conduit_config_save_config
#define self_is_enabled gnome_pilot_conduit_config_is_enabled
#define self_enable gnome_pilot_conduit_config_enable
#define self_enable_with_first_sync gnome_pilot_conduit_config_enable_with_first_sync
#define self_remove_first_sync gnome_pilot_conduit_config_remove_first_sync
#define self_disable gnome_pilot_conduit_config_disable
GType
gnome_pilot_conduit_config_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GnomePilotConduitConfigClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_pilot_conduit_config_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnomePilotConduitConfig),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnome_pilot_conduit_config_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_OBJECT, "GnomePilotConduitConfig", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnomePilotConduitConfig *)g_object_new(gnome_pilot_conduit_config_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnomePilotConduitConfig * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnomePilotConduitConfig *
GET_NEW_VARG (const char *first, ...)
{
	GnomePilotConduitConfig *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnomePilotConduitConfig *)g_object_new_valist (gnome_pilot_conduit_config_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::finalize"
	GnomePilotConduitConfig *self G_GNUC_UNUSED = GNOME_PILOT_CONDUIT_CONFIG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
gnome_pilot_conduit_config_init (GnomePilotConduitConfig * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,GNOME_TYPE_PILOT_CONDUIT_CONFIG,GnomePilotConduitConfigPrivate);
}
#undef __GOB_FUNCTION__
static void 
gnome_pilot_conduit_config_class_init (GnomePilotConduitConfigClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GnomePilotConduitConfigPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 50 "gnome-pilot-conduit-config.gob"
const gchar * 
gnome_pilot_conduit_config_sync_type_int_to_str (GnomePilotConduitSyncType e)
{
#line 148 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::sync_type_int_to_str"
{
#line 52 "gnome-pilot-conduit-config.gob"
	
		switch(e) {
		case GnomePilotConduitSyncTypeCustom:
			return GnomePilotConduitSyncTypeCustomStr;
		case GnomePilotConduitSyncTypeSynchronize:
			return GnomePilotConduitSyncTypeSynchronizeStr;
		case GnomePilotConduitSyncTypeCopyFromPilot:
			return GnomePilotConduitSyncTypeCopyFromPilotStr;
		case GnomePilotConduitSyncTypeCopyToPilot:
			return GnomePilotConduitSyncTypeCopyToPilotStr;
		case GnomePilotConduitSyncTypeMergeFromPilot:
			return GnomePilotConduitSyncTypeMergeFromPilotStr;
		case GnomePilotConduitSyncTypeMergeToPilot:
			return GnomePilotConduitSyncTypeMergeToPilotStr;
		case GnomePilotConduitSyncTypeNotSet:
			return GnomePilotConduitSyncTypeNotSetStr;
		default: 
		  g_message ("sync_type_int_to_str: invalid sync_type %d",e);
		  return GnomePilotConduitSyncTypeNotSetStr;
		}
	}}
#line 173 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 74 "gnome-pilot-conduit-config.gob"
gint 
gnome_pilot_conduit_config_sync_type_str_to_int (gchar * s)
{
#line 180 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::sync_type_str_to_int"
{
#line 76 "gnome-pilot-conduit-config.gob"
	
		g_return_val_if_fail(s!=NULL,GnomePilotConduitSyncTypeNotSet);

		if (strcmp (s, GnomePilotConduitSyncTypeSynchronizeStr) == 0) {
			return GnomePilotConduitSyncTypeSynchronize;
		} else if (strcmp (s, GnomePilotConduitSyncTypeCopyToPilotStr) == 0) {
			return GnomePilotConduitSyncTypeCopyToPilot;
		} else if (strcmp (s, GnomePilotConduitSyncTypeCopyFromPilotStr) == 0) {
			return GnomePilotConduitSyncTypeCopyFromPilot;
		} else if (strcmp (s, GnomePilotConduitSyncTypeMergeToPilotStr) == 0) {
			return GnomePilotConduitSyncTypeMergeToPilot;
		} else if (strcmp (s, GnomePilotConduitSyncTypeMergeFromPilotStr) == 0) {
			return GnomePilotConduitSyncTypeMergeFromPilot;
		} else if (strcmp (s, GnomePilotConduitSyncTypeCustomStr) == 0) {
			return GnomePilotConduitSyncTypeCustom;
		} else if (strcmp (s, GnomePilotConduitSyncTypeNotSetStr) == 0) {
			return GnomePilotConduitSyncTypeNotSet;
		}
		return GnomePilotConduitSyncTypeNotSet;
	}}
#line 204 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 102 "gnome-pilot-conduit-config.gob"
GnomePilotConduitConfig * 
gnome_pilot_conduit_config_new (GnomePilotConduitManagement * gpcm, guint32 pilot_id)
{
#line 211 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::new"
{
#line 103 "gnome-pilot-conduit-config.gob"
	
		GtkObject *ret = NULL;
		GnomePilotConduitConfig *obj;

		ret = GTK_OBJECT(GET_NEW);
		obj = SELF(ret);
		obj->_priv->pilot_id = pilot_id;
		obj->_priv->gpcm = gpcm;

		return obj;
	}}
#line 226 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 116 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_destroy (GnomePilotConduitConfig * self)
{
#line 233 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::destroy"
#line 116 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 116 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 239 "gnome-pilot-conduit-config.c"
{
#line 117 "gnome-pilot-conduit-config.gob"
	
		gtk_object_destroy(GTK_OBJECT(self));
	}}
#line 245 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 126 "gnome-pilot-conduit-config.gob"
int 
gnome_pilot_conduit_config_load_config (GnomePilotConduitConfig * self)
{
#line 252 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::load_config"
#line 126 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 126 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (int )0);
#line 258 "gnome-pilot-conduit-config.c"
{
#line 127 "gnome-pilot-conduit-config.gob"
	
		char  *tmp;
		GKeyFile *kfile;

		if(self_is_enabled(self,NULL)==TRUE) {
			kfile = get_conduits_kfile (self->_priv->pilot_id);
			tmp = g_key_file_get_string (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm), "sync_type", NULL);
			if (tmp) {
				self->sync_type = self_sync_type_str_to_int(tmp);
			} else {
				g_warning("conduit has no sync_type, synchronization will skip this conduit");
				self->sync_type = GnomePilotConduitSyncTypeNotSet;
			}
			g_free(tmp);
			tmp = g_key_file_get_string (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm), "first_sync_type", NULL);
			if (tmp) {
				self->first_sync_type = self_sync_type_str_to_int(tmp);
			} else {
				self->first_sync_type = GnomePilotConduitSyncTypeNotSet;
			}
			g_free(tmp);
			self->first_slow = g_key_file_get_boolean (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm), "slow_sync", NULL);
			g_key_file_free (kfile);
		} else 
			return 0;
		return 1;
	}}
#line 288 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 155 "gnome-pilot-conduit-config.gob"
int 
gnome_pilot_conduit_config_save_config (GnomePilotConduitConfig * self)
{
#line 295 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::save_config"
#line 155 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 155 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (int )0);
#line 301 "gnome-pilot-conduit-config.c"
{
#line 156 "gnome-pilot-conduit-config.gob"
	
		GKeyFile *kfile;

		if(self_is_enabled(self,NULL)==TRUE) {
			kfile = get_conduits_kfile (self->_priv->pilot_id);
			g_key_file_set_string (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
						"sync_type",
						self_sync_type_int_to_str(self->sync_type));
			g_key_file_set_string (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
						"first_sync_type",
						self_sync_type_int_to_str(self->first_sync_type));
			if(self->first_sync_type == GnomePilotConduitSyncTypeSynchronize) 
			        g_key_file_set_boolean (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
							"slow_sync",self->first_slow);
			else
			        g_key_file_remove_key (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
							"slow_sync", NULL);
			save_conduits_kfile (kfile, self->_priv->pilot_id);
			g_key_file_free (kfile);
		} else 
			return 0;
		return 1;
	}}
#line 327 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 187 "gnome-pilot-conduit-config.gob"
gboolean 
gnome_pilot_conduit_config_is_enabled (GnomePilotConduitConfig * self, GnomePilotConduitSyncType * sync_type)
{
#line 334 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::is_enabled"
#line 187 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 187 "gnome-pilot-conduit-config.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self), (gboolean )0);
#line 340 "gnome-pilot-conduit-config.c"
{
#line 189 "gnome-pilot-conduit-config.gob"
	
		gsize num_conduits;
		int cnt;
		gchar **conduit_name;
		gboolean retval;
		GKeyFile *kfile;
		
		retval = FALSE;
		
		/* load the list */
		kfile = get_conduits_kfile (self->_priv->pilot_id);
		conduit_name = g_key_file_get_string_list (kfile, "General", "conduits", &num_conduits, NULL);
		
		/* g_message("number_of_conduits = %d",num_conduits); */
		
		/* loop, compare and free */
		for(cnt=0;cnt<num_conduits;cnt++) {
			/* g_message("g_str_equal(%s,%s)",
			   conduit_name[cnt] ,
			   gnome_pilot_conduit_management_get_id(self->_priv->gpcm)); */
			if(g_str_equal(conduit_name[cnt] ,gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				/* g_message("match on %s, it is enabled",conduit_name[cnt]); */
				if(sync_type) {
					gchar *tmpstr;
					tmpstr = g_key_file_get_string (kfile,
									gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
									"first_sync_type",
									NULL);
					if (tmpstr == NULL) {
						tmpstr = g_key_file_get_string (kfile,
										gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
										"sync_type",
										NULL);
					}
					/* g_message("%s says %s",newpfx,tmpstr); */
					(*sync_type) = self_sync_type_str_to_int(tmpstr);
					g_free(tmpstr);
				}
				retval = TRUE;
			} 
			g_free(conduit_name[cnt]);
		}
		g_free(conduit_name);
		g_key_file_free (kfile);
		return retval;
	}}
#line 389 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 238 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_enable (GnomePilotConduitConfig * self, GnomePilotConduitSyncType sync_type)
{
#line 396 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::enable"
#line 238 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 238 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 402 "gnome-pilot-conduit-config.c"
{
#line 240 "gnome-pilot-conduit-config.gob"
	
		char **conduit_name;
		char **conduit_name_copy;
		gsize num_conduits;
		int cnt;
		GKeyFile *kfile;
		
		kfile = get_conduits_kfile (self->_priv->pilot_id);
	
		/* enable conduit, if it wasn't, otherwise, just write
		   the sync type in case it was changed. */
		if(self_is_enabled(self,NULL)==FALSE) {

			/* load the list of conduits */
			conduit_name = g_key_file_get_string_list (kfile, "General", "conduits", &num_conduits, NULL);
			/* g_message("num_conduits = %d",num_conduits); */
	
			/* copy the list and attach new conduit */
			conduit_name_copy = g_new0(gchar*,num_conduits+2);
			for(cnt=0;cnt<num_conduits;cnt++) {
				/* g_message("duping %d %s",cnt,conduit_name[cnt]); */
				conduit_name_copy[cnt] = g_strdup(conduit_name[cnt]);
				g_free(conduit_name[cnt]);
			}
			g_free(conduit_name);
			/* g_message("adding %s as element %d",gnome_pilot_conduit_management_get_id(self->_priv->gpcm),num_conduits); */ 
			conduit_name_copy[num_conduits] = g_strdup(gnome_pilot_conduit_management_get_id(self->_priv->gpcm));
	
			/* write new list */
			/* g_message("writing new conduits list, size %d",num_conduits+1); */
			g_key_file_set_string_list (kfile, "General", "conduits", (const char**)conduit_name_copy, num_conduits+1);
	
			/* free the copy */
			/* g_message("freeing %d items",num_conduits+1); */
			for(cnt=0;cnt<num_conduits+1;cnt++) {
				/* g_message("should contain %s",conduit_name_copy[cnt]); */
				g_free(conduit_name_copy[cnt]);
			}
			g_free(conduit_name_copy);
	
		}

		/* make section for conduit */
		g_key_file_set_string (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
					"sync_type",
					self_sync_type_int_to_str(sync_type));

		save_conduits_kfile (kfile, self->_priv->pilot_id);
		g_key_file_free (kfile);
	}}
#line 455 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 293 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_enable_with_first_sync (GnomePilotConduitConfig * self, GnomePilotConduitSyncType sync_type, GnomePilotConduitSyncType first_sync_type, gboolean slow)
{
#line 462 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::enable_with_first_sync"
#line 293 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 293 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 468 "gnome-pilot-conduit-config.c"
{
#line 297 "gnome-pilot-conduit-config.gob"
	
		GKeyFile *kfile;

		self_enable(self,sync_type);

		/* add the first_sync info */
		kfile = get_conduits_kfile (self->_priv->pilot_id);

		g_key_file_set_string (kfile,
					gnome_pilot_conduit_management_get_id (self->_priv->gpcm),
					"first_sync_type",
					self_sync_type_int_to_str(first_sync_type));
		if(first_sync_type==GnomePilotConduitSyncTypeSynchronize) 
			g_key_file_set_boolean (kfile, gnome_pilot_conduit_management_get_id (self->_priv->gpcm),
						"slow_sync",slow);
		else
			g_key_file_remove_key (kfile, gnome_pilot_conduit_management_get_id (self->_priv->gpcm),
						"slow_sync", NULL);
		save_conduits_kfile (kfile, self->_priv->pilot_id);
		g_key_file_free (kfile);
	}}
#line 492 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 320 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_remove_first_sync (GnomePilotConduitConfig * self)
{
#line 499 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::remove_first_sync"
#line 320 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 320 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 505 "gnome-pilot-conduit-config.c"
{
#line 321 "gnome-pilot-conduit-config.gob"
	
		GKeyFile *kfile;
		
		kfile = get_conduits_kfile (self->_priv->pilot_id);

		if (self_is_enabled(self,NULL)) {
			/* add the first_sync info */
			if (g_key_file_has_group (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				g_key_file_remove_key (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
							"first_sync_type", NULL);
				g_key_file_remove_key (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm),
							"slow_sync", NULL);
			}
		}

		save_conduits_kfile (kfile, self->_priv->pilot_id);
		g_key_file_free (kfile);
	}}
#line 526 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 341 "gnome-pilot-conduit-config.gob"
void 
gnome_pilot_conduit_config_disable (GnomePilotConduitConfig * self)
{
#line 533 "gnome-pilot-conduit-config.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Config::disable"
#line 341 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (self != NULL);
#line 341 "gnome-pilot-conduit-config.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_CONFIG (self));
#line 539 "gnome-pilot-conduit-config.c"
{
#line 342 "gnome-pilot-conduit-config.gob"
	
		gchar **conduit_name;
		char **conduit_name_copy;
		gsize num_conduits;
		int num_conduits_copy,cnt;
		GKeyFile *kfile;
		
		kfile = get_conduits_kfile (self->_priv->pilot_id);

		if(self_is_enabled(self,NULL)==FALSE) return;

		/* load the list of conduits */
		conduit_name = g_key_file_get_string_list (kfile, "General", "conduits", &num_conduits, NULL);
		
		/* copy the list, excluding the one to delete, num_conduits is > 0 since is_enables succeeded */
		conduit_name_copy = g_new0(char*,num_conduits);
		num_conduits_copy = 0;
		for(cnt=0;cnt<num_conduits;cnt++) {
			if (g_ascii_strcasecmp (conduit_name[cnt], gnome_pilot_conduit_management_get_id(self->_priv->gpcm))) {
				/* g_message("keeping %d:%s",cnt,conduit_name[cnt]); */
				conduit_name_copy[num_conduits_copy]=g_strdup(conduit_name[cnt]);
				num_conduits_copy++;
			} else {
				/* g_message("skipping %d:%s",cnt,conduit_name[cnt]); */
			}
			g_free(conduit_name[cnt]);
		}
		g_free(conduit_name);
		
		/* save new list */
		/* g_message("num_conduits_copy = %d",num_conduits_copy); */
		if ( num_conduits_copy > 0 )
			g_key_file_set_string_list (kfile, "General", "conduits", (const char**)conduit_name_copy, num_conduits_copy);
		else
			g_key_file_remove_key (kfile, "General", "conduits", NULL);
		
		/* free copy */
		for(cnt=0;cnt<num_conduits_copy;cnt++) g_free(conduit_name_copy[cnt]);
		g_free(conduit_name_copy);
		
		/* nuke the conduits config section */
		g_key_file_remove_group (kfile, gnome_pilot_conduit_management_get_id(self->_priv->gpcm), NULL);

		save_conduits_kfile (kfile, self->_priv->pilot_id);
		g_key_file_free (kfile);	
	}}
#line 588 "gnome-pilot-conduit-config.c"
#undef __GOB_FUNCTION__

#line 391 "gnome-pilot-conduit-config.gob"



#line 595 "gnome-pilot-conduit-config.c"
