/* glchess.c generated by valac 0.13.1, the Vala compiler
 * generated from glchess.vala, do not modify */

/* Workaround for https://bugzilla.gnome.org/show_bug.cgi?id=647122 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define __g_list_free__ai_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ai_profile_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
typedef struct _PGNGamePrivate PGNGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define _ai_profile_unref0(var) ((var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL)))
typedef struct _AIProfilePrivate AIProfilePrivate;

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))
typedef struct _ParamSpecApplication ParamSpecApplication;

#define TYPE_GL_CHESS (gl_chess_get_type ())
#define GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GL_CHESS, GlChess))
#define GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GL_CHESS, GlChessClass))
#define IS_GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GL_CHESS))
#define IS_GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GL_CHESS))
#define GL_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GL_CHESS, GlChessClass))

typedef struct _GlChess GlChess;
typedef struct _GlChessClass GlChessClass;
typedef struct _GlChessPrivate GlChessPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))
typedef struct _ParamSpecGlChess ParamSpecGlChess;

struct _Application {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GTypeClass parent_class;
	void (*finalize) (Application *self);
};

struct _ApplicationPrivate {
	GSettings* settings;
	History* history;
	GtkBuilder* builder;
	GtkBuilder* preferences_builder;
	GtkWindow* window;
	GtkWidget* save_menu;
	GtkWidget* save_as_menu;
	GtkMenuItem* fullscreen_menu;
	GtkInfoBar* info_bar;
	GtkLabel* info_title_label;
	GtkLabel* info_label;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkWidget* undo_menu;
	GtkWidget* undo_button;
	GtkWidget* resign_menu;
	GtkWidget* resign_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkDialog* preferences_dialog;
	GtkComboBox* duration_combo;
	GtkAdjustment* duration_adjustment;
	GtkContainer* custom_duration_box;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gboolean in_history;
	GFile* game_file;
	gboolean game_needs_saving;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH
} ChessRule;

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _AIProfile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AIProfilePrivate * priv;
	gchar* name;
	gchar* protocol;
	gchar* binary;
	gchar* path;
	gchar* args;
	gchar** easy_options;
	gint easy_options_length1;
	gchar** normal_options;
	gint normal_options_length1;
	gchar** hard_options;
	gint hard_options_length1;
};

struct _AIProfileClass {
	GTypeClass parent_class;
	void (*finalize) (AIProfile *self);
};

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
	gchar* binary;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _ParamSpecApplication {
	GParamSpec parent_instance;
};

struct _GlChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GlChessPrivate * priv;
};

struct _GlChessClass {
	GTypeClass parent_class;
	void (*finalize) (GlChess *self);
};

struct _ParamSpecGlChess {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
extern gchar* pgn_game_RESULT_WHITE;
extern gchar* pgn_game_RESULT_BLACK;
extern gchar* pgn_game_RESULT_DRAW;
extern gchar* pgn_game_TERMINATE_ABANDONED;
extern gchar* pgn_game_TERMINATE_DEATH;
static gpointer gl_chess_parent_class = NULL;
static gboolean gl_chess_show_version;
static gboolean gl_chess_show_version = FALSE;

void gtk_file_filter_set_name (GtkFileFilter* filter, const gchar* name);
gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
gpointer ai_profile_ref (gpointer instance);
void ai_profile_unref (gpointer instance);
GParamSpec* param_spec_ai_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ai_profile (GValue* value, gpointer v_object);
void value_take_ai_profile (GValue* value, gpointer v_object);
gpointer value_get_ai_profile (const GValue* value);
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static void _ai_profile_unref0_ (gpointer var);
static void _g_list_free__ai_profile_unref0_ (GList* self);
Application* application_new (void);
Application* application_construct (GType object_type);
History* history_new (GFile* data_dir);
History* history_construct (GType object_type, GFile* data_dir);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static void application_scene_changed_cb (Application* self, ChessScene* scene);
static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key);
static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void application_quit (Application* self);
static gboolean application_save_duration_cb (Application* self);
static void application_autosave (Application* self);
void history_remove (History* self, GFile* file);
void history_update (History* self, GFile* file, const gchar* fen, const gchar* _result_);
const gchar* pgn_game_get_result (PGNGame* self);
GFile* history_add (History* self, const gchar* date, const gchar* _result_, GError** error);
const gchar* pgn_game_get_date (PGNGame* self);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
GType chess_view3_d_get_type (void) G_GNUC_CONST;
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
GType chess_view2_d_get_type (void) G_GNUC_CONST;
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void application_update_history_panel (Application* self);
gint chess_scene_get_move_number (ChessScene* self);
guint chess_game_get_n_moves (ChessGame* self);
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move);
static void application_start_game (Application* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
gboolean pgn_game_get_set_up (PGNGame* self);
const gchar* pgn_game_get_fen (PGNGame* self);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
const gchar* pgn_game_get_time_control (PGNGame* self);
ChessClock* chess_clock_new (guint white_duration, guint black_duration, guint white_used, guint black_used);
ChessClock* chess_clock_construct (GType object_type, guint white_duration, guint black_duration, guint white_used, guint black_used);
GType chess_clock_get_type (void) G_GNUC_CONST;
void chess_game_set_clock (ChessGame* self, ChessClock* value);
static void application_game_start_cb (Application* self, ChessGame* game);
static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self);
static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player);
static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move);
static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void application_game_undo_cb (Application* self, ChessGame* game);
static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void application_game_end_cb (Application* self, ChessGame* game);
static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
ChessClock* chess_game_get_clock (ChessGame* self);
static void application_game_clock_tick_cb (Application* self, ChessClock* clock);
static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void application_update_control_buttons (Application* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty);
static void application_engine_ready_cb (Application* self, ChessEngine* engine);
static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move);
static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
gboolean chess_engine_start (ChessEngine* self);
void chess_game_start (ChessGame* self);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
ChessEngineCECP* chess_engine_cecp_new (gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (gchar** options, int options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, gchar** options, int options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
void application_start (Application* self, GFile* game, GError** error);
GList* load_ai_profiles (const gchar* filename);
GList* history_get_unfinished (History* self);
static void application_load_game (Application* self, GFile* file, gboolean from_history, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void application_start_new_game (Application* self);
void application_show (Application* self);
gboolean chess_engine_get_ready (ChessEngine* self);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
void chess_engine_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
GType piece_type_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_lan (ChessMove* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
void pgn_game_set_result (PGNGame* self, const gchar* value);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
gboolean G_MODULE_EXPORT glchess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
gboolean G_MODULE_EXPORT glchess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self);
gboolean G_MODULE_EXPORT glchess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self);
void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
gboolean chess_player_resign (ChessPlayer* self);
void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self);
gboolean chess_player_claim_draw (ChessPlayer* self);
void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self);
void chess_player_undo (ChessPlayer* self);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
void G_MODULE_EXPORT quit_cb (GtkWidget* widget, Application* self);
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
guint chess_clock_get_white_duration (ChessClock* self);
guint chess_clock_get_white_used_in_seconds (ChessClock* self);
guint chess_clock_get_black_duration (ChessClock* self);
guint chess_clock_get_black_used_in_seconds (ChessClock* self);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT preferences_cb (GtkWidget* widget, Application* self);
static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void application_set_duration (Application* self, gint duration, gboolean simplify);
static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self);
static gint application_get_duration (Application* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self);
static void application_save_duration (Application* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self);
static gboolean _application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self);
void G_MODULE_EXPORT promotion_type_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT help_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT about_cb (GtkWidget* widget, Application* self);
static void application_about_response_cb (Application* self, gint response_id);
static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void G_MODULE_EXPORT save_game_as_cb (GtkWidget* widget, Application* self);
static void application_save_game (Application* self);
void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self);
static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void application_save_file_cb (Application* self);
static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_save_cb (Application* self, gint response_id);
static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self);
static void application_open_file_cb (Application* self);
static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_open_cb (Application* self, gint response_id);
static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
void pgn_game_set_date (PGNGame* self, const gchar* value);
void pgn_game_set_time (PGNGame* self, const gchar* value);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
static void application_finalize (Application* obj);
gpointer gl_chess_ref (gpointer instance);
void gl_chess_unref (gpointer instance);
GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gl_chess (GValue* value, gpointer v_object);
void value_take_gl_chess (GValue* value, gpointer v_object);
gpointer value_get_gl_chess (const GValue* value);
GType gl_chess_get_type (void) G_GNUC_CONST;
enum  {
	GL_CHESS_DUMMY_PROPERTY
};
gint gl_chess_main (gchar** args, int args_length1);
GlChess* gl_chess_new (void);
GlChess* gl_chess_construct (GType object_type);
static void gl_chess_finalize (GlChess* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* APPLICATION_authors[1] = {"Robert Ancell <robert.ancell@gmail.com>"};
static const gchar* APPLICATION_artists[3] = {"John-Paul Gignac (3D Models)", "Max Froumentin (2D Models)", "Hylke Bons <h.bons@student.rug.nl> (icon)"};
const GOptionEntry GL_CHESS_options[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &gl_chess_show_version, "Show release version", NULL}, {NULL}};

static void _ai_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL));
}


static void _g_list_free__ai_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ai_profile_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
	application_scene_changed_cb (self, _sender);
}


static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	application_settings_changed_cb (self, _sender, key);
}


Application* application_construct (GType object_type) {
	Application* self = NULL;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* data_dir;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	History* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkWindow* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkWidget* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkWidget* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkMenuItem* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkWidget* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkWidget* _tmp23_;
	GObject* _tmp24_ = NULL;
	GtkWidget* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkWidget* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkWidget* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkWidget* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkWidget* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkComboBox* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkWidget* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkWidget* _tmp41_;
	GObject* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkVBox* _tmp45_;
	GtkVBox* view_box;
	GObject* _tmp46_ = NULL;
	GtkContainer* _tmp47_;
	GtkInfoBar* _tmp48_ = NULL;
	GtkWidget* _tmp49_ = NULL;
	GtkContainer* _tmp50_;
	GtkContainer* content_area;
	GtkVBox* _tmp51_ = NULL;
	GtkVBox* vbox;
	GtkLabel* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	ChessScene* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Application*) g_type_create_instance (object_type);
	_tmp0_ = g_settings_new ("org.gnome.glchess.Settings");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "glchess", NULL, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	data_dir = _tmp5_;
	_tmp6_ = g_file_get_path (data_dir);
	_tmp7_ = _tmp6_;
	g_mkdir_with_parents (_tmp7_, 0755);
	_g_free0 (_tmp7_);
	_tmp8_ = history_new (data_dir);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp8_;
	_tmp9_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp9_;
	{
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp10_ = g_build_filename (PKGDATADIR, "glchess.ui", NULL, NULL);
		_tmp11_ = _tmp10_;
		gtk_builder_add_from_file (self->priv->builder, _tmp11_, &_inner_error_);
		_g_free0 (_tmp11_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("glchess.vala:72: Could not load UI: %s", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp12_ = gtk_builder_get_object (self->priv->builder, "glchess_app");
	_tmp13_ = _g_object_ref0 (GTK_WINDOW (_tmp12_));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp13_;
	_tmp14_ = gtk_builder_get_object (self->priv->builder, "menu_save_item");
	_tmp15_ = _g_object_ref0 (GTK_WIDGET (_tmp14_));
	_g_object_unref0 (self->priv->save_menu);
	self->priv->save_menu = _tmp15_;
	_tmp16_ = gtk_builder_get_object (self->priv->builder, "menu_save_as_item");
	_tmp17_ = _g_object_ref0 (GTK_WIDGET (_tmp16_));
	_g_object_unref0 (self->priv->save_as_menu);
	self->priv->save_as_menu = _tmp17_;
	_tmp18_ = gtk_builder_get_object (self->priv->builder, "fullscreen_item");
	_tmp19_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp18_));
	_g_object_unref0 (self->priv->fullscreen_menu);
	self->priv->fullscreen_menu = _tmp19_;
	_tmp20_ = gtk_builder_get_object (self->priv->builder, "undo_move_item");
	_tmp21_ = _g_object_ref0 (GTK_WIDGET (_tmp20_));
	_g_object_unref0 (self->priv->undo_menu);
	self->priv->undo_menu = _tmp21_;
	_tmp22_ = gtk_builder_get_object (self->priv->builder, "undo_move_button");
	_tmp23_ = _g_object_ref0 (GTK_WIDGET (_tmp22_));
	_g_object_unref0 (self->priv->undo_button);
	self->priv->undo_button = _tmp23_;
	_tmp24_ = gtk_builder_get_object (self->priv->builder, "resign_item");
	_tmp25_ = _g_object_ref0 (GTK_WIDGET (_tmp24_));
	_g_object_unref0 (self->priv->resign_menu);
	self->priv->resign_menu = _tmp25_;
	_tmp26_ = gtk_builder_get_object (self->priv->builder, "resign_button");
	_tmp27_ = _g_object_ref0 (GTK_WIDGET (_tmp26_));
	_g_object_unref0 (self->priv->resign_button);
	self->priv->resign_button = _tmp27_;
	_tmp28_ = gtk_builder_get_object (self->priv->builder, "first_move_button");
	_tmp29_ = _g_object_ref0 (GTK_WIDGET (_tmp28_));
	_g_object_unref0 (self->priv->first_move_button);
	self->priv->first_move_button = _tmp29_;
	_tmp30_ = gtk_builder_get_object (self->priv->builder, "prev_move_button");
	_tmp31_ = _g_object_ref0 (GTK_WIDGET (_tmp30_));
	_g_object_unref0 (self->priv->prev_move_button);
	self->priv->prev_move_button = _tmp31_;
	_tmp32_ = gtk_builder_get_object (self->priv->builder, "next_move_button");
	_tmp33_ = _g_object_ref0 (GTK_WIDGET (_tmp32_));
	_g_object_unref0 (self->priv->next_move_button);
	self->priv->next_move_button = _tmp33_;
	_tmp34_ = gtk_builder_get_object (self->priv->builder, "last_move_button");
	_tmp35_ = _g_object_ref0 (GTK_WIDGET (_tmp34_));
	_g_object_unref0 (self->priv->last_move_button);
	self->priv->last_move_button = _tmp35_;
	_tmp36_ = gtk_builder_get_object (self->priv->builder, "history_combo");
	_tmp37_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp36_));
	_g_object_unref0 (self->priv->history_combo);
	self->priv->history_combo = _tmp37_;
	_tmp38_ = gtk_builder_get_object (self->priv->builder, "white_time_label");
	_tmp39_ = _g_object_ref0 (GTK_WIDGET (_tmp38_));
	_g_object_unref0 (self->priv->white_time_label);
	self->priv->white_time_label = _tmp39_;
	_tmp40_ = gtk_builder_get_object (self->priv->builder, "black_time_label");
	_tmp41_ = _g_object_ref0 (GTK_WIDGET (_tmp40_));
	_g_object_unref0 (self->priv->black_time_label);
	self->priv->black_time_label = _tmp41_;
	_tmp42_ = gtk_builder_get_object (self->priv->builder, "toolbar");
	g_settings_bind (self->priv->settings, "show-toolbar", _tmp42_, "visible", G_SETTINGS_BIND_DEFAULT);
	_tmp43_ = gtk_builder_get_object (self->priv->builder, "navigation_box");
	g_settings_bind (self->priv->settings, "show-history", _tmp43_, "visible", G_SETTINGS_BIND_DEFAULT);
	_tmp44_ = gtk_builder_get_object (self->priv->builder, "view_box");
	_tmp45_ = _g_object_ref0 (GTK_VBOX (_tmp44_));
	view_box = _tmp45_;
	_tmp46_ = gtk_builder_get_object (self->priv->builder, "view_container");
	_tmp47_ = _g_object_ref0 (GTK_CONTAINER (_tmp46_));
	_g_object_unref0 (self->priv->view_container);
	self->priv->view_container = _tmp47_;
	gtk_builder_connect_signals (self->priv->builder, self);
	_tmp48_ = (GtkInfoBar*) gtk_info_bar_new ();
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = g_object_ref_sink (_tmp48_);
	_tmp49_ = gtk_info_bar_get_content_area (self->priv->info_bar);
	_tmp50_ = _g_object_ref0 (GTK_CONTAINER (_tmp49_));
	content_area = _tmp50_;
	gtk_box_pack_start ((GtkBox*) view_box, (GtkWidget*) self->priv->info_bar, FALSE, TRUE, (guint) 0);
	_tmp51_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp51_);
	gtk_widget_show ((GtkWidget*) vbox);
	gtk_container_add (content_area, (GtkWidget*) vbox);
	_tmp52_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->info_title_label);
	self->priv->info_title_label = g_object_ref_sink (_tmp52_);
	gtk_widget_show ((GtkWidget*) self->priv->info_title_label);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->info_title_label, FALSE, TRUE, (guint) 0);
	_tmp53_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->info_label);
	self->priv->info_label = g_object_ref_sink (_tmp53_);
	gtk_widget_show ((GtkWidget*) self->priv->info_label);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->info_label, TRUE, TRUE, (guint) 0);
	_tmp54_ = chess_scene_new ();
	_g_object_unref0 (self->priv->scene);
	self->priv->scene = _tmp54_;
	g_signal_connect (self->priv->scene, "changed", (GCallback) _application_scene_changed_cb_chess_scene_changed, self);
	g_settings_bind (self->priv->settings, "show-move-hints", self->priv->scene, "show-move-hints", G_SETTINGS_BIND_GET);
	g_settings_bind (self->priv->settings, "show-numbering", self->priv->scene, "show-numbering", G_SETTINGS_BIND_GET);
	g_settings_bind (self->priv->settings, "piece-theme", self->priv->scene, "theme-name", G_SETTINGS_BIND_GET);
	g_settings_bind (self->priv->settings, "show-3d-smooth", self->priv->scene, "show-3d-smooth", G_SETTINGS_BIND_GET);
	g_settings_bind (self->priv->settings, "move-format", self->priv->scene, "move-format", G_SETTINGS_BIND_GET);
	g_settings_bind (self->priv->settings, "board-side", self->priv->scene, "board-side", G_SETTINGS_BIND_GET);
	g_signal_connect (self->priv->settings, "changed", (GCallback) _application_settings_changed_cb_g_settings_changed, self);
	application_settings_changed_cb (self, self->priv->settings, "show-3d");
	_g_object_unref0 (vbox);
	_g_object_unref0 (content_area);
	_g_object_unref0 (view_box);
	_g_object_unref0 (data_dir);
	return self;
}


Application* application_new (void) {
	return application_construct (TYPE_APPLICATION);
}


void application_quit (Application* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->save_duration_timeout != ((guint) 0)) {
		application_save_duration_cb (self);
	}
	application_autosave (self);
	g_settings_sync ();
	gtk_main_quit ();
}


static void application_autosave (Application* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->in_history) {
		return;
	}
	if (!self->priv->game_needs_saving) {
		if (self->priv->game_file != NULL) {
			history_remove (self->priv->history, self->priv->game_file);
		}
		return;
	}
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		if (self->priv->game_file != NULL) {
			const gchar* _tmp0_ = NULL;
			_tmp0_ = pgn_game_get_result (self->priv->pgn_game);
			history_update (self->priv->history, self->priv->game_file, "", _tmp0_);
		} else {
			const gchar* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			GFile* _tmp4_;
			_tmp1_ = pgn_game_get_date (self->priv->pgn_game);
			_tmp2_ = pgn_game_get_result (self->priv->pgn_game);
			_tmp3_ = history_add (self->priv->history, _tmp1_, _tmp2_, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp4_;
		}
		_tmp5_ = g_file_get_path (self->priv->game_file);
		_tmp6_ = _tmp5_;
		g_debug ("glchess.vala:151: Writing current game to %s", _tmp6_);
		_g_free0 (_tmp6_);
		pgn_game_write (self->priv->pgn_game, self->priv->game_file, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("glchess.vala:156: Failed to autosave: %s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "show-3d") == 0) {
		gboolean _tmp0_;
		if (self->priv->view != NULL) {
			gtk_container_remove (self->priv->view_container, (GtkWidget*) self->priv->view);
			gtk_widget_destroy ((GtkWidget*) self->priv->view);
		}
		_tmp0_ = g_settings_get_boolean (settings, "show-3d");
		if (_tmp0_) {
			ChessView3D* _tmp1_ = NULL;
			_tmp1_ = chess_view3_d_new ();
			_g_object_unref0 (self->priv->view);
			self->priv->view = (ChessView*) g_object_ref_sink (_tmp1_);
		} else {
			ChessView2D* _tmp2_ = NULL;
			_tmp2_ = chess_view2_d_new ();
			_g_object_unref0 (self->priv->view);
			self->priv->view = (ChessView*) g_object_ref_sink (_tmp2_);
		}
		gtk_widget_set_size_request ((GtkWidget*) self->priv->view, 300, 300);
		chess_view_set_scene (self->priv->view, self->priv->scene);
		gtk_container_add (self->priv->view_container, (GtkWidget*) self->priv->view);
		gtk_widget_show ((GtkWidget*) self->priv->view);
	}
}


static gpointer _chess_state_ref0 (gpointer self) {
	return self ? chess_state_ref (self) : NULL;
}


static void application_update_history_panel (Application* self) {
	gint _tmp0_;
	gint move_number;
	guint _tmp1_;
	gint n_moves;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint i;
	g_return_if_fail (self != NULL);
	if (self->priv->game == NULL) {
		return;
	}
	_tmp0_ = chess_scene_get_move_number (self->priv->scene);
	move_number = _tmp0_;
	_tmp1_ = chess_game_get_n_moves (self->priv->game);
	n_moves = (gint) _tmp1_;
	if (move_number < 0) {
		move_number = move_number + (1 + n_moves);
	}
	if (n_moves > 0) {
		_tmp2_ = move_number != 0;
	} else {
		_tmp2_ = FALSE;
	}
	gtk_widget_set_sensitive (self->priv->first_move_button, _tmp2_);
	gtk_widget_set_sensitive (self->priv->prev_move_button, move_number > 0);
	gtk_widget_set_sensitive (self->priv->next_move_button, move_number < n_moves);
	if (n_moves > 0) {
		_tmp3_ = move_number != n_moves;
	} else {
		_tmp3_ = FALSE;
	}
	gtk_widget_set_sensitive (self->priv->last_move_button, _tmp3_);
	i = n_moves;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = self->priv->game->move_stack;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp4_;
			ChessState* state = NULL;
			_tmp4_ = _chess_state_ref0 ((ChessState*) state_it->data);
			state = _tmp4_;
			{
				if (state->last_move != NULL) {
					GtkTreeIter iter = {0};
					GtkTreeModel* _tmp5_ = NULL;
					GtkTreeIter _tmp6_ = {0};
					gboolean _tmp7_;
					_tmp5_ = gtk_combo_box_get_model (self->priv->history_combo);
					_tmp7_ = gtk_tree_model_iter_nth_child (_tmp5_, &_tmp6_, NULL, i);
					iter = _tmp6_;
					if (_tmp7_) {
						application_set_move_text (self, &iter, state->last_move);
					}
				}
				i--;
				_chess_state_unref0 (state);
			}
		}
	}
	gtk_combo_box_set_active (self->priv->history_combo, move_number);
}


static void application_scene_changed_cb (Application* self, ChessScene* scene) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	application_update_history_panel (self);
}


static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self) {
	application_game_start_cb (self, _sender);
}


static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
	application_game_turn_cb (self, _sender, player);
}


static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	application_game_move_cb (self, _sender, move);
}


static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	application_game_undo_cb (self, _sender);
}


static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
	application_game_end_cb (self, _sender);
}


static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
	application_game_clock_tick_cb (self, _sender);
}


static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
	application_engine_ready_cb (self, _sender);
}


static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
	application_engine_move_cb (self, _sender, move);
}


static void application_start_game (Application* self) {
	GtkTreeModel* _tmp9_ = NULL;
	GtkListStore* _tmp10_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp11_ = {0};
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* fen;
	guint _tmp14_;
	gchar** _tmp15_ = NULL;
	gchar** moves;
	gint moves_length1;
	gint _moves_size_;
	gint i;
	gboolean _tmp20_;
	ChessGame* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	ChessClock* _tmp33_ = NULL;
	gconstpointer _tmp35_ = NULL;
	gchar* _tmp36_;
	gchar* white_engine;
	gconstpointer _tmp37_ = NULL;
	gchar* _tmp38_;
	gchar* white_level;
	gconstpointer _tmp40_ = NULL;
	gchar* _tmp41_;
	gchar* black_engine;
	gconstpointer _tmp42_ = NULL;
	gchar* _tmp43_;
	gchar* black_level;
	g_return_if_fail (self != NULL);
	if (self->priv->in_history) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Chess");
		gtk_window_set_title (self->priv->window, _tmp0_);
	} else {
		gchar* _tmp1_ = NULL;
		gchar* path;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp1_ = g_file_get_path (self->priv->game_file);
		path = _tmp1_;
		_tmp2_ = _ ("%1$s (%2$s) - Chess");
		_tmp3_ = g_path_get_basename (path);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_path_get_dirname (path);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf (_tmp2_, _tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		gtk_window_set_title (self->priv->window, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (path);
	}
	_tmp9_ = gtk_combo_box_get_model (self->priv->history_combo);
	_tmp10_ = _g_object_ref0 (GTK_LIST_STORE (_tmp9_));
	model = _tmp10_;
	gtk_list_store_clear (model);
	gtk_list_store_append (model, &_tmp11_);
	iter = _tmp11_;
	_tmp12_ = _ ("Game Start");
	gtk_list_store_set (model, &iter, 0, _tmp12_, 1, 0, -1, -1);
	gtk_combo_box_set_active_iter (self->priv->history_combo, &iter);
	_tmp13_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp13_;
	_tmp14_ = g_list_length (self->priv->pgn_game->moves);
	_tmp15_ = g_new0 (gchar*, _tmp14_ + 1);
	moves = _tmp15_;
	moves_length1 = _tmp14_;
	_moves_size_ = moves_length1;
	i = 0;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = self->priv->pgn_game->moves;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp16_;
			gchar* move = NULL;
			_tmp16_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp16_;
			{
				gint _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = i;
				i = _tmp17_ + 1;
				_tmp18_ = g_strdup (move);
				_tmp19_ = _tmp18_;
				_g_free0 (moves[_tmp17_]);
				moves[_tmp17_] = _tmp19_;
				_g_free0 (move);
			}
		}
	}
	_tmp20_ = pgn_game_get_set_up (self->priv->pgn_game);
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		_tmp21_ = pgn_game_get_fen (self->priv->pgn_game);
		if (_tmp21_ != NULL) {
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			_tmp22_ = pgn_game_get_fen (self->priv->pgn_game);
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (fen);
			fen = _tmp23_;
		} else {
			g_warning ("glchess.vala:252: Chess game has SetUp tag but no FEN tag");
		}
	}
	_tmp24_ = chess_game_new (fen, moves, moves_length1);
	_chess_game_unref0 (self->priv->game);
	self->priv->game = _tmp24_;
	_tmp25_ = pgn_game_get_time_control (self->priv->pgn_game);
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_ = NULL;
		gchar** _tmp27_;
		gchar** _tmp28_ = NULL;
		gchar** controls;
		gint controls_length1;
		gint _controls_size_;
		_tmp26_ = pgn_game_get_time_control (self->priv->pgn_game);
		_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, ":", 0);
		controls = _tmp28_;
		controls_length1 = _vala_array_length (_tmp27_);
		_controls_size_ = controls_length1;
		{
			gchar** control_collection = NULL;
			gint control_collection_length1 = 0;
			gint _control_collection_size_ = 0;
			gint control_it;
			control_collection = controls;
			control_collection_length1 = controls_length1;
			for (control_it = 0; control_it < controls_length1; control_it = control_it + 1) {
				gchar* _tmp29_;
				gchar* control = NULL;
				_tmp29_ = g_strdup (control_collection[control_it]);
				control = _tmp29_;
				{
					gint _tmp30_;
					gint duration;
					_tmp30_ = atoi (control);
					duration = _tmp30_;
					if (duration > 0) {
						ChessClock* _tmp31_ = NULL;
						ChessClock* _tmp32_;
						_tmp31_ = chess_clock_new ((guint) duration, (guint) duration, (guint) 0, (guint) 0);
						_tmp32_ = _tmp31_;
						chess_game_set_clock (self->priv->game, _tmp32_);
						_g_object_unref0 (_tmp32_);
					}
					_g_free0 (control);
				}
			}
		}
		controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) g_free), NULL);
	}
	g_signal_connect (self->priv->game, "started", (GCallback) _application_game_start_cb_chess_game_started, self);
	g_signal_connect (self->priv->game, "turn-started", (GCallback) _application_game_turn_cb_chess_game_turn_started, self);
	g_signal_connect (self->priv->game, "moved", (GCallback) _application_game_move_cb_chess_game_moved, self);
	g_signal_connect (self->priv->game, "undo", (GCallback) _application_game_undo_cb_chess_game_undo, self);
	g_signal_connect (self->priv->game, "ended", (GCallback) _application_game_end_cb_chess_game_ended, self);
	_tmp33_ = chess_game_get_clock (self->priv->game);
	if (_tmp33_ != NULL) {
		ChessClock* _tmp34_ = NULL;
		_tmp34_ = chess_game_get_clock (self->priv->game);
		g_signal_connect (_tmp34_, "tick", (GCallback) _application_game_clock_tick_cb_chess_clock_tick, self);
	}
	chess_scene_set_game (self->priv->scene, self->priv->game);
	gtk_widget_hide ((GtkWidget*) self->priv->info_bar);
	gtk_widget_set_sensitive (self->priv->save_menu, FALSE);
	gtk_widget_set_sensitive (self->priv->save_as_menu, FALSE);
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_tmp35_ = g_hash_table_lookup (self->priv->pgn_game->tags, "WhiteAI");
	_tmp36_ = g_strdup ((const gchar*) _tmp35_);
	white_engine = _tmp36_;
	_tmp37_ = g_hash_table_lookup (self->priv->pgn_game->tags, "WhiteLevel");
	_tmp38_ = g_strdup ((const gchar*) _tmp37_);
	white_level = _tmp38_;
	if (white_level == NULL) {
		gchar* _tmp39_;
		_tmp39_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp39_;
	}
	_tmp40_ = g_hash_table_lookup (self->priv->pgn_game->tags, "BlackAI");
	_tmp41_ = g_strdup ((const gchar*) _tmp40_);
	black_engine = _tmp41_;
	_tmp42_ = g_hash_table_lookup (self->priv->pgn_game->tags, "BlackLevel");
	_tmp43_ = g_strdup ((const gchar*) _tmp42_);
	black_level = _tmp43_;
	if (black_level == NULL) {
		gchar* _tmp44_;
		_tmp44_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp44_;
	}
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_g_object_unref0 (self->priv->opponent_engine);
	self->priv->opponent_engine = NULL;
	if (white_engine != NULL) {
		ChessPlayer* _tmp45_ = NULL;
		ChessPlayer* _tmp46_;
		ChessPlayer* _tmp47_ = NULL;
		ChessPlayer* _tmp48_;
		ChessEngine* _tmp49_ = NULL;
		_tmp45_ = chess_game_get_white (self->priv->game);
		_tmp46_ = _g_object_ref0 (_tmp45_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp46_;
		_tmp47_ = chess_game_get_black (self->priv->game);
		_tmp48_ = _g_object_ref0 (_tmp47_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp48_;
		_tmp49_ = application_get_engine (self, white_engine, white_level);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp49_;
	} else {
		if (black_engine != NULL) {
			ChessPlayer* _tmp50_ = NULL;
			ChessPlayer* _tmp51_;
			ChessPlayer* _tmp52_ = NULL;
			ChessPlayer* _tmp53_;
			ChessEngine* _tmp54_ = NULL;
			_tmp50_ = chess_game_get_black (self->priv->game);
			_tmp51_ = _g_object_ref0 (_tmp50_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp51_;
			_tmp52_ = chess_game_get_white (self->priv->game);
			_tmp53_ = _g_object_ref0 (_tmp52_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp53_;
			_tmp54_ = application_get_engine (self, black_engine, black_level);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp54_;
		}
	}
	if (self->priv->opponent_engine != NULL) {
		g_signal_connect (self->priv->opponent_engine, "ready-changed", (GCallback) _application_engine_ready_cb_chess_engine_ready_changed, self);
		g_signal_connect (self->priv->opponent_engine, "moved", (GCallback) _application_engine_move_cb_chess_engine_moved, self);
		chess_engine_start (self->priv->opponent_engine);
	}
	{
		guint _tmp55_;
		gint j;
		_tmp55_ = g_list_length (self->priv->game->move_stack);
		j = ((gint) _tmp55_) - 2;
		{
			gboolean _tmp56_;
			_tmp56_ = TRUE;
			while (TRUE) {
				gconstpointer _tmp57_ = NULL;
				ChessState* _tmp58_;
				ChessState* state;
				if (!_tmp56_) {
					j--;
				}
				_tmp56_ = FALSE;
				if (!(j >= 0)) {
					break;
				}
				_tmp57_ = g_list_nth_data (self->priv->game->move_stack, (guint) j);
				_tmp58_ = _chess_state_ref0 ((ChessState*) _tmp57_);
				state = _tmp58_;
				application_game_move_cb (self, self->priv->game, state->last_move);
				_chess_state_unref0 (state);
			}
		}
	}
	self->priv->game_needs_saving = FALSE;
	chess_game_start (self->priv->game);
	if (self->priv->game->result != CHESS_RESULT_IN_PROGRESS) {
		application_game_end_cb (self, self->priv->game);
	}
	gtk_widget_queue_draw (self->priv->white_time_label);
	gtk_widget_queue_draw (self->priv->black_time_label);
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
	_g_object_unref0 (model);
}


static gpointer _ai_profile_ref0 (gpointer self) {
	return self ? ai_profile_ref (self) : NULL;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	const gchar* _tmp4_;
	GQuark _tmp5_;
	static GQuark _tmp5__label0 = 0;
	static GQuark _tmp5__label1 = 0;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	profile = NULL;
	if (g_strcmp0 (name, "human") == 0) {
		result = NULL;
		_ai_profile_unref0 (profile);
		_g_object_unref0 (engine);
		return result;
	}
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = self->priv->ai_profiles;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp0_;
			AIProfile* p = NULL;
			_tmp0_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
			p = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				if (g_strcmp0 (name, "") == 0) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = g_strcmp0 (p->name, name) == 0;
				}
				if (_tmp1_) {
					AIProfile* _tmp2_;
					_tmp2_ = _ai_profile_ref0 (p);
					_ai_profile_unref0 (profile);
					profile = _tmp2_;
					_ai_profile_unref0 (p);
					break;
				}
				_ai_profile_unref0 (p);
			}
		}
	}
	if (profile == NULL) {
		AIProfile* _tmp3_;
		g_warning ("glchess.vala:351: Unknown AI profile %s", name);
		if (self->priv->ai_profiles == NULL) {
			result = NULL;
			_ai_profile_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
		_tmp3_ = _ai_profile_ref0 ((AIProfile*) self->priv->ai_profiles->data);
		_ai_profile_unref0 (profile);
		profile = _tmp3_;
	}
	_tmp4_ = difficulty;
	_tmp5_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp5_ == ((0 != _tmp5__label0) ? _tmp5__label0 : (_tmp5__label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				gchar** _tmp6_;
				gchar** _tmp7_;
				_tmp7_ = (_tmp6_ = profile->easy_options, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup2 (_tmp6_, profile->easy_options_length1));
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp7_;
				options_length1 = profile->easy_options_length1;
				_options_size_ = options_length1;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp5__label1) ? _tmp5__label1 : (_tmp5__label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				gchar** _tmp8_;
				gchar** _tmp9_;
				_tmp9_ = (_tmp8_ = profile->hard_options, (_tmp8_ == NULL) ? ((gpointer) _tmp8_) : _vala_array_dup3 (_tmp8_, profile->hard_options_length1));
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp9_;
				options_length1 = profile->hard_options_length1;
				_options_size_ = options_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar** _tmp10_;
				gchar** _tmp11_;
				_tmp11_ = (_tmp10_ = profile->normal_options, (_tmp10_ == NULL) ? ((gpointer) _tmp10_) : _vala_array_dup4 (_tmp10_, profile->normal_options_length1));
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp11_;
				options_length1 = profile->normal_options_length1;
				_options_size_ = options_length1;
				break;
			}
		}
	}
	if (g_strcmp0 (profile->protocol, "cecp") == 0) {
		ChessEngineCECP* _tmp12_ = NULL;
		_tmp12_ = chess_engine_cecp_new (options, options_length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp12_;
	} else {
		if (g_strcmp0 (profile->protocol, "uci") == 0) {
			ChessEngineUCI* _tmp13_ = NULL;
			_tmp13_ = chess_engine_uci_new (options, options_length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp13_;
		} else {
			g_warning ("glchess.vala:378: Unknown AI protocol %s", profile->protocol);
			result = NULL;
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_ai_profile_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
	}
	_tmp14_ = g_strdup (profile->binary);
	_g_free0 (engine->binary);
	engine->binary = _tmp14_;
	result = engine;
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_ai_profile_unref0 (profile);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void application_start (Application* self, GFile* game, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GList* _tmp2_ = NULL;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_build_filename (PKGDATADIR, "engines.conf", NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = load_ai_profiles (_tmp1_);
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
	self->priv->ai_profiles = _tmp2_;
	_g_free0 (_tmp1_);
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = self->priv->ai_profiles;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp3_;
			AIProfile* profile = NULL;
			_tmp3_ = _ai_profile_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp3_;
			{
				g_message ("glchess.vala:390: Detected AI profile %s in %s", profile->name, profile->path);
				_ai_profile_unref0 (profile);
			}
		}
	}
	if (game == NULL) {
		GList* _tmp4_ = NULL;
		GList* unfinished;
		_tmp4_ = history_get_unfinished (self->priv->history);
		unfinished = _tmp4_;
		if (unfinished != NULL) {
			GFile* _tmp5_;
			GFile* file;
			_tmp5_ = _g_object_ref0 ((GFile*) unfinished->data);
			file = _tmp5_;
			application_load_game (self, file, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				__g_list_free__g_object_unref0_0 (unfinished);
				return;
			}
			_g_object_unref0 (file);
		} else {
			application_start_new_game (self);
		}
		__g_list_free__g_object_unref0_0 (unfinished);
	} else {
		application_load_game (self, game, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp6_ = g_settings_get_int (self->priv->settings, "width");
	_tmp7_ = g_settings_get_int (self->priv->settings, "height");
	gtk_window_set_default_size (self->priv->window, _tmp6_, _tmp7_);
	_tmp8_ = g_settings_get_boolean (self->priv->settings, "fullscreen");
	if (_tmp8_) {
		gtk_window_fullscreen (self->priv->window);
	} else {
		gboolean _tmp9_;
		_tmp9_ = g_settings_get_boolean (self->priv->settings, "maximized");
		if (_tmp9_) {
			gtk_window_maximize (self->priv->window);
		}
	}
	application_show (self);
}


static void application_engine_ready_cb (Application* self, ChessEngine* engine) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = chess_engine_get_ready (self->priv->opponent_engine);
	if (_tmp0_) {
		chess_game_start (self->priv->game);
		gtk_widget_queue_draw ((GtkWidget*) self->priv->view);
	}
}


static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	chess_player_move (self->priv->opponent, move, TRUE);
}


static void application_game_start_cb (Application* self, ChessGame* game) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	if (self->priv->opponent_engine != NULL) {
		chess_engine_start_game (self->priv->opponent_engine);
	}
}


static void application_game_clock_tick_cb (Application* self, ChessClock* clock) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	gtk_widget_queue_draw (self->priv->white_time_label);
	gtk_widget_queue_draw (self->priv->black_time_label);
}


static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	if (self->priv->opponent_engine != NULL) {
		_tmp0_ = player == self->priv->opponent;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		chess_engine_request_move (self->priv->opponent_engine);
	}
}


static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move) {
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
	gchar* _tmp0_;
	gchar* move_text;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	static GQuark _tmp3__label1 = 0;
	static GQuark _tmp3__label2 = 0;
	GtkTreeModel* _tmp11_ = NULL;
	GtkListStore* _tmp12_;
	GtkListStore* model;
	gchar _tmp13_ = '\0';
	gchar* _tmp14_ = NULL;
	gchar* label;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = chess_scene_get_move_format (self->priv->scene);
	_tmp2_ = _tmp1_;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				gint index = 0;
				gchar* _tmp4_ = NULL;
				gchar* start;
				gchar* _tmp5_ = NULL;
				gchar* end;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				if (move->victim == NULL) {
					index = 0;
				} else {
					index = (gint) (move->victim->type + 1);
				}
				index = index + (move->piece->type * 6);
				if (move->piece->player->color == COLOR_BLACK) {
					index = index + 36;
				}
				_tmp4_ = g_strdup_printf ("%c%d", 'a' + move->f0, move->r0 + 1);
				start = _tmp4_;
				_tmp5_ = g_strdup_printf ("%c%d", 'a' + move->f1, move->r1 + 1);
				end = _tmp5_;
				_tmp6_ = _ (human_descriptions[index]);
				_tmp7_ = g_strdup_printf (_tmp6_, start, end);
				_g_free0 (move_text);
				move_text = _tmp7_;
				_g_free0 (end);
				_g_free0 (start);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_ = NULL;
				_tmp8_ = chess_move_get_san (move);
				_g_free0 (move_text);
				move_text = _tmp8_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label2) ? _tmp3__label2 : (_tmp3__label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_ = NULL;
				_tmp9_ = chess_move_get_fan (move);
				_g_free0 (move_text);
				move_text = _tmp9_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp10_ = NULL;
				_tmp10_ = chess_move_get_lan (move);
				_g_free0 (move_text);
				move_text = _tmp10_;
				break;
			}
		}
	}
	_tmp11_ = gtk_combo_box_get_model (self->priv->history_combo);
	_tmp12_ = _g_object_ref0 (GTK_LIST_STORE (_tmp11_));
	model = _tmp12_;
	if ((move->number % 2) == 0) {
		_tmp13_ = 'b';
	} else {
		_tmp13_ = 'a';
	}
	_tmp14_ = g_strdup_printf ("%u%c. %s", (guint) ((move->number + 1) / 2), (gint) _tmp13_, move_text);
	label = _tmp14_;
	gtk_list_store_set (model, iter, 0, label, -1, -1);
	_g_free0 (label);
	_g_object_unref0 (model);
	_g_free0 (move_text);
}


static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkListStore* _tmp5_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	self->priv->game_needs_saving = TRUE;
	if (move->number == 1) {
		_tmp1_ = self->priv->opponent != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->opponent->color == COLOR_WHITE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp2_ = g_list_length (self->priv->pgn_game->moves);
	if (((guint) move->number) > _tmp2_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = chess_move_get_san (move);
		self->priv->pgn_game->moves = g_list_append (self->priv->pgn_game->moves, _tmp3_);
	}
	_tmp4_ = gtk_combo_box_get_model (self->priv->history_combo);
	_tmp5_ = _g_object_ref0 (GTK_LIST_STORE (_tmp4_));
	model = _tmp5_;
	gtk_list_store_append (model, &_tmp6_);
	iter = _tmp6_;
	gtk_list_store_set (model, &iter, 1, move->number, -1, -1);
	application_set_move_text (self, &iter, move);
	_tmp8_ = chess_game_get_n_moves (game);
	if (((guint) move->number) == _tmp8_) {
		gint _tmp9_;
		_tmp9_ = chess_scene_get_move_number (self->priv->scene);
		_tmp7_ = _tmp9_ == (-1);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gtk_combo_box_set_active_iter (self->priv->history_combo, &iter);
	}
	gtk_widget_set_sensitive (self->priv->save_menu, TRUE);
	gtk_widget_set_sensitive (self->priv->save_as_menu, TRUE);
	application_update_history_panel (self);
	application_update_control_buttons (self);
	if (self->priv->opponent_engine != NULL) {
		chess_engine_report_move (self->priv->opponent_engine, move);
	}
	gtk_widget_queue_draw ((GtkWidget*) self->priv->view);
	_g_object_unref0 (model);
}


static void application_game_undo_cb (Application* self, ChessGame* game) {
	GList* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	gint _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	if (self->priv->opponent_engine != NULL) {
		chess_engine_undo (self->priv->opponent_engine);
	}
	_tmp0_ = g_list_last (self->priv->pgn_game->moves);
	self->priv->pgn_game->moves = g_list_remove_link (self->priv->pgn_game->moves, _tmp0_);
	_tmp1_ = gtk_combo_box_get_model (self->priv->history_combo);
	_tmp2_ = _g_object_ref0 (GTK_LIST_STORE (_tmp1_));
	model = _tmp2_;
	_tmp3_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) model, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) model, &_tmp4_, NULL, _tmp3_ - 1);
	iter = _tmp4_;
	gtk_list_store_remove (model, &iter);
	_tmp6_ = chess_scene_get_move_number (self->priv->scene);
	_tmp7_ = chess_game_get_n_moves (game);
	if (((guint) _tmp6_) > _tmp7_) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp8_;
		_tmp8_ = chess_scene_get_move_number (self->priv->scene);
		_tmp5_ = _tmp8_ == (-1);
	}
	if (_tmp5_) {
		gint _tmp9_;
		GtkTreeIter _tmp10_ = {0};
		_tmp9_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) model, NULL);
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) model, &_tmp10_, NULL, _tmp9_ - 1);
		iter = _tmp10_;
		gtk_combo_box_set_active_iter (self->priv->history_combo, &iter);
		gtk_widget_queue_draw ((GtkWidget*) self->priv->view);
	}
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_g_object_unref0 (model);
}


static void application_update_control_buttons (Application* self) {
	guint _tmp0_;
	gboolean can_resign;
	gboolean _tmp1_;
	guint _tmp2_;
	gboolean can_undo;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_game_get_n_moves (self->priv->game);
	can_resign = _tmp0_ > ((guint) 0);
	_tmp1_ = can_resign;
	gtk_widget_set_sensitive (self->priv->resign_button, _tmp1_);
	gtk_widget_set_sensitive (self->priv->resign_menu, _tmp1_);
	_tmp2_ = chess_game_get_n_moves (self->priv->game);
	can_undo = _tmp2_ > ((guint) 0);
	if (self->priv->opponent != NULL) {
		_tmp3_ = self->priv->opponent->color == COLOR_WHITE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		guint _tmp4_;
		_tmp4_ = chess_game_get_n_moves (self->priv->game);
		can_undo = _tmp4_ > ((guint) 1);
	}
	_tmp5_ = can_undo;
	gtk_widget_set_sensitive (self->priv->undo_button, _tmp5_);
	gtk_widget_set_sensitive (self->priv->undo_menu, _tmp5_);
}


static void application_game_end_cb (Application* self, ChessGame* game) {
	gchar* _tmp0_;
	gchar* title;
	gchar* _tmp7_;
	gchar* reason;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = g_strdup ("");
	title = _tmp0_;
	switch (game->result) {
		case CHESS_RESULT_WHITE_WON:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = _ ("White wins");
			_tmp2_ = g_strdup (_tmp1_);
			_g_free0 (title);
			title = _tmp2_;
			pgn_game_set_result (self->priv->pgn_game, pgn_game_RESULT_WHITE);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = _ ("Black wins");
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (title);
			title = _tmp4_;
			pgn_game_set_result (self->priv->pgn_game, pgn_game_RESULT_BLACK);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = _ ("Game is drawn");
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (title);
			title = _tmp6_;
			pgn_game_set_result (self->priv->pgn_game, pgn_game_RESULT_DRAW);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp7_ = g_strdup ("");
	reason = _tmp7_;
	switch (game->rule) {
		case CHESS_RULE_CHECKMATE:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("Opponent is in check and cannot move (checkmate)");
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (reason);
			reason = _tmp9_;
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("Opponent cannot move (stalemate)");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (reason);
			reason = _tmp11_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = _ ("No piece has been taken or pawn moved in the last fifty moves");
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (reason);
			reason = _tmp13_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp14_ = _ ("Opponent has run out of time");
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (reason);
			reason = _tmp15_;
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp16_ = _ ("The same board state has occurred three times (three fold repetition)");
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (reason);
			reason = _tmp17_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp18_ = _ ("Neither player can cause checkmate (insufficient material)");
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (reason);
			reason = _tmp19_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			if (game->result == CHESS_RESULT_WHITE_WON) {
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				_tmp20_ = _ ("The black player has resigned");
				_tmp21_ = g_strdup (_tmp20_);
				_g_free0 (reason);
				reason = _tmp21_;
			} else {
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				_tmp22_ = _ ("The white player has resigned");
				_tmp23_ = g_strdup (_tmp22_);
				_g_free0 (reason);
				reason = _tmp23_;
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp24_ = _ ("The game has been abandoned");
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (reason);
			reason = _tmp25_;
			pgn_game_set_termination (self->priv->pgn_game, pgn_game_TERMINATE_ABANDONED);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp26_ = _ ("One of the players has died");
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (reason);
			reason = _tmp27_;
			pgn_game_set_termination (self->priv->pgn_game, pgn_game_TERMINATE_DEATH);
			break;
		}
		default:
		break;
	}
	_tmp28_ = g_strdup_printf ("<big><b>%s</b></big>", title);
	_tmp29_ = _tmp28_;
	gtk_label_set_markup (self->priv->info_title_label, _tmp29_);
	_g_free0 (_tmp29_);
	gtk_label_set_text (self->priv->info_label, reason);
	gtk_widget_show ((GtkWidget*) self->priv->info_bar);
	gtk_widget_queue_draw (self->priv->white_time_label);
	gtk_widget_queue_draw (self->priv->black_time_label);
	_g_free0 (reason);
	_g_free0 (title);
}


void application_show (Application* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show ((GtkWidget*) self->priv->window);
}


gboolean G_MODULE_EXPORT glchess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	application_quit (self);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT glchess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp1_ = g_settings_get_boolean (self->priv->settings, "maximized");
	if (!_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = g_settings_get_boolean (self->priv->settings, "fullscreen");
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_settings_set_int (self->priv->settings, "width", (*event).width);
		g_settings_set_int (self->priv->settings, "height", (*event).height);
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT glchess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (((*event).changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		gboolean is_maximized;
		is_maximized = ((*event).new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
		g_settings_set_boolean (self->priv->settings, "maximized", is_maximized);
	}
	if (((*event).changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		gboolean is_fullscreen;
		const gchar* _tmp0_ = NULL;
		is_fullscreen = ((*event).new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		g_settings_set_boolean (self->priv->settings, "fullscreen", is_fullscreen);
		if (is_fullscreen) {
			_tmp0_ = GTK_STOCK_LEAVE_FULLSCREEN;
		} else {
			_tmp0_ = GTK_STOCK_FULLSCREEN;
		}
		gtk_menu_item_set_label (self->priv->fullscreen_menu, _tmp0_);
	}
	result = FALSE;
	return result;
}


void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->game_needs_saving) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->in_history) {
			_tmp1_ = self->priv->game_file != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		const gchar* _tmp2_ = NULL;
		GtkMessageDialog* _tmp3_ = NULL;
		GtkMessageDialog* dialog;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_;
		gint _result_;
		_tmp2_ = _ ("Save this game before starting a new one?");
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (self->priv->window, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "<span weight=\"bold\" size=\"larger\">%s</span>", _tmp2_, NULL);
		dialog = g_object_ref_sink (_tmp3_);
		gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
		_tmp4_ = _ ("_Abandon game");
		gtk_dialog_add_button ((GtkDialog*) dialog, _tmp4_, (gint) GTK_RESPONSE_NO);
		_tmp5_ = _ ("_Save game for later");
		gtk_dialog_add_button ((GtkDialog*) dialog, _tmp5_, (gint) GTK_RESPONSE_YES);
		_tmp6_ = gtk_dialog_run ((GtkDialog*) dialog);
		_result_ = _tmp6_;
		gtk_widget_destroy ((GtkWidget*) dialog);
		if (_result_ == ((gint) GTK_RESPONSE_CANCEL)) {
			_g_object_unref0 (dialog);
			return;
		}
		if (_result_ == ((gint) GTK_RESPONSE_NO)) {
			self->priv->in_history = FALSE;
			self->priv->game_needs_saving = FALSE;
		}
		_g_object_unref0 (dialog);
	}
	application_autosave (self);
	application_start_new_game (self);
}


void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = chess_game_get_current_player (self->priv->game);
	chess_player_resign (_tmp0_);
}


void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = chess_game_get_current_player (self->priv->game);
	chess_player_claim_draw (_tmp0_);
}


void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->opponent != NULL) {
		chess_player_undo (self->priv->human_player);
	} else {
		ChessPlayer* _tmp0_ = NULL;
		_tmp0_ = chess_game_get_opponent (self->priv->game);
		chess_player_undo (_tmp0_);
	}
}


void G_MODULE_EXPORT quit_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_quit (self);
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	static const gdouble fg[] = {0.0, 0.0, 0.0};
	static const gdouble bg[] = {1.0, 1.0, 1.0};
	ChessClock* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = chess_game_get_clock (self->priv->game);
	_tmp1_ = application_make_clock_text (self, _tmp0_, COLOR_WHITE);
	_tmp2_ = _tmp1_;
	application_draw_time (self, widget, c, _tmp2_, fg, G_N_ELEMENTS (fg), bg, G_N_ELEMENTS (bg));
	_g_free0 (_tmp2_);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	static const gdouble fg[] = {1.0, 1.0, 1.0};
	static const gdouble bg[] = {0.0, 0.0, 0.0};
	ChessClock* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = chess_game_get_clock (self->priv->game);
	_tmp1_ = application_make_clock_text (self, _tmp0_, COLOR_BLACK);
	_tmp2_ = _tmp1_;
	application_draw_time (self, widget, c, _tmp2_, fg, G_N_ELEMENTS (fg), bg, G_N_ELEMENTS (bg));
	_g_free0 (_tmp2_);
	result = FALSE;
	return result;
}


static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	gint used = 0;
	g_return_val_if_fail (self != NULL, NULL);
	if (clock == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("∞");
		result = _tmp0_;
		return result;
	}
	if (color == COLOR_WHITE) {
		ChessClock* _tmp1_ = NULL;
		guint _tmp2_;
		ChessClock* _tmp3_ = NULL;
		guint _tmp4_;
		_tmp1_ = chess_game_get_clock (self->priv->game);
		_tmp2_ = chess_clock_get_white_duration (_tmp1_);
		_tmp3_ = chess_game_get_clock (self->priv->game);
		_tmp4_ = chess_clock_get_white_used_in_seconds (_tmp3_);
		used = (gint) ((_tmp2_ / 1000) - _tmp4_);
	} else {
		ChessClock* _tmp5_ = NULL;
		guint _tmp6_;
		ChessClock* _tmp7_ = NULL;
		guint _tmp8_;
		_tmp5_ = chess_game_get_clock (self->priv->game);
		_tmp6_ = chess_clock_get_black_duration (_tmp5_);
		_tmp7_ = chess_game_get_clock (self->priv->game);
		_tmp8_ = chess_clock_get_black_used_in_seconds (_tmp7_);
		used = (gint) ((_tmp6_ / 1000) - _tmp8_);
	}
	if (used >= 60) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup_printf ("%d:%02d", used / 60, used % 60);
		result = _tmp9_;
		return result;
	} else {
		gchar* _tmp10_ = NULL;
		_tmp10_ = g_strdup_printf (":%02d", used);
		result = _tmp10_;
		return result;
	}
}


static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha;
	GtkStateType _tmp0_;
	gint _tmp1_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp2_ = {0};
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	alpha = 1.0;
	_tmp0_ = gtk_widget_get_state (widget);
	if (_tmp0_ == GTK_STATE_INSENSITIVE) {
		alpha = 0.5;
	}
	cairo_set_source_rgba (c, bg[0], bg[1], bg[2], alpha);
	cairo_paint (c);
	cairo_set_source_rgba (c, fg[0], fg[1], fg[2], alpha);
	cairo_select_font_face (c, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp1_ = gtk_widget_get_allocated_height (widget);
	cairo_set_font_size (c, 0.6 * _tmp1_);
	cairo_text_extents (c, text, &_tmp2_);
	extents = _tmp2_;
	_tmp3_ = gtk_widget_get_allocated_width (widget);
	_tmp4_ = gtk_widget_get_allocated_height (widget);
	cairo_move_to (c, ((_tmp3_ - extents.width) / 2) - extents.x_bearing, ((_tmp4_ - extents.height) / 2) - extents.y_bearing);
	cairo_show_text (c, text);
	gtk_widget_set_size_request (widget, ((gint) extents.width) + 6, -1);
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint move_number = 0;
	GtkTreeModel* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp2_, &iter, 1, &move_number, -1, -1);
	if (self->priv->game == NULL) {
		_tmp3_ = TRUE;
	} else {
		guint _tmp4_;
		_tmp4_ = chess_game_get_n_moves (self->priv->game);
		_tmp3_ = ((guint) move_number) == _tmp4_;
	}
	if (_tmp3_) {
		move_number = -1;
	}
	chess_scene_set_move_number (self->priv->scene, move_number);
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	chess_scene_set_move_number (self->priv->scene, -1);
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint move_number;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = chess_scene_get_move_number (self->priv->scene);
	if (_tmp0_ == (-1)) {
		return;
	}
	_tmp1_ = chess_scene_get_move_number (self->priv->scene);
	move_number = _tmp1_ + 1;
	_tmp2_ = chess_game_get_n_moves (self->priv->game);
	if (((guint) move_number) >= _tmp2_) {
		chess_scene_set_move_number (self->priv->scene, -1);
	} else {
		chess_scene_set_move_number (self->priv->scene, move_number);
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = chess_scene_get_move_number (self->priv->scene);
	if (_tmp0_ == 0) {
		return;
	}
	_tmp1_ = chess_scene_get_move_number (self->priv->scene);
	if (_tmp1_ == (-1)) {
		guint _tmp2_;
		_tmp2_ = chess_game_get_n_moves (self->priv->game);
		chess_scene_set_move_number (self->priv->scene, ((gint) _tmp2_) - 1);
	} else {
		gint _tmp3_;
		_tmp3_ = chess_scene_get_move_number (self->priv->scene);
		chess_scene_set_move_number (self->priv->scene, _tmp3_ - 1);
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	chess_scene_set_move_number (self->priv->scene, 0);
}


void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_menu_item_get_label (self->priv->fullscreen_menu);
	if (g_strcmp0 (_tmp0_, GTK_STOCK_FULLSCREEN) == 0) {
		gtk_window_fullscreen (self->priv->window);
	} else {
		gtk_window_unfullscreen (self->priv->window);
	}
}


void G_MODULE_EXPORT preferences_cb (GtkWidget* widget, Application* self) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkDialog* _tmp4_;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkComboBox* _tmp12_;
	GtkComboBox* side_combo;
	gint _tmp13_ = 0;
	gboolean _tmp14_;
	GObject* _tmp15_ = NULL;
	GtkComboBox* _tmp16_;
	GtkComboBox* ai_combo;
	GtkTreeModel* _tmp17_ = NULL;
	GtkListStore* _tmp18_;
	GtkListStore* ai_model;
	gchar* _tmp19_ = NULL;
	gchar* opponent_name;
	GObject* _tmp25_ = NULL;
	GtkComboBox* _tmp26_;
	GtkComboBox* difficulty_combo;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkComboBox* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkAdjustment* _tmp32_;
	GObject* _tmp33_ = NULL;
	GtkContainer* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkComboBox* _tmp36_;
	gint _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkComboBox* _tmp39_;
	GtkComboBox* orientation_combo;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	GObject* _tmp42_ = NULL;
	GtkComboBox* _tmp43_;
	GtkComboBox* move_combo;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	GObject* _tmp46_ = NULL;
	GtkComboBox* _tmp47_;
	GtkComboBox* promotion_combo;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_;
	GObject* _tmp50_ = NULL;
	GtkComboBox* _tmp51_;
	GtkComboBox* theme_combo;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->preferences_dialog != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->preferences_dialog);
		return;
	}
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->preferences_builder);
	self->priv->preferences_builder = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_build_filename (PKGDATADIR, "preferences.ui", NULL, NULL);
		_tmp2_ = _tmp1_;
		gtk_builder_add_from_file (self->priv->preferences_builder, _tmp2_, &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("glchess.vala:1021: Could not load preferences UI: %s", e->message);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = gtk_builder_get_object (self->priv->preferences_builder, "preferences");
	_tmp4_ = _g_object_ref0 (GTK_DIALOG (_tmp3_));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp4_;
	_tmp5_ = gtk_builder_get_object (self->priv->preferences_builder, "show_numbering_check");
	g_settings_bind (self->priv->settings, "show-numbering", _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = gtk_builder_get_object (self->priv->preferences_builder, "show_move_hints_check");
	g_settings_bind (self->priv->settings, "show-move-hints", _tmp6_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = gtk_builder_get_object (self->priv->preferences_builder, "show_toolbar_check");
	g_settings_bind (self->priv->settings, "show-toolbar", _tmp7_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = gtk_builder_get_object (self->priv->preferences_builder, "show_history_check");
	g_settings_bind (self->priv->settings, "show-history", _tmp8_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = gtk_builder_get_object (self->priv->preferences_builder, "show_3d_check");
	g_settings_bind (self->priv->settings, "show-3d", _tmp9_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp10_ = gtk_builder_get_object (self->priv->preferences_builder, "show_3d_smooth_check");
	g_settings_bind (self->priv->settings, "show-3d-smooth", _tmp10_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = gtk_builder_get_object (self->priv->preferences_builder, "side_combo");
	_tmp12_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp11_));
	side_combo = _tmp12_;
	_tmp14_ = g_settings_get_boolean (self->priv->settings, "play-as-white");
	if (_tmp14_) {
		_tmp13_ = 0;
	} else {
		_tmp13_ = 1;
	}
	gtk_combo_box_set_active (side_combo, _tmp13_);
	_tmp15_ = gtk_builder_get_object (self->priv->preferences_builder, "opponent_combo");
	_tmp16_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp15_));
	ai_combo = _tmp16_;
	_tmp17_ = gtk_combo_box_get_model (ai_combo);
	_tmp18_ = _g_object_ref0 (GTK_LIST_STORE (_tmp17_));
	ai_model = _tmp18_;
	_tmp19_ = g_settings_get_string (self->priv->settings, "opponent");
	opponent_name = _tmp19_;
	if (g_strcmp0 (opponent_name, "human") == 0) {
		gtk_combo_box_set_active (ai_combo, 0);
	}
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = self->priv->ai_profiles;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp20_;
			AIProfile* p = NULL;
			_tmp20_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
			p = _tmp20_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp21_ = {0};
				gboolean _tmp22_ = FALSE;
				gtk_list_store_append (ai_model, &_tmp21_);
				iter = _tmp21_;
				gtk_list_store_set (ai_model, &iter, 0, p->name, 1, p->name, -1, -1);
				if (g_strcmp0 (p->name, opponent_name) == 0) {
					_tmp22_ = TRUE;
				} else {
					gboolean _tmp23_ = FALSE;
					if (g_strcmp0 (opponent_name, "") == 0) {
						gint _tmp24_;
						_tmp24_ = gtk_combo_box_get_active (ai_combo);
						_tmp23_ = _tmp24_ == (-1);
					} else {
						_tmp23_ = FALSE;
					}
					_tmp22_ = _tmp23_;
				}
				if (_tmp22_) {
					gtk_combo_box_set_active_iter (ai_combo, &iter);
				}
				_ai_profile_unref0 (p);
			}
		}
	}
	g_settings_bind (self->priv->settings, "show-history", ai_combo, "visible", G_SETTINGS_BIND_SET);
	_tmp25_ = gtk_builder_get_object (self->priv->preferences_builder, "difficulty_combo");
	_tmp26_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp25_));
	difficulty_combo = _tmp26_;
	_tmp27_ = g_settings_get_string (self->priv->settings, "difficulty");
	_tmp28_ = _tmp27_;
	application_set_combo (self, difficulty_combo, 1, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = gtk_builder_get_object (self->priv->preferences_builder, "duration_combo");
	_tmp30_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp29_));
	_g_object_unref0 (self->priv->duration_combo);
	self->priv->duration_combo = _tmp30_;
	_tmp31_ = gtk_builder_get_object (self->priv->preferences_builder, "duration_adjustment");
	_tmp32_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp31_));
	_g_object_unref0 (self->priv->duration_adjustment);
	self->priv->duration_adjustment = _tmp32_;
	_tmp33_ = gtk_builder_get_object (self->priv->preferences_builder, "custom_duration_box");
	_tmp34_ = _g_object_ref0 (GTK_CONTAINER (_tmp33_));
	_g_object_unref0 (self->priv->custom_duration_box);
	self->priv->custom_duration_box = _tmp34_;
	_tmp35_ = gtk_builder_get_object (self->priv->preferences_builder, "custom_duration_units_combo");
	_tmp36_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp35_));
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	self->priv->custom_duration_units_combo = _tmp36_;
	_tmp37_ = g_settings_get_int (self->priv->settings, "duration");
	application_set_duration (self, _tmp37_, TRUE);
	_tmp38_ = gtk_builder_get_object (self->priv->preferences_builder, "orientation_combo");
	_tmp39_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp38_));
	orientation_combo = _tmp39_;
	_tmp40_ = g_settings_get_string (self->priv->settings, "board-side");
	_tmp41_ = _tmp40_;
	application_set_combo (self, orientation_combo, 1, _tmp41_);
	_g_free0 (_tmp41_);
	_tmp42_ = gtk_builder_get_object (self->priv->preferences_builder, "move_format_combo");
	_tmp43_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp42_));
	move_combo = _tmp43_;
	_tmp44_ = g_settings_get_string (self->priv->settings, "move-format");
	_tmp45_ = _tmp44_;
	application_set_combo (self, move_combo, 1, _tmp45_);
	_g_free0 (_tmp45_);
	_tmp46_ = gtk_builder_get_object (self->priv->preferences_builder, "promotion_type_combo");
	_tmp47_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp46_));
	promotion_combo = _tmp47_;
	_tmp48_ = g_settings_get_string (self->priv->settings, "promotion-type");
	_tmp49_ = _tmp48_;
	application_set_combo (self, promotion_combo, 1, _tmp49_);
	_g_free0 (_tmp49_);
	_tmp50_ = gtk_builder_get_object (self->priv->preferences_builder, "piece_style_combo");
	_tmp51_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp50_));
	theme_combo = _tmp51_;
	_tmp52_ = g_settings_get_string (self->priv->settings, "piece-theme");
	_tmp53_ = _tmp52_;
	application_set_combo (self, theme_combo, 1, _tmp53_);
	_g_free0 (_tmp53_);
	gtk_builder_connect_signals (self->priv->preferences_builder, self);
	gtk_window_present ((GtkWindow*) self->priv->preferences_dialog);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (promotion_combo);
	_g_object_unref0 (move_combo);
	_g_object_unref0 (orientation_combo);
	_g_object_unref0 (difficulty_combo);
	_g_free0 (opponent_name);
	_g_object_unref0 (ai_model);
	_g_object_unref0 (ai_combo);
	_g_object_unref0 (side_combo);
}


static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = gtk_combo_box_get_model (combo);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	_tmp3_ = gtk_tree_model_get_iter_first (model, &_tmp2_);
	iter = _tmp2_;
	if (!_tmp3_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			gchar* v = NULL;
			if (!_tmp4_) {
				gboolean _tmp5_;
				_tmp5_ = gtk_tree_model_iter_next (model, &iter);
				if (!_tmp5_) {
					break;
				}
			}
			_tmp4_ = FALSE;
			gtk_tree_model_get (model, &iter, value_index, &v, -1, -1);
			if (g_strcmp0 (v, value) == 0) {
				gtk_combo_box_set_active_iter (combo, &iter);
				_g_free0 (v);
				_g_object_unref0 (model);
				return;
			}
			_g_free0 (v);
		}
	}
	_g_object_unref0 (model);
}


static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = NULL;
		_g_free0 (value);
		return result;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp2_, &iter, value_index, &value, -1, -1);
	result = value;
	return result;
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean play_as_white = FALSE;
	GtkTreeModel* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp2_, &iter, 1, &play_as_white, -1, -1);
	g_settings_set_boolean (self->priv->settings, "play-as-white", play_as_white);
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* opponent = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp2_, &iter, 1, &opponent, -1, -1);
	g_settings_set_string (self->priv->settings, "opponent", opponent);
	_g_free0 (opponent);
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* difficulty = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp2_, &iter, 1, &difficulty, -1, -1);
	g_settings_set_string (self->priv->settings, "difficulty", difficulty);
	_g_free0 (difficulty);
}


static void application_set_duration (Application* self, gint duration, gboolean simplify) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter max_iter;
	gint max_multiplier;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gint value;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeModel* _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_combo_box_get_model (self->priv->custom_duration_units_combo);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	max_iter = _tmp2_;
	max_multiplier = 0;
	_tmp4_ = gtk_tree_model_get_iter_first (model, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				gboolean _tmp7_ = FALSE;
				if (!_tmp5_) {
					gboolean _tmp6_;
					_tmp6_ = gtk_tree_model_iter_next (model, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp5_ = FALSE;
				gtk_tree_model_get (model, &iter, 1, &multiplier, -1, -1);
				if (multiplier > max_multiplier) {
					_tmp7_ = (duration % multiplier) == 0;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					max_multiplier = multiplier;
					max_iter = iter;
				}
			}
		}
	}
	value = 0;
	if (max_multiplier > 0) {
		value = duration / max_multiplier;
		gtk_adjustment_set_value (self->priv->duration_adjustment, (gdouble) value);
		gtk_combo_box_set_active_iter (self->priv->custom_duration_units_combo, &max_iter);
	}
	if (!simplify) {
		_g_object_unref0 (model);
		return;
	}
	_tmp8_ = gtk_combo_box_get_model (self->priv->duration_combo);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (model);
	model = _tmp9_;
	_tmp11_ = gtk_tree_model_get_iter_first (model, &_tmp10_);
	iter = _tmp10_;
	if (!_tmp11_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp12_;
		_tmp12_ = TRUE;
		while (TRUE) {
			gint v = 0;
			gboolean _tmp14_ = FALSE;
			if (!_tmp12_) {
				gboolean _tmp13_;
				_tmp13_ = gtk_tree_model_iter_next (model, &iter);
				if (!_tmp13_) {
					break;
				}
			}
			_tmp12_ = FALSE;
			gtk_tree_model_get (model, &iter, 1, &v, -1, -1);
			if (v == duration) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = v == (-1);
			}
			if (_tmp14_) {
				gtk_combo_box_set_active_iter (self->priv->duration_combo, &iter);
				gtk_widget_set_visible ((GtkWidget*) self->priv->custom_duration_box, v == (-1));
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_g_object_unref0 (model);
}


static gint application_get_duration (Application* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gdouble _tmp3_;
	gint magnitude;
	gint multiplier;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->duration_combo, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		gint duration = 0;
		GtkTreeModel* _tmp2_ = NULL;
		_tmp2_ = gtk_combo_box_get_model (self->priv->duration_combo);
		gtk_tree_model_get (_tmp2_, &iter, 1, &duration, -1, -1);
		if (duration >= 0) {
			result = duration;
			return result;
		}
	}
	_tmp3_ = gtk_adjustment_get_value (self->priv->duration_adjustment);
	magnitude = (gint) _tmp3_;
	multiplier = 1;
	_tmp5_ = gtk_combo_box_get_active_iter (self->priv->custom_duration_units_combo, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeModel* _tmp6_ = NULL;
		_tmp6_ = gtk_combo_box_get_model (self->priv->custom_duration_units_combo);
		gtk_tree_model_get (_tmp6_, &iter, 1, &multiplier, -1, -1);
	}
	result = magnitude * multiplier;
	return result;
}


static gboolean application_save_duration_cb (Application* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = application_get_duration (self);
	g_settings_set_int (self->priv->settings, "duration", _tmp0_);
	g_source_remove (self->priv->save_duration_timeout);
	self->priv->save_duration_timeout = (guint) 0;
	result = FALSE;
	return result;
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	GtkListStore* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = gtk_combo_box_get_model (self->priv->custom_duration_units_combo);
	_tmp1_ = _g_object_ref0 (GTK_LIST_STORE (_tmp0_));
	model = _tmp1_;
	_tmp3_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) model, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				if (!_tmp4_) {
					gboolean _tmp5_;
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) model, &iter);
					if (!_tmp5_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				gtk_tree_model_get ((GtkTreeModel*) model, &iter, 1, &multiplier, -1, -1);
				switch (multiplier) {
					case 1:
					{
						gdouble _tmp6_;
						const gchar* _tmp7_ = NULL;
						_tmp6_ = gtk_adjustment_get_value (adjustment);
						_tmp7_ = ngettext ("second", "seconds", (gulong) _tmp6_);
						gtk_list_store_set (model, &iter, 0, _tmp7_, -1, -1);
						break;
					}
					case 60:
					{
						gdouble _tmp8_;
						const gchar* _tmp9_ = NULL;
						_tmp8_ = gtk_adjustment_get_value (adjustment);
						_tmp9_ = ngettext ("minute", "minutes", (gulong) _tmp8_);
						gtk_list_store_set (model, &iter, 0, _tmp9_, -1, -1);
						break;
					}
					case 3600:
					{
						gdouble _tmp10_;
						const gchar* _tmp11_ = NULL;
						_tmp10_ = gtk_adjustment_get_value (adjustment);
						_tmp11_ = ngettext ("hour", "hours", (gulong) _tmp10_);
						gtk_list_store_set (model, &iter, 0, _tmp11_, -1, -1);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	application_save_duration (self);
	_g_object_unref0 (model);
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_duration (self);
}


static gboolean _application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = application_save_duration_cb (self);
	return result;
}


static void application_save_duration (Application* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->save_duration_timeout != ((guint) 0)) {
		g_source_remove (self->priv->save_duration_timeout);
	}
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _application_save_duration_cb_gsource_func, application_ref (self), application_unref);
	self->priv->save_duration_timeout = _tmp0_;
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint duration = 0;
	GtkTreeModel* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp2_, &iter, 1, &duration, -1, -1);
	gtk_widget_set_visible ((GtkWidget*) self->priv->custom_duration_box, duration < 0);
	if (duration >= 0) {
		application_set_duration (self, duration, FALSE);
	} else {
		gint _tmp3_;
		_tmp3_ = application_get_duration (self);
		if (_tmp3_ <= 0) {
			application_set_duration (self, 5 * 60, FALSE);
		}
	}
	application_save_duration (self);
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->preferences_dialog);
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	G_MODULE_EXPORT preferences_response_cb (widget, (gint) GTK_RESPONSE_CANCEL, self);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = application_get_combo (self, combo, 1);
	_tmp1_ = _tmp0_;
	g_settings_set_string (self->priv->settings, "piece-theme", _tmp1_);
	_g_free0 (_tmp1_);
}


void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self) {
	GObject* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* w;
	gboolean _tmp2_;
	GObject* _tmp3_ = NULL;
	GtkWidget* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->preferences_builder, "show_3d_smooth_check");
	_tmp1_ = _g_object_ref0 (GTK_WIDGET (_tmp0_));
	w = _tmp1_;
	_tmp2_ = gtk_toggle_button_get_active (widget);
	gtk_widget_set_sensitive (w, _tmp2_);
	_tmp3_ = gtk_builder_get_object (self->priv->preferences_builder, "piece_style_combo");
	_tmp4_ = _g_object_ref0 (GTK_WIDGET (_tmp3_));
	_g_object_unref0 (w);
	w = _tmp4_;
	_tmp5_ = gtk_toggle_button_get_active (widget);
	gtk_widget_set_sensitive (w, !_tmp5_);
	_g_object_unref0 (w);
}


void G_MODULE_EXPORT promotion_type_combo_changed_cb (GtkComboBox* combo, Application* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = application_get_combo (self, combo, 1);
	_tmp1_ = _tmp0_;
	g_settings_set_string (self->priv->settings, "promotion-type", _tmp1_);
	_g_free0 (_tmp1_);
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = application_get_combo (self, combo, 1);
	_tmp1_ = _tmp0_;
	g_settings_set_string (self->priv->settings, "move-format", _tmp1_);
	_g_free0 (_tmp1_);
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = application_get_combo (self, combo, 1);
	_tmp1_ = _tmp0_;
	g_settings_set_string (self->priv->settings, "board-side", _tmp1_);
	_g_free0 (_tmp1_);
}


void G_MODULE_EXPORT help_cb (GtkWidget* widget, Application* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GdkScreen* _tmp0_ = NULL;
		guint32 _tmp1_;
		_tmp0_ = gtk_window_get_screen (self->priv->window);
		_tmp1_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp0_, "ghelp:glchess", _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("glchess.vala:1340: Unable to open help: %s", e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_about_response_cb (self, response_id);
}


void G_MODULE_EXPORT about_cb (GtkWidget* widget, Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->about_dialog != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->about_dialog);
		return;
	}
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = g_object_ref_sink (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->about_dialog, self->priv->window);
	gtk_widget_set_name ((GtkWidget*) self->priv->about_dialog, "glchess");
	gtk_about_dialog_set_version (self->priv->about_dialog, VERSION);
	gtk_about_dialog_set_copyright (self->priv->about_dialog, "Copyright 2010 Robert Ancell <robert.ancell@gmail.com>");
	gtk_about_dialog_set_license_type (self->priv->about_dialog, GTK_LICENSE_GPL_2_0);
	_tmp1_ = _ ("The 2D/3D chess game for GNOME. \n" \
"\n" \
"glChess is a part of GNOME Games.");
	gtk_about_dialog_set_comments (self->priv->about_dialog, _tmp1_);
	gtk_about_dialog_set_authors (self->priv->about_dialog, APPLICATION_authors);
	gtk_about_dialog_set_artists (self->priv->about_dialog, APPLICATION_artists);
	gtk_about_dialog_set_translator_credits (self->priv->about_dialog, "translator-credits");
	gtk_about_dialog_set_website (self->priv->about_dialog, "http://www.gnome.org/projects/gnome-games/");
	_tmp2_ = _ ("GNOME Games web site");
	gtk_about_dialog_set_website_label (self->priv->about_dialog, _tmp2_);
	gtk_about_dialog_set_logo_icon_name (self->priv->about_dialog, "glchess");
	g_signal_connect ((GtkDialog*) self->priv->about_dialog, "response", (GCallback) _application_about_response_cb_gtk_dialog_response, self);
	gtk_widget_show ((GtkWidget*) self->priv->about_dialog);
}


static void application_about_response_cb (Application* self, gint response_id) {
	g_return_if_fail (self != NULL);
	gtk_widget_destroy ((GtkWidget*) self->priv->about_dialog);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
}


void G_MODULE_EXPORT save_game_as_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_game (self);
}


void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_game (self);
}


static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _info_bar = NULL;
	GtkLabel* _label = NULL;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* vbox;
	GtkInfoBar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkContainer* _tmp3_;
	GtkContainer* content_area;
	GtkLabel* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkContainer* _tmp6_;
	GtkContainer* child;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	vbox = g_object_ref_sink (_tmp0_);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
	_g_object_unref0 (_info_bar);
	_info_bar = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_info_bar_get_content_area (_info_bar);
	_tmp3_ = _g_object_ref0 (GTK_CONTAINER (_tmp2_));
	content_area = _tmp3_;
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _info_bar, FALSE, TRUE, (guint) 0);
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (_label);
	_label = g_object_ref_sink (_tmp4_);
	gtk_container_add (content_area, (GtkWidget*) _label);
	gtk_widget_show ((GtkWidget*) _label);
	_tmp5_ = gtk_bin_get_child ((GtkBin*) dialog);
	_tmp6_ = _g_object_ref0 (GTK_CONTAINER (_tmp5_));
	child = _tmp6_;
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
	_tmp7_ = gtk_container_get_border_width ((GtkContainer*) dialog);
	gtk_container_set_border_width (child, _tmp7_);
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 0);
	gtk_container_add ((GtkContainer*) dialog, (GtkWidget*) vbox);
	_g_object_unref0 (child);
	_g_object_unref0 (content_area);
	_g_object_unref0 (vbox);
	if (info_bar) {
		*info_bar = _info_bar;
	} else {
		_g_object_unref0 (_info_bar);
	}
	if (label) {
		*label = _label;
	} else {
		_g_object_unref0 (_label);
	}
}


static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	application_save_file_cb (self);
}


static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_save_cb (self, response_id);
}


static void application_save_game (Application* self) {
	const gchar* _tmp0_ = NULL;
	GtkFileChooserDialog* _tmp1_ = NULL;
	GtkInfoBar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	GtkFileFilter* pgn_filter;
	const gchar* _tmp5_ = NULL;
	GtkFileFilter* _tmp6_ = NULL;
	GtkFileFilter* all_filter;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->save_dialog != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->save_dialog);
		return;
	}
	_tmp0_ = _ ("Save Chess Game");
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, self->priv->window, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_OK, NULL, NULL);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = g_object_ref_sink (_tmp1_);
	application_add_info_bar_to_dialog (self, (GtkDialog*) self->priv->save_dialog, &_tmp2_, &_tmp3_);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = _tmp2_;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = _tmp3_;
	g_signal_connect ((GtkFileChooser*) self->priv->save_dialog, "file-activated", (GCallback) _application_save_file_cb_gtk_file_chooser_file_activated, self);
	g_signal_connect ((GtkDialog*) self->priv->save_dialog, "response", (GCallback) _application_save_cb_gtk_dialog_response, self);
	_tmp4_ = gtk_file_filter_new ();
	pgn_filter = g_object_ref_sink (_tmp4_);
	_tmp5_ = _ ("PGN files");
	gtk_file_filter_set_name (pgn_filter, _tmp5_);
	gtk_file_filter_add_pattern (pgn_filter, "*.pgn");
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->save_dialog, pgn_filter);
	_tmp6_ = gtk_file_filter_new ();
	all_filter = g_object_ref_sink (_tmp6_);
	_tmp7_ = _ ("All files");
	gtk_file_filter_set_name (all_filter, _tmp7_);
	gtk_file_filter_add_pattern (all_filter, "*");
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->save_dialog, all_filter);
	gtk_window_present ((GtkWindow*) self->priv->save_dialog);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void application_save_file_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_save_cb (self, (gint) GTK_RESPONSE_OK);
}


static void application_save_cb (Application* self, gint response_id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		gtk_widget_set_sensitive (self->priv->save_menu, FALSE);
		{
			GFile* _tmp0_ = NULL;
			_tmp0_ = gtk_file_chooser_get_file ((GtkFileChooser*) self->priv->save_dialog);
			pgn_game_write (self->priv->pgn_game, _tmp0_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = _ ("Failed to save game: %s");
			_tmp2_ = g_strdup_printf (_tmp1_, e->message);
			_tmp3_ = _tmp2_;
			gtk_label_set_text (self->priv->save_dialog_error_label, _tmp3_);
			_g_free0 (_tmp3_);
			gtk_info_bar_set_message_type (self->priv->save_dialog_info_bar, GTK_MESSAGE_ERROR);
			gtk_widget_show ((GtkWidget*) self->priv->save_dialog_info_bar);
			_g_error_free0 (e);
			return;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	gtk_widget_destroy ((GtkWidget*) self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = NULL;
}


static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	application_open_file_cb (self);
}


static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_open_cb (self, response_id);
}


void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self) {
	const gchar* _tmp0_ = NULL;
	GtkFileChooserDialog* _tmp1_ = NULL;
	GtkInfoBar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	GtkFileFilter* pgn_filter;
	const gchar* _tmp5_ = NULL;
	GtkFileFilter* _tmp6_ = NULL;
	GtkFileFilter* all_filter;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->open_dialog != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->open_dialog);
		return;
	}
	_tmp0_ = _ ("Load Chess Game");
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, self->priv->window, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL, NULL);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = g_object_ref_sink (_tmp1_);
	application_add_info_bar_to_dialog (self, (GtkDialog*) self->priv->open_dialog, &_tmp2_, &_tmp3_);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = _tmp2_;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = _tmp3_;
	g_signal_connect ((GtkFileChooser*) self->priv->open_dialog, "file-activated", (GCallback) _application_open_file_cb_gtk_file_chooser_file_activated, self);
	g_signal_connect ((GtkDialog*) self->priv->open_dialog, "response", (GCallback) _application_open_cb_gtk_dialog_response, self);
	_tmp4_ = gtk_file_filter_new ();
	pgn_filter = g_object_ref_sink (_tmp4_);
	_tmp5_ = _ ("PGN files");
	gtk_file_filter_set_name (pgn_filter, _tmp5_);
	gtk_file_filter_add_pattern (pgn_filter, "*.pgn");
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->open_dialog, pgn_filter);
	_tmp6_ = gtk_file_filter_new ();
	all_filter = g_object_ref_sink (_tmp6_);
	_tmp7_ = _ ("All files");
	gtk_file_filter_set_name (all_filter, _tmp7_);
	gtk_file_filter_add_pattern (all_filter, "*");
	gtk_file_chooser_add_filter ((GtkFileChooser*) self->priv->open_dialog, all_filter);
	gtk_window_present ((GtkWindow*) self->priv->open_dialog);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void application_open_file_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_open_cb (self, (gint) GTK_RESPONSE_OK);
}


static void application_open_cb (Application* self, gint response_id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		{
			GFile* _tmp0_ = NULL;
			_tmp0_ = gtk_file_chooser_get_file ((GtkFileChooser*) self->priv->open_dialog);
			application_load_game (self, _tmp0_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = _ ("Failed to open game: %s");
			_tmp2_ = g_strdup_printf (_tmp1_, e->message);
			_tmp3_ = _tmp2_;
			gtk_label_set_text (self->priv->open_dialog_error_label, _tmp3_);
			_g_free0 (_tmp3_);
			gtk_info_bar_set_message_type (self->priv->open_dialog_info_bar, GTK_MESSAGE_ERROR);
			gtk_widget_show ((GtkWidget*) self->priv->open_dialog_info_bar);
			_g_error_free0 (e);
			return;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	gtk_widget_destroy ((GtkWidget*) self->priv->open_dialog);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = NULL;
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = NULL;
}


static void application_start_new_game (Application* self) {
	PGNGame* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* now;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	gint duration;
	gchar* _tmp9_ = NULL;
	gchar* engine_name;
	gchar* _tmp10_ = NULL;
	gchar* engine_level;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->in_history = TRUE;
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	_tmp0_ = pgn_game_new ();
	_pgn_game_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = g_date_time_format (now, "%Y.%m.%d");
	_tmp3_ = _tmp2_;
	pgn_game_set_date (self->priv->pgn_game, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_date_time_format (now, "%H:%M:%S");
	_tmp5_ = _tmp4_;
	pgn_game_set_time (self->priv->pgn_game, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = g_settings_get_int (self->priv->settings, "duration");
	duration = _tmp6_;
	if (duration > 0) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp7_ = g_strdup_printf ("%d", duration);
		_tmp8_ = _tmp7_;
		pgn_game_set_time_control (self->priv->pgn_game, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_tmp9_ = g_settings_get_string (self->priv->settings, "opponent");
	engine_name = _tmp9_;
	_tmp10_ = g_settings_get_string (self->priv->settings, "difficulty");
	engine_level = _tmp10_;
	if (engine_name != NULL) {
		_tmp11_ = g_strcmp0 (engine_name, "human") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp12_;
		_tmp12_ = g_settings_get_boolean (self->priv->settings, "play-as-white");
		if (_tmp12_) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp13_ = g_strdup ("BlackAI");
			_tmp14_ = g_strdup (engine_name);
			g_hash_table_insert (self->priv->pgn_game->tags, _tmp13_, _tmp14_);
			_tmp15_ = g_strdup ("BlackLevel");
			_tmp16_ = g_strdup (engine_level);
			g_hash_table_insert (self->priv->pgn_game->tags, _tmp15_, _tmp16_);
		} else {
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp17_ = g_strdup ("WhiteAI");
			_tmp18_ = g_strdup (engine_name);
			g_hash_table_insert (self->priv->pgn_game->tags, _tmp17_, _tmp18_);
			_tmp19_ = g_strdup ("WhiteLevel");
			_tmp20_ = g_strdup (engine_level);
			g_hash_table_insert (self->priv->pgn_game->tags, _tmp19_, _tmp20_);
		}
	}
	application_start_game (self);
	_g_free0 (engine_level);
	_g_free0 (engine_name);
	_g_date_time_unref0 (now);
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static void application_load_game (Application* self, GFile* file, gboolean from_history, GError** error) {
	PGN* _tmp0_ = NULL;
	PGN* pgn;
	gconstpointer _tmp1_ = NULL;
	PGNGame* _tmp2_;
	GFile* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = pgn_new_from_file (file, &_inner_error_);
	pgn = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = g_list_nth_data (pgn->games, (guint) 0);
	_tmp2_ = _pgn_game_ref0 ((PGNGame*) _tmp1_);
	_pgn_game_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp2_;
	_tmp3_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp3_;
	self->priv->in_history = from_history;
	application_start_game (self);
	_pgn_unref0 (pgn);
}


static void value_application_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_application_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		application_unref (value->data[0].v_pointer);
	}
}


static void value_application_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = application_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_application_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_application_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Application* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = application_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_application_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Application** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = application_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecApplication* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APPLICATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_application (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_application (GValue* value, gpointer v_object) {
	Application* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		application_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}


void value_take_application (GValue* value, gpointer v_object) {
	Application* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APPLICATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APPLICATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		application_unref (old);
	}
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	APPLICATION_CLASS (klass)->finalize = application_finalize;
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->save_duration_timeout = (guint) 0;
	self->priv->open_dialog = NULL;
	self->priv->open_dialog_info_bar = NULL;
	self->priv->open_dialog_error_label = NULL;
	self->priv->save_dialog = NULL;
	self->priv->save_dialog_info_bar = NULL;
	self->priv->save_dialog_error_label = NULL;
	self->priv->about_dialog = NULL;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
	self->ref_count = 1;
}


static void application_finalize (Application* obj) {
	Application * self;
	self = APPLICATION (obj);
	_g_object_unref0 (self->priv->settings);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->preferences_builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->save_menu);
	_g_object_unref0 (self->priv->save_as_menu);
	_g_object_unref0 (self->priv->fullscreen_menu);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_title_label);
	_g_object_unref0 (self->priv->info_label);
	_g_object_unref0 (self->priv->view_container);
	_g_object_unref0 (self->priv->scene);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->undo_menu);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->resign_menu);
	_g_object_unref0 (self->priv->resign_button);
	_g_object_unref0 (self->priv->first_move_button);
	_g_object_unref0 (self->priv->prev_move_button);
	_g_object_unref0 (self->priv->next_move_button);
	_g_object_unref0 (self->priv->last_move_button);
	_g_object_unref0 (self->priv->history_combo);
	_g_object_unref0 (self->priv->white_time_label);
	_g_object_unref0 (self->priv->black_time_label);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->duration_combo);
	_g_object_unref0 (self->priv->duration_adjustment);
	_g_object_unref0 (self->priv->custom_duration_box);
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	_g_object_unref0 (self->priv->open_dialog_error_label);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	_g_object_unref0 (self->priv->save_dialog_error_label);
	_g_object_unref0 (self->priv->about_dialog);
	_pgn_game_unref0 (self->priv->pgn_game);
	_chess_game_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->game_file);
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_application_init, value_application_free_value, value_application_copy_value, value_application_peek_pointer, "p", value_application_collect_value, "p", value_application_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType application_type_id;
		application_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Application", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gpointer application_ref (gpointer instance) {
	Application* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void application_unref (gpointer instance) {
	Application* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APPLICATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint gl_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	GFile* game_file;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* c;
	GOptionGroup* _tmp2_ = NULL;
	Application* _tmp5_ = NULL;
	Application* app;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	game_file = NULL;
	_tmp0_ = _ ("[FILE] - Play Chess");
	_tmp1_ = g_option_context_new (_tmp0_);
	c = _tmp1_;
	g_option_context_add_main_entries (c, GL_CHESS_options, GETTEXT_PACKAGE);
	_tmp2_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (c, _tmp2_);
	{
		g_option_context_parse (c, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_tmp3_ = _ ("Run '%s --help' to see a full list of available command line options.");
		fprintf (stderr, _tmp3_, args[0]);
		fprintf (stderr, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (gl_chess_show_version) {
		fprintf (stderr, "glchess %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		return result;
	}
	if (args_length1 > 1) {
		GFile* _tmp4_ = NULL;
		_tmp4_ = g_file_new_for_path (args[1]);
		_g_object_unref0 (game_file);
		game_file = _tmp4_;
	}
	_tmp5_ = application_new ();
	app = _tmp5_;
	{
		application_start (app, game_file, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = g_file_get_path (game_file);
		_tmp7_ = _tmp6_;
		fprintf (stderr, "Failed to load %s: %s\n", _tmp7_, e->message);
		_g_free0 (_tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_application_unref0 (app);
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_application_unref0 (app);
		_g_option_context_free0 (c);
		_g_object_unref0 (game_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_main ();
	result = EXIT_SUCCESS;
	_application_unref0 (app);
	_g_option_context_free0 (c);
	_g_object_unref0 (game_file);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gl_chess_main (argv, argc);
}


GlChess* gl_chess_construct (GType object_type) {
	GlChess* self = NULL;
	self = (GlChess*) g_type_create_instance (object_type);
	return self;
}


GlChess* gl_chess_new (void) {
	return gl_chess_construct (TYPE_GL_CHESS);
}


static void value_gl_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gl_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gl_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gl_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gl_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gl_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gl_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GlChess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gl_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gl_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GlChess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gl_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGlChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GL_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gl_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gl_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


void value_take_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


static void gl_chess_class_init (GlChessClass * klass) {
	gl_chess_parent_class = g_type_class_peek_parent (klass);
	GL_CHESS_CLASS (klass)->finalize = gl_chess_finalize;
}


static void gl_chess_instance_init (GlChess * self) {
	self->ref_count = 1;
}


static void gl_chess_finalize (GlChess* obj) {
	GlChess * self;
	self = GL_CHESS (obj);
}


GType gl_chess_get_type (void) {
	static volatile gsize gl_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gl_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gl_chess_init, value_gl_chess_free_value, value_gl_chess_copy_value, value_gl_chess_peek_pointer, "p", value_gl_chess_collect_value, "p", value_gl_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GlChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gl_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlChess), 0, (GInstanceInitFunc) gl_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gl_chess_type_id;
		gl_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GlChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gl_chess_type_id__volatile, gl_chess_type_id);
	}
	return gl_chess_type_id__volatile;
}


gpointer gl_chess_ref (gpointer instance) {
	GlChess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gl_chess_unref (gpointer instance) {
	GlChess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GL_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



