/* GNOME DB library
 * Copyright (C), 1999-2001 The Free Software Foundation
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gnome-db-table-editor.h"

struct _GnomeDbTableEditorPrivate {
	GList *fields;
};

static void gnome_db_table_editor_class_init (GnomeDbTableEditorClass *klass);
static void gnome_db_table_editor_init       (GnomeDbTableEditor *editor);
static void gnome_db_table_editor_destroy    (GtkObject *object);

/*
 * GnomeDbTableEditor class implementation
 */
static void
gnome_db_table_editor_class_init (GnomeDbTableEditorClass *klass)
{
	GtkObjectClass *object_class = GTK_OBJECT_CLASS (klass);

	object_class->destroy = gnome_db_table_editor_destroy;
}

static void
gnome_db_table_editor_init (GnomeDbTableEditor *editor)
{
	editor->priv = g_new0 (GnomeDbTableEditorPrivate, 1);
}

GtkType
gnome_db_table_editor_get_type (void)
{
	static GtkType type = 0;
	
	if (!type) {
		GtkTypeInfo info = {
			"GnomeDbTableEditor",
			sizeof (GnomeDbTableEditor),
			sizeof (GnomeDbTableEditorClass),
			(GtkClassInitFunc) gnome_db_table_editor_class_init,
			(GtkObjectInitFunc) gnome_db_table_editor_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL
		};
		type = gtk_type_unique (gtk_vbox_get_type(), &info);
	}
	return type;
}

/**
 * gnome_db_table_editor_new
 */
GtkWidget *
gnome_db_table_editor_new (void)
{
	GnomeDbTableEditor *editor;

	editor = GNOME_DB_TABLE_EDITOR (gtk_type_new (GNOME_DB_TYPE_TABLE_EDITOR));
	return GTK_WIDGET (editor);
}

static void
gnome_db_table_editor_destroy (GtkObject *object)
{
	GtkObjectClass *parent_class;
	GnomeDbTableEditor *editor = GNOME_DB_TABLE_EDITOR (object);

	g_return_if_fail (GNOME_DB_IS_TABLE_EDITOR (editor));

	/* free memory */
	g_free (editor->priv);

	parent_class = gtk_type_class (gtk_vbox_get_type ());
	if (parent_class && parent_class->destroy)
		parent_class->destroy (object);
}

/**
 * gnome_db_table_editor_new_from_connection
 */
GtkWidget *
gnome_db_table_editor_new_from_connection (GdaConnection *cnc, const gchar *table)
{
	GnomeDbTableEditor *editor;

	editor = GNOME_DB_TABLE_EDITOR (gnome_db_table_editor_new ());
	gnome_db_table_editor_from_connection (editor, cnc, table);

	return GTK_WIDGET (editor);
}

/**
 * gnome_db_table_editor_from_connection
 */
void
gnome_db_table_editor_from_connection (GnomeDbTableEditor *editor,
				       GdaConnection *cnc,
				       const gchar *table)
{
	g_return_if_fail (GNOME_DB_IS_TABLE_EDITOR (editor));
}
