#-*- mode: Fundamental; tab-width: 4; -*-
# ex:ts=4
# $Id: gar.conf.mk.in,v 1.6 2006/03/08 22:48:12 bobk Exp $

# This file contains configuration variables that are global to
# the GAR system.  Users wishing to make a change on a
# per-package basis should edit the category/package/Makefile, or
# specify environment variables on the make command-line.

# Variables that define the default *actions* (rather than just
# default data) of the system will remain in bbc.gar.mk
# (bbc.port.mk)

# Setting this variable will cause the results of your builds to
# be cleaned out after being installed.  Uncomment only if you
# desire this behavior!

# export BUILD_CLEAN = true

# Setting this variable will cause the build to be performed unattended,
# not asking for root permissions where needed. This means, those packages
# and packages depending on them will not be built. Uncomment only if you
# desire this behavior!

# export UNATTENDED = true

# The GARCHIVEDIR is a directory containing cached files. It can be created
# manually, or with 'make garchive' once you've started downloading required
# files (say with 'make paranoid-checksum'. Example:

#GARCHIVEDIR = /home/gnome/download

# These are the standard directory name variables from all GNU
# makefiles.  They're also used by autoconf, and can be adapted
# for a variety of build systems.
# 
# TODO: set $(SYSCONFDIR) and $(LOCALSTATEDIR) to never use
# /usr/etc or /usr/var

DESTIMG ?= main

# Directory config for the "main" image
main_prefix ?= $(HOME)/garnome
main_exec_prefix = $(main_prefix)
main_bindir = $(main_exec_prefix)/bin
main_sbindir = $(main_exec_prefix)/sbin
main_libexecdir = $(main_exec_prefix)/libexec
main_datadir = $(main_prefix)/share
main_sysconfdir = $(main_prefix)/etc
main_sharedstatedir = $(main_prefix)/share
main_localstatedir = $(main_prefix)/var
main_libdir = $(main_exec_prefix)/lib
main_infodir = $(main_prefix)/info
main_lispdir = $(main_prefix)/share/emacs/site-lisp
main_includedir = $(main_prefix)/include
main_mandir = $(main_prefix)/man
main_docdir = $(main_prefix)/share/doc
main_sourcedir = $(main_prefix)/src
main_licensedir = $(main_prefix)/licenses

prefix = $($(DESTIMG)_prefix)
exec_prefix = $($(DESTIMG)_exec_prefix)
bindir = $($(DESTIMG)_bindir)
sbindir = $($(DESTIMG)_sbindir)
libexecdir = $($(DESTIMG)_libexecdir)
datadir = $($(DESTIMG)_datadir)
sysconfdir = $($(DESTIMG)_sysconfdir)
sharedstatedir = $($(DESTIMG)_sharedstatedir)
localstatedir = $($(DESTIMG)_localstatedir)
libdir = $($(DESTIMG)_libdir)
infodir = $($(DESTIMG)_infodir)
lispdir = $($(DESTIMG)_lispdir)
includedir = $($(DESTIMG)_includedir)
mandir = $($(DESTIMG)_mandir)
docdir = $($(DESTIMG)_docdir)
sourcedir = $($(DESTIMG)_sourcedir)
licensedir = $($(DESTIMG)_licensedir)

# the DESTDIR is used at INSTALL TIME ONLY to determine what the
# filesystem root should be.  Each different DESTIMG has its own
# DESTDIR.
main_DESTDIR ?=

DESTDIR = $(main_DESTDIR)

BUILD_PREFIX ?= $(prefix)

# allow us to link to libraries we installed
CPPFLAGS += -I$(includedir)
CFLAGS += -I$(includedir) -L$(libdir)
LDFLAGS += -Wl,--export-dynamic -L$(libdir)

# allow us to find possibly installed autofoo
ACLOCAL_FLAGS += -I $(datadir)/aclocal
ACLOCAL_AMFLAGS += -I $(datadir)/aclocal

# allow us to use programs we just built
PATH := $(bindir):$(sbindir):$(PATH)
LD_LIBRARY_PATH := $(libdir):$(LD_LIBRARY_PATH)

# This is for pkgconfig-foo (GNOME 2.4 and later)
PKG_CONFIG := $(bindir)/pkg-config
PKG_CONFIG_PATH := $(libdir)/pkg-config:$(libdir)/pkgconfig:$(datadir)/pkgconfig:/usr/lib64/pkgconfig:/usr/lib/pkgconfig

# If you want to use a different version of python everywhere
# change this
PYTHON = $(shell which python)
PYVER = $(shell $(PYTHON) -c "import sys; print sys.version[:3]")
PYTHONPATH=$(main_libdir)/python$(PYVER)/site-packages:$(main_libdir)/python$(PYVER)/site-packages/gtk-2.0

# This is required by gnome-common from bootstrap (GNOME 2.8 and later)
GNOME2_PATH := $(main_prefix)

# This is for xdg-foo (GNOME 2.10 and later)
XDG_DATA_DIRS := $(datadir):/usr/share

# Sensible compiler defaults
CC ?= gcc
CXX ?= g++

# Sensible optimization defaults
CFLAGS += -O2 -pipe

# Non-Linux/BSD users should explicitly use GNU bash as
# the default shell
#SHELL = bash

# On some systems 'md5sum' may not be correctly located, making
# any checksum attempts fail
MD5 = $(shell which md5sum)

# Let's see if we can get gtk-doc going 100%
XML_CATALOG_FILES += $(DESTDIR)$(sysconfdir)/xml/catalog

# GNOME CVS root if we need it
GNOMECVSROOT = ":pserver:anonymous@anoncvs.gnome.org:/cvs/gnome"

#
# [crack approaching] things below this line are only to be set if you know
# what you are doing. If you have any doubts about your abilities to compile
# software from scratch, please read the GARNOME README file, or join our
# IRC channel and _ask_ questions first.
#

# Fine tuned (read: insane) optimisations

# Explicit optimization defaults
# Intel Pentium Pro and above
#CFLAGS += -march=pentiumpro
# iBook
#CFLAGS += -march=750
# Athlon-XP
#CFLAGS += -march=athlon-xp -m3dnow

# ccache support -- if you would like to speed up your GARNOME build
# at the expense of disc space, uncomment this option.
#CC := ccache $(CC)
#CXX := ccache $(CXX)

# Equalise CFLAGS and CXXFLAGS
CXXFLAGS := $(CFLAGS)

# Put these variables in the environment during the
# configure build and install stages
STAGE_EXPORTS = DESTDIR prefix exec_prefix bindir sbindir libexecdir datadir
STAGE_EXPORTS += sysconfdir sharedstatedir localstatedir libdir infodir lispdir
STAGE_EXPORTS += includedir mandir docdir sourcedir
STAGE_EXPORTS += CPPFLAGS CFLAGS CXXFLAGS LDFLAGS ACLOCAL_FLAGS ACLOCAL_AMFLAGS
STAGE_EXPORTS += CC CXX PYTHON PYTHONPATH

CONFIGURE_ENV += $(foreach TTT,$(STAGE_EXPORTS),$(TTT)="$($(TTT))")
BUILD_ENV += $(foreach TTT,$(STAGE_EXPORTS),$(TTT)="$($(TTT))")
INSTALL_ENV += $(foreach TTT,$(STAGE_EXPORTS),$(TTT)="$($(TTT))")
MANIFEST_ENV += $(foreach TTT,$(STAGE_EXPORTS),$(TTT)="$($(TTT))")

# Global environment
export SHELL
export PATH LD_LIBRARY_PATH PKG_CONFIG_PATH GNOME2_PATH
export XDG_DATA_DIRS XML_CATALOG_FILES GNOMECVSROOT

# prepend the local file listing
FILE_SITES = file://$(FILEDIR)/ file://$(GARCHIVEDIR)/

# Extra libs to include with gar.mk
#EXTRA_LIBS = 
