/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_ScaledFont
#define _Included_org_freedesktop_cairo_ScaledFont
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_ScaledFont
 * Method:    cairo_scaled_font_create
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_ScaledFont_cairo_1scaled_1font_1create
  (JNIEnv *env, jclass cls, jobject face, jobject matrix, jobject ctm, jobject options)
{
	cairo_font_face_t *face_g;
	cairo_matrix_t *matrix_g;
	cairo_matrix_t *ctm_g;
	cairo_scaled_font_t *sf;
	cairo_font_options_t *options_g;
	
	face_g = (cairo_font_face_t*)getPointerFromHandle(env, face);
	matrix_g = (cairo_matrix_t*)getPointerFromHandle(env, matrix);
	ctm_g = (cairo_matrix_t*)getPointerFromHandle(env, ctm);
	options_g = (cairo_font_options_t*)getPointerFromHandle(env, options);
	
	sf = cairo_scaled_font_create(face_g, matrix_g, ctm_g, options_g);

	return getHandleFromPointer(env, sf); 
}

/*
 * Class:     org_freedesktop_cairo_ScaledFont
 * Method:    cairo_scaled_font_extents
 * Signature: (Lorg/gnu/glib/Handle;Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_ScaledFont_cairo_1scaled_1font_1extents
  (JNIEnv *env, jclass cls, jobject sfont, jobject ext)
{
	cairo_scaled_font_t *sfont_g = (cairo_scaled_font_t*)getPointerFromHandle(env, sfont);
	cairo_font_extents_t* ext_g = g_new(cairo_font_extents_t, 1);
	cairo_scaled_font_extents(sfont_g, ext_g);
	updateHandle(env, ext, ext_g);
}

#ifdef __cplusplus
}
#endif
#endif
