/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 */
public class Extend extends Enum {

	static final private int _NONE = 0;
    static final public Extend NONE = new Extend (_NONE);
    static final private int _REPEAT = 1;
    static final public Extend REPEAT = new Extend (_REPEAT);
    static final private int _REFLECT = 2;
    static final public Extend REFLECT = new Extend (_REFLECT);
    static final private Extend[] theInterned = new Extend[] {
    	NONE, REPEAT, REFLECT
    };
    static private java.util.Hashtable theInternedExtras;
    static final private Extend theSacrificialOne = new Extend (0);
    static public Extend intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Extend already = (Extend) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Extend(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Extend(int value) {
        value_ = value;
    }

    public boolean test (Extend other) {
        return (value_ & other.value_) == other.value_;
    }
}
