/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class Content extends Enum {

    static final private int _COLOR = 0x1000;
    static final public Content COLOR = new Content (_COLOR);
    static final private int _ALPHA = 0x2000;
    static final public Content ALPHA = new Content (_ALPHA);
    static final private int _COLOR_ALPHA = 0x3000;
    static final public Content COLOR_ALPHA = new Content (_COLOR_ALPHA);

    static final private Content[] theInterned = new Content[] {
        COLOR, ALPHA, COLOR_ALPHA 
    };
    static private java.util.Hashtable theInternedExtras;
    static final private Content theSacrificialOne = new Content (0);
    static public Content intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Content already = (Content) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Content(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Content(int value) {
        value_ = value;
    }

    public boolean test (Content other) {
        return (value_ & other.value_) == other.value_;
    }

}
