// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/style.h>
#include <gtkmm/private/style_p.h>

// -*- c++ -*-
/* $Id: style.ccg,v 1.1.1.1 2003/01/21 13:40:39 murrayc Exp $ */

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/rc.h>
#include <gtk/gtkstyle.h>


namespace Gtk
{

/* 
Design notes:

Okay these are my notes on how a GtkStyle works.
They are not meant to be taken as documentation as I didn't
write the code.  

styles keeps a copy of itself for each color depth.  Thus
changing a style after it has been attached wont work!

At allocation time a Gtk Style has 
  - all GC set to 0 as they will be allocated later
  - has all color values set to default values.
  - a ref count of 1 and an attach count of 0 (floating?)
  - a properly referenced font.
  - colormap and depth are invalid.
  - The style list and rcstyle are 0. (??? styles wasn't set explicitly!)

It returns to this state if the style is detatched from
all widgets.

Attach acts to sink the object removing it from the floating state.

attaching a style for the first time initializes it. 
Initializing a style
  - sets the colormap and depth.
  - sets the mid colors. (thus allowing user to set these would be pointless)
  - gets black and white from the colormap.
  - allocates all the colors.
  - uses gtk_gc_get to share a gc if there is a matching one.

Conclusions, we need to rework the concept of Gdk to allow
for const objects.  

*/

void Style::set_font(const Pango::FontDescription& font_desc)
{
  g_return_if_fail(font_desc.gobj() != 0);

  // It will be freed when it goes out of scope.
  const Pango::FontDescription fontBefore (gobj()->font_desc, false);

  gobj()->font_desc = font_desc.gobj_copy();
}

Pango::FontDescription Style::get_font() const
{
  // Direct struct access seems the only way.
  return Pango::FontDescription(gobj()->font_desc, true); // true = make a copy.
}

Glib::RefPtr<Gdk::GC> Style::get_fg_gc(StateType state_type)
{
  return Glib::wrap(gobj()->fg_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_fg_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->fg_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_bg_gc(StateType state_type)
{
  return Glib::wrap(gobj()->bg_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_bg_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->bg_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_light_gc(StateType state_type)
{
  return Glib::wrap(gobj()->light_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_light_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->light_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_dark_gc(StateType state_type)
{
  return Glib::wrap(gobj()->dark_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_dark_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->dark_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_mid_gc(StateType state_type)
{
  return Glib::wrap(gobj()->mid_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_mid_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->mid_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_text_gc(StateType state_type)
{
  return Glib::wrap(gobj()->text_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_text_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->text_gc[state_type], true);
}

Glib::RefPtr<Gdk::GC> Style::get_base_gc(StateType state_type)
{
  return Glib::wrap(gobj()->base_gc[state_type], true);
}

Glib::RefPtr<const Gdk::GC> Style::get_base_gc(StateType state_type) const
{
  return Glib::wrap(gobj()->base_gc[state_type], true);
}

Gdk::Color Style::get_background(StateType state_type) const
{
  GdkColor* pGdkColor = const_cast<GdkColor*>(&(gobj()->bg[state_type]));
  return Glib::wrap(pGdkColor, true); //true = take_copy.
}

Glib::RefPtr<Gdk::Pixmap> Style::get_background_pixmap(StateType state_type)
{
  return Glib::wrap((GdkPixmapObject*) (gobj()->bg_pixmap[state_type]), true); //true = take_copy.
}

void Style::set_bg_pixmap(StateType state_type, const Glib::RefPtr<Gdk::Pixmap>& pixmap)
{
  GdkPixmap *const old_pixmap = gobj()->bg_pixmap[state_type];
  gobj()->bg_pixmap[state_type] = Glib::unwrap_copy(pixmap);

  if(old_pixmap)
    g_object_unref(old_pixmap);
}

Glib::RefPtr<Gdk::Pixmap> Style::get_bg_pixmap(StateType state_type)
{
  return Glib::wrap((GdkPixmapObject*) (gobj()->bg_pixmap[state_type]), true); // true = take_copy
}

Glib::RefPtr<const Gdk::Pixmap> Style::get_bg_pixmap(StateType state_type) const
{
  return Glib::wrap((GdkPixmapObject*) (gobj()->bg_pixmap[state_type]), true); // true = take_copy
}

void Style::set_xthickness(int xthickness)
{
  gobj()->xthickness = xthickness;
}

void Style::set_ythickness(int ythickness)
{
  gobj()->ythickness = ythickness;
}

void Style::paint_polygon(const Glib::RefPtr<Gdk::Window>&      window,
                          StateType                             state_type,
                          ShadowType                            shadow_type,
                          const Gdk::Rectangle&                 area,
                          Widget&                               widget,
                          const Glib::ustring&                  detail,
                          const Glib::ArrayHandle<Gdk::Point>&  points,
                          bool                                  fill) const
{
  gtk_paint_polygon(
      const_cast<GtkStyle*>(gobj()),
      Glib::unwrap(window),
      (GtkStateType) state_type,
      (GtkShadowType) shadow_type,
      const_cast<GdkRectangle*>(area.gobj()),
      widget.gobj(),
      detail.c_str(),
      reinterpret_cast<GdkPoint*>(const_cast<Gdk::Point*>(points.data())),
      points.size(),
      fill);
}

} // namespace Gtk


namespace
{

const Glib::SignalProxyInfo Style_signal_realize_info =
{
  "realize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Style_signal_unrealize_info =
{
  "unrealize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::Style> wrap(GtkStyle* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::Style>( dynamic_cast<Gtk::Style*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Style_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Style_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_style_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Style_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->realize = &realize_vfunc_callback;
  klass->unrealize = &unrealize_vfunc_callback;
  klass->copy = &copy_vfunc_callback;
  klass->clone = &clone_vfunc_callback;
  klass->init_from_rc = &init_from_rc_vfunc_callback;
  klass->set_background = &set_background_vfunc_callback;
  klass->render_icon = &render_icon_vfunc_callback;
  klass->draw_hline = &draw_hline_vfunc_callback;
  klass->draw_vline = &draw_vline_vfunc_callback;
  klass->draw_shadow = &draw_shadow_vfunc_callback;
  klass->draw_polygon = &draw_polygon_vfunc_callback;
  klass->draw_arrow = &draw_arrow_vfunc_callback;
  klass->draw_diamond = &draw_diamond_vfunc_callback;
  klass->draw_string = &draw_string_vfunc_callback;
  klass->draw_box = &draw_box_vfunc_callback;
  klass->draw_flat_box = &draw_flat_box_vfunc_callback;
  klass->draw_check = &draw_check_vfunc_callback;
  klass->draw_option = &draw_option_vfunc_callback;
  klass->draw_tab = &draw_tab_vfunc_callback;
  klass->draw_shadow_gap = &draw_shadow_gap_vfunc_callback;
  klass->draw_box_gap = &draw_box_gap_vfunc_callback;
  klass->draw_extension = &draw_extension_vfunc_callback;
  klass->draw_focus = &draw_focus_vfunc_callback;
  klass->draw_slider = &draw_slider_vfunc_callback;
  klass->draw_handle = &draw_handle_vfunc_callback;
  klass->draw_expander = &draw_expander_vfunc_callback;
  klass->draw_layout = &draw_layout_vfunc_callback;
  klass->draw_resize_grip = &draw_resize_grip_vfunc_callback;
  klass->realize = &realize_callback;
  klass->unrealize = &unrealize_callback;
}

void Style_Class::realize_vfunc_callback(GtkStyle* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->realize_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->realize)
      (*base->realize)(self);
  }
}

void Style_Class::unrealize_vfunc_callback(GtkStyle* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->unrealize_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->unrealize)
      (*base->unrealize)(self);
  }
}

void Style_Class::copy_vfunc_callback(GtkStyle* self, GtkStyle* src)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->copy_vfunc(Glib::wrap(src, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->copy)
      (*base->copy)(self, src);
  }
}

GtkStyle* Style_Class::clone_vfunc_callback(GtkStyle* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return Glib::unwrap(obj->clone_vfunc());
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->clone)
      return (*base->clone)(self);
  }

  typedef GtkStyle* RType;
  return RType();
}

void Style_Class::init_from_rc_vfunc_callback(GtkStyle* self, GtkRcStyle* rc_style)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->init_from_rc_vfunc(Glib::wrap(rc_style)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->init_from_rc)
      (*base->init_from_rc)(self, rc_style);
  }
}

void Style_Class::set_background_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->set_background_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->set_background)
      (*base->set_background)(self, window, state_type);
  }
}

GdkPixbuf* Style_Class::render_icon_vfunc_callback(GtkStyle* self, const GtkIconSource* source, GtkTextDirection direction, GtkStateType state, GtkIconSize size, GtkWidget* widget, const gchar* detail)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return Glib::unwrap(obj->render_icon_vfunc(Glib::wrap(const_cast<GtkIconSource*>(source), true)
, ((TextDirection)(direction))
, ((Gtk::StateType)(state))
, IconSize(static_cast<int>(size))
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->render_icon)
      return (*base->render_icon)(self, source, direction, state, size, widget, detail);
  }

  typedef GdkPixbuf* RType;
  return RType();
}

void Style_Class::draw_hline_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x1, gint x2, gint y)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_hline_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x1
, x2
, y
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_hline)
      (*base->draw_hline)(self, window, state_type, area, widget, detail, x1, x2, y);
  }
}

void Style_Class::draw_vline_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint y1, gint y2, gint x)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_vline_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, y1
, y2
, x
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_vline)
      (*base->draw_vline)(self, window, state_type, area, widget, detail, y1, y2, x);
  }
}

void Style_Class::draw_shadow_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_shadow_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_shadow)
      (*base->draw_shadow)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_polygon_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, GdkPoint* point, gint npoints, gboolean fill)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_polygon_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, point, npoints
, fill
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_polygon)
      (*base->draw_polygon)(self, window, state_type, shadow_type, area, widget, detail, point, npoints, fill);
  }
}

void Style_Class::draw_arrow_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, GtkArrowType arrow_type, gboolean fill, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_arrow_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, ((Gtk::ArrowType)(arrow_type))
, fill
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_arrow)
      (*base->draw_arrow)(self, window, state_type, shadow_type, area, widget, detail, arrow_type, fill, x, y, width, height);
  }
}

void Style_Class::draw_diamond_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_diamond_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_diamond)
      (*base->draw_diamond)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_string_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, const gchar* string)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_string_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, Glib::convert_const_gchar_ptr_to_ustring(string)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_string)
      (*base->draw_string)(self, window, state_type, area, widget, detail, x, y, string);
  }
}

void Style_Class::draw_box_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_box_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_box)
      (*base->draw_box)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_flat_box_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_flat_box_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_flat_box)
      (*base->draw_flat_box)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_check_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_check_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_check)
      (*base->draw_check)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_option_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_option_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_option)
      (*base->draw_option)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_tab_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_tab_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_tab)
      (*base->draw_tab)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_shadow_gap_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height, GtkPositionType gap_side, gint gap_x, gint gap_width)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_shadow_gap_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
, ((Gtk::PositionType)(gap_side))
, gap_x
, gap_width
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_shadow_gap)
      (*base->draw_shadow_gap)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height, gap_side, gap_x, gap_width);
  }
}

void Style_Class::draw_box_gap_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height, GtkPositionType gap_side, gint gap_x, gint gap_width)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_box_gap_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
, ((Gtk::PositionType)(gap_side))
, gap_x
, gap_width
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_box_gap)
      (*base->draw_box_gap)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height, gap_side, gap_x, gap_width);
  }
}

void Style_Class::draw_extension_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height, GtkPositionType gap_side)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_extension_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
, ((PositionType)(gap_side))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_extension)
      (*base->draw_extension)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height, gap_side);
  }
}

void Style_Class::draw_focus_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_focus_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_focus)
      (*base->draw_focus)(self, window, state_type, area, widget, detail, x, y, width, height);
  }
}

void Style_Class::draw_slider_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height, GtkOrientation orientation)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_slider_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
, ((Orientation)(orientation))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_slider)
      (*base->draw_slider)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height, orientation);
  }
}

void Style_Class::draw_handle_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, gint width, gint height, GtkOrientation orientation)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_handle_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, ((ShadowType)(shadow_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, width
, height
, ((Orientation)(orientation))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_handle)
      (*base->draw_handle)(self, window, state_type, shadow_type, area, widget, detail, x, y, width, height, orientation);
  }
}

void Style_Class::draw_expander_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, GtkExpanderStyle expander_style)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_expander_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, ((ExpanderStyle)(expander_style))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_expander)
      (*base->draw_expander)(self, window, state_type, area, widget, detail, x, y, expander_style);
  }
}

void Style_Class::draw_layout_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, gboolean use_text, GdkRectangle* area, GtkWidget* widget, const gchar* detail, gint x, gint y, PangoLayout* layout)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_layout_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, use_text
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, x
, y
, Glib::wrap(layout)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_layout)
      (*base->draw_layout)(self, window, state_type, use_text, area, widget, detail, x, y, layout);
  }
}

void Style_Class::draw_resize_grip_vfunc_callback(GtkStyle* self, GdkWindow* window, GtkStateType state_type, GdkRectangle* area, GtkWidget* widget, const gchar* detail, GdkWindowEdge edge, gint x, gint y, gint width, gint height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->draw_resize_grip_vfunc(Glib::wrap((GdkWindowObject*)(window), true)
, ((Gtk::StateType)(state_type))
, Glib::wrap(area)
, Glib::wrap(widget)
, Glib::convert_const_gchar_ptr_to_ustring(detail)
, ((Gdk::WindowEdge)(edge))
, x
, y
, width
, height
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->draw_resize_grip)
      (*base->draw_resize_grip)(self, window, state_type, area, widget, detail, edge, x, y, width, height);
  }
}


void Style_Class::realize_callback(GtkStyle* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_realize();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->realize)
      (*base->realize)(self);
  }
}

void Style_Class::unrealize_callback(GtkStyle* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_unrealize();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->unrealize)
      (*base->unrealize)(self);
  }
}


Glib::ObjectBase* Style_Class::wrap_new(GObject* object)
{
  return new Style((GtkStyle*)object);
}


/* The implementation: */

GtkStyle* Style::gobj_copy()
{
  reference();
  return gobj();
}

Style::Style(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Style::Style(GtkStyle* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Style::~Style()
{}


Style::CppClassType Style::style_class_; // initialize static member

GType Style::get_type()
{
  return style_class_.init().get_type();
}

GType Style::get_base_type()
{
  return gtk_style_get_type();
}


Style::Style()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(style_class_.init()))
{
  }

Glib::RefPtr<Style> Style::create()
{
  return Glib::RefPtr<Style>( new Style() );
}
void Style::set_fg(StateType state, const Gdk::Color& color)
{
  gobj()->fg[state] = *color.gobj();
}

Gdk::Color Style::get_fg(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->fg[state]), true);
}

void Style::set_bg(StateType state, const Gdk::Color& color)
{
  gobj()->bg[state] = *color.gobj();
}

Gdk::Color Style::get_bg(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->bg[state]), true);
}

void Style::set_light(StateType state, const Gdk::Color& color)
{
  gobj()->light[state] = *color.gobj();
}

Gdk::Color Style::get_light(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->light[state]), true);
}

void Style::set_dark(StateType state, const Gdk::Color& color)
{
  gobj()->dark[state] = *color.gobj();
}

Gdk::Color Style::get_dark(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->dark[state]), true);
}

void Style::set_mid(StateType state, const Gdk::Color& color)
{
  gobj()->mid[state] = *color.gobj();
}

Gdk::Color Style::get_mid(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->mid[state]), true);
}

void Style::set_text(StateType state, const Gdk::Color& color)
{
  gobj()->text[state] = *color.gobj();
}

Gdk::Color Style::get_text(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->text[state]), true);
}

void Style::set_base(StateType state, const Gdk::Color& color)
{
  gobj()->base[state] = *color.gobj();
}

Gdk::Color Style::get_base(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->base[state]), true);
}

void Style::set_text_aa(StateType state, const Gdk::Color& color)
{
  gobj()->text_aa[state] = *color.gobj();
}

Gdk::Color Style::get_text_aa(StateType state) const
{
  return Gdk::Color(const_cast<GdkColor*>(&gobj()->text_aa[state]), true);
}

 void Style::set_black(const Gdk::Color& value)
{
  gobj()->black = (*(value).gobj());
}
 
 Gdk::Color Style::get_black() const
{
  return Gdk::Color(const_cast<GdkColor*>(&(gobj()->black)), true);
}
 
 void Style::set_white(const Gdk::Color& value)
{
  gobj()->white = (*(value).gobj());
}
 
 Gdk::Color Style::get_white() const
{
  return Gdk::Color(const_cast<GdkColor*>(&(gobj()->white)), true);
}
 
 int Style::get_xthickness() const
{
  return gobj()->xthickness;
}
 
 int Style::get_ythickness() const
{
  return gobj()->ythickness;
}
 
 Glib::RefPtr<Gdk::GC> Style::get_black_gc()
{
  Glib::RefPtr<Gdk::GC> ref_ptr(Glib::wrap(gobj()->black_gc));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::GC> Style::get_black_gc() const
{
  Glib::RefPtr<const Gdk::GC> ref_ptr(Glib::wrap(gobj()->black_gc));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 
 Glib::RefPtr<Gdk::GC> Style::get_white_gc()
{
  Glib::RefPtr<Gdk::GC> ref_ptr(Glib::wrap(gobj()->white_gc));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::GC> Style::get_white_gc() const
{
  Glib::RefPtr<const Gdk::GC> ref_ptr(Glib::wrap(gobj()->white_gc));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 

void Style::paint_arrow(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, ArrowType arrow_type, bool fill, int x, int y, int width, int height) const
{
  gtk_paint_arrow(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), ((GtkArrowType)(arrow_type)), static_cast<int>(fill), x, y, width, height);
}


void Style::paint_box(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_box(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_box_gap(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side, int gap_x, int gap_width) const
{
  gtk_paint_box_gap(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), const_cast<gchar*>(detail.c_str()), x, y, width, height, ((GtkPositionType)(gap_side)), gap_x, gap_width);
}


void Style::paint_check(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_check(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_diamond(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_diamond(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_extension(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side) const
{
  gtk_paint_extension(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), const_cast<gchar*>(detail.c_str()), x, y, width, height, ((GtkPositionType)(gap_side)));
}


void Style::paint_flat_box(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_flat_box(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_focus(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_focus(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_handle(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation) const
{
  gtk_paint_handle(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height, ((GtkOrientation)(orientation)));
}


void Style::paint_hline(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x1, int x2, int y) const
{
  gtk_paint_hline(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x1, x2, y);
}


void Style::paint_option(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_option(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_shadow(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_shadow(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_shadow_gap(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side, int gap_x, int gap_width) const
{
  gtk_paint_shadow_gap(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), const_cast<gchar*>(detail.c_str()), x, y, width, height, ((GtkPositionType)(gap_side)), gap_x, gap_width);
}


void Style::paint_slider(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation) const
{
  gtk_paint_slider(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height, ((GtkOrientation)(orientation)));
}


void Style::paint_tab(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, int width, int height) const
{
  gtk_paint_tab(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), ((GtkShadowType)(shadow_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, width, height);
}


void Style::paint_vline(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int y1, int y2, int x) const
{
  gtk_paint_vline(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), y1, y2, x);
}


void Style::paint_expander(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, ExpanderStyle expander_style) const
{
  gtk_paint_expander(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, ((GtkExpanderStyle)(expander_style)));
}


void Style::paint_layout(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, bool use_text, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, int x, int y, const Glib::RefPtr<Pango::Layout>& layout) const
{
  gtk_paint_layout(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), static_cast<int>(use_text), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), x, y, Glib::unwrap(layout));
}


void Style::paint_resize_grip(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget& widget, const Glib::ustring& detail, Gdk::WindowEdge edge, int x, int y, int width, int height) const
{
  gtk_paint_resize_grip(const_cast<GtkStyle*>(gobj()), Glib::unwrap(window), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), (widget).gobj(), detail.c_str(), ((GdkWindowEdge)(edge)), x, y, width, height);
}


Glib::RefPtr<Style> Style::copy()
{
  return Glib::wrap(gtk_style_copy(gobj()));
}


void Style::set_background(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type)
{
  gtk_style_set_background(gobj(), Glib::unwrap(window), ((GtkStateType)(state_type)));
}


void Style::apply_default_background(const Glib::RefPtr<Gdk::Window>& window, bool set_bg, Gtk::StateType state_type, const Gdk::Rectangle& area, int x, int y, int width, int height)
{
  gtk_style_apply_default_background(gobj(), Glib::unwrap(window), static_cast<int>(set_bg), ((GtkStateType)(state_type)), const_cast<GdkRectangle*>(area.gobj()), x, y, width, height);
}


IconSet Style::lookup_icon_set(const Gtk::StockID& stock_id)
{
  return Glib::wrap(gtk_style_lookup_icon_set(gobj(), (stock_id).get_c_str()));
}


Glib::RefPtr<Gdk::Pixbuf> Style::render_icon(const IconSource& source, Gtk::TextDirection direction, Gtk::StateType state, Gtk::IconSize size, Gtk::Widget& widget, const Glib::ustring& detail)
{
  return Glib::wrap(gtk_style_render_icon(gobj(), (source).gobj(), ((GtkTextDirection)(direction)), ((GtkStateType)(state)), static_cast<GtkIconSize>(int(size)), (widget).gobj(), detail.c_str()));
}


Glib::SignalProxy0< void > Style::signal_realize()
{
  return Glib::SignalProxy0< void >(this, &Style_signal_realize_info);
}

Glib::SignalProxy0< void > Style::signal_unrealize()
{
  return Glib::SignalProxy0< void >(this, &Style_signal_unrealize_info);
}


void Gtk::Style::on_realize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->realize)
    (*base->realize)(gobj());
}

void Gtk::Style::on_unrealize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unrealize)
    (*base->unrealize)(gobj());
}


void Gtk::Style::realize_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->realize)
    (*base->realize)(gobj());
}

void Gtk::Style::unrealize_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unrealize)
    (*base->unrealize)(gobj());
}

void Gtk::Style::copy_vfunc(const Glib::RefPtr<Style>& src) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->copy)
    (*base->copy)(gobj(),Glib::unwrap(src));
}

Glib::RefPtr<Style> Gtk::Style::clone_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->clone)
    return Glib::wrap((*base->clone)(gobj()));

  typedef Glib::RefPtr<Style> RType;
  return RType();
}

void Gtk::Style::init_from_rc_vfunc(const Glib::RefPtr<RcStyle>& rc_style) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->init_from_rc)
    (*base->init_from_rc)(gobj(),Glib::unwrap(rc_style));
}

void Gtk::Style::set_background_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_background)
    (*base->set_background)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)));
}

Glib::RefPtr<Gdk::Pixbuf> Gtk::Style::render_icon_vfunc(const IconSource& source, TextDirection direction, Gtk::StateType state, IconSize size, Widget* widget, const Glib::ustring& detail) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->render_icon)
    return Glib::wrap((*base->render_icon)(gobj(),(source).gobj(),((GtkTextDirection)(direction)),((GtkStateType)(state)),static_cast<GtkIconSize>(int(size)),(GtkWidget*)Glib::unwrap(widget),detail.c_str()));

  typedef Glib::RefPtr<Gdk::Pixbuf> RType;
  return RType();
}

void Gtk::Style::draw_hline_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x1, int x2, int y) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_hline)
    (*base->draw_hline)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x1,x2,y);
}

void Gtk::Style::draw_vline_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int y1, int y2, int x) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_vline)
    (*base->draw_vline)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),y1,y2,x);
}

void Gtk::Style::draw_shadow_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_shadow)
    (*base->draw_shadow)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_polygon_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, GdkPoint* point, int npoints, bool fill) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_polygon)
    (*base->draw_polygon)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),point,npoints,static_cast<int>(fill));
}

void Gtk::Style::draw_arrow_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, Gtk::ArrowType arrow_type, bool fill, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_arrow)
    (*base->draw_arrow)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),((GtkArrowType)(arrow_type)),static_cast<int>(fill),x,y,width,height);
}

void Gtk::Style::draw_diamond_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_diamond)
    (*base->draw_diamond)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_string_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, const Glib::ustring& string) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_string)
    (*base->draw_string)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,string.c_str());
}

void Gtk::Style::draw_box_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_box)
    (*base->draw_box)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_flat_box_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_flat_box)
    (*base->draw_flat_box)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_check_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_check)
    (*base->draw_check)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_option_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_option)
    (*base->draw_option)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_tab_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_tab)
    (*base->draw_tab)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_shadow_gap_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Gtk::PositionType gap_side, int gap_x, int gap_width) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_shadow_gap)
    (*base->draw_shadow_gap)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height,((GtkPositionType)(gap_side)),gap_x,gap_width);
}

void Gtk::Style::draw_box_gap_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Gtk::PositionType gap_side, int gap_x, int gap_width) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_box_gap)
    (*base->draw_box_gap)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height,((GtkPositionType)(gap_side)),gap_x,gap_width);
}

void Gtk::Style::draw_extension_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, PositionType gap_side) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_extension)
    (*base->draw_extension)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height,((GtkPositionType)(gap_side)));
}

void Gtk::Style::draw_focus_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_focus)
    (*base->draw_focus)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height);
}

void Gtk::Style::draw_slider_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_slider)
    (*base->draw_slider)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height,((GtkOrientation)(orientation)));
}

void Gtk::Style::draw_handle_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, ShadowType shadow_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, int width, int height, Orientation orientation) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_handle)
    (*base->draw_handle)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),((GtkShadowType)(shadow_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,width,height,((GtkOrientation)(orientation)));
}

void Gtk::Style::draw_expander_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, ExpanderStyle expander_style) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_expander)
    (*base->draw_expander)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,((GtkExpanderStyle)(expander_style)));
}

void Gtk::Style::draw_layout_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, bool use_text, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, int x, int y, const Glib::RefPtr<Pango::Layout>& layout) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_layout)
    (*base->draw_layout)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),static_cast<int>(use_text),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),x,y,Glib::unwrap(layout));
}

void Gtk::Style::draw_resize_grip_vfunc(const Glib::RefPtr<Gdk::Window>& window, Gtk::StateType state_type, const Gdk::Rectangle& area, Widget* widget, const Glib::ustring& detail, Gdk::WindowEdge edge, int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_resize_grip)
    (*base->draw_resize_grip)(gobj(),Glib::unwrap(window),((GtkStateType)(state_type)),const_cast<GdkRectangle*>(area.gobj()),(GtkWidget*)Glib::unwrap(widget),detail.c_str(),((GdkWindowEdge)(edge)),x,y,width,height);
}


} // namespace Gtk


