/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkDragProtocol GdkDragContext_get_protocol (GdkDragContext * cptr) 
{
    return cptr->protocol;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getProtocol
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_DragContext_getProtocol (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return (jint) (GdkDragContext_get_protocol (obj_g));
}

gboolean GdkDragContext_get_is_source (GdkDragContext * cptr) 
{
    return cptr->is_source;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getIsSource
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_DragContext_getIsSource (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkDragContext_get_is_source (obj_g));
}

GdkWindow * GdkDragContext_get_source_window (GdkDragContext * cptr) 
{
    return cptr->source_window;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getSourceWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_DragContext_getSourceWindow (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkDragContext_get_source_window (obj_g));
}

GdkWindow * GdkDragContext_get_dest_window (GdkDragContext * cptr) 
{
    return cptr->dest_window;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getDestWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_DragContext_getDestWindow (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkDragContext_get_dest_window (obj_g));
}

GdkDragAction GdkDragContext_get_actions (GdkDragContext * cptr) 
{
    return cptr->actions;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getActions
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_DragContext_getActions (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return (jint) (GdkDragContext_get_actions (obj_g));
}

GdkDragAction GdkDragContext_get_suggested_action (GdkDragContext * cptr) 
{
    return cptr->suggested_action;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getSuggestedAction
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_DragContext_getSuggestedAction (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return (jint) (GdkDragContext_get_suggested_action (obj_g));
}

GdkDragAction GdkDragContext_get_action (GdkDragContext * cptr) 
{
    return cptr->action;
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    getAction
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_DragContext_getAction (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkDragContext *obj_g = (GdkDragContext *)getPointerFromHandle(env, obj);
    return (jint) (GdkDragContext_get_action (obj_g));
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    gdk_drag_context_get_type
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_DragContext_gdk_1drag_1context_1get_1type (JNIEnv *env, 
    jclass cls) 
{
    return (jint)gdk_drag_context_get_type ();
}

/*
 * Class:     org.gnu.gdk.DragContext
 * Method:    gdk_drag_context_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_DragContext_gdk_1drag_1context_1new (JNIEnv *env, 
    jclass cls) 
{
    return getHandleFromPointer(env, gdk_drag_context_new ());
}


#ifdef __cplusplus
}

#endif
