/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * A vertical separator, used to group the widgets within a window. 
 * It displays a vertical line with a shadow to make it appear sunken 
 * into the interface.
 */
public class VSeparator extends Separator 
{

	/**
	 * Creates a new VSeparator
	 */
	public VSeparator(){
		super(gtk_vseparator_new ());
	}
	
	/**
	 * Construct a VSeparator from a handle to a native resource.
	 */
	public VSeparator(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vseparator_get_type());
	}

    native static final protected int gtk_vseparator_get_type ();
    native static final protected Handle gtk_vseparator_new ();
}

