/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class ToolTipsData extends Boxed 
{
	ToolTipsData(Handle handle) {
		this.handle = handle;
	}
	
	public ToolTips getToolTip() {
		return new ToolTips(getToolTip(handle));
	}
	
	public Widget getWidget() {
		return new Widget(getWidget(handle));
	}
	
	public String getTipText() {
		return getTipText(handle);
	}

    native static final protected Handle getToolTip (Handle cptr);
    native static final protected Handle getWidget (Handle cptr);
    native static final protected String getTipText (Handle cptr);
    native static final protected Handle gtk_tooltips_data_get (Handle widget);
}

