# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libgsf
VER=1.14.8
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

DEPS=`/devel/src/tml/latest.sh glib atk pango gtk+ libIDL ORBit2 libbonobo GConf gnome-vfs`

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev
usemsvs6

unset MY_PKG_CONFIG_PATH
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done
PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3' CPPFLAGS='-DBONOBO_DISABLE_DEPRECATED -I/opt/win_iconv/include -I/opt/proxy-libintl/include -I/opt/misc/include -I/opt/gnuwin32/include' LDFLAGS='-L/opt/proxy-libintl/lib -L/opt/misc/lib -L/opt/gnuwin32/lib' CFLAGS=-O ./configure --disable-gtk-doc --without-python --disable-static --prefix=c:/devel/target/$HEX --without-python

# Do NOT use libtool-cache for libgsf! It breaks build in tools
make -j3 install &&
PATH=/devel/target/$HEX/bin:$PATH make check &&
./libgsf-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
