/* rygel-wmv-transcoder.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-wmv-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;
typedef struct _RygelWMVTranscoderPrivate RygelWMVTranscoderPrivate;

#define RYGEL_TYPE_WMV_TRANSCODER_BIN (rygel_wmv_transcoder_bin_get_type ())
#define RYGEL_WMV_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER_BIN, RygelWMVTranscoderBin))
#define RYGEL_WMV_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER_BIN, RygelWMVTranscoderBinClass))
#define RYGEL_IS_WMV_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER_BIN))
#define RYGEL_IS_WMV_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER_BIN))
#define RYGEL_WMV_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER_BIN, RygelWMVTranscoderBinClass))

typedef struct _RygelWMVTranscoderBin RygelWMVTranscoderBin;
typedef struct _RygelWMVTranscoderBinClass RygelWMVTranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelWMVTranscoder {
	RygelTranscoder parent_instance;
	RygelWMVTranscoderPrivate * priv;
};

struct _RygelWMVTranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_wmv_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WMV_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_WMV_TRANSCODER_VIDEO_BITRATE 1200
#define RYGEL_WMV_TRANSCODER_BITRATE 1200000
#define RYGEL_WMV_TRANSCODER_VIDEO_ENCODER "ffenc_wmv1"
#define RYGEL_WMV_TRANSCODER_COLORSPACE_CONVERT "ffmpegcolorspace"
#define RYGEL_WMV_TRANSCODER_VIDEO_RATE "videorate"
#define RYGEL_WMV_TRANSCODER_VIDEO_SCALE "videoscale"
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
static GstElement* rygel_wmv_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelWMVTranscoderBin* rygel_wmv_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelWMVTranscoder* transcoder, GError** error);
RygelWMVTranscoderBin* rygel_wmv_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelWMVTranscoder* transcoder, GError** error);
GType rygel_wmv_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_wmv_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
#define RYGEL_WMA_TRANSCODER_BITRATE 64
static guint rygel_wmv_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GstElement* rygel_wmv_transcoder_create_encoder (RygelWMVTranscoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_bitrate5 (GstElement* obj, gint value);


RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type) {
	RygelWMVTranscoder * self = NULL;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	self = (RygelWMVTranscoder*) rygel_transcoder_construct (object_type, "video/x-ms-wmv", "WMVHIGH_FULL", RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return self;
#line 315 "rygel-wmv-transcoder.c"
}


RygelWMVTranscoder* rygel_wmv_transcoder_new (void) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return rygel_wmv_transcoder_construct (RYGEL_TYPE_WMV_TRANSCODER);
#line 322 "rygel-wmv-transcoder.c"
}


static GstElement* rygel_wmv_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
	RygelWMVTranscoder * self;
	GstElement* result = NULL;
	RygelMediaItem* _tmp0_;
	GstElement* _tmp1_;
	RygelWMVTranscoderBin* _tmp2_;
	RygelWMVTranscoderBin* _tmp3_;
	GError * _inner_error_ = NULL;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	self = (RygelWMVTranscoder*) base;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp0_ = item;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp1_ = src;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp2_ = rygel_wmv_transcoder_bin_new (_tmp0_, _tmp1_, self, &_inner_error_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_object_ref_sink (_tmp2_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		return NULL;
#line 356 "rygel-wmv-transcoder.c"
	}
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_object_ref_sink (_tmp3_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	result = (GstElement*) _tmp3_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return result;
#line 364 "rygel-wmv-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 371 "rygel-wmv-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_wmv_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelWMVTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	RygelMediaItem* _tmp4_;
	RygelVideoItem* _tmp5_;
	RygelVideoItem* video_item;
	RygelVideoItem* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelVideoItem* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	self = (RygelWMVTranscoder*) base;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp0_ = didl_item;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp1_ = item;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp2_ = manager;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_wmv_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	resource = _tmp3_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		return NULL;
#line 417 "rygel-wmv-transcoder.c"
	}
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (resource == NULL) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		result = NULL;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_g_object_unref0 (resource);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		return result;
#line 427 "rygel-wmv-transcoder.c"
	}
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp4_ = item;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp5_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp4_) ? ((RygelVideoItem*) _tmp4_) : NULL);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	video_item = _tmp5_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp6_ = video_item;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp7_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp6_);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp8_ = _tmp7_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gupnp_didl_lite_resource_set_width (resource, _tmp8_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp9_ = video_item;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp10_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp9_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp11_ = _tmp10_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gupnp_didl_lite_resource_set_height (resource, _tmp11_);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_WMV_TRANSCODER_VIDEO_BITRATE + RYGEL_WMA_TRANSCODER_BITRATE) * 1000) / 8);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	result = resource;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_g_object_unref0 (video_item);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return result;
#line 459 "rygel-wmv-transcoder.c"
}


static guint rygel_wmv_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelWMVTranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	RygelVideoItem* _tmp3_;
	RygelVideoItem* video_item;
	guint _tmp4_;
	guint distance;
	RygelVideoItem* _tmp5_;
	gint _tmp6_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	self = (RygelWMVTranscoder*) base;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp0_ = item;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (!RYGEL_IS_VIDEO_ITEM (_tmp0_)) {
#line 482 "rygel-wmv-transcoder.c"
		guint _tmp1_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_tmp1_ = G_MAXUINT;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		result = _tmp1_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		return result;
#line 490 "rygel-wmv-transcoder.c"
	}
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp2_ = item;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp3_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp2_) ? ((RygelVideoItem*) _tmp2_) : NULL);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	video_item = _tmp3_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp4_ = 0;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	distance = _tmp4_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp5_ = video_item;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp6_ = ((RygelAudioItem*) _tmp5_)->bitrate;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (_tmp6_ > 0) {
#line 508 "rygel-wmv-transcoder.c"
		guint _tmp7_;
		RygelVideoItem* _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_tmp7_ = distance;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_tmp8_ = video_item;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_tmp9_ = ((RygelAudioItem*) _tmp8_)->bitrate;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_tmp10_ = abs (_tmp9_ - RYGEL_WMV_TRANSCODER_BITRATE);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		distance = _tmp7_ + _tmp10_;
#line 523 "rygel-wmv-transcoder.c"
	}
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	result = distance;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_g_object_unref0 (video_item);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return result;
#line 531 "rygel-wmv-transcoder.c"
}


static inline void _dynamic_set_bitrate5 (GstElement* obj, gint value) {
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_object_set (obj, "bitrate", value, NULL);
#line 538 "rygel-wmv-transcoder.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return self ? gst_object_ref (self) : NULL;
#line 545 "rygel-wmv-transcoder.c"
}


GstElement* rygel_wmv_transcoder_create_encoder (RygelWMVTranscoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* convert;
	GstElement* _tmp1_ = NULL;
	GstElement* encoder;
	GstElement* _tmp2_;
	GstBin* _tmp3_;
	GstBin* bin;
	GstBin* _tmp4_;
	GstElement* _tmp5_;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstPad* _tmp12_ = NULL;
	GstPad* pad;
	const gchar* _tmp13_;
	GstPad* _tmp14_;
	GstGhostPad* _tmp15_;
	GstGhostPad* ghost;
	GstBin* _tmp16_;
	GstGhostPad* _tmp17_;
	GstPad* _tmp18_;
	GstElement* _tmp19_;
	GstPad* _tmp20_ = NULL;
	const gchar* _tmp21_;
	GstPad* _tmp22_;
	GstGhostPad* _tmp23_;
	GstBin* _tmp24_;
	GstGhostPad* _tmp25_;
	GstPad* _tmp26_;
	GError * _inner_error_ = NULL;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp0_ = rygel_gst_utils_create_element (RYGEL_WMV_TRANSCODER_COLORSPACE_CONVERT, RYGEL_WMV_TRANSCODER_COLORSPACE_CONVERT, &_inner_error_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	convert = _tmp0_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		return NULL;
#line 598 "rygel-wmv-transcoder.c"
	}
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp1_ = rygel_gst_utils_create_element (RYGEL_WMV_TRANSCODER_VIDEO_ENCODER, RYGEL_WMV_TRANSCODER_VIDEO_ENCODER, &_inner_error_);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	encoder = _tmp1_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		_gst_object_unref0 (convert);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
		return NULL;
#line 612 "rygel-wmv-transcoder.c"
	}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp2_ = encoder;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_dynamic_set_bitrate5 (_tmp2_, ((gint) RYGEL_WMV_TRANSCODER_VIDEO_BITRATE) * 1000);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp3_ = (GstBin*) gst_bin_new ("video-encoder-bin");
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_object_ref_sink (_tmp3_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	bin = _tmp3_;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp4_ = bin;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp5_ = convert;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp6_ = _gst_object_ref0 (_tmp5_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp7_ = encoder;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp8_ = _gst_object_ref0 (_tmp7_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_bin_add_many (_tmp4_, _tmp6_, _tmp8_, NULL);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp9_ = convert;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp10_ = encoder;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_element_link (_tmp9_, _tmp10_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp11_ = convert;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp12_ = gst_element_get_static_pad (_tmp11_, "sink");
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	pad = _tmp12_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp13_ = sink_pad_name;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp14_ = pad;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp15_ = (GstGhostPad*) gst_ghost_pad_new (_tmp13_, _tmp14_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_object_ref_sink (_tmp15_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	ghost = _tmp15_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp16_ = bin;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp17_ = ghost;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp18_ = _gst_object_ref0 ((GstPad*) _tmp17_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp16_, _tmp18_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp19_ = encoder;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp20_ = gst_element_get_static_pad (_tmp19_, "src");
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_gst_object_unref0 (pad);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	pad = _tmp20_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp21_ = src_pad_name;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp22_ = pad;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp23_ = (GstGhostPad*) gst_ghost_pad_new (_tmp21_, _tmp22_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_object_ref_sink (_tmp23_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	ghost = _tmp23_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp24_ = bin;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp25_ = ghost;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_tmp26_ = _gst_object_ref0 ((GstPad*) _tmp25_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp24_, _tmp26_);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	result = (GstElement*) bin;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_gst_object_unref0 (pad);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_gst_object_unref0 (encoder);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	_gst_object_unref0 (convert);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	return result;
#line 706 "rygel-wmv-transcoder.c"
}


static void rygel_wmv_transcoder_class_init (RygelWMVTranscoderClass * klass) {
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	rygel_wmv_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_wmv_transcoder_real_create_source;
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_wmv_transcoder_real_add_resource;
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wmv-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_wmv_transcoder_real_get_distance;
#line 719 "rygel-wmv-transcoder.c"
}


static void rygel_wmv_transcoder_instance_init (RygelWMVTranscoder * self) {
}


GType rygel_wmv_transcoder_get_type (void) {
	static volatile gsize rygel_wmv_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_wmv_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWMVTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_wmv_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWMVTranscoder), 0, (GInstanceInitFunc) rygel_wmv_transcoder_instance_init, NULL };
		GType rygel_wmv_transcoder_type_id;
		rygel_wmv_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelWMVTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_wmv_transcoder_type_id__volatile, rygel_wmv_transcoder_type_id);
	}
	return rygel_wmv_transcoder_type_id__volatile;
}



