/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.StringUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.AbstractLogger;
import org.dita.dost.log.MessageBean;

public class JsonLogger
extends AbstractLogger
implements BuildLogger {
    static final String FIELD_CODE = "code";
    static final String FIELD_DURATION = "duration";
    static final String FIELD_LEVEL = "level";
    static final String FIELD_LINE = "line";
    static final String FIELD_LOCATION = "location";
    static final String FIELD_MSG = "msg";
    static final String FIELD_ROW = "row";
    static final String FIELD_STACKTRACE = "stacktrace";
    static final String FIELD_TARGET = "target";
    static final String FIELD_TASK = "task";
    static final String FIELD_TIMESTAMP = "timestamp";
    private PrintStream out;
    private JsonGenerator generator;
    private boolean isArray = false;
    private Clock clock = Clock.systemDefaultZone();
    private final Deque<Long> timestampStack = new ArrayDeque<Long>();
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final Pattern LOCATION_PREFIX = Pattern.compile("^(?:(.+):(\\d+):(\\d+):\\s+)?(?:\\[(\\w+)])?(?:\\[(\\w+)])?:?\\s+");

    public JsonLogger() {
        this.msgOutputLevel = 0;
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public int getMessageOutputLevel() {
        return this.msgOutputLevel;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    public void buildStarted(BuildEvent event) {
        this.timestampStack.push(this.clock.instant().toEpochMilli());
        try {
            MinimalPrettyPrinter prettyPrinter = new MinimalPrettyPrinter();
            prettyPrinter.setRootValueSeparator(System.lineSeparator());
            this.generator = new ObjectMapper().createGenerator((OutputStream)this.out).setPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open JSON generator: " + e.getMessage(), e);
        }
        if (this.isArray) {
            try {
                this.generator.writeStartArray();
                this.generator.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
            }
        }
    }

    public void buildFinished(BuildEvent event) {
        Throwable error;
        for (Throwable e = error = event.getException(); e != null; e = e.getCause()) {
            if (!(e instanceof DITAOTException)) continue;
            error = e;
            break;
        }
        try {
            if (error == null) {
                if (2 <= this.msgOutputLevel) {
                    this.writeStart(MessageBean.Type.INFO);
                    this.generator.writeStringField(FIELD_MSG, "Build successful");
                    this.writeDuration();
                    this.writeEnd();
                }
            } else {
                this.writeStart(MessageBean.Type.FATAL);
                if (error instanceof DITAOTException) {
                    this.generator.writeStringField(FIELD_MSG, JsonLogger.removeLevelPrefix(error.getMessage()));
                } else {
                    try (StringWriter buf2 = new StringWriter();
                         PrintWriter printWriter = new PrintWriter((Writer)buf2, true);){
                        error.printStackTrace(printWriter);
                        this.generator.writeStringField(FIELD_MSG, buf2.toString());
                    }
                    catch (IOException buf2) {
                        // empty catch block
                    }
                }
                this.writeDuration();
                this.writeEnd();
            }
            if (this.isArray) {
                this.generator.writeEndArray();
                this.generator.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
        }
        finally {
            try {
                this.generator.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close JSON generator: " + e.getMessage(), e);
            }
        }
    }

    private void writeDuration() throws IOException {
        this.generator.writeNumberField(FIELD_DURATION, this.clock.instant().toEpochMilli() - this.timestampStack.pop());
    }

    private void writeStart(MessageBean.Type level) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_TIMESTAMP, this.formatter.format(Instant.now(this.clock)));
        this.generator.writeStringField(FIELD_LEVEL, level.name());
    }

    private void writeEnd() throws IOException {
        this.generator.writeEndObject();
        this.generator.flush();
    }

    private boolean evaluate(Project project, String condition) {
        String value;
        return switch (value = project.replaceProperties(condition)) {
            case "true" -> true;
            case "false" -> false;
            default -> project.getProperty(value) != null || project.getUserProperty(value) != null;
        };
    }

    public void targetStarted(BuildEvent event) {
        Target target = event.getTarget();
        if (target.getIf() != null && !this.evaluate(event.getProject(), target.getIf())) {
            return;
        }
        if (target.getUnless() != null && this.evaluate(event.getProject(), target.getUnless())) {
            return;
        }
        if (2 <= this.msgOutputLevel && !target.getName().equals("")) {
            this.timestampStack.push(this.clock.instant().toEpochMilli());
            try {
                this.writeStart(MessageBean.Type.INFO);
                this.generator.writeStringField(FIELD_TARGET, target.getName());
                this.generator.writeStringField(FIELD_MSG, target.getDescription() != null ? "Started target %s: %s".formatted(target.getName(), target.getDescription()) : "Started target %s".formatted(target.getName()));
                this.writeEnd();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
            }
        }
    }

    public void targetFinished(BuildEvent event) {
        Target target = event.getTarget();
        if (target.getIf() != null && !this.evaluate(event.getProject(), target.getIf())) {
            return;
        }
        if (target.getUnless() != null && this.evaluate(event.getProject(), target.getUnless())) {
            return;
        }
        if (2 <= this.msgOutputLevel && !target.getName().equals("")) {
            try {
                this.writeStart(MessageBean.Type.INFO);
                this.generator.writeStringField(FIELD_TARGET, target.getName());
                this.generator.writeStringField(FIELD_MSG, target.getDescription() != null ? "Finished target %s: %s".formatted(target.getName(), target.getDescription()) : "Finished target %s".formatted(target.getName()));
                this.writeDuration();
                this.writeEnd();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
            }
        }
    }

    public void taskStarted(BuildEvent event) {
        Task task = event.getTask();
        if (4 <= this.msgOutputLevel && !task.getTaskName().equals("")) {
            this.timestampStack.push(this.clock.instant().toEpochMilli());
            try {
                this.writeStart(JsonLogger.toLevel(event));
                this.generator.writeStringField(FIELD_TARGET, task.getOwningTarget().getName());
                this.generator.writeStringField(FIELD_TASK, task.getTaskName());
                this.generator.writeStringField(FIELD_MSG, task.getDescription() != null ? "Started task %s: %s".formatted(task.getTaskName(), task.getDescription()) : "Started task %s".formatted(task.getTaskName()));
                this.writeEnd();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
            }
        }
    }

    public void taskFinished(BuildEvent event) {
        Task task = event.getTask();
        if (4 <= this.msgOutputLevel && !task.getTaskName().equals("")) {
            try {
                this.writeStart(JsonLogger.toLevel(event));
                this.generator.writeStringField(FIELD_TARGET, task.getOwningTarget().getName());
                this.generator.writeStringField(FIELD_TASK, task.getTaskName());
                this.generator.writeStringField(FIELD_MSG, task.getDescription() != null ? "Finished task %s: %s".formatted(task.getTaskName(), task.getDescription()) : "Finished task %s".formatted(task.getTaskName()));
                this.writeDuration();
                this.writeEnd();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
            }
        }
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority > this.msgOutputLevel) {
            return;
        }
        try {
            this.writeStart(JsonLogger.toLevel(event));
            if (event.getTarget() != null) {
                this.generator.writeStringField(FIELD_TARGET, event.getTarget().getName());
            }
            if (event.getTask() != null) {
                this.generator.writeStringField(FIELD_TASK, event.getTask().getTaskName());
            }
            Throwable ex = event.getException();
            if (3 <= this.msgOutputLevel && ex != null) {
                this.generator.writeStringField(FIELD_STACKTRACE, StringUtils.getStackTrace((Throwable)ex));
            }
            StringBuilder message = new StringBuilder(event.getMessage());
            this.extractLocation(message);
            this.generator.writeStringField(FIELD_MSG, JsonLogger.removeLevelPrefix(message).toString());
            this.writeEnd();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public void log(String msg, Throwable t, int level) {
        throw new UnsupportedOperationException();
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private static MessageBean.Type toLevel(BuildEvent event) {
        return switch (event.getPriority()) {
            case 0 -> MessageBean.Type.ERROR;
            case 1 -> MessageBean.Type.WARN;
            case 2 -> MessageBean.Type.INFO;
            case 3 -> MessageBean.Type.DEBUG;
            case 4 -> MessageBean.Type.TRACE;
            default -> throw new IllegalArgumentException("Unexpected value: " + event.getPriority());
        };
    }

    private void extractLocation(StringBuilder message) throws IOException {
        Matcher matcher = LOCATION_PREFIX.matcher(message);
        if (matcher.find()) {
            if (matcher.group(1) != null) {
                this.generator.writeStringField(FIELD_LOCATION, matcher.group(1));
            }
            if (matcher.group(2) != null) {
                this.generator.writeNumberField(FIELD_LINE, Integer.parseInt(matcher.group(2)));
            }
            if (matcher.group(3) != null) {
                this.generator.writeNumberField(FIELD_ROW, Integer.parseInt(matcher.group(3)));
            }
            block11: for (int i = 4; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                switch (matcher.group(i).toUpperCase()) {
                    case "ERROR": 
                    case "WARN": 
                    case "WARNING": 
                    case "INFO": 
                    case "DEBUG": 
                    case "TRACE": {
                        continue block11;
                    }
                    default: {
                        this.generator.writeStringField(FIELD_CODE, matcher.group(i));
                    }
                }
            }
            message.delete(0, matcher.end());
        }
    }
}

