/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.pdf2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class AhfLogProcessorTask
extends Task {
    private static String PREFIX = "AHFCmd :";
    private static String PREFIX_INFO = "INFO: ";
    private static String PREFIX_WARN = "WARNING: ";
    private static String PREFIX_ERROR = "RECOVERABLE: ";
    private static String PREFIX_FATAL = "FATAL: ";
    private File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.file == null) {
            throw new IllegalArgumentException("File argument not set");
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.file));
            String line = in.readLine();
            if (line == null) {
                return;
            }
            this.log(line, 3);
            line = in.readLine();
            if (line == null) {
                return;
            }
            if (line.startsWith(PREFIX)) {
                line = line.substring(PREFIX.length());
            }
            this.log(line.trim(), 3);
            line = in.readLine();
            if (line == null) {
                return;
            }
            this.log(line.trim(), 4);
            in.readLine();
            while ((line = in.readLine()) != null) {
                if (line.startsWith(PREFIX)) {
                    line = line.substring(PREFIX.length());
                }
                int level = 2;
                if (line.startsWith(PREFIX_INFO)) {
                    line = line.substring(PREFIX_INFO.length());
                    level = 2;
                } else if (line.startsWith(PREFIX_WARN)) {
                    line = line.substring(PREFIX_WARN.length());
                    level = 1;
                } else if (line.startsWith(PREFIX_ERROR)) {
                    line = line.substring(PREFIX_ERROR.length());
                    level = 0;
                } else if (line.startsWith(PREFIX_FATAL)) {
                    line = line.substring(PREFIX_FATAL.length());
                    level = 0;
                }
                this.log(line, level);
            }
            return;
        }
        catch (FileNotFoundException e) {
            new BuildException("Failed to find log file: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (IOException e) {
            new BuildException("Failed to read log file: " + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }
}

