/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.dexmaker.dx.ssa;

import java.util.ArrayList;
import java.util.BitSet;
import org.droidparts.dexmaker.dx.ssa.Dominators;
import org.droidparts.dexmaker.dx.ssa.SetFactory;
import org.droidparts.dexmaker.dx.ssa.SsaBasicBlock;
import org.droidparts.dexmaker.dx.ssa.SsaMethod;
import org.droidparts.dexmaker.dx.util.IntSet;

public class DomFront {
    private static boolean DEBUG = false;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> nodes;
    private final DomInfo[] domInfos;

    public DomFront(SsaMethod meth) {
        this.meth = meth;
        this.nodes = meth.getBlocks();
        int szNodes = this.nodes.size();
        this.domInfos = new DomInfo[szNodes];
        for (int i = 0; i < szNodes; ++i) {
            this.domInfos[i] = new DomInfo();
        }
    }

    public DomInfo[] run() {
        int i;
        int szNodes = this.nodes.size();
        if (DEBUG) {
            for (int i2 = 0; i2 < szNodes; ++i2) {
                SsaBasicBlock node = this.nodes.get(i2);
                System.out.println("pred[" + i2 + "]: " + node.getPredecessors());
            }
        }
        Dominators methDom = Dominators.make(this.meth, this.domInfos, false);
        if (DEBUG) {
            for (int i3 = 0; i3 < szNodes; ++i3) {
                DomInfo info = this.domInfos[i3];
                System.out.println("idom[" + i3 + "]: " + info.idom);
            }
        }
        this.buildDomTree();
        if (DEBUG) {
            this.debugPrintDomChildren();
        }
        for (i = 0; i < szNodes; ++i) {
            this.domInfos[i].dominanceFrontiers = SetFactory.makeDomFrontSet(szNodes);
        }
        this.calcDomFronts();
        if (DEBUG) {
            for (i = 0; i < szNodes; ++i) {
                System.out.println("df[" + i + "]: " + this.domInfos[i].dominanceFrontiers);
            }
        }
        return this.domInfos;
    }

    private void debugPrintDomChildren() {
        int szNodes = this.nodes.size();
        for (int i = 0; i < szNodes; ++i) {
            SsaBasicBlock node = this.nodes.get(i);
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            boolean comma = false;
            for (SsaBasicBlock child : node.getDomChildren()) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(child);
                comma = true;
            }
            sb.append('}');
            System.out.println("domChildren[" + node + "]: " + sb);
        }
    }

    private void buildDomTree() {
        int szNodes = this.nodes.size();
        for (int i = 0; i < szNodes; ++i) {
            DomInfo info = this.domInfos[i];
            if (info.idom == -1) continue;
            SsaBasicBlock domParent = this.nodes.get(info.idom);
            domParent.addDomChild(this.nodes.get(i));
        }
    }

    private void calcDomFronts() {
        int szNodes = this.nodes.size();
        for (int b = 0; b < szNodes; ++b) {
            SsaBasicBlock nb = this.nodes.get(b);
            DomInfo nbInfo = this.domInfos[b];
            BitSet pred = nb.getPredecessors();
            if (pred.cardinality() <= 1) continue;
            int i = pred.nextSetBit(0);
            while (i >= 0) {
                int runnerIndex = i;
                while (runnerIndex != nbInfo.idom && runnerIndex != -1) {
                    DomInfo runnerInfo = this.domInfos[runnerIndex];
                    if (runnerInfo.dominanceFrontiers.has(b)) break;
                    runnerInfo.dominanceFrontiers.add(b);
                    runnerIndex = runnerInfo.idom;
                }
                i = pred.nextSetBit(i + 1);
            }
        }
    }

    public static class DomInfo {
        public IntSet dominanceFrontiers;
        public int idom = -1;
    }
}

