/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.building;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.ITmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.AbstractCriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathProvider;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.WorkerSerializer;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public abstract class AbstractTmfGraphBuilderModule
extends TmfAbstractAnalysisModule
implements ICriticalPathProvider {
    private @Nullable ITmfGraph fGraph;
    private @Nullable ITmfEventRequest fRequest;
    private final AbstractCriticalPathModule fCriticalPathModule = this.getCriticalPathModule();

    protected abstract ITmfGraphProvider getGraphProvider();

    protected abstract AbstractCriticalPathModule getCriticalPathModule();

    protected abstract @Nullable ITmfGraph createGraphInstance(Path var1, WorkerSerializer var2, long var3, int var5);

    public @Nullable ITmfGraph getTmfGraph() {
        return this.fGraph;
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) {
        ITmfGraphProvider provider = this.getGraphProvider();
        this.createGraph(provider);
        return !monitor.isCanceled();
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        boolean ret = super.setTrace(trace);
        if (!ret) {
            return ret;
        }
        ret = this.fCriticalPathModule.setTrace(trace);
        return ret;
    }

    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    public void dispose() {
        this.fCriticalPathModule.dispose();
        super.dispose();
        ITmfGraph graph = this.fGraph;
        if (graph != null) {
            graph.dispose();
        }
        this.fGraph = null;
    }

    private void createGraph(ITmfGraphProvider provider) {
        ITmfGraph graph;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new NullPointerException("The graph should not be created if there is no trace set");
        }
        String fileDirectory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        String id = this.getId();
        Path htFile = Paths.get(fileDirectory + id + ".ht", new String[0]);
        this.fGraph = graph = this.createGraphInstance(htFile, this.getWorkerSerializer(), provider.getStartTime(), provider.getGraphFileVersion());
        if (graph != null) {
            provider.assignGraph(graph);
        }
        if (graph != null && graph.isDoneBuilding()) {
            return;
        }
        this.build(provider, graph);
    }

    public WorkerSerializer getWorkerSerializer() {
        return new DefaultWorkerSerializer();
    }

    private void build(ITmfGraphProvider provider, ITmfGraph graph) {
        Object request = this.fRequest;
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
        try {
            this.fRequest = request = new TmfGraphBuildRequest(provider, graph);
            provider.getTrace().sendRequest(request);
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            Activator.getInstance().logError("Request interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public @Nullable ITmfGraph getCriticalPathGraph() {
        return this.fCriticalPathModule.getCriticalPathGraph();
    }

    private static class DefaultWorkerSerializer
    implements WorkerSerializer {
        private DefaultWorkerSerializer() {
        }

        @Override
        public String serialize(IGraphWorker worker) {
            return worker.toString();
        }

        @Override
        public IGraphWorker deserialize(String serializedWorker) {
            throw new UnsupportedOperationException("Implementatiosn nee");
        }
    }

    private static class TmfGraphBuildRequest
    extends TmfEventRequest {
        private final ITmfGraphProvider fProvider;
        private final ITmfGraph fBuilderGraph;
        private long fLastEnd;

        public TmfGraphBuildRequest(ITmfGraphProvider provider, ITmfGraph graph) {
            super(TmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.fProvider = provider;
            this.fBuilderGraph = graph;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            this.fProvider.processEvent(event);
            this.fLastEnd = event.getTimestamp().getValue();
        }

        public synchronized void done() {
            super.done();
            this.fProvider.done();
            this.fBuilderGraph.closeGraph(this.fLastEnd);
        }

        public void handleCancel() {
            this.fProvider.handleCancel();
            super.handleCancel();
        }
    }
}

