/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.util.Properties;
import org.eclipse.help.internal.webapp.parser.ParseElement;
import org.eclipse.help.internal.webapp.parser.ResultParser;
import org.xml.sax.Attributes;

public class SearchParser
extends ResultParser {
    private Properties properties;
    private String currentTag;

    public SearchParser() {
        super("label");
    }

    @Override
    public void startElement(String uri, String lname, String name, Attributes attrs) {
        this.currentTag = name;
        if (name.equalsIgnoreCase("hit")) {
            this.properties = new Properties();
            this.properties.put("tagName", name);
            int i = 0;
            while (i < attrs.getLength()) {
                String qname = attrs.getQName(i);
                String val = attrs.getValue(i);
                this.properties.put(qname, val);
                ++i;
            }
            String id = "" + this.items.size();
            this.properties.put("id", id);
        } else if (name.equalsIgnoreCase("category")) {
            int i = 0;
            while (i < attrs.getLength()) {
                String qname = attrs.getQName(i);
                String val = attrs.getValue(i);
                if (qname.equalsIgnoreCase("href")) {
                    qname = "categoryHref";
                }
                this.properties.put(qname, val);
                ++i;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.currentTag.equalsIgnoreCase("hit") || this.currentTag.equalsIgnoreCase("searchHits")) {
            return;
        }
        if (this.properties != null) {
            String content = new String(ch, start, length);
            String existing = (String)this.properties.get(this.currentTag);
            if (existing == null) {
                existing = "";
            }
            content = content.replaceAll("[\\n\\t]", "").trim();
            this.properties.put(this.currentTag, existing + content);
        }
    }

    @Override
    public void endElement(String uri, String lname, String name) {
        if (name.equalsIgnoreCase("hit")) {
            ParseElement element = new ParseElement(this.properties);
            this.items.add(element);
        }
    }
}

