/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TimeGraphFilterDialog;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class ShowFilterDialogAction
extends Action {
    private final TimeGraphFilterDialog fFilterDialog;
    private final TimeGraphViewer fTimeGraphViewer;

    public ShowFilterDialogAction(TimeGraphViewer timeGraphViewer) {
        this.fFilterDialog = new TimeGraphFilterDialog(timeGraphViewer.getControl().getShell());
        this.fTimeGraphViewer = timeGraphViewer;
        this.setText(Messages.ShowFilterDialogAction_FilterActionNameText);
        this.setToolTipText(Messages.ShowFilterDialogAction_FilterActionToolTipText);
        this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/filter_items.gif"));
    }

    public void run() {
        ITimeGraphEntry[] topInput = this.fTimeGraphViewer.getTimeGraphContentProvider().getElements(this.fTimeGraphViewer.getInput());
        if (topInput != null) {
            List<? extends ITimeGraphEntry> allElements = this.listAllInputs(Arrays.asList(topInput));
            this.fFilterDialog.setInput(this.fTimeGraphViewer.getInput());
            this.fFilterDialog.setTitle(Messages.TmfTimeFilterDialog_WINDOW_TITLE);
            this.fFilterDialog.setMessage(Messages.TmfTimeFilterDialog_MESSAGE);
            this.fFilterDialog.setExpandedElements(allElements.toArray());
            RawViewerFilter rawViewerFilter = null;
            ViewerFilter[] viewerFilterArray = this.fTimeGraphViewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter instanceof RawViewerFilter) {
                    rawViewerFilter = (RawViewerFilter)filter;
                }
                ++n2;
            }
            if (rawViewerFilter != null && rawViewerFilter.getFiltered() != null) {
                ArrayList<? extends ITimeGraphEntry> nonFilteredElements = new ArrayList<ITimeGraphEntry>(allElements);
                nonFilteredElements.removeAll(rawViewerFilter.getFiltered());
                this.fFilterDialog.setInitialElementSelections(nonFilteredElements);
            } else {
                this.fFilterDialog.setInitialElementSelections(allElements);
            }
            this.fFilterDialog.open();
            if (this.fFilterDialog.getResult() != null) {
                if (this.fFilterDialog.getResult().length != allElements.size()) {
                    ArrayList<? extends ITimeGraphEntry> filteredElements = new ArrayList<ITimeGraphEntry>(allElements);
                    filteredElements.removeAll(Arrays.asList(this.fFilterDialog.getResult()));
                    if (rawViewerFilter == null) {
                        rawViewerFilter = new RawViewerFilter(filteredElements);
                        this.addFilter(rawViewerFilter);
                    } else {
                        rawViewerFilter.setFiltered(filteredElements);
                        this.changeFilter(rawViewerFilter);
                    }
                } else if (rawViewerFilter != null) {
                    this.removeFilter(rawViewerFilter);
                }
            }
        }
    }

    public TimeGraphFilterDialog getFilterDialog() {
        return this.fFilterDialog;
    }

    protected void addFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphViewer.addFilter(filter);
    }

    protected void changeFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphViewer.changeFilter(filter);
    }

    protected void removeFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphViewer.removeFilter(filter);
    }

    protected void refresh() {
        this.fTimeGraphViewer.refresh();
    }

    private List<? extends ITimeGraphEntry> listAllInputs(List<? extends ITimeGraphEntry> inputs) {
        ArrayList<? extends ITimeGraphEntry> items = new ArrayList<ITimeGraphEntry>();
        for (ITimeGraphEntry iTimeGraphEntry : inputs) {
            items.add(iTimeGraphEntry);
            if (iTimeGraphEntry == null || !iTimeGraphEntry.hasChildren()) continue;
            items.addAll(this.listAllInputs(iTimeGraphEntry.getChildren()));
        }
        return items;
    }

    private class RawViewerFilter
    extends ViewerFilter {
        private List<? extends ITimeGraphEntry> fFiltered = null;

        public RawViewerFilter(List<? extends ITimeGraphEntry> filteredElements) {
            this.fFiltered = filteredElements;
        }

        public void setFiltered(List<? extends ITimeGraphEntry> objects) {
            this.fFiltered = objects;
        }

        public List<? extends ITimeGraphEntry> getFiltered() {
            return this.fFiltered;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fFiltered == null) {
                return true;
            }
            return !this.fFiltered.contains(element);
        }
    }
}

