/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

public class SelectionConverter {
    private static final IJavaScriptElement[] EMPTY_RESULT = new IJavaScriptElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaScriptModelException {
        ISelection selection;
        if (part instanceof JavaEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((JavaEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaScriptElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IJavaScriptElement[] result = new IJavaScriptElement[selection.size()];
            int i = 0;
            for (Object element : selection) {
                if (!(element instanceof IJavaScriptElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IJavaScriptElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(JavaEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IJavaScriptElement[] codeResolveOrInputForked(JavaEditor editor) throws InvocationTargetException, InterruptedException {
        ITextSelection selection;
        IJavaScriptElement input = SelectionConverter.getInput(editor);
        IJavaScriptElement[] result = SelectionConverter.performForkedCodeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IJavaScriptElement[]{input};
        }
        return result;
    }

    public static IJavaScriptElement[] codeResolve(JavaEditor editor) throws JavaScriptModelException {
        return SelectionConverter.codeResolve(editor, true);
    }

    public static IJavaScriptElement[] codeResolve(JavaEditor editor, boolean primaryOnly) throws JavaScriptModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaScriptElement[] codeResolveForked(JavaEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        return SelectionConverter.performForkedCodeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaScriptElement getElementAtOffset(JavaEditor editor) throws JavaScriptModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    private static IJavaScriptElement getElementAtOffset(JavaEditor editor, boolean primaryOnly) throws JavaScriptModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IType getTypeAtOffset(JavaEditor editor) throws JavaScriptModelException {
        IJavaScriptUnit unit;
        IJavaScriptElement element = SelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = SelectionConverter.getInputAsCompilationUnit(editor)) != null) {
            type = unit.findPrimaryType();
        }
        return type;
    }

    public static IJavaScriptElement getInput(JavaEditor editor) {
        return SelectionConverter.getInput(editor, true);
    }

    private static IJavaScriptElement getInput(JavaEditor editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputJavaElement((IEditorPart)editor, primaryOnly);
    }

    public static ITypeRoot getInputAsTypeRoot(JavaEditor editor) {
        IJavaScriptElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ITypeRoot) {
            return (ITypeRoot)editorInput;
        }
        return null;
    }

    public static IJavaScriptUnit getInputAsCompilationUnit(JavaEditor editor) {
        IJavaScriptElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof IJavaScriptUnit) {
            return (IJavaScriptUnit)editorInput;
        }
        return null;
    }

    public static IClassFile getInputAsClassFile(JavaEditor editor) {
        IJavaScriptElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof IClassFile) {
            return (IClassFile)editorInput;
        }
        return null;
    }

    private static IJavaScriptElement[] performForkedCodeResolve(IJavaScriptElement input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IJavaScriptElement[] result;
            private final /* synthetic */ IJavaScriptElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IJavaScriptElement iJavaScriptElement, ITextSelection iTextSelection) {
                this.val$input = iJavaScriptElement;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (JavaScriptModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IJavaScriptElement[] codeResolve(IJavaScriptElement input, ITextSelection selection) throws JavaScriptModelException {
        if (input instanceof ICodeAssist) {
            IJavaScriptElement[] elements;
            if (input instanceof IJavaScriptUnit) {
                JavaModelUtil.reconcile((IJavaScriptUnit)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset() + selection.getLength(), 0)).length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaScriptElement getElementAtOffset(IJavaScriptElement input, ITextSelection selection) throws JavaScriptModelException {
        if (input instanceof IJavaScriptUnit) {
            IJavaScriptUnit cunit = (IJavaScriptUnit)input;
            JavaModelUtil.reconcile(cunit);
            IJavaScriptElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaScriptElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IJavaScriptElement resolveEnclosingElement(JavaEditor editor, ITextSelection selection) throws JavaScriptModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput(editor), selection);
    }

    public static IJavaScriptElement resolveEnclosingElement(IJavaScriptElement input, ITextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement atOffset = null;
        if (input instanceof IJavaScriptUnit) {
            IJavaScriptUnit cunit = (IJavaScriptUnit)input;
            JavaModelUtil.reconcile(cunit);
            atOffset = cunit.getElementAt(selection.getOffset());
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(selection.getOffset());
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IJavaScriptElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }

    public static IJavaScriptElement selectJavaElement(IJavaScriptElement[] elements, Shell shell, String title, String message) {
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = 2130;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaScriptElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0) {
            return (IJavaScriptElement)dialog.getFirstResult();
        }
        return null;
    }
}

