/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.resource.MemoryResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Invocable;

public class IOResources {
    public static RetainableByteBuffer toRetainableByteBuffer(Resource resource, ByteBufferPool.Sized bufferPool) throws IllegalArgumentException {
        if (resource.isDirectory() || !resource.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
        }
        if (resource instanceof Content.Source.Factory) {
            RetainableByteBuffer retainableByteBuffer;
            block36: {
                Content.Source.Factory factory = (Content.Source.Factory)resource;
                Blocker.Promise promise = Blocker.promise(Retainable::retain);
                try {
                    Content.Source.asRetainableByteBuffer(factory.newContentSource(bufferPool, 0L, -1L), bufferPool, bufferPool.isDirect(), Integer.MAX_VALUE, (Promise<RetainableByteBuffer>)promise);
                    retainableByteBuffer = (RetainableByteBuffer)promise.block();
                    if (promise == null) break block36;
                }
                catch (Throwable throwable) {
                    try {
                        if (promise != null) {
                            try {
                                promise.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                promise.close();
            }
            return retainableByteBuffer;
        }
        if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            return RetainableByteBuffer.wrap(ByteBuffer.wrap(memoryResource.getBytes()));
        }
        long longLength = resource.length();
        bufferPool = bufferPool == null ? ByteBufferPool.SIZED_NON_POOLING : bufferPool;
        Path path = resource.getPath();
        if (path != null && longLength < Integer.MAX_VALUE) {
            RetainableByteBuffer.Mutable mutable;
            block37: {
                RetainableByteBuffer.Mutable retainableByteBuffer = bufferPool.acquire((int)longLength);
                SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);
                try {
                    int read;
                    ByteBuffer byteBuffer = retainableByteBuffer.getByteBuffer();
                    int pos = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
                    for (long totalRead = 0L; totalRead < longLength && (read = seekableByteChannel.read(byteBuffer)) != -1; totalRead += (long)read) {
                    }
                    BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)pos);
                    mutable = retainableByteBuffer;
                    if (seekableByteChannel == null) break block37;
                }
                catch (Throwable totalRead) {
                    try {
                        if (seekableByteChannel != null) {
                            try {
                                seekableByteChannel.close();
                            }
                            catch (Throwable throwable) {
                                totalRead.addSuppressed(throwable);
                            }
                        }
                        throw totalRead;
                    }
                    catch (IOException e) {
                        retainableByteBuffer.release();
                        throw new UncheckedIOException(e);
                    }
                }
                seekableByteChannel.close();
            }
            return mutable;
        }
        Retainable buffer = null;
        try {
            RetainableByteBuffer.DynamicCapacity dynamicCapacity;
            block38: {
                InputStream inputStream = resource.newInputStream();
                try {
                    if (inputStream == null) {
                        throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
                    }
                    RetainableByteBuffer.DynamicCapacity retainableByteBuffer = new RetainableByteBuffer.DynamicCapacity((ByteBufferPool)bufferPool, bufferPool.isDirect(), longLength);
                    while (true) {
                        int read;
                        if (buffer == null) {
                            buffer = bufferPool.acquire(false);
                        }
                        if ((read = inputStream.read(buffer.getByteBuffer().array())) == -1) break;
                        buffer.getByteBuffer().limit(read);
                        retainableByteBuffer.append((RetainableByteBuffer)buffer);
                        if (!buffer.isRetained()) continue;
                        buffer.release();
                        buffer = null;
                    }
                    dynamicCapacity = retainableByteBuffer;
                    if (inputStream == null) break block38;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return dynamicCapacity;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    public static Content.Source asContentSource(Resource resource, ByteBufferPool.Sized bufferPool, long offset, long length) throws IllegalArgumentException {
        if (resource.isDirectory() || !resource.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
        }
        if (resource instanceof Content.Source.Factory) {
            Content.Source.Factory factory = (Content.Source.Factory)resource;
            return factory.newContentSource(bufferPool, offset, length);
        }
        Path path = resource.getPath();
        if (path != null) {
            return Content.Source.from(bufferPool, path, offset, length);
        }
        if (resource instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource;
            return Content.Source.from(BufferUtil.slice((ByteBuffer)ByteBuffer.wrap(memoryResource.getBytes()), (int)Math.toIntExact(offset), (int)Math.toIntExact(length)));
        }
        try {
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            return Content.Source.from(bufferPool, inputStream, offset, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream asInputStream(Resource resource) throws IllegalArgumentException {
        if (resource.isDirectory() || !resource.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
        }
        try {
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            return inputStream;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copy(Resource resource, Content.Sink sink, ByteBufferPool.Sized bufferPool, long offset, long length, Callback callback) throws IllegalArgumentException {
        try {
            if (resource.isDirectory() || !resource.exists()) {
                throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource));
            }
            if (resource instanceof Content.Source.Factory) {
                Content.Source.Factory factory = (Content.Source.Factory)resource;
                Content.Source source = factory.newContentSource(bufferPool, offset, length);
                Content.copy(source, sink, callback);
                return;
            }
            Path path = resource.getPath();
            if (path != null) {
                new PathToSinkCopier(path, sink, bufferPool, offset, length, callback).iterate();
                return;
            }
            if (resource instanceof MemoryResource) {
                MemoryResource memoryResource = (MemoryResource)resource;
                ByteBuffer byteBuffer = BufferUtil.slice((ByteBuffer)ByteBuffer.wrap(memoryResource.getBytes()), (int)Math.toIntExact(offset), (int)Math.toIntExact(length));
                sink.write(true, byteBuffer, callback);
                return;
            }
            InputStream inputStream = resource.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource));
            }
            Content.Source source = Content.Source.from(bufferPool, inputStream, offset, length);
            Content.copy(source, sink, callback);
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    private static class PathToSinkCopier
    extends IteratingNestedCallback {
        private final SeekableByteChannel channel;
        private final Content.Sink sink;
        private final ByteBufferPool.Sized pool;
        private long remainingLength;
        private RetainableByteBuffer retainableByteBuffer;
        private boolean terminated;

        public PathToSinkCopier(Path path, Content.Sink sink, ByteBufferPool.Sized pool, long offset, long length, Callback callback) throws IOException {
            super(callback);
            this.sink = sink;
            this.pool = pool == null ? ByteBufferPool.SIZED_NON_POOLING : pool;
            this.remainingLength = length;
            this.channel = Files.newByteChannel(path, new OpenOption[0]);
            PathToSinkCopier.skipToOffset(this.channel, offset, length, this.pool);
        }

        private static void skipToOffset(SeekableByteChannel channel, long offset, long length, ByteBufferPool.Sized pool) {
            if (offset > 0L && length != 0L) {
                RetainableByteBuffer.Mutable byteBuffer = pool.acquire(1);
                try {
                    channel.position(offset - 1L);
                    if (channel.read(byteBuffer.getByteBuffer().limit(1)) == -1) {
                        throw new IllegalArgumentException("Offset out of range");
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    byteBuffer.release();
                }
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        protected IteratingCallback.Action process() throws Throwable {
            if (this.terminated) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this.retainableByteBuffer == null) {
                this.retainableByteBuffer = this.pool.acquire();
            }
            ByteBuffer byteBuffer = this.retainableByteBuffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            if (this.remainingLength >= 0L && this.remainingLength < Integer.MAX_VALUE) {
                byteBuffer.limit((int)Math.min((long)byteBuffer.capacity(), this.remainingLength));
            }
            boolean eof = false;
            while (byteBuffer.hasRemaining() && !eof) {
                int read = this.channel.read(byteBuffer);
                if (read == -1) {
                    eof = true;
                    continue;
                }
                if (this.remainingLength < 0L) continue;
                this.remainingLength -= (long)read;
            }
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
            this.terminated = eof || this.remainingLength == 0L;
            this.sink.write(this.terminated, byteBuffer, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onCompleteSuccess() {
            if (this.retainableByteBuffer != null) {
                this.retainableByteBuffer.release();
            }
            IO.close((Closeable)this.channel);
            super.onCompleteSuccess();
        }

        protected void onFailure(Throwable x) {
            IO.close((Closeable)this.channel);
            super.onFailure(x);
        }

        protected void onCompleteFailure(Throwable cause) {
            if (this.retainableByteBuffer != null) {
                this.retainableByteBuffer.release();
            }
            super.onCompleteFailure(cause);
        }
    }
}

