/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public interface LaunchConstants {
    public static final String FILE_LOCATION = "File location";
    public static final String SUSPEND_ON_STARTUP = "Suspend on startup";
    public static final String DISPLAY_DYNAMIC_CODE = "Display dynamic code";
    public static final String LIBRARIES = "Libraries";
    public static final String SCRIPT_ENGINE = "Script engine";
    public static final String STARTUP_PARAMETERS = "Startup parameters";
    public static final String SUSPEND_ON_SCRIPT_LOAD = "Suspend on script load";

    public static Collection<String> getLibraries(ILaunchConfiguration configuration) throws CoreException {
        String librariesString = configuration.getAttribute(LIBRARIES, "");
        return LaunchConstants.unserializeLibraries(librariesString);
    }

    public static Collection<String> unserializeLibraries(String libraries) {
        String[] elements = libraries.split(File.pathSeparator);
        ArrayList<String> result = new ArrayList<String>(elements.length);
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                result.add(element.trim());
            }
            ++n2;
        }
        return result;
    }

    public static String serializeLibraries(List<String> libraries) {
        StringBuilder result = new StringBuilder();
        for (String filePath : libraries) {
            result.append(File.pathSeparator);
            result.append(filePath);
        }
        if (result.length() > 0) {
            result.delete(0, File.pathSeparator.length());
        }
        return result.toString();
    }
}

