/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.VmOverheadStateProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class QemuKvmEventHandler
implements IVirtualMachineEventHandler {
    private static final String FIELD_EXIT_REASON = "exit_reason";
    private final Map<IKernelAnalysisEventLayout, Set<String>> fRequiredEvents = new HashMap<IKernelAnalysisEventLayout, Set<String>>();
    private final VmOverheadStateProvider fProvider;

    public QemuKvmEventHandler(VmOverheadStateProvider provider) {
        this.fProvider = provider;
    }

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        Set<String> events = this.fRequiredEvents.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.addAll(layout.eventsKVMEntry());
            events.addAll(layout.eventsKVMExit());
            this.fRequiredEvents.put(layout, events);
        }
        return events;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event, IVirtualEnvironmentModel virtEnv, IKernelAnalysisEventLayout layout) {
        String eventName = event.getName();
        long ts = event.getTimestamp().toNanos();
        if (layout.eventsKVMEntry().contains(eventName)) {
            this.handleKvmEvent(ss, ts, event, virtEnv, null, null);
        } else if (layout.eventsKVMExit().contains(eventName)) {
            Long exitReason = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_EXIT_REASON});
            this.handleKvmEvent(ss, ts, event, virtEnv, "VMM", String.valueOf(exitReason));
        }
    }

    private void handleKvmEvent(ITmfStateSystemBuilder ss, long ts, ITmfEvent event, IVirtualEnvironmentModel virtEnv, @Nullable Object level2, @Nullable Object level3) {
        HostThread ht = IVirtualMachineEventHandler.getCurrentHostThread(event, ts);
        if (ht == null) {
            return;
        }
        VirtualCPU vcpu = virtEnv.getVirtualCpu(event, ht);
        if (vcpu == null) {
            return;
        }
        VirtualMachine vm = vcpu.getVm();
        IHostModel model = ModelManager.getModelFor((String)vm.getHostId());
        int guestTid = model.getThreadOnCpu(vcpu.getCpuId().intValue(), ts);
        if (guestTid != -1) {
            int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"Traces", vm.getTraceName(), "Threads", VmOverheadStateProvider.buildThreadAttributeName(guestTid, vcpu.getCpuId().intValue()), "CallStack"});
            ss.getQuarkRelativeAndAdd(quark, new String[]{"1"});
            int tidQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"1"});
            if (ss.queryOngoing(tidQuark) == null) {
                HostThread hostThread = new HostThread(event.getTrace().getHostId(), Integer.valueOf(guestTid));
                this.fProvider.createGuestThreadStatus(ss, hostThread, ts, tidQuark);
            }
            int preemptQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"2"});
            ss.modifyAttribute(ts, level2, preemptQuark);
            int statusQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"3"});
            ss.modifyAttribute(ts, level3, statusQuark);
        }
    }
}

