/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.folding;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.folding.AbstractFoldingStrategy;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextEditorPrefs;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;

public final class IndentationFoldingStrategy
extends AbstractFoldingStrategy {
    @Override
    public void reconcile(DirtyRegion dirtyRegion, @Nullable IRegion subRegion) {
        IDocument document = this.document;
        ProjectionAnnotationModel annoModel = this.projectionAnnotationModel;
        ITextViewer textViewer = this.textViewer;
        if (document == null || annoModel == null || textViewer == null) {
            return;
        }
        int tabSize = TextEditorPrefs.getCursorConfiguration(null).indentSize;
        if (tabSize < 1) {
            return;
        }
        try {
            boolean startLineIndex = false;
            int endLineIndexExclusive = document.getNumberOfLines();
            int endLineIndex = endLineIndexExclusive - 1;
            ArrayList<FoldingRange> foldingRanges = new ArrayList<FoldingRange>();
            ArrayDeque<IndentationBlock> openRanges = new ArrayDeque<IndentationBlock>();
            int prevIndent = -1;
            int prevLineIdx = -1;
            int lineIndex = 0;
            while (lineIndex < endLineIndexExclusive) {
                int indentLevel;
                if (document != this.document) {
                    return;
                }
                String lineText = DocumentHelper.getLineText((IDocument)document, (int)lineIndex, (boolean)false);
                boolean isBlank = lineText.isBlank();
                int n = indentLevel = isBlank ? prevIndent : IndentationFoldingStrategy.getIndentLevel(lineText, tabSize);
                if (!isBlank) {
                    if (prevIndent >= 0 && prevLineIdx >= 0 && indentLevel > prevIndent) {
                        openRanges.push(new IndentationBlock(prevLineIdx, prevIndent));
                    } else if (indentLevel < prevIndent) {
                        while (!openRanges.isEmpty() && ((IndentationBlock)NullSafetyHelper.castNonNull((Object)((IndentationBlock)openRanges.peek()))).indentLevel >= indentLevel) {
                            IndentationBlock block = (IndentationBlock)openRanges.pop();
                            int endL = lineIndex - 1;
                            int startL = block.startLineIndex;
                            if (endL <= startL) continue;
                            foldingRanges.add(new FoldingRange(startL, endL));
                        }
                    }
                    prevIndent = indentLevel;
                    prevLineIdx = lineIndex;
                }
                ++lineIndex;
            }
            while (!openRanges.isEmpty()) {
                IndentationBlock block = (IndentationBlock)openRanges.pop();
                int endL = endLineIndex;
                int startL = block.startLineIndex;
                if (endL <= startL) continue;
                foldingRanges.add(new FoldingRange(startL, endL));
            }
            foldingRanges.removeIf(r -> r.endLineIndex - r.startLineIndex == 0);
            HashMap<IndentationFoldingAnno, Position> additions = new HashMap<IndentationFoldingAnno, Position>();
            ArrayList<IndentationFoldingAnno> deletions = new ArrayList<IndentationFoldingAnno>();
            HashSet newRanges = new HashSet(foldingRanges);
            int scanOffset = document.getLineOffset(0);
            int scanLength = document.getLength() - scanOffset;
            Iterator it = annoModel.getAnnotationIterator(scanOffset, scanLength, true, true);
            while (it.hasNext()) {
                if (document != this.document) {
                    return;
                }
                Annotation annotation = (Annotation)it.next();
                if (!(annotation instanceof IndentationFoldingAnno)) continue;
                IndentationFoldingAnno anno = (IndentationFoldingAnno)annotation;
                Position pos = annoModel.getPosition((Annotation)anno);
                if (pos == null || pos.getLength() == 0) {
                    deletions.add(anno);
                    continue;
                }
                try {
                    int annStartLine = document.getLineOfOffset(pos.getOffset());
                    int annEndLine = document.getLineOfOffset(pos.getOffset() + pos.getLength() - 1);
                    FoldingRange existing = new FoldingRange(annStartLine, annEndLine);
                    if (newRanges.remove(existing)) continue;
                    deletions.add(anno);
                }
                catch (BadLocationException ex) {
                    deletions.add(anno);
                }
            }
            for (FoldingRange range : newRanges) {
                try {
                    int startOffset = document.getLineOffset(range.startLineIndex);
                    int endOffset = document.getLineOffset(range.endLineIndex) + document.getLineLength(range.endLineIndex);
                    additions.put(new IndentationFoldingAnno(), new Position(startOffset, endOffset - startOffset));
                }
                catch (BadLocationException ex) {
                    LanguageConfigurationPlugin.logError(ex);
                }
            }
            if (document != this.document) {
                return;
            }
            this.modifyAnnotations(deletions, additions, List.of());
        }
        catch (BadLocationException ex) {
            LanguageConfigurationPlugin.logError(ex);
        }
    }

    private static int getIndentLevel(String lineText, int tabSize) {
        int indent = 0;
        int i = 0;
        int len = lineText.length();
        while (i < len) {
            char ch = lineText.charAt(i);
            if (ch == ' ') {
                ++indent;
            } else {
                if (ch != '\t') break;
                indent += tabSize;
            }
            ++i;
        }
        return indent;
    }

    private record FoldingRange(int startLineIndex, int endLineIndex) {
    }

    private record IndentationBlock(int startLineIndex, int indentLevel) {
    }

    private static final class IndentationFoldingAnno
    extends ProjectionAnnotation {
        IndentationFoldingAnno() {
            super(false);
        }
    }
}

