/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.embedder.MavenProperties;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.osgi.service.prefs.BackingStoreException;

public class StandardPreferenceManager
extends PreferenceManager {
    private static final String JAVALS_PROFILE = "javals.profile";
    public static final String M2E_DISABLE_TEST_CLASSPATH_FLAG = "m2e.disableTestClasspathFlag";
    private static final String M2E_APT_ID = "org.eclipse.m2e.apt";
    public static final String MAVEN_MULTI_MODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    private IMavenConfiguration mavenConfig;

    public StandardPreferenceManager() {
        StandardPreferenceManager.initializeMavenPreferences();
    }

    public static void initialize() {
        PreferenceManager.initialize();
        StandardPreferenceManager.initializeMavenPreferences();
    }

    public static void initializeMavenPreferences() {
        IEclipsePreferences m2eAptPrefs = DefaultScope.INSTANCE.getNode(M2E_APT_ID);
        if (m2eAptPrefs != null) {
            m2eAptPrefs.put("org.eclipse.m2e.apt.mode", "jdt_apt");
        }
        IEclipsePreferences store = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        store.put("eclipse.m2.problem.outofdateProjectConfig", ProblemSeverity.warning.toString());
    }

    @Override
    public void update(Preferences preferences) {
        ProjectsManager projectManager;
        String oldMavenDefaultMavenExecutionAction;
        String oldMavenNotCoveredExecutionSeverity;
        String newMavenNotCoveredExecutionSeverity;
        String oldMavenLifecycleMappings;
        String newMavenLifecycleMappings;
        String oldMavenGlobalSettings;
        String newMavenGlobalSettings;
        super.update(preferences);
        boolean updateMavenProjects = false;
        String newMavenSettings = preferences.getMavenUserSettings();
        String oldMavenSettings = this.getMavenConfiguration().getUserSettingsFile();
        if (!Objects.equals(newMavenSettings, oldMavenSettings)) {
            try {
                this.getMavenConfiguration().setUserSettingsFile(newMavenSettings);
                updateMavenProjects = true;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven settings", e);
                preferences.setMavenUserSettings(oldMavenSettings);
            }
        }
        if (!Objects.equals(newMavenGlobalSettings = preferences.getMavenGlobalSettings(), oldMavenGlobalSettings = this.getMavenConfiguration().getGlobalSettingsFile())) {
            try {
                this.getMavenConfiguration().setGlobalSettingsFile(newMavenGlobalSettings);
                updateMavenProjects = true;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven global settings", e);
                preferences.setMavenGlobalSettings(oldMavenGlobalSettings);
            }
        }
        if (!Objects.equals(newMavenLifecycleMappings = preferences.getMavenLifecycleMappings(), oldMavenLifecycleMappings = this.getMavenConfiguration().getWorkspaceLifecycleMappingMetadataFile())) {
            try {
                this.getMavenConfiguration().setWorkspaceLifecycleMappingMetadataFile(newMavenLifecycleMappings);
                LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
                updateMavenProjects = true;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven lifecycle mappings", e);
                preferences.setMavenLifecycleMappings(oldMavenLifecycleMappings);
            }
        }
        try {
            Settings mavenSettings = MavenPlugin.getMaven().getSettings();
            String systemMmpd = System.getProperty(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY);
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
            boolean oldDisableTest = prefs.getBoolean(M2E_DISABLE_TEST_CLASSPATH_FLAG, false);
            String oldMultiModuleProjectDirectory = prefs.get(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY, null);
            String multiModuleProjectDirectory = systemMmpd;
            if (multiModuleProjectDirectory == null && preferences.getRootPaths() != null) {
                for (IPath path : preferences.getRootPaths()) {
                    File f = MavenProperties.computeMultiModuleProjectDirectory((File)path.toFile());
                    if (f == null) continue;
                    try {
                        multiModuleProjectDirectory = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        multiModuleProjectDirectory = f.getAbsolutePath();
                    }
                    break;
                }
            }
            updateMavenProjects = updateMavenProjects || !Objects.equals(multiModuleProjectDirectory, oldMultiModuleProjectDirectory) || oldDisableTest != preferences.isMavenDisableTestClasspathFlag();
            mavenSettings.getProfiles().removeIf(p -> JAVALS_PROFILE.equals(p.getId()));
            if (preferences.isMavenDisableTestClasspathFlag() || multiModuleProjectDirectory != null) {
                Profile profile = new Profile();
                profile.setId(JAVALS_PROFILE);
                Activation activation = new Activation();
                activation.setActiveByDefault(true);
                profile.setActivation(activation);
                profile.getProperties().put(M2E_DISABLE_TEST_CLASSPATH_FLAG, String.valueOf(preferences.isMavenDisableTestClasspathFlag()));
                if (multiModuleProjectDirectory != null) {
                    profile.getProperties().put(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY, multiModuleProjectDirectory);
                } else {
                    profile.getProperties().remove(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY);
                }
                mavenSettings.addProfile(profile);
                mavenSettings.addActiveProfile(profile.getId());
                prefs.putBoolean(M2E_DISABLE_TEST_CLASSPATH_FLAG, preferences.isMavenDisableTestClasspathFlag());
                if (multiModuleProjectDirectory != null) {
                    prefs.put(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY, multiModuleProjectDirectory);
                } else {
                    prefs.remove(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY);
                }
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        if (!Objects.equals(newMavenNotCoveredExecutionSeverity = preferences.getMavenNotCoveredPluginExecutionSeverity(), oldMavenNotCoveredExecutionSeverity = this.getMavenConfiguration().getNotCoveredMojoExecutionSeverity())) {
            try {
                ((MavenConfigurationImpl)this.getMavenConfiguration()).setNotCoveredMojoExecutionSeverity(newMavenNotCoveredExecutionSeverity);
                updateMavenProjects = true;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set not covered Maven plugin execution severity", e);
            }
        }
        String newMavenDefaultMavenExecutionAction = preferences.getMavenDefaultMojoExecutionAction();
        String string = oldMavenDefaultMavenExecutionAction = this.getMavenConfiguration().getDefaultMojoExecutionAction() == null ? null : this.getMavenConfiguration().getDefaultMojoExecutionAction().name();
        if (!Objects.equals(newMavenDefaultMavenExecutionAction, oldMavenDefaultMavenExecutionAction)) {
            PluginExecutionAction action = PluginExecutionAction.valueOf((String)(newMavenDefaultMavenExecutionAction == null ? "ignore" : newMavenDefaultMavenExecutionAction));
            this.getMavenConfiguration().setDefaultMojoExecutionAction(action);
            updateMavenProjects = true;
        }
        if (updateMavenProjects && (projectManager = JavaLanguageServerPlugin.getProjectsManager()) != null) {
            if (projectManager.isBuildFinished()) {
                IProject[] iProjectArray = ProjectUtils.getAllProjects();
                int n = iProjectArray.length;
                int profile = 0;
                while (profile < n) {
                    IProject project = iProjectArray[profile];
                    if (ProjectUtils.isMavenProject(project)) {
                        projectManager.updateProject(project, true);
                    }
                    ++profile;
                }
            } else {
                boolean hasMavenProjects = false;
                IProject[] iProjectArray = ProjectUtils.getAllProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (ProjectUtils.isMavenProject(project)) {
                        hasMavenProjects = true;
                        break;
                    }
                    ++n2;
                }
                projectManager.setShouldUpdateProjects(hasMavenProjects);
            }
        }
        this.updateParallelBuild(preferences.getMaxConcurrentBuilds());
        boolean mavenOffline = preferences.isMavenOffline();
        IEclipsePreferences store = DefaultScope.INSTANCE.getNode("org.eclipse.m2e.core");
        store.putBoolean("eclipse.m2.offline", mavenOffline);
    }

    private void updateParallelBuild(int maxConcurrentBuilds) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        if (description.getMaxConcurrentBuilds() == maxConcurrentBuilds) {
            return;
        }
        description.setMaxConcurrentBuilds(maxConcurrentBuilds);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problems setting maxConcurrentBuilds from workspace.", e);
        }
        String stringValue = maxConcurrentBuilds != 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        pref.put("builderUsesNullSchedulingRule", stringValue);
        pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
    }

    public IMavenConfiguration getMavenConfiguration() {
        if (this.mavenConfig == null) {
            this.mavenConfig = MavenPlugin.getMavenConfiguration();
        }
        return this.mavenConfig;
    }

    public void setMavenConfiguration(IMavenConfiguration mavenConfig) {
        this.mavenConfig = mavenConfig;
    }
}

