/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DelayedSnapshotJob
extends Job {
    private static final String MSG_SNAPSHOT = Messages.resources_snapshot;
    private SaveManager saveManager;
    private Workspace workspace;

    public DelayedSnapshotJob(SaveManager manager, Workspace workspace) {
        super(MSG_SNAPSHOT);
        this.saveManager = manager;
        this.workspace = workspace;
        this.setRule(workspace.getRoot());
        this.setSystem(true);
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.workspace.isOpen()) {
            return Status.OK_STATUS;
        }
        try {
            IStatus iStatus = this.saveManager.save(2, null, Policy.monitorFor(null));
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            this.saveManager.operationCount = 0;
            this.saveManager.snapshotRequested = false;
        }
    }
}

