/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AbstractDelegatingExecutorService;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;

public abstract class AbstractManagedExecutor<S extends ExecutorService>
extends AbstractDelegatingExecutorService<S>
implements ManagedExecutor {
    private final ThreadLocal<Object> executing = new ThreadLocal();
    private final ExecutorPolicy executorPolicy;

    public AbstractManagedExecutor(S delegate, ExecutorPolicy executorPolicy) {
        super(delegate);
        this.executorPolicy = executorPolicy;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.trackedCommand(command));
    }

    protected Runnable trackedCommand(final Runnable command) {
        return new Runnable(){

            @Override
            public void run() {
                AbstractManagedExecutor.this.executing.set(command);
                try {
                    AbstractManagedExecutor.this.executorPolicy.onExecute(command);
                }
                finally {
                    AbstractManagedExecutor.this.executing.remove();
                }
            }
        };
    }

    protected <V> Callable<V> trackedCommand(final Callable<V> command) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                AbstractManagedExecutor.this.executing.set(command);
                try {
                    Object t = AbstractManagedExecutor.this.executorPolicy.onExecute(command);
                    return t;
                }
                finally {
                    AbstractManagedExecutor.this.executing.remove();
                }
            }
        };
    }

    @Override
    public void requestStop() {
        this.delegate.shutdown();
    }

    @Override
    public void stop() {
        this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
        this.requestStop();
        if (this.executing.get() != null) {
            throw new IllegalStateException("Cannot stop this executor from an executor thread.");
        }
        try {
            if (!this.delegate.awaitTermination(timeoutValue, timeoutUnits)) {
                this.delegate.shutdownNow();
                throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
            }
        }
        catch (InterruptedException e) {
            this.delegate.shutdownNow();
            throw UncheckedException.throwAsUncheckedException(e);
        }
        this.executorPolicy.onStop();
    }

    @Override
    public void setKeepAlive(int timeout, TimeUnit timeUnit) {
        if (!(this.delegate instanceof ThreadPoolExecutor)) {
            throw new UnsupportedOperationException();
        }
        ((ThreadPoolExecutor)this.delegate).setKeepAliveTime(timeout, timeUnit);
    }
}

