/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javafx;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.ILibraryLocationResolver;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class FXLibraryLocationResolver
implements ILibraryLocationResolver {
    public IPath getPackageRoot(IPath libraryPath) {
        return Path.EMPTY;
    }

    public IPath getSourcePath(IPath libraryPath) {
        File jarLocation;
        File jdkHome;
        IPath srcPath;
        if (libraryPath.lastSegment().endsWith("jfxrt.jar") && (srcPath = new Path((jdkHome = (jarLocation = libraryPath.toFile()).getParentFile().getParentFile().getParentFile().getParentFile()).getAbsolutePath()).append("javafx-src.zip")).toFile().exists()) {
            return srcPath;
        }
        return Path.EMPTY;
    }

    public URL getJavadocLocation(IPath libraryPath) {
        if (libraryPath.lastSegment().endsWith("jfxrt.jar")) {
            try {
                File jarLocation = libraryPath.toFile();
                File jdkHome = jarLocation.getParentFile().getParentFile().getParentFile().getParentFile();
                File javaDoc = new Path(jdkHome.getAbsolutePath()).append("docs").append("api").toFile();
                if (javaDoc.exists()) {
                    return javaDoc.toURI().toURL();
                }
                javaDoc = new Path(System.getProperty("user.home")).append("javafx8-api").append("docs").append("api").toFile();
                if (javaDoc.exists()) {
                    return javaDoc.toURI().toURL();
                }
                return new URL("http://docs.oracle.com/javase/8/javafx/api/");
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logError("Failure while trying to detect JavaFX8 JavaDoc: " + e.getMessage());
            }
        }
        return null;
    }

    public URL getIndexLocation(IPath libraryPath) {
        return null;
    }
}

