/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.cleanup.AddDeprecatedAnnotationCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.AddOverrideAnnotationCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.CleanUpUtils;
import org.eclipse.jdt.ls.core.internal.cleanup.ISimpleCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.InstanceofPatternMatch;
import org.eclipse.jdt.ls.core.internal.cleanup.InvertEqualsCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.LambdaExpressionAndMethodRefCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.LambdaExpressionCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.MemberAccessUsesThisCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.OrganizeImportsCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.PatternInstanceofToSwitchCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.RedundantComparisonStatementCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.RedundantFallingThroughBlockEndCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.RedundantIfConditionCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.RedundantModifiersCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.RedundantSuperCallCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.RenameUnusedLocalVariableCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.StaticAccessUsesClassNameCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.StringConcatToTextBlockCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.SwitchExpressionCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.TryWithResourceCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.VariableDeclarationFixCleanup;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.text.edits.TextEdit;

public class CleanUpRegistry {
    private Map<String, ISimpleCleanUp> cleanUps;

    public CleanUpRegistry() {
        List<ISimpleCleanUp> cleanUpsList = List.of(new MemberAccessUsesThisCleanUp(), new StaticAccessUsesClassNameCleanUp(), new AddOverrideAnnotationCleanUp(), new AddDeprecatedAnnotationCleanUp(), new StringConcatToTextBlockCleanUp(), new InvertEqualsCleanUp(), new VariableDeclarationFixCleanup(), new SwitchExpressionCleanup(), new InstanceofPatternMatch(), new LambdaExpressionCleanup(), new TryWithResourceCleanUp(), new LambdaExpressionAndMethodRefCleanUp(), new OrganizeImportsCleanup(), new RenameUnusedLocalVariableCleanup(), new PatternInstanceofToSwitchCleanup(), new RedundantModifiersCleanUp(), new RedundantSuperCallCleanUp(), new RedundantIfConditionCleanUp(), new RedundantFallingThroughBlockEndCleanUp(), new RedundantComparisonStatementCleanUp());
        this.cleanUps = new HashMap<String, ISimpleCleanUp>();
        cleanUpsList.forEach(cleanUp -> cleanUp.getIdentifiers().forEach(id -> {
            ISimpleCleanUp iSimpleCleanUp2 = this.cleanUps.put((String)id, (ISimpleCleanUp)cleanUp);
        }));
    }

    public List<org.eclipse.lsp4j.TextEdit> getEditsForAllActiveCleanUps(TextDocumentIdentifier textDocumentId, List<String> cleanUpEnabled, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(textDocumentId.getUri());
        if (unit == null) {
            return List.of();
        }
        IJavaProject javaProject = unit.getJavaProject();
        LinkedHashSet<ISimpleCleanUp> cleanUpsToRun = new LinkedHashSet<ISimpleCleanUp>(cleanUpEnabled.size());
        for (String cleanUpId : cleanUpEnabled) {
            ISimpleCleanUp cleanUp2 = this.cleanUps.get(cleanUpId);
            if (cleanUp2 != null) {
                cleanUpsToRun.add(cleanUp2);
                continue;
            }
            JavaLanguageServerPlugin.log(Status.warning((String)("Not found cleanup id: " + cleanUpId)));
        }
        if (cleanUpsToRun.isEmpty()) {
            return Collections.emptyList();
        }
        List compilerOptsToEnable = cleanUpsToRun.stream().flatMap(cleanUp -> cleanUp.getRequiredCompilerMarkers().stream()).toList();
        Map opts = javaProject.getOptions(true);
        for (String compilerOpt : compilerOptsToEnable) {
            String currentOptValue = (String)opts.get(compilerOpt);
            if (currentOptValue != null && !currentOptValue.equals("ignore")) continue;
            opts.put(compilerOpt, "warning");
        }
        CleanUpContext context = CleanUpUtils.getCleanUpContext(textDocumentId, (Map<String, String>)opts, monitor);
        ArrayList<org.eclipse.lsp4j.TextEdit> textEdits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        ICompilationUnit cu = context.getCompilationUnit();
        try {
            ICompilationUnit wc = cu.getWorkingCopy(monitor);
            for (ISimpleCleanUp cleanUp3 : cleanUpsToRun) {
                TextEdit jdtEdit = CleanUpUtils.getTextEditFromCleanUp(cleanUp3, context, monitor);
                if (jdtEdit == null) continue;
                wc.applyTextEdit(jdtEdit, monitor);
                context = CleanUpUtils.getCleanUpContext(wc, (Map<String, String>)opts, monitor);
            }
            IBuffer wcBuff = wc.getBuffer();
            IBuffer cuBuff = cu.getBuffer();
            String newText = wcBuff.getContents();
            if (!newText.equals(cuBuff.getContents())) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit(JDTUtils.toRange((IOpenable)cu, 0, cuBuff.getLength()), newText);
                textEdits.add(te);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return textEdits;
    }
}

