/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.9")
public class OutputDir {
    private final Path path;

    public static OutputDir create(Optional<String> customDir) {
        try {
            return OutputDir.createSafely(customDir, () -> Paths.get(".", new String[0]).toAbsolutePath());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output dir", e);
        }
    }

    static OutputDir createSafely(Optional<String> customDir, Supplier<Path> currentWorkingDir) throws IOException {
        Path cwd = currentWorkingDir.get();
        Path outputDir = customDir.isPresent() && StringUtils.isNotBlank((String)customDir.get()) ? cwd.resolve(customDir.get()) : (Files.exists(cwd.resolve("pom.xml"), new LinkOption[0]) ? cwd.resolve("target") : (OutputDir.containsFilesWithExtensions(cwd, ".gradle", ".gradle.kts") ? cwd.resolve("build") : cwd));
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        return new OutputDir(outputDir);
    }

    private OutputDir(Path path) {
        this.path = path;
    }

    public Path toPath() {
        return this.path;
    }

    public Path createFile(String prefix, String extension) throws UncheckedIOException {
        String filename = String.format("%s-%d.%s", prefix, Math.abs(new SecureRandom().nextLong()), extension);
        Path outputFile = this.path.resolve(filename);
        try {
            if (Files.exists(outputFile, new LinkOption[0])) {
                Files.delete(outputFile);
            }
            return Files.createFile(outputFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output file: " + outputFile, e);
        }
    }

    private static boolean containsFilesWithExtensions(Path dir, String ... extensions) throws IOException {
        return Files.find(dir, 1, (path, basicFileAttributes) -> {
            if (basicFileAttributes.isRegularFile()) {
                for (String extension : extensions) {
                    if (!path.getFileName().toString().endsWith(extension)) continue;
                    return true;
                }
            }
            return false;
        }, new FileVisitOption[0]).findFirst().isPresent();
    }
}

