/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.eclipse.search.internal.core.text.DirtyFileProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DirtyFileSearchParticipantServiceTracker
extends ServiceTracker<DirtyFileProvider, DirtyFileProvider> {
    private static final String PROPERTY_WEIGHT = "weight";
    private static final Comparator<ServiceReference<DirtyFileProvider>> BY_WEIGHT = Comparator.comparing(o -> o.getProperty(PROPERTY_WEIGHT), Comparator.nullsFirst(Comparator.comparing(Integer.class::isInstance).thenComparing(Integer.class::cast)));

    public DirtyFileSearchParticipantServiceTracker(BundleContext context) throws InvalidSyntaxException {
        super(context, context.createFilter(MessageFormat.format("(&(objectClass={0}))", DirtyFileProvider.class.getCanonicalName())), null);
    }

    public DirtyFileProvider checkedGetService() {
        Optional<ServiceReference<DirtyFileProvider>> reference;
        ServiceReference[] allRefs = this.getServiceReferences();
        if (allRefs != null && allRefs.length > 0 && (reference = Arrays.stream(allRefs).max(BY_WEIGHT)).isPresent()) {
            return (DirtyFileProvider)this.getService(reference.get());
        }
        return Collections::emptyMap;
    }
}

