/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class SingletonEclipsePreferences
extends EclipsePreferences {
    private final String qualifier;
    private final int segmentCount;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private final Set<String> loadedNodes;
    private final AtomicBoolean initialized;

    SingletonEclipsePreferences(EclipsePreferences parent, String name, Set<String> loadedNodes, AtomicBoolean initialized) {
        super(parent, name);
        this.loadedNodes = loadedNodes;
        this.initialized = initialized;
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = SingletonEclipsePreferences.getSegmentCount(path);
        this.qualifier = this.segmentCount < 2 ? null : SingletonEclipsePreferences.getSegment(path, 1);
    }

    abstract IPath getBaseLocation();

    @Override
    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return this.loadedNodes.contains(node.name());
    }

    @Override
    protected void loaded() {
        this.loadedNodes.add(this.name());
    }

    @Override
    protected IPath getLocation() {
        if (this.location == null && this.qualifier != null) {
            this.location = this.computeLocation(this.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    @Override
    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (this.initialized.get() || this.parent == null) {
            return;
        }
        try {
            SingletonEclipsePreferences singletonEclipsePreferences = this;
            synchronized (singletonEclipsePreferences) {
                IPath baseLocation = this.getBaseLocation();
                if (baseLocation != null) {
                    for (String n : this.computeChildren(baseLocation)) {
                        this.addChild(n, null);
                    }
                }
            }
        }
        finally {
            this.initialized.set(true);
        }
    }
}

