/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin.dependency;

import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultArtifact;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleModuleDependency;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.specs.Specs;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.GradleVersion;

public class DependencyCollector {
    private static final String UNKNOWN = "unknown";
    private final Project project;
    private final Set<File> exclusionFromDependencies;
    private final Set<GradleModuleDependency> moduleDependencies;

    public DependencyCollector(Project project, Set<File> exclusionFromDependencies) {
        this.project = project;
        this.exclusionFromDependencies = exclusionFromDependencies;
        this.moduleDependencies = new LinkedHashSet<GradleModuleDependency>();
    }

    public Set<GradleModuleDependency> getModuleDependencies() {
        return this.moduleDependencies;
    }

    public void collectByConfigurationNames(Set<String> configurationNames) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.3")) < 0) {
            List configs = this.project.getConfigurations().stream().filter(configuration -> configurationNames.contains(configuration.getName())).map(Configuration::getResolvedConfiguration).collect(Collectors.toList());
            configs.stream().flatMap(config -> config.getResolvedArtifacts().stream()).forEach(this::resolveArtifact);
            configs.stream().flatMap(config -> config.getFiles(Specs.satisfyAll()).stream()).forEach(this::resolveFileDependency);
        } else {
            this.project.getConfigurations().stream().filter(configuration -> configurationNames.contains(configuration.getName())).filter(Configuration::isCanBeResolved).flatMap(configuration -> this.getConfigurationArtifacts((Configuration)configuration).stream()).filter(artifact -> !this.exclusionFromDependencies.contains(artifact.getFile())).forEach(this::resolveArtifact);
        }
    }

    private void resolveArtifact(ResolvedArtifactResult artifactResult) {
        ComponentArtifactIdentifier id = artifactResult.getId();
        this.resolveArtifact(id, artifactResult.getFile());
    }

    private void resolveArtifact(ResolvedArtifact resolvedArtifact) {
        ComponentArtifactIdentifier id = resolvedArtifact.getId();
        this.resolveArtifact(id, resolvedArtifact.getFile());
    }

    private void resolveArtifact(ComponentArtifactIdentifier id, File artifactFile) {
        if (id instanceof ModuleComponentArtifactIdentifier) {
            this.resolveModuleArtifactDependency((ModuleComponentArtifactIdentifier)id, artifactFile);
        } else if (id instanceof OpaqueComponentArtifactIdentifier) {
            this.resolveFileArtifactDependency((OpaqueComponentArtifactIdentifier)id, artifactFile);
        } else if (id instanceof ComponentFileArtifactIdentifier) {
            this.resolveFileArtifactDependency((ComponentFileArtifactIdentifier)id, artifactFile);
        }
    }

    private List<ResolvedArtifactResult> getConfigurationArtifacts(Configuration config) {
        return config.getIncoming().artifactView(viewConfiguration -> {
            viewConfiguration.lenient(true);
            viewConfiguration.componentFilter(Specs.satisfyAll());
        }).getArtifacts().getArtifacts().stream().collect(Collectors.toList());
    }

    private void resolveModuleArtifactDependency(ModuleComponentArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        File javaDocJar;
        Set resolvedComponents;
        File sourceJar;
        ArtifactResolutionResult resolutionResult = this.project.getDependencies().createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{artifactIdentifier.getComponentIdentifier()}).withArtifacts(JvmLibrary.class, new Class[]{JavadocArtifact.class, SourcesArtifact.class}).execute();
        LinkedList<com.microsoft.java.bs.gradle.model.Artifact> artifacts = new LinkedList<com.microsoft.java.bs.gradle.model.Artifact>();
        if (resolvedArtifactFile != null) {
            artifacts.add(new DefaultArtifact(resolvedArtifactFile.toURI(), null));
        }
        if ((sourceJar = this.getArtifact(resolvedComponents = resolutionResult.getResolvedComponents(), SourcesArtifact.class)) != null) {
            artifacts.add(new DefaultArtifact(sourceJar.toURI(), "sources"));
        }
        if ((javaDocJar = this.getArtifact(resolvedComponents, JavadocArtifact.class)) != null) {
            artifacts.add(new DefaultArtifact(javaDocJar.toURI(), "javadoc"));
        }
        this.moduleDependencies.add(new DefaultGradleModuleDependency(artifactIdentifier.getComponentIdentifier().getGroup(), artifactIdentifier.getComponentIdentifier().getModule(), artifactIdentifier.getComponentIdentifier().getVersion(), artifacts));
    }

    private File getArtifact(Set<ComponentArtifactsResult> resolvedComponents, Class<? extends Artifact> artifactClass) {
        for (ComponentArtifactsResult component : resolvedComponents) {
            Set artifacts = component.getArtifacts(artifactClass);
            for (ArtifactResult artifact : artifacts) {
                if (!(artifact instanceof ResolvedArtifactResult)) continue;
                return ((ResolvedArtifactResult)artifact).getFile();
            }
        }
        return null;
    }

    private void resolveFileArtifactDependency(ComponentFileArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        this.moduleDependencies.add(this.getFileArtifactDependency(artifactIdentifier.getCapitalizedDisplayName(), resolvedArtifactFile));
    }

    private void resolveFileArtifactDependency(OpaqueComponentArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        this.moduleDependencies.add(this.getFileArtifactDependency(artifactIdentifier.getCapitalizedDisplayName(), resolvedArtifactFile));
    }

    private void resolveFileDependency(File resolvedArtifactFile) {
        this.moduleDependencies.add(this.getFileArtifactDependency(resolvedArtifactFile.getName(), resolvedArtifactFile));
    }

    private GradleModuleDependency getFileArtifactDependency(String displayName, File resolvedArtifactFile) {
        LinkedList<com.microsoft.java.bs.gradle.model.Artifact> artifacts = new LinkedList<com.microsoft.java.bs.gradle.model.Artifact>();
        if (resolvedArtifactFile != null) {
            artifacts.add(new DefaultArtifact(resolvedArtifactFile.toURI(), null));
        }
        return new DefaultGradleModuleDependency(UNKNOWN, displayName, UNKNOWN, artifacts);
    }
}

