/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.ChangeSignatureHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.text.correction.ChangeSignatureInfo;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionUtility;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ChangeSignatureInfoHandler {
    private static final String CANNOT_CHANGE_SIGNATURE = "Cannot change signature.";

    public static ChangeSignatureInfo getChangeSignatureInfo(CodeActionParams params, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null || monitor.isCanceled()) {
            return null;
        }
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
        if (astRoot == null) {
            return null;
        }
        IInvocationContext context = CodeActionHandler.getContext(unit, astRoot, params.getRange());
        ASTNode methodNode = CodeActionUtility.inferASTNode(context.getCoveringNode(), MethodDeclaration.class);
        if (methodNode == null) {
            return null;
        }
        IMethodBinding methodBinding = ((MethodDeclaration)methodNode).resolveBinding();
        if (methodBinding == null) {
            return null;
        }
        IJavaElement element = methodBinding.getJavaElement();
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            try {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(method);
                if (RefactoringAvailabilityTesterCore.isChangeSignatureAvailable((IMethod)method)) {
                    RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                    if (status.isOK()) {
                        ArrayList<ChangeSignatureHandler.MethodParameter> parameters = new ArrayList<ChangeSignatureHandler.MethodParameter>();
                        for (ParameterInfo info : processor.getParameterInfos()) {
                            parameters.add(new ChangeSignatureHandler.MethodParameter(info.getOldTypeName(), info.getOldName(), info.getDefaultValue() == null ? "null" : info.getDefaultValue(), info.getOldIndex()));
                        }
                        ArrayList<ChangeSignatureHandler.MethodException> exceptions = new ArrayList<ChangeSignatureHandler.MethodException>();
                        for (ExceptionInfo info : processor.getExceptionInfos()) {
                            exceptions.add(new ChangeSignatureHandler.MethodException(info.getFullyQualifiedName(), info.getElement().getHandleIdentifier()));
                        }
                        return new ChangeSignatureInfo(method.getHandleIdentifier(), JdtFlags.getVisibilityString((int)processor.getVisibility()), processor.getReturnTypeString(), method.getElementName(), (ChangeSignatureHandler.MethodParameter[])parameters.toArray(ChangeSignatureHandler.MethodParameter[]::new), (ChangeSignatureHandler.MethodException[])exceptions.toArray(ChangeSignatureHandler.MethodException[]::new));
                    }
                    return new ChangeSignatureInfo(CANNOT_CHANGE_SIGNATURE + status.getMessageMatchingSeverity(status.getSeverity()));
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return new ChangeSignatureInfo(CANNOT_CHANGE_SIGNATURE);
    }
}

