"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBDebugSession = void 0;
/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const debugadapter_1 = require("@vscode/debugadapter");
const GDBDebugSessionBase_1 = require("../gdb/GDBDebugSessionBase");
const GDBBackendFactory_1 = require("./factories/GDBBackendFactory");
class GDBDebugSession extends GDBDebugSessionBase_1.GDBDebugSessionBase {
    constructor(backendFactory) {
        super(backendFactory || new GDBBackendFactory_1.GDBBackendFactory());
        this.logger = debugadapter_1.logger;
    }
    /**
     * Main entry point
     */
    static run(debugSession) {
        debugadapter_1.DebugSession.run(debugSession);
    }
}
exports.GDBDebugSession = GDBDebugSession;
//# sourceMappingURL=GDBDebugSession.js.map