"use strict";
/*********************************************************************
 * Copyright (c) 2019 Arm and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const chai_1 = require("chai");
const utils_1 = require("./utils");
describe('logpoints', () => __awaiter(void 0, void 0, void 0, function* () {
    let dc;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            dc = yield (0, utils_1.standardBeforeEach)();
            yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                program: (0, path_1.join)(utils_1.testProgramsDir, 'count'),
            }));
        });
    });
    afterEach(() => __awaiter(void 0, void 0, void 0, function* () {
        yield dc.stop();
    }));
    it('hits a logpoint', () => __awaiter(void 0, void 0, void 0, function* () {
        const logMessage = 'log message';
        yield dc.setBreakpointsRequest({
            source: {
                name: 'count.c',
                path: (0, path_1.join)(utils_1.testProgramsDir, 'count.c'),
            },
            breakpoints: [
                {
                    column: 1,
                    line: 4,
                    logMessage,
                },
            ],
        });
        yield dc.configurationDoneRequest();
        const logEvent = yield dc.waitForOutputEvent('console');
        (0, chai_1.expect)(logEvent.body.output).to.eq(logMessage);
    }));
    it('supports changing log messages', () => __awaiter(void 0, void 0, void 0, function* () {
        const logMessage = 'log message';
        yield dc.setBreakpointsRequest({
            source: {
                name: 'count.c',
                path: (0, path_1.join)(utils_1.testProgramsDir, 'count.c'),
            },
            breakpoints: [
                {
                    column: 1,
                    line: 4,
                    logMessage: 'something uninteresting',
                },
            ],
        });
        yield dc.setBreakpointsRequest({
            source: {
                name: 'count.c',
                path: (0, path_1.join)(utils_1.testProgramsDir, 'count.c'),
            },
            breakpoints: [
                {
                    column: 1,
                    line: 4,
                    logMessage,
                },
            ],
        });
        yield dc.configurationDoneRequest();
        const logEvent = yield dc.waitForOutputEvent('console');
        (0, chai_1.expect)(logEvent.body.output).to.eq(logMessage);
    }));
}));
//# sourceMappingURL=logpoints.spec.js.map