/// <reference types="node" />
/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { IStdioProcess } from '../../types/gdb';
import { ChildProcess } from 'child_process';
import { GDBFileSystemProcessManager } from './GDBFileSystemProcessManager';
import { DebugSession } from '@vscode/debugadapter';
import { AttachRequestArguments, LaunchRequestArguments } from '../../types/session';
export declare class GDBPTYProcessManager extends GDBFileSystemProcessManager {
    protected session: DebugSession;
    protected proc?: ChildProcess;
    constructor(session: DebugSession);
    start(requestArgs: LaunchRequestArguments | AttachRequestArguments): Promise<IStdioProcess>;
    stop(): Promise<void>;
}
