"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_remote_lib_electron-browser_remote-frontend-module_js"],{

/***/ "../../node_modules/@theia/remote/lib/electron-browser/local-backend-services.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/local-backend-services.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LocalRemoteFileSystemProvider = exports.LocalRemoteFileSytemServer = exports.LocalEnvVariablesServer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_file_system_provider_1 = __webpack_require__(/*! @theia/filesystem/lib/common/remote-file-system-provider */ "../../node_modules/@theia/filesystem/lib/common/remote-file-system-provider.js");
exports.LocalEnvVariablesServer = Symbol('LocalEnviromentVariableServer');
exports.LocalRemoteFileSytemServer = Symbol('LocalRemoteFileSytemServer');
/**
 * provide file access to local files while connected to a remote workspace or dev container.
 */
let LocalRemoteFileSystemProvider = class LocalRemoteFileSystemProvider extends remote_file_system_provider_1.RemoteFileSystemProvider {
};
exports.LocalRemoteFileSystemProvider = LocalRemoteFileSystemProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.LocalRemoteFileSytemServer),
    tslib_1.__metadata("design:type", Object)
], LocalRemoteFileSystemProvider.prototype, "server", void 0);
exports.LocalRemoteFileSystemProvider = LocalRemoteFileSystemProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], LocalRemoteFileSystemProvider);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwading-contribution.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwading-contribution.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PortForwardingContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const port_forwarding_widget_1 = __webpack_require__(/*! ./port-forwarding-widget */ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-widget.js");
let PortForwardingContribution = class PortForwardingContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: port_forwarding_widget_1.PORT_FORWARDING_WIDGET_ID,
            widgetName: core_1.nls.localizeByDefault('Ports'),
            defaultWidgetOptions: {
                area: 'bottom'
            }
        });
    }
};
exports.PortForwardingContribution = PortForwardingContribution;
exports.PortForwardingContribution = PortForwardingContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], PortForwardingContribution);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-widget.js":
/*!*******************************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-widget.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PortForwardingWidget = exports.PORT_FORWARDING_WIDGET_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const port_forwarding_service_1 = __webpack_require__(/*! ./port-forwarding-service */ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-service.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
exports.PORT_FORWARDING_WIDGET_ID = 'port-forwarding-widget';
let PortForwardingWidget = class PortForwardingWidget extends browser_1.ReactWidget {
    init() {
        this.id = exports.PORT_FORWARDING_WIDGET_ID;
        this.node.tabIndex = -1;
        this.title.label = core_1.nls.localizeByDefault('Ports');
        this.title.caption = this.title.label;
        this.title.closable = true;
        this.update();
        this.portForwardingService.onDidChangePorts(() => this.update());
    }
    render() {
        if (this.portForwardingService.forwardedPorts.length === 0) {
            return React.createElement("div", null,
                React.createElement("p", { style: { marginLeft: 'calc(var(--theia-ui-padding) * 2)' } }, core_1.nls.localizeByDefault('No forwarded ports. Forward a port to access your locally running services over the internet.\n[Forward a Port]({0})').split('\n')[0]),
                this.renderForwardPortButton());
        }
        return React.createElement("div", null,
            React.createElement("table", { className: 'port-table' },
                React.createElement("thead", null,
                    React.createElement("tr", null,
                        React.createElement("th", { className: 'port-table-header' }, core_1.nls.localizeByDefault('Port')),
                        React.createElement("th", { className: 'port-table-header' }, core_1.nls.localizeByDefault('Address')),
                        React.createElement("th", { className: 'port-table-header' }, core_1.nls.localizeByDefault('Running Process')),
                        React.createElement("th", { className: 'port-table-header' }, core_1.nls.localizeByDefault('Origin')))),
                React.createElement("tbody", null,
                    this.portForwardingService.forwardedPorts.map(port => {
                        var _a;
                        return (React.createElement("tr", { key: (_a = port.localPort) !== null && _a !== void 0 ? _a : 'editing' },
                            this.renderPortColumn(port),
                            this.renderAddressColumn(port),
                            React.createElement("td", null),
                            React.createElement("td", null, port.origin ? core_1.nls.localizeByDefault(port.origin) : '')));
                    }),
                    !this.portForwardingService.forwardedPorts.some(port => port.editing) && React.createElement("tr", null,
                        React.createElement("td", null, this.renderForwardPortButton())))));
    }
    renderForwardPortButton() {
        return React.createElement("button", { className: 'theia-button', onClick: () => {
                this.portForwardingService.forwardNewPort('User Forwarded');
                this.update();
            } }, core_1.nls.localizeByDefault('Forward a Port'));
    }
    renderAddressColumn(port) {
        var _a;
        const address = `${(_a = port.address) !== null && _a !== void 0 ? _a : '0.0.0.0'}:${port.localPort}`;
        return React.createElement("td", null,
            React.createElement("div", { className: 'button-cell' },
                React.createElement("span", { style: { flexGrow: 1 }, className: 'forwarded-address', onClick: async (e) => {
                        if (e.ctrlKey) {
                            const uri = new core_1.URI(`http://${address}`);
                            (await this.openerService.getOpener(uri)).open(uri);
                        }
                    }, title: core_1.nls.localizeByDefault('Follow link') + ' (ctrl/cmd + click)' }, port.localPort ? address : ''),
                port.localPort &&
                    React.createElement("span", { className: 'codicon codicon-clippy action-label', title: core_1.nls.localizeByDefault('Copy Local Address'), onClick: () => {
                            this.clipboardService.writeText(address);
                        } })));
    }
    renderPortColumn(port) {
        return port.editing ?
            React.createElement("td", null,
                React.createElement(PortEditingInput, { port: port, service: this.portForwardingService })) :
            React.createElement("td", null,
                React.createElement("div", { className: 'button-cell' },
                    React.createElement("span", { style: { flexGrow: 1 } }, port.localPort),
                    React.createElement("span", { className: 'codicon codicon-close action-label', title: core_1.nls.localizeByDefault('Stop Forwarding Port'), onClick: () => {
                            this.portForwardingService.removePort(port);
                            this.update();
                        } })));
    }
};
exports.PortForwardingWidget = PortForwardingWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(port_forwarding_service_1.PortForwardingService),
    tslib_1.__metadata("design:type", port_forwarding_service_1.PortForwardingService)
], PortForwardingWidget.prototype, "portForwardingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], PortForwardingWidget.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    tslib_1.__metadata("design:type", Object)
], PortForwardingWidget.prototype, "clipboardService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PortForwardingWidget.prototype, "init", null);
exports.PortForwardingWidget = PortForwardingWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PortForwardingWidget);
function PortEditingInput({ port, service }) {
    var _a;
    const [error, setError] = React.useState(false);
    return React.createElement("input", { className: `theia-input forward-port-button${error ? ' port-edit-input-error' : ''}`, "port-edit-input-error": error, autoFocus: true, defaultValue: port.address ? `${port.address}:${port.localPort}` : (_a = port.localPort) !== null && _a !== void 0 ? _a : '', placeholder: core_1.nls.localizeByDefault('Port number or address (eg. 3000 or 10.10.10.10:2000).'), onKeyDown: e => e.key === 'Enter' && !error && service.updatePort(port, e.currentTarget.value), onKeyUp: e => setError(!service.isValidAddress(e.currentTarget.value)) });
}


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-electron-file-dialog-service.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-electron-file-dialog-service.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteElectronFileDialogService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_dialog_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-dialog/file-dialog-service */ "../../node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-service.js");
const electron_file_dialog_service_1 = __webpack_require__(/*! @theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service */ "../../node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js");
const remote_service_1 = __webpack_require__(/*! ./remote-service */ "../../node_modules/@theia/remote/lib/electron-browser/remote-service.js");
let RemoteElectronFileDialogService = class RemoteElectronFileDialogService extends electron_file_dialog_service_1.ElectronFileDialogService {
    showOpenDialog(props, folder) {
        if (this.remoteService.isConnected()) {
            return file_dialog_service_1.DefaultFileDialogService.prototype.showOpenDialog.call(this, props, folder);
        }
        else {
            return super.showOpenDialog(props, folder);
        }
    }
    showSaveDialog(props, folder) {
        if (this.remoteService.isConnected()) {
            return file_dialog_service_1.DefaultFileDialogService.prototype.showSaveDialog.call(this, props, folder);
        }
        else {
            return super.showSaveDialog(props, folder);
        }
    }
};
exports.RemoteElectronFileDialogService = RemoteElectronFileDialogService;
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_service_1.RemoteService),
    tslib_1.__metadata("design:type", remote_service_1.RemoteService)
], RemoteElectronFileDialogService.prototype, "remoteService", void 0);
exports.RemoteElectronFileDialogService = RemoteElectronFileDialogService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], RemoteElectronFileDialogService);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-frontend-contribution.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-frontend-contribution.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteFrontendContribution = exports.RemoteCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_status_service_1 = __webpack_require__(/*! ../electron-common/remote-status-service */ "../../node_modules/@theia/remote/lib/electron-common/remote-status-service.js");
const remote_registry_contribution_1 = __webpack_require__(/*! ./remote-registry-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js");
const remote_service_1 = __webpack_require__(/*! ./remote-service */ "../../node_modules/@theia/remote/lib/electron-browser/remote-service.js");
const window_service_1 = __webpack_require__(/*! @theia/core/lib/browser/window/window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
const electron_local_ws_connection_source_1 = __webpack_require__(/*! @theia/core/lib/electron-browser/messaging/electron-local-ws-connection-source */ "../../node_modules/@theia/core/lib/electron-browser/messaging/electron-local-ws-connection-source.js");
var RemoteCommands;
(function (RemoteCommands) {
    RemoteCommands.REMOTE_SELECT = {
        id: 'remote.select'
    };
    RemoteCommands.REMOTE_DISCONNECT = core_1.Command.toDefaultLocalizedCommand({
        id: 'remote.disconnect',
        label: 'Close Remote Connection',
    });
})(RemoteCommands || (exports.RemoteCommands = RemoteCommands = {}));
let RemoteFrontendContribution = class RemoteFrontendContribution {
    constructor() {
        this.remoteRegistry = new remote_registry_contribution_1.RemoteRegistry();
    }
    async configure() {
        const port = (0, electron_local_ws_connection_source_1.getCurrentPort)();
        if (port) {
            const status = await this.remoteStatusService.getStatus(Number(port));
            await this.setStatusBar(status);
        }
        else {
            await this.setStatusBar({
                alive: false
            });
        }
    }
    async setStatusBar(info) {
        this.remoteService.setConnected(info.alive);
        const entry = {
            alignment: browser_1.StatusBarAlignment.LEFT,
            command: RemoteCommands.REMOTE_SELECT.id,
            backgroundColor: 'var(--theia-statusBarItem-remoteBackground)',
            color: 'var(--theia-statusBarItem-remoteForeground)',
            priority: 10000,
            ...(info.alive
                ? {
                    text: `$(codicon-remote) ${info.type}: ${info.name.length > 35 ? info.name.substring(0, 32) + '...' : info.name}`,
                    tooltip: core_1.nls.localizeByDefault('Editing on {0}', info.name),
                } : {
                text: '$(codicon-remote)',
                tooltip: core_1.nls.localizeByDefault('Open a Remote Window'),
            })
        };
        this.statusBar.setElement('remoteStatus', entry);
    }
    registerCommands(commands) {
        this.remoteRegistry.onDidRegisterCommand(([command, handler]) => {
            commands.registerCommand(command, handler);
        });
        for (const contribution of this.remoteRegistryContributions.getContributions()) {
            contribution.registerRemoteCommands(this.remoteRegistry);
        }
        commands.registerCommand(RemoteCommands.REMOTE_SELECT, {
            execute: () => this.selectRemote()
        });
        commands.registerCommand(RemoteCommands.REMOTE_DISCONNECT, {
            execute: () => this.disconnectRemote()
        });
    }
    async disconnectRemote() {
        const localPort = (0, electron_local_ws_connection_source_1.getLocalPort)();
        if (localPort) {
            const searchParams = new URLSearchParams(location.search);
            const currentPort = searchParams.get('port');
            this.remoteStatusService.connectionClosed(parseInt(currentPort !== null && currentPort !== void 0 ? currentPort : '0'));
            this.windowService.reload({ search: { port: localPort } });
        }
    }
    async selectRemote() {
        var _a;
        const commands = [...this.remoteRegistry.commands];
        if (this.remoteService.isConnected()) {
            commands.push(RemoteCommands.REMOTE_DISCONNECT);
        }
        const quickPicks = [];
        let previousCategory = undefined;
        for (const command of commands) {
            if (previousCategory !== command.category) {
                quickPicks.push({
                    type: 'separator',
                    label: command.category
                });
                previousCategory = command.category;
            }
            quickPicks.push({
                label: command.label,
                id: command.id
            });
        }
        const selection = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(quickPicks, {
            placeholder: core_1.nls.localizeByDefault('Select an option to open a Remote Window')
        }));
        if (selection) {
            this.commandRegistry.executeCommand(selection.id);
        }
    }
};
exports.RemoteFrontendContribution = RemoteFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.StatusBar),
    tslib_1.__metadata("design:type", Object)
], RemoteFrontendContribution.prototype, "statusBar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], RemoteFrontendContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], RemoteFrontendContribution.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_service_1.RemoteService),
    tslib_1.__metadata("design:type", remote_service_1.RemoteService)
], RemoteFrontendContribution.prototype, "remoteService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_status_service_1.RemoteStatusService),
    tslib_1.__metadata("design:type", Object)
], RemoteFrontendContribution.prototype, "remoteStatusService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    tslib_1.__metadata("design:type", Object)
], RemoteFrontendContribution.prototype, "windowService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(remote_registry_contribution_1.RemoteRegistryContribution),
    tslib_1.__metadata("design:type", Object)
], RemoteFrontendContribution.prototype, "remoteRegistryContributions", void 0);
exports.RemoteFrontendContribution = RemoteFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], RemoteFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-frontend-module.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-frontend-module.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const remote_ssh_contribution_1 = __webpack_require__(/*! ./remote-ssh-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-ssh-contribution.js");
const remote_ssh_connection_provider_1 = __webpack_require__(/*! ../electron-common/remote-ssh-connection-provider */ "../../node_modules/@theia/remote/lib/electron-common/remote-ssh-connection-provider.js");
const remote_frontend_contribution_1 = __webpack_require__(/*! ./remote-frontend-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-frontend-contribution.js");
const remote_registry_contribution_1 = __webpack_require__(/*! ./remote-registry-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js");
const remote_service_1 = __webpack_require__(/*! ./remote-service */ "../../node_modules/@theia/remote/lib/electron-browser/remote-service.js");
const remote_status_service_1 = __webpack_require__(/*! ../electron-common/remote-status-service */ "../../node_modules/@theia/remote/lib/electron-common/remote-status-service.js");
const electron_file_dialog_service_1 = __webpack_require__(/*! @theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service */ "../../node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js");
const remote_electron_file_dialog_service_1 = __webpack_require__(/*! ./remote-electron-file-dialog-service */ "../../node_modules/@theia/remote/lib/electron-browser/remote-electron-file-dialog-service.js");
const remote_preferences_1 = __webpack_require__(/*! ./remote-preferences */ "../../node_modules/@theia/remote/lib/electron-browser/remote-preferences.js");
const port_forwarding_widget_1 = __webpack_require__(/*! ./port-forwarding/port-forwarding-widget */ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-widget.js");
const port_forwading_contribution_1 = __webpack_require__(/*! ./port-forwarding/port-forwading-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwading-contribution.js");
const port_forwarding_service_1 = __webpack_require__(/*! ./port-forwarding/port-forwarding-service */ "../../node_modules/@theia/remote/lib/electron-browser/port-forwarding/port-forwarding-service.js");
const remote_port_forwarding_provider_1 = __webpack_require__(/*! ../electron-common/remote-port-forwarding-provider */ "../../node_modules/@theia/remote/lib/electron-common/remote-port-forwarding-provider.js");
const service_connection_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/messaging/service-connection-provider */ "../../node_modules/@theia/core/lib/browser/messaging/service-connection-provider.js");
__webpack_require__(/*! ../../src/electron-browser/style/port-forwarding-widget.css */ "../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css");
const user_storage_contribution_1 = __webpack_require__(/*! @theia/userstorage/lib/browser/user-storage-contribution */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js");
const remote_user_storage_provider_1 = __webpack_require__(/*! ./remote-user-storage-provider */ "../../node_modules/@theia/remote/lib/electron-browser/remote-user-storage-provider.js");
const remote_file_system_provider_1 = __webpack_require__(/*! @theia/filesystem/lib/common/remote-file-system-provider */ "../../node_modules/@theia/filesystem/lib/common/remote-file-system-provider.js");
const local_backend_services_1 = __webpack_require__(/*! ./local-backend-services */ "../../node_modules/@theia/remote/lib/electron-browser/local-backend-services.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
exports["default"] = new inversify_1.ContainerModule((bind, _, __, rebind) => {
    bind(remote_frontend_contribution_1.RemoteFrontendContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(remote_frontend_contribution_1.RemoteFrontendContribution);
    bind(core_1.CommandContribution).toService(remote_frontend_contribution_1.RemoteFrontendContribution);
    (0, core_1.bindContributionProvider)(bind, remote_registry_contribution_1.RemoteRegistryContribution);
    bind(remote_ssh_contribution_1.RemoteSSHContribution).toSelf().inSingletonScope();
    bind(remote_registry_contribution_1.RemoteRegistryContribution).toService(remote_ssh_contribution_1.RemoteSSHContribution);
    (0, remote_preferences_1.bindRemotePreferences)(bind);
    rebind(electron_file_dialog_service_1.ElectronFileDialogService).to(remote_electron_file_dialog_service_1.RemoteElectronFileDialogService).inSingletonScope();
    bind(remote_service_1.RemoteService).toSelf().inSingletonScope();
    bind(port_forwarding_widget_1.PortForwardingWidget).toSelf();
    bind(browser_1.WidgetFactory).toDynamicValue(context => ({
        id: port_forwarding_widget_1.PORT_FORWARDING_WIDGET_ID,
        createWidget: () => context.container.get(port_forwarding_widget_1.PortForwardingWidget)
    }));
    (0, browser_1.bindViewContribution)(bind, port_forwading_contribution_1.PortForwardingContribution);
    bind(port_forwarding_service_1.PortForwardingService).toSelf().inSingletonScope();
    bind(remote_ssh_connection_provider_1.RemoteSSHConnectionProvider).toDynamicValue(ctx => service_connection_provider_1.ServiceConnectionProvider.createLocalProxy(ctx.container, remote_ssh_connection_provider_1.RemoteSSHConnectionProviderPath)).inSingletonScope();
    bind(remote_status_service_1.RemoteStatusService).toDynamicValue(ctx => service_connection_provider_1.ServiceConnectionProvider.createLocalProxy(ctx.container, remote_status_service_1.RemoteStatusServicePath)).inSingletonScope();
    bind(remote_port_forwarding_provider_1.RemotePortForwardingProvider).toDynamicValue(ctx => service_connection_provider_1.ServiceConnectionProvider.createLocalProxy(ctx.container, remote_port_forwarding_provider_1.RemoteRemotePortForwardingProviderPath)).inSingletonScope();
    bind(local_backend_services_1.LocalRemoteFileSytemServer).toDynamicValue(ctx => browser_1.isRemote ?
        service_connection_provider_1.ServiceConnectionProvider.createLocalProxy(ctx.container, remote_file_system_provider_1.remoteFileSystemPath, new remote_file_system_provider_1.RemoteFileSystemProxyFactory()) :
        ctx.container.get(remote_file_system_provider_1.RemoteFileSystemServer));
    bind(local_backend_services_1.LocalEnvVariablesServer).toDynamicValue(ctx => browser_1.isRemote ?
        service_connection_provider_1.ServiceConnectionProvider.createLocalProxy(ctx.container, env_variables_1.envVariablesPath) :
        ctx.container.get(env_variables_1.EnvVariablesServer));
    bind(local_backend_services_1.LocalRemoteFileSystemProvider).toSelf().inSingletonScope();
    rebind(user_storage_contribution_1.UserStorageContribution).to(remote_user_storage_provider_1.RemoteUserStorageContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-service.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-service.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let RemoteService = class RemoteService {
    isConnected() {
        return this._connected;
    }
    setConnected(value) {
        this._connected = value;
    }
};
exports.RemoteService = RemoteService;
exports.RemoteService = RemoteService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], RemoteService);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-ssh-contribution.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-ssh-contribution.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteSSHContribution = exports.RemoteSSHCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const remote_ssh_connection_provider_1 = __webpack_require__(/*! ../electron-common/remote-ssh-connection-provider */ "../../node_modules/@theia/remote/lib/electron-common/remote-ssh-connection-provider.js");
const remote_registry_contribution_1 = __webpack_require__(/*! ./remote-registry-contribution */ "../../node_modules/@theia/remote/lib/electron-browser/remote-registry-contribution.js");
const remote_preferences_1 = __webpack_require__(/*! ./remote-preferences */ "../../node_modules/@theia/remote/lib/electron-browser/remote-preferences.js");
const ssh_config_1 = __webpack_require__(/*! ssh-config */ "../../node_modules/ssh-config/index.js");
var RemoteSSHCommands;
(function (RemoteSSHCommands) {
    RemoteSSHCommands.CONNECT = core_1.Command.toLocalizedCommand({
        id: 'remote.ssh.connect',
        category: 'SSH',
        label: 'Connect to Host...',
    }, 'theia/remoteSSH/connect');
    RemoteSSHCommands.CONNECT_CURRENT_WINDOW = core_1.Command.toLocalizedCommand({
        id: 'remote.ssh.connectCurrentWindow',
        category: 'SSH',
        label: 'Connect Current Window to Host...',
    }, 'theia/remoteSSH/connect');
    RemoteSSHCommands.CONNECT_CURRENT_WINDOW_TO_CONFIG_HOST = core_1.Command.toLocalizedCommand({
        id: 'remote.ssh.connectToConfigHost',
        category: 'SSH',
        label: 'Connect Current Window to Host in Config File...',
    }, 'theia/remoteSSH/connectToConfigHost');
})(RemoteSSHCommands || (exports.RemoteSSHCommands = RemoteSSHCommands = {}));
let RemoteSSHContribution = class RemoteSSHContribution extends remote_registry_contribution_1.AbstractRemoteRegistryContribution {
    registerRemoteCommands(registry) {
        registry.registerCommand(RemoteSSHCommands.CONNECT, {
            execute: () => this.connect(true)
        });
        registry.registerCommand(RemoteSSHCommands.CONNECT_CURRENT_WINDOW, {
            execute: () => this.connect(false)
        });
        registry.registerCommand(RemoteSSHCommands.CONNECT_CURRENT_WINDOW_TO_CONFIG_HOST, {
            execute: () => this.connectToConfigHost()
        });
    }
    async getConfigFilePath() {
        return this.remotePreferences['remote.ssh.configFile'];
    }
    async connectToConfigHost() {
        var _a, _b;
        const quickPicks = [];
        const sshConfig = await this.sshConnectionProvider.getSSHConfig(await this.getConfigFilePath());
        const wildcardCheck = /[\?\*\%]/;
        for (const record of sshConfig) {
            // check if its a section and if it has a single value
            if (!('config' in record) || !(typeof record.value === 'string')) {
                continue;
            }
            if (record.param.toLowerCase() === 'host' && !wildcardCheck.test(record.value)) {
                const rec = ((record.config)
                    .filter((entry) => entry.type === ssh_config_1.default.DIRECTIVE))
                    .reduce((pv, item) => ({ ...pv, [item.param.toLowerCase()]: item.value }), { 'host': record.value });
                const host = (rec.hostname || rec.host) + ':' + (rec.port || '22');
                const user = rec.user || 'root';
                quickPicks.push({
                    label: rec.host,
                    id: user + '@' + host
                });
            }
        }
        const selection = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(quickPicks, {
            placeholder: core_1.nls.localizeByDefault('Select an option to open a Remote Window')
        }));
        if (selection && selection.id) {
            try {
                let [user, host] = selection.id.split('@', 2);
                host = selection.label;
                const remotePort = await this.sendSSHConnect(host, user);
                this.openRemote(remotePort, false);
            }
            catch (err) {
                this.messageService.error(`${core_1.nls.localize('theia/remote/sshFailure', 'Could not open SSH connection to remote.')} ${(_b = err.message) !== null && _b !== void 0 ? _b : String(err)}`);
            }
        }
    }
    async connect(newWindow) {
        var _a;
        let host;
        let user;
        host = await this.quickInputService.input({
            title: core_1.nls.localize('theia/remote/enterHost', 'Enter SSH host name'),
            placeHolder: core_1.nls.localize('theia/remote/hostPlaceHolder', 'E.g. hello@example.com')
        });
        if (!host) {
            this.messageService.error(core_1.nls.localize('theia/remote/needsHost', 'Please enter a host name.'));
            return;
        }
        if (host.includes('@')) {
            const split = host.split('@');
            user = split[0];
            host = split[1];
        }
        if (!user) {
            const configHost = await this.sshConnectionProvider.matchSSHConfigHost(host, undefined, await this.getConfigFilePath());
            if (configHost) {
                if (!user && configHost.user) {
                    user = configHost.user;
                }
            }
        }
        if (!user) {
            user = await this.quickInputService.input({
                title: core_1.nls.localize('theia/remote/enterUser', 'Enter SSH user name'),
                placeHolder: core_1.nls.localize('theia/remote/userPlaceHolder', 'E.g. hello')
            });
        }
        if (!user) {
            this.messageService.error(core_1.nls.localize('theia/remote/needsUser', 'Please enter a user name.'));
            return;
        }
        try {
            const remotePort = await this.sendSSHConnect(host, user);
            this.openRemote(remotePort, newWindow);
        }
        catch (err) {
            this.messageService.error(`${core_1.nls.localize('theia/remote/sshFailure', 'Could not open SSH connection to remote.')} ${(_a = err.message) !== null && _a !== void 0 ? _a : String(err)}`);
        }
    }
    async sendSSHConnect(host, user) {
        return this.sshConnectionProvider.establishConnection({
            host,
            user,
            nodeDownloadTemplate: this.remotePreferences['remote.nodeDownloadTemplate'],
            customConfigFile: await this.getConfigFilePath()
        });
    }
};
exports.RemoteSSHContribution = RemoteSSHContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], RemoteSSHContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_ssh_connection_provider_1.RemoteSSHConnectionProvider),
    tslib_1.__metadata("design:type", Object)
], RemoteSSHContribution.prototype, "sshConnectionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], RemoteSSHContribution.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_preferences_1.RemotePreferences),
    tslib_1.__metadata("design:type", Object)
], RemoteSSHContribution.prototype, "remotePreferences", void 0);
exports.RemoteSSHContribution = RemoteSSHContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], RemoteSSHContribution);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-browser/remote-user-storage-provider.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-browser/remote-user-storage-provider.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteUserStorageContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const user_storage_contribution_1 = __webpack_require__(/*! @theia/userstorage/lib/browser/user-storage-contribution */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js");
const remote_status_service_1 = __webpack_require__(/*! ../electron-common/remote-status-service */ "../../node_modules/@theia/remote/lib/electron-common/remote-status-service.js");
const local_backend_services_1 = __webpack_require__(/*! ./local-backend-services */ "../../node_modules/@theia/remote/lib/electron-browser/local-backend-services.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const electron_local_ws_connection_source_1 = __webpack_require__(/*! @theia/core/lib/electron-browser/messaging/electron-local-ws-connection-source */ "../../node_modules/@theia/core/lib/electron-browser/messaging/electron-local-ws-connection-source.js");
/**
 * This overide is to have remote connections still use settings, keymaps, etc. from the local machine.
 */
let RemoteUserStorageContribution = class RemoteUserStorageContribution extends user_storage_contribution_1.UserStorageContribution {
    constructor() {
        super(...arguments);
        this.isRemoteConnection = new promise_util_1.Deferred();
    }
    init() {
        const port = (0, electron_local_ws_connection_source_1.getCurrentPort)();
        if (port) {
            this.remoteStatusService.getStatus(Number(port)).then(status => this.isRemoteConnection.resolve(status.alive));
        }
    }
    async getDelegate(service) {
        return await this.isRemoteConnection.promise ?
            this.localRemoteFileSystemProvider
            : service.activateProvider('file');
    }
    async getCongigDirUri() {
        return await this.isRemoteConnection.promise ?
            new core_1.URI(await this.localEnvironments.getConfigDirUri())
            : super.getCongigDirUri();
    }
};
exports.RemoteUserStorageContribution = RemoteUserStorageContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(remote_status_service_1.RemoteStatusService),
    tslib_1.__metadata("design:type", Object)
], RemoteUserStorageContribution.prototype, "remoteStatusService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(local_backend_services_1.LocalRemoteFileSystemProvider),
    tslib_1.__metadata("design:type", local_backend_services_1.LocalRemoteFileSystemProvider)
], RemoteUserStorageContribution.prototype, "localRemoteFileSystemProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(local_backend_services_1.LocalEnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], RemoteUserStorageContribution.prototype, "localEnvironments", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], RemoteUserStorageContribution.prototype, "init", null);
exports.RemoteUserStorageContribution = RemoteUserStorageContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], RemoteUserStorageContribution);


/***/ }),

/***/ "../../node_modules/@theia/remote/lib/electron-common/remote-ssh-connection-provider.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/lib/electron-common/remote-ssh-connection-provider.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoteSSHConnectionProvider = exports.RemoteSSHConnectionProviderPath = void 0;
exports.RemoteSSHConnectionProviderPath = '/remote/ssh';
exports.RemoteSSHConnectionProvider = Symbol('RemoteSSHConnectionProvider');


/***/ }),

/***/ "../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_port_forwarding_widget_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./port-forwarding-widget.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_port_forwarding_widget_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_port_forwarding_widget_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserStorageContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const delegating_file_system_provider_1 = __webpack_require__(/*! @theia/filesystem/lib/common/delegating-file-system-provider */ "../../node_modules/@theia/filesystem/lib/common/delegating-file-system-provider.js");
const user_storage_uri_1 = __webpack_require__(/*! ./user-storage-uri */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js");
let UserStorageContribution = class UserStorageContribution {
    registerFileSystemProviders(service) {
        service.onWillActivateFileSystemProvider(event => {
            if (event.scheme === user_storage_uri_1.UserStorageUri.scheme) {
                event.waitUntil((async () => {
                    const provider = await this.createProvider(service);
                    service.registerProvider(user_storage_uri_1.UserStorageUri.scheme, provider);
                })());
            }
        });
    }
    getDelegate(service) {
        return service.activateProvider('file');
    }
    async getCongigDirUri() {
        return new uri_1.default(await this.environments.getConfigDirUri());
    }
    async createProvider(service) {
        const delegate = await this.getDelegate(service);
        const configDirUri = await this.getCongigDirUri();
        return new delegating_file_system_provider_1.DelegatingFileSystemProvider(delegate, {
            uriConverter: {
                to: resource => {
                    const relativePath = user_storage_uri_1.UserStorageUri.relative(resource);
                    if (relativePath) {
                        return configDirUri.resolve(relativePath).normalizePath();
                    }
                    return undefined;
                },
                from: resource => {
                    const relativePath = configDirUri.relative(resource);
                    if (relativePath) {
                        return user_storage_uri_1.UserStorageUri.resolve(relativePath);
                    }
                    return undefined;
                }
            }
        }, new disposable_1.DisposableCollection(delegate.watch(configDirUri, { excludes: [], recursive: true })));
    }
};
exports.UserStorageContribution = UserStorageContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], UserStorageContribution.prototype, "environments", void 0);
exports.UserStorageContribution = UserStorageContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], UserStorageContribution);


/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserStorageUri = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
exports.UserStorageUri = new uri_1.default('user-storage:/user');


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css":
/*!****************************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css ***!
  \****************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2024 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.port-table {
  width: 100%;
  margin: calc(var(--theia-ui-padding) * 2);
  table-layout: fixed;
}

.port-table-header {
  text-align: left;
}

.forward-port-button {
  margin-left: 0;
  width: 100%;
}

.button-cell {
  display: flex;
  padding-right: var(--theia-ui-padding);
}

.forwarded-address:hover {
  cursor: pointer;
  text-decoration: underline;
}

.port-edit-input-error {
  outline-color: var(--theia-inputValidation-errorBorder);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/remote/src/electron-browser/style/port-forwarding-widget.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,WAAW;EACX,yCAAyC;EACzC,mBAAmB;AACrB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,cAAc;EACd,WAAW;AACb;;AAEA;EACE,aAAa;EACb,sCAAsC;AACxC;;AAEA;EACE,eAAe;EACf,0BAA0B;AAC5B;;AAEA;EACE,uDAAuD;AACzD","sourcesContent":["/********************************************************************************\n * Copyright (C) 2024 TypeFox and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.port-table {\n  width: 100%;\n  margin: calc(var(--theia-ui-padding) * 2);\n  table-layout: fixed;\n}\n\n.port-table-header {\n  text-align: left;\n}\n\n.forward-port-button {\n  margin-left: 0;\n  width: 100%;\n}\n\n.button-cell {\n  display: flex;\n  padding-right: var(--theia-ui-padding);\n}\n\n.forwarded-address:hover {\n  cursor: pointer;\n  text-decoration: underline;\n}\n\n.port-edit-input-error {\n  outline-color: var(--theia-inputValidation-errorBorder);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/ssh-config/index.js":
/*!**********************************************!*\
  !*** ../../node_modules/ssh-config/index.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const ssh_config_1 = __importDefault(__webpack_require__(/*! ./src/ssh-config */ "../../node_modules/ssh-config/src/ssh-config.js"));
__exportStar(__webpack_require__(/*! ./src/ssh-config */ "../../node_modules/ssh-config/src/ssh-config.js"), exports);
exports["default"] = ssh_config_1.default;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/ssh-config/src/glob.js":
/*!*************************************************!*\
  !*** ../../node_modules/ssh-config/src/glob.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
function escapeChars(text, chars) {
    for (let char of chars) {
        text = text.replace(new RegExp('\\' + char, 'g'), '\\' + char);
    }
    return text;
}
function match(pattern, text) {
    pattern = escapeChars(pattern, '\\()[]{}.+^$|');
    pattern = pattern
        .replace(/\*/g, '.*')
        .replace(/\?/g, '.?');
    return new RegExp('^(?:' + pattern + ')$').test(text);
}
/**
 * A helper function to match input against [pattern-list](https://www.freebsd.org/cgi/man.cgi?query=ssh_config&sektion=5#PATTERNS).
 * According to `man ssh_config`, negated patterns shall be matched first.
 *
 * @param {string|string[]} patternList
 * @param {string} str
 */
function glob(patternList, text) {
    const patterns = Array.isArray(patternList) ? patternList : patternList.split(/,/);
    // > If a negated entry is matched, then the Host entry is ignored, regardless of whether any other patterns on the line match.
    let result = false;
    for (const pattern of patterns) {
        const negate = pattern[0] == '!';
        if (negate && match(pattern.slice(1), text)) {
            return false;
        }
        else if (match(pattern, text)) {
            // wait until all of the pattern match results because there might be a negated pattern
            result = true;
        }
    }
    return result;
}
exports["default"] = glob;
//# sourceMappingURL=glob.js.map

/***/ }),

/***/ "../../node_modules/ssh-config/src/ssh-config.js":
/*!*******************************************************!*\
  !*** ../../node_modules/ssh-config/src/ssh-config.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LineType = void 0;
exports.parse = parse;
exports.stringify = stringify;
const glob_1 = __importDefault(__webpack_require__(/*! ./glob */ "../../node_modules/ssh-config/src/glob.js"));
const child_process_1 = __webpack_require__(/*! child_process */ "?93ed");
const os_1 = __importDefault(__webpack_require__(/*! os */ "?97c8"));
const RE_SPACE = /\s/;
const RE_LINE_BREAK = /\r|\n/;
const RE_SECTION_DIRECTIVE = /^(Host|Match)$/i;
const RE_MULTI_VALUE_DIRECTIVE = /^(GlobalKnownHostsFile|Host|IPQoS|SendEnv|UserKnownHostsFile|ProxyCommand|Match|CanonicalDomains)$/i;
const RE_QUOTE_DIRECTIVE = /^(?:CertificateFile|IdentityFile|IdentityAgent|User)$/i;
const RE_SINGLE_LINE_DIRECTIVE = /^(Include|IdentityFile)$/i;
var LineType;
(function (LineType) {
    LineType[LineType["DIRECTIVE"] = 1] = "DIRECTIVE";
    LineType[LineType["COMMENT"] = 2] = "COMMENT";
})(LineType || (exports.LineType = LineType = {}));
const REPEATABLE_DIRECTIVES = [
    'IdentityFile',
    'LocalForward',
    'RemoteForward',
    'DynamicForward',
    'CertificateFile',
];
function compare(line, opts) {
    return opts.hasOwnProperty(line.param) && opts[line.param] === line.value;
}
function getIndent(config) {
    for (const line of config) {
        if (line.type === LineType.DIRECTIVE && 'config' in line) {
            for (const subline of line.config) {
                if (subline.before) {
                    return subline.before;
                }
            }
        }
    }
    return '  ';
}
function match(criteria, context) {
    const testCriterion = (key, criterion) => {
        switch (key.toLowerCase()) {
            case 'all':
                return true;
            case 'final':
                if (context.inFinalPass) {
                    return true;
                }
                context.doFinalPass = true;
                return false;
            case 'exec':
                const command = `function main {
          ${criterion}
        }
        main`;
                return (0, child_process_1.spawnSync)(command, { shell: true }).status === 0;
            case 'host':
                return (0, glob_1.default)(criterion, context.params.HostName);
            case 'originalhost':
                return (0, glob_1.default)(criterion, context.params.OriginalHost);
            case 'user':
                return (0, glob_1.default)(criterion, context.params.User);
            case 'localuser':
                return (0, glob_1.default)(criterion, context.params.LocalUser);
        }
    };
    for (const key in criteria) {
        const criterion = criteria[key];
        const values = Array.isArray(criterion) ? criterion.map(({ val }) => val) : criterion;
        if (!testCriterion(key, values)) {
            return false;
        }
    }
    return true;
}
class SSHConfig extends Array {
    /**
     * Parse SSH config text into structured object.
     */
    static parse(text) {
        return parse(text);
    }
    /**
     * Stringify structured object into SSH config text.
     */
    static stringify(config) {
        return stringify(config);
    }
    compute(opts) {
        if (typeof opts === 'string')
            opts = { Host: opts };
        let userInfo;
        try {
            userInfo = os_1.default.userInfo();
        }
        catch (_a) {
            // os.userInfo() throws a SystemError if a user has no username or homedir.
            userInfo = { username: process.env.USER || process.env.USERNAME || '' };
        }
        const context = {
            params: {
                Host: opts.Host,
                HostName: opts.Host,
                OriginalHost: opts.Host,
                User: userInfo.username,
                LocalUser: userInfo.username,
            },
            inFinalPass: false,
            doFinalPass: false,
        };
        const obj = {};
        const setProperty = (name, value) => {
            let val;
            if (Array.isArray(value)) {
                if (/ProxyCommand/i.test(name)) {
                    val = value.map(({ val, separator, quoted }) => {
                        return `${separator}${quoted ? `"${val.replace(/"/g, '\\"')}"` : val}`;
                    }).join('').trim();
                }
                else {
                    val = value.map(({ val }) => val);
                }
            }
            else {
                val = value;
            }
            const val0 = Array.isArray(val) ? val[0] : val;
            if (REPEATABLE_DIRECTIVES.includes(name)) {
                const list = (obj[name] || (obj[name] = []));
                list.push(...[].concat(val));
            }
            else if (obj[name] == null) {
                if (name === 'HostName') {
                    context.params.HostName = val0;
                }
                else if (name === 'User') {
                    context.params.User = val0;
                }
                obj[name] = val;
            }
        };
        if (opts.User !== undefined) {
            setProperty('User', opts.User);
        }
        const doPass = () => {
            for (const line of this) {
                if (line.type !== LineType.DIRECTIVE)
                    continue;
                if (line.param === 'Host' && (0, glob_1.default)(Array.isArray(line.value) ? line.value.map(({ val }) => val) : line.value, context.params.Host)) {
                    let canonicalizeHostName = false;
                    let canonicalDomains = [];
                    setProperty(line.param, line.value);
                    for (const subline of line.config) {
                        if (subline.type === LineType.DIRECTIVE) {
                            setProperty(subline.param, subline.value);
                            if (/^CanonicalizeHostName$/i.test(subline.param) && subline.value === 'yes') {
                                canonicalizeHostName = true;
                            }
                            if (/^CanonicalDomains$/i.test(subline.param) && Array.isArray(subline.value)) {
                                canonicalDomains = subline.value.map(({ val }) => val);
                            }
                        }
                    }
                    if (canonicalDomains.length > 0 && canonicalizeHostName && context.params.Host === context.params.OriginalHost) {
                        for (const domain of canonicalDomains) {
                            const host = `${context.params.OriginalHost}.${domain}`;
                            const { status, stderr } = (0, child_process_1.spawnSync)('nslookup', [host]);
                            if (status === 0 && !/can't find/.test(stderr.toString())) {
                                context.params.Host = host;
                                setProperty('Host', host);
                                doPass();
                                break;
                            }
                        }
                    }
                }
                else if (line.param === 'Match' && 'criteria' in line && match(line.criteria, context)) {
                    for (const subline of line.config) {
                        if (subline.type === LineType.DIRECTIVE) {
                            setProperty(subline.param, subline.value);
                        }
                    }
                }
                else if (line.param !== 'Host' && line.param !== 'Match') {
                    setProperty(line.param, line.value);
                }
            }
        };
        doPass();
        if (context.doFinalPass) {
            context.inFinalPass = true;
            context.params.Host = context.params.HostName;
            doPass();
        }
        return obj;
    }
    find(opts) {
        if (typeof opts === 'function')
            return super.find(opts);
        if (!(opts && ('Host' in opts || 'Match' in opts))) {
            throw new Error('Can only find by Host or Match');
        }
        return super.find(line => compare(line, opts));
    }
    remove(opts) {
        let index;
        if (typeof opts === 'function') {
            index = super.findIndex(opts);
        }
        else if (!(opts && ('Host' in opts || 'Match' in opts))) {
            throw new Error('Can only remove by Host or Match');
        }
        else {
            index = super.findIndex(line => compare(line, opts));
        }
        if (index >= 0)
            return this.splice(index, 1);
    }
    toString() {
        return stringify(this);
    }
    /**
     * Append new section to existing SSH config.
     */
    append(opts) {
        const indent = getIndent(this);
        const lastEntry = this.length > 0 ? this[this.length - 1] : null;
        let config = lastEntry && lastEntry.config || this;
        let configWas = this;
        let lastLine = config.length > 0 ? config[config.length - 1] : lastEntry;
        if (lastLine && !lastLine.after)
            lastLine.after = '\n';
        let sectionLineFound = config !== configWas;
        for (const param in opts) {
            const value = opts[param];
            const line = {
                type: LineType.DIRECTIVE,
                param,
                separator: ' ',
                value: Array.isArray(value) ? value.map((val, i) => ({ val, separator: i === 0 ? '' : ' ' })) : value,
                before: sectionLineFound ? indent : indent.replace(/  |\t/, ''),
                after: '\n',
            };
            if (RE_SECTION_DIRECTIVE.test(param)) {
                sectionLineFound = true;
                line.before = indent.replace(/  |\t/, '');
                config = configWas;
                // separate sections with an extra newline
                // https://github.com/cyjake/ssh-config/issues/23#issuecomment-564768248
                if (lastLine && lastLine.after === '\n')
                    lastLine.after += '\n';
                config.push(line);
                config = line.config = new SSHConfig();
            }
            else {
                config.push(line);
            }
            lastLine = line;
        }
        return configWas;
    }
    /**
     * Prepend new section to existing SSH config.
     */
    prepend(opts, beforeFirstSection = false) {
        const indent = getIndent(this);
        let config = this;
        let i = 0;
        // insert above known sections
        if (beforeFirstSection) {
            while (i < this.length && !('config' in this[i])) {
                i += 1;
            }
            if (i >= this.length) { // No sections in original config
                return this.append(opts);
            }
        }
        // Prepend new section above the first section
        let sectionLineFound = false;
        let processedLines = 0;
        for (const param in opts) {
            processedLines += 1;
            const value = opts[param];
            const line = {
                type: LineType.DIRECTIVE,
                param,
                separator: ' ',
                value: Array.isArray(value) ? value.map((val, i) => ({ val, separator: i === 0 ? '' : ' ' })) : value,
                before: '',
                after: '\n',
            };
            if (RE_SECTION_DIRECTIVE.test(param)) {
                line.before = indent.replace(/  |\t/, '');
                config.splice(i, 0, line);
                config = line.config = new SSHConfig();
                sectionLineFound = true;
                continue;
            }
            // separate from previous sections with an extra newline
            if (processedLines === Object.keys(opts).length) {
                line.after += '\n';
            }
            if (!sectionLineFound) {
                config.splice(i, 0, line);
                i += 1;
                // Add an extra newline if a single line directive like Include
                if (RE_SINGLE_LINE_DIRECTIVE.test(param)) {
                    line.after += '\n';
                }
                continue;
            }
            line.before = indent;
            config.push(line);
        }
        return config;
    }
}
SSHConfig.DIRECTIVE = LineType.DIRECTIVE;
SSHConfig.COMMENT = LineType.COMMENT;
exports["default"] = SSHConfig;
/**
 * Parse SSH config text into structured object.
 */
function parse(text) {
    let i = 0;
    let chr = next();
    let config = new SSHConfig();
    let configWas = config;
    function next() {
        return text[i++];
    }
    function space() {
        let spaces = '';
        while (RE_SPACE.test(chr)) {
            spaces += chr;
            chr = next();
        }
        return spaces;
    }
    function linebreak() {
        let breaks = '';
        while (RE_LINE_BREAK.test(chr)) {
            breaks += chr;
            chr = next();
        }
        return breaks;
    }
    function parameter() {
        let param = '';
        while (chr && /[^ \t=]/.test(chr)) {
            param += chr;
            chr = next();
        }
        return param;
    }
    function separator() {
        let sep = space();
        if (chr === '=') {
            sep += chr;
            chr = next();
        }
        return (sep + space());
    }
    function value() {
        let val = '';
        let quoted = false;
        let escaped = false;
        while (chr && !RE_LINE_BREAK.test(chr)) {
            // backslash escapes only double quotes
            if (escaped) {
                val += chr === '"' ? chr : `\\${chr}`;
                escaped = false;
            }
            // ProxyCommand ssh -W "%h:%p" firewall.example.org
            else if (chr === '"' && (!val || quoted)) {
                quoted = !quoted;
            }
            else if (chr === '\\') {
                escaped = true;
            }
            else if (chr === '#' && !quoted) {
                break;
            }
            else {
                val += chr;
            }
            chr = next();
        }
        if (quoted || escaped) {
            throw new Error(`Unexpected line break at ${val}`);
        }
        return val.trim();
    }
    function comment() {
        const type = LineType.COMMENT;
        let content = '';
        while (chr && !RE_LINE_BREAK.test(chr)) {
            content += chr;
            chr = next();
        }
        return { type, content, before: '', after: '' };
    }
    // Host *.co.uk
    // Host * !local.dev
    // Host "foo bar"
    function values() {
        const results = [];
        let val = '';
        // whether current value is quoted or not
        let valQuoted = false;
        // the separator preceding current value
        let valSeparator = ' ';
        // whether current context is within quotations or not
        let quoted = false;
        let escaped = false;
        while (chr && !RE_LINE_BREAK.test(chr)) {
            if (escaped) {
                val += chr === '"' ? chr : `\\${chr}`;
                escaped = false;
            }
            else if (chr === '"') {
                quoted = !quoted;
            }
            else if (chr === '\\') {
                escaped = true;
            }
            else if (quoted) {
                val += chr;
                valQuoted = true;
            }
            else if (/[ \t=]/.test(chr)) {
                if (val) {
                    results.push({ val, separator: valSeparator, quoted: valQuoted });
                    val = '';
                    valQuoted = false;
                    valSeparator = chr;
                }
                // otherwise ignore the space
            }
            else if (chr === '#' && results.length > 0) {
                break;
            }
            else {
                val += chr;
            }
            chr = next();
        }
        if (quoted || escaped) {
            throw new Error(`Unexpected line break at ${results.map(({ val }) => val).concat(val).join(' ')}`);
        }
        if (val)
            results.push({ val, separator: valSeparator, quoted: valQuoted });
        return results.length > 1 ? results : results[0].val;
    }
    function directive() {
        const type = LineType.DIRECTIVE;
        const param = parameter();
        // Host "foo bar" baz
        const multiple = RE_MULTI_VALUE_DIRECTIVE.test(param);
        const result = {
            type,
            param,
            separator: separator(),
            quoted: !multiple && chr === '"',
            value: multiple ? values() : value(),
            before: '',
            after: '',
        };
        if (!result.quoted)
            delete result.quoted;
        if (/^Match$/i.test(param)) {
            const criteria = {};
            if (typeof result.value === 'string') {
                result.value = [{ val: result.value, separator: '', quoted: result.quoted }];
            }
            let i = 0;
            while (i < result.value.length) {
                const { val: keyword } = result.value[i];
                switch (keyword.toLowerCase()) {
                    case 'all':
                    case 'canonical':
                    case 'final':
                        criteria[keyword] = [];
                        i += 1;
                        break;
                    default:
                        if (i + 1 >= result.value.length) {
                            throw new Error(`Missing value for match criteria ${keyword}`);
                        }
                        criteria[keyword] = result.value[i + 1].val;
                        i += 2;
                        break;
                }
            }
            result.criteria = criteria;
        }
        return result;
    }
    function line() {
        const before = space();
        const node = chr === '#' ? comment() : directive();
        const after = linebreak();
        node.before = before;
        node.after = after;
        return node;
    }
    while (chr) {
        let node = line();
        if (node.type === LineType.DIRECTIVE && RE_SECTION_DIRECTIVE.test(node.param)) {
            config = configWas;
            config.push(node);
            config = node.config = new SSHConfig();
        }
        else if (node.type === LineType.DIRECTIVE && !node.param) {
            // blank lines at file end
            if (config.length === 0) {
                configWas[configWas.length - 1].after += node.before;
            }
            else {
                config[config.length - 1].after += node.before;
            }
        }
        else {
            config.push(node);
        }
    }
    return configWas;
}
/**
 * Stringify structured object into SSH config text.
 */
function stringify(config) {
    let str = '';
    function formatValue(value, quoted) {
        if (Array.isArray(value)) {
            let result = '';
            for (const { val, separator, quoted } of value) {
                result += (result ? separator : '') + formatValue(val, quoted || RE_SPACE.test(val));
            }
            return result;
        }
        return quoted ? `"${value}"` : value;
    }
    function formatDirective(line) {
        const quoted = line.quoted
            || (RE_QUOTE_DIRECTIVE.test(line.param) && RE_SPACE.test(line.value));
        const value = formatValue(line.value, quoted);
        return `${line.param}${line.separator}${value}`;
    }
    const format = (line) => {
        str += line.before;
        if (line.type === LineType.COMMENT) {
            str += line.content;
        }
        else if (line.type === LineType.DIRECTIVE && REPEATABLE_DIRECTIVES.includes(line.param)) {
            (Array.isArray(line.value) ? line.value : [line.value]).forEach((value, i, values) => {
                str += formatDirective({ ...line, value: typeof value !== 'string' ? value.val : value });
                if (i < values.length - 1)
                    str += `\n${line.before}`;
            });
        }
        else if (line.type === LineType.DIRECTIVE) {
            str += formatDirective(line);
        }
        str += line.after;
        if ('config' in line) {
            line.config.forEach(format);
        }
    };
    config.forEach(format);
    return str;
}
//# sourceMappingURL=ssh-config.js.map

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_remote_lib_electron-browser_remote-frontend-module_js.js.map