"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_plugin-ext-vscode_lib_common_plugin-vscode-uri_js-node_modules_the-5304ff"],{

/***/ "../../node_modules/@theia/ovsx-client/lib/index.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OVSXRouterClient = exports.OVSXMockClient = exports.OVSX_RATE_LIMIT = exports.OVSXHttpClient = exports.OVSXApiFilterProvider = exports.OVSXApiFilterImpl = exports.OVSXApiFilter = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
var ovsx_api_filter_1 = __webpack_require__(/*! ./ovsx-api-filter */ "../../node_modules/@theia/ovsx-client/lib/ovsx-api-filter.js");
Object.defineProperty(exports, "OVSXApiFilter", ({ enumerable: true, get: function () { return ovsx_api_filter_1.OVSXApiFilter; } }));
Object.defineProperty(exports, "OVSXApiFilterImpl", ({ enumerable: true, get: function () { return ovsx_api_filter_1.OVSXApiFilterImpl; } }));
Object.defineProperty(exports, "OVSXApiFilterProvider", ({ enumerable: true, get: function () { return ovsx_api_filter_1.OVSXApiFilterProvider; } }));
var ovsx_http_client_1 = __webpack_require__(/*! ./ovsx-http-client */ "../../node_modules/@theia/ovsx-client/lib/ovsx-http-client.js");
Object.defineProperty(exports, "OVSXHttpClient", ({ enumerable: true, get: function () { return ovsx_http_client_1.OVSXHttpClient; } }));
Object.defineProperty(exports, "OVSX_RATE_LIMIT", ({ enumerable: true, get: function () { return ovsx_http_client_1.OVSX_RATE_LIMIT; } }));
var ovsx_mock_client_1 = __webpack_require__(/*! ./ovsx-mock-client */ "../../node_modules/@theia/ovsx-client/lib/ovsx-mock-client.js");
Object.defineProperty(exports, "OVSXMockClient", ({ enumerable: true, get: function () { return ovsx_mock_client_1.OVSXMockClient; } }));
var ovsx_router_client_1 = __webpack_require__(/*! ./ovsx-router-client */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-client.js");
Object.defineProperty(exports, "OVSXRouterClient", ({ enumerable: true, get: function () { return ovsx_router_client_1.OVSXRouterClient; } }));
tslib_1.__exportStar(__webpack_require__(/*! ./ovsx-router-filters */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/index.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ovsx-types */ "../../node_modules/@theia/ovsx-client/lib/ovsx-types.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-api-filter.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-api-filter.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OVSXApiFilterImpl = exports.OVSXApiFilter = exports.OVSXApiFilterProvider = void 0;
const semver = __webpack_require__(/*! semver */ "../../node_modules/semver/index.js");
const ovsx_types_1 = __webpack_require__(/*! ./ovsx-types */ "../../node_modules/@theia/ovsx-client/lib/ovsx-types.js");
exports.OVSXApiFilterProvider = Symbol('OVSXApiFilterProvider');
exports.OVSXApiFilter = Symbol('OVSXApiFilter');
class OVSXApiFilterImpl {
    constructor(client, supportedApiVersion) {
        this.client = client;
        this.supportedApiVersion = supportedApiVersion;
    }
    async findLatestCompatibleExtension(query) {
        const targetPlatform = query.targetPlatform;
        if (!targetPlatform) {
            return this.queryLatestCompatibleExtension(query);
        }
        const latestWithTargetPlatform = await this.queryLatestCompatibleExtension(query);
        let latestUniversal;
        if (targetPlatform !== 'universal' && targetPlatform !== 'web') {
            // Additionally query the universal version, as there might be a newer one available
            latestUniversal = await this.queryLatestCompatibleExtension({ ...query, targetPlatform: 'universal' });
        }
        if (latestWithTargetPlatform && latestUniversal) {
            // Prefer the version with the target platform if it's greater or equal to the universal version
            return this.versionGreaterThanOrEqualTo(latestWithTargetPlatform.version, latestUniversal.version) ? latestWithTargetPlatform : latestUniversal;
        }
        return latestWithTargetPlatform !== null && latestWithTargetPlatform !== void 0 ? latestWithTargetPlatform : latestUniversal;
    }
    async queryLatestCompatibleExtension(query) {
        let offset = 0;
        let size = 5;
        let loop = true;
        while (loop) {
            const queryOptions = {
                ...query,
                offset,
                size // there is a great chance that the newest version will work
            };
            const results = await this.client.query(queryOptions);
            const compatibleExtension = this.getLatestCompatibleExtension(results.extensions);
            if (compatibleExtension) {
                return compatibleExtension;
            }
            // Adjust offset by the amount of returned extensions
            offset += results.extensions.length;
            // Continue querying if there are more extensions available
            loop = results.totalSize > offset;
            // Adjust the size to fetch more extensions next time
            size = Math.min(size * 2, 100);
        }
        return undefined;
    }
    getLatestCompatibleExtension(extensions) {
        if (extensions.length === 0) {
            return;
        }
        else if (this.isBuiltinNamespace(extensions[0].namespace.toLowerCase())) {
            return extensions.find(extension => this.versionGreaterThanOrEqualTo(this.supportedApiVersion, extension.version));
        }
        else {
            return extensions.find(extension => { var _a, _b; return this.supportedVscodeApiSatisfies((_b = (_a = extension.engines) === null || _a === void 0 ? void 0 : _a.vscode) !== null && _b !== void 0 ? _b : '*'); });
        }
    }
    getLatestCompatibleVersion(searchEntry) {
        function getLatestCompatibleVersion(predicate) {
            if (searchEntry.allVersions) {
                return searchEntry.allVersions.find(predicate);
            }
            // If the allVersions field is missing then try to use the
            // searchEntry as VSXAllVersions and check if it's compatible:
            if (predicate(searchEntry)) {
                return searchEntry;
            }
        }
        if (this.isBuiltinNamespace(searchEntry.namespace)) {
            return getLatestCompatibleVersion(allVersions => this.versionGreaterThanOrEqualTo(this.supportedApiVersion, allVersions.version));
        }
        else {
            return getLatestCompatibleVersion(allVersions => { var _a, _b; return this.supportedVscodeApiSatisfies((_b = (_a = allVersions.engines) === null || _a === void 0 ? void 0 : _a.vscode) !== null && _b !== void 0 ? _b : '*'); });
        }
    }
    isBuiltinNamespace(namespace) {
        return ovsx_types_1.VSXBuiltinNamespaces.is(namespace);
    }
    /**
     * @returns `a >= b`
     */
    versionGreaterThanOrEqualTo(a, b) {
        const versionA = semver.clean(a);
        const versionB = semver.clean(b);
        if (!versionA || !versionB) {
            return false;
        }
        return semver.gte(versionA, versionB);
    }
    supportedVscodeApiSatisfies(vscodeApiRange) {
        return semver.satisfies(this.supportedApiVersion, vscodeApiRange);
    }
}
exports.OVSXApiFilterImpl = OVSXApiFilterImpl;


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-http-client.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-http-client.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OVSXHttpClient = exports.OVSX_RATE_LIMIT = void 0;
const request_1 = __webpack_require__(/*! @theia/request */ "../../node_modules/@theia/request/lib/index.js");
const limiter_1 = __webpack_require__(/*! limiter */ "../../node_modules/limiter/dist/cjs/index.js");
exports.OVSX_RATE_LIMIT = 15;
class OVSXHttpClient {
    /**
     * @param requestService
     * @returns factory that will cache clients based on the requested input URL.
     */
    static createClientFactory(requestService, rateLimiter) {
        // eslint-disable-next-line no-null/no-null
        const cachedClients = Object.create(null);
        return url => { var _a; return (_a = cachedClients[url]) !== null && _a !== void 0 ? _a : (cachedClients[url] = new this(url, requestService, rateLimiter)); };
    }
    constructor(vsxRegistryUrl, requestService, rateLimiter = new limiter_1.RateLimiter({ tokensPerInterval: exports.OVSX_RATE_LIMIT, interval: 'second' })) {
        this.vsxRegistryUrl = vsxRegistryUrl;
        this.requestService = requestService;
        this.rateLimiter = rateLimiter;
    }
    search(searchOptions) {
        return this.requestJson(this.buildUrl('api/-/search', searchOptions));
    }
    query(queryOptions) {
        return this.requestJson(this.buildUrl('api/v2/-/query', queryOptions));
    }
    async requestJson(url) {
        const attempts = 5;
        for (let i = 0; i < attempts; i++) {
            // Use 1, 2, 4, 8, 16 tokens for each attempt
            const tokenCount = Math.pow(2, i);
            await this.rateLimiter.removeTokens(tokenCount);
            const context = await this.requestService.request({
                url,
                headers: { 'Accept': 'application/json' }
            });
            if (context.res.statusCode === 429) {
                console.warn('OVSX rate limit exceeded. Consider reducing the rate limit.');
                // If there are still more attempts left, retry the request with a higher token count
                if (i < attempts - 1) {
                    continue;
                }
            }
            return request_1.RequestContext.asJson(context);
        }
        throw new Error('Failed to fetch data from OVSX.');
    }
    buildUrl(url, query) {
        return new URL(`${url}${this.buildQueryString(query)}`, this.vsxRegistryUrl).toString();
    }
    buildQueryString(searchQuery) {
        if (!searchQuery) {
            return '';
        }
        let queryString = '';
        for (const [key, value] of Object.entries(searchQuery)) {
            if (typeof value === 'string') {
                queryString += `&${key}=${encodeURIComponent(value)}`;
            }
            else if (typeof value === 'boolean' || typeof value === 'number') {
                queryString += `&${key}=${value}`;
            }
        }
        return queryString && '?' + queryString.slice(1);
    }
}
exports.OVSXHttpClient = OVSXHttpClient;


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-mock-client.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-mock-client.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OVSXMockClient = void 0;
/**
 * Querying will only find exact matches.
 * Searching will try to find the query string in various fields.
 */
class OVSXMockClient {
    constructor(extensions = []) {
        this.extensions = extensions;
    }
    setExtensions(extensions) {
        this.extensions = extensions;
        return this;
    }
    /**
     * @param baseUrl required to construct the URLs required by {@link VSXExtensionRaw}.
     * @param ids list of ids to generate {@link VSXExtensionRaw} from.
     */
    setExtensionsFromIds(baseUrl, ids) {
        const now = Date.now();
        const url = new OVSXMockClient.UrlBuilder(baseUrl);
        this.extensions = ids.map((extension, i) => {
            const [id, version = '0.0.1'] = extension.split('@', 2);
            const [namespace, name] = id.split('.', 2);
            return {
                allVersions: {
                    [version]: url.extensionUrl(namespace, name, `/${version}`)
                },
                displayName: name,
                downloadCount: 0,
                files: {
                    download: url.extensionFileUrl(namespace, name, version, `/${id}-${version}.vsix`)
                },
                name,
                namespace,
                namespaceAccess: 'public',
                namespaceUrl: url.namespaceUrl(namespace),
                publishedBy: {
                    loginName: 'mock'
                },
                reviewCount: 0,
                reviewsUrl: url.extensionReviewsUrl(namespace, name),
                timestamp: new Date(now - ids.length + i + 1).toISOString(),
                version,
                description: `Mock VS Code Extension for ${id}`,
                namespaceDisplayName: name,
                preRelease: false
            };
        });
        return this;
    }
    async query(queryOptions) {
        const extensions = this.extensions
            .filter(extension => typeof queryOptions === 'object' && (this.compare(queryOptions.extensionId, this.id(extension)) &&
            this.compare(queryOptions.extensionName, extension.name) &&
            this.compare(queryOptions.extensionVersion, extension.version) &&
            this.compare(queryOptions.namespaceName, extension.namespace)));
        return {
            offset: 0,
            totalSize: extensions.length,
            extensions
        };
    }
    async search(searchOptions) {
        var _a, _b;
        const query = searchOptions === null || searchOptions === void 0 ? void 0 : searchOptions.query;
        const offset = (_a = searchOptions === null || searchOptions === void 0 ? void 0 : searchOptions.offset) !== null && _a !== void 0 ? _a : 0;
        const size = (_b = searchOptions === null || searchOptions === void 0 ? void 0 : searchOptions.size) !== null && _b !== void 0 ? _b : 18;
        const end = offset + size;
        return {
            offset,
            extensions: this.extensions
                .filter(extension => typeof query !== 'string' || (this.includes(query, this.id(extension)) ||
                this.includes(query, extension.description) ||
                this.includes(query, extension.displayName)))
                .sort((a, b) => this.sort(a, b, searchOptions))
                .filter((extension, i) => i >= offset && i < end)
                .map(extension => ({
                downloadCount: extension.downloadCount,
                files: extension.files,
                name: extension.name,
                namespace: extension.namespace,
                timestamp: extension.timestamp,
                url: `${extension.namespaceUrl}/${extension.name}`,
                version: extension.version,
            }))
        };
    }
    id(extension) {
        return `${extension.namespace}.${extension.name}`;
    }
    /**
     * Case sensitive.
     */
    compare(expected, value) {
        return expected === undefined || value === undefined || expected === value;
    }
    /**
     * Case insensitive.
     */
    includes(needle, value) {
        return value === undefined || value.toLowerCase().includes(needle.toLowerCase());
    }
    sort(a, b, searchOptions) {
        var _a, _b, _c, _d;
        let order = 0;
        const sortBy = (_a = searchOptions === null || searchOptions === void 0 ? void 0 : searchOptions.sortBy) !== null && _a !== void 0 ? _a : 'relevance';
        const sortOrder = (_b = searchOptions === null || searchOptions === void 0 ? void 0 : searchOptions.sortOrder) !== null && _b !== void 0 ? _b : 'desc';
        if (sortBy === 'averageRating') {
            order = ((_c = a.averageRating) !== null && _c !== void 0 ? _c : -1) - ((_d = b.averageRating) !== null && _d !== void 0 ? _d : -1);
        }
        else if (sortBy === 'downloadCount') {
            order = a.downloadCount - b.downloadCount;
        }
        else if (sortBy === 'relevance') {
            order = 0;
        }
        else if (sortBy === 'timestamp') {
            order = new Date(a.timestamp).getTime() - new Date(b.timestamp).getTime();
        }
        if (sortOrder === 'asc') {
            order *= -1;
        }
        return order;
    }
}
exports.OVSXMockClient = OVSXMockClient;
(function (OVSXMockClient) {
    /**
     * URLs should respect the official OpenVSX API:
     * https://open-vsx.org/swagger-ui/index.html
     */
    class UrlBuilder {
        constructor(baseUrl) {
            this.baseUrl = baseUrl;
        }
        url(path) {
            return this.baseUrl + path;
        }
        apiUrl(path) {
            return this.url(`/api${path}`);
        }
        namespaceUrl(namespace, path = '') {
            return this.apiUrl(`/${namespace}${path}`);
        }
        extensionUrl(namespace, name, path = '') {
            return this.apiUrl(`/${namespace}/${name}${path}`);
        }
        extensionReviewsUrl(namespace, name) {
            return this.apiUrl(`/${namespace}/${name}/reviews`);
        }
        extensionFileUrl(namespace, name, version, path = '') {
            return this.apiUrl(`/${namespace}/${name}/${version}/file${path}`);
        }
    }
    OVSXMockClient.UrlBuilder = UrlBuilder;
})(OVSXMockClient || (exports.OVSXMockClient = OVSXMockClient = {}));


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-client.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-router-client.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OVSXRouterClient = exports.createFilterFactory = void 0;
/**
 * Helper function to create factories that handle a single condition key.
 */
function createFilterFactory(conditionKey, factory) {
    return (conditions, remainingKeys) => {
        if (conditionKey in conditions) {
            const filter = factory(conditions[conditionKey]);
            if (filter) {
                remainingKeys.delete(conditionKey);
                return filter;
            }
        }
    };
}
exports.createFilterFactory = createFilterFactory;
/**
 * Route and agglomerate queries according to {@link routerConfig}.
 * {@link ruleFactories} is the actual logic used to evaluate the config.
 * Each rule implementation will be ran sequentially over each configured rule.
 */
class OVSXRouterClient {
    static async FromConfig(routerConfig, clientProvider, filterFactories) {
        const rules = routerConfig.rules ? await this.ParseRules(routerConfig.rules, filterFactories, routerConfig.registries) : [];
        return new this(this.ParseUse(routerConfig.use, routerConfig.registries), clientProvider, rules);
    }
    static async ParseRules(rules, filterFactories, aliases) {
        return Promise.all(rules.map(async ({ use, ...conditions }) => {
            const remainingKeys = new Set(Object.keys(conditions));
            const filters = removeNullValues(await Promise.all(filterFactories.map(filterFactory => filterFactory(conditions, remainingKeys))));
            if (remainingKeys.size > 0) {
                throw new Error(`unknown conditions: ${Array.from(remainingKeys).join(', ')}`);
            }
            return {
                filters,
                use: this.ParseUse(use, aliases)
            };
        }));
    }
    static ParseUse(use, aliases) {
        if (typeof use === 'string') {
            return [alias(use)];
        }
        else if (Array.isArray(use)) {
            return use.map(alias);
        }
        else {
            return [];
        }
        function alias(aliasOrUri) {
            var _a;
            return (_a = aliases === null || aliases === void 0 ? void 0 : aliases[aliasOrUri]) !== null && _a !== void 0 ? _a : aliasOrUri;
        }
    }
    constructor(useDefault, clientProvider, rules) {
        this.useDefault = useDefault;
        this.clientProvider = clientProvider;
        this.rules = rules;
    }
    async search(searchOptions) {
        return this.runRules(filter => { var _a; return (_a = filter.filterSearchOptions) === null || _a === void 0 ? void 0 : _a.call(filter, searchOptions); }, rule => rule.use.length > 0
            ? this.mergedSearch(rule.use, searchOptions)
            : this.emptySearchResult(searchOptions), () => this.mergedSearch(this.useDefault, searchOptions));
    }
    async query(queryOptions = {}) {
        return this.runRules(filter => { var _a; return (_a = filter.filterQueryOptions) === null || _a === void 0 ? void 0 : _a.call(filter, queryOptions); }, rule => rule.use.length > 0
            ? this.mergedQuery(rule.use, queryOptions)
            : this.emptyQueryResult(queryOptions), () => this.mergedQuery(this.useDefault, queryOptions));
    }
    emptySearchResult(searchOptions) {
        var _a;
        return {
            extensions: [],
            offset: (_a = searchOptions === null || searchOptions === void 0 ? void 0 : searchOptions.offset) !== null && _a !== void 0 ? _a : 0
        };
    }
    emptyQueryResult(queryOptions) {
        return {
            offset: 0,
            totalSize: 0,
            extensions: []
        };
    }
    async mergedQuery(registries, queryOptions) {
        return this.mergeQueryResults(await createMapping(registries, async (registry) => (await this.clientProvider(registry)).query(queryOptions)));
    }
    async mergedSearch(registries, searchOptions) {
        return this.mergeSearchResults(await createMapping(registries, async (registry) => (await this.clientProvider(registry)).search(searchOptions)));
    }
    async mergeSearchResults(results) {
        const filtering = [];
        results.forEach((result, sourceUri) => {
            filtering.push(Promise
                .all(result.extensions.map(extension => this.filterExtension(sourceUri, extension)))
                .then(removeNullValues));
        });
        return {
            extensions: interleave(await Promise.all(filtering)),
            offset: Math.min(...Array.from(results.values(), result => result.offset))
        };
    }
    async mergeQueryResults(results) {
        const filtering = [];
        results.forEach((result, sourceUri) => {
            result.extensions.forEach(extension => filtering.push(this.filterExtension(sourceUri, extension)));
        });
        const extensions = removeNullValues(await Promise.all(filtering));
        return {
            offset: 0,
            totalSize: extensions.length,
            extensions
        };
    }
    async filterExtension(sourceUri, extension) {
        return this.runRules(filter => { var _a; return (_a = filter.filterExtension) === null || _a === void 0 ? void 0 : _a.call(filter, extension); }, rule => rule.use.includes(sourceUri) ? extension : undefined, () => extension);
    }
    async runRules(runFilter, onRuleMatched, onNoRuleMatched) {
        for (const rule of this.rules) {
            const results = removeNullValues(await Promise.all(rule.filters.map(filter => runFilter(filter))));
            if (results.length > 0 && results.every(value => value)) {
                return onRuleMatched(rule);
            }
        }
        return onNoRuleMatched === null || onNoRuleMatched === void 0 ? void 0 : onNoRuleMatched();
    }
}
exports.OVSXRouterClient = OVSXRouterClient;
function nonNullable(value) {
    // eslint-disable-next-line no-null/no-null
    return typeof value !== 'undefined' && value !== null;
}
function removeNullValues(values) {
    return values.filter(nonNullable);
}
/**
 * Create a map where the keys are each element from {@link values} and the
 * values are the result of a mapping function applied on the key.
 */
async function createMapping(values, map, thisArg) {
    return new Map(await Promise.all(values.map(async (value, index) => [value, await map.call(thisArg, value, index)])));
}
/**
 * @example
 * interleave([[1, 2, 3], [4, 5], [6, 7, 8]]) === [1, 4, 6, 2, 5, 7, 3, 8]
 */
function interleave(arrays) {
    const interleaved = [];
    const length = Math.max(...arrays.map(array => array.length));
    for (let i = 0; i < length; i++) {
        for (const array of arrays) {
            if (i < array.length) {
                interleaved.push(array[i]);
            }
        }
    }
    return interleaved;
}


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/abstract-reg-exp-filter.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/abstract-reg-exp-filter.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractRegExpFilter = void 0;
class AbstractRegExpFilter {
    constructor(regExp) {
        this.regExp = regExp;
    }
    test(value) {
        return typeof value === 'string' && this.regExp.test(value);
    }
}
exports.AbstractRegExpFilter = AbstractRegExpFilter;


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/extension-id-matches-filter.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/extension-id-matches-filter.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExtensionIdMatchesFilter = exports.ExtensionIdMatchesFilterFactory = void 0;
const ovsx_router_client_1 = __webpack_require__(/*! ../ovsx-router-client */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-client.js");
const ovsx_types_1 = __webpack_require__(/*! ../ovsx-types */ "../../node_modules/@theia/ovsx-client/lib/ovsx-types.js");
const abstract_reg_exp_filter_1 = __webpack_require__(/*! ./abstract-reg-exp-filter */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/abstract-reg-exp-filter.js");
exports.ExtensionIdMatchesFilterFactory = (0, ovsx_router_client_1.createFilterFactory)('ifExtensionIdMatches', ifExtensionIdMatches => {
    if (typeof ifExtensionIdMatches !== 'string') {
        throw new TypeError(`expected a string, got: ${typeof ifExtensionIdMatches}`);
    }
    return new ExtensionIdMatchesFilter(new RegExp(ifExtensionIdMatches, 'i'));
});
class ExtensionIdMatchesFilter extends abstract_reg_exp_filter_1.AbstractRegExpFilter {
    filterExtension(extension) {
        return this.test(ovsx_types_1.ExtensionLike.id(extension));
    }
}
exports.ExtensionIdMatchesFilter = ExtensionIdMatchesFilter;


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/index.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/index.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RequestContainsFilterFactory = exports.ExtensionIdMatchesFilterFactory = void 0;
var extension_id_matches_filter_1 = __webpack_require__(/*! ./extension-id-matches-filter */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/extension-id-matches-filter.js");
Object.defineProperty(exports, "ExtensionIdMatchesFilterFactory", ({ enumerable: true, get: function () { return extension_id_matches_filter_1.ExtensionIdMatchesFilterFactory; } }));
var request_contains_filter_1 = __webpack_require__(/*! ./request-contains-filter */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/request-contains-filter.js");
Object.defineProperty(exports, "RequestContainsFilterFactory", ({ enumerable: true, get: function () { return request_contains_filter_1.RequestContainsFilterFactory; } }));


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/request-contains-filter.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/request-contains-filter.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RequestContainsFilter = exports.RequestContainsFilterFactory = void 0;
const ovsx_router_client_1 = __webpack_require__(/*! ../ovsx-router-client */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-client.js");
const abstract_reg_exp_filter_1 = __webpack_require__(/*! ./abstract-reg-exp-filter */ "../../node_modules/@theia/ovsx-client/lib/ovsx-router-filters/abstract-reg-exp-filter.js");
exports.RequestContainsFilterFactory = (0, ovsx_router_client_1.createFilterFactory)('ifRequestContains', ifRequestContains => {
    if (typeof ifRequestContains !== 'string') {
        throw new TypeError(`expected a string, got: ${typeof ifRequestContains}`);
    }
    return new RequestContainsFilter(new RegExp(ifRequestContains, 'i'));
});
class RequestContainsFilter extends abstract_reg_exp_filter_1.AbstractRegExpFilter {
    filterSearchOptions(searchOptions) {
        return !searchOptions || this.test(searchOptions.query) || this.test(searchOptions.category);
    }
    filterQueryOptions(queryOptions) {
        return !queryOptions || Object.values(queryOptions).some(this.test, this);
    }
}
exports.RequestContainsFilter = RequestContainsFilter;


/***/ }),

/***/ "../../node_modules/@theia/ovsx-client/lib/ovsx-types.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@theia/ovsx-client/lib/ovsx-types.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VSXBuiltinNamespaces = exports.VSXResponseError = exports.ExtensionLike = void 0;
var ExtensionLike;
(function (ExtensionLike) {
    function id(extension) {
        return `${extension.namespace}.${extension.name}`;
    }
    ExtensionLike.id = id;
    function idWithVersion(extension) {
        if (!extension.version) {
            throw new Error(`no valid "version" value provided for "${id(extension)}"`);
        }
        return `${id(extension)}@${extension.version}`;
    }
    ExtensionLike.idWithVersion = idWithVersion;
    // eslint-disable-next-line @typescript-eslint/no-shadow
    function fromId(id) {
        const [left, version] = id.split('@', 2);
        const [namespace, name] = left.split('.', 2);
        return {
            name,
            namespace,
            version
        };
    }
    ExtensionLike.fromId = fromId;
})(ExtensionLike || (exports.ExtensionLike = ExtensionLike = {}));
var VSXResponseError;
(function (VSXResponseError) {
    function is(error) {
        return !!error && typeof error === 'object' && typeof error.statusCode === 'number';
    }
    VSXResponseError.is = is;
})(VSXResponseError || (exports.VSXResponseError = VSXResponseError = {}));
/**
 * Builtin namespaces maintained by the framework.
 */
var VSXBuiltinNamespaces;
(function (VSXBuiltinNamespaces) {
    /**
     * Namespace for individual vscode builtin extensions.
     */
    VSXBuiltinNamespaces.VSCODE = 'vscode';
    /**
     * Namespace for vscode builtin extension packs.
     * - corresponds to: https://github.com/eclipse-theia/vscode-builtin-extensions/blob/af9cfeb2ea23e1668a8340c1c2fb5afd56be07d7/src/create-extension-pack.js#L45
     */
    VSXBuiltinNamespaces.THEIA = 'eclipse-theia';
    /**
     * Determines if the extension namespace is a builtin maintained by the framework.
     * @param namespace the extension namespace to verify.
     */
    function is(namespace) {
        return namespace === VSXBuiltinNamespaces.VSCODE
            || namespace === VSXBuiltinNamespaces.THEIA;
    }
    VSXBuiltinNamespaces.is = is;
})(VSXBuiltinNamespaces || (exports.VSXBuiltinNamespaces = VSXBuiltinNamespaces = {}));


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext-vscode/lib/common/plugin-vscode-uri.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext-vscode/lib/common/plugin-vscode-uri.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VSCodeExtensionUri = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
/**
 * Static methods for identifying a plugin as the target of the VSCode deployment system.
 * In practice, this means that it will be resolved and deployed by the Open-VSX system.
 */
var VSCodeExtensionUri;
(function (VSCodeExtensionUri) {
    VSCodeExtensionUri.SCHEME = 'vscode-extension';
    function fromId(id, version) {
        if (typeof version === 'string') {
            return new uri_1.default().withScheme(VSCodeExtensionUri.SCHEME).withAuthority(id).withPath(`/${version}`);
        }
        else {
            return new uri_1.default().withScheme(VSCodeExtensionUri.SCHEME).withAuthority(id);
        }
    }
    VSCodeExtensionUri.fromId = fromId;
    function fromVersionedId(versionedId) {
        const versionAndId = versionedId.split('@');
        return fromId(versionAndId[0], versionAndId[1]);
    }
    VSCodeExtensionUri.fromVersionedId = fromVersionedId;
    function toId(uri) {
        if (uri.scheme === VSCodeExtensionUri.SCHEME) {
            return { id: uri.authority, version: uri.path.isRoot ? undefined : uri.path.base };
        }
        return undefined;
    }
    VSCodeExtensionUri.toId = toId;
})(VSCodeExtensionUri || (exports.VSCodeExtensionUri = VSCodeExtensionUri = {}));


/***/ }),

/***/ "../../node_modules/@theia/vsx-registry/lib/common/ovsx-client-provider.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/vsx-registry/lib/common/ovsx-client-provider.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createOVSXClient = exports.OVSXClientProvider = exports.OVSXUrlResolver = void 0;
const ovsx_client_1 = __webpack_require__(/*! @theia/ovsx-client */ "../../node_modules/@theia/ovsx-client/lib/index.js");
exports.OVSXUrlResolver = Symbol('OVSXUrlResolver');
exports.OVSXClientProvider = Symbol('OVSXClientProvider');
/**
 * @deprecated since 1.32.0
 */
async function createOVSXClient(vsxEnvironment, requestService) {
    const apiUrl = await vsxEnvironment.getRegistryApiUri();
    return new ovsx_client_1.OVSXHttpClient(apiUrl, requestService);
}
exports.createOVSXClient = createOVSXClient;


/***/ }),

/***/ "../../node_modules/@theia/vsx-registry/lib/common/vsx-environment.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/vsx-registry/lib/common/vsx-environment.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VSXEnvironment = exports.VSX_ENVIRONMENT_PATH = void 0;
exports.VSX_ENVIRONMENT_PATH = '/services/vsx-environment';
exports.VSXEnvironment = Symbol('VSXEnvironment');


/***/ }),

/***/ "../../node_modules/just-performance/dist/esm/browser.js":
/*!***************************************************************!*\
  !*** ../../node_modules/just-performance/dist/esm/browser.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   performance: () => (/* binding */ performance)
/* harmony export */ });
const universal = typeof globalThis !== "undefined" ? globalThis : __webpack_require__.g;
const performance = universal.performance;



/***/ }),

/***/ "../../node_modules/limiter/dist/cjs/RateLimiter.js":
/*!**********************************************************!*\
  !*** ../../node_modules/limiter/dist/cjs/RateLimiter.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RateLimiter = void 0;
const TokenBucket_1 = __webpack_require__(/*! ./TokenBucket */ "../../node_modules/limiter/dist/cjs/TokenBucket.js");
const clock_1 = __webpack_require__(/*! ./clock */ "../../node_modules/limiter/dist/cjs/clock.js");
/**
 * A generic rate limiter. Underneath the hood, this uses a token bucket plus
 * an additional check to limit how many tokens we can remove each interval.
 *
 * @param options
 * @param options.tokensPerInterval Maximum number of tokens that can be
 *  removed at any given moment and over the course of one interval.
 * @param options.interval The interval length in milliseconds, or as
 *  one of the following strings: 'second', 'minute', 'hour', day'.
 * @param options.fireImmediately Whether or not the promise will resolve
 *  immediately when rate limiting is in effect (default is false).
 */
class RateLimiter {
    constructor({ tokensPerInterval, interval, fireImmediately }) {
        this.tokenBucket = new TokenBucket_1.TokenBucket({
            bucketSize: tokensPerInterval,
            tokensPerInterval,
            interval,
        });
        // Fill the token bucket to start
        this.tokenBucket.content = tokensPerInterval;
        this.curIntervalStart = clock_1.getMilliseconds();
        this.tokensThisInterval = 0;
        this.fireImmediately = fireImmediately !== null && fireImmediately !== void 0 ? fireImmediately : false;
    }
    /**
     * Remove the requested number of tokens. If the rate limiter contains enough
     * tokens and we haven't spent too many tokens in this interval already, this
     * will happen immediately. Otherwise, the removal will happen when enough
     * tokens become available.
     * @param count The number of tokens to remove.
     * @returns A promise for the remainingTokens count.
     */
    async removeTokens(count) {
        // Make sure the request isn't for more than we can handle
        if (count > this.tokenBucket.bucketSize) {
            throw new Error(`Requested tokens ${count} exceeds maximum tokens per interval ${this.tokenBucket.bucketSize}`);
        }
        const now = clock_1.getMilliseconds();
        // Advance the current interval and reset the current interval token count
        // if needed
        if (now < this.curIntervalStart || now - this.curIntervalStart >= this.tokenBucket.interval) {
            this.curIntervalStart = now;
            this.tokensThisInterval = 0;
        }
        // If we don't have enough tokens left in this interval, wait until the
        // next interval
        if (count > this.tokenBucket.tokensPerInterval - this.tokensThisInterval) {
            if (this.fireImmediately) {
                return -1;
            }
            else {
                const waitMs = Math.ceil(this.curIntervalStart + this.tokenBucket.interval - now);
                await clock_1.wait(waitMs);
                const remainingTokens = await this.tokenBucket.removeTokens(count);
                this.tokensThisInterval += count;
                return remainingTokens;
            }
        }
        // Remove the requested number of tokens from the token bucket
        const remainingTokens = await this.tokenBucket.removeTokens(count);
        this.tokensThisInterval += count;
        return remainingTokens;
    }
    /**
     * Attempt to remove the requested number of tokens and return immediately.
     * If the bucket (and any parent buckets) contains enough tokens and we
     * haven't spent too many tokens in this interval already, this will return
     * true. Otherwise, false is returned.
     * @param {Number} count The number of tokens to remove.
     * @param {Boolean} True if the tokens were successfully removed, otherwise
     *  false.
     */
    tryRemoveTokens(count) {
        // Make sure the request isn't for more than we can handle
        if (count > this.tokenBucket.bucketSize)
            return false;
        const now = clock_1.getMilliseconds();
        // Advance the current interval and reset the current interval token count
        // if needed
        if (now < this.curIntervalStart || now - this.curIntervalStart >= this.tokenBucket.interval) {
            this.curIntervalStart = now;
            this.tokensThisInterval = 0;
        }
        // If we don't have enough tokens left in this interval, return false
        if (count > this.tokenBucket.tokensPerInterval - this.tokensThisInterval)
            return false;
        // Try to remove the requested number of tokens from the token bucket
        const removed = this.tokenBucket.tryRemoveTokens(count);
        if (removed) {
            this.tokensThisInterval += count;
        }
        return removed;
    }
    /**
     * Returns the number of tokens remaining in the TokenBucket.
     * @returns {Number} The number of tokens remaining.
     */
    getTokensRemaining() {
        this.tokenBucket.drip();
        return this.tokenBucket.content;
    }
}
exports.RateLimiter = RateLimiter;


/***/ }),

/***/ "../../node_modules/limiter/dist/cjs/TokenBucket.js":
/*!**********************************************************!*\
  !*** ../../node_modules/limiter/dist/cjs/TokenBucket.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenBucket = void 0;
const clock_1 = __webpack_require__(/*! ./clock */ "../../node_modules/limiter/dist/cjs/clock.js");
/**
 * A hierarchical token bucket for rate limiting. See
 * http://en.wikipedia.org/wiki/Token_bucket for more information.
 *
 * @param options
 * @param options.bucketSize Maximum number of tokens to hold in the bucket.
 *  Also known as the burst rate.
 * @param options.tokensPerInterval Number of tokens to drip into the bucket
 *  over the course of one interval.
 * @param options.interval The interval length in milliseconds, or as
 *  one of the following strings: 'second', 'minute', 'hour', day'.
 * @param options.parentBucket Optional. A token bucket that will act as
 *  the parent of this bucket.
 */
class TokenBucket {
    constructor({ bucketSize, tokensPerInterval, interval, parentBucket }) {
        this.bucketSize = bucketSize;
        this.tokensPerInterval = tokensPerInterval;
        if (typeof interval === "string") {
            switch (interval) {
                case "sec":
                case "second":
                    this.interval = 1000;
                    break;
                case "min":
                case "minute":
                    this.interval = 1000 * 60;
                    break;
                case "hr":
                case "hour":
                    this.interval = 1000 * 60 * 60;
                    break;
                case "day":
                    this.interval = 1000 * 60 * 60 * 24;
                    break;
                default:
                    throw new Error("Invalid interval " + interval);
            }
        }
        else {
            this.interval = interval;
        }
        this.parentBucket = parentBucket;
        this.content = 0;
        this.lastDrip = clock_1.getMilliseconds();
    }
    /**
     * Remove the requested number of tokens. If the bucket (and any parent
     * buckets) contains enough tokens this will happen immediately. Otherwise,
     * the removal will happen when enough tokens become available.
     * @param count The number of tokens to remove.
     * @returns A promise for the remainingTokens count.
     */
    async removeTokens(count) {
        // Is this an infinite size bucket?
        if (this.bucketSize === 0) {
            return Number.POSITIVE_INFINITY;
        }
        // Make sure the bucket can hold the requested number of tokens
        if (count > this.bucketSize) {
            throw new Error(`Requested tokens ${count} exceeds bucket size ${this.bucketSize}`);
        }
        // Drip new tokens into this bucket
        this.drip();
        const comeBackLater = async () => {
            // How long do we need to wait to make up the difference in tokens?
            const waitMs = Math.ceil((count - this.content) * (this.interval / this.tokensPerInterval));
            await clock_1.wait(waitMs);
            return this.removeTokens(count);
        };
        // If we don't have enough tokens in this bucket, come back later
        if (count > this.content)
            return comeBackLater();
        if (this.parentBucket != undefined) {
            // Remove the requested from the parent bucket first
            const remainingTokens = await this.parentBucket.removeTokens(count);
            // Check that we still have enough tokens in this bucket
            if (count > this.content)
                return comeBackLater();
            // Tokens were removed from the parent bucket, now remove them from
            // this bucket. Note that we look at the current bucket and parent
            // bucket's remaining tokens and return the smaller of the two values
            this.content -= count;
            return Math.min(remainingTokens, this.content);
        }
        else {
            // Remove the requested tokens from this bucket
            this.content -= count;
            return this.content;
        }
    }
    /**
     * Attempt to remove the requested number of tokens and return immediately.
     * If the bucket (and any parent buckets) contains enough tokens this will
     * return true, otherwise false is returned.
     * @param {Number} count The number of tokens to remove.
     * @param {Boolean} True if the tokens were successfully removed, otherwise
     *  false.
     */
    tryRemoveTokens(count) {
        // Is this an infinite size bucket?
        if (!this.bucketSize)
            return true;
        // Make sure the bucket can hold the requested number of tokens
        if (count > this.bucketSize)
            return false;
        // Drip new tokens into this bucket
        this.drip();
        // If we don't have enough tokens in this bucket, return false
        if (count > this.content)
            return false;
        // Try to remove the requested tokens from the parent bucket
        if (this.parentBucket && !this.parentBucket.tryRemoveTokens(count))
            return false;
        // Remove the requested tokens from this bucket and return
        this.content -= count;
        return true;
    }
    /**
     * Add any new tokens to the bucket since the last drip.
     * @returns {Boolean} True if new tokens were added, otherwise false.
     */
    drip() {
        if (this.tokensPerInterval === 0) {
            const prevContent = this.content;
            this.content = this.bucketSize;
            return this.content > prevContent;
        }
        const now = clock_1.getMilliseconds();
        const deltaMS = Math.max(now - this.lastDrip, 0);
        this.lastDrip = now;
        const dripAmount = deltaMS * (this.tokensPerInterval / this.interval);
        const prevContent = this.content;
        this.content = Math.min(this.content + dripAmount, this.bucketSize);
        return Math.floor(this.content) > Math.floor(prevContent);
    }
}
exports.TokenBucket = TokenBucket;


/***/ }),

/***/ "../../node_modules/limiter/dist/cjs/clock.js":
/*!****************************************************!*\
  !*** ../../node_modules/limiter/dist/cjs/clock.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.wait = exports.getMilliseconds = void 0;
const just_performance_1 = __webpack_require__(/*! just-performance */ "../../node_modules/just-performance/dist/esm/browser.js");
// generate timestamp or delta
// see http://nodejs.org/api/process.html#process_process_hrtime
function hrtime(previousTimestamp) {
    const clocktime = just_performance_1.performance.now() * 1e-3;
    let seconds = Math.floor(clocktime);
    let nanoseconds = Math.floor((clocktime % 1) * 1e9);
    if (previousTimestamp != undefined) {
        seconds = seconds - previousTimestamp[0];
        nanoseconds = nanoseconds - previousTimestamp[1];
        if (nanoseconds < 0) {
            seconds--;
            nanoseconds += 1e9;
        }
    }
    return [seconds, nanoseconds];
}
// The current timestamp in whole milliseconds
function getMilliseconds() {
    const [seconds, nanoseconds] = hrtime();
    return seconds * 1e3 + Math.floor(nanoseconds / 1e6);
}
exports.getMilliseconds = getMilliseconds;
// Wait for a specified number of milliseconds before fulfilling the returned promise.
function wait(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}
exports.wait = wait;


/***/ }),

/***/ "../../node_modules/limiter/dist/cjs/index.js":
/*!****************************************************!*\
  !*** ../../node_modules/limiter/dist/cjs/index.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./RateLimiter */ "../../node_modules/limiter/dist/cjs/RateLimiter.js"), exports);
__exportStar(__webpack_require__(/*! ./TokenBucket */ "../../node_modules/limiter/dist/cjs/TokenBucket.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_plugin-ext-vscode_lib_common_plugin-vscode-uri_js-node_modules_the-5304ff.js.map