"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-chat_lib_browser_task-context-service_js-node_modules_theia_ai--2ea09b"],{

/***/ "../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TaskContextService = exports.TaskContextStorageService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const chat_session_summary_agent_1 = __webpack_require__(/*! ../common/chat-session-summary-agent */ "../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const chat_session_summary_agent_prompt_1 = __webpack_require__(/*! ../common/chat-session-summary-agent-prompt */ "../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent-prompt.js");
exports.TaskContextStorageService = Symbol('TextContextStorageService');
let TaskContextService = class TaskContextService {
    constructor() {
        this.pendingSummaries = new Map();
    }
    get onDidChange() {
        return this.storageService.onDidChange;
    }
    getAll() {
        return this.storageService.getAll();
    }
    async getSummary(sessionIdOrFilePath) {
        const existing = this.storageService.get(sessionIdOrFilePath);
        if (existing) {
            return existing.summary;
        }
        const pending = this.pendingSummaries.get(sessionIdOrFilePath);
        if (pending) {
            return pending.then(({ summary }) => summary);
        }
        const session = this.chatService.getSession(sessionIdOrFilePath);
        if (session) {
            return this.summarize(session);
        }
        throw new Error('Unable to resolve summary request.');
    }
    /** Returns an ID that can be used to refer to the summary in the future. */
    async summarize(session, promptId, agent) {
        const pending = this.pendingSummaries.get(session.id);
        if (pending) {
            return pending.then(({ id }) => id);
        }
        const existing = this.getSummaryForSession(session);
        if (existing) {
            return existing.id;
        }
        const summaryId = (0, core_1.generateUuid)();
        const summaryDeferred = new promise_util_1.Deferred();
        const progress = await this.progressService.showProgress({ text: `Summarize: ${session.title || session.id}`, options: { location: 'ai-chat' } });
        this.pendingSummaries.set(session.id, summaryDeferred.promise);
        try {
            const newSummary = {
                summary: await this.getLlmSummary(session, promptId, agent),
                label: session.title || session.id,
                sessionId: session.id,
                id: summaryId
            };
            await this.storageService.store(newSummary);
            return summaryId;
        }
        catch (err) {
            summaryDeferred.reject(err);
            throw err;
        }
        finally {
            progress.cancel();
            this.pendingSummaries.delete(session.id);
        }
    }
    async getLlmSummary(session, promptId = chat_session_summary_agent_prompt_1.CHAT_SESSION_SUMMARY_PROMPT.id, agent) {
        var _a, _b;
        agent = agent || this.agentService.getAgents().find((candidate) => 'invoke' in candidate
            && typeof candidate.invoke === 'function'
            && candidate.id === chat_session_summary_agent_1.ChatSessionSummaryAgent.ID);
        if (!agent) {
            throw new Error('Unable to identify agent for summary.');
        }
        const model = new common_1.MutableChatModel(common_1.ChatAgentLocation.Panel);
        const prompt = await this.promptService.getPrompt(promptId || chat_session_summary_agent_prompt_1.CHAT_SESSION_SUMMARY_PROMPT.id, undefined, { model: session.model });
        if (!prompt) {
            return '';
        }
        const messages = session.model.getRequests().filter((candidate) => candidate instanceof common_1.MutableChatRequestModel);
        messages.forEach(message => model['_hierarchy'].append(message));
        const summaryRequest = model.addRequest({
            variables: (_a = prompt.variables) !== null && _a !== void 0 ? _a : [],
            request: { text: prompt.text },
            parts: [new common_1.ParsedChatRequestTextPart({ start: 0, endExclusive: prompt.text.length }, prompt.text)],
            toolRequests: (_b = prompt.functionDescriptions) !== null && _b !== void 0 ? _b : new Map()
        }, agent.id);
        await agent.invoke(summaryRequest);
        return summaryRequest.response.response.asDisplayString();
    }
    hasSummary(chatSession) {
        return !!this.getSummaryForSession(chatSession);
    }
    getSummaryForSession(chatSession) {
        return this.storageService.getAll().find(candidate => candidate.sessionId === chatSession.id);
    }
    getLabel(id) {
        var _a;
        return (_a = this.storageService.get(id)) === null || _a === void 0 ? void 0 : _a.label;
    }
    open(id) {
        return this.storageService.open(id);
    }
};
exports.TaskContextService = TaskContextService;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], TaskContextService.prototype, "chatService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], TaskContextService.prototype, "agentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], TaskContextService.prototype, "promptService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.TaskContextStorageService),
    tslib_1.__metadata("design:type", Object)
], TaskContextService.prototype, "storageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ProgressService),
    tslib_1.__metadata("design:type", core_1.ProgressService)
], TaskContextService.prototype, "progressService", void 0);
exports.TaskContextService = TaskContextService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TaskContextService);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TASK_CONTEXT_VARIABLE = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
exports.TASK_CONTEXT_VARIABLE = {
    id: 'taskContext',
    description: 'Provides context information for a task, e.g. the plan for completing a task or a summary of a previous sessions',
    name: 'taskContext',
    label: 'Task Context',
    iconClasses: (0, browser_1.codiconArray)('clippy'),
    isContextVariable: true,
    args: [{ name: 'context-id', description: 'The ID of the task context to retrieve, or a chat session to summarize.' }]
};


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent-prompt.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent-prompt.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/* eslint-disable @typescript-eslint/tslint/config  */
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This file is licensed under the MIT License.
// See LICENSE-MIT.txt in the project root for license information.
// https://opensource.org/license/mit.
//
// SPDX-License-Identifier: MIT
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CHAT_SESSION_SUMMARY_PROMPT = void 0;
const context_variables_1 = __webpack_require__(/*! ./context-variables */ "../../node_modules/@theia/ai-chat/lib/common/context-variables.js");
exports.CHAT_SESSION_SUMMARY_PROMPT = {
    id: 'chat-session-summary-prompt',
    template: `{{!-- !-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We\'d love for you to share it with the community! Contribute back here: ' +
        'https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}\n\n' +
        'You are a chat agent for summarizing AI agent chat sessions for later use. \
Review the conversation above and generate a concise summary that captures every crucial detail, \
including all requirements, decisions, and pending tasks. \
Ensure that the summary is sufficiently comprehensive to allow seamless continuation of the workflow. The summary will primarily be used by other AI agents, so tailor your \
response for use by AI agents. \
Also consider the system message.
Make sure you include all necessary context information and use unique references (such as URIs, file paths, etc.).
If the conversation was about a task, describe the state of the task, i.e. what has been completed and what is open.
If a changeset is open in the session, describe the state of the suggested changes.
{{${context_variables_1.CHANGE_SET_SUMMARY_VARIABLE_ID}}}`,
};


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ChatSessionSummaryAgent_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatSessionSummaryAgent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const chat_session_summary_agent_prompt_1 = __webpack_require__(/*! ./chat-session-summary-agent-prompt */ "../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent-prompt.js");
let ChatSessionSummaryAgent = ChatSessionSummaryAgent_1 = class ChatSessionSummaryAgent extends chat_agents_1.AbstractStreamParsingChatAgent {
    constructor() {
        super(...arguments);
        this.id = ChatSessionSummaryAgent_1.ID;
        this.name = 'Chat Session Summary';
        this.description = 'Agent for generating chat session summaries.';
        this.variables = [];
        this.promptTemplates = [chat_session_summary_agent_prompt_1.CHAT_SESSION_SUMMARY_PROMPT];
        this.defaultLanguageModelPurpose = 'chat-session-summary';
        this.languageModelRequirements = [{
                purpose: 'chat-session-summary',
                identifier: 'openai/gpt-4o-mini',
            }];
        this.agentSpecificVariables = [];
        this.functions = [];
        this.locations = [];
        this.tags = [];
    }
};
exports.ChatSessionSummaryAgent = ChatSessionSummaryAgent;
ChatSessionSummaryAgent.ID = 'chat-session-summary-agent';
exports.ChatSessionSummaryAgent = ChatSessionSummaryAgent = ChatSessionSummaryAgent_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatSessionSummaryAgent);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-chat_lib_browser_task-context-service_js-node_modules_theia_ai--2ea09b.js.map