(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-chat-ui_lib_browser_chat-tree-view_chat-view-tree-widget_js"],{

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/change-set-actions/change-set-action-service.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/change-set-actions/change-set-action-service.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetActionService = exports.ChangeSetActionRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
exports.ChangeSetActionRenderer = Symbol('ChangeSetActionRenderer');
let ChangeSetActionService = class ChangeSetActionService {
    constructor() {
        this.onDidChangeEmitter = new core_1.Emitter();
    }
    get onDidChange() {
        return this.onDidChangeEmitter.event;
    }
    init() {
        const actions = this.contributions.getContributions();
        actions.sort((a, b) => { var _a, _b; return ((_a = b.priority) !== null && _a !== void 0 ? _a : 0) - ((_b = a.priority) !== null && _b !== void 0 ? _b : 0); });
        actions.forEach(contribution => { var _a; return (_a = contribution.onDidChange) === null || _a === void 0 ? void 0 : _a.call(contribution, this.onDidChangeEmitter.fire, this.onDidChangeEmitter); });
    }
    getActions() {
        return this.contributions.getContributions();
    }
    getActionsForChangeset(changeSet) {
        return this.getActions().filter(candidate => !candidate.canRender || candidate.canRender(changeSet));
    }
};
exports.ChangeSetActionService = ChangeSetActionService;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(exports.ChangeSetActionRenderer),
    tslib_1.__metadata("design:type", Object)
], ChangeSetActionService.prototype, "contributions", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ChangeSetActionService.prototype, "init", null);
exports.ChangeSetActionService = ChangeSetActionService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetActionService);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-input-agent-suggestions.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-input-agent-suggestions.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatInputAgentSuggestions = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const markdown_part_renderer_1 = __webpack_require__(/*! ./chat-response-renderer/markdown-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/markdown-part-renderer.js");
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
function getText(suggestion) {
    if (typeof suggestion === 'string') {
        return suggestion;
    }
    if ('value' in suggestion) {
        return suggestion.value;
    }
    if (typeof suggestion.content === 'string') {
        return suggestion.content;
    }
    return suggestion.content.value;
}
function getContent(suggestion) {
    if (typeof suggestion === 'string') {
        return suggestion;
    }
    if ('value' in suggestion) {
        return suggestion;
    }
    return suggestion.content;
}
const ChatInputAgentSuggestions = ({ suggestions, opener }) => (!!(suggestions === null || suggestions === void 0 ? void 0 : suggestions.length) && React.createElement("div", { className: "chat-agent-suggestions" }, suggestions.map(suggestion => React.createElement(ChatInputAgentSuggestion, { key: getText(suggestion), suggestion: suggestion, opener: opener, handler: ai_chat_1.ChatSuggestionCallback.is(suggestion) ? new ChatSuggestionClickHandler(suggestion) : undefined }))));
exports.ChatInputAgentSuggestions = ChatInputAgentSuggestions;
const ChatInputAgentSuggestion = ({ suggestion, opener, handler }) => {
    const ref = (0, markdown_part_renderer_1.useMarkdownRendering)(getContent(suggestion), opener, true, handler);
    return React.createElement("div", { className: "chat-agent-suggestion", style: (!handler || ai_chat_1.ChatSuggestionCallback.containsCallbackLink(suggestion)) ? undefined : { cursor: 'pointer' }, ref: ref });
};
class ChatSuggestionClickHandler {
    constructor(suggestion) {
        this.suggestion = suggestion;
    }
    handleEvent(event) {
        const { target, currentTarget } = event;
        if (event.type !== 'click' || !(target instanceof Element)) {
            return false;
        }
        const link = target.closest('a[href^="_callback"]');
        if (link) {
            this.suggestion.callback();
            return true;
        }
        if (!(currentTarget instanceof Element)) {
            this.suggestion.callback();
            return true;
        }
        const containedLink = currentTarget.querySelector('a[href^="_callback"]');
        // Whole body should count.
        if (!containedLink) {
            this.suggestion.callback();
            return true;
        }
        return false;
    }
}


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-input-widget.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-input-widget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var AIChatInputWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIChatInputWidget = exports.AIChatInputConfiguration = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const monaco_editor_provider_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-provider */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-provider.js");
const chat_view_language_contribution_1 = __webpack_require__(/*! ./chat-view-language-contribution */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-view-language-contribution.js");
const browser_2 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const context_variable_picker_1 = __webpack_require__(/*! ./context-variable-picker */ "../../node_modules/@theia/ai-chat-ui/lib/browser/context-variable-picker.js");
const change_set_action_service_1 = __webpack_require__(/*! ./change-set-actions/change-set-action-service */ "../../node_modules/@theia/ai-chat-ui/lib/browser/change-set-actions/change-set-action-service.js");
const change_set_decorator_service_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/change-set-decorator-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-decorator-service.js");
const chat_input_agent_suggestions_1 = __webpack_require__(/*! ./chat-input-agent-suggestions */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-input-agent-suggestions.js");
exports.AIChatInputConfiguration = Symbol('AIChatInputConfiguration');
let AIChatInputWidget = AIChatInputWidget_1 = class AIChatInputWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.editorRef = undefined;
        this.editorReady = new promise_util_1.Deferred();
        this.isEnabled = false;
        this.onDisposeForChatModel = new core_1.DisposableCollection();
    }
    set onQuery(query) {
        this._onQuery = query;
    }
    set onUnpin(unpin) {
        this._onUnpin = unpin;
    }
    set onCancel(cancel) {
        this._onCancel = cancel;
    }
    set onDeleteChangeSet(deleteChangeSet) {
        this._onDeleteChangeSet = deleteChangeSet;
    }
    set onDeleteChangeSetElement(deleteChangeSetElement) {
        this._onDeleteChangeSetElement = deleteChangeSetElement;
    }
    set initialValue(value) {
        this._initialValue = value;
    }
    set chatModel(chatModel) {
        this.onDisposeForChatModel.dispose();
        this.onDisposeForChatModel = new core_1.DisposableCollection();
        this.onDisposeForChatModel.push(chatModel.onDidChange(event => {
            if (event.kind === 'addVariable' || event.kind === 'removeVariable') {
                this.update();
            }
        }));
        this._chatModel = chatModel;
        this.update();
    }
    set pinnedAgent(pinnedAgent) {
        this._pinnedAgent = pinnedAgent;
        this.update();
    }
    init() {
        this.id = AIChatInputWidget_1.ID;
        this.title.closable = false;
        this.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.editorReady.promise.then(() => {
            if (this.editorRef) {
                this.editorRef.focus();
            }
        });
    }
    getResourceUri() {
        return new core_1.URI(`ai-chat:/input.${chat_view_language_contribution_1.CHAT_VIEW_LANGUAGE_EXTENSION}`);
    }
    render() {
        var _a, _b, _c;
        return (React.createElement(ChatInput, { onQuery: this._onQuery.bind(this), onUnpin: this._onUnpin.bind(this), onCancel: this._onCancel.bind(this), onDragOver: this.onDragOver.bind(this), onDrop: this.onDrop.bind(this), onDeleteChangeSet: this._onDeleteChangeSet.bind(this), onDeleteChangeSetElement: this._onDeleteChangeSetElement.bind(this), onAddContextElement: this.addContextElement.bind(this), onDeleteContextElement: this.deleteContextElement.bind(this), context: this.getContext(), onOpenContextElement: this.openContextElement.bind(this), chatModel: this._chatModel, pinnedAgent: this._pinnedAgent, editorProvider: this.editorProvider, resources: this.resources, resourceUriProvider: this.getResourceUri.bind(this), contextMenuCallback: this.handleContextMenu.bind(this), isEnabled: this.isEnabled, setEditorRef: editor => {
                this.editorRef = editor;
                this.editorReady.resolve();
            }, showContext: (_a = this.configuration) === null || _a === void 0 ? void 0 : _a.showContext, showPinnedAgent: (_b = this.configuration) === null || _b === void 0 ? void 0 : _b.showPinnedAgent, showChangeSet: (_c = this.configuration) === null || _c === void 0 ? void 0 : _c.showChangeSet, labelProvider: this.labelProvider, actionService: this.changeSetActionService, decoratorService: this.changeSetDecoratorService, initialValue: this._initialValue, openerService: this.openerService, suggestions: this._chatModel.suggestions }));
    }
    onDragOver(event) {
        var _a;
        event.preventDefault();
        event.stopPropagation();
        this.node.classList.add('drag-over');
        if ((_a = event.dataTransfer) === null || _a === void 0 ? void 0 : _a.types.includes('text/plain')) {
            event.dataTransfer.dropEffect = 'copy';
        }
        else {
            event.dataTransfer.dropEffect = 'link';
        }
    }
    onDrop(event) {
        var _a, _b, _c;
        event.preventDefault();
        event.stopPropagation();
        this.node.classList.remove('drag-over');
        const dataTransferText = (_a = event.dataTransfer) === null || _a === void 0 ? void 0 : _a.getData('text/plain');
        const position = (_c = (_b = this.editorRef) === null || _b === void 0 ? void 0 : _b.getControl().getTargetAtClientPoint(event.clientX, event.clientY)) === null || _c === void 0 ? void 0 : _c.position;
        this.variableService.getDropResult(event.nativeEvent, { type: 'ai-chat-input-widget' }).then(result => {
            var _a, _b;
            result.variables.forEach(variable => this.addContext(variable));
            const text = (_a = result.text) !== null && _a !== void 0 ? _a : dataTransferText;
            if (position && text) {
                (_b = this.editorRef) === null || _b === void 0 ? void 0 : _b.getControl().executeEdits('drag-and-drop', [{
                        range: {
                            startLineNumber: position.lineNumber,
                            startColumn: position.column,
                            endLineNumber: position.lineNumber,
                            endColumn: position.column
                        },
                        text
                    }]);
            }
        });
    }
    async openContextElement(request) {
        const session = this.chatService.getSessions().find(candidate => candidate.model.id === this._chatModel.id);
        const context = { session };
        await this.variableService.open(request, context);
    }
    setEnabled(enabled) {
        this.isEnabled = enabled;
        this.update();
    }
    addContextElement() {
        this.contextVariablePicker.pickContextVariable().then(contextElement => {
            if (contextElement) {
                this.addContext(contextElement);
            }
        });
    }
    deleteContextElement(index) {
        this._chatModel.context.deleteVariables(index);
    }
    handleContextMenu(event) {
        this.contextMenuRenderer.render({
            menuPath: AIChatInputWidget_1.CONTEXT_MENU,
            anchor: { x: event.posx, y: event.posy },
            context: event.target,
            args: [this.editorRef]
        });
        event.preventDefault();
    }
    addContext(variable) {
        this._chatModel.context.addVariables(variable);
    }
    getContext() {
        return this._chatModel.context.getVariables();
    }
};
exports.AIChatInputWidget = AIChatInputWidget;
AIChatInputWidget.ID = 'chat-input-widget';
AIChatInputWidget.CONTEXT_MENU = ['chat-input-context-menu'];
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_provider_1.MonacoEditorProvider),
    tslib_1.__metadata("design:type", monaco_editor_provider_1.MonacoEditorProvider)
], AIChatInputWidget.prototype, "editorProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.InMemoryResources),
    tslib_1.__metadata("design:type", core_1.InMemoryResources)
], AIChatInputWidget.prototype, "resources", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], AIChatInputWidget.prototype, "contextMenuRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.AIChatInputConfiguration),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], AIChatInputWidget.prototype, "configuration", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.FrontendVariableService),
    tslib_1.__metadata("design:type", Object)
], AIChatInputWidget.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], AIChatInputWidget.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_variable_picker_1.ContextVariablePicker),
    tslib_1.__metadata("design:type", context_variable_picker_1.ContextVariablePicker)
], AIChatInputWidget.prototype, "contextVariablePicker", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_action_service_1.ChangeSetActionService),
    tslib_1.__metadata("design:type", change_set_action_service_1.ChangeSetActionService)
], AIChatInputWidget.prototype, "changeSetActionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_decorator_service_1.ChangeSetDecoratorService),
    tslib_1.__metadata("design:type", change_set_decorator_service_1.ChangeSetDecoratorService)
], AIChatInputWidget.prototype, "changeSetDecoratorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], AIChatInputWidget.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_chat_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], AIChatInputWidget.prototype, "chatService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIChatInputWidget.prototype, "init", null);
exports.AIChatInputWidget = AIChatInputWidget = AIChatInputWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIChatInputWidget);
const ChatInput = (props) => {
    const onDeleteChangeSet = () => props.onDeleteChangeSet(props.chatModel.id);
    const onDeleteChangeSetElement = (index) => props.onDeleteChangeSetElement(props.chatModel.id, index);
    const [inProgress, setInProgress] = React.useState(false);
    const [isInputEmpty, setIsInputEmpty] = React.useState(true);
    const [changeSetUI, setChangeSetUI] = React.useState(() => props.chatModel.changeSet
        ? buildChangeSetUI(props.chatModel.changeSet, props.labelProvider, props.decoratorService, props.actionService.getActionsForChangeset(props.chatModel.changeSet), onDeleteChangeSet, onDeleteChangeSetElement)
        : undefined);
    // eslint-disable-next-line no-null/no-null
    const editorContainerRef = React.useRef(null);
    // eslint-disable-next-line no-null/no-null
    const placeholderRef = React.useRef(null);
    const editorRef = React.useRef(undefined);
    React.useEffect(() => {
        const uri = props.resourceUriProvider();
        const resource = props.resources.add(uri, '');
        const createInputElement = async () => {
            const paddingTop = 6;
            const lineHeight = 20;
            const maxHeight = 240;
            const editor = await props.editorProvider.createSimpleInline(uri, editorContainerRef.current, {
                language: chat_view_language_contribution_1.CHAT_VIEW_LANGUAGE_EXTENSION,
                // Disable code lens, inlay hints and hover support to avoid console errors from other contributions
                codeLens: false,
                inlayHints: { enabled: 'off' },
                hover: { enabled: false },
                autoSizing: false, // we handle the sizing ourselves
                scrollBeyondLastLine: false,
                scrollBeyondLastColumn: 0,
                minHeight: 1,
                fontFamily: 'var(--theia-ui-font-family)',
                fontSize: 13,
                cursorWidth: 1,
                maxHeight: -1,
                scrollbar: { horizontal: 'hidden' },
                automaticLayout: true,
                lineNumbers: 'off',
                lineHeight,
                padding: { top: paddingTop },
                suggest: {
                    showIcons: true,
                    showSnippets: false,
                    showWords: false,
                    showStatusBar: false,
                    insertMode: 'replace',
                },
                bracketPairColorization: { enabled: false },
                wrappingStrategy: 'advanced',
                stickyScroll: { enabled: false },
            });
            if (editorContainerRef.current) {
                editorContainerRef.current.style.height = (lineHeight + (2 * paddingTop)) + 'px';
            }
            const updateEditorHeight = () => {
                if (editorContainerRef.current) {
                    const contentHeight = editor.getControl().getContentHeight() + paddingTop;
                    editorContainerRef.current.style.height = `${Math.min(contentHeight, maxHeight)}px`;
                }
            };
            editor.getControl().onDidChangeModelContent(() => {
                const value = editor.getControl().getValue();
                setIsInputEmpty(!value || value.length === 0);
                updateEditorHeight();
                handleOnChange();
            });
            const resizeObserver = new ResizeObserver(updateEditorHeight);
            if (editorContainerRef.current) {
                resizeObserver.observe(editorContainerRef.current);
            }
            editor.getControl().onDidDispose(() => {
                resizeObserver.disconnect();
            });
            editor.getControl().onContextMenu(e => props.contextMenuCallback(e.event));
            editorRef.current = editor;
            props.setEditorRef(editor);
            if (props.initialValue) {
                setValue(props.initialValue);
            }
        };
        createInputElement();
        return () => {
            resource.dispose();
            props.setEditorRef(undefined);
            if (editorRef.current) {
                editorRef.current.dispose();
            }
        };
    }, []);
    const responseListenerRef = React.useRef();
    // track chat model updates to keep our UI in sync
    // - keep "inProgress" in sync with the request state
    // - keep "changeSetUI" in sync with the change set
    React.useEffect(() => {
        const listener = props.chatModel.onDidChange(event => {
            var _a;
            if (event.kind === 'addRequest') {
                if (event.request) {
                    setInProgress(ai_chat_1.ChatRequestModel.isInProgress(event.request));
                }
                (_a = responseListenerRef.current) === null || _a === void 0 ? void 0 : _a.dispose();
                responseListenerRef.current = event.request.response.onDidChange(() => setInProgress(ai_chat_1.ChatRequestModel.isInProgress(event.request)));
            }
            else if (ai_chat_1.ChatChangeEvent.isChangeSetEvent(event)) {
                if (event.kind === 'removeChangeSet') {
                    setChangeSetUI(undefined);
                }
                else if (event.kind === 'setChangeSet' || 'updateChangeSet') {
                    setChangeSetUI(buildChangeSetUI(event.changeSet, props.labelProvider, props.decoratorService, props.actionService.getActionsForChangeset(event.changeSet), onDeleteChangeSet, onDeleteChangeSetElement));
                }
            }
        });
        setChangeSetUI(props.chatModel.changeSet
            ? buildChangeSetUI(props.chatModel.changeSet, props.labelProvider, props.decoratorService, props.actionService.getActionsForChangeset(props.chatModel.changeSet), onDeleteChangeSet, onDeleteChangeSetElement)
            : undefined);
        return () => {
            var _a;
            listener === null || listener === void 0 ? void 0 : listener.dispose();
            (_a = responseListenerRef.current) === null || _a === void 0 ? void 0 : _a.dispose();
            responseListenerRef.current = undefined;
        };
    }, [props.chatModel]);
    React.useEffect(() => {
        const disposable = props.actionService.onDidChange(() => {
            if (!props.chatModel.changeSet) {
                return;
            }
            const newActions = props.actionService.getActionsForChangeset(props.chatModel.changeSet);
            setChangeSetUI(current => !current ? current : { ...current, actions: newActions });
        });
        return () => disposable.dispose();
    });
    React.useEffect(() => {
        const disposable = props.decoratorService.onDidChangeDecorations(() => {
            if (!props.chatModel.changeSet) {
                return;
            }
            setChangeSetUI(buildChangeSetUI(props.chatModel.changeSet, props.labelProvider, props.decoratorService, props.actionService.getActionsForChangeset(props.chatModel.changeSet), onDeleteChangeSet, onDeleteChangeSetElement));
        });
        return () => disposable.dispose();
    });
    const setValue = React.useCallback((value) => {
        if (editorRef.current && !editorRef.current.document.isDisposed()) {
            editorRef.current.document.textEditorModel.setValue(value);
        }
    }, [editorRef]);
    const submit = React.useCallback(function submit(value) {
        if (!value || value.trim().length === 0) {
            return;
        }
        setInProgress(true);
        props.onQuery(value);
        setValue('');
    }, [props.context, props.onQuery, setValue]);
    const onKeyDown = React.useCallback((event) => {
        var _a;
        if (!props.isEnabled) {
            return;
        }
        if (event.key === 'Enter' && !event.shiftKey) {
            event.preventDefault();
            submit(((_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.document.textEditorModel.getValue()) || '');
        }
    }, [props.isEnabled, submit]);
    const handleInputFocus = () => {
        hidePlaceholderIfEditorFilled();
    };
    const handleOnChange = () => {
        showPlaceholderIfEditorEmpty();
        hidePlaceholderIfEditorFilled();
    };
    const handleInputBlur = () => {
        showPlaceholderIfEditorEmpty();
    };
    const showPlaceholderIfEditorEmpty = () => {
        var _a, _b;
        if (!((_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.getControl().getValue())) {
            (_b = placeholderRef.current) === null || _b === void 0 ? void 0 : _b.classList.remove('hidden');
        }
    };
    const hidePlaceholderIfEditorFilled = () => {
        var _a, _b;
        const value = (_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.getControl().getValue();
        if (value && value.length > 0) {
            (_b = placeholderRef.current) === null || _b === void 0 ? void 0 : _b.classList.add('hidden');
        }
    };
    const handlePin = () => {
        var _a, _b;
        if (editorRef.current) {
            (_a = editorRef.current.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.applyEdits([{
                    range: {
                        startLineNumber: 1,
                        startColumn: 1,
                        endLineNumber: 1,
                        endColumn: 1
                    },
                    text: '@',
                }]);
            editorRef.current.getControl().setPosition({ lineNumber: 1, column: 2 });
            (_b = editorRef.current.getControl().getAction('editor.action.triggerSuggest')) === null || _b === void 0 ? void 0 : _b.run();
        }
    };
    const leftOptions = [
        ...(props.showContext
            ? [{
                    title: core_1.nls.localize('theia/ai/chat-ui/attachToContext', 'Attach elements to context'),
                    handler: () => props.onAddContextElement(),
                    className: 'codicon-add'
                }]
            : []),
        ...(props.showPinnedAgent
            ? [{
                    title: props.pinnedAgent ? core_1.nls.localize('theia/ai/chat-ui/unpinAgent', 'Unpin Agent') : core_1.nls.localize('theia/ai/chat-ui/pinAgent', 'Pin Agent'),
                    handler: props.pinnedAgent ? props.onUnpin : handlePin,
                    className: 'at-icon',
                    text: {
                        align: 'right',
                        content: props.pinnedAgent && props.pinnedAgent.name
                    },
                }]
            : []),
    ];
    const rightOptions = inProgress
        ? [{
                title: core_1.nls.localize('theia/ai/chat-ui/cancel', 'Cancel (Esc)'),
                handler: () => {
                    const latestRequest = getLatestRequest(props.chatModel);
                    if (latestRequest) {
                        props.onCancel(latestRequest);
                    }
                    setInProgress(false);
                },
                className: 'codicon-stop-circle'
            }]
        : [{
                title: core_1.nls.localize('theia/ai/chat-ui/send', 'Send (Enter)'),
                handler: () => {
                    var _a;
                    if (props.isEnabled) {
                        submit(((_a = editorRef.current) === null || _a === void 0 ? void 0 : _a.document.textEditorModel.getValue()) || '');
                    }
                },
                className: 'codicon-send',
                disabled: isInputEmpty || !props.isEnabled
            }];
    const contextUI = buildContextUI(props.context, props.labelProvider, props.onDeleteContextElement, props.onOpenContextElement);
    return React.createElement("div", { className: 'theia-ChatInput', onDragOver: props.onDragOver, onDrop: props.onDrop },
        React.createElement(chat_input_agent_suggestions_1.ChatInputAgentSuggestions, { suggestions: props.suggestions, opener: props.openerService }),
        props.showChangeSet && (changeSetUI === null || changeSetUI === void 0 ? void 0 : changeSetUI.elements) &&
            React.createElement(ChangeSetBox, { changeSet: changeSetUI }),
        React.createElement("div", { className: 'theia-ChatInput-Editor-Box' },
            React.createElement("div", { className: 'theia-ChatInput-Editor', ref: editorContainerRef, onKeyDown: onKeyDown, onFocus: handleInputFocus, onBlur: handleInputBlur },
                React.createElement("div", { ref: placeholderRef, className: 'theia-ChatInput-Editor-Placeholder' }, core_1.nls.localizeByDefault('Ask a question'))),
            props.context && props.context.length > 0 &&
                React.createElement(ChatContext, { context: contextUI.context }),
            React.createElement(ChatInputOptions, { leftOptions: leftOptions, rightOptions: rightOptions })));
};
const noPropagation = (handler) => (e) => {
    handler();
    e.stopPropagation();
};
const buildChangeSetUI = (changeSet, labelProvider, decoratorService, actions, onDeleteChangeSet, onDeleteChangeSetElement) => ({
    title: changeSet.title,
    changeSet,
    deleteChangeSet: onDeleteChangeSet,
    elements: changeSet.getElements().map(element => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        return ({
            open: (_a = element.open) === null || _a === void 0 ? void 0 : _a.bind(element),
            iconClass: (_c = (_b = element.icon) !== null && _b !== void 0 ? _b : labelProvider.getIcon(element.uri)) !== null && _c !== void 0 ? _c : labelProvider.fileIcon,
            nameClass: `${element.type} ${element.state}`,
            name: (_d = element.name) !== null && _d !== void 0 ? _d : labelProvider.getName(element.uri),
            additionalInfo: (_e = element.additionalInfo) !== null && _e !== void 0 ? _e : labelProvider.getDetails(element.uri),
            additionalInfoSuffixIcon: decoratorService.getAdditionalInfoSuffixIcon(element),
            openChange: (_f = element === null || element === void 0 ? void 0 : element.openChange) === null || _f === void 0 ? void 0 : _f.bind(element),
            apply: element.state !== 'applied' ? (_g = element === null || element === void 0 ? void 0 : element.apply) === null || _g === void 0 ? void 0 : _g.bind(element) : undefined,
            revert: element.state === 'applied' || element.state === 'stale' ? (_h = element === null || element === void 0 ? void 0 : element.revert) === null || _h === void 0 ? void 0 : _h.bind(element) : undefined,
            delete: () => onDeleteChangeSetElement(changeSet.getElements().indexOf(element))
        });
    }),
    actions
});
/** Memo because the parent element rerenders on every key press in the chat widget. */
const ChangeSetBox = React.memo(({ changeSet: { changeSet, title, deleteChangeSet, elements, actions } }) => (React.createElement("div", { className: 'theia-ChatInput-ChangeSet-Box' },
    React.createElement("div", { className: 'theia-ChatInput-ChangeSet-Header' },
        React.createElement("h3", null, title),
        React.createElement("div", { className: 'theia-ChatInput-ChangeSet-Header-Actions' },
            actions.map(action => React.createElement("div", { key: action.id, className: 'theia-changeSet-Action' }, action.render(changeSet))),
            React.createElement("span", { className: 'codicon codicon-close action', title: core_1.nls.localize('theia/ai/chat-ui/deleteChangeSet', 'Delete Change Set'), onClick: () => deleteChangeSet() }))),
    React.createElement("div", { className: 'theia-ChatInput-ChangeSet-List' },
        React.createElement("ul", null, elements.map((element, index) => (React.createElement("li", { key: index, title: core_1.nls.localize('theia/ai/chat-ui/openDiff', 'Open Diff'), onClick: () => { var _a; return (_a = element.openChange) === null || _a === void 0 ? void 0 : _a.call(element); } },
            React.createElement("div", { className: `theia-ChatInput-ChangeSet-Icon ${element.iconClass}` }),
            React.createElement("div", { className: 'theia-ChatInput-ChangeSet-labelParts' },
                React.createElement("span", { className: `theia-ChatInput-ChangeSet-title ${element.nameClass}` }, element.name),
                React.createElement("div", { className: 'theia-ChatInput-ChangeSet-additionalInfo' },
                    element.additionalInfo && React.createElement("span", null, element.additionalInfo),
                    element.additionalInfoSuffixIcon
                        && React.createElement("div", { className: `theia-ChatInput-ChangeSet-AdditionalInfo-SuffixIcon ${element.additionalInfoSuffixIcon.join(' ')}` }))),
            React.createElement("div", { className: 'theia-ChatInput-ChangeSet-Actions' },
                element.open && (React.createElement("span", { className: 'codicon codicon-file action', title: core_1.nls.localize('theia/ai/chat-ui/openOriginalFile', 'Open Original File'), onClick: noPropagation(() => element.open()) })),
                element.revert && (React.createElement("span", { className: 'codicon codicon-discard action', title: core_1.nls.localizeByDefault('Revert'), onClick: noPropagation(() => element.revert()) })),
                element.apply && (React.createElement("span", { className: 'codicon codicon-check action', title: core_1.nls.localizeByDefault('Apply'), onClick: noPropagation(() => element.apply()) })),
                React.createElement("span", { className: 'codicon codicon-close action', title: core_1.nls.localizeByDefault('Delete'), onClick: noPropagation(() => element.delete()) }))))))))));
const ChatInputOptions = ({ leftOptions, rightOptions }) => (React.createElement("div", { className: "theia-ChatInputOptions" },
    React.createElement("div", { className: "theia-ChatInputOptions-left" }, leftOptions.map((option, index) => {
        var _a, _b;
        return (React.createElement("span", { key: index, className: `option ${option.disabled ? 'disabled' : ''} ${((_a = option.text) === null || _a === void 0 ? void 0 : _a.align) === 'right' ? 'reverse' : ''}`, title: option.title, onClick: option.handler },
            React.createElement("span", null, (_b = option.text) === null || _b === void 0 ? void 0 : _b.content),
            React.createElement("span", { className: `codicon ${option.className}` })));
    })),
    React.createElement("div", { className: "theia-ChatInputOptions-right" }, rightOptions.map((option, index) => {
        var _a, _b;
        return (React.createElement("span", { key: index, className: `option ${option.disabled ? 'disabled' : ''} ${((_a = option.text) === null || _a === void 0 ? void 0 : _a.align) === 'right' ? 'reverse' : ''}`, title: option.title, onClick: option.handler },
            React.createElement("span", null, (_b = option.text) === null || _b === void 0 ? void 0 : _b.content),
            React.createElement("span", { className: `codicon ${option.className}` })));
    }))));
function getLatestRequest(chatModel) {
    const requests = chatModel.getRequests();
    return requests.length > 0 ? requests[requests.length - 1] : undefined;
}
function buildContextUI(context, labelProvider, onDeleteContextElement, onOpen) {
    if (!context) {
        return { context: [] };
    }
    return {
        context: context.map((element, index) => ({
            name: labelProvider.getName(element),
            iconClass: labelProvider.getIcon(element),
            nameClass: element.variable.name,
            additionalInfo: labelProvider.getDetails(element),
            details: labelProvider.getLongName(element),
            delete: () => onDeleteContextElement(index),
            open: () => onOpen(element)
        }))
    };
}
const ChatContext = ({ context }) => (React.createElement("div", { className: "theia-ChatInput-ChatContext" },
    React.createElement("ul", null, context.map((element, index) => (React.createElement("li", { key: index, className: "theia-ChatInput-ChatContext-Element", title: element.details, onClick: () => { var _a; return (_a = element.open) === null || _a === void 0 ? void 0 : _a.call(element); } },
        React.createElement("div", { className: `theia-ChatInput-ChatContext-Icon ${element.iconClass}` }),
        React.createElement("div", { className: "theia-ChatInput-ChatContext-labelParts" },
            React.createElement("span", { className: `theia-ChatInput-ChatContext-title ${element.nameClass}` }, element.name),
            React.createElement("span", { className: 'theia-ChatInput-ChatContext-additionalInfo' }, element.additionalInfo)),
        React.createElement("span", { className: "codicon codicon-close action", title: core_1.nls.localizeByDefault('Delete'), onClick: e => { e.stopPropagation(); element.delete(); } })))))));


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-node-toolbar-action-contribution.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-node-toolbar-action-contribution.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultChatNodeToolbarActionContribution = exports.ChatNodeToolbarCommands = exports.ChatNodeToolbarActionContribution = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const chat_tree_view_1 = __webpack_require__(/*! ./chat-tree-view */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/index.js");
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
/**
 * Clients implement this interface if they want to contribute to the toolbar of chat nodes.
 *
 * ### Example
 * ```ts
 * bind(ChatNodeToolbarActionContribution).toDynamicValue(context => ({
 *  getToolbarActions: (args: RequestNode | ResponseNode) => {
 *      if (isResponseNode(args)) {
 *          return [{
 *              commandId: 'core.about',
 *              icon: 'codicon codicon-feedback',
 *              tooltip: 'Show about dialog on response nodes'
 *          }];
 *      } else {
 *          return [];
 *      }
 *  }
 * }));
 * ```
 */
exports.ChatNodeToolbarActionContribution = Symbol('ChatNodeToolbarActionContribution');
var ChatNodeToolbarCommands;
(function (ChatNodeToolbarCommands) {
    const CHAT_NODE_TOOLBAR_CATEGORY = 'ChatNodeToolbar';
    const CHAT_NODE_TOOLBAR_CATEGORY_KEY = core_1.nls.getDefaultKey(CHAT_NODE_TOOLBAR_CATEGORY);
    ChatNodeToolbarCommands.EDIT = core_1.Command.toLocalizedCommand({
        id: 'chat:node:toolbar:edit-request',
        category: CHAT_NODE_TOOLBAR_CATEGORY,
    }, '', CHAT_NODE_TOOLBAR_CATEGORY_KEY);
    ChatNodeToolbarCommands.CANCEL = core_1.Command.toLocalizedCommand({
        id: 'chat:node:toolbar:cancel-request',
        category: CHAT_NODE_TOOLBAR_CATEGORY,
    }, '', CHAT_NODE_TOOLBAR_CATEGORY_KEY);
})(ChatNodeToolbarCommands || (exports.ChatNodeToolbarCommands = ChatNodeToolbarCommands = {}));
class DefaultChatNodeToolbarActionContribution {
    getToolbarActions(node) {
        if ((0, chat_tree_view_1.isRequestNode)(node)) {
            if (ai_chat_1.EditableChatRequestModel.isEditing(node.request)) {
                return [{
                        commandId: ChatNodeToolbarCommands.CANCEL.id,
                        icon: (0, browser_1.codicon)('close'),
                        tooltip: core_1.nls.localize('theia/ai/chat-ui/node/toolbar/cancel', 'Cancel'),
                    }];
            }
            return [{
                    commandId: ChatNodeToolbarCommands.EDIT.id,
                    icon: (0, browser_1.codicon)('edit'),
                    tooltip: core_1.nls.localize('theia/ai/chat-ui/node/toolbar/edit', 'Edit'),
                }];
        }
        else {
            return [];
        }
    }
}
exports.DefaultChatNodeToolbarActionContribution = DefaultChatNodeToolbarActionContribution;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-progress-message.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-progress-message.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Indicator = exports.ProgressMessage = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const ProgressMessage = (c) => (React.createElement("div", { className: 'theia-ResponseNode-ProgressMessage' },
    React.createElement(exports.Indicator, { ...c }),
    " ",
    c.content));
exports.ProgressMessage = ProgressMessage;
const Indicator = (progressMessage) => (React.createElement("span", { className: 'theia-ResponseNode-ProgressMessage-Indicator' },
    progressMessage.status === 'inProgress' &&
        React.createElement("i", { className: 'fa fa-spinner fa-spin ' + progressMessage.status }),
    progressMessage.status === 'completed' &&
        React.createElement("i", { className: 'fa fa-check ' + progressMessage.status }),
    progressMessage.status === 'failed' &&
        React.createElement("i", { className: 'fa fa-warning ' + progressMessage.status })));
exports.Indicator = Indicator;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-part-renderer.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-part-renderer.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatResponsePartRenderer = void 0;
exports.ChatResponsePartRenderer = Symbol('ChatResponsePartRenderer');


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/markdown-part-renderer.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/markdown-part-renderer.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useMarkdownRendering = exports.MarkdownPartRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const react_1 = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const markdownit = __webpack_require__(/*! @theia/core/shared/markdown-it */ "../../node_modules/@theia/core/shared/markdown-it.js");
const DOMPurify = __webpack_require__(/*! @theia/core/shared/dompurify */ "../../node_modules/@theia/core/shared/dompurify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let MarkdownPartRenderer = class MarkdownPartRenderer {
    constructor() {
        this.markdownIt = markdownit();
    }
    canHandle(response) {
        if (common_1.MarkdownChatResponseContent.is(response)) {
            return 10;
        }
        if (common_1.InformationalChatResponseContent.is(response)) {
            return 10;
        }
        return -1;
    }
    render(response) {
        // TODO let the user configure whether they want to see informational content
        if (common_1.InformationalChatResponseContent.is(response)) {
            // null is valid in React
            // eslint-disable-next-line no-null/no-null
            return null;
        }
        return React.createElement(MarkdownRender, { response: response, openerService: this.openerService });
    }
};
exports.MarkdownPartRenderer = MarkdownPartRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], MarkdownPartRenderer.prototype, "openerService", void 0);
exports.MarkdownPartRenderer = MarkdownPartRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], MarkdownPartRenderer);
const MarkdownRender = ({ response, openerService }) => {
    const ref = (0, exports.useMarkdownRendering)(response.content, openerService);
    return React.createElement("div", { ref: ref });
};
/**
 * This hook uses markdown-it directly to render markdown.
 * The reason to use markdown-it directly is that the MarkdownRenderer is
 * overridden by theia with a monaco version. This monaco version strips all html
 * tags from the markdown with empty content. This leads to unexpected behavior when
 * rendering markdown with html tags.
 *
 * Moreover, we want to intercept link clicks to use the Theia OpenerService instead of the default browser behavior.
 *
 * @param markdown the string to render as markdown
 * @param skipSurroundingParagraph whether to remove a surrounding paragraph element (default: false)
 * @param openerService the service to handle link opening
 * @param eventHandler `handleEvent` will be called by default for `click` events and additionally
 * for all events enumerated in {@link DeclaredEventsEventListenerObject.handledEvents}. If `handleEvent` returns `true`,
 * no additional handlers will be run for the event.
 * @returns the ref to use in an element to render the markdown
 */
const useMarkdownRendering = (markdown, openerService, skipSurroundingParagraph = false, eventHandler) => {
    // null is valid in React
    // eslint-disable-next-line no-null/no-null
    const ref = (0, react_1.useRef)(null);
    const markdownString = typeof markdown === 'string' ? markdown : markdown.value;
    (0, react_1.useEffect)(() => {
        var _a, _b, _c, _d;
        const markdownIt = markdownit();
        const host = document.createElement('div');
        // markdownIt always puts the content in a paragraph element, so we remove it if we don't want that
        const html = skipSurroundingParagraph ? markdownIt.render(markdownString).replace(/^<p>|<\/p>|<p><\/p>$/g, '') : markdownIt.render(markdownString);
        host.innerHTML = DOMPurify.sanitize(html, {
            // DOMPurify usually strips non http(s) links from hrefs
            // but we want to allow them (see handleClick via OpenerService below)
            ALLOW_UNKNOWN_PROTOCOLS: true
        });
        while ((_a = ref === null || ref === void 0 ? void 0 : ref.current) === null || _a === void 0 ? void 0 : _a.firstChild) {
            ref.current.removeChild(ref.current.firstChild);
        }
        (_b = ref === null || ref === void 0 ? void 0 : ref.current) === null || _b === void 0 ? void 0 : _b.appendChild(host);
        // intercept link clicks to use the Theia OpenerService instead of the default browser behavior
        const handleClick = (event) => {
            if ((eventHandler === null || eventHandler === void 0 ? void 0 : eventHandler.handleEvent(event)) === true) {
                return;
            }
            let target = event.target;
            while (target && target.tagName !== 'A') {
                target = target.parentElement;
            }
            if (target && target.tagName === 'A') {
                const href = target.getAttribute('href');
                if (href) {
                    (0, browser_1.open)(openerService, new core_1.URI(href));
                    event.preventDefault();
                }
            }
        };
        (_c = ref === null || ref === void 0 ? void 0 : ref.current) === null || _c === void 0 ? void 0 : _c.addEventListener('click', handleClick);
        (_d = eventHandler === null || eventHandler === void 0 ? void 0 : eventHandler.handledEvents) === null || _d === void 0 ? void 0 : _d.forEach(eventType => { var _a; return eventType !== 'click' && ((_a = ref === null || ref === void 0 ? void 0 : ref.current) === null || _a === void 0 ? void 0 : _a.addEventListener(eventType, eventHandler)); });
        return () => {
            var _a, _b;
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.removeEventListener('click', handleClick);
            (_b = eventHandler === null || eventHandler === void 0 ? void 0 : eventHandler.handledEvents) === null || _b === void 0 ? void 0 : _b.forEach(eventType => { var _a; return eventType !== 'click' && ((_a = ref === null || ref === void 0 ? void 0 : ref.current) === null || _a === void 0 ? void 0 : _a.removeEventListener(eventType, eventHandler)); });
        };
    }, [markdownString, skipSurroundingParagraph, openerService]);
    return ref;
};
exports.useMarkdownRendering = useMarkdownRendering;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-container.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-container.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createChatViewTreeWidget = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const chat_view_tree_widget_1 = __webpack_require__(/*! ./chat-view-tree-widget */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-widget.js");
const CHAT_VIEW_TREE_PROPS = {
    multiSelect: false,
    search: false,
};
function createChatViewTreeWidget(parent) {
    const child = (0, browser_1.createTreeContainer)(parent, {
        props: CHAT_VIEW_TREE_PROPS,
        widget: chat_view_tree_widget_1.ChatViewTreeWidget,
    });
    return child.get(chat_view_tree_widget_1.ChatViewTreeWidget);
}
exports.createChatViewTreeWidget = createChatViewTreeWidget;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-input-widget.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-input-widget.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIChatTreeInputWidget = exports.AIChatTreeInputFactory = exports.AIChatTreeInputArgs = exports.AIChatTreeInputConfiguration = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_input_widget_1 = __webpack_require__(/*! ../chat-input-widget */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-input-widget.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const chat_view_language_contribution_1 = __webpack_require__(/*! ../chat-view-language-contribution */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-view-language-contribution.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
exports.AIChatTreeInputConfiguration = Symbol('AIChatTreeInputConfiguration');
exports.AIChatTreeInputArgs = Symbol('AIChatTreeInputArgs');
exports.AIChatTreeInputFactory = Symbol('AIChatTreeInputFactory');
let AIChatTreeInputWidget = class AIChatTreeInputWidget extends chat_input_widget_1.AIChatInputWidget {
    get requestNode() {
        return this.args.node;
    }
    get request() {
        return this.requestNode.request;
    }
    init() {
        super.init();
        this.addKeyListener(this.node, browser_1.Key.ESCAPE, () => {
            this.request.cancelEdit();
        });
        this.editorReady.promise.then(() => {
            if (this.editorRef) {
                this.editorRef.focus();
            }
        });
    }
    getResourceUri() {
        return new core_1.URI(`ai-chat:/${this.requestNode.id}-input.${chat_view_language_contribution_1.CHAT_VIEW_LANGUAGE_EXTENSION}`);
    }
    addContext(variable) {
        this.request.editContextManager.addVariables(variable);
    }
    getContext() {
        return this.request.editContextManager.getVariables();
    }
    deleteContextElement(index) {
        this.request.editContextManager.deleteVariables(index);
    }
};
exports.AIChatTreeInputWidget = AIChatTreeInputWidget;
AIChatTreeInputWidget.ID = 'chat-tree-input-widget';
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.AIChatTreeInputArgs),
    tslib_1.__metadata("design:type", Object)
], AIChatTreeInputWidget.prototype, "args", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.AIChatTreeInputConfiguration),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], AIChatTreeInputWidget.prototype, "configuration", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIChatTreeInputWidget.prototype, "init", null);
exports.AIChatTreeInputWidget = AIChatTreeInputWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIChatTreeInputWidget);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-widget.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-widget.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var ChatViewTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatViewTreeWidget = exports.ChatWelcomeMessageProvider = exports.isEnterKey = exports.isResponseNode = exports.isEditableRequestNode = exports.isRequestNode = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const chat_node_toolbar_action_contribution_1 = __webpack_require__(/*! ../chat-node-toolbar-action-contribution */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-node-toolbar-action-contribution.js");
const chat_response_part_renderer_1 = __webpack_require__(/*! ../chat-response-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-part-renderer.js");
const markdown_part_renderer_1 = __webpack_require__(/*! ../chat-response-renderer/markdown-part-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/markdown-part-renderer.js");
const chat_progress_message_1 = __webpack_require__(/*! ../chat-progress-message */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-progress-message.js");
const chat_view_tree_input_widget_1 = __webpack_require__(/*! ./chat-view-tree-input-widget */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-input-widget.js");
const isRequestNode = (node) => 'request' in node;
exports.isRequestNode = isRequestNode;
const isEditableRequestNode = (node) => (0, exports.isRequestNode)(node) && ai_chat_1.EditableChatRequestModel.is(node.request);
exports.isEditableRequestNode = isEditableRequestNode;
const isResponseNode = (node) => 'response' in node;
exports.isResponseNode = isResponseNode;
function isEnterKey(e) {
    var _a;
    return browser_2.Key.ENTER.keyCode === ((_a = browser_2.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode);
}
exports.isEnterKey = isEnterKey;
exports.ChatWelcomeMessageProvider = Symbol('ChatWelcomeMessageProvider');
let ChatViewTreeWidget = ChatViewTreeWidget_1 = class ChatViewTreeWidget extends browser_2.TreeWidget {
    set shouldScrollToEnd(shouldScrollToEnd) {
        this._shouldScrollToEnd = shouldScrollToEnd;
        this.shouldScrollToRow = this._shouldScrollToEnd;
    }
    get shouldScrollToEnd() {
        return this._shouldScrollToEnd;
    }
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.onDidSubmitEditEmitter = new core_1.Emitter();
        this.onDidSubmitEdit = this.onDidSubmitEditEmitter.event;
        this.chatInputs = new Map();
        this._shouldScrollToEnd = true;
        this.isEnabled = false;
        this.toDisposeOnChatModelChange = new core_1.DisposableCollection();
        this.id = ChatViewTreeWidget_1.ID;
        this.title.closable = false;
        model.root = {
            id: 'ChatTree',
            name: 'ChatRootNode',
            parent: undefined,
            visible: false,
            children: [],
        };
    }
    init() {
        super.init();
        this.id = ChatViewTreeWidget_1.ID + '-treeContainer';
        this.addClass('treeContainer');
        this.toDispose.pushAll([
            this.toDisposeOnChatModelChange,
            this.activationService.onDidChangeActiveStatus(change => {
                this.chatInputs.forEach(widget => {
                    widget.setEnabled(change);
                });
                this.update();
            })
        ]);
    }
    setEnabled(enabled) {
        this.isEnabled = enabled;
        this.update();
    }
    renderTree(model) {
        var _a;
        if (!this.isEnabled) {
            return this.renderDisabledMessage();
        }
        if (browser_2.CompositeTreeNode.is(model.root) && ((_a = model.root.children) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            return super.renderTree(model);
        }
        return this.renderWelcomeMessage();
    }
    renderDisabledMessage() {
        var _a, _b, _c;
        return (_c = (_b = (_a = this.welcomeMessageProvider) === null || _a === void 0 ? void 0 : _a.renderDisabledMessage) === null || _b === void 0 ? void 0 : _b.call(_a)) !== null && _c !== void 0 ? _c : React.createElement(React.Fragment, null);
    }
    renderWelcomeMessage() {
        var _a, _b, _c;
        return (_c = (_b = (_a = this.welcomeMessageProvider) === null || _a === void 0 ? void 0 : _a.renderWelcomeMessage) === null || _b === void 0 ? void 0 : _b.call(_a)) !== null && _c !== void 0 ? _c : React.createElement(React.Fragment, null);
    }
    mapRequestToNode(branch) {
        return {
            parent: this.model.root,
            get id() {
                return this.request.id;
            },
            get request() {
                return branch.get();
            },
            branch
        };
    }
    mapResponseToNode(response) {
        return {
            id: response.id,
            parent: this.model.root,
            response
        };
    }
    /**
     * Tracks the ChatModel handed over.
     * Tracking multiple chat models will result in a weird UI
     */
    trackChatModel(chatModel) {
        this.toDisposeOnChatModelChange.dispose();
        this.recreateModelTree(chatModel);
        chatModel.getRequests().forEach(request => {
            if (!request.response.isComplete) {
                request.response.onDidChange(() => this.scheduleUpdateScrollToRow());
            }
        });
        this.toDisposeOnChatModelChange.pushAll([
            core_1.Disposable.create(() => {
                this.chatInputs.forEach(widget => widget.dispose());
                this.chatInputs.clear();
            }),
            chatModel.onDidChange(event => {
                var _a;
                if (event.kind === 'enableEdit') {
                    this.scrollToRow = (_a = this.rows.get(event.request.id)) === null || _a === void 0 ? void 0 : _a.index;
                    this.update();
                    return;
                }
                else if (event.kind === 'cancelEdit') {
                    this.disposeChatInputWidget(event.request);
                    this.scrollToRow = undefined;
                    this.update();
                    return;
                }
                else if (event.kind === 'changeHierarchyBranch') {
                    this.scrollToRow = undefined;
                }
                this.recreateModelTree(chatModel);
                if (event.kind === 'addRequest' && !event.request.response.isComplete) {
                    event.request.response.onDidChange(() => this.scheduleUpdateScrollToRow());
                }
                else if (event.kind === 'submitEdit') {
                    event.branch.succeedingBranches().forEach(branch => {
                        this.disposeChatInputWidget(branch.get());
                    });
                    this.onDidSubmitEditEmitter.fire(event.newRequest);
                }
            })
        ]);
    }
    disposeChatInputWidget(request) {
        const widget = this.chatInputs.get(request.id);
        if (widget) {
            widget.dispose();
            this.chatInputs.delete(request.id);
        }
    }
    getScrollToRow() {
        if (this.shouldScrollToEnd) {
            return this.rows.size;
        }
        return super.getScrollToRow();
    }
    async recreateModelTree(chatModel) {
        if (browser_2.CompositeTreeNode.is(this.model.root)) {
            const nodes = [];
            chatModel.getBranches().forEach(branch => {
                const request = branch.get();
                nodes.push(this.mapRequestToNode(branch));
                nodes.push(this.mapResponseToNode(request.response));
            });
            this.model.root.children = nodes;
            this.model.refresh();
        }
    }
    renderNode(node, props) {
        if (!browser_2.TreeNode.isVisible(node)) {
            return undefined;
        }
        if (!((0, exports.isRequestNode)(node) || (0, exports.isResponseNode)(node))) {
            return super.renderNode(node, props);
        }
        return React.createElement(React.Fragment, { key: node.id },
            React.createElement("div", { className: 'theia-ChatNode', onContextMenu: e => this.handleContextMenu(node, e) },
                this.renderAgent(node),
                this.renderDetail(node)));
    }
    renderAgent(node) {
        var _a;
        const inProgress = (0, exports.isResponseNode)(node) && !node.response.isComplete && !node.response.isCanceled && !node.response.isError;
        const waitingForInput = (0, exports.isResponseNode)(node) && node.response.isWaitingForInput;
        const toolbarContributions = !inProgress
            ? this.chatNodeToolbarActionContributions.getContributions()
                .flatMap(c => c.getToolbarActions(node))
                .filter(action => this.commandRegistry.isEnabled(action.commandId, node))
                .sort((a, b) => { var _a, _b; return ((_a = a.priority) !== null && _a !== void 0 ? _a : 0) - ((_b = b.priority) !== null && _b !== void 0 ? _b : 0); })
            : [];
        const agentLabel = React.createRef();
        const agentDescription = (_a = this.getAgent(node)) === null || _a === void 0 ? void 0 : _a.description;
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'theia-ChatNodeHeader' },
                React.createElement("div", { className: `theia-AgentAvatar ${this.getAgentIconClassName(node)}` }),
                React.createElement("h3", { ref: agentLabel, className: 'theia-AgentLabel', onMouseEnter: () => {
                        if (agentDescription) {
                            this.hoverService.requestHover({
                                content: agentDescription,
                                target: agentLabel.current,
                                position: 'right'
                            });
                        }
                    } }, this.getAgentLabel(node)),
                inProgress && !waitingForInput && React.createElement("span", { className: 'theia-ChatContentInProgress' }, nls_1.nls.localizeByDefault('Generating')),
                inProgress && waitingForInput && React.createElement("span", { className: 'theia-ChatContentInProgress' }, nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/waitingForInput', 'Waiting for input')),
                React.createElement("div", { className: 'theia-ChatNodeToolbar' }, !inProgress &&
                    toolbarContributions.length > 0 &&
                    toolbarContributions.map(action => React.createElement("span", { key: action.commandId, className: `theia-ChatNodeToolbarAction ${action.icon}`, title: action.tooltip, onClick: e => {
                            e.stopPropagation();
                            this.commandRegistry.executeCommand(action.commandId, node);
                        }, onKeyDown: e => {
                            if (isEnterKey(e)) {
                                e.stopPropagation();
                                this.commandRegistry.executeCommand(action.commandId, node);
                            }
                        }, role: 'button' })))));
    }
    getAgentLabel(node) {
        var _a, _b;
        if ((0, exports.isRequestNode)(node)) {
            // TODO find user name
            return nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/you', 'You');
        }
        return (_b = (_a = this.getAgent(node)) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/ai', 'AI');
    }
    getAgent(node) {
        if ((0, exports.isRequestNode)(node)) {
            return undefined;
        }
        return node.response.agentId ? this.chatAgentService.getAgent(node.response.agentId) : undefined;
    }
    getAgentIconClassName(node) {
        var _a;
        if ((0, exports.isRequestNode)(node)) {
            return (0, browser_2.codicon)('account');
        }
        const agent = node.response.agentId ? this.chatAgentService.getAgent(node.response.agentId) : undefined;
        return (_a = agent === null || agent === void 0 ? void 0 : agent.iconClass) !== null && _a !== void 0 ? _a : (0, browser_2.codicon)('copilot');
    }
    renderDetail(node) {
        if ((0, exports.isRequestNode)(node)) {
            return this.renderChatRequest(node);
        }
        if ((0, exports.isResponseNode)(node)) {
            return this.renderChatResponse(node);
        }
        ;
    }
    renderChatRequest(node) {
        return React.createElement(ChatRequestRender, { node: node, hoverService: this.hoverService, chatAgentService: this.chatAgentService, variableService: this.variableService, openerService: this.openerService, provideChatInputWidget: () => {
                const editableNode = node;
                if ((0, exports.isEditableRequestNode)(editableNode)) {
                    let widget = this.chatInputs.get(editableNode.id);
                    if (!widget) {
                        widget = this.inputWidgetFactory({
                            node: editableNode,
                            initialValue: editableNode.request.message.request.text,
                            onQuery: async (query) => {
                                editableNode.request.submitEdit({ text: query });
                            }
                        });
                        this.chatInputs.set(editableNode.id, widget);
                        widget.disposed.connect(() => {
                            this.chatInputs.delete(editableNode.id);
                            editableNode.request.cancelEdit();
                        });
                    }
                    return widget;
                }
                return;
            } });
    }
    renderChatResponse(node) {
        return (React.createElement("div", { className: 'theia-ResponseNode' },
            !node.response.isComplete
                && node.response.response.content.length === 0
                && node.response.progressMessages
                    .filter(c => c.show === 'untilFirstContent')
                    .map((c, i) => React.createElement(chat_progress_message_1.ProgressMessage, { ...c, key: `${node.id}-progress-untilFirstContent-${i}` })),
            node.response.response.content.map((c, i) => React.createElement("div", { className: 'theia-ResponseNode-Content', key: `${node.id}-content-${i}` }, this.getChatResponsePartRenderer(c, node))),
            !node.response.isComplete
                && node.response.progressMessages
                    .filter(c => c.show === 'whileIncomplete')
                    .map((c, i) => React.createElement(chat_progress_message_1.ProgressMessage, { ...c, key: `${node.id}-progress-whileIncomplete-${i}` })),
            node.response.progressMessages
                .filter(c => c.show === 'forever')
                .map((c, i) => React.createElement(chat_progress_message_1.ProgressMessage, { ...c, key: `${node.id}-progress-afterComplete-${i}` }))));
    }
    getChatResponsePartRenderer(content, node) {
        const renderer = this.chatResponsePartRenderers.getContributions().reduce((prev, current) => {
            const prio = current.canHandle(content);
            if (prio > prev[0]) {
                return [prio, current];
            }
            return prev;
        }, [-1, undefined])[1];
        if (!renderer) {
            console.error('No renderer found for content', content);
            return React.createElement("div", null, nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/noRenderer', 'Error: No renderer found'));
        }
        return renderer.render(content, node);
    }
    handleContextMenu(node, event) {
        this.contextMenuRenderer.render({
            menuPath: ChatViewTreeWidget_1.CONTEXT_MENU,
            anchor: { x: event.clientX, y: event.clientY },
            args: [node],
            context: event.currentTarget
        });
        event.preventDefault();
    }
    handleSpace(event) {
        // We need to return false to prevent the handler within
        // packages/core/src/browser/widgets/widget.ts
        // Otherwise, the space key will never be handled by the monaco editor
        return false;
    }
};
exports.ChatViewTreeWidget = ChatViewTreeWidget;
ChatViewTreeWidget.ID = 'chat-tree-widget';
ChatViewTreeWidget.CONTEXT_MENU = ['chat-tree-context-menu'];
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(chat_response_part_renderer_1.ChatResponsePartRenderer),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "chatResponsePartRenderers", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(chat_node_toolbar_action_contribution_1.ChatNodeToolbarActionContribution),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "chatNodeToolbarActionContributions", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_chat_1.ChatAgentService),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "chatAgentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], ChatViewTreeWidget.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.OpenerService),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.HoverService),
    tslib_1.__metadata("design:type", browser_2.HoverService)
], ChatViewTreeWidget.prototype, "hoverService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.ChatWelcomeMessageProvider),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "welcomeMessageProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_view_tree_input_widget_1.AIChatTreeInputFactory),
    tslib_1.__metadata("design:type", Function)
], ChatViewTreeWidget.prototype, "inputWidgetFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.AIActivationService),
    tslib_1.__metadata("design:type", browser_1.AIActivationService)
], ChatViewTreeWidget.prototype, "activationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_chat_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], ChatViewTreeWidget.prototype, "chatService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ChatViewTreeWidget.prototype, "init", null);
exports.ChatViewTreeWidget = ChatViewTreeWidget = ChatViewTreeWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(browser_2.TreeProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(browser_2.TreeModel)),
    tslib_1.__param(2, (0, inversify_1.inject)(browser_2.ContextMenuRenderer)),
    tslib_1.__metadata("design:paramtypes", [Object, Object, browser_2.ContextMenuRenderer])
], ChatViewTreeWidget);
const WidgetContainer = ({ widget }) => {
    // eslint-disable-next-line no-null/no-null
    const containerRef = React.useRef(null);
    React.useEffect(() => {
        if (containerRef.current && !widget.isAttached) {
            browser_2.Widget.attach(widget, containerRef.current);
        }
    }, [containerRef.current]);
    // Clean up
    React.useEffect(() => () => {
        setTimeout(() => {
            // Delay clean up to allow react to finish its rendering cycle
            widget.clearFlag(browser_2.Widget.Flag.IsAttached);
            widget.dispose();
        });
    }, []);
    return React.createElement("div", { ref: containerRef });
};
const ChatRequestRender = ({ node, hoverService, chatAgentService, variableService, openerService, provideChatInputWidget }) => {
    const parts = node.request.message.parts;
    if (ai_chat_1.EditableChatRequestModel.isEditing(node.request)) {
        const widget = provideChatInputWidget();
        if (widget) {
            return React.createElement("div", { className: "theia-RequestNode" },
                React.createElement(WidgetContainer, { widget: widget }));
        }
    }
    const renderFooter = () => {
        if (node.branch.items.length < 2) {
            return;
        }
        const isFirst = node.branch.activeBranchIndex === 0;
        const isLast = node.branch.activeBranchIndex === node.branch.items.length - 1;
        return (React.createElement("div", { className: 'theia-RequestNode-Footer' },
            React.createElement("div", { className: `item ${isFirst ? '' : 'enabled'}` },
                React.createElement("div", { className: "codicon codicon-chevron-left action-label", title: "Previous", onClick: () => {
                        node.branch.enablePrevious();
                    } })),
            React.createElement("small", null,
                React.createElement("span", null,
                    node.branch.activeBranchIndex + 1,
                    "/"),
                React.createElement("span", null, node.branch.items.length)),
            React.createElement("div", { className: `item ${isLast ? '' : 'enabled'}` },
                React.createElement("div", { className: 'codicon codicon-chevron-right action-label', title: "Next", onClick: () => {
                        node.branch.enableNext();
                    } }))));
    };
    return (React.createElement("div", { className: "theia-RequestNode" },
        React.createElement("p", null, parts.map((part, index) => {
            var _a, _b;
            if (part instanceof ai_chat_1.ParsedChatRequestAgentPart || part instanceof ai_chat_1.ParsedChatRequestVariablePart) {
                let description = undefined;
                let className = '';
                if (part instanceof ai_chat_1.ParsedChatRequestAgentPart) {
                    description = (_a = chatAgentService.getAgent(part.agentId)) === null || _a === void 0 ? void 0 : _a.description;
                    className = 'theia-RequestNode-AgentLabel';
                }
                else if (part instanceof ai_chat_1.ParsedChatRequestVariablePart) {
                    description = (_b = variableService.getVariable(part.variableName)) === null || _b === void 0 ? void 0 : _b.description;
                    className = 'theia-RequestNode-VariableLabel';
                }
                return (React.createElement(HoverableLabel, { key: index, text: part.text, description: description, hoverService: hoverService, className: className }));
            }
            else {
                const ref = (0, markdown_part_renderer_1.useMarkdownRendering)(part.text
                    .replace(/^[\r\n]+|[\r\n]+$/g, '') // remove excessive new lines
                    .replace(/(^ )/g, '&nbsp;'), // enforce keeping space before
                openerService, true);
                return (React.createElement("span", { key: index, ref: ref }));
            }
        })),
        renderFooter()));
};
const HoverableLabel = ({ text, description, hoverService, className }) => {
    const spanRef = React.createRef();
    return (React.createElement("span", { className: className, ref: spanRef, onMouseEnter: () => {
            if (description) {
                hoverService.requestHover({
                    content: description,
                    target: spanRef.current,
                    position: 'right'
                });
            }
        } }, text));
};


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/index.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./chat-view-tree-container */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-container.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./chat-view-tree-widget */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/chat-view-tree-widget.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-view-language-contribution.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/chat-view-language-contribution.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatViewLanguageContribution = exports.CHAT_VIEW_LANGUAGE_EXTENSION = exports.SETTINGS_LANGUAGE_ID = exports.CHAT_VIEW_LANGUAGE_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const prompt_text_1 = __webpack_require__(/*! @theia/ai-core/lib/common/prompt-text */ "../../node_modules/@theia/ai-core/lib/common/prompt-text.js");
const tool_invocation_registry_1 = __webpack_require__(/*! @theia/ai-core/lib/common/tool-invocation-registry */ "../../node_modules/@theia/ai-core/lib/common/tool-invocation-registry.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const ai_chat_frontend_contribution_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/ai-chat-frontend-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-contribution.js");
exports.CHAT_VIEW_LANGUAGE_ID = 'theia-ai-chat-view-language';
exports.SETTINGS_LANGUAGE_ID = 'theia-ai-chat-settings-language';
exports.CHAT_VIEW_LANGUAGE_EXTENSION = 'aichatviewlanguage';
const VARIABLE_RESOLUTION_CONTEXT = { context: 'chat-input-autocomplete' };
const VARIABLE_ARGUMENT_PICKER_COMMAND = 'trigger-variable-argument-picker';
let ChatViewLanguageContribution = class ChatViewLanguageContribution {
    onStart(_app) {
        monaco.languages.register({ id: exports.CHAT_VIEW_LANGUAGE_ID, extensions: [exports.CHAT_VIEW_LANGUAGE_EXTENSION] });
        monaco.languages.register({ id: exports.SETTINGS_LANGUAGE_ID, extensions: ['json'], filenames: ['editor'] });
        this.registerCompletionProviders();
        monaco.editor.registerCommand(VARIABLE_ARGUMENT_PICKER_COMMAND, this.triggerVariableArgumentPicker.bind(this));
    }
    registerCompletionProviders() {
        this.registerStandardCompletionProvider({
            triggerCharacter: prompt_text_1.PromptText.AGENT_CHAR,
            getItems: () => this.agentService.getAgents(),
            kind: monaco.languages.CompletionItemKind.Value,
            getId: agent => `${agent.id} `,
            getName: agent => agent.name,
            getDescription: agent => agent.description
        });
        this.registerStandardCompletionProvider({
            triggerCharacter: prompt_text_1.PromptText.VARIABLE_CHAR,
            getItems: () => this.variableService.getVariables(),
            kind: monaco.languages.CompletionItemKind.Variable,
            getId: variable => { var _a; return ((_a = variable.args) === null || _a === void 0 ? void 0 : _a.some(arg => !arg.isOptional)) ? variable.name + prompt_text_1.PromptText.VARIABLE_SEPARATOR_CHAR : `${variable.name} `; },
            getName: variable => variable.name,
            getDescription: variable => variable.description,
            command: {
                title: core_1.nls.localize('theia/ai/chat-ui/selectVariableArguments', 'Select variable arguments'),
                id: VARIABLE_ARGUMENT_PICKER_COMMAND,
            }
        });
        this.registerStandardCompletionProvider({
            triggerCharacter: prompt_text_1.PromptText.FUNCTION_CHAR,
            getItems: () => this.toolInvocationRegistry.getAllFunctions(),
            kind: monaco.languages.CompletionItemKind.Function,
            getId: tool => `${tool.id} `,
            getName: tool => tool.name,
            getDescription: tool => { var _a; return (_a = tool.description) !== null && _a !== void 0 ? _a : ''; }
        });
        // Register the variable argument completion provider (special case)
        monaco.languages.registerCompletionItemProvider(exports.CHAT_VIEW_LANGUAGE_ID, {
            triggerCharacters: [prompt_text_1.PromptText.VARIABLE_CHAR, prompt_text_1.PromptText.VARIABLE_SEPARATOR_CHAR],
            provideCompletionItems: (model, position, _context, _token) => this.provideVariableWithArgCompletions(model, position),
        });
    }
    registerStandardCompletionProvider(source) {
        monaco.languages.registerCompletionItemProvider(exports.CHAT_VIEW_LANGUAGE_ID, {
            triggerCharacters: [source.triggerCharacter],
            provideCompletionItems: (model, position, _context, _token) => this.provideCompletions(model, position, source),
        });
    }
    getCompletionRange(model, position, triggerCharacter) {
        const wordInfo = model.getWordUntilPosition(position);
        const lineContent = model.getLineContent(position.lineNumber);
        // one to the left, and -1 for 0-based index
        const characterBeforeCurrentWord = lineContent[wordInfo.startColumn - 1 - 1];
        if (characterBeforeCurrentWord !== triggerCharacter) {
            return undefined;
        }
        // we are not at the beginning of the line
        if (wordInfo.startColumn > 2) {
            const charBeforeTrigger = model.getValueInRange({
                startLineNumber: position.lineNumber,
                startColumn: wordInfo.startColumn - 2,
                endLineNumber: position.lineNumber,
                endColumn: wordInfo.startColumn - 1
            });
            // If the character before the trigger is not whitespace, don't provide completions
            if (!/\s/.test(charBeforeTrigger)) {
                return undefined;
            }
        }
        return new monaco.Range(position.lineNumber, wordInfo.startColumn, position.lineNumber, position.column);
    }
    provideCompletions(model, position, source) {
        const completionRange = this.getCompletionRange(model, position, source.triggerCharacter);
        if (completionRange === undefined) {
            return { suggestions: [] };
        }
        const items = source.getItems();
        const suggestions = items.map(item => ({
            insertText: source.getId(item),
            kind: source.kind,
            label: source.getName(item),
            range: completionRange,
            detail: source.getDescription(item),
            command: source.command
        }));
        return { suggestions };
    }
    async provideVariableWithArgCompletions(model, position) {
        // Get the text of the current line up to the cursor position
        const textUntilPosition = model.getValueInRange({
            startLineNumber: position.lineNumber,
            startColumn: 1,
            endLineNumber: position.lineNumber,
            endColumn: position.column,
        });
        // Regex that captures the variable name in contexts like "#varname" or "#var-name:args"
        // Matches only when # is at the beginning of the string or after whitespace
        const variableRegex = /(?:^|\s)#([\w-]*)/;
        const match = textUntilPosition.match(variableRegex);
        if (!match) {
            return { suggestions: [] };
        }
        const currentVariableName = match[1];
        const hasColonSeparator = textUntilPosition.includes(`${currentVariableName}:`);
        const variables = this.variableService.getVariables();
        const suggestions = [];
        for (const variable of variables) {
            // If we have a variable:arg pattern, only process the matching variable
            if (hasColonSeparator && variable.name !== currentVariableName) {
                continue;
            }
            const provider = await this.variableService.getArgumentCompletionProvider(variable.name);
            if (provider) {
                const items = await provider(model, position);
                if (items) {
                    suggestions.push(...items.map(item => ({
                        command: {
                            title: ai_chat_frontend_contribution_1.VARIABLE_ADD_CONTEXT_COMMAND.label,
                            id: ai_chat_frontend_contribution_1.VARIABLE_ADD_CONTEXT_COMMAND.id,
                            arguments: [variable.name, item.insertText]
                        },
                        ...item,
                    })));
                }
            }
        }
        return { suggestions };
    }
    async triggerVariableArgumentPicker() {
        var _a;
        const inputEditor = monaco.editor.getEditors().find(editor => editor.hasTextFocus());
        if (!inputEditor) {
            return;
        }
        const model = inputEditor.getModel();
        const position = inputEditor.getPosition();
        if (!model || !position) {
            return;
        }
        // // Get the word at cursor
        const wordInfo = model.getWordUntilPosition(position);
        // account for the variable separator character if present
        let endOfWordPosition = position.column;
        if (wordInfo.word === '' && this.getCharacterBeforePosition(model, position) === prompt_text_1.PromptText.VARIABLE_SEPARATOR_CHAR) {
            endOfWordPosition = position.column - 1;
        }
        else {
            return;
        }
        const variableName = (_a = model.getWordAtPosition({ ...position, column: endOfWordPosition })) === null || _a === void 0 ? void 0 : _a.word;
        if (!variableName) {
            return;
        }
        const provider = await this.variableService.getArgumentPicker(variableName, VARIABLE_RESOLUTION_CONTEXT);
        if (!provider) {
            return;
        }
        const arg = await provider(VARIABLE_RESOLUTION_CONTEXT);
        if (!arg) {
            return;
        }
        inputEditor.executeEdits('variable-argument-picker', [{
                range: new monaco.Range(position.lineNumber, position.column, position.lineNumber, position.column),
                text: arg
            }]);
        await this.chatFrontendContribution.addContextVariable(variableName, arg);
    }
    getCharacterBeforePosition(model, position) {
        return model.getLineContent(position.lineNumber)[position.column - 1 - 1];
    }
};
exports.ChatViewLanguageContribution = ChatViewLanguageContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_chat_1.ChatAgentService),
    tslib_1.__metadata("design:type", Object)
], ChatViewLanguageContribution.prototype, "agentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], ChatViewLanguageContribution.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(tool_invocation_registry_1.ToolInvocationRegistry),
    tslib_1.__metadata("design:type", Object)
], ChatViewLanguageContribution.prototype, "toolInvocationRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_chat_frontend_contribution_1.AIChatFrontendContribution),
    tslib_1.__metadata("design:type", ai_chat_frontend_contribution_1.AIChatFrontendContribution)
], ChatViewLanguageContribution.prototype, "chatFrontendContribution", void 0);
exports.ChatViewLanguageContribution = ChatViewLanguageContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatViewLanguageContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat-ui/lib/browser/context-variable-picker.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat-ui/lib/browser/context-variable-picker.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextVariablePicker = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const QUERY_CONTEXT = { type: 'context-variable-picker' };
let ContextVariablePicker = class ContextVariablePicker {
    async pickContextVariable() {
        const variables = this.variableService.getContextVariables();
        const selection = await this.quickInputService.showQuickPick(variables.map(v => {
            var _a;
            return ({
                id: v.id,
                label: (_a = v.label) !== null && _a !== void 0 ? _a : v.name,
                variable: v,
                iconClasses: v.iconClasses,
            });
        }), { placeholder: 'Select a context variable to be attached to the message', });
        if (!selection) {
            return undefined;
        }
        const variable = selection.variable;
        if (!variable.args || variable.args.length === 0) {
            return { variable };
        }
        const argumentPicker = await this.variableService.getArgumentPicker(variable.name, QUERY_CONTEXT);
        if (!argumentPicker) {
            return this.useGenericArgumentPicker(variable);
        }
        const arg = await argumentPicker(QUERY_CONTEXT);
        if (!arg) {
            return undefined;
        }
        return { variable, arg };
    }
    async useGenericArgumentPicker(variable) {
        var _a;
        const args = [];
        for (const argument of (_a = variable.args) !== null && _a !== void 0 ? _a : []) {
            const placeHolder = argument.description;
            let input;
            if (argument.enum) {
                const picked = await this.quickInputService.pick(argument.enum.map(enumItem => ({ label: enumItem })), { placeHolder, canPickMany: false });
                input = picked === null || picked === void 0 ? void 0 : picked.label;
            }
            else {
                input = await this.quickInputService.input({ placeHolder });
            }
            if (!input && !argument.isOptional) {
                return;
            }
            args.push(input !== null && input !== void 0 ? input : '');
        }
        return { variable, arg: args.join(ai_core_1.PromptText.VARIABLE_SEPARATOR_CHAR) };
    }
};
exports.ContextVariablePicker = ContextVariablePicker;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], ContextVariablePicker.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], ContextVariablePicker.prototype, "quickInputService", void 0);
exports.ContextVariablePicker = ContextVariablePicker = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContextVariablePicker);


/***/ }),

/***/ "../../node_modules/@theia/core/shared/markdown-it.js":
/*!************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/markdown-it.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! markdown-it */ "../../node_modules/markdown-it/index.js");


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-chat-ui_lib_browser_chat-tree-view_chat-view-tree-widget_js.js.map