/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.viewsupport.IndexedFilesCache;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class IndexedFilesLabelProvider
implements ILightweightLabelDecorator {
    private static final ImageDescriptor INDEXED = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.cdt.ui", (String)"$nl$/icons/ovr16/indexedFile.gif").get();

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IIndexFileLocation ifl = null;
        IProject project = null;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            project = file.getProject();
            try {
                if (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                    ifl = IndexLocationFactory.getWorkspaceIFL((IFile)file);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        } else if (element instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)element;
            ifl = IndexLocationFactory.getIFL((ITranslationUnit)tu);
            project = tu.getCProject().getProject();
        }
        if (ifl != null && this.isIndexed(project, ifl)) {
            decoration.addOverlay(INDEXED, 0);
        }
    }

    private boolean isIndexed(IProject project, IIndexFileLocation ifl) {
        if (project == null || ifl == null) {
            return false;
        }
        return IndexedFilesCache.getInstance().isIndexed(project, ifl);
    }
}

