/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.ICoreVariableContextInfo;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;

public class EnvironmentVariableManagerToolChain
extends EnvironmentVariableManager {
    private final IToolChain toolChain;
    private final ICConfigurationDescription cfgDescription;

    public EnvironmentVariableManagerToolChain(IToolChain toolchain) {
        this.toolChain = toolchain;
        IConfiguration cfg = this.toolChain.getParent();
        this.cfgDescription = cfg != null ? ManagedBuildManager.getDescriptionForConfiguration(cfg) : null;
    }

    public IEnvironmentContextInfo getContextInfo(Object level) {
        if (this.cfgDescription != null) {
            return super.getContextInfo(level);
        }
        return new ToolChainEnvironmentContextInfo(this.toolChain);
    }

    public ICoreVariableContextInfo getMacroContextInfoForContext(Object context) {
        if (this.cfgDescription != null) {
            return super.getMacroContextInfoForContext(context);
        }
        return new ToolChainCoreVariableContextInfo(this.toolChain);
    }

    public IEnvironmentVariable getVariable(String variableName, boolean resolveMacros) {
        return this.getVariable(variableName, this.cfgDescription, resolveMacros);
    }

    private class ToolChainCdtVariableSupplier
    implements ICdtVariableSupplier {
        private final IConfigurationEnvironmentVariableSupplier toolchainSupplier;

        private ToolChainCdtVariableSupplier(IToolChain toolChain) {
            this.toolchainSupplier = toolChain.getEnvironmentVariableSupplier();
        }

        public ICdtVariable getVariable(String macroName, IVariableContextInfo context) {
            if (this.toolchainSupplier == null) {
                return null;
            }
            IBuildEnvironmentVariable var = this.toolchainSupplier.getVariable(macroName, null, ManagedBuildManager.getEnvironmentVariableProvider());
            return CdtVariableManager.fEnvironmentMacroSupplier.createBuildMacro((IEnvironmentVariable)var);
        }

        public ICdtVariable[] getVariables(IVariableContextInfo context) {
            if (this.toolchainSupplier == null) {
                return null;
            }
            IBuildEnvironmentVariable[] vars = this.toolchainSupplier.getVariables(null, ManagedBuildManager.getEnvironmentVariableProvider());
            if (vars != null) {
                ICdtVariable[] cdtVars = new ICdtVariable[vars.length];
                int i = 0;
                while (i < vars.length) {
                    cdtVars[i] = CdtVariableManager.fEnvironmentMacroSupplier.createBuildMacro((IEnvironmentVariable)vars[i]);
                    ++i;
                }
            }
            return null;
        }
    }

    private final class ToolChainCoreVariableContextInfo
    implements ICoreVariableContextInfo {
        private final ToolChainCdtVariableSupplier fToolChainSupplier;

        private ToolChainCoreVariableContextInfo(IToolChain toolChain) {
            this.fToolChainSupplier = new ToolChainCdtVariableSupplier(toolChain);
        }

        public ICdtVariableSupplier[] getSuppliers() {
            return new ICdtVariableSupplier[]{CdtVariableManager.fUserDefinedMacroSupplier, this.fToolChainSupplier, CdtVariableManager.fEnvironmentMacroSupplier, CdtVariableManager.fCdtMacroSupplier, CdtVariableManager.fEclipseVariablesMacroSupplier};
        }

        public IVariableContextInfo getNext() {
            return null;
        }

        public int getContextType() {
            return 5;
        }

        public Object getContextData() {
            return null;
        }
    }

    private class ToolChainEnvironmentContextInfo
    implements IEnvironmentContextInfo {
        private final ICoreEnvironmentVariableSupplier fToolchainSupplier;

        private ToolChainEnvironmentContextInfo(IToolChain toolChain) {
            this.fToolchainSupplier = new ToolChainEnvironmentVariableSupplier(toolChain);
        }

        public IEnvironmentContextInfo getNext() {
            return null;
        }

        public ICoreEnvironmentVariableSupplier[] getSuppliers() {
            return new ICoreEnvironmentVariableSupplier[]{fUserSupplier, this.fToolchainSupplier, fEclipseSupplier};
        }

        public Object getContext() {
            return null;
        }
    }

    private class ToolChainEnvironmentVariableSupplier
    implements ICoreEnvironmentVariableSupplier {
        private final IEnvironmentVariableProvider environmentVariableProvider = EnvironmentVariableProvider.getDefault();
        private final IConfigurationEnvironmentVariableSupplier toolchainSupplier;

        private ToolChainEnvironmentVariableSupplier(IToolChain toolChain) {
            this.toolchainSupplier = toolChain.getEnvironmentVariableSupplier();
        }

        public IEnvironmentVariable getVariable(String name, Object context) {
            if (this.toolchainSupplier == null) {
                return null;
            }
            return this.toolchainSupplier.getVariable(name, null, this.environmentVariableProvider);
        }

        public IEnvironmentVariable[] getVariables(Object context) {
            if (this.toolchainSupplier == null) {
                return new IEnvironmentVariable[0];
            }
            return this.toolchainSupplier.getVariables(null, this.environmentVariableProvider);
        }

        public boolean appendEnvironment(Object context) {
            return true;
        }
    }
}

