/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class RepositoryTransactionHelper
implements AutoCloseable {
    private final RepositoryTracker metadataRepositoryTracker;
    private final RepositoryTracker artifactRepositoryTracker;

    public RepositoryTransactionHelper(IMetadataRepositoryManager metadataRepositoryManager, IArtifactRepositoryManager artifactRepositoryManager) {
        this.metadataRepositoryTracker = metadataRepositoryManager == null ? null : new RepositoryTracker((IRepositoryManager<?>)metadataRepositoryManager);
        this.artifactRepositoryTracker = artifactRepositoryManager == null ? null : new RepositoryTracker((IRepositoryManager<?>)artifactRepositoryManager);
    }

    public void init() {
        if (this.metadataRepositoryTracker != null) {
            this.metadataRepositoryTracker.init();
        }
        if (this.artifactRepositoryTracker != null) {
            this.artifactRepositoryTracker.init();
        }
    }

    public void addRepository(URI uri) {
        if (this.artifactRepositoryTracker != null) {
            this.artifactRepositoryTracker.addRepository(uri);
        }
        if (this.metadataRepositoryTracker != null) {
            this.metadataRepositoryTracker.addRepository(uri);
        }
    }

    public void resetRepository(URI uri) {
        if (this.metadataRepositoryTracker != null) {
            this.metadataRepositoryTracker.resetRepository(uri);
        }
        if (this.artifactRepositoryTracker != null) {
            this.artifactRepositoryTracker.resetRepository(uri);
        }
    }

    public void resetAll() {
        if (this.metadataRepositoryTracker != null) {
            this.metadataRepositoryTracker.resetAll();
        }
        if (this.artifactRepositoryTracker != null) {
            this.artifactRepositoryTracker.resetAll();
        }
    }

    @Override
    public void close() {
        this.resetAll();
    }

    private static enum CleanupAction {
        REMOVE,
        DISABLE;

    }

    private static class RepositoryTracker
    implements AutoCloseable {
        private static final int ENABLED_STATE_FLAGS = 18;
        private static final int DISABLED_STATE_FLAGS = 26;
        final IRepositoryManager<?> manager;
        final Map<URI, CleanupAction> cleanupActions;
        final Map<URI, Integer> initialState;

        RepositoryTracker(IRepositoryManager<?> manager) {
            this.manager = manager;
            this.initialState = new HashMap<URI, Integer>();
            this.cleanupActions = new LinkedHashMap<URI, CleanupAction>();
            this.init();
        }

        public void init() {
            URI uri;
            if (!this.cleanupActions.isEmpty()) {
                throw new IllegalStateException();
            }
            this.initialState.clear();
            URI[] enabledRemoteRepos = this.manager.getKnownRepositories(18);
            URI[] disabledRemoteRepos = this.manager.getKnownRepositories(26);
            URI[] uRIArray = enabledRemoteRepos;
            int n = enabledRemoteRepos.length;
            int n2 = 0;
            while (n2 < n) {
                uri = uRIArray[n2];
                this.initialState.put(uri, 18);
                ++n2;
            }
            uRIArray = disabledRemoteRepos;
            n = disabledRemoteRepos.length;
            n2 = 0;
            while (n2 < n) {
                uri = uRIArray[n2];
                this.initialState.put(uri, 26);
                ++n2;
            }
        }

        public void addRepository(URI uri) {
            this.manager.addRepository(uri);
            this.mergeAction(uri, this.getCleanupAction(uri));
        }

        private void mergeAction(URI uri, CleanupAction cleanupAction) {
            if (cleanupAction != null) {
                this.cleanupActions.put(uri, cleanupAction);
            }
        }

        private CleanupAction getCleanupAction(URI uri) {
            Integer state = this.initialState.get(uri);
            if (state == null) {
                return CleanupAction.REMOVE;
            }
            if ((state & 8) != 0) {
                return CleanupAction.DISABLE;
            }
            return null;
        }

        public void resetRepository(URI uri) {
            CleanupAction action = this.cleanupActions.remove(uri);
            this.doResetRepository(uri, action);
        }

        private void doResetRepository(URI uri, CleanupAction action) {
            if (action == null) {
                return;
            }
            switch (action) {
                case REMOVE: {
                    this.manager.removeRepository(uri);
                    break;
                }
                case DISABLE: {
                    this.manager.setEnabled(uri, false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(action.name());
                }
            }
        }

        public void resetAll() {
            for (Map.Entry<URI, CleanupAction> entry : this.cleanupActions.entrySet()) {
                this.doResetRepository(entry.getKey(), entry.getValue());
            }
            this.cleanupActions.clear();
        }

        @Override
        public void close() {
            this.resetAll();
        }
    }
}

