/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.textile.internal.Textile;

public class CommentBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("###\\.(\\.)?\\s+(.*)");
    private boolean extended;
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            offset = this.matcher.start(2);
            boolean bl = this.extended = this.matcher.group(1) != null;
        }
        if (this.markupLanguage.isEmptyLine(line) && !this.extended) {
            this.setClosed(true);
            return 0;
        }
        if (this.extended && Textile.explicitBlockBegins(line, offset)) {
            this.setClosed(true);
            return offset;
        }
        ++this.blockLineCount;
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

