/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.repository.internal;

import java.io.File;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.repository.RepositoryManagerException;
import org.apache.maven.shared.transfer.repository.internal.Invoker;
import org.apache.maven.shared.transfer.repository.internal.MavenRepositoryManager;
import org.sonatype.aether.RepositoryCache;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.util.DefaultRepositoryCache;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.metadata.DefaultMetadata;

class Maven30RepositoryManager
implements MavenRepositoryManager {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    Maven30RepositoryManager(RepositorySystem repositorySystem, RepositorySystemSession session) {
        this.repositorySystem = repositorySystem;
        this.session = session;
    }

    @Override
    public String getPathForLocalArtifact(org.apache.maven.artifact.Artifact mavenArtifact) {
        Artifact aetherArtifact;
        try {
            aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.session.getLocalRepositoryManager().getPathForLocalArtifact(aetherArtifact);
    }

    @Override
    public String getPathForLocalArtifact(ArtifactCoordinate coordinate) {
        Artifact aetherArtifact = this.toArtifact(coordinate);
        return this.session.getLocalRepositoryManager().getPathForLocalArtifact(aetherArtifact);
    }

    @Override
    public String getPathForLocalMetadata(ArtifactMetadata metadata) {
        DefaultMetadata aetherMetadata = new DefaultMetadata(metadata.getGroupId(), metadata.storedInGroupDirectory() ? null : metadata.getArtifactId(), metadata.storedInArtifactVersionDirectory() ? metadata.getBaseVersion() : null, "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        return this.session.getLocalRepositoryManager().getPathForLocalMetadata((Metadata)aetherMetadata);
    }

    @Override
    public ProjectBuildingRequest setLocalRepositoryBasedir(ProjectBuildingRequest buildingRequest, File basedir) {
        RepositorySystemSession session;
        DefaultProjectBuildingRequest newRequest = new DefaultProjectBuildingRequest(buildingRequest);
        try {
            session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
        newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        String repositoryType = this.resolveRepositoryType(session.getLocalRepository());
        LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager(new LocalRepository(basedir, repositoryType));
        newSession.setLocalRepositoryManager(localRepositoryManager);
        try {
            Invoker.invoke(newRequest, "setRepositorySession", RepositorySystemSession.class, (Object)newSession);
        }
        catch (RepositoryManagerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return newRequest;
    }

    @Override
    public File getLocalRepositoryBasedir() {
        return this.session.getLocalRepository().getBasedir();
    }

    protected String resolveRepositoryType(LocalRepository localRepository) {
        return localRepository.getContentType();
    }

    protected Artifact toArtifact(ArtifactCoordinate coordinate) {
        if (coordinate == null) {
            return null;
        }
        DefaultArtifact result = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return result;
    }
}

