/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.team;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForWorkspace;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.team.CategoryFileInfo;

public class SnippetDefinitionResourceChangeListener
implements IResourceChangeListener {
    public static final String SNIPPET_DEFINITION_EXTENSION = "snippet";
    protected List fCategoryList = null;
    protected LibraryDefinitionVisitor fVisitor = null;

    public SnippetDefinitionResourceChangeListener() {
        this.initialize();
    }

    protected void categoryAdded(CategoryFileInfo info) {
        this.categoryChanged(info);
    }

    protected void categoryChanged(CategoryFileInfo info) {
        if (info.getCategory() == null) {
            return;
        }
        int oldIndex = -1;
        List categories = SnippetManager.getInstance().getPaletteRoot().getChildren();
        int i = 0;
        while (i < categories.size()) {
            if (((SnippetPaletteDrawer)categories.get(i)).getId().equals(((SnippetPaletteDrawer)info.getCategory()).getId())) {
                SnippetManager.getInstance().getPaletteRoot().remove((PaletteEntry)categories.get(i));
                oldIndex = i;
                break;
            }
            ++i;
        }
        SnippetManager.getInstance().getPaletteRoot().remove((PaletteEntry)info.getCategory());
        if (oldIndex >= 0) {
            SnippetManager.getInstance().getPaletteRoot().add(oldIndex, (PaletteEntry)((PaletteDrawer)info.getCategory()));
        } else {
            SnippetManager.getInstance().getPaletteRoot().add((PaletteEntry)((PaletteDrawer)info.getCategory()));
        }
    }

    protected void categoryRemoved(CategoryFileInfo info) {
        if (info.getCategory() == null) {
            return;
        }
        SnippetManager.getInstance().getPaletteRoot().remove((PaletteEntry)info.getCategory());
    }

    protected CategoryFileInfo createCategoryInfo(IFile file) {
        SnippetDefinitions defs = ModelFactoryForWorkspace.getWorkspaceInstance().loadFrom(file);
        ISnippetCategory category = null;
        if (defs.getCategories().size() > 0) {
            category = defs.getCategories().get(0);
        }
        CategoryFileInfo result = new CategoryFileInfo(this, file, category);
        if (category != null) {
            ((SnippetPaletteDrawer)category).setSourceDescriptor(result);
        }
        return result;
    }

    protected List findCategories(IContainer container) throws CoreException {
        ArrayList list = new ArrayList(1);
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return list;
        }
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(list);
        try {
            container.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException coreException) {}
        Iterator iter = list.iterator();
        ArrayList<CategoryFileInfo> infos = new ArrayList<CategoryFileInfo>(list.size());
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            infos.add(this.createCategoryInfo(file));
        }
        return infos;
    }

    protected List getAllCategories() throws CoreException {
        if (this.fCategoryList == null) {
            this.fCategoryList = new ArrayList(0);
            List categories = this.findCategories((IContainer)this.getWorkspaceRoot());
            this.fCategoryList.addAll(categories);
        }
        return this.fCategoryList;
    }

    public List getCategoryList() {
        if (this.fCategoryList == null) {
            this.fCategoryList = new ArrayList();
        }
        return this.fCategoryList;
    }

    protected List getCategoryRecords(IProject project) throws CoreException {
        Iterator iter = this.getAllCategories().iterator();
        ArrayList<CategoryFileInfo> infos = new ArrayList<CategoryFileInfo>();
        while (iter.hasNext()) {
            CategoryFileInfo info = (CategoryFileInfo)iter.next();
            IFile file = info.getFile();
            if (file == null || !file.getProject().equals((Object)project)) continue;
            infos.add(info);
        }
        return infos;
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    protected void initialize() {
        IProject[] projects = this.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                try {
                    this.projectOpened(projects[i]);
                }
                catch (CoreException coreException) {}
            } else {
                try {
                    this.projectClosed(projects[i]);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    protected void projectClosed(IProject project) throws CoreException {
        List infos = this.getCategoryRecords(project);
        if (!infos.isEmpty()) {
            Iterator iterator = infos.iterator();
            while (iterator.hasNext()) {
                this.categoryRemoved((CategoryFileInfo)iterator.next());
            }
        }
    }

    protected void projectOpened(IProject project) throws CoreException {
        List configs = this.getCategoryRecords(project);
        if (!configs.isEmpty()) {
            Iterator iterator = configs.iterator();
            while (iterator.hasNext()) {
                this.categoryAdded((CategoryFileInfo)iterator.next());
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                if (this.fVisitor == null) {
                    this.fVisitor = new LibraryDefinitionVisitor();
                }
                delta.accept((IResourceDeltaVisitor)this.fVisitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    protected class LibraryDefinitionVisitor
    implements IResourceDeltaVisitor {
        protected LibraryDefinitionVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0) {
                if (delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    try {
                        if (project.isOpen()) {
                            SnippetDefinitionResourceChangeListener.this.projectOpened(project);
                        } else {
                            SnippetDefinitionResourceChangeListener.this.projectClosed(project);
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                return false;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (SnippetDefinitionResourceChangeListener.SNIPPET_DEFINITION_EXTENSION.equals(file.getFileExtension())) {
                    IPath categoryPath = file.getLocation();
                    if (categoryPath == null) {
                        IPath workspaceRelativePath = delta.getFullPath();
                        categoryPath = SnippetDefinitionResourceChangeListener.this.getWorkspaceRoot().getLocation().append(workspaceRelativePath);
                    }
                    CategoryFileInfo handle = SnippetDefinitionResourceChangeListener.this.createCategoryInfo(file);
                    switch (delta.getKind()) {
                        case 1: {
                            SnippetDefinitionResourceChangeListener.this.categoryAdded(handle);
                            break;
                        }
                        case 4: {
                            SnippetDefinitionResourceChangeListener.this.categoryChanged(handle);
                            break;
                        }
                        case 2: {
                            SnippetDefinitionResourceChangeListener.this.categoryRemoved(handle);
                        }
                    }
                }
                return false;
            }
            if (resource instanceof IContainer) {
                return true;
            }
            return true;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected List fList;

        protected ResourceProxyVisitor(List list) {
            this.fList = list;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1) {
                if (SnippetDefinitionResourceChangeListener.SNIPPET_DEFINITION_EXTENSION.equalsIgnoreCase(proxy.requestFullPath().getFileExtension())) {
                    this.fList.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

